/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPPONumberGenerator;
import com.kingdee.eas.mm.planning.app.mrp.MRPStep;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Locale;

public class MRPMergePlanOrder
extends MRPStep {
    @Override
    protected String getStepDesc(MRPCalcParam runParam) {
        return ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"34_MRPMergePlanOrder", (Locale)runParam.getCtx(false).getLocale());
    }

    @Override
    protected Object innerExecute(MRPCalcParam runParam) throws EASBizException, BOSException {
        Context ctx = runParam.getCtx();
        String runLogId = runParam.getRunLogID();
        String tempPlanOrderTable = null;
        String tempPlanOrderEntryTable = null;
        try {
            this.updatePlanOrderStatus(ctx, runLogId);
            tempPlanOrderTable = this.createTempPlanOrderTable(ctx);
            this.copyPlanOrder(ctx, runLogId, tempPlanOrderTable);
            tempPlanOrderEntryTable = this.createTempPlanOrderEntryTable(ctx);
            this.copyPlanOrderEntry(ctx, runLogId, tempPlanOrderEntryTable, tempPlanOrderTable);
            this.releaseTempTable(ctx, tempPlanOrderTable);
            this.releaseTempTable(ctx, tempPlanOrderEntryTable);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.releaseTempTable(ctx, tempPlanOrderTable);
                this.releaseTempTable(ctx, tempPlanOrderEntryTable);
                throw throwable;
            }
        }
        return null;
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return true;
    }

    private void updatePlanOrderStatus(Context ctx, String runLogId) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_mm_PlannedOrder t set FBaseStatus=7 ");
        sql.append("where Fcalcid='").append(runLogId).append("' ");
        sql.append("and fprojectid is not null and ftrackid is not null ");
        sql.append(" and exists( select 1 from t_bd_materialplan mp where mp.fmaterialid = t.fmaterialid and ");
        sql.append(" mp.forgunit = t.fstorageorgunitid  ");
        sql.append(" and mp.FManufactureStrategyID='").append("GE2FIa4GQ6uhdx0RDGuibtg0uEU=");
        sql.append("' and mp.FMergeRule=10521 )");
        SQLUtils.execute((Context)ctx, (String)sql.toString());
    }

    private String createTempPlanOrderTable(Context ctx) throws Exception {
        StringBuffer createTableSQL = new StringBuffer();
        createTableSQL.append(" CREATE TABLE TEMPPLANORDER (");
        createTableSQL.append(" FPlanOrderID varchar(44),");
        createTableSQL.append(" FNewPlanOrderID varchar(44),");
        createTableSQL.append(" FNumber nvarchar(80),");
        createTableSQL.append(" FQty NUMERIC(21,8) not null default 0,");
        createTableSQL.append(" FBaseQty NUMERIC(21,8) not null default 0)");
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        return pool.createTempTable(createTableSQL.toString());
    }

    private String createTempPlanOrderEntryTable(Context ctx) throws Exception {
        StringBuffer createTableSQL = new StringBuffer();
        createTableSQL.append(" CREATE TABLE TEMPPLANORDERENTRY (");
        createTableSQL.append(" FParentID varchar(44),");
        createTableSQL.append(" FPlanOrderEntryID varchar(44),");
        createTableSQL.append(" FNewPlanOrderEntryID varchar(44),");
        createTableSQL.append(" FDemandQty NUMERIC(21,8) not null default 0,");
        createTableSQL.append(" FBaseDemandQty NUMERIC(21,8) not null default 0)");
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        return pool.createTempTable(createTableSQL.toString());
    }

    private void releaseTempTable(Context ctx, String tableName) {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        pool.releaseTable(tableName);
    }

    private void copyPlanOrder(Context ctx, String runLogId, String tempPoTableName) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(tempPoTableName).append(" ");
        sql.append("(FPlanOrderID, FNewPlanOrderID, FQty, FBaseQty) ");
        sql.append("select ");
        sql.append("po.fid, ");
        sql.append("newbosid('B844D41F'), ");
        sql.append("tmp.sumqty, ");
        sql.append("tmp.sumbaseqty ");
        sql.append("from t_mm_plannedorder po ");
        sql.append("inner join t_mm_trackNumber track on po.ftrackid=track.fid ");
        sql.append("inner join ");
        sql.append("  (select ");
        sql.append("  t.fmaterialid materialid, ");
        sql.append("  t.fprojectid projectid, ");
        sql.append("  sum(t.fqty) sumQty, ");
        sql.append("  sum(t.fbaseqty) sumbaseQty, ");
        sql.append("  min(trackNumber.fnumber) trackNo");
        sql.append("  from t_mm_plannedorder T ");
        sql.append("  left outer  join t_mm_tracknumber trackNumber on T.FTrackid=trackNumber.fid");
        sql.append("  inner join t_bd_materialplan mp on t.fstorageorgunitid=mp.forgunit ");
        sql.append("  and t.fmaterialid=mp.fmaterialid and mp.FManufactureStrategyID='").append("GE2FIa4GQ6uhdx0RDGuibtg0uEU=");
        sql.append("' and mp.FMergeRule=10521 ");
        sql.append("  where t.fcalcid='").append(runLogId);
        sql.append("' and t.fprojectid is not null and t.ftrackid is not null ");
        sql.append("  group by t.fmaterialid, t.fprojectid as tmp) ");
        sql.append("on po.fmaterialid=tmp.materialid and po.fprojectid=tmp.projectid ");
        sql.append("and track.fnumber=tmp.trackNo ");
        sql.append("where po.fcalcid='").append(runLogId).append("' ");
        SQLUtils.execute((Context)ctx, (String)sql.toString());
        String poNumber = null;
        sql.setLength(0);
        sql.append("select FPlanOrderID from ").append(tempPoTableName);
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql.toString());
        while (rs.next()) {
            poNumber = new MRPPONumberGenerator(this.runParam).getNumber();
            sql.setLength(0);
            sql.append("update ").append(tempPoTableName).append(" set Fnumber='").append(poNumber);
            sql.append("' where FPlanOrderID='").append(rs.getString("FPlanOrderID")).append("' ");
            SQLUtils.execute((Context)ctx, (String)sql.toString());
        }
        sql.setLength(0);
        sql.append("insert into t_mm_PlannedOrder(FID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,");
        sql.append("FControlUnitID,FNumber,FBizDate,FHandlerID,FDescription,FHasEffected,FAuditorID,FSourceBillID,");
        sql.append("FSourceFunction,FAuditTime,FBaseStatus,FBizTypeID,FSourceBillTypeID,FBillTypeID,FYear,FPeriod,");
        sql.append("FModifierID,FModificationTime,FMaterialID,FOrderType,FStorageOrgUnitID,FProductionOrgUnitID,");
        sql.append("FStartDate,FEndDate,FAvilableDate,FQty,FBaseQty,FTotalReleaseQty,FBaseTotalReleaseQty,");
        sql.append("FScheduleQty,FBaseScheduleQty,FUnitID,FProductUnitID,FBomInterID,FBomNumber,FOrderMatLock,");
        sql.append("FSchemeID,FCalcID,FSourceType,FSourceOrderID,FSourceEntryID,FRelatingOrderType,FRelatingOrderID,");
        sql.append("FRelatingEntryID,FPlanner,FSourceNumber,FRelatingOrderNum,FRelatingEntrySeq,FProjectId,FTrackId,");
        sql.append("FAdminOrgUnitID,FIsAfreshExtend) ");
        sql.append("select tmp.FNewPlanOrderID,T.FCreatorID,T.FCreateTime,T.FLastUpdateUserID,T.FLastUpdateTime,");
        sql.append("T.FControlUnitID,tmp.FNumber,T.FBizDate,T.FHandlerID,T.FDescription,T.FHasEffected,T.FAuditorID,T.FSourceBillID,");
        sql.append("T.FSourceFunction,T.FAuditTime,2,T.FBizTypeID,T.FSourceBillTypeID,T.FBillTypeID,T.FYear,T.FPeriod,");
        sql.append("T.FModifierID,T.FModificationTime,T.FMaterialID,T.FOrderType,T.FStorageOrgUnitID,T.FProductionOrgUnitID,");
        sql.append("T.FStartDate,T.FEndDate,T.FAvilableDate,tmp.Fqty,tmp.Fbaseqty,T.FTotalReleaseQty,T.FBaseTotalReleaseQty,");
        sql.append("T.FScheduleQty,T.FBaseScheduleQty,T.FUnitID,T.FProductUnitID,T.FBomInterID,T.FBomNumber,T.FOrderMatLock,");
        sql.append("T.FSchemeID,T.FCalcID,T.FSourceType,T.FSourceOrderID,T.FSourceEntryID,T.FRelatingOrderType,T.FRelatingOrderID,");
        sql.append("T.FRelatingEntryID,T.FPlanner,T.FSourceNumber,T.FRelatingOrderNum,T.FRelatingEntrySeq,T.FProjectId,T.FTrackId,");
        sql.append("T.FAdminOrgUnitID,T.FIsAfreshExtend ");
        sql.append("from ").append(tempPoTableName).append(" tmp ");
        sql.append("inner join t_mm_PlannedOrder T on tmp.FPlanOrderID=T.fid ");
        SQLUtils.execute((Context)ctx, (String)sql.toString());
    }

    private void copyPlanOrderEntry(Context ctx, String runLogId, String tempEntryTableName, String tempPoTableName) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(tempEntryTableName).append(" ");
        sql.append("(FParentID, FPlanOrderEntryID, FNewPlanOrderEntryID, FDemandQty, FBaseDemandQty) ");
        sql.append("select ");
        sql.append("po.FNewPlanOrderID, ");
        sql.append("poentry.fid, ");
        sql.append("newbosid('CE85FF93'), ");
        sql.append("tmp.demandqty, ");
        sql.append("tmp.basedemandqty ");
        sql.append("from t_mm_plannedorderentry poentry ");
        sql.append("inner join ").append(tempPoTableName).append(" po ");
        sql.append("on poentry.FParentId=po.FPlanOrderId ");
        sql.append("inner join ");
        sql.append("  (select ");
        sql.append("   entry.fmaterialid materialid, ");
        sql.append("  sum(entry.fdemandqty) demandqty, ");
        sql.append("  sum(entry.fbasedemandqty) basedemandqty ");
        sql.append("  from t_mm_plannedorderentry entry ");
        sql.append("  inner join t_mm_plannedorder T on entry.fparentid=T.fid");
        sql.append("  where t.fcalcid='").append(runLogId);
        sql.append("' and t.fprojectid is not null and t.ftrackid is not null ");
        sql.append("   group by t.fmaterialid, t.fprojectid, entry.fmaterialid as tmp) ");
        sql.append(" on poentry.fmaterialid=tmp.materialid ");
        sql.append("where poentry.FParentId in ");
        sql.append("(select FPlanOrderId from ").append(tempPoTableName).append(") ");
        SQLUtils.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("insert into t_mm_PlannedOrderentry(FID,FParentID,FMaterialID,FUnitID,FBaseUnitID,");
        sql.append("FDemandQty,FBaseDemandQty,FReqDate,FQuotaControl,FIssInHightLimit,FIssInLowLimit,");
        sql.append("FBackFlush,FValidate,FStorageOrgUnitID,FReasonCodeID,FRemark,FAssistUnitID,");
        sql.append("FSourceBillTypeID,FAssicateQty,FBaseStatus,FAssCoefficient,FSourceBillEntrySeq,");
        sql.append("FSourceBillEntryID,FSourceBillNumber,FSourceBillID,FAssistPropertyID,FAssociateQty,");
        sql.append("FReleaseQty,FReleaseBaseQty,FBlkSize,FSpecifiedLength,FNewnetWeight,FMaterialSubsID) ");
        sql.append("select tmp.FNewPlanOrderEntryID,tmp.FParentID,T.FMaterialID,T.FUnitID,T.FBaseUnitID,");
        sql.append("tmp.FDemandQty,tmp.FBaseDemandQty,T.FReqDate,T.FQuotaControl,T.FIssInHightLimit,T.FIssInLowLimit,");
        sql.append("T.FBackFlush,T.FValidate,T.FStorageOrgUnitID,T.FReasonCodeID,T.FRemark,T.FAssistUnitID,");
        sql.append("T.FSourceBillTypeID,T.FAssicateQty,T.FBaseStatus,T.FAssCoefficient,T.FSourceBillEntrySeq,");
        sql.append("T.FSourceBillEntryID,T.FSourceBillNumber,T.FSourceBillID,T.FAssistPropertyID,T.FAssociateQty,");
        sql.append("T.FReleaseQty,T.FReleaseBaseQty,T.FBlkSize,T.FSpecifiedLength,T.FNewnetWeight,T.FMaterialSubsID ");
        sql.append("from ").append(tempEntryTableName).append(" tmp ");
        sql.append("inner join t_mm_PlannedOrderentry T on tmp.FPlanOrderEntryID=T.fid ");
        SQLUtils.execute((Context)ctx, (String)sql.toString());
    }
}

