/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.IProductTransactionType;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeCollection;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeFactory;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeInfo;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.planning.IMRPCalcFacade;
import com.kingdee.eas.mm.planning.IMRPRunLog;
import com.kingdee.eas.mm.planning.MRPCalcFacadeFactory;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.MRPRunExceptionCollection;
import com.kingdee.eas.mm.planning.MRPRunExceptionFactory;
import com.kingdee.eas.mm.planning.MRPRunLogFactory;
import com.kingdee.eas.mm.planning.MRPRunLogInfo;
import com.kingdee.eas.mm.planning.MRPRunLogStatusEnum;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalendarFactory;
import com.kingdee.eas.mm.planning.app.mrp.MRPDate;
import com.kingdee.eas.mm.planning.app.mrp.MRPDynamicTableManager;
import com.kingdee.eas.mm.planning.app.mrp.MRPExceptionUtil;
import com.kingdee.eas.mm.planning.app.mrp.MRPResource;
import com.kingdee.eas.mm.planning.app.mrp.MRPRunningTablesInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPStep;
import com.kingdee.eas.mm.planning.app.mrp.MRPSubstituteHelper;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class MRPRunStart
extends MRPStep {
    @Override
    protected Object innerExecute(MRPCalcParam runParam) throws EASBizException, BOSException {
        runParam.setRunStartTime(runParam.getRunLogInfo().getPlanDate());
        this.saveLog();
        this.adjustPlanDate();
        this.setMRPTableName();
        this.setMRPException();
        this.setMRPRuntimeParams();
        this.setMRPTrack();
        this.setDefaultTransType();
        this.initMRPBillParam();
        this.setMRPPlanOrderTable();
        this.setAdditionalInfo();
        this.checkBom();
        return runParam;
    }

    private void setMRPTrack() throws BOSException, MRPException {
        if (this.runParam.getRunLogInfo() == null || this.runParam.getRunLogInfo().getStorageOrgUnit() == null || this.runParam.getRunLogInfo().getStorageOrgUnit().getCU() == null) {
            throw new MRPException(MRPException.PARAM_ERROR);
        }
        String cuId = this.runParam.getRunLogInfo().getStorageOrgUnit().getCU().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT t1.fid fid,t1.fnumber fnumber FROM  T_MM_TRACKNUMBER t1 left join T_BD_DataBaseDAssign t2 ").append(" on t1.fid=t2.fdatabasedid").append(" WHERE t1.FdefaultTraceNumberFlag=1 ").append(" and (t1.FcontrolUnitId=?  or t2.fassigncuid=?)");
        IRowSet rs = SQLUtils.executeQuery((Context)this.runParam.getCtx(), (String)sql.toString(), (Object[])new Object[]{cuId, cuId});
        try {
            if (rs.next()) {
                String trackId = rs.getString("fid");
                String trackNumber = rs.getString("fnumber");
                if (trackId != null && trackNumber != null) {
                    this.runParam.setTrackID(trackId);
                    this.runParam.setTrackNumber(trackNumber);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void setMRPRuntimeParams() throws BOSException, EASBizException {
        IMRPCalcFacade calcFacade = MRPCalcFacadeFactory.getLocalInstance(this.runParam.getCtx());
        this.runParam.setAdvanceType(calcFacade.getParamValueOfPlanAdjust(this.runParam.getStorageOrgUnitID()));
        this.runParam.setSubFisrt(calcFacade.getParamValueOfPropSeq(this.runParam.getStorageOrgUnitID()));
        this.runParam.setModifyOrder(calcFacade.getParamValueOfSubAltPlanOrder(this.runParam.getStorageOrgUnitID()));
    }

    private void setMRPException() throws BOSException, EASBizException {
        MRPRunExceptionCollection collection = null;
        collection = MRPRunExceptionFactory.getLocalInstance(this.runParam.getCtx()).getSetterByStorageOrgID(this.runParam.getStorageOrgUnitID());
        int size = collection.size();
        HashMap<String, Boolean> exception = new HashMap<String, Boolean>();
        for (int i = 0; i < size; ++i) {
            exception.put(collection.get(i).getNumber(), collection.get(i).isIsShow());
        }
        MRPExceptionUtil exceptionUtil = new MRPExceptionUtil(collection);
        this.runParam.setException(exception);
        this.runParam.setExceptionUtil(exceptionUtil);
    }

    private void setMRPTableName() throws BOSException, EASBizException {
        List runningTableList = MRPDynamicTableManager.getTableNameForRunStrategy(this.runParam);
        String materialTableName = ((MRPRunningTablesInfo)runningTableList.get(0)).getTableName();
        String detailTableName = ((MRPRunningTablesInfo)runningTableList.get(1)).getTableName();
        this.runParam.setMaterialTableName(materialTableName);
        this.runParam.setMrpCalcDetailTableName(detailTableName);
    }

    private void setDefaultTransType() throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.runParam.getStorageOrgUnitID()));
        filterInfo.getFilterItems().add(new FilterItemInfo("bizType.id", (Object)"vGXRx5fFSsCYz9Zv7CzzgyQHQ1w="));
        filterInfo.getFilterItems().add(new FilterItemInfo("isDefault", (Object)Boolean.TRUE));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(20)));
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        viewInfo.setSelector(sic);
        IProductTransactionType ptType = ProductTransactionTypeFactory.getLocalInstance((Context)this.runParam.getCtx());
        ProductTransactionTypeCollection prodCol = ptType.getProductTransactionTypeCollection(viewInfo);
        if (prodCol.size() > 0) {
            ProductTransactionTypeInfo type = prodCol.get(0);
            this.runParam.setProductTranTypeID(type.getId().toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void adjustPlanDate() throws EASBizException, BOSException {
        Calendar theDate = MRPUtil.createCalendar();
        theDate.setTime(this.runParam.getRunLogInfo().getPlanDate());
        theDate.set(11, 0);
        theDate.set(12, 0);
        theDate.set(13, 0);
        theDate.set(14, 0);
        MRPDate planDate = new MRPDate();
        int workDaySeqID = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select t0.fid,t0.fworkDateSeq,t0.fweekSeq,").append("\r\n").append("t0.fmonthSeq,t0.FNextWorkDaySeq,t0.FPreWorkDaySeq ").append("\r\n").append("from t_mm_factorycalendarentry t0 ,t_mm_factorycalendar t1 ").append("\r\n").append("where t0.fparentid = t1.fid ").append("\r\n").append("and t0.fworkdate = to_date('").append(MRPUtil.dateToString(theDate.getTime(), "yyyy-MM-dd")).append("')").append("\r\n").append("and t1.fstorageorgunitid = ? and t1.FIsDefault = 1 ");
        IRowSet rs = SQLUtils.executeQuery((Context)this.runParam.getCtx(), (String)sql.toString(), (Object[])new Object[]{this.runParam.getStorageOrgUnitID()});
        try {
            if (!rs.next()) throw new MRPException(MRPException.FACTORYCALENDAR_ERROR);
            workDaySeqID = rs.getInt("fworkDateSeq");
            if (workDaySeqID == 0) {
                workDaySeqID = rs.getInt("FNextWorkDaySeq");
                sql.setLength(0);
                sql.append("select t0.fid,t0.fworkdate,t0.fweekSeq,t0.fmonthSeq ").append("\r\n").append("from t_mm_factorycalendarentry t0 ,t_mm_factorycalendar t1 ").append("\r\n").append("where t0.fparentid = t1.fid ").append("\r\n").append("and t0.fworkDateSeq = ? ").append("\r\n").append("and t1.fstorageorgunitid = ? and t1.FIsDefault = 1 ");
                rs = SQLUtils.executeQuery((Context)this.runParam.getCtx(), (String)sql.toString(), (Object[])new Object[]{new Integer(workDaySeqID), this.runParam.getStorageOrgUnitID()});
                if (!rs.next()) throw new MRPException(MRPException.FACTORYCALENDAR_ERROR);
                rs.getDate("fworkdate", theDate);
                planDate.setCalendarID(rs.getString("fid"));
                planDate.setDate(theDate);
                planDate.setWorkDaySeqID(workDaySeqID);
                planDate.setPeriod(workDaySeqID);
                planDate.setWeekSeqID(rs.getInt("fweekSeq"));
                planDate.setMonthSeqID(rs.getInt("fmonthSeq"));
            } else {
                planDate.setCalendarID(rs.getString("fid"));
                planDate.setDate(theDate);
                planDate.setWorkDaySeqID(workDaySeqID);
                planDate.setPeriod(workDaySeqID);
                planDate.setWeekSeqID(rs.getInt("fweekSeq"));
                planDate.setMonthSeqID(rs.getInt("fmonthSeq"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        this.runParam.setPlanDate(planDate);
    }

    private void saveLog() throws EASBizException, BOSException {
        IMRPRunLog mrpRunLog = MRPRunLogFactory.getLocalInstance(this.runParam.getCtx());
        MRPRunLogInfo logValue = this.runParam.getRunLogInfo();
        if (logValue.getId() == null) {
            logValue.setId(BOSUuid.create((BOSObjectType)logValue.getBOSType()));
        }
        logValue.setPercent(0);
        logValue.setStatus(MRPRunLogStatusEnum.Running);
        logValue.setDesc(MRPResource.getString(this.runParam.getCtx(), "SP_START"));
        logValue.setStartTime(new Date());
        mrpRunLog.addnew(logValue);
    }

    @Override
    protected String getStepDesc() throws MRPException, BOSException {
        StringBuffer sb = new StringBuffer();
        Context ctx = this.runParam.getCtx();
        sb.append(MRPResource.getString(ctx, "SP_START")).append("\r\n").append(MRPResource.getString(ctx, "RUN_LOG_NUMBER")).append(this.runParam.getRunLogInfo().getNumber()).append("\r\n").append(MRPResource.getString(ctx, "PLANVERSION_NUMBER")).append(this.runParam.getPlanVersionNumber()).append("\r\n").append(MRPResource.getString(ctx, "PLANTYPE")).append((Object)this.runParam.getPlanType()).append("\r\n").append(MRPResource.getString(ctx, "CONTAIN_MRP_MATERIAL")).append(this.runParam.getRunLogInfo().isIsContainsMRPMaterial()).append("\r\n").append(MRPResource.getString(ctx, "DELAY_ORDER")).append(this.runParam.getRunLogInfo().isIsDelayOrder()).append("\r\n").append(MRPResource.getString(ctx, "BOM_CHECK")).append(this.runParam.getRunLogInfo().isIsCheckBOM()).append("\r\n").append(MRPResource.getString(ctx, "LOWLEVEL_CODE_CAL")).append(this.runParam.getRunLogInfo().isIsManageLLC()).append("\r\n");
        if (this.runParam.getPlanDate() != null && this.runParam.getPlanDate().getDate() != null) {
            DateFormat dtformat = BOSLocaleUtil.getDateFormat();
            sb.append(MRPResource.getString(ctx, "PLANDATE")).append(dtformat.format(this.runParam.getPlanDate().getDate().getTime())).append("\r\n");
        }
        return sb.toString();
    }

    @Override
    protected String getStepDesc(MRPCalcParam runParam) throws MRPException, BOSException {
        return MRPResource.getString(runParam.getCtx(), "SP_START");
    }

    private void initMRPBillParam() {
        this.initMRPBillParam(this.runParam);
    }

    private void setMRPPlanOrderTable() throws BOSException, MRPException {
        String tableName;
        StringBuffer tempTable = new StringBuffer();
        tempTable.append("create table T_MM_MRPPlannedOrder (");
        tempTable.append("FID VARCHAR(44) NOT NULL, ").append("\r\n");
        tempTable.append("FDetailID VARCHAR(44), ").append("\r\n");
        tempTable.append("FNumber VARCHAR(80),").append("\r\n");
        tempTable.append("FBizDate DATETIME,").append("\r\n");
        tempTable.append("FSourceBillID VARCHAR(44),").append("\r\n");
        tempTable.append("FBillTypeID VARCHAR(44),").append("\r\n");
        tempTable.append("FMaterialID VARCHAR(44),").append("\r\n");
        tempTable.append("FOrderType INT,").append("\r\n");
        tempTable.append("FProductionOrgUnitID VARCHAR(44),").append("\r\n");
        tempTable.append("FStartDate DATETIME,").append("\r\n");
        tempTable.append("FEndDate DATETIME,").append("\r\n");
        tempTable.append("FAvilableDate DATETIME,").append("\r\n");
        tempTable.append("FBaseQty NUMERIC(21,8) not null default 0,").append("\r\n");
        tempTable.append("FUnitID VARCHAR(44),").append("\r\n");
        tempTable.append("FProductUnitID VARCHAR(44),").append("\r\n");
        tempTable.append("FBomInterID VARCHAR(44),").append("\r\n");
        tempTable.append("FSchemeID VARCHAR(44),").append("\r\n");
        tempTable.append("FSourceBillTypeID VARCHAR(44),").append("\r\n");
        tempTable.append("FSourceOrderID VARCHAR(44),").append("\r\n");
        tempTable.append("FSourceNumber VARCHAR(80),").append("\r\n");
        tempTable.append("FSourceEntryID VARCHAR(44),").append("\r\n");
        tempTable.append("FRelatingOrderID VARCHAR(44),").append("\r\n");
        tempTable.append("FRelatingEntryID VARCHAR(44),").append("\r\n");
        tempTable.append("FRelatingOrderNum VARCHAR(80),").append("\r\n");
        tempTable.append("FRelatingEntrySeq INT,").append("\r\n");
        tempTable.append("FProjectID VARCHAR(44),").append("\r\n");
        tempTable.append("FTrackID VARCHAR(44),").append("\r\n");
        tempTable.append("FBProjectID VARCHAR(44),").append("\r\n");
        tempTable.append("FBTrackID VARCHAR(44),").append("\r\n");
        tempTable.append("FProjectNumBer VARCHAR(80),").append("\r\n");
        tempTable.append("FTrackNumber VARCHAR(80),").append("\r\n");
        tempTable.append("FBProjectNumBer VARCHAR(80),").append("\r\n");
        tempTable.append("FBTrackNumber VARCHAR(80),").append("\r\n");
        tempTable.append("FIsDefaultTNO int,").append("\r\n");
        tempTable.append("FAdminOrgUnitID VARCHAR(44),").append("\r\n");
        tempTable.append("FisStraightIssueMode INT,").append("\r\n");
        tempTable.append("FTransactionTypeID VARCHAR(44),").append("\r\n");
        tempTable.append("FIsCannotRelease INT,").append("\r\n");
        tempTable.append("FHierarchyCode VARCHAR(500),").append("\r\n");
        tempTable.append("FYield NUMERIC(21,8) not null default 100,").append("\r\n");
        tempTable.append("FManufactureDepartment VARCHAR(44),").append("\r\n");
        tempTable.append("FMaterialAttr INTEGER not null default 10060,").append("\r\n");
        tempTable.append("FConvertRate NUMERIC(21,8) not null default 1,").append("\r\n");
        tempTable.append("FPlanner VARCHAR(44) null,").append("\r\n");
        tempTable.append("FLowsetCode INTEGER not null default 999,").append("\r\n");
        tempTable.append("FProdQtyPrc Integer not null default 4,").append("\r\n");
        tempTable.append("FBaseQtyPrc Integer not null default 4, ").append("\r\n");
        tempTable.append("FBeginDateWorkdayID Integer,").append("\r\n");
        tempTable.append("FParentBomID VARCHAR(44),").append("\r\n");
        tempTable.append("FFinalProductsQty NUMERIC(21,8) not null default 0, ").append("\r\n");
        tempTable.append("FQty NUMERIC(21,8) not null default 0, ").append("\r\n");
        tempTable.append("FPlanOrgUnit varchar(44), ").append("\r\n");
        tempTable.append("CONSTRAINT ");
        tempTable.append(new UUTN("ZC").toString());
        tempTable.append(" PRIMARY KEY (FID) )");
        TempTablePool pool = TempTablePool.getInstance((Context)this.runParam.getCtx());
        try {
            tableName = pool.createTempTable(tempTable.toString());
            pool.createIndex(tableName, "FDetailID", false, false);
            pool.createIndex(tableName, "FMaterialID", false, false);
            this.runParam.setMrpPlanOrder(tableName);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        tempTable.setLength(0);
        tempTable.append("create table T_MM_MRPPlannedOrderEntry (");
        tempTable.append("FID VARCHAR(44) NOT NULL, ").append("\r\n");
        tempTable.append("FParentID VARCHAR(44),").append("\r\n");
        tempTable.append("FMaterialID VARCHAR(44),").append("\r\n");
        tempTable.append("FParentMaterialID VARCHAR(44),").append("\r\n");
        tempTable.append("FUnitID VARCHAR(44),").append("\r\n");
        tempTable.append("FDemandQty NUMERIC(21,8) not null default 0,").append("\r\n");
        tempTable.append("FBaseDemandQty NUMERIC(21,8) not null default 0,").append("\r\n");
        tempTable.append("FReqDate DATETIME,").append("\r\n");
        tempTable.append("FStorageOrgUnitID VARCHAR(44),").append("\r\n");
        tempTable.append("FSeq INT,").append("\r\n");
        tempTable.append("FSourceBillEntryID VARCHAR(44),").append("\r\n");
        tempTable.append("FProvideType INT,").append("\r\n");
        tempTable.append("FUnitQty NUMERIC(21,8) not null default 1,").append("\r\n");
        tempTable.append("FOutputType NUMERIC(21,8) not null default 1,").append("\r\n");
        tempTable.append("FStandardQty NUMERIC(21,8) not null default 0,").append("\r\n");
        tempTable.append("FScrapRate NUMERIC(21,8) not null default 0,").append("\r\n");
        tempTable.append("FIssMode int not null default 0,").append("\r\n");
        tempTable.append("FDefaultWarehouseID VARCHAR(44),").append("\r\n");
        tempTable.append("FLocationID VARCHAR(44),").append("\r\n");
        tempTable.append("FTransferOrgUnitID VARCHAR(44),").append("\r\n");
        tempTable.append("FTransferWarehouseID VARCHAR(44),").append("\r\n");
        tempTable.append("FBackFlush int not null default 0,").append("\r\n");
        tempTable.append("FIsStockTransfer int not null default 0,").append("\r\n");
        tempTable.append("FProductUnitId VARCHAR(44),").append("\r\n");
        tempTable.append("FMaterialSubsID VARCHAR(44),").append("\r\n");
        tempTable.append("FReplaceVersionID VARCHAR(44),").append("\r\n");
        tempTable.append("FReplaceVersionEntryID VARCHAR(44),").append("\r\n");
        tempTable.append("FLineSeq VARCHAR(10),").append("\r\n");
        tempTable.append("FIsReplaced INT not null default 0,").append("\r\n");
        tempTable.append("FReplacePriority INT not null default 0,").append("\r\n");
        tempTable.append("FMatReplaceType INT not null default 0,").append("\r\n");
        tempTable.append("FOriginalPlanQty NUMERIC(21,8) not null default 0,").append("\r\n");
        tempTable.append("FScrapQty NUMERIC(21,8) not null default 0,").append("\r\n");
        tempTable.append("FNewnetWeight NUMERIC(21,8) not null default 0,").append("\r\n");
        tempTable.append("FBlkSize NVARCHAR(255),").append("\r\n");
        tempTable.append("FSpecifiedLength NVARCHAR(255),").append("\r\n");
        tempTable.append("CONSTRAINT ");
        tempTable.append(new UUTN("ZC").toString());
        tempTable.append(" PRIMARY KEY (FID) )");
        try {
            tableName = pool.createTempTable(tempTable.toString());
            this.runParam.setMrpPlanOrderEntry(tableName);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return false;
    }

    private void setAdditionalInfo() throws MRPException, BOSException {
        MRPCalendarFactory factory = new MRPCalendarFactory(this.runParam.getCtx(), this.runParam.getStorageOrgUnitID());
        this.runParam.setCalendarFactory(factory);
        MRPSubstituteHelper substituteHelper = new MRPSubstituteHelper(this.runParam.getCtx());
        substituteHelper.setStorageOrgUnitId(this.runParam.getStorageOrgUnitID());
        substituteHelper.setTempPlanOrderEntryTable(this.runParam.getMrpPlanOrderEntry());
        this.runParam.setSubstituteHelper(substituteHelper);
        this.runParam.setExtendFacade(MRPCalcFacadeFactory.getLocalInstance(this.runParam.getCtx()));
    }

    protected void checkBom() throws MRPException, BOSException {
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("select t0.fbomType,t1.fnumber,count(*) ").append("from t_mm_bom t0 ").append("inner join t_bd_material t1 on t0.fmaterialid = t1.fid ").append("where t0.fbasestatus = ").append(4).append(" and t0.fusagetype = ").append(10).append(" and fbomtype=").append(40).append(" and t0.fstorageOrgUnitId = ? ").append(" group by t0.fbomType,t1.fnumber ").append(" having count(*) > 1");
        IRowSet rowSet = SQLUtils.executeQuery((Context)this.runParam.getCtx(), (String)sqlBuf.toString(), (Object[])new Object[]{this.runParam.getStorageOrgUnitID()});
        try {
            StringBuffer dbMsgBuf = new StringBuffer();
            StringBuffer fileMsgBuf = new StringBuffer();
            while (rowSet.next()) {
                if (dbMsgBuf.length() + rowSet.getString("fnumber").length() < 959) {
                    dbMsgBuf.append(rowSet.getString("fnumber")).append(",");
                } else {
                    dbMsgBuf.append("......");
                }
                fileMsgBuf.append(rowSet.getString("fnumber")).append(",");
            }
            if (dbMsgBuf.length() > 0) {
                MRPException exp = new MRPException(MRPException.BOM_REDUPLICATE, new Object[]{fileMsgBuf.toString()});
                logger.info((Object)exp.getMessage());
                exp = new MRPException(MRPException.BOM_REDUPLICATE, new Object[]{dbMsgBuf.toString()});
                throw exp;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

