/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.AdjustStrategyEnum;
import com.kingdee.eas.mm.planning.MRPElementEnum;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.app.mrp.MRPAjustMent;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPConstant;
import com.kingdee.eas.mm.planning.app.mrp.MRPDate;
import com.kingdee.eas.mm.planning.app.mrp.MRPDetailInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPFetchSurplusDivertDataUtil;
import com.kingdee.eas.mm.planning.app.mrp.MRPMaterialDataInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPMaterialStatisticsInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPProgressUpdater;
import com.kingdee.eas.mm.planning.app.mrp.MRPSeqUtil;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class MRPSurplusDivertAjustMent
extends MRPAjustMent {
    protected static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.mrp.MRPSurplusDivertAjustMent");
    protected MRPFetchSurplusDivertDataUtil materialDataUtil;
    protected MRPFetchSurplusDivertDataUtil reqMaterialDataUtil;
    protected MRPFetchSurplusDivertDataUtil supplyMaterialDataUtil;
    private Map onHandMap;
    private List fristPeriodList;

    public MRPSurplusDivertAjustMent(List materialIDLst, MRPCalcParam runParam, List materialFristPeriodList) throws MRPException, BOSException {
        super(materialIDLst, runParam);
        if (isMoreInfo.booleanValue()) {
            logger.setLevel(Level.INFO);
        } else {
            logger.setLevel(Level.ERROR);
        }
        this.fristPeriodList = materialFristPeriodList;
        this.materialDataUtil = new MRPFetchSurplusDivertDataUtil(runParam);
        this.materialDataUtil.setDataSaver(this.dataSaver);
        this.materialDataUtil.setDetailType(30);
        this.reqMaterialDataUtil = new MRPFetchSurplusDivertDataUtil(runParam);
        this.reqMaterialDataUtil.setDataSaver(this.dataSaver);
        this.reqMaterialDataUtil.setDetailType(10);
        this.supplyMaterialDataUtil = new MRPFetchSurplusDivertDataUtil(runParam);
        this.supplyMaterialDataUtil.setDataSaver(this.dataSaver);
        this.supplyMaterialDataUtil.setDetailType(20);
    }

    @Override
    protected void cycCalc() throws BOSException, EASBizException {
        this.materialCount = this.materialIDLst.size();
        int[] periods = null;
        MRPMaterialDataInfo materialDataInfo = null;
        int n = this.materialIDLst.size();
        for (int i = 0; i < n; ++i) {
            String materialID = (String)this.materialIDLst.get(i);
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"35_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + materialID + "\u3002"));
            this.fristPeriodList.add(new Object[]{new Integer(this.runParam.getMRPBeginDate().getPeriod()), new Timestamp(this.runParam.getBeginDate().getTime()), materialID});
            this.materialDataUtil.setMaterialId(materialID);
            periods = this.materialDataUtil.getCalcPeriod();
            this.materialDataUtil.clearSeq();
            this.onHandMap = null;
            for (int j = 0; j < periods.length; ++j) {
                int period = periods[j];
                while (this.materialDataUtil.hasNextMaterial(period)) {
                    materialDataInfo = this.materialDataUtil.getNextMaterial(period);
                    this.createMaterialDataInfo(materialDataInfo);
                    this.oneDayCalc(materialDataInfo, period);
                }
                this.dataSaver.execute(true);
            }
            this.afterCalcLoopHook();
            this.dataAmount += this.detailDataUtil.getDetailCount();
            this.detailDataUtil.clear();
            MRPProgressUpdater.updateMaterialCalcProgress(this.runParam, 1);
            this.doSurplusQtyDivert(materialID, false);
            this.doSurplusQtyDivert(materialID, true);
            this.dealSurplusReq(materialID);
            this.dealSurplusSupply(materialID);
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"36_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + materialID + "\u3002"));
        }
        this.materialException.clear();
        this.underSafeStockIds.clear();
        this.dataSaver.executeUpdateMaterial();
    }

    @Override
    protected void oneDayCalc(MRPMaterialDataInfo materialDataInfo, int period) throws BOSException, EASBizException {
        MRPMaterialStatisticsInfo materialStatisticsInfo = null;
        List detailDatas = null;
        while (this.materialDataUtil.hasNextStatisticData(period, materialDataInfo.getMaterialID(), null, null)) {
            BigDecimal pab;
            materialStatisticsInfo = this.materialDataUtil.getNextStatisticData(period, materialDataInfo.getMaterialID(), null, null);
            detailDatas = this.materialDataUtil.getOneMaterialDetialData(this.runParam, period, materialDataInfo.getMaterialID(), materialStatisticsInfo.getProjectNumber(), materialStatisticsInfo.getTrackNumber(), materialStatisticsInfo.getSeq());
            if (detailDatas == null || detailDatas.size() == 0) continue;
            this.detailLineCount += detailDatas.size();
            if (this.onHandMap == null) {
                this.onHandMap = this.materialDataUtil.getIsolatorOnhandDetail();
            }
            if ((pab = materialStatisticsInfo.getRQty().add(materialStatisticsInfo.getSQty())).compareTo(MRPConstant.ZERO) > 0) {
                this.dealSupplyOneByOne(detailDatas, materialStatisticsInfo.getRQty());
                continue;
            }
            this.dealReqOneByOne(detailDatas, materialStatisticsInfo.getSQty());
        }
    }

    private void dealReqOneByOne(List detailDatas, BigDecimal supplyQty) throws EASBizException, BOSException {
        for (int i = 0; i < detailDatas.size(); ++i) {
            MRPDetailInfo detailInfo = (MRPDetailInfo)detailDatas.get(i);
            BigDecimal reqQty = detailInfo.getIndependentQty().add(detailInfo.getDependentQty());
            if (reqQty.compareTo(MRPConstant.ZERO) < 0) {
                if ((supplyQty = supplyQty.add(reqQty)).compareTo(MRPConstant.ZERO) >= 0) continue;
                detailInfo.setSurplusQty(supplyQty);
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"37_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + detailInfo.getBillNumber() + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"38_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + reqQty + "\u3002"));
                this.dataSaver.addUpdateDetailNetReqList(detailInfo);
                supplyQty = MRPConstant.ZERO;
                continue;
            }
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"39_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + detailInfo.getBillNumber() + "\u3002"));
        }
    }

    private void dealSupplyOneByOne(List detailDatas, BigDecimal reqQty) throws EASBizException, BOSException {
        for (int i = 0; i < detailDatas.size(); ++i) {
            MRPDetailInfo detailInfo = (MRPDetailInfo)detailDatas.get(i);
            BigDecimal supplyQty = detailInfo.getScheduledReceiptQty().add(detailInfo.getAllocationQty());
            if (supplyQty.compareTo(MRPConstant.ZERO) > 0) {
                if ((reqQty = reqQty.add(supplyQty)).compareTo(MRPConstant.ZERO) <= 0) continue;
                detailInfo.setSurplusQty(reqQty);
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"37_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + detailInfo.getBillNumber() + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"40_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + reqQty + "\u3002"));
                this.dataSaver.addUpdateDetailNetReqList(detailInfo);
                reqQty = MRPConstant.ZERO;
                continue;
            }
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"41_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + detailInfo.getBillNumber() + "\u3002"));
        }
    }

    private void doSplitStock(MRPMaterialDataInfo materialDataInfo, MRPMaterialStatisticsInfo statisticsInfo, MRPDetailInfo onhandDetail, BigDecimal splitQty) throws EASBizException, BOSException {
        MRPDate billDate = this.runParam.getCalendarFactory().getDate(statisticsInfo.getPeriod());
        MRPDetailInfo onhandDetailCopy = (MRPDetailInfo)onhandDetail.clone();
        onhandDetailCopy.setID(BOSUuid.create((String)"F94043EF").toString());
        onhandDetailCopy.setMrpItem(MRPElementEnum.I_DivertInv);
        onhandDetailCopy.setRePlanDATE(billDate);
        onhandDetailCopy.setProjectNumber(statisticsInfo.getProjectNumber());
        onhandDetailCopy.setTrackNumber(statisticsInfo.getTrackNumber());
        onhandDetailCopy.setProjectID(statisticsInfo.getProjectId());
        onhandDetailCopy.setTrackID(statisticsInfo.getTrackNumberId());
        onhandDetailCopy.setBProjectID(onhandDetail.getProjectID());
        onhandDetailCopy.setBProjectNumber(onhandDetail.getProjectNumber());
        onhandDetailCopy.setBTrackID(onhandDetail.getTrackID());
        onhandDetailCopy.setBTrackNumber(onhandDetail.getTrackNumber());
        if (this.runParam.getTrackNumber().equals(onhandDetailCopy.getTrackNumber())) {
            onhandDetailCopy.setIsDeaultTNO(1);
        } else {
            onhandDetailCopy.setIsDeaultTNO(2);
        }
        onhandDetailCopy.setPeriod(statisticsInfo.getPeriod());
        onhandDetailCopy.setBillDate(billDate);
        onhandDetailCopy.setSperiod(onhandDetail.getPeriod());
        onhandDetailCopy.setSID(onhandDetail.getID());
        onhandDetailCopy.setAjustQty(splitQty);
        onhandDetailCopy.setAjustFlag(8);
        this.runParam.getExceptionUtil().setException(onhandDetailCopy, 80);
        this.generateException(materialDataInfo);
        MRPSeqUtil.setMRPSeq(onhandDetailCopy);
        onhandDetailCopy.setAvaliableQty(splitQty);
        onhandDetailCopy.setScheduledReceiptQty(splitQty);
        onhandDetailCopy.setNewOrder(false);
        onhandDetailCopy.setNetReqQty(MRPConstant.ZERO);
        this.dataSaver.addInsertList(onhandDetailCopy);
        onhandDetail.setHasSplit(true);
        onhandDetail.setAvaliableQty(onhandDetail.getAvaliableQty().subtract(splitQty));
        onhandDetail.setAjustQty(onhandDetail.getAjustQty().add(splitQty));
        onhandDetail.setNetReqQty(onhandDetail.getNetReqQty().subtract(splitQty));
        this.dataSaver.addUpdateList4Split(onhandDetail);
    }

    private void dealSurplusReq(String materialID) throws EASBizException, BOSException {
        this.reqMaterialDataUtil.setMaterialId(materialID);
        int[] reqPeriods = this.reqMaterialDataUtil.getCalcPeriod();
        this.reqMaterialDataUtil.clearSeq();
        for (int j = 0; j < reqPeriods.length; ++j) {
            int period = reqPeriods[j];
            MRPMaterialDataInfo materialDataInfo = this.reqMaterialDataUtil.getMaterialInfo(materialID);
            while (this.reqMaterialDataUtil.hasNextStatisticData(period, materialID, null, null)) {
                MRPMaterialStatisticsInfo reqMaterialStatisticsInfo = this.reqMaterialDataUtil.getNextStatisticData(period, materialID, null, null);
                ArrayList reqDetailDatas = (ArrayList)this.reqMaterialDataUtil.getOneMaterialDetialData(this.runParam, reqMaterialStatisticsInfo.getPeriod(), materialDataInfo.getMaterialID(), reqMaterialStatisticsInfo.getProjectNumber(), reqMaterialStatisticsInfo.getTrackNumber(), reqMaterialStatisticsInfo.getSeq());
                if (reqDetailDatas == null || reqDetailDatas.size() == 0) continue;
                this.dealOnePeriodSurplusReq(materialDataInfo, reqMaterialStatisticsInfo, reqDetailDatas);
            }
            this.dataSaver.execute(true);
        }
    }

    private void dealOnePeriodSurplusReq(MRPMaterialDataInfo materialDataInfo, MRPMaterialStatisticsInfo statisticsInfo, List detailDatas) throws EASBizException, BOSException {
        if (materialDataInfo.getBatchPolicy() == 1 || materialDataInfo.getBatchPolicy() == 2) {
            if (this.isMerge(materialDataInfo)) {
                while (detailDatas.size() > 0) {
                    MRPDetailInfo detailInfo = this.getNextMergeRequire(materialDataInfo.getPlanStrategy(), (ArrayList)detailDatas, materialDataInfo.getIsolatedRule());
                    logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"42_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + detailInfo.getNetReqQty() + "\u3002"));
                    this.batchCal(materialDataInfo, statisticsInfo.getPeriod(), detailInfo.getNetReqQty(), detailInfo.getNetReqQty(), false, detailInfo.getNetReqQty(), detailInfo, true);
                }
            } else {
                int n = detailDatas.size();
                for (int i = 0; i < n; ++i) {
                    MRPDetailInfo detailInfo = (MRPDetailInfo)detailDatas.get(i);
                    logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"43_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + detailInfo.getNetReqQty() + "\u3002"));
                    this.batchCal(materialDataInfo, statisticsInfo.getPeriod(), detailInfo.getNetReqQty(), detailInfo.getNetReqQty(), false, detailInfo.getNetReqQty(), detailInfo, true);
                }
            }
        } else {
            int n = detailDatas.size();
            for (int i = 0; i < n; ++i) {
                MRPDetailInfo detailInfo = (MRPDetailInfo)detailDatas.get(i);
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"43_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + detailInfo.getNetReqQty() + "\u3002"));
                this.batchCal(materialDataInfo, statisticsInfo.getPeriod(), detailInfo.getNetReqQty(), detailInfo.getNetReqQty(), false, detailInfo.getNetReqQty(), detailInfo, true);
            }
        }
    }

    private void dealSurplusSupply(String materialID) throws EASBizException, BOSException {
        this.supplyMaterialDataUtil.setMaterialId(materialID);
        int[] supplyPeriods = this.supplyMaterialDataUtil.getCalcPeriod();
        this.supplyMaterialDataUtil.clearSeq();
        for (int j = 0; j < supplyPeriods.length; ++j) {
            int period = supplyPeriods[j];
            MRPMaterialDataInfo materialDataInfo = this.supplyMaterialDataUtil.getMaterialInfo(materialID);
            while (this.supplyMaterialDataUtil.hasNextStatisticData(period, materialID, null, null)) {
                MRPMaterialStatisticsInfo supplyMaterialStatisticsInfo = this.supplyMaterialDataUtil.getNextStatisticData(period, materialID, null, null);
                ArrayList supplyDetailDatas = (ArrayList)this.supplyMaterialDataUtil.getOneMaterialDetialData(this.runParam, supplyMaterialStatisticsInfo.getPeriod(), materialDataInfo.getMaterialID(), supplyMaterialStatisticsInfo.getProjectNumber(), supplyMaterialStatisticsInfo.getTrackNumber(), supplyMaterialStatisticsInfo.getSeq());
                if (supplyDetailDatas == null || supplyDetailDatas.size() == 0) continue;
                this.dealOnePeriodSurplusSupply(materialDataInfo, supplyMaterialStatisticsInfo, supplyDetailDatas);
            }
            this.dataSaver.execute(true);
        }
    }

    private void dealOnePeriodSurplusSupply(MRPMaterialDataInfo materialDataInfo, MRPMaterialStatisticsInfo supplyMaterialStatisticsInfo, ArrayList detailDatas) throws EASBizException, BOSException {
        for (int i = 0; i < detailDatas.size(); ++i) {
            MRPDetailInfo detailInfo = (MRPDetailInfo)detailDatas.get(i);
            BigDecimal needDelayQty = this.calcCancelQty(materialDataInfo, detailInfo, detailInfo.getNetReqQty());
            if (needDelayQty.compareTo(MRPConstant.ZERO) <= 0) continue;
            if (needDelayQty.compareTo(detailInfo.getNetReqQty()) <= 0) {
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"44_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + needDelayQty + "\u3002"));
                MRPDetailInfo detailInfoCopy = (MRPDetailInfo)detailInfo.clone();
                detailInfoCopy.setID(BOSUuid.create((String)"F94043EF").toString());
                detailInfoCopy.setSperiod(detailInfo.getPeriod());
                detailInfoCopy.setPeriod(this.runParam.getMRPEndDate().getWorkDaySeqID());
                if (this.runParam.getExceptionUtil().setException(detailInfoCopy, 62)) {
                    this.statisticException(materialDataInfo);
                }
                detailInfoCopy.setRePlanDATE(null);
                detailInfoCopy.setSID(detailInfo.getID());
                detailInfoCopy.setAjustQty(needDelayQty);
                detailInfoCopy.setScheduledReceiptQty(needDelayQty);
                detailInfoCopy.setNetReqQty(MRPConstant.ZERO);
                detailInfoCopy.setAjustFlag(4);
                detailInfoCopy.setPriority(99999);
                MRPSeqUtil.setMRPSeq(detailInfoCopy);
                this.dataSaver.addInsertList(detailInfoCopy);
                detailInfo.setAjustQty(detailInfo.getAjustQty().add(needDelayQty));
                detailInfo.setScheduledReceiptQty(detailInfo.getScheduledReceiptQty().subtract(needDelayQty));
                detailInfo.setNetReqQty(MRPConstant.ZERO);
                detailInfo.setHasSplit(true);
                this.dataSaver.addUpdateList4Split(detailInfo);
                continue;
            }
            logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"45_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()));
        }
    }

    protected void doSurplusQtyDivert(String materialID, boolean isCross) throws EASBizException, BOSException {
        this.reqMaterialDataUtil.setMaterialId(materialID);
        int[] reqPeriods = this.reqMaterialDataUtil.getCalcPeriod();
        this.reqMaterialDataUtil.clearSeq();
        for (int j = 0; j < reqPeriods.length; ++j) {
            if (isCross) {
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"46_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"47_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + reqPeriods[j] + "\u3002"));
            } else {
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"48_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"47_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + reqPeriods[j] + "\u3002"));
            }
            int period = reqPeriods[j];
            MRPMaterialDataInfo materialDataInfo = this.reqMaterialDataUtil.getMaterialInfo(materialID);
            this.oneDayDivert(materialDataInfo, period, isCross);
            if (isCross) {
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"49_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"50_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale())));
                continue;
            }
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"51_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"50_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale())));
        }
    }

    protected void oneDayDivert(MRPMaterialDataInfo materialDataInfo, int period, boolean isCross) throws BOSException, EASBizException {
        MRPMaterialStatisticsInfo reqMaterialStatisticsInfo = null;
        MRPMaterialStatisticsInfo supplyMaterialStatisticsInfo = null;
        List reqDetailDatas = null;
        ArrayList supplyDetailDatas = null;
        BigDecimal pab = MRPConstant.ZERO;
        String projectNumber = null;
        String trackNumber = null;
        ArrayList<MRPDetailInfo> divertList = new ArrayList<MRPDetailInfo>();
        while (this.reqMaterialDataUtil.hasNextStatisticData(period, materialDataInfo.getMaterialID(), null, null)) {
            reqMaterialStatisticsInfo = this.reqMaterialDataUtil.getNextStatisticData(period, materialDataInfo.getMaterialID(), null, null);
            reqDetailDatas = this.reqMaterialDataUtil.getOneMaterialDetialData(this.runParam, period, materialDataInfo.getMaterialID(), reqMaterialStatisticsInfo.getProjectNumber(), reqMaterialStatisticsInfo.getTrackNumber(), reqMaterialStatisticsInfo.getSeq());
            if (reqDetailDatas == null || reqDetailDatas.size() == 0) continue;
            BigDecimal reqQty = reqMaterialStatisticsInfo.getSurplusQty();
            if (this.runParam.getPlanVersion().isIsINVFirst()) {
                reqQty = this.dealDiverStock(materialDataInfo, reqMaterialStatisticsInfo, reqQty, isCross);
            }
            if (reqQty.compareTo(MRPConstant.ZERO) < 0) {
                this.supplyMaterialDataUtil.setMaterialId(materialDataInfo.getMaterialID());
                this.supplyMaterialDataUtil.clearSeq();
                if (!isCross) {
                    projectNumber = reqMaterialStatisticsInfo.getProjectNumber();
                    trackNumber = reqMaterialStatisticsInfo.getTrackNumber();
                }
                while (this.supplyMaterialDataUtil.hasNextStatisticData(period, materialDataInfo.getMaterialID(), projectNumber, trackNumber)) {
                    supplyMaterialStatisticsInfo = this.supplyMaterialDataUtil.getNextStatisticData(period, materialDataInfo.getMaterialID(), projectNumber, trackNumber);
                    supplyDetailDatas = (ArrayList)this.supplyMaterialDataUtil.getOneMaterialDetialData(this.runParam, supplyMaterialStatisticsInfo.getPeriod(), materialDataInfo.getMaterialID(), supplyMaterialStatisticsInfo.getProjectNumber(), supplyMaterialStatisticsInfo.getTrackNumber(), supplyMaterialStatisticsInfo.getSeq());
                    if (supplyDetailDatas == null || supplyDetailDatas.size() == 0) continue;
                    pab = supplyMaterialStatisticsInfo.getSurplusQty().add(reqQty);
                    if (pab.compareTo(MRPConstant.ZERO) < 0) {
                        divertList.addAll(supplyDetailDatas);
                        reqQty = pab;
                        supplyMaterialStatisticsInfo.setSurplusQty(MRPConstant.ZERO);
                        this.dataSaver.addUpdateSurplusQtyList(supplyMaterialStatisticsInfo);
                        continue;
                    }
                    BigDecimal divertQty = MRPConstant.ZERO;
                    int n = supplyDetailDatas.size();
                    for (int i = 0; i < n; ++i) {
                        MRPDetailInfo supplyDetailInfo = (MRPDetailInfo)supplyDetailDatas.get(i);
                        divertList.add(supplyDetailInfo);
                        reqQty = reqQty.add(supplyDetailInfo.getSurplusQty());
                        if (reqQty.compareTo(MRPConstant.ZERO) >= 0) break;
                    }
                    supplyMaterialStatisticsInfo.setSurplusQty(pab);
                    this.dataSaver.addUpdateSurplusQtyList(supplyMaterialStatisticsInfo);
                    break;
                }
            }
            if (!this.runParam.getPlanVersion().isIsINVFirst()) {
                reqQty = this.dealDiverStock(materialDataInfo, reqMaterialStatisticsInfo, reqQty, isCross);
            }
            reqMaterialStatisticsInfo.setSurplusQty(reqQty.compareTo(MRPConstant.ZERO) > 0 ? MRPConstant.ZERO : reqQty);
            this.dataSaver.addUpdateSurplusQtyList(reqMaterialStatisticsInfo);
            this.dealDivertReq(reqDetailDatas, reqQty, isCross);
            if (divertList != null && divertList.size() > 0) {
                this.dealDivertSupply(materialDataInfo, reqMaterialStatisticsInfo, divertList, reqQty, isCross);
                divertList.clear();
            }
            this.dataSaver.execute(true);
        }
    }

    private BigDecimal dealDiverStock(MRPMaterialDataInfo materialDataInfo, MRPMaterialStatisticsInfo reqMaterialStatisticsInfo, BigDecimal reqQty, boolean isCross) throws EASBizException, BOSException {
        if (reqQty.compareTo(MRPConstant.ZERO) >= 0) {
            return reqQty;
        }
        BigDecimal safeStock = this.runParam.isSafeStock() ? materialDataInfo.getSafeStockQty() : MRPConstant.ZERO;
        for (Map.Entry entry : this.onHandMap.entrySet()) {
            MRPDetailInfo onhandDetail;
            BigDecimal onHandQty;
            BigDecimal onHand;
            String key = reqMaterialStatisticsInfo.getProjectNumber() + reqMaterialStatisticsInfo.getTrackNumber();
            if (!isCross && !key.equals(entry.getKey()) || (onHand = (onHandQty = (onhandDetail = (MRPDetailInfo)this.onHandMap.get(entry.getKey())).getNetReqQty()).compareTo(safeStock) >= 0 ? onHandQty.subtract(safeStock) : MRPConstant.ZERO).compareTo(MRPConstant.ZERO) == 0) continue;
            BigDecimal pab = onHand.add(reqQty);
            if (pab.compareTo(MRPConstant.ZERO) >= 0) {
                if (isCross) {
                    logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"52_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + reqQty + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"53_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + onHandQty.add(reqQty) + "\u3002"));
                    this.doSplitStock(materialDataInfo, reqMaterialStatisticsInfo, onhandDetail, reqQty.abs());
                } else {
                    logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"54_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + reqQty + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"53_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + onHandQty.add(reqQty) + "\u3002"));
                    onhandDetail.setNetReqQty(onHandQty.add(reqQty));
                }
                reqQty = MRPConstant.ZERO;
                break;
            }
            if (isCross) {
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"52_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + onHand + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"53_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + safeStock + "\u3002"));
                this.doSplitStock(materialDataInfo, reqMaterialStatisticsInfo, onhandDetail, onHand);
            } else {
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"54_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + onHand + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"53_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + safeStock + "\u3002"));
                onhandDetail.setNetReqQty(safeStock);
            }
            reqQty = pab;
        }
        return reqQty;
    }

    private void dealDivertReq(List detailDatas, BigDecimal surplusQty, boolean isCross) throws EASBizException, BOSException {
        for (int i = detailDatas.size() - 1; i >= 0; --i) {
            MRPDetailInfo detailInfo = (MRPDetailInfo)detailDatas.get(i);
            if (surplusQty.compareTo(MRPConstant.ZERO) >= 0) {
                if (isCross) {
                    logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"55_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + detailInfo.getBillNumber() + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"56_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + detailInfo.getSurplusQty() + "\u3002"));
                } else {
                    logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"57_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + detailInfo.getBillNumber() + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"56_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + detailInfo.getSurplusQty() + "\u3002"));
                }
                detailInfo.setSurplusQty(MRPConstant.ZERO);
                this.dataSaver.addUpdateDetailNetReqList(detailInfo);
                continue;
            }
            if (surplusQty.compareTo(detailInfo.getSurplusQty()) <= 0) {
                surplusQty = surplusQty.subtract(detailInfo.getSurplusQty());
                continue;
            }
            if (isCross) {
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"58_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + detailInfo.getBillNumber() + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"56_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + detailInfo.getSurplusQty().subtract(surplusQty) + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"59_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + surplusQty + "\u3002"));
            } else {
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"60_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + detailInfo.getBillNumber() + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"56_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + detailInfo.getSurplusQty().subtract(surplusQty) + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"59_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + surplusQty + "\u3002"));
            }
            detailInfo.setSurplusQty(surplusQty);
            this.dataSaver.addUpdateDetailNetReqList(detailInfo);
            surplusQty = MRPConstant.ZERO;
        }
    }

    private void dealDivertSupply(MRPMaterialDataInfo materialDataInfo, MRPMaterialStatisticsInfo statisticsInfo, List detailDatas, BigDecimal surplusQty, boolean isCross) throws EASBizException, BOSException {
        for (int i = detailDatas.size() - 1; i >= 0; --i) {
            MRPDetailInfo detailInfo = (MRPDetailInfo)detailDatas.get(i);
            if (surplusQty.compareTo(MRPConstant.ZERO) <= 0) {
                if (isCross) {
                    logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"61_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + detailInfo.getBillNumber() + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"56_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + detailInfo.getSurplusQty() + "\u3002"));
                } else {
                    logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"62_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + detailInfo.getBillNumber() + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"56_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + detailInfo.getSurplusQty() + "\u3002"));
                }
                this.handleAdjust(materialDataInfo, statisticsInfo, detailInfo, detailInfo.getSurplusQty());
                continue;
            }
            if (surplusQty.compareTo(detailInfo.getSurplusQty()) > 0) {
                surplusQty = surplusQty.subtract(detailInfo.getSurplusQty());
                continue;
            }
            if (isCross) {
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"63_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + detailInfo.getBillNumber() + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"56_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + detailInfo.getSurplusQty().subtract(surplusQty) + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"59_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + surplusQty + "\u3002"));
            } else {
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"64_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + detailInfo.getBillNumber() + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"56_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + detailInfo.getSurplusQty().subtract(surplusQty) + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"59_MRPSurplusDivertAjustMent", (Locale)this.runParam.getCtx().getLocale()) + surplusQty + "\u3002"));
            }
            this.handleAdjust(materialDataInfo, statisticsInfo, detailInfo, detailInfo.getSurplusQty().subtract(surplusQty));
            surplusQty = MRPConstant.ZERO;
        }
    }

    private void handleAdjust(MRPMaterialDataInfo materialDataInfo, MRPMaterialStatisticsInfo statisticsInfo, MRPDetailInfo detailInfo, BigDecimal adjustQty) throws EASBizException, BOSException {
        this.doPartAdjust(materialDataInfo, statisticsInfo, detailInfo, adjustQty);
    }

    private boolean isCanDivert(MRPDetailInfo detailInfo) {
        AdjustStrategyEnum adjustStrategy = this.runParam.getAdjustStrategy(detailInfo.getBillType());
        if (adjustStrategy.equals((Object)AdjustStrategyEnum.WHOLE_ADJUST)) {
            return detailInfo.getScheduledReceiptQty().compareTo(detailInfo.getSurplusQty()) == 0;
        }
        return adjustStrategy.equals((Object)AdjustStrategyEnum.PART_ADJUST);
    }

    private void doWholeAdjust(MRPMaterialDataInfo materialDataInfo, MRPMaterialStatisticsInfo statisticsInfo, MRPDetailInfo detailInfo) throws BOSException, EASBizException {
        MRPDate billDate = this.runParam.getCalendarFactory().getDate(statisticsInfo.getPeriod());
        detailInfo.setRePlanDATE(billDate);
        detailInfo.setSID(detailInfo.getID());
        detailInfo.setSperiod(detailInfo.getPeriod());
        detailInfo.setSurplusQty(MRPConstant.ZERO);
        detailInfo.setNetReqQty(MRPConstant.ZERO);
        int ajustValue = this.getAdjustType(statisticsInfo, detailInfo);
        detailInfo.setAjustFlag(ajustValue);
        this.addException4DetailInfo(materialDataInfo, detailInfo);
        detailInfo.setPeriod(statisticsInfo.getPeriod());
        detailInfo.setBillDate(billDate);
        detailInfo.setAjustQty(detailInfo.getScheduledReceiptQty());
        this.dataSaver.addUpdateList4Split(detailInfo);
    }

    private void doPartAdjust(MRPMaterialDataInfo materialDataInfo, MRPMaterialStatisticsInfo statisticsInfo, MRPDetailInfo detailInfo, BigDecimal adjustQty) throws BOSException, EASBizException {
        MRPDate billDate = this.runParam.getCalendarFactory().getDate(statisticsInfo.getPeriod());
        MRPDetailInfo detailInfoCopy = (MRPDetailInfo)detailInfo.clone();
        detailInfoCopy.setID(BOSUuid.create((String)"F94043EF").toString());
        detailInfoCopy.setRePlanDATE(billDate);
        detailInfoCopy.setProjectNumber(statisticsInfo.getProjectNumber());
        detailInfoCopy.setTrackNumber(statisticsInfo.getTrackNumber());
        detailInfoCopy.setProjectID(statisticsInfo.getProjectId());
        detailInfoCopy.setTrackID(statisticsInfo.getTrackNumberId());
        detailInfoCopy.setBProjectID(statisticsInfo.getProjectId());
        detailInfoCopy.setBProjectNumber(statisticsInfo.getProjectNumber());
        detailInfoCopy.setBTrackID(statisticsInfo.getTrackNumberId());
        detailInfoCopy.setBTrackNumber(statisticsInfo.getTrackNumber());
        if (this.runParam.getTrackNumber().equals(detailInfoCopy.getTrackNumber())) {
            detailInfoCopy.setIsDeaultTNO(1);
        } else {
            detailInfoCopy.setIsDeaultTNO(2);
        }
        detailInfoCopy.setPeriod(statisticsInfo.getPeriod());
        detailInfoCopy.setBillDate(billDate);
        detailInfoCopy.setSperiod(detailInfo.getPeriod());
        detailInfoCopy.setSID(detailInfo.getID());
        detailInfoCopy.setAjustQty(MRPConstant.ZERO);
        int ajustValue = this.getAdjustType(statisticsInfo, detailInfo);
        detailInfoCopy.setAjustFlag(ajustValue);
        this.addException4DetailInfo(materialDataInfo, detailInfoCopy);
        MRPSeqUtil.setMRPSeq(detailInfoCopy);
        detailInfoCopy.setHasSplit(true);
        detailInfoCopy.setScheduledReceiptQty(adjustQty);
        detailInfoCopy.setAjustQty(adjustQty);
        detailInfoCopy.setSurplusQty(MRPConstant.ZERO);
        detailInfoCopy.setNetReqQty(MRPConstant.ZERO);
        detailInfoCopy.setNewOrder(false);
        this.dataSaver.addInsertList(detailInfoCopy);
        detailInfo.setHasSplit(true);
        detailInfo.setSurplusQty(detailInfo.getSurplusQty().subtract(adjustQty));
        detailInfo.setScheduledReceiptQty(detailInfo.getScheduledReceiptQty().subtract(adjustQty));
        detailInfo.setNetReqQty(detailInfo.getSurplusQty());
        this.dataSaver.addUpdateList4Split(detailInfo);
    }

    private int getAdjustType(MRPMaterialStatisticsInfo statisticsInfo, MRPDetailInfo detailInfo) {
        int ajustValue = 0;
        if (statisticsInfo.getProjectNumber().equals(detailInfo.getProjectNumber()) && statisticsInfo.getTrackNumber().equals(detailInfo.getTrackNumber())) {
            if (detailInfo.getPeriod() < statisticsInfo.getPeriod()) {
                ajustValue = statisticsInfo.getPeriod() - detailInfo.getPeriod() <= this.runParam.getPlanVersion().getTolerOfDisplacemt() ? 5 : 3;
            } else if (detailInfo.getPeriod() > statisticsInfo.getPeriod()) {
                ajustValue = detailInfo.getPeriod() - statisticsInfo.getPeriod() <= this.runParam.getPlanVersion().getTolerOfDisplacemt() ? 1 : 2;
            }
        } else {
            ajustValue = detailInfo.getPeriod() < statisticsInfo.getPeriod() ? (statisticsInfo.getPeriod() - detailInfo.getPeriod() <= this.runParam.getPlanVersion().getTolerOfDisplacemt() ? 9 : 11) : (detailInfo.getPeriod() > statisticsInfo.getPeriod() ? (detailInfo.getPeriod() - statisticsInfo.getPeriod() <= this.runParam.getPlanVersion().getTolerOfDisplacemt() ? 9 : 10) : 9);
        }
        return ajustValue;
    }

    private void addException4DetailInfo(MRPMaterialDataInfo materialDataInfo, MRPDetailInfo detailInfo) throws BOSException {
        int ajustValue = detailInfo.getAjustFlag();
        if (ajustValue == 3) {
            this.runParam.getExceptionUtil().setException(detailInfo, 61);
            this.generateException(materialDataInfo);
        }
        if (ajustValue == 2) {
            this.runParam.getExceptionUtil().setException(detailInfo, 60);
            this.generateException(materialDataInfo);
        }
        if (ajustValue == 9) {
            this.runParam.getExceptionUtil().setException(detailInfo, 81);
            this.generateException(materialDataInfo);
        }
        if (ajustValue == 11) {
            this.runParam.getExceptionUtil().setException(detailInfo, 83);
            this.generateException(materialDataInfo);
        }
        if (ajustValue == 10) {
            this.runParam.getExceptionUtil().setException(detailInfo, 82);
            this.generateException(materialDataInfo);
        }
    }

    private void generateException(MRPMaterialDataInfo materialDataInfo) {
        if (!this.materialException.contains(materialDataInfo.getMaterialID())) {
            this.materialException.add(materialDataInfo.getMaterialID());
            if (this.isContainMaterial(materialDataInfo)) {
                this.runParam.generateException();
            }
        }
    }

    @Override
    protected MRPDetailInfo getNextMergeRequire(String planStrategy, ArrayList detailDatas, IsolatedRuleEnum isolateRule) {
        MRPDetailInfo newDetailInfo;
        MRPDetailInfo detailInfo;
        MRPDetailInfo lastDetailInfo = detailInfo = (MRPDetailInfo)detailDatas.get(0);
        boolean isDirectTransport = detailInfo.isDirectTransport();
        BigDecimal rqty = MRPConstant.ZERO;
        int group = detailInfo.getPriority();
        Iterator iterator = detailDatas.iterator();
        if ("qAYbemEdG9ngQKjAYj0V1dg0uEU=".equals(planStrategy) || "qAYfaBzTrmLgQKjAYj0f3dg0uEU=".equals(planStrategy) || "qAYfaBzUrmLgQKjAYj0f3dg0uEU=".equals(planStrategy)) {
            boolean isCanNotThrow = detailInfo.isCanNotThrow();
            while (iterator.hasNext()) {
                detailInfo = (MRPDetailInfo)iterator.next();
                if (!isDirectTransport) {
                    isDirectTransport = detailInfo.isDirectTransport();
                }
                if (group == detailInfo.getPriority() && isCanNotThrow == detailInfo.isCanNotThrow()) {
                    rqty = rqty.add(detailInfo.getSurplusQty());
                    lastDetailInfo = detailInfo;
                    iterator.remove();
                    continue;
                }
                break;
            }
        } else {
            while (iterator.hasNext()) {
                detailInfo = (MRPDetailInfo)iterator.next();
                if (!isDirectTransport) {
                    isDirectTransport = detailInfo.isDirectTransport();
                }
                if (group == detailInfo.getPriority()) {
                    rqty = rqty.add(detailInfo.getSurplusQty());
                    lastDetailInfo = detailInfo;
                    iterator.remove();
                    continue;
                }
                break;
            }
        }
        if (this.isNotProjectNoIsolation(planStrategy, newDetailInfo = (MRPDetailInfo)lastDetailInfo.clone())) {
            newDetailInfo.setBProjectID(this.runParam.getProjectID());
            newDetailInfo.setBProjectNumber(this.runParam.getProjectNumber());
        }
        if (this.isNotTrackNoIsolation(planStrategy, isolateRule, newDetailInfo)) {
            newDetailInfo.setBTrackID(this.runParam.getTrackID());
            newDetailInfo.setBTrackNumber(this.runParam.getTrackNumber());
        }
        newDetailInfo.setDirectTransport(isDirectTransport);
        newDetailInfo.setDependentQty(rqty);
        newDetailInfo.setIndependentQty(MRPConstant.ZERO);
        newDetailInfo.setNetReqQty(rqty);
        return newDetailInfo;
    }
}

