/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.planning.app.mrp.MRPRunningTablesInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPStep;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class MRPTableUpgrader {
    protected static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.mrp.MRPTableUpgrader");
    static String[][] materialTableUpgradeSQLs = null;
    static String[][] detailTableUpgradeSQLs = null;
    static String updateTableVerSQL = null;
    static String existsSQL = null;
    static String alterSQL = null;

    public MRPTableUpgrader() {
        if (MRPStep.isMoreInfo.booleanValue()) {
            logger.setLevel(Level.INFO);
        } else {
            logger.setLevel(Level.ERROR);
        }
    }

    public static void upgrade(Context ctx, String storageOrgUnitID, String planVerID, List tableList, int currentVer, boolean isFormal) throws BOSException, EASBizException {
        String materialTableName = ((MRPRunningTablesInfo)tableList.get(0)).getTableName();
        String detailTableName = ((MRPRunningTablesInfo)tableList.get(1)).getTableName();
        MRPTableUpgrader.upgradeTable(ctx, materialTableName, materialTableUpgradeSQLs, currentVer);
        MRPTableUpgrader.upgradeTable(ctx, detailTableName, detailTableUpgradeSQLs, currentVer);
        MRPUtil.executeUpdate(ctx, updateTableVerSQL, new Object[]{new Integer(120), storageOrgUnitID, planVerID, isFormal});
        MRPTableUpgrader.updateMrpException(ctx);
    }

    private static boolean upgradeTable(Context ctx, String tableName, String[][] sqls, int currentVer) throws BOSException, EASBizException {
        Statement pstmt;
        Connection conn;
        block6: {
            boolean bl;
            if (sqls == null || sqls.length <= 0) {
                return false;
            }
            StringBuffer addedFiled = new StringBuffer();
            addedFiled.append("MRP Update Tables: Upgrade Table: ");
            addedFiled.append(tableName);
            addedFiled.append(", Added Fields:");
            conn = null;
            pstmt = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                pstmt = conn.createStatement();
                int addColCount = 0;
                String theAlterSQL = null;
                for (int i = 0; i < sqls.length; ++i) {
                    if (MRPTableUpgrader.isColExists(ctx, tableName, sqls[i][1])) continue;
                    theAlterSQL = MessageFormat.format(alterSQL, tableName, sqls[i][1], sqls[i][2]);
                    pstmt.addBatch(theAlterSQL);
                    addedFiled.append("[").append(sqls[i][1]).append("]");
                    ++addColCount;
                }
                if (addColCount <= 0) break block6;
                pstmt.executeBatch();
                logger.info((Object)addedFiled.toString());
                bl = true;
            }
            catch (SQLException e) {
                try {
                    throw new SQLDataException(e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
            return bl;
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isColExists(Context ctx, String tableName, String colName) throws SQLException {
        boolean bl;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(existsSQL);
            pstmt.setString(1, colName.toUpperCase());
            pstmt.setString(2, tableName.toUpperCase());
            rs = pstmt.executeQuery();
            bl = rs.next();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return bl;
    }

    private static void updateMrpException(Context ctx) throws BOSException {
        int versionNum = 118;
        if (120 != versionNum) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" select FTABLENAME ");
        sb.append(" from T_MM_RUNNINGTABLES");
        sb.append(" where FVERSION < 118 and FTABLETYPE = 'detail'");
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sb.toString());
        if (rs == null || rs.size() == 0) {
            return;
        }
        String[] sqls = new String[7];
        sb.setLength(0);
        sb.append(" update ? ");
        sb.append(" set fexception1 = case when fexception1 = 2 then 10 ");
        sb.append("                        when fexception1 = 10 then 11 ");
        sb.append("                        else 0 end ");
        sb.append(" where fexception1 in (2, 10)");
        sqls[0] = sb.toString();
        sb.setLength(0);
        sb.append(" update ? ");
        sb.append(" set fexception2 = case when fexception2 = 3 then 20 ");
        sb.append("                        when fexception2 = 11 then 21 ");
        sb.append("                        else 0 end ");
        sb.append(" where fexception2 in (3, 11)");
        sqls[1] = sb.toString();
        sb.setLength(0);
        sb.append(" update ? ");
        sb.append(" set fexception3 = case when fexception3 = 20 then 30 ");
        sb.append("                        when fexception3 = 21 then 31 ");
        sb.append("                        else 0 end ");
        sb.append(" where fexception3 in (20, 21)");
        sqls[2] = sb.toString();
        sb.setLength(0);
        sb.append(" update ? ");
        sb.append(" set fexception4 = case when fexception4 = 30 then 40 ");
        sb.append("                        when fexception4 = 31 then 41 ");
        sb.append("                        else 0 end ");
        sb.append(" where fexception4 in (30, 31)");
        sqls[3] = sb.toString();
        sb.setLength(0);
        sb.append(" update ? ");
        sb.append(" set fexception5 = 50 ");
        sb.append(" where fexception5 = 32");
        sqls[4] = sb.toString();
        sb.setLength(0);
        sb.append(" update ? ");
        sb.append(" set fexception6 = case when fexception6 = 40 then 60 ");
        sb.append("                        when fexception6 = 41 then 61 ");
        sb.append("                        when fexception6 = 42 then 62 ");
        sb.append("                        when fexception6 = 43 then 63 ");
        sb.append("                        else 0 end ");
        sb.append(" where fexception6 in (40, 41, 42, 43)");
        sqls[5] = sb.toString();
        sb.setLength(0);
        sb.append(" update ? ");
        sb.append(" set fexception7 = 70 ");
        sb.append(" where fexception7 = 50");
        sqls[6] = sb.toString();
        String tableName = null;
        try {
            while (rs.next()) {
                tableName = rs.getString("FTABLENAME");
                for (int i = 0; i < sqls.length; ++i) {
                    SQLUtils.execute((Context)ctx, (String)sqls[i].replaceAll("\\?", tableName));
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    static {
        updateTableVerSQL = "update T_MM_RunningTables set FVersion = ? where fstorageOrgUnitId = ? and fplanverid = ? and FIsFormal=?";
        existsSQL = "SELECT 1 WHERE EXISTS(SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = ? AND KSQL_COL_TABNAME= ?)";
        alterSQL = "ALTER TABLE {0} ADD {1} {2} ";
        materialTableUpgradeSQLs = new String[24][3];
        MRPTableUpgrader.materialTableUpgradeSQLs[0][0] = "105";
        MRPTableUpgrader.materialTableUpgradeSQLs[0][1] = "FSubstitute";
        MRPTableUpgrader.materialTableUpgradeSQLs[0][2] = "INTEGER DEFAULT 0 NOT NULL ";
        MRPTableUpgrader.materialTableUpgradeSQLs[1][0] = "105";
        MRPTableUpgrader.materialTableUpgradeSQLs[1][1] = "FSubstituteGroup";
        MRPTableUpgrader.materialTableUpgradeSQLs[1][2] = "INTEGER DEFAULT 0 NOT NULL ";
        MRPTableUpgrader.materialTableUpgradeSQLs[2][0] = "105";
        MRPTableUpgrader.materialTableUpgradeSQLs[2][1] = "FCalcSeq";
        MRPTableUpgrader.materialTableUpgradeSQLs[2][2] = "INTEGER DEFAULT 0 NOT NULL ";
        MRPTableUpgrader.materialTableUpgradeSQLs[3][0] = "105";
        MRPTableUpgrader.materialTableUpgradeSQLs[3][1] = "FfixStock";
        MRPTableUpgrader.materialTableUpgradeSQLs[3][2] = " NUMERIC(21,8) DEFAULT 0 NOT NULL ";
        MRPTableUpgrader.materialTableUpgradeSQLs[4][0] = "107";
        MRPTableUpgrader.materialTableUpgradeSQLs[4][1] = "FQtyMinPackage";
        MRPTableUpgrader.materialTableUpgradeSQLs[4][2] = "NUMERIC(21,8) ";
        MRPTableUpgrader.materialTableUpgradeSQLs[5][0] = "109";
        MRPTableUpgrader.materialTableUpgradeSQLs[5][1] = "FManufactureDepartment";
        MRPTableUpgrader.materialTableUpgradeSQLs[5][2] = "VARCHAR(44) ";
        MRPTableUpgrader.materialTableUpgradeSQLs[6][0] = "110";
        MRPTableUpgrader.materialTableUpgradeSQLs[6][1] = "FisNewOrder";
        MRPTableUpgrader.materialTableUpgradeSQLs[6][2] = "INTEGER not null default 0 ";
        MRPTableUpgrader.materialTableUpgradeSQLs[7][0] = "110";
        MRPTableUpgrader.materialTableUpgradeSQLs[7][1] = "FhasStockExp";
        MRPTableUpgrader.materialTableUpgradeSQLs[7][2] = "INTEGER not null default 0 ";
        MRPTableUpgrader.materialTableUpgradeSQLs[8][0] = "110";
        MRPTableUpgrader.materialTableUpgradeSQLs[8][1] = "FhasExceptions";
        MRPTableUpgrader.materialTableUpgradeSQLs[8][2] = "INTEGER not null default 0 ";
        MRPTableUpgrader.materialTableUpgradeSQLs[9][0] = "112";
        MRPTableUpgrader.materialTableUpgradeSQLs[9][1] = "FCollabMaterialEntryID";
        MRPTableUpgrader.materialTableUpgradeSQLs[9][2] = "varchar(44) ";
        MRPTableUpgrader.materialTableUpgradeSQLs[10][0] = "114";
        MRPTableUpgrader.materialTableUpgradeSQLs[10][1] = "FRequirementUniteRuleID";
        MRPTableUpgrader.materialTableUpgradeSQLs[10][2] = "varchar(44) ";
        MRPTableUpgrader.materialTableUpgradeSQLs[11][0] = "115";
        MRPTableUpgrader.materialTableUpgradeSQLs[11][1] = "FProductTranTypeID";
        MRPTableUpgrader.materialTableUpgradeSQLs[11][2] = " varchar(44) ";
        MRPTableUpgrader.materialTableUpgradeSQLs[12][0] = "116";
        MRPTableUpgrader.materialTableUpgradeSQLs[12][1] = "FLeadTimeType";
        MRPTableUpgrader.materialTableUpgradeSQLs[12][2] = "INTEGER not null default 0 ";
        MRPTableUpgrader.materialTableUpgradeSQLs[13][0] = "116";
        MRPTableUpgrader.materialTableUpgradeSQLs[13][1] = "FChangeLeadTime";
        MRPTableUpgrader.materialTableUpgradeSQLs[13][2] = "INTEGER not null default 0 ";
        MRPTableUpgrader.materialTableUpgradeSQLs[14][0] = "116";
        MRPTableUpgrader.materialTableUpgradeSQLs[14][1] = "FChangeBatch";
        MRPTableUpgrader.materialTableUpgradeSQLs[14][2] = "INTEGER not null default 0 ";
        MRPTableUpgrader.materialTableUpgradeSQLs[15][0] = "116";
        MRPTableUpgrader.materialTableUpgradeSQLs[15][1] = "FisCanNotThrow";
        MRPTableUpgrader.materialTableUpgradeSQLs[15][2] = "INTEGER not null default 0 ";
        MRPTableUpgrader.materialTableUpgradeSQLs[16][0] = "116";
        MRPTableUpgrader.materialTableUpgradeSQLs[16][1] = "FisolateRules";
        MRPTableUpgrader.materialTableUpgradeSQLs[16][2] = "varchar(30) not null default 'ITEM_TRACKNO' ";
        MRPTableUpgrader.materialTableUpgradeSQLs[17][0] = "116";
        MRPTableUpgrader.materialTableUpgradeSQLs[17][1] = "FInvDetailId";
        MRPTableUpgrader.materialTableUpgradeSQLs[17][2] = "varchar(44) ";
        MRPTableUpgrader.materialTableUpgradeSQLs[18][0] = "116";
        MRPTableUpgrader.materialTableUpgradeSQLs[18][1] = "FPartitionQty";
        MRPTableUpgrader.materialTableUpgradeSQLs[18][2] = "INTEGER default 0 not null ";
        MRPTableUpgrader.materialTableUpgradeSQLs[19][0] = "116";
        MRPTableUpgrader.materialTableUpgradeSQLs[19][1] = "FMaxBatchQty";
        MRPTableUpgrader.materialTableUpgradeSQLs[19][2] = "NUMERIC(21,8) ";
        MRPTableUpgrader.materialTableUpgradeSQLs[20][0] = "116";
        MRPTableUpgrader.materialTableUpgradeSQLs[20][1] = "FBatchCycle";
        MRPTableUpgrader.materialTableUpgradeSQLs[20][2] = "INTEGER default 0 not null ";
        MRPTableUpgrader.materialTableUpgradeSQLs[21][0] = "117";
        MRPTableUpgrader.materialTableUpgradeSQLs[21][1] = "FIsSurplusDivert";
        MRPTableUpgrader.materialTableUpgradeSQLs[21][2] = "INTEGER default 0 not null ";
        MRPTableUpgrader.materialTableUpgradeSQLs[22][0] = "117";
        MRPTableUpgrader.materialTableUpgradeSQLs[22][1] = "FisComReqConsume";
        MRPTableUpgrader.materialTableUpgradeSQLs[22][2] = "INTEGER default 0 not null ";
        MRPTableUpgrader.materialTableUpgradeSQLs[23][0] = "119";
        MRPTableUpgrader.materialTableUpgradeSQLs[23][1] = "FPlanOrgUnit";
        MRPTableUpgrader.materialTableUpgradeSQLs[23][2] = "varchar(44) ";
        detailTableUpgradeSQLs = new String[47][3];
        MRPTableUpgrader.detailTableUpgradeSQLs[0][0] = "100";
        MRPTableUpgrader.detailTableUpgradeSQLs[0][1] = "FSrcBillEntrySeq";
        MRPTableUpgrader.detailTableUpgradeSQLs[0][2] = "INTEGER DEFAULT 0 NOT NULL ";
        MRPTableUpgrader.detailTableUpgradeSQLs[1][0] = "101";
        MRPTableUpgrader.detailTableUpgradeSQLs[1][1] = "FOutputType";
        MRPTableUpgrader.detailTableUpgradeSQLs[1][2] = "INTEGER default 0 not null";
        MRPTableUpgrader.detailTableUpgradeSQLs[2][0] = "102";
        MRPTableUpgrader.detailTableUpgradeSQLs[2][1] = "FProjectID";
        MRPTableUpgrader.detailTableUpgradeSQLs[2][2] = "varchar(44)";
        MRPTableUpgrader.detailTableUpgradeSQLs[3][0] = "102";
        MRPTableUpgrader.detailTableUpgradeSQLs[3][1] = "FTrackID";
        MRPTableUpgrader.detailTableUpgradeSQLs[3][2] = "varchar(44)";
        MRPTableUpgrader.detailTableUpgradeSQLs[4][0] = "103";
        MRPTableUpgrader.detailTableUpgradeSQLs[4][1] = "FBomID";
        MRPTableUpgrader.detailTableUpgradeSQLs[4][2] = "varchar(44)";
        MRPTableUpgrader.detailTableUpgradeSQLs[5][0] = "104";
        MRPTableUpgrader.detailTableUpgradeSQLs[5][1] = "FYield";
        MRPTableUpgrader.detailTableUpgradeSQLs[5][2] = " NUMERIC(21,8)";
        MRPTableUpgrader.detailTableUpgradeSQLs[6][0] = "105";
        MRPTableUpgrader.detailTableUpgradeSQLs[6][1] = "FAjustFlag";
        MRPTableUpgrader.detailTableUpgradeSQLs[6][2] = "INTEGER DEFAULT 0 NOT NULL";
        MRPTableUpgrader.detailTableUpgradeSQLs[7][0] = "105";
        MRPTableUpgrader.detailTableUpgradeSQLs[7][1] = "FAjustQty";
        MRPTableUpgrader.detailTableUpgradeSQLs[7][2] = "NUMERIC(21,8) DEFAULT 0 NOT NULL";
        MRPTableUpgrader.detailTableUpgradeSQLs[8][0] = "105";
        MRPTableUpgrader.detailTableUpgradeSQLs[8][1] = "FIsAjust";
        MRPTableUpgrader.detailTableUpgradeSQLs[8][2] = "INTEGER DEFAULT 0 NOT NULL ";
        MRPTableUpgrader.detailTableUpgradeSQLs[9][0] = "105";
        MRPTableUpgrader.detailTableUpgradeSQLs[9][1] = "FPriority";
        MRPTableUpgrader.detailTableUpgradeSQLs[9][2] = "INTEGER DEFAULT 0 NOT NULL ";
        MRPTableUpgrader.detailTableUpgradeSQLs[10][0] = "105";
        MRPTableUpgrader.detailTableUpgradeSQLs[10][1] = "FSID";
        MRPTableUpgrader.detailTableUpgradeSQLs[10][2] = "varchar(44)";
        MRPTableUpgrader.detailTableUpgradeSQLs[11][0] = "105";
        MRPTableUpgrader.detailTableUpgradeSQLs[11][1] = "FProjectNumber";
        MRPTableUpgrader.detailTableUpgradeSQLs[11][2] = "nvarchar(80)";
        MRPTableUpgrader.detailTableUpgradeSQLs[12][0] = "105";
        MRPTableUpgrader.detailTableUpgradeSQLs[12][1] = "FTrackNumber";
        MRPTableUpgrader.detailTableUpgradeSQLs[12][2] = "nvarchar(80)";
        MRPTableUpgrader.detailTableUpgradeSQLs[13][0] = "105";
        MRPTableUpgrader.detailTableUpgradeSQLs[13][1] = "FBProjectID";
        MRPTableUpgrader.detailTableUpgradeSQLs[13][2] = "varchar(44)";
        MRPTableUpgrader.detailTableUpgradeSQLs[14][0] = "105";
        MRPTableUpgrader.detailTableUpgradeSQLs[14][1] = "FBTrackID";
        MRPTableUpgrader.detailTableUpgradeSQLs[14][2] = "varchar(44)";
        MRPTableUpgrader.detailTableUpgradeSQLs[15][0] = "105";
        MRPTableUpgrader.detailTableUpgradeSQLs[15][1] = "FBProjectNumber";
        MRPTableUpgrader.detailTableUpgradeSQLs[15][2] = "nvarchar(80)";
        MRPTableUpgrader.detailTableUpgradeSQLs[16][0] = "105";
        MRPTableUpgrader.detailTableUpgradeSQLs[16][1] = "FBTrackNumber";
        MRPTableUpgrader.detailTableUpgradeSQLs[16][2] = "nvarchar(80)";
        MRPTableUpgrader.detailTableUpgradeSQLs[17][0] = "105";
        MRPTableUpgrader.detailTableUpgradeSQLs[17][1] = "FParentBomID";
        MRPTableUpgrader.detailTableUpgradeSQLs[17][2] = "varchar(44)";
        MRPTableUpgrader.detailTableUpgradeSQLs[18][0] = "105";
        MRPTableUpgrader.detailTableUpgradeSQLs[18][1] = "FIsDefaultTNO";
        MRPTableUpgrader.detailTableUpgradeSQLs[18][2] = "INTEGER DEFAULT 1 NOT NULL";
        MRPTableUpgrader.detailTableUpgradeSQLs[19][0] = "105";
        MRPTableUpgrader.detailTableUpgradeSQLs[19][1] = "FPeriod";
        MRPTableUpgrader.detailTableUpgradeSQLs[19][2] = "INTEGER DEFAULT 1 NOT NULL";
        MRPTableUpgrader.detailTableUpgradeSQLs[20][0] = "105";
        MRPTableUpgrader.detailTableUpgradeSQLs[20][1] = "FRePlanDATE";
        MRPTableUpgrader.detailTableUpgradeSQLs[20][2] = "DATETIME";
        MRPTableUpgrader.detailTableUpgradeSQLs[21][0] = "105";
        MRPTableUpgrader.detailTableUpgradeSQLs[21][1] = "FBizTypeID";
        MRPTableUpgrader.detailTableUpgradeSQLs[21][2] = "varchar(44)";
        MRPTableUpgrader.detailTableUpgradeSQLs[22][0] = "105";
        MRPTableUpgrader.detailTableUpgradeSQLs[22][1] = "FBaseStatus";
        MRPTableUpgrader.detailTableUpgradeSQLs[22][2] = "Integer not null default 0 ";
        MRPTableUpgrader.detailTableUpgradeSQLs[23][0] = "105";
        MRPTableUpgrader.detailTableUpgradeSQLs[23][1] = "FException4";
        MRPTableUpgrader.detailTableUpgradeSQLs[23][2] = "Integer not null default 0 ";
        MRPTableUpgrader.detailTableUpgradeSQLs[24][0] = "105";
        MRPTableUpgrader.detailTableUpgradeSQLs[24][1] = "FException5";
        MRPTableUpgrader.detailTableUpgradeSQLs[24][2] = "Integer not null default 0 ";
        MRPTableUpgrader.detailTableUpgradeSQLs[25][0] = "105";
        MRPTableUpgrader.detailTableUpgradeSQLs[25][1] = "FException6";
        MRPTableUpgrader.detailTableUpgradeSQLs[25][2] = "Integer not null default 0 ";
        MRPTableUpgrader.detailTableUpgradeSQLs[26][0] = "105";
        MRPTableUpgrader.detailTableUpgradeSQLs[26][1] = "FException7";
        MRPTableUpgrader.detailTableUpgradeSQLs[26][2] = "Integer not null default 0 ";
        MRPTableUpgrader.detailTableUpgradeSQLs[27][0] = "106";
        MRPTableUpgrader.detailTableUpgradeSQLs[27][1] = "FBomType";
        MRPTableUpgrader.detailTableUpgradeSQLs[27][2] = "Integer not null default 0 ";
        MRPTableUpgrader.detailTableUpgradeSQLs[28][0] = "108";
        MRPTableUpgrader.detailTableUpgradeSQLs[28][1] = "FSPeriod";
        MRPTableUpgrader.detailTableUpgradeSQLs[28][2] = "Integer not null default 0 ";
        MRPTableUpgrader.detailTableUpgradeSQLs[29][0] = "111";
        MRPTableUpgrader.detailTableUpgradeSQLs[29][1] = "FSSR";
        MRPTableUpgrader.detailTableUpgradeSQLs[29][2] = "NUMERIC(21,8) not null default 0 ";
        MRPTableUpgrader.detailTableUpgradeSQLs[30][0] = "112";
        MRPTableUpgrader.detailTableUpgradeSQLs[30][1] = "FSupplyType";
        MRPTableUpgrader.detailTableUpgradeSQLs[30][2] = "Integer not null default 0  ";
        MRPTableUpgrader.detailTableUpgradeSQLs[31][0] = "112";
        MRPTableUpgrader.detailTableUpgradeSQLs[31][1] = "FRequireMentID";
        MRPTableUpgrader.detailTableUpgradeSQLs[31][2] = " varchar(44) ";
        MRPTableUpgrader.detailTableUpgradeSQLs[32][0] = "113";
        MRPTableUpgrader.detailTableUpgradeSQLs[32][1] = "FIsDirectTransport";
        MRPTableUpgrader.detailTableUpgradeSQLs[32][2] = "Integer not null default 0  ";
        MRPTableUpgrader.detailTableUpgradeSQLs[33][0] = "116";
        MRPTableUpgrader.detailTableUpgradeSQLs[33][1] = "FUnitQty";
        MRPTableUpgrader.detailTableUpgradeSQLs[33][2] = "NUMERIC(21,8) not null default 1 ";
        MRPTableUpgrader.detailTableUpgradeSQLs[34][0] = "116";
        MRPTableUpgrader.detailTableUpgradeSQLs[34][1] = "FReplaceVersionID";
        MRPTableUpgrader.detailTableUpgradeSQLs[34][2] = "varchar(44) ";
        MRPTableUpgrader.detailTableUpgradeSQLs[35][0] = "116";
        MRPTableUpgrader.detailTableUpgradeSQLs[35][1] = "FReplaceVersionEntryID";
        MRPTableUpgrader.detailTableUpgradeSQLs[35][2] = "varchar(44) ";
        MRPTableUpgrader.detailTableUpgradeSQLs[36][0] = "116";
        MRPTableUpgrader.detailTableUpgradeSQLs[36][1] = "FSaleOrderID";
        MRPTableUpgrader.detailTableUpgradeSQLs[36][2] = "varchar(44) ";
        MRPTableUpgrader.detailTableUpgradeSQLs[37][0] = "116";
        MRPTableUpgrader.detailTableUpgradeSQLs[37][1] = "FSaleOrderEntryID";
        MRPTableUpgrader.detailTableUpgradeSQLs[37][2] = "varchar(44) ";
        MRPTableUpgrader.detailTableUpgradeSQLs[38][0] = "116";
        MRPTableUpgrader.detailTableUpgradeSQLs[38][1] = "FSaleOrderNumber";
        MRPTableUpgrader.detailTableUpgradeSQLs[38][2] = "nvarchar(80) ";
        MRPTableUpgrader.detailTableUpgradeSQLs[39][0] = "116";
        MRPTableUpgrader.detailTableUpgradeSQLs[39][1] = "FSaleOrderEntrySeq";
        MRPTableUpgrader.detailTableUpgradeSQLs[39][2] = "INTEGER not null default 0 ";
        MRPTableUpgrader.detailTableUpgradeSQLs[40][0] = "116";
        MRPTableUpgrader.detailTableUpgradeSQLs[40][1] = "FisCanNotThrow";
        MRPTableUpgrader.detailTableUpgradeSQLs[40][2] = "INTEGER not null default 0 ";
        MRPTableUpgrader.detailTableUpgradeSQLs[41][0] = "116";
        MRPTableUpgrader.detailTableUpgradeSQLs[41][1] = "FMrpSeq";
        MRPTableUpgrader.detailTableUpgradeSQLs[41][2] = "varchar(100) ";
        MRPTableUpgrader.detailTableUpgradeSQLs[42][0] = "117";
        MRPTableUpgrader.detailTableUpgradeSQLs[42][1] = "FHierarchyCode";
        MRPTableUpgrader.detailTableUpgradeSQLs[42][2] = "varchar(500) ";
        MRPTableUpgrader.detailTableUpgradeSQLs[43][0] = "117";
        MRPTableUpgrader.detailTableUpgradeSQLs[43][1] = "Fexception8";
        MRPTableUpgrader.detailTableUpgradeSQLs[43][2] = "INTEGER default 0 not null ";
        MRPTableUpgrader.detailTableUpgradeSQLs[44][0] = "117";
        MRPTableUpgrader.detailTableUpgradeSQLs[44][1] = "FHasSplit";
        MRPTableUpgrader.detailTableUpgradeSQLs[44][2] = "INTEGER default 0 not null ";
        MRPTableUpgrader.detailTableUpgradeSQLs[45][0] = "118";
        MRPTableUpgrader.detailTableUpgradeSQLs[45][1] = "FDesc64";
        MRPTableUpgrader.detailTableUpgradeSQLs[45][2] = "varchar(255) ";
        MRPTableUpgrader.detailTableUpgradeSQLs[46][0] = "120";
        MRPTableUpgrader.detailTableUpgradeSQLs[46][1] = "FIsMatch";
        MRPTableUpgrader.detailTableUpgradeSQLs[46][2] = "Integer not null default 0";
    }
}

