/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.MaterialRangeEnum;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPClearUpResultTable;
import com.kingdee.eas.mm.planning.app.mrp.MRPDynamicTableManager;
import com.kingdee.eas.mm.planning.app.mrp.MRPRunningTablesInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPStrategySelectGenerator;
import java.util.List;

public class MRPUpdateResultTable
extends MRPClearUpResultTable {
    private int deleteStrategy;

    @Override
    protected String getStepDesc() {
        return "update result table";
    }

    @Override
    protected Object innerExecute(MRPCalcParam runParam) throws EASBizException, BOSException {
        if (!runParam.isNeedUpdateResultTable()) {
            return null;
        }
        List resultTableList = MRPDynamicTableManager.getTableName(runParam.getCtx(), runParam.getStorageOrgUnitID(), runParam.getPlanVersionID(), runParam.isTransform());
        String materialTable = ((MRPRunningTablesInfo)resultTableList.get(0)).getTableName();
        String detailTable = ((MRPRunningTablesInfo)resultTableList.get(1)).getTableName();
        this.updateResultTable(runParam, materialTable, detailTable, resultTableList);
        return null;
    }

    protected void updateResultTable(MRPCalcParam runParam, String materialTable, String detailTable, List resultTableList) throws BOSException, MRPException {
        String materialRangeOld = ((MRPRunningTablesInfo)resultTableList.get(0)).getMaterialRange();
        this.deleteStrategy = MRPStrategySelectGenerator.updateResultTableDeleteStrategy(runParam, materialRangeOld);
        if (this.deleteStrategy > 0) {
            if (this.deleteStrategy == 1) {
                MaterialRangeEnum range = runParam.getRunLogInfo().getMateriaRange();
                if (range.equals((Object)MaterialRangeEnum.PUR)) {
                    this.updateResult4Pur(runParam, materialTable, detailTable);
                } else if (range.equals((Object)MaterialRangeEnum.CUSTOM)) {
                    this.updateResult4Custom(runParam, materialTable, detailTable);
                }
            } else if (this.deleteStrategy == 2) {
                this.updateResult4MpsOrMrp(runParam, materialTable, detailTable, 2);
            } else if (this.deleteStrategy == 3) {
                this.updateResult4MpsOrMrp(runParam, materialTable, detailTable, 3);
            }
        }
    }

    protected void updateResult4Custom(MRPCalcParam runParam, String materialTable, String detailTable) throws BOSException, MRPException {
        String materialTempTable = runParam.getMaterialTableName();
        String detailTempTable = runParam.getMrpCalcDetailTableName();
        StringBuffer sql4Material = new StringBuffer();
        StringBuffer sql4Detail = new StringBuffer();
        String idStr = SQLUtil.arrayToString((Object[])runParam.getMaterialRangeIds());
        sql4Detail.append("delete from ").append(detailTable).append(" where FMaterialID in (").append(idStr).append(")");
        sql4Material.append("delete from ").append(materialTable).append(" where FMaterialID in (").append(idStr).append(")");
        SQLUtils.execute((Context)runParam.getCtx(), (String)sql4Detail.toString());
        SQLUtils.execute((Context)runParam.getCtx(), (String)sql4Material.toString());
        sql4Material.setLength(0);
        sql4Detail.setLength(0);
        sql4Material.append("insert into ").append(materialTable).append(" (").append(MRPDynamicTableManager.getMaterialTableFields(null)).append(") ").append(" select ").append(MRPDynamicTableManager.getMaterialTableFields(null)).append(" from ").append(materialTempTable).append(" where FMaterialID in (").append(idStr).append(")");
        sql4Detail.append("insert into ").append(detailTable).append(" (").append(MRPDynamicTableManager.getDetailTableFields(null)).append(") ").append(" select ").append(MRPDynamicTableManager.getDetailTableFields(null)).append(" from ").append(detailTempTable).append(" where FMaterialID in (").append(idStr).append(")");
        SQLUtils.execute((Context)runParam.getCtx(), (String)sql4Detail.toString());
        SQLUtils.execute((Context)runParam.getCtx(), (String)sql4Material.toString());
    }

    private void updateResult4Pur(MRPCalcParam runParam, String materialTable, String detailTable) throws BOSException, MRPException {
        String materialTempTable = runParam.getMaterialTableName();
        String detailTempTable = runParam.getMrpCalcDetailTableName();
        StringBuffer sql4Material = new StringBuffer();
        StringBuffer sql4Detail = new StringBuffer();
        sql4Detail.append("delete from ").append(detailTable).append(" where FMaterialID in (select FMaterialID from ").append(materialTempTable).append(" where FMaterialAttr=").append(10040).append(")");
        sql4Material.append("delete from ").append(materialTable).append(" where FMaterialID in (select FMaterialID from ").append(materialTempTable).append(" where FMaterialAttr=").append(10040).append(")");
        SQLUtils.execute((Context)runParam.getCtx(), (String)sql4Detail.toString());
        SQLUtils.execute((Context)runParam.getCtx(), (String)sql4Material.toString());
        sql4Material.setLength(0);
        sql4Detail.setLength(0);
        sql4Material.append("insert into ").append(materialTable).append(" (").append(MRPDynamicTableManager.getMaterialTableFields(null)).append(") ").append(" select ").append(MRPDynamicTableManager.getMaterialTableFields(null)).append(" from ").append(materialTempTable).append(" where FMaterialAttr=").append(10040);
        sql4Detail.append("insert into ").append(detailTable).append(" (").append(MRPDynamicTableManager.getDetailTableFields(null)).append(") ").append(" select ").append(MRPDynamicTableManager.getDetailTableFields("t1")).append(" from ").append(detailTempTable).append(" t1,").append(materialTempTable).append(" t2 where FMaterialAttr=").append(10040).append(" and t1.FMaterialID = t2.FMaterialID");
        SQLUtils.execute((Context)runParam.getCtx(), (String)sql4Detail.toString());
        SQLUtils.execute((Context)runParam.getCtx(), (String)sql4Material.toString());
    }

    private void updateResult4MpsOrMrp(MRPCalcParam runParam, String materialTable, String detailTable, int type) throws BOSException, MRPException {
        String materialTempTable = runParam.getMaterialTableName();
        String detailTempTable = runParam.getMrpCalcDetailTableName();
        StringBuffer sql4Material = new StringBuffer();
        StringBuffer sql4Detail = new StringBuffer();
        sql4Detail.append("delete from ").append(detailTable).append(" where exists (select 1 from ").append(materialTempTable).append(" m where (").append(detailTable).append(".FMaterialID=m.FMaterialID ) ").append(" and m.FplanningMode=").append(type).append(")");
        sql4Material.append("delete from ").append(materialTable).append(" where exists (select 1 from ").append(materialTempTable).append(" m where m.FplanningMode=").append(type).append(" and ").append(materialTable).append(".FMaterialID=m.FMaterialID ").append(")");
        SQLUtils.execute((Context)runParam.getCtx(), (String)sql4Detail.toString());
        SQLUtils.execute((Context)runParam.getCtx(), (String)sql4Material.toString());
        sql4Material.setLength(0);
        sql4Detail.setLength(0);
        sql4Material.append("insert into ").append(materialTable).append(" (").append(MRPDynamicTableManager.getMaterialTableFields(null)).append(") ").append(" select ").append(MRPDynamicTableManager.getMaterialTableFields(null)).append(" from ").append(materialTempTable);
        sql4Detail.append("insert into ").append(detailTable).append(" (").append(MRPDynamicTableManager.getDetailTableFields(null)).append(") ").append(" select ").append(MRPDynamicTableManager.getDetailTableFields("d")).append(" from ").append(detailTempTable).append(" d ").append(" inner join ").append(materialTempTable).append(" m  on d.FMaterialId=m.FMaterialId");
        SQLUtils.execute((Context)runParam.getCtx(), (String)sql4Detail.toString());
        SQLUtils.execute((Context)runParam.getCtx(), (String)sql4Material.toString());
    }
}

