/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.app.CreateTempTableResult;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPDate;
import com.kingdee.eas.mm.planning.app.mrp.MRPMaterialDataInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPResource;
import com.kingdee.eas.mm.planning.app.mrp.MRPStep;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public final class MRPUtil {
    protected static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.mrp.MRPUtil");

    public MRPUtil() {
        if (MRPStep.isMoreInfo.booleanValue()) {
            logger.setLevel(Level.INFO);
        } else {
            logger.setLevel(Level.ERROR);
        }
    }

    public static Calendar createCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static boolean dateEquals(Calendar d1, Calendar d2) {
        return d1.get(1) == d2.get(1) && d1.get(2) == d2.get(2) && d1.get(5) == d2.get(5);
    }

    public static Calendar copyDate(Calendar d1) {
        Calendar d2 = MRPUtil.createCalendar();
        d2.set(d1.get(1), d1.get(2), d1.get(5));
        return d2;
    }

    public static MRPDate copyDate(MRPDate d1) {
        Calendar date = MRPUtil.copyDate(d1.getDate());
        MRPDate mrpDate = new MRPDate();
        mrpDate.setDate(date);
        mrpDate.setInCalendar(d1.getInCalendar());
        mrpDate.setSourceDate(d1.getSourceDate());
        mrpDate.setCalendarID(d1.getCalendarID());
        mrpDate.setPeriod(d1.getPeriod());
        return mrpDate;
    }

    public static void logBegin(Date beginTime, String msg) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)msg);
        }
    }

    public static void logEnd(Context ctx, Date beginTime, String msg) {
        if (logger.isInfoEnabled()) {
            Date endTime = new Date();
            long runSecs = (endTime.getTime() - beginTime.getTime()) / 1000L;
            logger.info((Object)(msg + "," + MRPResource.getString(ctx, "SYM_RUNTIMES") + "\uff1a" + String.valueOf(runSecs) + "s"));
        }
    }

    public static Date formatDate(Date inDate, String hmsvalue) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String str = null;
        str = MRPUtil.dateToString(inDate, "yyyy-MM-dd") + " " + hmsvalue;
        try {
            return format.parse(str);
        }
        catch (ParseException e) {
            return inDate;
        }
    }

    public static String dateToString(Date inDate, String formatstring) {
        SimpleDateFormat sf = new SimpleDateFormat(formatstring);
        return sf.format(inDate);
    }

    public static String dateToString(Date inDate) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sf.format(inDate);
    }

    public static String getResourceValue(String name) {
        return name;
    }

    public static String getBosType() {
        return "F94043EF";
    }

    public static int executeUpdate(Context ctx, String sql, Object[] params) throws BOSException {
        return SQLUtils.execute((Context)ctx, (String)sql, (Object[])params);
    }

    public static int executeUpdate(Context ctx, String sql) throws BOSException {
        return SQLUtils.execute((Context)ctx, (String)sql);
    }

    public static String getBizNumber(Context ctx, IObjectValue bizObject, String orgID) throws BOSException, EASBizException {
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        RuleStatus ruleStatus = codingRuleManager.getRuleStatus(bizObject, orgID);
        String number = null;
        if (ruleStatus.isExist()) {
            number = codingRuleManager.getNumber(bizObject, orgID);
        }
        return number;
    }

    public static CreateTempTableResult executeCreateAsSelectInto(Context ctx, String sql, SqlParams parameters) throws BOSException {
        Connection con = null;
        try {
            CreateTempTableResult result;
            con = EJBFactory.getConnection((Context)ctx);
            CreateTempTableResult createTempTableResult = result = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)sql, (SqlParams)parameters, (Connection)con);
            return createTempTableResult;
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("SQL: " + sql));
            throw new SQLDataException(e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            com.kingdee.util.db.SQLUtils.cleanup((Connection)con);
        }
    }

    public static void releaseTempTable(MRPCalcParam runParam) throws MRPException, BOSException {
        TempTablePool pool = TempTablePool.getInstance((Context)runParam.getCtx(true));
        if (runParam.getMrpPlanOrder() != null) {
            pool.releaseTable(runParam.getMrpPlanOrder());
            pool.releaseTable(runParam.getMrpPlanOrderEntry());
        }
        if (runParam.getCalendarTable() != null) {
            pool.releaseTable(runParam.getCalendarTable());
        }
    }

    public static BigDecimal calculateDemandQty(BigDecimal standardQty, BigDecimal scrapRate, int scrapExpression, int precision, boolean isScrapRate) {
        BigDecimal demandQty = standardQty;
        if (isScrapRate) {
            scrapRate = scrapRate.divide(new BigDecimal("100.00"), precision, 2);
            demandQty = 10610 == scrapExpression ? standardQty.divide(new BigDecimal("1.00").subtract(scrapRate), precision, 2) : standardQty.multiply(new BigDecimal("1.00").add(scrapRate)).setScale(precision, 2);
        }
        return demandQty;
    }

    public static BigDecimal calculateStandardQty(BigDecimal demandQty, BigDecimal scrapRate, int scrapExpression, int precision, boolean isScrapRate) {
        BigDecimal standardQty = demandQty;
        if (isScrapRate) {
            scrapRate = scrapRate.divide(new BigDecimal("100.00"), precision, 2);
            standardQty = 10610 == scrapExpression ? demandQty.multiply(new BigDecimal("1.00").subtract(scrapRate)).setScale(precision, 2) : demandQty.divide(new BigDecimal("1.00").add(scrapRate), precision, 2);
        }
        return standardQty;
    }

    public static BigDecimal calculateProdQty(BigDecimal baseQty, MRPMaterialDataInfo materialDataInfo) {
        return baseQty.divide(materialDataInfo.getConvertRate(), materialDataInfo.getProdQtyPrc(), 4);
    }

    public static String getInsert(MRPCalcParam runParam) throws MRPException, BOSException {
        String dbType = runParam.getCtx().get((Object)"dbType").toString();
        String ret = "INSERT ";
        if (dbType.startsWith("oracle")) {
            ret = ret + " /*+ APPEND */ ".intern();
        }
        ret = ret + " INTO ";
        return ret;
    }
}

