/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.release;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.mm.basedata.IPlannedOrderPutInParam;
import com.kingdee.eas.mm.basedata.PlannedOrderPutInParamFactory;
import com.kingdee.eas.mm.basedata.PlannedOrderPutInParamInfo;
import com.kingdee.eas.mm.common.MMCommonException;
import com.kingdee.eas.mm.common.app.BizCommand;
import com.kingdee.eas.mm.common.app.CommonUtils;
import com.kingdee.eas.mm.planning.MappingReturnTypeEnum;
import com.kingdee.eas.mm.planning.PlanOrderException;
import com.kingdee.eas.mm.planning.PlannedOrderCollection;
import com.kingdee.eas.mm.planning.PlannedOrderInfo;
import com.kingdee.eas.mm.planning.app.release.ReleaseUtil;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractPlanOrderTransform
extends BizCommand {
    private String storageOrgUnitId = null;
    private String botpRuleId = null;
    private Set planOrderSet = null;
    private String temp_id = null;
    private Map resultMap = null;

    public AbstractPlanOrderTransform(Context ctx) {
        super(ctx);
    }

    public String getBotpRuleId() {
        return this.botpRuleId;
    }

    public void setBotpRuleId(String botpRuleId) {
        this.botpRuleId = botpRuleId;
    }

    public String getStorageOrgUnitId() {
        return this.storageOrgUnitId;
    }

    public void setStorageOrgUnitId(String storageOrgUnitId) {
        this.storageOrgUnitId = storageOrgUnitId;
    }

    public Set getPlanOrderSet() {
        return this.planOrderSet;
    }

    public void setPlanOrderSet(Set planOrderSet) {
        this.planOrderSet = planOrderSet;
    }

    public Map getResultMap() {
        return this.resultMap;
    }

    public void setResultMap(Map resultMap) {
        this.resultMap = resultMap;
    }

    public String getTemp_id() {
        return this.temp_id;
    }

    public void setTemp_id(String temp_id) {
        this.temp_id = temp_id;
    }

    public Object doing(Object inParam) throws BOSException, EASBizException {
        Map map = (Map)inParam;
        Set successPOs = (Set)map.get("successPOs");
        List failedDestBillIds = (List)map.get("failedDestBillIds");
        List successDestBillIds = (List)map.get("successDestBillIds");
        logger.info((Object)"doBeforeTransform");
        this.doBeforeTransform();
        logger.info((Object)"doTransform");
        BTPTransformResult result = this.doTransform();
        if (result != null) {
            logger.info((Object)"doAfterTransform");
            this.doAfterTransform(result.getBills(), successPOs, failedDestBillIds, successDestBillIds);
        }
        logger.info((Object)"doing.end");
        return null;
    }

    public void transform(Set successPOs, List failedDestBillIds, List successDestBillIds) throws EASBizException, BOSException {
        HashMap map = new HashMap();
        map.put("successPOs", successPOs);
        map.put("failedDestBillIds", failedDestBillIds);
        map.put("successDestBillIds", successDestBillIds);
        this.doing(map);
    }

    protected void doBeforeTransform() throws EASBizException, BOSException {
        this.doChecks();
    }

    protected void doChecks() throws EASBizException, BOSException {
        this.checkPermission();
        this.checkBotpRule();
        this.checkAdditionalItems();
    }

    protected BTPTransformResult doTransform() {
        logger.info((Object)"ReleaseUtil.set2Collection");
        PlannedOrderCollection poCol = ReleaseUtil.set2Collection(this.planOrderSet);
        if (poCol == null || poCol.size() == 0) {
            return null;
        }
        BTPTransformResult result = null;
        try {
            logger.info((Object)"CommonUtils.mapppingToBills2");
            result = CommonUtils.mapppingToBills2((Context)this.ctx, null, null, (BOSObjectType)this.getSrcBOSType(), (BOSObjectType)this.getDestBOSType(), (String)this.getBotpRuleId(), (IObjectCollection)poCol, (boolean)false);
        }
        catch (Exception e) {
            for (int i = 0; i < poCol.size(); ++i) {
                this.resultMap.put(poCol.get(i).getNumber(), e.getMessage());
            }
            this.planOrderSet.clear();
        }
        return result;
    }

    protected String getBotpRuleName() {
        return null;
    }

    protected void checkAdditionalItems() throws EASBizException, BOSException {
    }

    protected String getDestBillMainOrgUnitId() throws EASBizException, BOSException {
        return this.storageOrgUnitId;
    }

    protected abstract void doAfterTransform(IObjectCollection var1, Set var2, List var3, List var4) throws EASBizException, BOSException;

    protected abstract BOSObjectType getDestBOSType();

    protected abstract String getDestBillPermission();

    protected abstract IObjectValue getDestBillInfo();

    private BOSObjectType getSrcBOSType() {
        return BOSObjectType.create((String)"B844D41F");
    }

    private BOTMappingInfo getBotpRule() throws BOSException {
        String botpRuleName;
        BOTMappingInfo botpRule = null;
        String destBOSType = this.getDestBOSType().toString();
        botpRule = this.getBotpRuleByStorage(destBOSType, botpRuleName = this.getBotpRuleName());
        if (botpRule == null) {
            botpRule = this.getDefaultBotpRule(destBOSType, botpRuleName);
        }
        return botpRule;
    }

    private BOTMappingInfo getBotpRuleByStorage(String destBOSType, String botpRuleName) throws BOSException {
        BOTMappingInfo botpRule = null;
        PlannedOrderPutInParamInfo plann = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.storageOrgUnitId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bostype", (Object)destBOSType, CompareType.EQUALS));
        if (botpRuleName != null) {
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)botpRuleName, CompareType.EQUALS));
        }
        view.setFilter(filter);
        IPlannedOrderPutInParam iplannedorderputin = PlannedOrderPutInParamFactory.getLocalInstance((Context)this.ctx);
        CoreBaseCollection collection = iplannedorderputin.getCollection(view);
        if (collection != null && collection.size() > 0) {
            plann = (PlannedOrderPutInParamInfo)collection.get(0);
            botpRule = plann.getBotpRules();
        }
        return botpRule;
    }

    private BOTMappingInfo getDefaultBotpRule(String destBOSType, String botpRuleName) throws BOSException {
        BOTMappingInfo botpRule = null;
        PlannedOrderPutInParamInfo plann = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("simpleName", (Object)"9999", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bostype", (Object)destBOSType, CompareType.EQUALS));
        if (botpRuleName != null) {
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)botpRuleName, CompareType.EQUALS));
        }
        view.setFilter(filter);
        IPlannedOrderPutInParam iplannedorderputin = PlannedOrderPutInParamFactory.getLocalInstance((Context)this.ctx);
        CoreBaseCollection collection = iplannedorderputin.getCollection(view);
        if (collection != null && collection.size() > 0) {
            plann = (PlannedOrderPutInParamInfo)collection.get(0);
            botpRule = plann.getBotpRules();
        }
        return botpRule;
    }

    private void checkBotpRule() throws EASBizException, BOSException {
        BOTMappingInfo botpRule = this.getBotpRule();
        if (botpRule == null) {
            throw new BOSException("botpRuleId is null!");
        }
        this.setBotpRuleId(botpRule.getId().toString());
        IBOTMapping ibt = BOTMappingFactory.getLocalInstance((Context)this.ctx);
        BOTMappingInfo botMappingInfo = null;
        Object exception = null;
        try {
            botMappingInfo = ibt.getBOTMappingInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getBotpRuleId())));
        }
        catch (Exception e) {
            exception = new MMCommonException(MMCommonException.BOTPERROR);
            ReleaseUtil.setResultMap(this.planOrderSet, this.resultMap, (Exception)exception);
            return;
        }
        if (!botMappingInfo.getExtRule().isIsEffected()) {
            exception = new PlanOrderException(PlanOrderException.RELEASE_BOTP_NOT_EFFECTED);
            ReleaseUtil.setResultMap(this.planOrderSet, this.resultMap, (Exception)exception);
            return;
        }
        if (botMappingInfo.getIsShowEditUI() == 0) {
            exception = new MMCommonException(MMCommonException.BOTP_CANNOT_SHOW_NONE);
            ReleaseUtil.setResultMap(this.planOrderSet, this.resultMap, (Exception)exception);
            return;
        }
    }

    public void checkPermission() throws EASBizException, BOSException {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)this.ctx);
        if (userInfo.getType() != UserType.PERSON) {
            ReleaseUtil.cleanSet(this.planOrderSet, this.resultMap, MappingReturnTypeEnum.CURR_OPERATOR_NOT_CLERK);
            return;
        }
        IPermission ipermission = PermissionFactory.getLocalInstance((Context)this.ctx);
        PlannedOrderInfo plannedInfo = null;
        Object[] poInfos = this.planOrderSet.toArray();
        plannedInfo = (PlannedOrderInfo)poInfos[0];
        ObjectUuidPK userPK = new ObjectUuidPK(this.ctx.getCaller().toString());
        ObjectUuidPK orgPK = new ObjectUuidPK(this.getDestBillMainOrgUnitId());
        try {
            ipermission.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, this.getDestBillPermission());
        }
        catch (Exception e) {
            ReleaseUtil.cleanSet(this.planOrderSet, this.resultMap, MappingReturnTypeEnum.NO_NEW_PERRMISSION);
            return;
        }
        boolean isExistNumber = CommonUtils.existCodingRule((Context)this.ctx, (IObjectValue)this.getDestBillInfo(), (String)this.getDestBillMainOrgUnitId());
        if (!isExistNumber) {
            ReleaseUtil.cleanSet(this.planOrderSet, this.resultMap, MappingReturnTypeEnum.NO_CODINGRULE);
        }
    }

    protected String getResource(String key, String[] params) {
        if (params == null) {
            params = new String[]{};
        }
        return ResourceUtils.getMessage((String)"com.kingdee.eas.mm.planning.PlannedOrderResource", (String)key, (String[])params);
    }
}

