/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.release;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingCollection;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.batchaction.ActionResult;
import com.kingdee.eas.framework.batchaction.ActionResultEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.app.MMLogger;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.planning.PlanOrderException;
import com.kingdee.eas.mm.planning.PlannedOrderCollection;
import com.kingdee.eas.mm.planning.PlannedOrderInfo;
import com.kingdee.eas.mm.planning.app.release.AbstractPlanOrderTransform;
import com.kingdee.eas.mm.planning.app.release.ReleaseUtil;
import com.kingdee.eas.mm.planning.app.release.batch.PlanningOrderReleasePurReq;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.pur.IPurRequest;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PlanOrder2PurRequest
extends AbstractPlanOrderTransform {
    private static Logger logger = MMLogger.getLogger();

    public PlanOrder2PurRequest(Context ctx) {
        super(ctx);
    }

    @Override
    protected BOSObjectType getDestBOSType() {
        return BOSObjectType.create((String)"25428F2E");
    }

    @Override
    protected IObjectValue getDestBillInfo() {
        return new PurRequestInfo();
    }

    @Override
    protected String getDestBillPermission() {
        return "purreq_addnew";
    }

    @Override
    protected void doAfterTransform(IObjectCollection billCollection, Set successPOs, List failedDestBillIds, List successDestBillIds) throws EASBizException, BOSException {
        logger.info((Object)"ReleaseUtil.set2Collection(getPlanOrderSet()");
        PlannedOrderCollection poCollection = ReleaseUtil.set2Collection(this.getPlanOrderSet());
        PurRequestInfo reqInfo = null;
        PlannedOrderInfo planned = poCollection.get(0);
        SelectorItemCollection _ = new SelectorItemCollection();
        _.add(new SelectorItemInfo("baseCurrency.precision"));
        CompanyOrgUnitInfo comInfo = ReleaseUtil.getCompanyOrgUnitInfo(this.ctx, planned.getStorageOrgUnit().getId().toString());
        MaterialPurchasingCollection materialPurcon = null;
        String plannedId = null;
        BigDecimal thisTotalReleaseQty = null;
        BigDecimal thisTotalReleasebaseQty = null;
        this.ctx.put((Object)"CONTEXT_KEY_ISBATCHACTION", (Object)true);
        IPurRequest iPurRequest = PurRequestFactory.getLocalInstance((Context)this.ctx);
        logger.info((Object)("doAfterTransform.[for (int i = 0; i < " + String.valueOf(billCollection.size()) + "; i++)]"));
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)this.ctx);
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[billCollection.size()];
        Object entry = null;
        HashMap<String, String> idplannedTopurreq = new HashMap<String, String>();
        ArrayList<String> purreqids = new ArrayList<String>();
        PurRequestInfo[] purRequestInfos = new PurRequestInfo[billCollection.size()];
        HashSet<String> matSet = new HashSet<String>();
        HashSet<String> storageSet = new HashSet<String>();
        HashSet<String> purOrgSet = new HashSet<String>();
        long time00 = System.currentTimeMillis();
        for (int i = 0; i < billCollection.size(); ++i) {
            reqInfo = (PurRequestInfo)billCollection.getObject(i);
            for (int j = 0; j < reqInfo.getEntries().size(); ++j) {
                planned = ReleaseUtil.getPlannedOrderInfo(poCollection, plannedId);
                matSet.add(reqInfo.getEntries().get(j).getMaterial().getId().toString());
                storageSet.add(planned.getStorageOrgUnit().getId().toString());
            }
        }
        FilterInfo matFilter = new FilterInfo();
        matFilter.getFilterItems().add(new FilterItemInfo("material.id", matSet, CompareType.INCLUDE));
        matFilter.getFilterItems().add(new FilterItemInfo("orgUnit.id", storageSet, CompareType.INCLUDE));
        EntityViewInfo entiView = new EntityViewInfo();
        entiView.setFilter(matFilter);
        MaterialPlanCollection materialPlanCollection = MaterialPlanFactory.getLocalInstance((Context)this.ctx).getMaterialPlanCollection(entiView);
        HashMap<String, PurchaseOrgUnitInfo> purchaseOrgMap = new HashMap<String, PurchaseOrgUnitInfo>();
        MaterialPlanInfo materialPlanInfo = null;
        HashMap<String, PurchaseOrgUnitInfo> purOrgMap2 = new HashMap<String, PurchaseOrgUnitInfo>();
        PurchaseOrgUnitInfo purOrg = null;
        int size = materialPlanCollection.size();
        for (int i = 0; i < size; ++i) {
            materialPlanInfo = materialPlanCollection.get(i);
            String key = materialPlanInfo.getMaterial().getId().toString() + materialPlanInfo.getOrgUnit().getId().toString();
            if (materialPlanInfo.getPurOrg() != null) {
                purOrgSet.add(materialPlanInfo.getPurOrg().getId().toString());
                purchaseOrgMap.put(key, materialPlanInfo.getPurOrg());
                continue;
            }
            if (purOrgMap2.containsKey(materialPlanInfo.getOrgUnit().getId().toString())) {
                purOrg = (PurchaseOrgUnitInfo)purOrgMap2.get(materialPlanInfo.getOrgUnit().getId().toString());
            } else {
                purOrg = SCMBillCommonFacadeFactory.getLocalInstance((Context)this.ctx).getPurchaseByStorageOrg(materialPlanInfo.getOrgUnit().getId().toString());
                purOrgMap2.put(materialPlanInfo.getOrgUnit().getId().toString(), purOrg);
            }
            purOrgSet.add(purOrg.getId().toString());
            purchaseOrgMap.put(key, purOrg);
        }
        matFilter = new FilterInfo();
        matFilter.getFilterItems().add(new FilterItemInfo("material.id", matSet, CompareType.INCLUDE));
        matFilter.getFilterItems().add(new FilterItemInfo("orgUnit.id", purOrgSet, CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(matFilter);
        materialPurcon = MaterialPurchasingFactory.getLocalInstance((Context)this.ctx).getMaterialPurchasingCollection(viewInfo);
        MaterialPurchasingInfo materialPurInfo = null;
        HashMap<String, MaterialPurchasingInfo> materialPurMap = new HashMap<String, MaterialPurchasingInfo>();
        int size2 = materialPurcon.size();
        for (int i = 0; i < size2; ++i) {
            materialPurInfo = materialPurcon.get(i);
            materialPurMap.put(materialPurInfo.getMaterial().getId().toString() + materialPurInfo.getOrgUnit().getId().toString(), materialPurInfo);
        }
        long time01 = System.currentTimeMillis();
        logger.error((Object)("#############\u6295\u653e\u540e\u53d6\u7269\u6599\u8d44\u6599\uff1a" + (time01 - time00)));
        HashMap personAdminOrgMap = new HashMap();
        HashMap unitCacheMap = new HashMap();
        int size3 = billCollection.size();
        for (int i = 0; i < size3; ++i) {
            reqInfo = (PurRequestInfo)billCollection.getObject(i);
            purreqids.add(reqInfo.getId().toString());
            purOrg = null;
            MeasureUnitInfo qtyUnit = null;
            BigDecimal qty = null;
            BigDecimal _qty = SysConstant.BIGZERO;
            BigDecimal _price = SysConstant.BIGZERO;
            BigDecimal _amount = SysConstant.BIGZERO;
            BigDecimal _sumAmount = SysConstant.BIGZERO;
            int scale = 4;
            if (null != comInfo && null != comInfo.getBaseCurrency()) {
                scale = comInfo.getBaseCurrency().getPrecision();
            }
            PurRequestEntryInfo entryInfo = null;
            for (int j = 0; j < reqInfo.getEntries().size(); ++j) {
                String materialID = reqInfo.getEntries().get(j).getMaterial().getId().toString();
                plannedId = reqInfo.getEntries().get(j).getSourceBillId();
                planned = ReleaseUtil.getPlannedOrderInfo(poCollection, plannedId);
                idplannedTopurreq.put(reqInfo.getId().toString(), planned.getNumber());
                purOrg = (PurchaseOrgUnitInfo)purchaseOrgMap.get(materialID + planned.getStorageOrgUnit().getId().toString());
                reqInfo.getEntries().get(j).setPurchaseOrgUnit(purOrg);
                entryInfo = reqInfo.getEntries().get(j);
                if (planned != null && planned.get("thisTotalReleaseQty") != null) {
                    thisTotalReleaseQty = (BigDecimal)planned.get("thisTotalReleaseQty");
                    reqInfo.getEntries().get(j).setQty(thisTotalReleaseQty);
                    reqInfo.getEntries().get(j).setRequestQty(thisTotalReleaseQty);
                }
                if (planned != null && planned.get("thisTotalReleaseBaseQty") != null) {
                    thisTotalReleasebaseQty = (BigDecimal)planned.get("thisTotalReleaseBaseQty");
                    reqInfo.getEntries().get(j).setBaseQty(thisTotalReleasebaseQty);
                }
                if (purOrg != null && purOrg.getId() != null && (materialPurInfo = (MaterialPurchasingInfo)materialPurMap.get(materialID + purOrg.getId().toString())) != null) {
                    reqInfo.getEntries().get(j).setPurchasePerson(materialPurInfo.getPurPerson());
                    reqInfo.getEntries().get(j).setPurchaseGroup(materialPurInfo.getPurGroup());
                    if (reqInfo.getEntries().get(j).getSupplier() == null) {
                        reqInfo.getEntries().get(j).setSupplier(materialPurInfo.getSupplier());
                    }
                    reqInfo.getEntries().get(j).setIsQuantityUnCtrl(materialPurInfo.isIsNotControlQty());
                    qtyUnit = materialPurInfo.getUnit();
                    qty = this.getExchangePrecisionQtyForServer(this.ctx, materialID, planned.getProductUnit(), qtyUnit, reqInfo.getEntries().get(j).getQty(), unitCacheMap);
                    reqInfo.getEntries().get(j).setQty(qty);
                    reqInfo.getEntries().get(j).setRequestQty(qty);
                    reqInfo.getEntries().get(j).setUnit(qtyUnit);
                }
                reqInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
                reqInfo.setPerson(userInfo.getPerson());
                reqInfo.getEntries().get(j).setBaseStatus(EntryBaseStatusEnum.ADD);
                if (planned != null) {
                    reqInfo.setSourceBillId(planned.getId().toString());
                    reqInfo.setSourceBillType(planned.getBillType());
                }
                reqInfo.getEntries().get(j).setExchangeRate(new BigDecimal("1.00"));
                _qty = entryInfo.getQty();
                _price = null == entryInfo.getPrice() ? SysConstant.BIGZERO : entryInfo.getPrice();
                _amount = _qty.multiply(_price).setScale(scale, 4);
                entryInfo.setAmount(_amount);
                entryInfo.setLocalAmount(_amount);
                _sumAmount = _sumAmount.add(_amount).setScale(scale, 4);
                reqInfo.getEntries().get(j).setOrderedQty(new BigDecimal("0.00"));
                if (null == reqInfo.getEntries().get(j).getAssistUnit()) {
                    reqInfo.getEntries().get(j).setAssistQty(new BigDecimal("0.00"));
                }
                if (comInfo == null || comInfo.getBaseCurrency() == null) continue;
                reqInfo.getEntries().get(j).setCurrency(comInfo.getBaseCurrency());
            }
            reqInfo.setTotalAmount(_sumAmount);
            reqInfo.setLocalTotalAmount(_sumAmount);
            if (reqInfo.getPerson() != null && reqInfo.getPerson().getId() != null) {
                try {
                    if (reqInfo.getPerson().getId() != null) {
                        if (personAdminOrgMap.containsKey(reqInfo.getPerson().getId().toString())) {
                            reqInfo.setAdminOrg((AdminOrgUnitInfo)personAdminOrgMap.get(reqInfo.getPerson().getId().toString()));
                        } else {
                            reqInfo.setAdminOrg(this.getAdminOrgUnitInfoToPerson(this.ctx, reqInfo.getPerson().getId().toString(), personAdminOrgMap));
                        }
                    }
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
            purRequestInfos[i] = reqInfo;
        }
        long time1 = System.currentTimeMillis();
        iPurRequest.submitForPlan(purRequestInfos);
        long time2 = System.currentTimeMillis();
        logger.error((Object)("#############\u6295\u653e\u540e\u5904\u7406submitForPlan\uff1a" + (time2 - time1)));
        PurRequestInfo info = (PurRequestInfo)billCollection.getObject(0);
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)this.ctx);
        CtrlUnitInfo cu = this.getCU(this.ctx, info);
        info.setCU(cu);
        String[] numbers = iCodingRuleManager.getBatchNumber((IObjectValue)info, info.getCompanyOrgUnit().getId().toString(), billCollection.size());
        int size4 = billCollection.size();
        for (int i = 0; i < size4; ++i) {
            info = (PurRequestInfo)billCollection.getObject(i);
            info.setNumber(numbers[i]);
        }
        long time22 = System.currentTimeMillis();
        logger.error((Object)("#############\u53d6\u7f16\u7801\u89c4\u5219\uff1a" + (time22 - time2)));
        this.ctx.put((Object)"CONTEXT_KEY_ISBATCHACTION", (Object)Boolean.TRUE);
        this.ctx.put((Object)"isPlannedOrderRelease", (Object)new Boolean(true));
        PlanningOrderReleasePurReq p = new PlanningOrderReleasePurReq();
        BatchActionResults results = null;
        try {
            results = p.doit(this.ctx, billCollection);
        }
        catch (Exception e) {
            logger.info((Object)e);
            PurRequestInfo purreqInfo = null;
            for (int i = 0; i < billCollection.size(); ++i) {
                purreqInfo = (PurRequestInfo)billCollection.getObject(i);
                failedDestBillIds.add(purreqInfo.getId().toString());
            }
            this.getResultMap().put(planned.getNumber(), e.getCause().getMessage());
            return;
        }
        long time3 = System.currentTimeMillis();
        logger.error((Object)("#############\u63d0\u4ea4\u91c7\u8d2d\u7533\u8bf7\u5355\u603b\u65f6\u95f4\uff1a" + (time3 - time2)));
        ArrayList batchResultList = new ArrayList();
        for (int i = 0; i < purreqids.size(); ++i) {
            String id = purreqids.get(i).toString();
            if (results == null) {
                successDestBillIds.add(id);
                continue;
            }
            ActionResult result = results.getActionResult((Object)id);
            if (result != null && ActionResultEnum.ERROR.equals((Object)result.getResult())) {
                failedDestBillIds.add(id);
                this.getResultMap().put(idplannedTopurreq.get(id), result.getMessage());
                continue;
            }
            if (result != null && !ActionResultEnum.SUCCESS.equals((Object)result.getResult())) continue;
            successDestBillIds.add(id);
        }
        planned = null;
        logger.info((Object)("doAfterTransform.[for (int i = 0; i < " + String.valueOf(poCollection.size()) + "; i++)]"));
        for (int j = 0; j < poCollection.size(); ++j) {
            planned = poCollection.get(j);
            if (this.getResultMap().containsKey(planned.getNumber())) continue;
            successPOs.add(planned);
        }
        successPOs.size();
    }

    @Override
    protected String getDestBillMainOrgUnitId() throws EASBizException, BOSException {
        String storageOrgUnitId = this.getStorageOrgUnitId();
        String orgUnitId = null;
        try {
            CompanyOrgUnitInfo orgUnit = ReleaseUtil.getCompanyOrgUnitInfo(this.ctx, storageOrgUnitId);
            if (orgUnit != null) {
                orgUnitId = orgUnit.getId().toString();
            }
        }
        catch (Exception e) {
            logger.error((Object)("PlanOrder2OutPurRequest getDestBillMainOrgUnitId exception 1" + e.getMessage()), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return orgUnitId;
    }

    @Override
    protected String getBotpRuleName() {
        return this.getResouce("PUT_INI_07", this.ctx);
    }

    @Override
    protected void checkAdditionalItems() throws EASBizException, BOSException {
        PlanOrderException excep = new PlanOrderException(PlanOrderException.PURORG_IS_NULL);
        String[] poIds = ReleaseUtil.getPlanOrderIds(this.getPlanOrderSet());
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FID FPoId from t_mm_plannedorder t \n");
        sql.append("inner join t_bd_materialPlan mp ");
        sql.append(" on t.FMaterialId=mp.FMaterialId and t.FStorageOrgUnitId=mp.FOrgUnit \n");
        sql.append("left outer join T_ORG_UnitRelation t1 on t.FStorageOrgUnitId=t1.FFromUnitID \n");
        sql.append(" and t1.FTypeRelationID='").append("00000000-0000-0000-0000-0000000000080FE9F8B5").append("' ");
        sql.append("where t.FID in (").append(this.getTemp_id()).append(") \n");
        sql.append("and mp.FPurOrgID is null and t1.FToUnitID is null ");
        IRowSet rs = SQLUtils.executeQuery((Context)this.ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                ReleaseUtil.setResultMap(this.getPlanOrderSet(), this.getResultMap(), rs.getString("FPoId"), (Exception)((Object)excep));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String getResouce(String key, Context ctx) {
        return SCMUtils.getResource((String)"com.kingdee.eas.mm.basedata.PlannedOrderPutInParamResource", (String)key, (Context)ctx);
    }

    private AdminOrgUnitInfo getAdminOrgUnitInfoToPerson(Context ctx, String personid, Map personAdminOrgMap) throws Exception {
        if (personid == null) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personid));
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("position.id"));
        sic.add(new SelectorItemInfo("position.name"));
        sic.add(new SelectorItemInfo("position.adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("position.adminOrgUnit.name"));
        SorterItemInfo sorterItem = new SorterItemInfo("isPrimary");
        sorterItem.setSortType(SortType.DESCEND);
        viewInfo.getSorter().add(sorterItem);
        IPositionMember iPositionMember = PositionMemberFactory.getLocalInstance((Context)ctx);
        PositionMemberCollection coll = iPositionMember.getPositionMemberCollection(viewInfo);
        if (coll != null && coll.size() > 0) {
            personAdminOrgMap.put(personid, coll.get(0).getPosition().getAdminOrgUnit());
            return coll.get(0).getPosition().getAdminOrgUnit();
        }
        return null;
    }

    private SelectorItemCollection getDestOrderSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("sourcebillid");
        sic.add("entries.id");
        sic.add("entries.sourcebillid");
        return sic;
    }

    protected CtrlUnitInfo getCU(Context ctx, PurRequestInfo model) {
        CompanyOrgUnitInfo mainOrg = model.getCompanyOrgUnit();
        if (mainOrg != null && mainOrg.getCU() == null) {
            try {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("CU.id"));
                mainOrg = FullOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitInfo((IObjectPK)new ObjectUuidPK(mainOrg.getId().toString()), sic);
            }
            catch (Exception e) {
                return ContextUtil.getCurrentCtrlUnit((Context)ctx);
            }
            return mainOrg.getCU();
        }
        return ContextUtil.getCurrentCtrlUnit((Context)ctx);
    }

    private BigDecimal getExchangePrecisionQtyForServer(Context ctx, String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty, Map UnitCacheMap) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetQty = null;
        MultiMeasureUnitInfo multiUnifInfo = this.getUnitByCahce(materialID, unitInfo.getId().toString(), UnitCacheMap);
        MultiMeasureUnitInfo othermultiUnifInfo = this.getUnitByCahce(materialID, otherUnitInfo.getId().toString(), UnitCacheMap);
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            BigDecimal baseQty = qty.multiply(baseExchangeRate1);
            targetQty = baseQty.divide(baseExchangeRate2, othermultiUnifInfo.getQtyPrecision(), 4);
        }
        return targetQty;
    }

    private MultiMeasureUnitInfo getUnitByCahce(String materialID, String unitId, Map unitCacheMap) throws BOSException, EASBizException {
        if (unitCacheMap.containsKey(materialID + unitId)) {
            return (MultiMeasureUnitInfo)unitCacheMap.get(materialID + unitId);
        }
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)this.ctx);
        MultiMeasureUnitInfo unit = multiUnit.getMultiUnit(materialID, unitId);
        unitCacheMap.put(materialID + unitId, unit);
        return unit;
    }
}

