/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.release;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.planning.PlannedOrderCollection;
import com.kingdee.eas.mm.planning.PlannedOrderInfo;
import com.kingdee.eas.mm.planning.app.release.AbstractPlanOrderTransform;
import com.kingdee.eas.mm.planning.app.release.ReleaseUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.im.inv.ITransferOrderBill;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillFactory;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PlanOrder2TransferOrderBill
extends AbstractPlanOrderTransform {
    public PlanOrder2TransferOrderBill(Context ctx) {
        super(ctx);
    }

    @Override
    protected BOSObjectType getDestBOSType() {
        return BOSObjectType.create((String)"5C2A1F0C");
    }

    @Override
    protected IObjectValue getDestBillInfo() {
        return new TransferOrderBillInfo();
    }

    @Override
    protected String getDestBillPermission() {
        return "transferorder_new";
    }

    @Override
    protected void doAfterTransform(IObjectCollection billCollection, Set successPOs, List failedDestBillIds, List successDestBillIds) throws EASBizException, BOSException {
        logger.info((Object)("ReleaseUtil.set2Collection(getPlanOrderSet()),size=" + String.valueOf(this.getPlanOrderSet().size())));
        PlannedOrderCollection poCollection = ReleaseUtil.set2Collection(this.getPlanOrderSet());
        String plannedId = null;
        PlannedOrderInfo planned = null;
        HashSet<TransferOrderBillInfo> transferOrderbills = new HashSet<TransferOrderBillInfo>();
        IObjectPK pkst = null;
        ITransferOrderBill itransferOrderbill = TransferOrderBillFactory.getLocalInstance((Context)this.ctx);
        TransferOrderBillInfo transferOrderBillInfo = null;
        TransferOrderBillEntryInfo transferOrderBillEntryInfo = null;
        planned = poCollection.get(0);
        CompanyOrgUnitInfo issueCompanyOrgUnit = ReleaseUtil.getCompanyOrgUnitInfo(this.ctx, planned.getProductionOrgUnit().getId().toString());
        CompanyOrgUnitInfo receCompanyOrgUnit = ReleaseUtil.getCompanyOrgUnitInfo(this.ctx, planned.getStorageOrgUnit().getId().toString());
        StringBuffer wareHouseSql = new StringBuffer();
        WarehouseInfo issueWareHouse = new WarehouseInfo();
        WarehouseInfo receiptWareHouse = new WarehouseInfo();
        logger.info((Object)("doAfterTransform.[for (int i = 0; i < " + String.valueOf(billCollection.size()) + "; i++)]"));
        for (int i = 0; i < billCollection.size(); ++i) {
            transferOrderBillInfo = (TransferOrderBillInfo)billCollection.getObject(i);
            if (issueCompanyOrgUnit != null) {
                transferOrderBillInfo.setCurrency(issueCompanyOrgUnit.getBaseCurrency());
                transferOrderBillInfo.setExchangeRate(new BigDecimal("1.00"));
            }
            if (receCompanyOrgUnit != null) {
                transferOrderBillInfo.setReceiptCompanyOrgUnit(receCompanyOrgUnit);
            }
            logger.info((Object)"itransferOrderbill.save(transferOrderBillInfo)");
            pkst = itransferOrderbill.save((CoreBaseInfo)transferOrderBillInfo);
            logger.info((Object)("itransferOrderbill.save(transferOrderBillInfo),id=" + pkst.toString()));
            transferOrderBillInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
            for (int j = 0; j < transferOrderBillInfo.getEntry().size(); ++j) {
                transferOrderBillEntryInfo = transferOrderBillInfo.getEntry().get(j);
                plannedId = transferOrderBillEntryInfo.getSourceBillId();
                planned = ReleaseUtil.getPlannedOrderInfo(poCollection, plannedId);
                SaleOrgUnitInfo saleInfo = ReleaseUtil.getSaleOrgUnitInfo(this.ctx, planned.getProductionOrgUnit().getId().toString());
                if (saleInfo != null) {
                    transferOrderBillEntryInfo.setIssueSaleOrgUnit(saleInfo);
                }
                if (planned != null && planned.get("thisTotalReleaseQty") != null) {
                    BigDecimal thisTotalReleaseQty = (BigDecimal)planned.get("thisTotalReleaseQty");
                    transferOrderBillEntryInfo.setQty(thisTotalReleaseQty);
                }
                if (planned != null && planned.get("thisTotalReleaseBaseQty") != null) {
                    BigDecimal thisTotalReleasebaseQty = (BigDecimal)planned.get("thisTotalReleaseBaseQty");
                    transferOrderBillEntryInfo.setBaseQty(thisTotalReleasebaseQty);
                }
                transferOrderBillEntryInfo.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
                wareHouseSql.setLength(0);
                wareHouseSql.append("select ReceiptInventory.FDefaultWarehouseID ReceiptWarehouseID, ").append("supllyInventory.FDefaultWarehouseID SupplyWarehouseID ").append("from t_mm_plannedorder po ").append("left outer join t_bd_materialInventory ReceiptInventory ").append(" on po.FStorageOrgUnitID = ReceiptInventory.forgunit ").append(" and po.FMaterialID = ReceiptInventory.FMaterialID ").append("left outer join t_bd_materialInventory supllyInventory ").append(" on po.FProductionOrgUnitID = supllyInventory.forgunit ").append(" and po.FMaterialID = supllyInventory.FMaterialID ").append("where po.fid = '").append(planned.getId().toString()).append("' ");
                IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)wareHouseSql.toString());
                logger.info((Object)("DbUtil.executeQuery(ctx, wareHouseSql.toString()),size=" + String.valueOf(rs.size())));
                try {
                    rs.next();
                    String issueWarehouseID = rs.getString("SupplyWarehouseID");
                    String receiptWarehouseID = rs.getString("ReceiptWarehouseID");
                    if (issueWarehouseID != null) {
                        issueWareHouse.setId(BOSUuid.read((String)issueWarehouseID));
                        transferOrderBillEntryInfo.setIssueWarehouse(issueWareHouse);
                    }
                    if (receiptWarehouseID != null) {
                        receiptWareHouse.setId(BOSUuid.read((String)receiptWarehouseID));
                        transferOrderBillEntryInfo.setReceiptWarehouse(receiptWareHouse);
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
                successPOs.add(planned);
            }
            logger.info((Object)"itransferOrderbill.update(pkst, transferOrderBillInfo)");
            itransferOrderbill.update(pkst, (CoreBaseInfo)transferOrderBillInfo);
            transferOrderbills.add(transferOrderBillInfo);
            successDestBillIds.add(transferOrderBillInfo.getId().toString());
        }
        if (transferOrderbills.size() > 0) {
            logger.info((Object)("InvServerUtils.handleBatchReqPlan,size=" + String.valueOf(transferOrderbills.size())));
            InvServerUtils.handleBatchReqPlan(transferOrderbills, (String)"Eg5BUQEVEADgAAABwKgOEEY+1VI=", (BizActionEnum)BizActionEnum.SUBMIT, (Context)this.ctx);
        }
    }

    @Override
    protected void checkAdditionalItems() throws EASBizException, BOSException {
        Map checkRstMap = ReleaseUtil.checkMaterialInventory(this.ctx, this.getPlanOrderSet());
        this.getResultMap().putAll(checkRstMap);
    }
}

