/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.release;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.ThrowModeEnum;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.AsynchFacadeFactory;
import com.kingdee.eas.mm.common.AsyrunLog;
import com.kingdee.eas.mm.common.IAsynchFacade;
import com.kingdee.eas.mm.common.app.BizCommand;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.planning.IReqPlanWriteOffFacade;
import com.kingdee.eas.mm.planning.MappingReturnTypeEnum;
import com.kingdee.eas.mm.planning.PlanOrderException;
import com.kingdee.eas.mm.planning.PlannedOrderCollection;
import com.kingdee.eas.mm.planning.PlannedOrderEntryInfo;
import com.kingdee.eas.mm.planning.PlannedOrderInfo;
import com.kingdee.eas.mm.planning.ReqPlanReceiveReqDataFacadeFactory;
import com.kingdee.eas.mm.planning.ReqPlanWriteOffFacadeFactory;
import com.kingdee.eas.mm.planning.app.release.AbstractPlanOrderTransform;
import com.kingdee.eas.mm.planning.app.release.PlanOrder2ManufactureOrder;
import com.kingdee.eas.mm.planning.app.release.PlanOrder2OutPurRequest;
import com.kingdee.eas.mm.planning.app.release.PlanOrder2ProductionOrder;
import com.kingdee.eas.mm.planning.app.release.PlanOrder2PurOrder;
import com.kingdee.eas.mm.planning.app.release.PlanOrder2PurRequest;
import com.kingdee.eas.mm.planning.app.release.PlanOrder2StockTransferBill;
import com.kingdee.eas.mm.planning.app.release.PlanOrder2SubContractOrder;
import com.kingdee.eas.mm.planning.app.release.PlanOrder2TransferOrderBill;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class PlanOrderRelease
extends BizCommand {
    public static final String PO_COLLECTION = "poCollection";
    public static final String ERROR_MAP = "errorMap";
    public static String MAPPING_MUTEX = "MM_PLANNEDORDER_RELEASE";
    public static final String PLANNEDORDER_ID = "plannedOrderIdList";

    public PlanOrderRelease(Context ctx) {
        super(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doing(Object inParam) throws BOSException, EASBizException {
        logger.info((Object)"doing,begin....");
        Map paramMap = (Map)inParam;
        String temp_id = (String)paramMap.get("temp_id");
        PlannedOrderCollection plannedorders = (PlannedOrderCollection)((Object)paramMap.get(PO_COLLECTION));
        Map map = (Map)paramMap.get(ERROR_MAP);
        List ids = (List)paramMap.get(PLANNEDORDER_ID);
        PlannedOrderInfo plannedInfo = null;
        if (plannedorders == null || plannedorders.size() == 0) {
            String msg = ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"27_No_Order_Release", (Locale)this.ctx.getLocale());
            map.put("    ", msg);
            return map;
        }
        logger.info((Object)"checkPlannedOrder.");
        this.checkPlannedOrder(this.ctx, map, ids, plannedorders);
        logger.info((Object)"checkMaterialPlan.");
        this.checkMaterialPlan(this.ctx, plannedorders, map, ids, temp_id);
        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"68_PlanOrderRelease", (Locale)this.ctx.getLocale()));
        String[] orgunits = this.getOrgUnitId(this.ctx, plannedorders);
        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"69_PlanOrderRelease", (Locale)this.ctx.getLocale()));
        Map currentFIUnits = this.getCouOrgUnit(this.ctx, orgunits);
        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"70_PlanOrderRelease", (Locale)this.ctx.getLocale()));
        this.checkOrgUnitByPurOrg(this.ctx, plannedorders, map, currentFIUnits, ids);
        logger.info((Object)"writeLog(ctx, map, successIds)");
        HashSet successIds = new HashSet();
        if (ids.size() <= 0) {
            if (this.ctx.get((Object)"311F8787") != null) {
                this.writeLog(this.ctx, map, successIds);
            }
            return map;
        }
        ArrayList<Uuid> mutexUuids = new ArrayList<Uuid>();
        try {
            if (this.ctx.get((Object)"311F8787") == null) {
                IMutexServiceControl iMutexService = MutexServiceControlFactory.getLocalInstance((Context)this.ctx);
                for (String orgUnitID : orgunits) {
                    Uuid mutexUuid = Uuid.create();
                    MutexParameter mutexParam = new MutexParameter();
                    mutexParam.setRequestId(mutexUuid);
                    mutexParam.setOrgUnitID(BOSUuid.read((String)orgUnitID));
                    mutexParam.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
                    mutexParam.setMutexName(MAPPING_MUTEX);
                    boolean requestFlag = iMutexService.requestMutex(mutexParam);
                    if (!requestFlag) {
                        throw new PlanOrderException(PlanOrderException.SIMULANT_TRANSFER_LOCKED);
                    }
                    mutexUuids.add(mutexUuid);
                }
            }
            LinkedHashSet<PlannedOrderInfo> homeMade = new LinkedHashSet<PlannedOrderInfo>();
            LinkedHashSet<PlannedOrderInfo> outsourcing = new LinkedHashSet<PlannedOrderInfo>();
            LinkedHashSet<PlannedOrderInfo> purchase = new LinkedHashSet<PlannedOrderInfo>();
            LinkedHashSet flowSet = new LinkedHashSet();
            LinkedHashSet discreteSet = new LinkedHashSet();
            LinkedHashSet outsourcingPurrequest = new LinkedHashSet();
            LinkedHashSet stockTransferBillSet = new LinkedHashSet();
            LinkedHashSet tsfOrderBillSet = new LinkedHashSet();
            LinkedHashSet<PlannedOrderInfo> purOrderSet = new LinkedHashSet<PlannedOrderInfo>();
            LinkedHashSet subContractOrderSet = new LinkedHashSet();
            ArrayList successTargetBillIds = new ArrayList();
            Boolean paramValue = null;
            logger.info((Object)("doAfterTransform.[for (int i = 0; i < " + String.valueOf(plannedorders.size()) + "; i++)]"));
            block11: for (int i = 0; i < plannedorders.size(); ++i) {
                plannedInfo = plannedorders.get(i);
                logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"71_PlanOrderRelease", (Locale)this.ctx.getLocale()) + plannedInfo.getNumber().toString() + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"66_PlannedOrderControllerBean", (Locale)this.ctx.getLocale()) + plannedInfo.getQty() + " (id:" + plannedInfo.getProductUnit().getId() + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"67_PlannedOrderControllerBean", (Locale)this.ctx.getLocale()) + plannedInfo.getBaseQty() + " (id:" + plannedInfo.getUnit().getId() + ")"));
                switch (plannedInfo.getOrderType().getValue()) {
                    case 10: {
                        homeMade.add(plannedInfo);
                        continue block11;
                    }
                    case 20: {
                        if (paramValue == null) {
                            paramValue = this.getParamValue(this.ctx, plannedInfo.getStorageOrgUnit().getId().toString(), "PLAN_PO");
                        }
                        if (Boolean.TRUE.equals(paramValue)) {
                            purOrderSet.add(plannedInfo);
                            continue block11;
                        }
                        purchase.add(plannedInfo);
                        continue block11;
                    }
                    case 30: {
                        outsourcing.add(plannedInfo);
                    }
                }
            }
            HashMap tempMapqty = new HashMap();
            HashMap tempMapbaseqty = new HashMap();
            ArrayList failedDestBillIds = new ArrayList();
            if (homeMade.size() > 0) {
                logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"72_PlanOrderRelease", (Locale)this.ctx.getLocale()));
                this.homeMadeTypeCheck(this.ctx, homeMade, discreteSet, flowSet, map);
            }
            if (purOrderSet.size() > 0) {
                logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"73_PlanOrderRelease", (Locale)this.ctx.getLocale()));
                this.getPuacharOrgUnitAndCheck(this.ctx, purOrderSet, map);
            }
            if (purchase.size() > 0) {
                logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"73_PlanOrderRelease", (Locale)this.ctx.getLocale()));
                this.getPuacharOrgUnitAndCheck(this.ctx, purchase, map);
                logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"74_PlanOrderRelease", (Locale)this.ctx.getLocale()));
                this.checkBaseMaterialTable(this.ctx, purchase, map, currentFIUnits);
            }
            if (outsourcing.size() > 0) {
                logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"73_PlanOrderRelease", (Locale)this.ctx.getLocale()));
                this.getPuacharOrgUnitAndCheck(this.ctx, outsourcing, map);
                logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"74_PlanOrderRelease", (Locale)this.ctx.getLocale()));
                this.checkBaseMaterialTable(this.ctx, outsourcing, map, currentFIUnits);
                logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"75_PlanOrderRelease", (Locale)this.ctx.getLocale()));
                this.groupingByOutsourcing(this.ctx, outsourcing, currentFIUnits, outsourcingPurrequest, stockTransferBillSet, tsfOrderBillSet, subContractOrderSet);
            }
            logger.info((Object)"setPlanndOrderEntryTotalQty");
            this.setPlanndOrderEntryTotalQty(plannedorders, tempMapqty, tempMapbaseqty);
            String storageOrgUnitId = plannedorders.get(0).getStorageOrgUnit().getId().toString();
            logger.info((Object)"transform");
            AbstractPlanOrderTransform trans = null;
            if (discreteSet.size() > 0) {
                this.ctx.put((Object)"isPlannedOrderRelease", (Object)new Boolean(true));
                trans = new PlanOrder2ManufactureOrder(this.ctx);
                trans.setStorageOrgUnitId(storageOrgUnitId);
                trans.setPlanOrderSet(discreteSet);
                trans.setResultMap(map);
                trans.transform(successIds, failedDestBillIds, successTargetBillIds);
            }
            if (flowSet.size() > 0) {
                trans = new PlanOrder2ProductionOrder(this.ctx);
                trans.setStorageOrgUnitId(storageOrgUnitId);
                trans.setPlanOrderSet(flowSet);
                trans.setResultMap(map);
                trans.transform(successIds, failedDestBillIds, successTargetBillIds);
            }
            if (tsfOrderBillSet.size() > 0) {
                trans = new PlanOrder2TransferOrderBill(this.ctx);
                trans.setStorageOrgUnitId(storageOrgUnitId);
                trans.setPlanOrderSet(tsfOrderBillSet);
                trans.setResultMap(map);
                trans.transform(successIds, failedDestBillIds, successTargetBillIds);
            }
            if (stockTransferBillSet.size() > 0) {
                trans = new PlanOrder2StockTransferBill(this.ctx);
                trans.setStorageOrgUnitId(storageOrgUnitId);
                trans.setPlanOrderSet(stockTransferBillSet);
                trans.setResultMap(map);
                trans.transform(successIds, failedDestBillIds, successTargetBillIds);
            }
            if (purOrderSet.size() > 0) {
                trans = new PlanOrder2PurOrder(this.ctx);
                trans.setStorageOrgUnitId(storageOrgUnitId);
                trans.setPlanOrderSet(purOrderSet);
                trans.setResultMap(map);
                trans.transform(successIds, failedDestBillIds, successTargetBillIds);
            }
            if (purchase.size() > 0) {
                this.ctx.put((Object)"isPlannedOrderRelease", (Object)new Boolean(true));
                trans = new PlanOrder2PurRequest(this.ctx);
                trans.setStorageOrgUnitId(storageOrgUnitId);
                trans.setPlanOrderSet(purchase);
                trans.setResultMap(map);
                trans.setTemp_id(temp_id);
                trans.transform(successIds, failedDestBillIds, successTargetBillIds);
            }
            if (outsourcingPurrequest.size() > 0) {
                this.ctx.put((Object)"isPlannedOrderRelease", (Object)new Boolean(true));
                trans = new PlanOrder2OutPurRequest(this.ctx);
                trans.setStorageOrgUnitId(storageOrgUnitId);
                trans.setPlanOrderSet(outsourcingPurrequest);
                trans.setResultMap(map);
                trans.transform(successIds, failedDestBillIds, successTargetBillIds);
            }
            if (subContractOrderSet.size() > 0) {
                trans = new PlanOrder2SubContractOrder(this.ctx);
                trans.setStorageOrgUnitId(storageOrgUnitId);
                trans.setPlanOrderSet(subContractOrderSet);
                trans.setResultMap(map);
                trans.transform(successIds, failedDestBillIds, successTargetBillIds);
            }
            logger.info((Object)"writeBackPlanOrder");
            this.writeBackPlanOrder(this.ctx, successIds, tempMapqty, tempMapbaseqty);
            logger.info((Object)"writerbackPlannedOrderEnty");
            this.writerbackPlannedOrderEnty(this.ctx, successIds);
            StringBuffer plannedOrderIds = new StringBuffer("'null'");
            logger.info((Object)("successIds,size=" + String.valueOf(successIds.size())));
            Iterator plannedOrders = successIds.iterator();
            while (plannedOrders.hasNext()) {
                plannedOrderIds.append(",'").append(((PlannedOrderInfo)plannedOrders.next()).getId().toString()).append("'");
            }
            try {
                logger.info((Object)("updateReqPlanDataForRelease,size=" + String.valueOf(plannedOrderIds.length())));
                this.updateReqPlanDataForRelease(this.ctx, plannedOrderIds.toString(), outsourcingPurrequest, discreteSet, flowSet, subContractOrderSet, successTargetBillIds);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            if (this.ctx.get((Object)"311F8787") != null) {
                this.writeLog(this.ctx, map, successIds);
            }
            logger.info((Object)("deleteSaveBill(ctx,failedDestBillIds),size=" + String.valueOf(failedDestBillIds.size())));
            this.deleteSaveBill(this.ctx, failedDestBillIds);
            logger.info((Object)"doing,end.");
            Map map2 = map;
            return map2;
        }
        finally {
            if (this.ctx.get((Object)"311F8787") == null) {
                int size = mutexUuids.size();
                for (int i = 0; i < size; ++i) {
                    IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)this.ctx);
                    mutexService.releaseMutex((Uuid)mutexUuids.get(i));
                }
            }
        }
    }

    private void checkPlannedOrder(Context ctx, Map map, List ids, PlannedOrderCollection plannedorders) {
        PlannedOrderInfo plan = null;
        String planid = null;
        for (int i = 0; i < plannedorders.size(); ++i) {
            plan = plannedorders.get(i);
            planid = plan.getId().toString();
            Date startDate = plan.getStartDate();
            Date nowDate = new Date();
            if (!plan.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
                map.put(plan.getNumber(), new PlanOrderException(PlanOrderException.RELEASE_MUSTONAUDIT).getMessage());
                ids.remove(planid);
                plannedorders.remove(plan);
                --i;
                continue;
            }
            if (plan.getQty().compareTo(plan.getTotalReleaseQty()) <= 0) {
                map.put(plan.getNumber(), new PlanOrderException(PlanOrderException.CANNOTRELEASE_QUATITYLESSTOTAL).getMessage());
                ids.remove(planid);
                plannedorders.remove(plan);
                --i;
                continue;
            }
            BigDecimal thisTotalReleaseQty = new BigDecimal(0);
            if (plan.get("thisTotalReleaseQty") != null) {
                thisTotalReleaseQty = (BigDecimal)plan.get("thisTotalReleaseQty");
            }
            if (plan.getQty().compareTo(plan.getTotalReleaseQty().add(thisTotalReleaseQty)) < 0) {
                map.put(plan.getNumber(), new PlanOrderException(PlanOrderException.CANNOTRELEASE_QUATITYLESSTOTAL).getMessage());
                ids.remove(planid);
                plannedorders.remove(plan);
                --i;
                continue;
            }
            if (!plan.isIsSimulant()) continue;
            map.put(plan.getNumber(), MappingReturnTypeEnum.NOT_FORMAL_BILL);
            ids.remove(planid);
            plannedorders.remove(plan);
            --i;
        }
    }

    private void checkMaterialPlan(Context ctx, PlannedOrderCollection plannedorders, Map map, List idss, String temp_id) throws EASBizException, BOSException {
        if (plannedorders == null || plannedorders.size() == 0) {
            return;
        }
        PlannedOrderInfo plan = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT plannedorder.fid, plannedorder.fnumber FROM t_mm_plannedorder plannedorder").append(" inner join ").append("T_ORG_STORAGE  org  on org.fid = plannedorder.FStorageOrgUnitID").append(" inner join ").append("T_BD_MaterialPlan  material on org.fid = material.forgunit and PLANNEDORDER.FMATERIALID = material.FMATERIALID ").append("where plannedorder.fid  in(").append(temp_id).append(") and ( material.fstatus = 0 or material.fstatus is null)");
        IRowSet rs = this.executeQuery(sql.toString());
        String id = null;
        String planid = null;
        try {
            block2: while (rs.next()) {
                id = rs.getString("fid");
                map.put(rs.getString("fnumber"), new PlanOrderException(PlanOrderException.MATPLAN_NOTEXISTS).getMessage());
                for (int i = 0; i < plannedorders.size(); ++i) {
                    plan = plannedorders.get(i);
                    planid = plan.getId().toString();
                    if (!id.equals(planid)) continue;
                    plannedorders.remove(plan);
                    idss.remove(planid);
                    continue block2;
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private String[] getOrgUnitId(Context ctx, PlannedOrderCollection plannedorders) throws BOSException, EASBizException {
        if (plannedorders != null && plannedorders.size() > 0) {
            HashSet<String> orgUnits = new HashSet<String>();
            PlannedOrderInfo plannedInfo = null;
            String orgUnitId = null;
            String productionOrgunitId = null;
            for (int i = 0; i < plannedorders.size(); ++i) {
                plannedInfo = plannedorders.get(i);
                orgUnitId = plannedInfo.getStorageOrgUnit().getId().toString();
                productionOrgunitId = plannedInfo.getProductionOrgUnit().getId().toString();
                if (!orgUnits.contains(orgUnitId)) {
                    orgUnits.add(orgUnitId);
                }
                if (orgUnits.contains(productionOrgunitId)) continue;
                orgUnits.add(productionOrgunitId);
            }
            String[] s = new String[orgUnits.size()];
            return orgUnits.toArray(s);
        }
        return null;
    }

    private Map getCouOrgUnit(Context ctx, String[] orgUnitID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        HashMap<String, String> map = new HashMap<String, String>();
        if (orgUnitID == null || orgUnitID.length == 0) {
            return map;
        }
        sql.append("select orgRe.FFromUnitID ,orgRe.FTOUnitID from T_ORG_UnitRelation orgRe where orgRe.FFromUnitID in (");
        for (int i = 0; i < orgUnitID.length; ++i) {
            sql.append("'");
            sql.append(orgUnitID[i]);
            if (i != orgUnitID.length - 1) {
                sql.append("' , ");
                continue;
            }
            sql.append("' )");
        }
        sql.append("  and orgRe.ftyperelationid='");
        sql.append("00000000-0000-0000-0000-0000000000070FE9F8B5");
        sql.append("'  ");
        try {
            IRowSet rs = this.executeQuery(sql.toString());
            while (rs.next()) {
                map.put(rs.getString("FFromUnitID"), rs.getString("FTOUnitID"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return map;
    }

    private void checkOrgUnitByPurOrg(Context ctx, PlannedOrderCollection plannedorders, Map map, Map currentFIUnits, List ids) throws BOSException, EASBizException {
        if (currentFIUnits != null && currentFIUnits.size() > 0) {
            PlannedOrderInfo plannedInfo = null;
            String orgUnitId = null;
            String productionOrgunitId = null;
            for (int i = 0; i < plannedorders.size(); ++i) {
                plannedInfo = plannedorders.get(i);
                orgUnitId = plannedInfo.getStorageOrgUnit().getId().toString();
                productionOrgunitId = plannedInfo.getProductionOrgUnit().getId().toString();
                if (currentFIUnits.get(orgUnitId) != null) {
                    if (currentFIUnits.get(productionOrgunitId) != null) continue;
                    map.put(plannedInfo.getNumber(), new PlanOrderException(PlanOrderException.COMPANYISNULL_OUT_EXCEPTION).getMessage());
                    plannedorders.remove(plannedInfo);
                    ids.remove(plannedInfo.getId().toString());
                    --i;
                    continue;
                }
                map.put(plannedInfo.getNumber(), new PlanOrderException(PlanOrderException.COMPANYISNULL_OUT_EXCEPTION).getMessage());
                ids.remove(plannedInfo.getId().toString());
                plannedorders.remove(plannedInfo);
                --i;
            }
        }
    }

    private void writeLog(Context ctx, Map errorMap, Set succeedNum) throws BOSException, EASBizException {
        String asyOpflag = ctx.get((Object)"311F8787").toString();
        Iterator<Object> iterator = errorMap.keySet().iterator();
        IAsynchFacade facade = AsynchFacadeFactory.getLocalInstance((Context)ctx);
        AsyrunLog log = null;
        ArrayList<AsyrunLog> list = new ArrayList<AsyrunLog>();
        while (iterator.hasNext()) {
            log = new AsyrunLog();
            String errorlog = iterator.next().toString();
            log.setDetailLog(errorlog + errorMap.get(errorlog));
            log.setOptype(asyOpflag);
            log.setRunFlag(0);
            log.setParamQty(1);
            list.add(log);
        }
        iterator = succeedNum.iterator();
        PlannedOrderInfo plan = null;
        String msg = ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"0_PlannedOrderMappingExtendBean", (Locale)ctx.getLocale());
        while (iterator.hasNext()) {
            plan = (PlannedOrderInfo)iterator.next();
            log = new AsyrunLog();
            String errorlog = plan.getNumber() + msg;
            log.setDetailLog(errorlog);
            log.setOptype(asyOpflag);
            log.setRunFlag(1);
            list.add(log);
        }
        facade.addLog(list);
    }

    private Boolean getParamValue(Context ctx, String storageOrgId, String paramName) throws BOSException, EASBizException {
        ObjectUuidPK orgPK;
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
        String paramValue = iParamControl.getParamValue((IObjectPK)(orgPK = new ObjectUuidPK(storageOrgId)), paramName);
        if (StringUtil.isEmptyString((String)paramValue)) {
            return Boolean.FALSE;
        }
        return Boolean.valueOf(paramValue);
    }

    private void homeMadeTypeCheck(Context ctx, Set homeMades, Set discreteSet, Set flowSet, Map map) throws BOSException, EASBizException {
        Iterator it = homeMades.iterator();
        PlannedOrderInfo plannedInfo = null;
        String materialId = null;
        String orgunitId = null;
        HashSet<String> materids = new HashSet<String>();
        HashSet<String> orgUnitIds = new HashSet<String>();
        while (it.hasNext()) {
            plannedInfo = (PlannedOrderInfo)it.next();
            materialId = plannedInfo.getMaterial().getId().toString();
            orgunitId = plannedInfo.getStorageOrgUnit().getId().toString();
            if (!materids.contains(materialId)) {
                materids.add(materialId);
            }
            if (orgUnitIds.contains(orgunitId)) continue;
            orgUnitIds.add(orgunitId);
        }
        FilterInfo matFilter = new FilterInfo();
        matFilter.getFilterItems().add(new FilterItemInfo("material.id", materids, CompareType.INCLUDE));
        matFilter.getFilterItems().add(new FilterItemInfo("orgUnit.id", orgUnitIds, CompareType.INCLUDE));
        EntityViewInfo entiView = new EntityViewInfo();
        entiView.setFilter(matFilter);
        entiView.getSelector().add(new SelectorItemInfo("material.id"));
        entiView.getSelector().add(new SelectorItemInfo("orgUnit.id"));
        entiView.getSelector().add(new SelectorItemInfo("status"));
        entiView.getSelector().add(new SelectorItemInfo("isProductLinePlan"));
        entiView.getSelector().add(new SelectorItemInfo("throwMode"));
        MaterialPlanCollection materialPlanCollection = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanCollection(entiView);
        materialId = null;
        orgunitId = null;
        MaterialPlanInfo materialPlanInfo = null;
        it = homeMades.iterator();
        while (it.hasNext()) {
            plannedInfo = (PlannedOrderInfo)it.next();
            materialId = plannedInfo.getMaterial().getId().toString();
            orgunitId = plannedInfo.getStorageOrgUnit().getId().toString();
            materialPlanInfo = null;
            for (int i = 0; !(i >= materialPlanCollection.size() || materialId.equals((materialPlanInfo = materialPlanCollection.get(i)).getMaterial().getId().toString()) && orgunitId.equals(materialPlanInfo.getOrgUnit().getId().toString())); ++i) {
            }
            if (materialPlanInfo == null) continue;
            if (materialPlanInfo.getStatus().getValue() != 1) {
                map.put(plannedInfo.getNumber(), new PlanOrderException(PlanOrderException.MATPLAN_NOTEXISTS).getMessage());
                it.remove();
                continue;
            }
            if (materialPlanInfo.isIsProductLinePlan()) {
                map.put(plannedInfo.getNumber(), new PlanOrderException(PlanOrderException.EXPORT_ORDER_ISPRODUCTLIN).getMessage());
                it.remove();
                continue;
            }
            if (materialPlanInfo.getThrowMode().equals((Object)ThrowModeEnum.DISCRETE)) {
                discreteSet.add(plannedInfo);
            }
            if (!materialPlanInfo.getThrowMode().equals((Object)ThrowModeEnum.FLOW)) continue;
            flowSet.add(plannedInfo);
        }
    }

    private void getPuacharOrgUnitAndCheck(Context ctx, Set set, Map map) throws BOSException, EASBizException {
        Iterator it = set.iterator();
        PlannedOrderInfo plan = null;
        PurchaseOrgUnitInfo purchase = null;
        Object purorgId = null;
        StringBuffer materIds = new StringBuffer();
        StringBuffer purIds = new StringBuffer();
        HashMap<String, String> numberMap = new HashMap<String, String>();
        ArrayList<String> materIdList = new ArrayList<String>();
        ArrayList<String> purIdList = new ArrayList<String>();
        while (it.hasNext()) {
            plan = (PlannedOrderInfo)it.next();
            purchase = this.getPurOrgsInfo(ctx, plan);
            if (purchase == null) {
                map.put(plan.getNumber(), new PlanOrderException(PlanOrderException.PURCHASEORG_CANNOT_NULL).getMessage());
                it.remove();
                continue;
            }
            numberMap.put(plan.getNumber(), purchase.getId().toString());
            if (!materIdList.contains(plan.getMaterial().getId().toString())) {
                materIdList.add(plan.getMaterial().getId().toString());
                materIds.append("'").append(plan.getMaterial().getId().toString()).append("'").append(",");
            }
            if (purIdList.contains(purchase.getId().toString())) continue;
            purIdList.add(purchase.getId().toString());
            purIds.append("'").append(purchase.getId().toString()).append("'").append(",");
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select FID, FMaterialID,FOrgUnit,Fstatus from t_bd_materialpurchasing where FMaterialID in ( ").append(materIds.toString().substring(0, materIds.toString().length() - 1)).append(" ) and FOrgUnit in (").append(purIds.toString().substring(0, purIds.toString().length() - 1)).append(") and fstatus = 0 ");
        IRowSet rs = this.executeQuery(sql.toString());
        String materalId = null;
        String purOrgId = null;
        String matera = null;
        String orgUnitId = null;
        try {
            while (rs.next()) {
                materalId = rs.getString("FMaterialID");
                purOrgId = rs.getString("FOrgUnit");
                it = set.iterator();
                while (it.hasNext()) {
                    plan = (PlannedOrderInfo)it.next();
                    matera = plan.getMaterial().getId().toString();
                    if (numberMap.get(plan.getNumber().toString()) == null) continue;
                    orgUnitId = (String)numberMap.get(plan.getNumber().toString());
                    if (!materalId.equals(matera) || !purOrgId.equals(orgUnitId)) continue;
                    map.put(plan.getNumber(), new PlanOrderException(PlanOrderException.PURATTR_NULL).getMessage());
                    it.remove();
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private PurchaseOrgUnitInfo getPurOrgsInfo(Context ctx, PlannedOrderInfo info) throws EASBizException, BOSException {
        String stroageOrgUnitID;
        PurchaseOrgUnitInfo purOrg = null;
        String materialID = info.getMaterial().getId().toString();
        String FPurOrgID = this.getDefaultPurOrgID(ctx, materialID, stroageOrgUnitID = info.getStorageOrgUnit().getId().toString());
        if (FPurOrgID != null) {
            purOrg = new PurchaseOrgUnitInfo();
            purOrg.setId(BOSUuid.read((String)FPurOrgID));
            return purOrg;
        }
        return SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getPurchaseByStorageOrg(stroageOrgUnitID);
    }

    private String getDefaultPurOrgID(Context ctx, String materialID, String storageOrgUnitID) throws BOSException {
        if (materialID == null || storageOrgUnitID == null) {
            return null;
        }
        String purOrgID = null;
        String sql = "select FPurOrgID from T_BD_MaterialPlan where fmaterialid = '" + materialID + "' and forgunit=  '" + storageOrgUnitID + "' ";
        IRowSet purid = this.executeQuery(sql);
        try {
            while (purid.next()) {
                purOrgID = purid.getString("FPurOrgID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return purOrgID;
    }

    private void checkBaseMaterialTable(Context ctx, Set set, Map map, Map currentFIUnits) throws BOSException, EASBizException {
        if (set.size() == 0) {
            return;
        }
        StringBuffer materIds = new StringBuffer();
        StringBuffer caiwuIds = new StringBuffer();
        Iterator it = set.iterator();
        PlannedOrderInfo plan = null;
        String orgUnitId = null;
        String caiwuId = null;
        while (it.hasNext()) {
            plan = (PlannedOrderInfo)it.next();
            if (it.hasNext()) {
                materIds.append("'").append(plan.getMaterial().getId().toString()).append("'").append(",");
            } else {
                materIds.append("'").append(plan.getMaterial().getId().toString()).append("'");
            }
            orgUnitId = plan.getStorageOrgUnit().getId().toString();
            if (currentFIUnits.get(orgUnitId) != null && caiwuIds.indexOf(caiwuId = (String)currentFIUnits.get(orgUnitId)) == -1) {
                caiwuIds.append("'").append(caiwuId).append("'").append(",");
            }
            if (currentFIUnits.get(orgUnitId = plan.getProductionOrgUnit().getId().toString()) == null || caiwuIds.indexOf(caiwuId = (String)currentFIUnits.get(orgUnitId)) != -1) continue;
            caiwuIds.append("'").append(caiwuId).append("'").append(",");
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select FID, FMaterialID,FCompanyID,Fstatus from t_bd_materialcompanyinfo where FMaterialID in ( ").append(materIds.toString()).append(" ) and FCompanyID  in (").append(caiwuIds.toString().substring(0, caiwuIds.toString().length() - 1)).append(") and fstatus = 0 ");
        IRowSet rs = this.executeQuery(sql.toString());
        String materalId = null;
        String companyId = null;
        String matera = null;
        caiwuId = null;
        orgUnitId = null;
        plan = null;
        try {
            while (rs.next()) {
                materalId = rs.getString("FMaterialID");
                companyId = rs.getString("FCompanyID");
                it = set.iterator();
                while (it.hasNext()) {
                    plan = (PlannedOrderInfo)it.next();
                    matera = plan.getMaterial().getId().toString();
                    orgUnitId = plan.getStorageOrgUnit().getId().toString();
                    if (currentFIUnits.get(orgUnitId) != null) {
                        caiwuId = (String)currentFIUnits.get(orgUnitId);
                        if (materalId.equals(matera) && companyId.equals(caiwuId)) {
                            map.put(plan.getNumber(), new PlanOrderException(PlanOrderException.RELEASE_CHK_FIN_EXCEPTION1).getMessage());
                            it.remove();
                            continue;
                        }
                    }
                    if (currentFIUnits.get(orgUnitId = plan.getProductionOrgUnit().getId().toString()) == null) continue;
                    caiwuId = (String)currentFIUnits.get(orgUnitId);
                    if (!materalId.equals(matera) || !companyId.equals(caiwuId)) continue;
                    map.put(plan.getNumber(), new PlanOrderException(PlanOrderException.RELEASE_CHK_FIN_EXCEPTION1).getMessage());
                    it.remove();
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void groupingByOutsourcing(Context ctx, Set set, Map currentFIUnits, Set outsourcingPurrequest, Set stockTransferBillSet, Set tsfOrderBillSet, Set subContractOrderSet) throws EASBizException, BOSException {
        PlannedOrderInfo plannedInfo = null;
        String orgUnitid = null;
        String purOrgUnitid = null;
        String orgUnitCaiwuId = null;
        String purOrgUnitCaiwuId = null;
        Iterator it = set.iterator();
        Boolean paramValue = null;
        while (it.hasNext()) {
            plannedInfo = (PlannedOrderInfo)it.next();
            orgUnitid = plannedInfo.getStorageOrgUnit().getId().toString();
            if (orgUnitid.equals(purOrgUnitid = plannedInfo.getProductionOrgUnit().getId().toString())) {
                if (paramValue == null) {
                    paramValue = this.getParamValue(ctx, orgUnitid, "PLAN_OUTSOURCING");
                }
                if (Boolean.TRUE.equals(paramValue)) {
                    subContractOrderSet.add(plannedInfo);
                    continue;
                }
                outsourcingPurrequest.add(plannedInfo);
                continue;
            }
            orgUnitCaiwuId = (String)currentFIUnits.get(orgUnitid);
            if (orgUnitCaiwuId.equals(purOrgUnitCaiwuId = (String)currentFIUnits.get(purOrgUnitid))) {
                stockTransferBillSet.add(plannedInfo);
                continue;
            }
            tsfOrderBillSet.add(plannedInfo);
        }
    }

    private void setPlanndOrderEntryTotalQty(PlannedOrderCollection plannedOrdercbcn, Map tempMapqty, Map tempbaseqty) {
        if (plannedOrdercbcn == null || plannedOrdercbcn.size() == 0) {
            return;
        }
        PlannedOrderInfo plannedOrderInfo = null;
        for (int i = 0; i < plannedOrdercbcn.size(); ++i) {
            plannedOrderInfo = plannedOrdercbcn.get(i);
            this.writePlannedEntryQty(plannedOrderInfo, tempMapqty, tempbaseqty);
        }
    }

    private void writePlannedEntryQty(PlannedOrderInfo planned, Map tempMapqty, Map tempbaseqty) {
        BigDecimal thisTotalReleaseQty = null;
        BigDecimal thisTotalReleasebaseQty = null;
        BigDecimal qty = planned.getQty();
        BigDecimal baseqty = planned.getBaseQty();
        if (planned == null || planned.get("thisTotalReleaseQty") == null) {
            return;
        }
        thisTotalReleaseQty = (BigDecimal)planned.get("thisTotalReleaseQty");
        if (planned != null && planned.get("thisTotalReleaseBaseQty") != null) {
            thisTotalReleasebaseQty = (BigDecimal)planned.get("thisTotalReleaseBaseQty");
        }
        BigDecimal weiTotalReleaseQty = planned.getTotalReleaseQty();
        tempMapqty.put(planned.getId().toString(), weiTotalReleaseQty);
        BigDecimal weiBaseTotalReleaseQty = planned.getBaseTotalReleaseQty();
        tempbaseqty.put(planned.getId().toString(), weiBaseTotalReleaseQty);
        BigDecimal thisEntryTotalReleaseQty = null;
        BigDecimal thisEntryTotalReleaseBaseQty = null;
        planned.setTotalReleaseQty(qty.add(thisTotalReleaseQty.negate()));
        planned.setBaseTotalReleaseQty(baseqty.add(thisTotalReleasebaseQty.negate()));
        if (planned.getEntries() != null && planned.getEntries().size() > 0) {
            PlannedOrderEntryInfo plannedOrderEntryInfo = null;
            for (int i = 0; i < planned.getEntries().size(); ++i) {
                plannedOrderEntryInfo = planned.getEntries().get(i);
                if (plannedOrderEntryInfo.getBaseDemandQty().compareTo(plannedOrderEntryInfo.getReleaseBaseQty()) == 0) {
                    planned.getEntries().removeObject(i);
                    --i;
                    continue;
                }
                thisEntryTotalReleaseQty = thisTotalReleaseQty.multiply(plannedOrderEntryInfo.getDemandQty().add(plannedOrderEntryInfo.getReleaseQty().negate())).divide(qty.add(weiTotalReleaseQty.negate()), 4);
                thisEntryTotalReleaseBaseQty = thisTotalReleasebaseQty.multiply(plannedOrderEntryInfo.getBaseDemandQty().add(plannedOrderEntryInfo.getReleaseBaseQty().negate())).divide(baseqty.add(weiBaseTotalReleaseQty.negate()), 4);
                plannedOrderEntryInfo.setReleaseQty(thisEntryTotalReleaseQty.negate().add(plannedOrderEntryInfo.getDemandQty()));
                plannedOrderEntryInfo.setReleaseBaseQty(thisEntryTotalReleaseBaseQty.negate().add(plannedOrderEntryInfo.getBaseDemandQty()));
            }
        }
    }

    private boolean checkPlanStartTime(Date startDate, Date nowDate) {
        boolean result = false;
        if (startDate.before(nowDate)) {
            result = true;
        }
        return result;
    }

    private void deleteSaveBill(Context ctx, List failedDestBillIds) throws BOSException, EASBizException {
        String[] sqls = new String[10];
        StringBuffer sql = new StringBuffer();
        String idStr = SQLUtil.arrayToString((Object[])failedDestBillIds.toArray());
        if (idStr.length() > 2) {
            ReqPlanReceiveReqDataFacadeFactory.getLocalInstance(ctx).receiveReqPlanDate("B2aZSVXaSx6qxdfekgCmrEY+1VI=", idStr, 104);
        }
        sql.append("delete T_MM_MFTOrderStock  where fparentid in(");
        sql.append(idStr);
        sql.append(")");
        sqls[0] = sql.toString();
        sql.setLength(0);
        sql.append("delete T_MM_MFTOrderTechnics  where fparentid in(");
        sql.append(idStr);
        sql.append(")");
        sqls[1] = sql.toString();
        sql.setLength(0);
        sql.append("delete T_MM_ManufactureOrder  where fid in(");
        sql.append(idStr);
        sql.append(")");
        sqls[2] = sql.toString();
        if (idStr.length() > 2) {
            ReqPlanReceiveReqDataFacadeFactory.getLocalInstance(ctx).receiveReqPlanDate("ejIZHXXTQliYCQJg9t4Re0Y+1VI=", idStr, 104);
        }
        sql.setLength(0);
        sql.append("delete T_MM_ProductionOrderSEntry  where fparentid in(");
        sql.append(idStr);
        sql.append(")");
        sqls[3] = sql.toString();
        sql.setLength(0);
        sql.append("delete T_MM_ProductionOrderOEntry  where fparentid in(");
        sql.append(idStr);
        sql.append(")");
        sqls[4] = sql.toString();
        sql.setLength(0);
        sql.append("delete T_MM_ProductionOrder  where fid in(");
        sql.append(idStr);
        sql.append(")");
        sqls[5] = sql.toString();
        sql.setLength(0);
        sql.append("delete T_SM_PurRequest  where fid in(");
        sql.append(idStr);
        sql.append(")");
        sqls[6] = sql.toString();
        sql.setLength(0);
        sql.append("delete T_SM_PurRequestEntry  where fparentid in(");
        sql.append(idStr);
        sql.append(")");
        sqls[7] = sql.toString();
        idStr = SQLUtil.arrayToString((Object[])failedDestBillIds.toArray());
        sql.setLength(0);
        sql.append("delete T_BOT_Relation  where FDestObjectID in(");
        sql.append(idStr);
        sql.append(")");
        sqls[8] = sql.toString();
        sql.setLength(0);
        sql.append("delete T_BOT_RelationEntry  where FDestObjectID in(");
        sql.append(idStr);
        sql.append(")");
        sqls[9] = sql.toString();
        SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
    }

    private void writeBackPlanOrder(Context ctx, Set ids, Map tempMapqty, Map tempMapbaseqty) throws BOSException {
        if (ids.size() == 0) {
            return;
        }
        StringBuffer sqlOrder = new StringBuffer();
        sqlOrder.append("update T_MM_PlannedOrder set FBASESTATUS = ?");
        sqlOrder.append(",FTOTALRELEASEQTY = (FTOTALRELEASEQTY + ?)");
        sqlOrder.append(",FBASETOTALRELEASEQTY = (FBASETOTALRELEASEQTY + ?)");
        sqlOrder.append(" where FID = ?");
        Iterator it = ids.iterator();
        PlannedOrderInfo plannedOrderInfo = null;
        String fid = null;
        BigDecimal qty = null;
        BigDecimal totalReleaseQty = null;
        BigDecimal temqty = null;
        BigDecimal tempbaseqty = null;
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] params = null;
        while (it.hasNext()) {
            BigDecimal releasebaseTotalQty;
            BigDecimal releaseTotalQty;
            plannedOrderInfo = (PlannedOrderInfo)it.next();
            temqty = (BigDecimal)tempMapqty.get(plannedOrderInfo.getId().toString());
            if (temqty != null) {
                plannedOrderInfo.setTotalReleaseQty(temqty);
            }
            if ((tempbaseqty = (BigDecimal)tempMapbaseqty.get(plannedOrderInfo.getId().toString())) != null) {
                plannedOrderInfo.setBaseTotalReleaseQty(tempbaseqty);
            }
            if ((releaseTotalQty = (BigDecimal)plannedOrderInfo.get("thisTotalReleaseQty")) == null) {
                releaseTotalQty = plannedOrderInfo.getQty().add(plannedOrderInfo.getTotalReleaseQty().negate());
            }
            if ((releasebaseTotalQty = (BigDecimal)plannedOrderInfo.get("thisTotalReleaseBaseQty")) == null) {
                releasebaseTotalQty = plannedOrderInfo.getBaseQty().add(plannedOrderInfo.getBaseTotalReleaseQty().negate());
            }
            fid = plannedOrderInfo.getId().toString();
            qty = plannedOrderInfo.getQty();
            totalReleaseQty = plannedOrderInfo.getTotalReleaseQty();
            params = new Object[4];
            params[0] = totalReleaseQty.add(releaseTotalQty).compareTo(qty) >= 0 ? new Integer(7) : new Integer(4);
            if (plannedOrderInfo.get("thisisClose") != null && ((Boolean)plannedOrderInfo.get("thisisClose")).booleanValue()) {
                params[0] = new Integer(7);
            }
            params[1] = releaseTotalQty;
            params[2] = releasebaseTotalQty;
            params[3] = fid;
            paramList.add(params);
        }
        this.executeBatch(sqlOrder.toString(), paramList);
    }

    private void writerbackPlannedOrderEnty(Context ctx, Set ids) throws BOSException {
        if (ids.size() == 0) {
            return;
        }
        StringBuffer sqlOrder = new StringBuffer();
        sqlOrder.append(" update T_MM_PlannedOrderEntry as entry set (freleaseQty,freleaseBaseQty) = (").append("  select round(decimal(?*to_number((t1.FDemandQty-t1.FReleaseQty)/?) +t1.FReleaseQty,21,8),t2.FQtyPrecision) ,").append(" round(decimal((?*to_number((t1.FBaseDemandQty-t1.FReleaseBaseQty)/?) +t1.FReleaseBaseQty) ,21,8), t3.FQtyPrecision) ").append(" from T_MM_PlannedOrder as t0 , T_MM_PlannedOrderEntry as t1 , t_bd_multimeasureunit as t2 ").append(", t_bd_multimeasureunit as t3 \n").append(" where t0.fid = t1.fparentid and  t1.FMaterialID = t2.FMaterialID and t1.FUnitID = t2.fmeasureunitid ").append("  and t1.FMaterialID = t3.FMaterialID and t1.FBaseUnitID = t3.fmeasureunitid ").append(" and t0.FID = ? and entry.fid = t1.fid) ");
        StringBuffer sb = new StringBuffer();
        sb.append(" update T_MM_PlannedOrderEntry as entry set (freleaseQty,freleaseBaseQty) = (").append(" select t1.FDemandQty, ").append("       t1.FBaseDemandQty ").append(" from T_MM_PlannedOrder as t0 , T_MM_PlannedOrderEntry as t1 ").append(" where t0.fid = t1.fparentid").append(" and t0.FID = ? and entry.fid = t1.fid)");
        Iterator it = ids.iterator();
        PlannedOrderInfo plannedOrderInfo = null;
        String fid = null;
        BigDecimal qty = null;
        BigDecimal baseQty = null;
        BigDecimal totalReleaseQty = null;
        ArrayList<Object[]> sbParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> sqlOrderParamList = new ArrayList<Object[]>();
        while (it.hasNext()) {
            BigDecimal releasebaseTotalQty;
            plannedOrderInfo = (PlannedOrderInfo)it.next();
            BigDecimal releaseTotalQty = (BigDecimal)plannedOrderInfo.get("thisTotalReleaseQty");
            if (releaseTotalQty == null) {
                releaseTotalQty = plannedOrderInfo.getQty().add(plannedOrderInfo.getTotalReleaseQty().negate());
            }
            if ((releasebaseTotalQty = (BigDecimal)plannedOrderInfo.get("thisTotalReleaseBaseQty")) == null) {
                releasebaseTotalQty = plannedOrderInfo.getBaseQty().add(plannedOrderInfo.getBaseTotalReleaseQty().negate());
            }
            fid = plannedOrderInfo.getId().toString();
            qty = plannedOrderInfo.getQty();
            baseQty = plannedOrderInfo.getBaseQty();
            totalReleaseQty = plannedOrderInfo.getTotalReleaseQty();
            if (totalReleaseQty.add(releaseTotalQty).compareTo(qty) >= 0) {
                sbParamList.add(new Object[]{fid});
                continue;
            }
            sqlOrderParamList.add(new Object[]{releaseTotalQty, qty.add(plannedOrderInfo.getTotalReleaseQty().negate()), releasebaseTotalQty, baseQty.add(plannedOrderInfo.getBaseTotalReleaseQty().negate()), fid});
        }
        if (sbParamList.size() > 0) {
            this.executeBatch(sb.toString(), sbParamList);
        }
        if (sqlOrderParamList.size() > 0) {
            this.executeBatch(sqlOrder.toString(), sqlOrderParamList);
        }
    }

    private void updateReqPlanDataForRelease(Context ctx, String poId, Set outsourcing, Set discreteSet, Set flowSet, Set subContractOrderSet, List successTargetBillIds) throws Exception {
        if (outsourcing.size() == 0 && discreteSet.size() == 0 && flowSet.size() == 0 && subContractOrderSet.size() == 0) {
            return;
        }
        String[] sqls = new String[2];
        StringBuffer sqlBuffer = new StringBuffer();
        if (outsourcing.size() > 0 || discreteSet.size() > 0 || flowSet.size() > 0 || subContractOrderSet.size() > 0) {
            sqlBuffer = this.getInsertSql();
            String selectSql = this.updatePlanDataForPlanOrder(poId);
            if (selectSql == null) {
                return;
            }
            sqlBuffer.append(selectSql);
            sqls[0] = sqlBuffer.toString();
            this.execute(sqls[0]);
            IReqPlanWriteOffFacade reqPlanReceiveReqDataFacade = ReqPlanWriteOffFacadeFactory.getLocalInstance(ctx);
            reqPlanReceiveReqDataFacade.immdiateCounteract(null);
        }
        if (discreteSet.size() > 0) {
            sqlBuffer.setLength(0);
            String moIds = SQLUtil.arrayToString((Object[])successTargetBillIds.toArray());
            sqlBuffer = this.getInsertSql();
            sqlBuffer.append(this.updatePlanDataForManufacturOrder(poId, moIds));
            sqls[1] = sqlBuffer.toString();
        }
        if (flowSet.size() > 0) {
            sqlBuffer.setLength(0);
            String proIds = SQLUtil.arrayToString((Object[])successTargetBillIds.toArray());
            sqlBuffer = this.getInsertSql();
            sqlBuffer.append(this.updatePlanDataForProductionOrder(poId, proIds));
            sqls[1] = sqlBuffer.toString();
        }
        if (sqls[1] != null) {
            this.execute(sqls[1]);
            IReqPlanWriteOffFacade reqPlanReceiveReqDataFacade = ReqPlanWriteOffFacadeFactory.getLocalInstance(ctx);
            reqPlanReceiveReqDataFacade.immdiateCounteract(null);
        }
    }

    private StringBuffer getInsertSql() {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("INSERT INTO T_MM_ReqPlanData ").append("(fID,").append("FSrcOfSourceBillID,").append("fSourceBillTypeID,").append("FSrcOfSourceEntryID,").append("fStorageOrgUnitID,").append("fSourceSUID,").append("fSourceBillID,").append("FSourceEntryID,").append("fsrcSeq,").append("fBillTypeID,").append("FSrcNumber,").append("fRequireDate,").append("fMaterialID,").append("fUnitID,").append("fBaseUnitID,").append("fQty,").append("fBaseQty,").append("fOriginType,").append("fOperationType,").append("fCreatorID,").append("fCreateTime,").append("fFailTimes,").append("fProjectID,").append("fTrackNumberID,").append("fIsDirectTransport, ").append("Fisaddnew,FisWriteOff,FisOrderToOrder,FaddPlanType,FWriteOffPlanType,FisRubricWriteOff,").append("FisNowWriteOff,FisDeletePlan,fReqSource)");
        return sqlBuffer;
    }

    private String updatePlanDataForPlanOrder(String poId) throws BOSException {
        if (poId.length() < 10) {
            return null;
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT newbosid('D02F7535'), ").append("poEntry.FSourceBillID, ").append("poEntry.FSourceBillTypeId, ").append("poEntry.FSourceBillEntryID, ").append("case when poEntry.FProvideType in (10930,10940) then  poEntry.FStorageOrgUnitID else po.FStorageOrgUnitID end , ").append("po.FStorageOrgUnitID, ").append("po.fId, ").append("poEntry.fId, ").append("poEntry.fseq, ").append("po.fBillTypeId, ").append("po.fNumber, ").append("poEntry.fReqDate, ").append("poEntry.fmaterialId, ").append("poEntry.fUnitId, ").append("poEntry.fBaseUnitId, ").append("poEntry.fDemandQty - poEntry.fReleaseQty, ").append("poEntry.fBaseDemandQty - poEntry.fReleaseBaseQty, ").append(90).append(", ").append(801).append(" as fOperationType ,").append("po.fAuditorId, ").append("").append(this.getCurTime()).append(", ").append("0, ").append("po.fProjectId, ").append("po.FTrackId, ").append("(case when poEntry.FIssMode=").append(11050).append(" then 1 else 0 end) as fIsDirectTransport,").append("(case when po.FBASESTATUS=7 or po.FBASETOTALRELEASEQTY=po.fbaseqty  then 0  else 1 end) as  Fisaddnew, ").append("(case when po.FBASESTATUS=7 or po.FBASETOTALRELEASEQTY=po.fbaseqty  then 0  else 1 end) as FisWriteOff,").append("0 as FisOrderToOrder,").append("(case when po.FBASESTATUS=7 or po.FBASETOTALRELEASEQTY=po.fbaseqty  then null ").append(" when poEntry.FProvideType in (10930,10940)  and poEntry.FIssMode<>11040  then '").append("NcvxPgEcEADgAAiuwKgL09hs+cg=").append("' when poEntry.FProvideType in (10910,10920) and mp.FIsComReqConsume=1  and poEntry.FIssMode<>11040 then '").append("LIggukxnQ0eNvHc34XGmuNhs+cg=").append("' else null end) as faddPlanType,").append("(case when po.FBASESTATUS=7 or po.FBASETOTALRELEASEQTY=po.fbaseqty   or poEntry.FIssMode=11040  then 0 else ").append(7).append(" end)  as FWriteOffPlanType,").append("1 as FisRubricWriteOff,").append("0 as  FisNowWriteOff, ").append("1 as FisDeletePlan ,").append(" (case when poEntry.FProvideType in (10930,10940) then ").append(50).append(" when poEntry.FProvideType in (10910,10920) and mp.FIsComReqConsume=1 then ").append(100).append(" else 0 end) as fReqSource ").append(" from T_bd_materialplan mp ").append(" inner join T_mm_plannedorderentry poEntry on poEntry.fmaterialId = mp.fmaterialId ").append(" inner join t_mm_plannedorder po ").append(" on po.fid = poEntry.FParentID and po.FStorageOrgUnitID = mp.ForgUnit ").append("where po.fid in (").append(poId).append(") ");
        return sqlBuffer.toString();
    }

    private String updatePlanDataForManufacturOrder(String poId, String moIds) throws BOSException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT newbosid('D02F7535'),").append("ManufactureOrder.fSourceBillId, ").append("ManufactureOrder.fSourceBilltypeId, ").append("null,").append(" case when stock.FProvideType in (10930,10940) then stock.FStorageOrgUnitID else ManufactureOrder.FStorageOrgUnitID end , ").append("ManufactureOrder.FStorageOrgUnitID, ").append("ManufactureOrder.fId, ").append("stock.fId, ").append("stock.fseq, ").append("ManufactureOrder.fBillTypeId, ").append("ManufactureOrder.fNumber, ").append("stock.FDemandTime, ").append("stock.fmaterialId, ").append("stock.fUnitId, ").append("stock.fBaseUnitId, ").append("stock.FPlannedQty, ").append("stock.FPlannedBaseQty, ").append(90).append(", ").append(102).append(", ").append(" case when ManufactureOrder.fAuditorId is null then ManufactureOrder.fLastUpdateUserId else  ManufactureOrder.fAuditorId end , ").append("").append(this.getCurTime()).append(", ").append("0, ").append(" ManufactureOrder.fProjectId, ").append(" ManufactureOrder.FTrackId, ").append("(case when stock.FIssueMode=").append(11050).append(" then 1 else 0 end) as fIsDirectTransport, ").append("1 as  Fisaddnew, ").append("1 as FisWriteOff,").append("0 as FisOrderToOrder,").append("( case when stock.FProvideType in (10930,10940) and stock.FIssueMode <> 11040 then '").append("NcvxPgEcEADgAAiuwKgL09hs+cg=").append("' when mp.FIsComReqConsume = 1 and stock.FIssueMode <> 11040 then '").append("LIggukxnQ0eNvHc34XGmuNhs+cg=").append("' else null end )as faddPlanType,").append("( case when stock.FProvideType in (10930,10940) and stock.FIssueMode <> 11040 then ").append(7).append(" when mp.FIsComReqConsume = 1 and stock.FIssueMode <> 11040 then ").append(1).append(" else 0 end )as FWriteOffPlanType, ").append("0 as FisRubricWriteOff,").append("0 as  FisNowWriteOff, ").append("0 as FisDeletePlan ,").append("( case when stock.FProvideType in (10930,10940) then ").append(50).append(" when mp.FIsComReqConsume = 1 then ").append(100).append(" else 0 end )as fReqSource ").append(" from  T_MM_ManufactureOrder ManufactureOrder ").append("inner join T_MM_MFTOrderStock stock on stock.fparentId = ManufactureOrder.fId ").append(" inner join  T_bd_materialplan mp on  stock.fmaterialId = mp.fmaterialId and mp.forgunit = ManufactureOrder.FStorageOrgUnitID ").append("where ManufactureOrder.fId in (").append(moIds).append(") ");
        return sqlBuffer.toString();
    }

    private String updatePlanDataForProductionOrder(String poId, String proIds) throws BOSException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT newbosid('D02F7535') AS FID,").append("productionOrder.FSourceBillID AS FSrcOfSourceBillID, ").append("productionOrder.fSourceBillTypeID AS fSourceBillTypeID, ").append("productionEntry.FSourceBillEntryID AS FSrcOfSourceEntryID, ").append(" case when productionEntry.FProvideType = 10930  then productionEntry.FSupplyStorageOrgUnitID else productionOrder.FStorageOrgUnitID end as fStorageOrgUnitID, ").append("productionOrder.FStorageOrgUnitID AS fSourceSUID, ").append("productionOrder.fId AS fSourceBillID, ").append("productionEntry.fId AS FSourceEntryID , ").append("productionEntry.fseq AS fsrcSeq, ").append("productionOrder.fBillTypeId AS fBillTypeID, ").append("productionOrder.fNumber AS FSrcNumber, ").append("productionEntry.fStartdate AS fRequireDate, ").append("productionEntry.fmaterialId AS fMaterialID, ").append("productionEntry.fUnitId AS fUnitID, ").append("productionEntry.fBaseUnitId AS fBaseUnitID, ").append("productionEntry.fQty AS fQty, ").append("productionEntry.fBaseQty AS fBaseQty, ").append(90).append(" AS fOriginType, ").append(102).append(" AS fOperationType, ").append(" case when productionOrder.fAuditorId is null then productionOrder.fLastUpdateUserId else  productionOrder.fAuditorId end , ").append("").append(this.getCurTime()).append(" AS fCreateTime, ").append("0 AS fFailTimes, ").append(" null AS fProjectID, ").append(" productionOrder.FTrackNumberID, ").append("(case when productionEntry.FIssMode=").append(11050).append(" then 1 else 0 end) as fIsDirectTransport, ").append("1 as  Fisaddnew, ").append("1 as FisWriteOff,").append("0 as FisOrderToOrder,").append("( case when productionEntry.FProvideType = 10930 and productionEntry.FIssMode <> 11040 then '").append("NcvxPgEcEADgAAiuwKgL09hs+cg=").append("' when mp.FIsComReqConsume = 1 and productionEntry.FIssMode <> 11040 and productionEntry.FProvideType in (10910,10920 )then '").append("LIggukxnQ0eNvHc34XGmuNhs+cg=").append("' else null end )as faddPlanType,").append("( case when productionEntry.FProvideType = 10930 and productionEntry.FIssMode <> 11040 then ").append(7).append(" when mp.FIsComReqConsume = 1 and productionEntry.FIssMode <> 11040 and  productionEntry.FProvideType in (10910,10920 )then ").append(1).append(" else 0 end )as FWriteOffPlanType,").append("0 as FisRubricWriteOff,").append("0 as  FisNowWriteOff, ").append("0 as FisDeletePlan ,").append("( case when productionEntry.FProvideType =10930 then ").append(50).append(" when mp.FIsComReqConsume = 1 then ").append(100).append(" else 0 end )as fReqSource ").append(" from  T_MM_ProductionOrder productionOrder ").append(" inner join T_MM_ProductionOrderSEntry productionEntry on productionEntry.fparentId = productionOrder.fId").append(" inner join T_bd_materialPlan as mp on mp.forgunit = productionOrder.FStorageOrgUnitID  and mp.fmaterialid = productionEntry.fmaterialid ").append(" where  productionOrder.fId in (").append(proIds).append(") ");
        return sqlBuffer.toString();
    }

    private String getCurTime() throws BOSException {
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, 1);
        Date curTime = calendar.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        String now = "{ts'" + sdf.format(curTime) + "'}";
        return now;
    }
}

