/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.release.batch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.common.EASBizException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AbstractProcessor {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.mo.app.release.enhancement.processor.AbstractProcessor");
    protected Context ctx;
    protected IObjectCollection collection;
    private long start;
    private long end;
    List beforeProcessors = new ArrayList();
    List afterProcessors = new ArrayList();

    public AbstractProcessor(Context ctx, IObjectCollection collection) {
        this.ctx = ctx;
        this.collection = collection;
    }

    public abstract void innerDoing() throws EASBizException, BOSException;

    public final void doing() throws EASBizException, BOSException {
        this.loggingBefore();
        try {
            int i;
            int count = this.beforeProcessors.size();
            for (i = 0; i < count; ++i) {
                ((AbstractProcessor)this.beforeProcessors.get(i)).doing();
            }
            this.innerDoing();
            count = this.afterProcessors.size();
            for (i = 0; i < count; ++i) {
                ((AbstractProcessor)this.afterProcessors.get(i)).doing();
            }
        }
        catch (EASBizException e) {
            logger.info((Object)(this.getLogDesc() + " ERROR:"), (Throwable)e);
            throw e;
        }
        catch (BOSException e) {
            logger.info((Object)(this.getLogDesc() + " ERROR:"), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.info((Object)(this.getLogDesc() + " ERROR:"), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.loggingAfter();
        }
    }

    public void loggingBefore() {
        this.start = System.currentTimeMillis();
        logger.info((Object)(this.getLogDesc() + " start at: " + this.start));
    }

    public void loggingAfter() {
        this.end = System.currentTimeMillis();
        logger.info((Object)(this.getLogDesc() + " end at: " + this.end));
        logger.info((Object)(this.getLogDesc() + " spend " + (this.end - this.start) / 1000L + " S "));
    }

    public AbstractProcessor addBeforeProcessor(AbstractProcessor processor) {
        this.beforeProcessors.add(processor);
        return this;
    }

    public AbstractProcessor addAfterProcessor(AbstractProcessor processor) {
        this.afterProcessors.add(processor);
        return this;
    }

    protected String getLogDesc() {
        String str = this.getClass().getName();
        int i = str.lastIndexOf(".");
        str = str.substring(i + 1, str.length());
        str = "thread is: " + Thread.currentThread().getName() + " processor is: " + str + " ";
        return str;
    }
}

