/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.release.batch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.app.MMLogger;
import com.kingdee.eas.mm.planning.app.release.batch.AbstractProcessor;
import com.kingdee.eas.mm.planning.app.release.batch.AbstractProcessorRequest;
import com.kingdee.eas.mm.planning.app.release.batch.Future;
import com.kingdee.eas.mm.planning.app.release.batch.ProcessorRequestQueue;
import com.kingdee.eas.mm.planning.app.release.batch.WrapCollection;
import com.kingdee.eas.scm.sm.pur.IPurRequest;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class PurRequestSubmitProcessor
extends AbstractProcessor {
    private static Logger logger = MMLogger.getLogger();
    private ProcessorRequestQueue processorRequestQueue;
    protected BatchActionResults results;
    protected static final int MAXSIZE = 200;

    public PurRequestSubmitProcessor(Context ctx, IObjectCollection collection) {
        super(ctx, collection);
    }

    public PurRequestSubmitProcessor(Context ctx, IObjectCollection collection, ProcessorRequestQueue processorRequestQueue) {
        this(ctx, collection);
        this.processorRequestQueue = processorRequestQueue;
    }

    public BatchActionResults getResults() {
        return this.results;
    }

    @Override
    public void innerDoing() throws EASBizException, BOSException {
        int i;
        final BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[this.collection.size()];
        BatchExecuteParamsEntry entry = null;
        for (int i2 = 0; i2 < this.collection.size(); ++i2) {
            PurRequestInfo purRequestInfo = (PurRequestInfo)this.collection.getObject(i2);
            entries[i2] = entry = new BatchExecuteParamsEntry(new Class[]{CoreBillBaseInfo.class, BOTRelationCollection.class}, new Object[]{purRequestInfo, null});
        }
        ArrayList<Future> futureList = new ArrayList<Future>();
        final ArrayList batchResultList = new ArrayList();
        int size = this.collection.size();
        int begin = 0;
        int end = 0;
        int time = size % this.getMaxSize() == 0 ? size / this.getMaxSize() : size / this.getMaxSize() + 1;
        for (i = 0; i < time; ++i) {
            begin = this.getMaxSize() * i;
            end = i + 1 < time ? this.getMaxSize() * (i + 1) : size;
            Future future = new Future();
            final int start = begin;
            final int over = end;
            final IObjectCollection cols = this.collection;
            AbstractProcessorRequest request = new AbstractProcessorRequest(future, this){

                @Override
                public void doing() {
                    WrapCollection data = new WrapCollection(cols);
                    try {
                        IPurRequest ipurreq = PurRequestFactory.getLocalInstance((Context)PurRequestSubmitProcessor.this.ctx);
                        BatchExecuteParamsEntry[] entries1 = new BatchExecuteParamsEntry[over - start];
                        int k = 0;
                        for (int i = start; i < over; ++i) {
                            entries1[k++] = entries[i];
                        }
                        long time1 = System.currentTimeMillis();
                        BatchExecuteResult result11 = ipurreq.batchExecute("submitRelations", new Class[]{CoreBillBaseInfo.class, BOTRelationCollection.class}, entries1);
                        long time2 = System.currentTimeMillis();
                        logger.error((Object)("#############\u63d0\u4ea4\u91c7\u8d2d\u7533\u8bf7\u5355" + k + ": " + (time2 - time1)));
                        if (result11 != null) {
                            BatchActionResults results = (BatchActionResults)result11.getBatchResult();
                            batchResultList.add(results);
                        }
                        this.future.setData(data);
                    }
                    catch (EASBizException e) {
                        logger.info((Object)(PurRequestSubmitProcessor.this.getLogDesc() + " ERROR:"), (Throwable)e);
                        this.future.setException((Exception)((Object)e));
                    }
                    catch (BOSException e) {
                        logger.info((Object)(PurRequestSubmitProcessor.this.getLogDesc() + " ERROR:"), (Throwable)e);
                        this.future.setException((Exception)((Object)e));
                    }
                    catch (Exception e) {
                        logger.info((Object)(PurRequestSubmitProcessor.this.getLogDesc() + " ERROR:"), (Throwable)e);
                        this.future.setException(e);
                    }
                }
            };
            if (null != this.processorRequestQueue) {
                logger.info((Object)(this.getLogDesc() + " main thread user blockedQueue! "));
                try {
                    this.processorRequestQueue.putRequest(request);
                }
                catch (InterruptedException e) {
                    logger.info((Object)(this.getLogDesc() + " ERROR:"), (Throwable)e);
                    logger.info((Object)(this.getLogDesc() + " main thread put request error: " + e.getMessage()));
                    future.setException(e);
                }
            } else {
                logger.info((Object)(this.getLogDesc() + " main thread user itselef! "));
                request.doing();
            }
            futureList.add(future);
        }
        logger.info((Object)"begin waiting");
        int count = futureList.size();
        for (i = 0; i < count; ++i) {
            Future future = (Future)futureList.get(i);
            future.getResult();
        }
        logger.info((Object)"end waiting");
        int k = 0;
        for (BatchActionResults result : batchResultList) {
            ++k;
            if (result == null) continue;
            if (1 == k) {
                this.results = result;
                continue;
            }
            this.results.mergeResults(result);
        }
        if (this.results == null) {
            this.results = new BatchActionResults();
        }
        logger.info((Object)"\u63d0\u4ea4\u7ed3\u675f");
    }

    protected int getMaxSize() {
        return 200;
    }
}

