/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.reqplan;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.app.BizCommand;
import com.kingdee.eas.mm.planning.app.reqplan.ReqPlanWriteOffParam;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.List;

public abstract class ReqPlanRunner {
    protected ReqPlanWriteOffParam inParam = null;

    public ReqPlanRunner(Context ctx) {
    }

    public void run(Context ctx, String storageOrgUnitid) throws BOSException, EASBizException {
        this.inParam = this.createnewParam(ctx, storageOrgUnitid);
        try {
            List stepList = this.getStepList(ctx);
            for (int i = 0; i < stepList.size(); ++i) {
                ((BizCommand)stepList.get(i)).execute((Object)this.inParam);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            TempTablePool pool;
            if (this.inParam.getTempTableNameForCalc() != null) {
                pool = TempTablePool.getInstance((Context)ctx);
                pool.releaseTable(this.inParam.getTempTableNameForCalc());
            }
            if (this.inParam.getTempTableNameForDelete() != null) {
                pool = TempTablePool.getInstance((Context)ctx);
                pool.releaseTable(this.inParam.getTempTableNameForDelete());
            }
        }
    }

    protected abstract List getStepList(Context var1);

    private ReqPlanWriteOffParam createnewParam(Context ctx, String storageOrgUnitid) throws BOSException, EASBizException {
        ReqPlanWriteOffParam param = new ReqPlanWriteOffParam();
        String cuID = this.getCU(ctx, storageOrgUnitid);
        boolean iswriteOffDefaultTrackNumber = Boolean.valueOf(ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitid), (String)"Req_Writeoff_Control"));
        String paramValueManul = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitid), (String)"ReqPlan_ManualWriteOff");
        boolean ismanul = Boolean.valueOf(paramValueManul);
        param.setStorageOrgUnitID(storageOrgUnitid);
        param.setCuID(cuID);
        param.setDefaultTrackNumber(this.getDefaultTrackNumber(ctx, cuID));
        param.setIsWriteOffDefaultTrackNumber(iswriteOffDefaultTrackNumber);
        param.setIsmanul(ismanul);
        String reductionMode = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitid), (String)"ReductionMode");
        param.setReductionMode(reductionMode);
        String reqconfumeMode = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitid), (String)"REQCONFUME_MODE");
        param.setReqconfumeMode(reqconfumeMode);
        String subConsumeTime = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitid), (String)"REQCONFUME_TIME");
        param.setSubConsumeTime(subConsumeTime == null ? "0" : subConsumeTime);
        return param;
    }

    private String getCU(Context ctx, String storageOrgUnitID) throws BOSException {
        String cuID = null;
        StringBuffer str = new StringBuffer();
        str.append(" select FControlUnitID from T_ORG_Storage  ");
        str.append(" where fid = '").append(storageOrgUnitID).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        try {
            if (rs.next()) {
                cuID = rs.getString("FControlUnitID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return cuID;
    }

    private String getDefaultTrackNumber(Context ctx, String cuID) throws BOSException {
        String defaultTrackNumber = " ";
        TrackNumberInfo trackNumberInfo = new TrackNumberInfo();
        StringBuffer checkSql = new StringBuffer("");
        checkSql.append("select fid from T_MM_TrackNumber\n").append(" where FDefaultTraceNumberFlag = 1\n").append(" and (FADMINCUID = '").append(cuID).append("' or FID in( select FDataBaseDID FROM T_BD_DataBaseDAssign WHERE FBOSObjectType = '").append(trackNumberInfo.getBOSType()).append("' AND FAssignCUID='").append(cuID).append("'))");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
        try {
            if (rs.next()) {
                defaultTrackNumber = rs.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return defaultTrackNumber;
    }
}

