/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.reqplan;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.planning.ReqPlanStatusEnum;
import com.kingdee.eas.mm.planning.app.reqplan.ReqPlanDataVO;
import com.kingdee.eas.mm.planning.app.reqplan.ReqPlanWriteOff;
import com.kingdee.eas.mm.planning.app.reqplan.WriteOffDataVO;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Set;

public class ReqPlanWriteOffPID
extends ReqPlanWriteOff {
    public ReqPlanWriteOffPID(Context ctx) {
        super(ctx);
    }

    @Override
    protected IRowSet selectWriteOffData(String storageOrgUnitID, String tmpTable) throws EASBizException, BOSException {
        String paramValueManul = ParamManager.getParamValue((Context)this.ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitID), (String)"ReqPlan_ManualWriteOff");
        boolean ismanul = Boolean.valueOf(paramValueManul);
        StringBuffer sql = new StringBuffer();
        sql.append(" select  FSrcOfSourceEntryID as FSRCSourceEntryID,fForwardDaysOffset ,fBackwardDaysOffset,faddPlanType as FSourceReqType,");
        sql.append(" to_date(to_char(fRequireDate,'yyyy-mm-dd')||' 00:00:00')  as fRequireDate, fCreateTime,");
        sql.append(" null as fid,fqty as fNotCntactQty,fbaseqty as fBaseNotCntactQty ,FStorageOrgUnitID,FSourceBillID,FSrcNumber as FSourceBillNum ,FSourceEntryID as fSourceEntryID ,");
        sql.append("FBillTypeID,FMaterialID,FUnitID,FBaseUnitID,fOffsetMode,fManufactureStrategyID,FProjectID,");
        sql.append(" (case when FTrackNumberID is null then '").append(this.param.getDefaultTrackNumber());
        sql.append("' else FTrackNumberID end ) as FTrackNumberID,");
        sql.append(" FIsolatedRule ");
        sql.append(" from ").append(tmpTable).append(" where FSTORAGEORGUNITID = ? and fisWriteOff = 1  ");
        sql.append("  and fWriteOffPlanType = ? and FBillTypeID<>isnull(FSOURCEBILLTYPEID,' ') ");
        sql.append(" and fManufactureStrategyID is not null ");
        sql.append(" and (faddPlanType is null or isnull(faddPlanType,' ') <>  '").append("LIggukxnQ0eNvHc34XGmuNhs+cg=").append("')");
        if (!ismanul) {
            sql.append(" union all ");
            sql.append(" select  null as FSRCSourceEntryID,m.fForwardDaysOffset,m.fBackwardDaysOffset,p.FReqTypeID as FSourceReqType,");
            sql.append(" to_date(to_char(p.fRequireDate,'yyyy-mm-dd')||' 00:00:00')  as fRequireDate, p.fCreateTime,p.fid, p.fNotCntactQty as fNotCntactQty,p.FBaseNotCntactQty as fBaseNotCntactQty, p.FStorageOrgUnitID,");
            sql.append(" to_char(p.FSourceBillID) as fSourceBillID,p.FSourceBillNum as FSourceBillNum ,to_char(p.FSourceEntryID) as fSourceEntryID,");
            sql.append(" p.FBillTypeID,p.FMaterialID,p.FUnitID,p.FBaseUnitID,m.fOffsetMode,p.FManuStrategyID as fManufactureStrategyID,FProjectID,");
            sql.append(" (case when p.FTrackNumberID is null then '").append(this.param.getDefaultTrackNumber());
            sql.append("' else p.FTrackNumberID end ) as FTrackNumberID ,");
            sql.append(" m.FIsolatedRule ");
            sql.append(" from t_mm_RequirementPlan p,t_bd_materialplan m ");
            sql.append(" where p.fMaterialID = m.fMaterialID ");
            sql.append(" and p.fStorageOrgUnitID = m.FOrgUnit");
            sql.append(" and p.fStorageOrgUnitID = '").append(storageOrgUnitID);
            sql.append("' and p.fStatus = ").append(10);
            sql.append(" and p.fNotCntactQty >0");
            sql.append(" and p.FReqTypeID = '").append("LIggukxnQ0eNvHc34XGmuNhs+cg=").append("'");
            sql.append(" and p.FManuStrategyID is not null ");
        }
        sql.append(" order by  FMaterialID ASC ,fRequireDate,fCreateTime ASC ");
        IRowSet reqRow = this.executeQuery(sql.toString(), new Object[]{storageOrgUnitID, new Integer(1)});
        return reqRow;
    }

    @Override
    protected ArrayList getPlanData(String materialID) throws SQLException, EASBizException, BOSException {
        ArrayList<ReqPlanDataVO> reqPlanDataList = new ArrayList<ReqPlanDataVO>();
        StringBuffer sql_queryPICReq = new StringBuffer();
        sql_queryPICReq.append("select fID,fQty,fBaseQty,fCntactTotalQty,fBaseCntactTotalQty,");
        sql_queryPICReq.append(" to_date(to_char(fRequireDate,'yyyy-mm-dd')||' 00:00:00')  as fRequireDate,fMaterialID,fcreateTime, ");
        sql_queryPICReq.append(" (case when FTrackNumberID is null then '").append(this.param.getDefaultTrackNumber());
        sql_queryPICReq.append("' else FTrackNumberID end ) as FTrackNumberID");
        sql_queryPICReq.append(" from t_mm_RequirementPlan ");
        sql_queryPICReq.append(" where fStorageOrgUnitID = '").append(this.param.getStorageOrgUnitID());
        sql_queryPICReq.append("' and fMaterialID in (").append(materialID).append(")");
        sql_queryPICReq.append(" and fStatus =  ").append(10);
        sql_queryPICReq.append(" and fQty>fCntactTotalQty ");
        sql_queryPICReq.append(" and fReqTypeID = '").append("NcvxPgEcEADgAAiowKgL09hs+cg=").append("'");
        sql_queryPICReq.append(" \n ORDER BY fmaterialID ASC,fRequireDate ASC, fcreateTime ASC  ");
        IRowSet rs = this.executeQuery(sql_queryPICReq.toString());
        ReqPlanDataVO reqPlanDataVO = null;
        String materialid = null;
        String lastMaterialid = null;
        while (rs.next()) {
            materialid = rs.getString("fmaterialID");
            if (!materialid.equals(lastMaterialid) && lastMaterialid != null) {
                this.reaPlanDataBufferMap.put(lastMaterialid, reqPlanDataList);
                reqPlanDataList = new ArrayList();
            }
            reqPlanDataVO = new ReqPlanDataVO();
            reqPlanDataVO.setId(rs.getString("fID"));
            reqPlanDataVO.setQty(rs.getBigDecimal("fQty"));
            reqPlanDataVO.setBaseQty(rs.getBigDecimal("fBaseQty"));
            reqPlanDataVO.setCntactTotalQty(rs.getBigDecimal("fCntactTotalQty"));
            reqPlanDataVO.setBaseCntactTotalQty(rs.getBigDecimal("fBaseCntactTotalQty"));
            reqPlanDataVO.setRequireDate(rs.getDate("fRequireDate"));
            reqPlanDataVO.setTrackNumberID(rs.getString("FTrackNumberID"));
            reqPlanDataVO.setStatus(ReqPlanStatusEnum.ACTIVE);
            lastMaterialid = rs.getString("fmaterialID");
            reqPlanDataList.add(reqPlanDataVO);
        }
        this.reaPlanDataBufferMap.put(materialid, reqPlanDataList);
        return reqPlanDataList;
    }

    @Override
    protected int getCntactPlanType(WriteOffDataVO writeOffDataVO) throws SQLException {
        int cntactPlanType = -1;
        if (writeOffDataVO.getId() != null) {
            if (writeOffDataVO.getId() != null && this.param.getReqconfumeMode().equals("0")) {
                cntactPlanType = writeOffDataVO.getOffSetMode();
            } else if (writeOffDataVO.getId() != null && this.param.getReqconfumeMode().equals("1")) {
                cntactPlanType = 2;
            }
        } else if (this.param.getReductionMode().equals("0")) {
            cntactPlanType = 0;
        } else if (this.param.getReductionMode().equals("1")) {
            cntactPlanType = writeOffDataVO.getOffSetMode();
        } else if (this.param.getReductionMode().equals("2")) {
            cntactPlanType = 2;
        }
        return cntactPlanType;
    }

    @Override
    protected String getMaterialsDataSQL(String storageOrgUnitID, Set materialids) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select count(*) as count,fmaterialID from t_mm_RequirementPlan ");
        sql.append(" where  fstorageorgunitid = '").append(storageOrgUnitID).append("'");
        sql.append(" and  fStatus =  ").append(10);
        sql.append(" and fQty>fCntactTotalQty ");
        sql.append(" and fReqTypeID = '").append("NcvxPgEcEADgAAiowKgL09hs+cg=").append("'");
        sql.append("");
        sql.append(" and fmaterialID in ").append(MMUtils.setToString((Set)materialids));
        sql.append(" group by fmaterialID order by fmaterialID");
        return sql.toString();
    }
}

