/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.reqplan;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.planning.ReqPlanStatusEnum;
import com.kingdee.eas.mm.planning.app.reqplan.ReqPlanDataVO;
import com.kingdee.eas.mm.planning.app.reqplan.ReqPlanWriteOff;
import com.kingdee.eas.mm.planning.app.reqplan.WriteOffDataVO;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;

public class ReqPlanWriteOffPIO
extends ReqPlanWriteOff {
    public ReqPlanWriteOffPIO(Context ctx) {
        super(ctx);
    }

    @Override
    protected IRowSet selectWriteOffData(String storageOrgUnitID, String tmpTable) throws EASBizException, BOSException {
        String consPioParamValue = ParamManager.getParamValue((Context)this.ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitID), (String)"MTDREQ_CONSUMEPIOREQ");
        boolean isMTDConsumePio = Boolean.valueOf(consPioParamValue);
        StringBuffer sql = new StringBuffer();
        sql.append(" select FSrcOfSourceEntryID as FSRCSourceEntryID,fForwardDaysOffset ,fBackwardDaysOffset,faddPlanType as FSourceReqType,");
        sql.append(" to_date(to_char(fRequireDate,'yyyy-mm-dd')||' 00:00:00')  as fRequireDate, ");
        sql.append(" fCreateTime, null as fid,fqty as fNotCntactQty,fbaseqty as fBaseNotCntactQty,");
        sql.append(" FStorageOrgUnitID,FSourceBillID,FSrcNumber as fsourceBillNum,FSourceEntryID,");
        sql.append("FBillTypeID,FMaterialID,FUnitID,FBaseUnitID,fOffsetMode,fManufactureStrategyID,");
        sql.append(" (case when FProjectID is null then ' ' else FProjectID end) as FProjectID ,");
        sql.append(" (case when FTrackNumberID is null then '").append(this.param.getDefaultTrackNumber());
        sql.append("' else FTrackNumberID end ) as FTrackNumberID,");
        sql.append(" FIsolatedRule ");
        sql.append(" from ").append(tmpTable).append(" where FSTORAGEORGUNITID = '").append(storageOrgUnitID).append("'");
        sql.append(" and fisWriteOff = 1  and fWriteOffPlanType = ? and FBillTypeID<>isnull(FSOURCEBILLTYPEID,' ') ");
        sql.append(" and fManufactureStrategyID is not null ");
        sql.append(" and (faddPlanType is null or isnull(faddPlanType,' ') <>  '").append("NcvxPgEcEADgAAiwwKgL09hs+cg=").append("')");
        if (isMTDConsumePio) {
            sql.append(" union ");
            sql.append(" select null as FSRCSourceEntryID, m.fForwardDaysOffset,m.fBackwardDaysOffset,p.FReqTypeID as FSourceReqType,");
            sql.append(" to_date(to_char(p.fRequireDate,'yyyy-mm-dd')||' 00:00:00')  as fRequireDate , ");
            sql.append(" p.fCreateTime,p.fid, p.fNotCntactQty as fQty,p.FBaseNotCntactQty as fbaseQty, p.FStorageOrgUnitID,");
            sql.append(" to_char(p.FSourceBillID) as fSourceBillID ,p.FSourceBillNum as fsourceBillNum ,to_char(p.FSourceEntryID),");
            sql.append(" p.FBillTypeID,p.FMaterialID,p.FUnitID,p.FBaseUnitID,m.fOffsetMode,p.FManuStrategyID as fManufactureStrategyID, ");
            sql.append(" (case when p.FProjectID is null then ' ' else p.FProjectID end) as FProjectID ,");
            sql.append(" (case when p.FTrackNumberID is null then '").append(this.param.getDefaultTrackNumber());
            sql.append("' else p.FTrackNumberID end ) as FTrackNumberID,");
            sql.append(" FIsolatedRule ");
            sql.append(" from t_mm_RequirementPlan p,t_bd_materialplan m ");
            sql.append(" where p.fMaterialID = m.fMaterialID ");
            sql.append(" and p.fStorageOrgUnitID = m.FOrgUnit");
            sql.append(" and p.fStorageOrgUnitID = '").append(storageOrgUnitID);
            sql.append("' and p.fStatus = ").append(10);
            sql.append(" and p.fNotCntactQty >0");
            sql.append(" and p.FReqTypeID = '").append("NcvxPgEcEADgAAiwwKgL09hs+cg=").append("'");
            sql.append(" and p.FManuStrategyID is not null ");
        }
        sql.append(" order by  FMaterialID ASC, fRequireDate,fCreateTime ASC ");
        IRowSet reqRow = this.executeQuery(sql.toString(), new Object[]{new Integer(3)});
        return reqRow;
    }

    @Override
    protected WriteOffDataVO createWriteOffDataVO(IRowSet reqRow) throws SQLException {
        WriteOffDataVO writeOffDataVO = new WriteOffDataVO();
        writeOffDataVO.setprojectID(reqRow.getString("FProjectID"));
        writeOffDataVO.setEtoConsumePioValue(reqRow.getString("FIsolatedRule"));
        return writeOffDataVO;
    }

    @Override
    protected ArrayList getPlanData(String materialID) throws SQLException, EASBizException, BOSException {
        ArrayList<ReqPlanDataVO> reqPlanDataList = new ArrayList<ReqPlanDataVO>();
        String defaultTrackNumber = this.param.getDefaultTrackNumber();
        StringBuffer sql_queryPICReq = new StringBuffer();
        sql_queryPICReq.append(" select fID,fQty,fBaseQty,fCntactTotalQty,fBaseCntactTotalQty,");
        sql_queryPICReq.append(" to_date(to_char(fRequireDate,'yyyy-mm-dd')||' 00:00:00')  as fRequireDate,fMaterialID,fcreateTime, ");
        sql_queryPICReq.append(" (case when FProjectID is null then '' else FProjectID end) as FProjectID ,");
        sql_queryPICReq.append(" (case when FTrackNumberID is null then '").append(defaultTrackNumber);
        sql_queryPICReq.append("' else FTrackNumberID end ) as FTrackNumberID ");
        sql_queryPICReq.append(" from t_mm_RequirementPlan ");
        sql_queryPICReq.append(" where fStorageOrgUnitID = '").append(this.param.getStorageOrgUnitID());
        sql_queryPICReq.append("' and fmaterialID in  (").append(materialID).append(")");
        sql_queryPICReq.append(" and fStatus =  ").append(10);
        sql_queryPICReq.append(" and fQty>fCntactTotalQty ");
        sql_queryPICReq.append(" and fReqTypeID = '").append("s0fDJAEoEADgAABCfwAAAdhs+cg=").append("'");
        sql_queryPICReq.append(" \n ORDER BY fmaterialID ASC ,fRequireDate ASC, fcreateTime ASC  ");
        IRowSet rs = this.executeQuery(sql_queryPICReq.toString());
        ReqPlanDataVO reqPlanDataVO = null;
        String materialid = null;
        String lastMaterialid = null;
        while (rs.next()) {
            materialid = rs.getString("fmaterialID");
            if (!materialid.equals(lastMaterialid) && lastMaterialid != null) {
                this.reaPlanDataBufferMap.put(lastMaterialid, reqPlanDataList);
                reqPlanDataList = new ArrayList();
            }
            reqPlanDataVO = new ReqPlanDataVO();
            reqPlanDataVO.setId(rs.getString("fID"));
            reqPlanDataVO.setQty(rs.getBigDecimal("fQty"));
            reqPlanDataVO.setBaseQty(rs.getBigDecimal("fBaseQty"));
            reqPlanDataVO.setCntactTotalQty(rs.getBigDecimal("fCntactTotalQty"));
            reqPlanDataVO.setBaseCntactTotalQty(rs.getBigDecimal("fBaseCntactTotalQty"));
            reqPlanDataVO.setRequireDate(rs.getDate("fRequireDate"));
            reqPlanDataVO.setTrackNumberID(rs.getString("FTrackNumberID"));
            reqPlanDataVO.setProjectID(rs.getString("FProjectID"));
            reqPlanDataVO.setStatus(ReqPlanStatusEnum.ACTIVE);
            lastMaterialid = rs.getString("fmaterialID");
            reqPlanDataList.add(reqPlanDataVO);
        }
        this.reaPlanDataBufferMap.put(materialid, reqPlanDataList);
        return reqPlanDataList;
    }

    @Override
    protected boolean isMatchTrackNumber(WriteOffDataVO writeOffDataVO) {
        boolean isMatchTrackNumber = false;
        String etoConsumePioValue = writeOffDataVO.getEtoConsumePioValue();
        String manufactureStrategy = writeOffDataVO.getManufactureStrategy();
        if (manufactureStrategy.equals("qAYbemEdG9ngQKjAYj0V1dg0uEU=") || manufactureStrategy.equals("qAYfaBzTrmLgQKjAYj0f3dg0uEU=") || manufactureStrategy.equals("fpPxtypCS/ihJ30GjB/UJtg0uEU=") || manufactureStrategy.equals("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=") || manufactureStrategy.equals("GE2FIa4GQ6uhdx0RDGuibtg0uEU=") || manufactureStrategy.equals("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=")) {
            isMatchTrackNumber = true;
        }
        if (etoConsumePioValue.equals("ITEM")) {
            isMatchTrackNumber = false;
        }
        return isMatchTrackNumber;
    }

    @Override
    protected boolean iswriteOff(Date endDate, String trackNumberID, WriteOffDataVO writeOffDataVO, ReqPlanDataVO reqPlanDataVO, boolean isMatchTrackNumber, boolean isForward) {
        String etoConsumePioValue = writeOffDataVO.getEtoConsumePioValue();
        String manufactureStrategy = writeOffDataVO.getManufactureStrategy();
        if (manufactureStrategy.equals("fpPxtypCS/ihJ30GjB/UJtg0uEU=") || manufactureStrategy.equals("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=") || manufactureStrategy.equals("GE2FIa4GQ6uhdx0RDGuibtg0uEU=") || manufactureStrategy.equals("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=")) {
            isMatchTrackNumber = true;
        }
        boolean isMatchProject = false;
        if (etoConsumePioValue.equals("ITEM_TRACKNO") || "NONE".equalsIgnoreCase(etoConsumePioValue)) {
            if (manufactureStrategy.equals("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=") || manufactureStrategy.equals("GE2FIa4GQ6uhdx0RDGuibtg0uEU=")) {
                isMatchProject = true;
            }
        } else if (etoConsumePioValue.equals("ITEM")) {
            isMatchTrackNumber = false;
            isMatchProject = true;
        }
        boolean iswriteOff = super.iswriteOff(endDate, trackNumberID, writeOffDataVO, reqPlanDataVO, isMatchTrackNumber, isForward);
        if (isMatchProject && !writeOffDataVO.getprojectID().equals(reqPlanDataVO.getProjectID())) {
            iswriteOff = false;
        }
        return iswriteOff;
    }

    @Override
    protected int getCntactPlanType(WriteOffDataVO writeOffDataVO) throws SQLException {
        int cntactPlanType = -1;
        if (writeOffDataVO.getId() != null) {
            if (writeOffDataVO.getId() != null && this.param.getReqconfumeMode().equals("0")) {
                cntactPlanType = writeOffDataVO.getOffSetMode();
            } else if (writeOffDataVO.getId() != null && this.param.getReqconfumeMode().equals("1")) {
                cntactPlanType = 2;
            }
        } else if (this.param.getReductionMode().equals("0")) {
            cntactPlanType = 0;
        } else if (this.param.getReductionMode().equals("1")) {
            cntactPlanType = writeOffDataVO.getOffSetMode();
        } else if (this.param.getReductionMode().equals("2")) {
            cntactPlanType = 2;
        }
        return cntactPlanType;
    }

    @Override
    protected String getMaterialsDataSQL(String storageOrgUnitID, Set materialids) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select count(*) as count,fmaterialID from t_mm_RequirementPlan ");
        sql.append(" where  fstorageorgunitid = '").append(storageOrgUnitID).append("'");
        sql.append(" and  fStatus =  ").append(10);
        sql.append(" and fQty>fCntactTotalQty ");
        sql.append(" and fReqTypeID = '").append("s0fDJAEoEADgAABCfwAAAdhs+cg=").append("'");
        sql.append(" and fmaterialID in ").append(MMUtils.setToString((Set)materialids));
        sql.append(" group by fmaterialID order by fmaterialID");
        return sql.toString();
    }
}

