/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.reqplan;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.app.BizCommand;
import com.kingdee.eas.mm.planning.app.reqplan.ReqPlanUpdateDataVO;
import com.kingdee.eas.mm.planning.app.reqplan.ReqPlanWriteOffParam;
import com.kingdee.eas.mm.planning.app.reqplan.WriteOffDetailDataVO;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;

public class ReqPlanWriteOffReturn
extends BizCommand {
    public ReqPlanWriteOffParam param = null;

    public ReqPlanWriteOffReturn(Context ctx) {
        super(ctx);
    }

    protected Object doing(Object inParam) throws BOSException, EASBizException {
        this.param = (ReqPlanWriteOffParam)inParam;
        this.passiveRubricWriteOffReq(this.param.getStorageOrgUnitID());
        return this.param;
    }

    protected void passiveRubricWriteOffReq(String storageOrgUnitID) throws BOSException, EASBizException {
        String tmpTable = this.param.getTempTableNameForCalc();
        StringBuffer sql = new StringBuffer();
        sql.append(" select FSourceBillTypeID,fOffsetMode,FsrcOfSourceBillID,FsrcOfSourceEntryID,fqty,fbaseqty,FStorageOrgUnitID,FSourceBillID,FSrcNumber,FSourceEntryID,");
        sql.append("FBillTypeID,FMaterialID,FUnitID,FBaseUnitID, fQty,FBaseQty,fManufactureStrategyID,");
        sql.append(" FProjectID,FTrackNumberID,FIsolatedRule ,faddPlanType");
        sql.append(" from ").append(tmpTable).append(" where  fisWriteOff = 1  ");
        sql.append(" and FSourceBillTypeID = ? and fisOrderToOrder = 0 ");
        sql.append("  and fbaseqty<0 ");
        sql.append(" order by fCreateTime ASC ");
        IRowSet reqRow = this.executeQuery(sql.toString(), new String[]{"50957179-0105-1000-e008-8152c0a812fd463ED552"});
        try {
            while (reqRow.next()) {
                ReqPlanUpdateDataVO newDataVO = new ReqPlanUpdateDataVO();
                newDataVO.setBillID(reqRow.getString("fSourceBillID"));
                newDataVO.setBillNumber(reqRow.getString("FSrcNumber"));
                newDataVO.setBillEntryID(reqRow.getString("fSourceEntryID"));
                newDataVO.setBillTypeID(reqRow.getString("fBillTypeID"));
                newDataVO.setStorageOrgUnitID(reqRow.getString("fStorageOrgUnitID"));
                newDataVO.setMaterialID(reqRow.getString("fMaterialID"));
                newDataVO.setUnitID(reqRow.getString("fUnitID"));
                newDataVO.setBaseUnitID(reqRow.getString("fBaseUnitID"));
                newDataVO.setQty(reqRow.getBigDecimal("fqty"));
                newDataVO.setBaseQty(reqRow.getBigDecimal("fbaseqty"));
                newDataVO.setSrcBillID(reqRow.getString("FsrcOfSourceBillID"));
                newDataVO.setSrcBillEntryID(reqRow.getString("FsrcOfSourceEntryID"));
                this.rubricWriteOffReq(newDataVO);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void rubricWriteOffReq(ReqPlanUpdateDataVO dataVO) throws BOSException, EASBizException {
        String billTypeID = dataVO.getBillTypeID();
        String billID = dataVO.getBillID();
        String billNum = dataVO.getBillNumber();
        String billEntryID = dataVO.getBillEntryID();
        String unitID = dataVO.getUnitID();
        String baseUnitID = dataVO.getBaseUnitID();
        BigDecimal qty = dataVO.getQty();
        BigDecimal baseQty = dataVO.getBaseQty();
        String materialId = dataVO.getMaterialID();
        String srcOfSourceEntryID = dataVO.getSrcBillEntryID();
        qty = qty.abs();
        baseQty = baseQty.abs();
        String sql_getCntRelation = "SELECT FID,FDestID,(FQty) as fQty,(FBaseQty) as FBaseQty,FSeq  FROM  T_MM_ReqCounteractRelation  WHERE FSRCSourceEntryID = ?  and (FQty)>0  ORDER BY FSeq DESC";
        IRowSet row = this.executeQuery(sql_getCntRelation, new Object[]{srcOfSourceEntryID});
        StringBuffer sql_uptReqplan = new StringBuffer();
        sql_uptReqplan.append("update T_MM_Requirementplan set fCntactTotalQty = fCntactTotalQty - ? ");
        sql_uptReqplan.append(",fBaseCntactTotalQty = fBaseCntactTotalQty - ?");
        sql_uptReqplan.append(",fStatus = (case when(fQty - fCntactTotalQty + ? )>0 then ");
        sql_uptReqplan.append(10).append(" else ").append(20);
        sql_uptReqplan.append(" end) where fID = ? ");
        ArrayList writeOffDetailDataList = new ArrayList();
        ArrayList<Object[]> reqPlanDataDataList = new ArrayList<Object[]>();
        WriteOffDetailDataVO writeOffDetailDataVO = null;
        try {
            int seq = 1;
            while (row.next()) {
                StringBuffer updateSql;
                Object[] reqPlanParams;
                writeOffDetailDataVO = new WriteOffDetailDataVO();
                writeOffDetailDataVO.setId(BOSUuid.create((String)"D02F7535").toString());
                writeOffDetailDataVO.setSourceID(billID);
                writeOffDetailDataVO.setSourceEntryID(billEntryID);
                writeOffDetailDataVO.setBillTypeID(billTypeID);
                writeOffDetailDataVO.setUnitID(unitID);
                writeOffDetailDataVO.setBaseUnitID(baseUnitID);
                writeOffDetailDataVO.setSourceNumber(billNum);
                writeOffDetailDataVO.setMaterialID(materialId);
                writeOffDetailDataVO.setSrcSourceEntryID(srcOfSourceEntryID);
                String destID = row.getString("FDestID");
                BigDecimal cntactQty = row.getBigDecimal("FQty");
                BigDecimal cntactBaseQty = row.getBigDecimal("FBaseQty");
                String id = row.getString("fID");
                if (qty.compareTo(cntactQty) >= 0) {
                    writeOffDetailDataVO.setDestID(row.getString("FDestID"));
                    writeOffDetailDataVO.setQty(cntactQty.negate());
                    writeOffDetailDataVO.setBaseQty(cntactBaseQty.negate());
                    writeOffDetailDataVO.setSeq(seq++);
                    this.addListData(writeOffDetailDataList, writeOffDetailDataVO);
                    reqPlanParams = new Object[]{cntactQty, cntactBaseQty, cntactQty, destID};
                    reqPlanDataDataList.add(reqPlanParams);
                    updateSql = new StringBuffer();
                    updateSql.append("update T_MM_ReqCounteractRelation set fRubricQty = fqty,fRubricBaseQty = fbaseqty ");
                    updateSql.append(" where fid = '").append(id).append("'");
                    DbUtil.execute((Context)this.ctx, (String)updateSql.toString());
                    qty = qty.subtract(cntactQty);
                    baseQty = baseQty.subtract(cntactBaseQty);
                    continue;
                }
                writeOffDetailDataVO.setDestID(row.getString("FDestID"));
                writeOffDetailDataVO.setQty(qty.negate());
                writeOffDetailDataVO.setBaseQty(baseQty.negate());
                writeOffDetailDataVO.setSeq(seq++);
                this.addListData(writeOffDetailDataList, writeOffDetailDataVO);
                reqPlanParams = new Object[]{qty, baseQty, qty, destID};
                reqPlanDataDataList.add(reqPlanParams);
                updateSql = new StringBuffer();
                updateSql.append("update T_MM_ReqCounteractRelation set fRubricQty = fRubricQty+?,fRubricBaseQty = fRubricBaseQty+? ");
                updateSql.append(" where fid = '").append(id).append("'");
                DbUtil.execute((Context)this.ctx, (String)updateSql.toString(), (Object[])new Object[]{qty, baseQty});
                break;
            }
            this.dealWithWriteOffDetailData(writeOffDetailDataList);
            this.executeBatch(sql_uptReqplan.toString(), reqPlanDataDataList);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void addListData(ArrayList dataList, Object data) throws BOSException {
        dataList.add(data);
        if (dataList != null && dataList.size() > 300) {
            this.dealWithWriteOffDetailData(dataList);
            dataList.clear();
        }
    }

    protected void dealWithWriteOffDetailData(ArrayList writeOffDetailDataList) throws BOSException {
        if (writeOffDetailDataList.size() == 0) {
            return;
        }
        StringBuffer sql_writeOffRelation = new StringBuffer();
        StringBuffer updateDetail = new StringBuffer();
        sql_writeOffRelation.append("insert into T_MM_ReqCounteractRelation ");
        sql_writeOffRelation.append("(FID,FSourceID,FSourceEntryID,FDestID,FBillTypeID,FQty,FBaseQty,FUnitID,FBaseUnitID,FSeq,FSourceNumber,fmaterialId,FSRCSourceEntryID)");
        sql_writeOffRelation.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?)");
        updateDetail.append(" update T_MM_ReqCounteractRelation set FQty =FQty+?, FBaseQty = FBaseQty+?");
        updateDetail.append(" where FDestID = ? and FSourceEntryID  = ? ");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        ArrayList<Object[]> updateparamsList = new ArrayList<Object[]>();
        WriteOffDetailDataVO writeOffDetailDataVO = null;
        int size = writeOffDetailDataList.size();
        for (int i = 0; i < size; ++i) {
            writeOffDetailDataVO = (WriteOffDetailDataVO)writeOffDetailDataList.get(i);
            boolean isexsit = this.checkDetail(writeOffDetailDataVO.getDestID(), writeOffDetailDataVO.getSourceEntryID());
            if (isexsit) {
                Object[] updateparam = new Object[]{writeOffDetailDataVO.getQty(), writeOffDetailDataVO.getBaseQty(), writeOffDetailDataVO.getDestID(), writeOffDetailDataVO.getSourceEntryID()};
                updateparamsList.add(updateparam);
                this.executeBatch(updateDetail.toString(), updateparamsList);
                updateparamsList.clear();
                continue;
            }
            Object[] param = new Object[]{writeOffDetailDataVO.getId(), writeOffDetailDataVO.getSourceID(), writeOffDetailDataVO.getSourceEntryID(), writeOffDetailDataVO.getDestID(), writeOffDetailDataVO.getBillTypeID(), writeOffDetailDataVO.getQty(), writeOffDetailDataVO.getBaseQty(), writeOffDetailDataVO.getUnitID(), writeOffDetailDataVO.getBaseUnitID(), new Integer(writeOffDetailDataVO.getSeq()), writeOffDetailDataVO.getSourceNumber(), writeOffDetailDataVO.getMaterialID(), writeOffDetailDataVO.getSrcSourceEntryID()};
            paramsList.add(param);
            this.executeBatch(sql_writeOffRelation.toString(), paramsList);
            paramsList.clear();
        }
    }

    private boolean checkDetail(String destID, String sourceEntryID) throws BOSException {
        boolean isexsit = false;
        StringBuffer checkDetail = new StringBuffer();
        checkDetail.append("select fid from T_MM_ReqCounteractRelation where FDestID = ? and FSourceEntryID = ? ");
        IRowSet rs = this.executeQuery(checkDetail.toString(), new String[]{destID, sourceEntryID});
        try {
            if (rs.next()) {
                isexsit = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return isexsit;
    }
}

