/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.reqplan;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.app.BizCommand;
import com.kingdee.eas.mm.planning.app.reqplan.ReqPlanUpdateDataVO;
import com.kingdee.eas.mm.planning.app.reqplan.ReqPlanWriteOffParam;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;

public class ReqPlanWriteOffRubric
extends BizCommand {
    public ReqPlanWriteOffParam param = null;

    public ReqPlanWriteOffRubric(Context ctx) {
        super(ctx);
    }

    protected Object doing(Object inParam) throws BOSException, EASBizException {
        this.param = (ReqPlanWriteOffParam)inParam;
        this.passiveRubricWriteOffReq(this.param.getStorageOrgUnitID());
        return this.param;
    }

    protected void passiveRubricWriteOffReq(String storageOrgUnitID) throws BOSException, EASBizException {
        String tmpTable = this.param.getTempTableNameForCalc();
        StringBuffer sql = new StringBuffer();
        sql.append(" select FSourceBillTypeID,fOffsetMode,FsrcOfSourceBillID,FsrcOfSourceEntryID,fqty,fbaseqty,FStorageOrgUnitID,FSourceBillID,FSrcNumber,FSourceEntryID,");
        sql.append("FBillTypeID,FMaterialID,FUnitID,FBaseUnitID, fQty,FBaseQty,fManufactureStrategyID,");
        sql.append(" FProjectID,FTrackNumberID,FIsolatedRule ,faddPlanType");
        sql.append(" from ").append(tmpTable).append(" where  fisWriteOff = 1  ");
        sql.append(" and FSourceBillTypeID not in (?,?,?,?)");
        sql.append("  and fbaseqty<0 ");
        sql.append(" order by fCreateTime ASC ");
        IRowSet reqRow = this.executeQuery(sql.toString(), new String[]{"50957179-0105-1000-e008-8152c0a812fd463ED552", "B2aZSVXaSx6qxdfekgCmrEY+1VI=", "ejIZHXXTQliYCQJg9t4Re0Y+1VI=", "3fY8szOQTQmfaNi+Tm5SJUY+1VI="});
        if (reqRow.size() <= 0) {
            return;
        }
        try {
            while (reqRow.next()) {
                ReqPlanUpdateDataVO newDataVO = new ReqPlanUpdateDataVO();
                newDataVO.setBillID(reqRow.getString("fSourceBillID"));
                newDataVO.setBillNumber(reqRow.getString("FSrcNumber"));
                newDataVO.setBillEntryID(reqRow.getString("fSourceEntryID"));
                newDataVO.setBillTypeID(reqRow.getString("fBillTypeID"));
                newDataVO.setStorageOrgUnitID(reqRow.getString("fStorageOrgUnitID"));
                newDataVO.setMaterialID(reqRow.getString("fMaterialID"));
                newDataVO.setUnitID(reqRow.getString("fUnitID"));
                newDataVO.setBaseUnitID(reqRow.getString("fBaseUnitID"));
                newDataVO.setQty(reqRow.getBigDecimal("fqty"));
                newDataVO.setBaseQty(reqRow.getBigDecimal("fbaseqty"));
                newDataVO.setSrcBillID(reqRow.getString("FsrcOfSourceBillID"));
                newDataVO.setSrcBillEntryID(reqRow.getString("FsrcOfSourceEntryID"));
                this.rubricWriteOffReq(newDataVO);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void rubricWriteOffReq(ReqPlanUpdateDataVO dataVO) throws BOSException, EASBizException {
        String billTypeID = dataVO.getBillTypeID();
        String billID = dataVO.getBillID();
        String billNum = dataVO.getBillNumber();
        String billEntryID = dataVO.getBillEntryID();
        String unitID = dataVO.getUnitID();
        String baseUnitID = dataVO.getBaseUnitID();
        BigDecimal qty = dataVO.getQty();
        BigDecimal baseQty = dataVO.getBaseQty();
        String materialId = dataVO.getMaterialID();
        String srcOfSourceEntryID = dataVO.getSrcBillEntryID();
        qty = qty.abs();
        baseQty = baseQty.abs();
        String sql_getCntRelation = "SELECT FID,FDestID,(FQty-fRubricQty) as fQty,(FBaseQty-fRubricBaseQty) as FBaseQty,FSeq  FROM  T_MM_ReqCounteractRelation  WHERE FSourceEntryID = ?  and (FQty-fRubricQty)>0  ORDER BY FSeq DESC";
        IRowSet row = DbUtil.executeQuery((Context)this.ctx, (String)sql_getCntRelation, (Object[])new Object[]{srcOfSourceEntryID});
        StringBuffer sql_recordWriteOffRelation = new StringBuffer();
        sql_recordWriteOffRelation.append("insert into T_MM_ReqCounteractRelation");
        sql_recordWriteOffRelation.append("(FID,FSourceID,FSourceEntryID,FDestID,FBillTypeID,FQty,FBaseQty,FUnitID,FBaseUnitID,FSeq,FSourceNumber,FmaterialId)");
        sql_recordWriteOffRelation.append(" values(?,?,?,?,?,?,?,?,?,?,?,?)");
        StringBuffer sql_uptReqplan = new StringBuffer();
        sql_uptReqplan.append("update T_MM_Requirementplan set fCntactTotalQty = fCntactTotalQty - ? ");
        sql_uptReqplan.append(",fBaseCntactTotalQty = fBaseCntactTotalQty - ?");
        sql_uptReqplan.append(",fStatus = (case when(fQty - fCntactTotalQty + ? )>0 then ");
        sql_uptReqplan.append(10).append(" else ").append(20);
        sql_uptReqplan.append(" end) where fID = ? ");
        ArrayList<Object[]> writeOffDetailDataList = new ArrayList<Object[]>();
        ArrayList<Object[]> reqPlanDataDataList = new ArrayList<Object[]>();
        try {
            int seq = 1;
            while (row.next()) {
                StringBuffer updateSql;
                Object[] reqPlanParams;
                Object[] detailParams;
                String destID = row.getString("FDestID");
                BigDecimal cntactQty = row.getBigDecimal("FQty");
                BigDecimal cntactBaseQty = row.getBigDecimal("FBaseQty");
                String id = row.getString("fID");
                if (qty.compareTo(cntactQty) >= 0) {
                    detailParams = new Object[]{BOSUuid.create((String)"D02F7535").toString(), billID, billEntryID, row.getString("FDestID"), billTypeID, cntactQty.negate(), cntactBaseQty.negate(), unitID, baseUnitID, new Integer(seq++), billNum, materialId};
                    writeOffDetailDataList.add(detailParams);
                    reqPlanParams = new Object[]{cntactQty, cntactBaseQty, cntactQty, destID};
                    reqPlanDataDataList.add(reqPlanParams);
                    updateSql = new StringBuffer();
                    updateSql.append("update T_MM_ReqCounteractRelation set fRubricQty = fqty,fRubricBaseQty = fbaseqty ");
                    updateSql.append(" where fid = '").append(id).append("'");
                    DbUtil.execute((Context)this.ctx, (String)updateSql.toString());
                    qty = qty.subtract(cntactQty);
                    baseQty = baseQty.subtract(cntactBaseQty);
                    continue;
                }
                detailParams = new Object[]{BOSUuid.create((String)"D02F7535").toString(), billID, billEntryID, row.getString("FDestID"), billTypeID, qty.negate(), baseQty.negate(), unitID, baseUnitID, new Integer(seq++), billNum, materialId};
                writeOffDetailDataList.add(detailParams);
                reqPlanParams = new Object[]{qty, baseQty, qty, destID};
                reqPlanDataDataList.add(reqPlanParams);
                updateSql = new StringBuffer();
                updateSql.append("update T_MM_ReqCounteractRelation set fRubricQty = fRubricQty+?,fRubricBaseQty = fRubricBaseQty+? ");
                updateSql.append(" where fid = '").append(id).append("'");
                DbUtil.execute((Context)this.ctx, (String)updateSql.toString(), (Object[])new Object[]{qty, baseQty});
                break;
            }
            this.executeBatch(sql_recordWriteOffRelation.toString(), writeOffDetailDataList);
            this.executeBatch(sql_uptReqplan.toString(), reqPlanDataDataList);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

