/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;

public class MonthPlanFilterPharser
implements Serializable {
    private static final long serialVersionUID = 1L;
    private FilterInfo filter;

    public MonthPlanFilterPharser(FilterInfo filter) {
        this.filter = filter;
    }

    public Date getDate() throws ParseException {
        FilterItemCollection coll = this.filter.getFilterItems();
        Date date = null;
        FilterItemInfo filterItemInfo = null;
        for (int i = 0; i < coll.size(); ++i) {
            filterItemInfo = coll.get(i);
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("beginTime")) continue;
            String strDate = (String)filterItemInfo.getCompareValue();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            date = format.parse(strDate);
            break;
        }
        return date;
    }

    public int getPeriodNumber() {
        FilterItemCollection coll = this.filter.getFilterItems();
        int number = 0;
        FilterItemInfo filterItemInfo = null;
        for (int i = 0; i < coll.size(); ++i) {
            filterItemInfo = coll.get(i);
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("period")) continue;
            String strInt = (String)filterItemInfo.getCompareValue();
            strInt = strInt.replaceAll(",", "");
            number = Integer.parseInt(strInt);
            break;
        }
        return number;
    }

    public String getPeriodType() {
        FilterItemCollection coll = this.filter.getFilterItems();
        String number = null;
        FilterItemInfo filterItemInfo = null;
        for (int i = 0; i < coll.size(); ++i) {
            filterItemInfo = coll.get(i);
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("periodType.number")) continue;
            number = (String)filterItemInfo.getCompareValue();
            break;
        }
        return number;
    }

    public String getStorageFilter(String table) {
        FilterItemCollection coll = this.filter.getFilterItems();
        StringBuffer sql = new StringBuffer(8);
        sql.setLength(0);
        for (int i = 0; i < coll.size(); ++i) {
            FilterItemInfo item = coll.get(i);
            if (!item.getPropertyName().equalsIgnoreCase("storageOrgUnit.number")) continue;
            sql.append(this.buildWhere(item, table));
        }
        return sql.toString();
    }

    public String buildStatusFilter(String table) {
        FilterItemCollection coll = this.filter.getFilterItems();
        StringBuffer sql = new StringBuffer(8);
        sql.setLength(0);
        for (int i = 0; i < coll.size(); ++i) {
            FilterItemInfo item = coll.get(i);
            if (!item.getPropertyName().equalsIgnoreCase("baseStatus")) continue;
            sql.append(table);
            sql.append(".FBaseStatus ");
            sql.append(item.getCompareExpression());
            Object object = item.getCompareValue();
            if ("in".equalsIgnoreCase(item.getCompareExpression())) {
                sql.append(" (");
                String keys = this.mapToString((Set)object, true);
                sql.append(keys);
                sql.append(") ");
            } else {
                sql.append(item.getCompareValue());
            }
            return sql.toString();
        }
        return sql.toString();
    }

    public String getDateString(boolean from) throws ParseException {
        Date begin = this.getDate();
        if (from) {
            return this.dateToString(begin);
        }
        int number = this.getPeriodNumber();
        Date end = this.getEndDayOfMonth(begin, number);
        return this.dateToString(end);
    }

    private String buildWhere(FilterItemInfo item, String key) {
        StringBuffer sql = new StringBuffer(8);
        sql.append(key);
        sql.append(".FNumber ");
        sql.append(item.getCompareExpression());
        Object object = item.getCompareValue();
        if ("in".equalsIgnoreCase(item.getCompareExpression())) {
            sql.append(" (");
            String keys = this.mapToString((Set)object, false);
            sql.append(keys);
            sql.append(") ");
        } else {
            sql.append("'");
            sql.append(item.getCompareValue());
            sql.append("'");
        }
        return sql.toString();
    }

    private String mapToString(Set set, boolean isInt) {
        if (set == null) {
            return "'null'";
        }
        StringBuffer keys = new StringBuffer(8);
        String returnValue = null;
        for (Object value : set) {
            if (!isInt) {
                keys.append("'");
            }
            keys.append(value);
            if (!isInt) {
                keys.append("',");
                continue;
            }
            keys.append(",");
        }
        returnValue = keys.toString().substring(0, keys.length() - 1);
        return returnValue;
    }

    public String toSql() throws ParseException {
        FilterItemCollection coll = this.filter.getFilterItems();
        StringBuffer sql = new StringBuffer(8);
        sql.setLength(0);
        for (int i = 0; i < coll.size(); ++i) {
            FilterItemInfo item = coll.get(i);
            if (item.getPropertyName().equalsIgnoreCase("storageOrgUnit.number")) {
                sql.append(this.buildWhere(item, "Storage"));
            }
            if (item.getPropertyName().equalsIgnoreCase("project.number")) {
                if (sql.length() > 0) {
                    sql.append(" AND ");
                }
                sql.append(this.buildWhere(item, "Project"));
            }
            if (item.getPropertyName().equalsIgnoreCase("task.number")) {
                if (sql.length() > 0) {
                    sql.append(" AND ");
                }
                sql.append(this.buildWhere(item, "Task"));
            }
            if (!item.getPropertyName().equalsIgnoreCase("taskTemplate.number")) continue;
            if (sql.length() > 0) {
                sql.append(" AND ");
            }
            sql.append(this.buildWhere(item, "TaskTemplate"));
        }
        Date begin = this.getDate();
        int number = this.getPeriodNumber();
        Date end = this.getEndDayOfMonth(begin, number - 1);
        if (sql.length() > 0) {
            sql.append(" AND ");
        }
        sql.append("Task");
        sql.append(".FPlanEndTime >= to_date('");
        sql.append(this.dateToString(begin));
        sql.append("') and ");
        sql.append("Task");
        sql.append(".FPlanEndTime <= to_date('");
        sql.append(this.dateToString(end));
        sql.append("')");
        sql.append(" AND ");
        sql.append(this.buildStatusFilter("Task"));
        return sql.toString();
    }

    private Date getEndDayOfMonth(Date date, int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, num);
        int endDay = calendar.getActualMaximum(5);
        calendar.set(5, endDay);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    private String dateToString(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(date);
    }
}

