/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.formatter.DateParser;
import com.kingdee.bos.ctrl.kdf.formatter.FormatException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.project.IProjectDictData;
import com.kingdee.eas.mm.project.ProjectDictDataCollection;
import com.kingdee.eas.mm.project.ProjectDictDataFactory;
import com.kingdee.eas.mm.project.ProjectDictDataInfo;
import com.kingdee.eas.mm.project.util.MMProjectCalendarFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.BaseException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class ProjectTaskPlanningReportUtil {
    private int issueType;
    private int expectationNum;
    private Context ctx;
    private RptParams filter = null;
    public static final String WBSResource = "com.kingdee.eas.mm.project.WBSResource";
    private String titleFormat = null;
    private String year = null;
    private String month = null;
    private String week = null;
    private String quater = null;

    public ProjectTaskPlanningReportUtil(Context ctx, RptParams filter) {
        this.ctx = ctx;
        this.filter = filter;
        this.issueType = new Integer(filter.getString("planningType"));
        this.expectationNum = new Integer(filter.getString("expectationNum"));
        this.titleFormat = this.getResource(WBSResource, "PROJECT_PEROID_PARTTEN");
        this.year = this.getResource(WBSResource, "PROJECT_PEROID_MID");
        this.month = this.getResource(WBSResource, "PROJECT_PEROID_POST_MONTH");
        this.week = this.getResource(WBSResource, "PROJECT_PEROID_POST_WEEK");
        this.quater = this.getResource(WBSResource, "PROJECT_PEROID_POST_QUATER");
    }

    public ProjectDictDataInfo getPeroidType() throws BOSException {
        ProjectDictDataInfo info = null;
        IProjectDictData iData = null;
        iData = this.ctx == null ? ProjectDictDataFactory.getRemoteInstance() : ProjectDictDataFactory.getLocalInstance(this.ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)new Integer(this.issueType)));
        view.setFilter(filter);
        ProjectDictDataCollection cols = iData.getProjectDictDataCollection(view);
        if (cols != null && cols.size() > 0) {
            info = cols.get(0);
        }
        return info;
    }

    public String[] getPeroidRang() {
        int expectationNum = new Integer(this.filter.getString("expectationNum"));
        Calendar beginTime = this.buildBeginTime(this.filter.getString("beginTime"));
        Calendar endTime = this.getExpectationEndTime(beginTime.getTime(), expectationNum);
        String[] rang = new String[2];
        switch (this.issueType) {
            case -1: {
                rang[0] = beginTime.get(1) + "." + (beginTime.get(2) + 1) + "." + beginTime.get(5);
                rang[1] = endTime.get(1) + "." + (endTime.get(2) + 1) + "." + endTime.get(5);
                break;
            }
            case -2: {
                rang[0] = MMUtils.getResourceWithParam((String)this.titleFormat, (Object[])new Object[]{String.valueOf(beginTime.get(1)), this.year, String.valueOf(beginTime.get(3)), this.week});
                rang[1] = MMUtils.getResourceWithParam((String)this.titleFormat, (Object[])new Object[]{String.valueOf(endTime.get(1)), this.year, String.valueOf(endTime.get(3)), this.week});
                break;
            }
            case -4: {
                rang[0] = MMUtils.getResourceWithParam((String)this.titleFormat, (Object[])new Object[]{String.valueOf(beginTime.get(1)), this.year, String.valueOf(this.getQuarterNum(beginTime)), this.quater});
                rang[1] = MMUtils.getResourceWithParam((String)this.titleFormat, (Object[])new Object[]{String.valueOf(endTime.get(1)), this.year, String.valueOf(this.getQuarterNum(endTime)), this.quater});
                break;
            }
            case -5: {
                String bHalfYear = "";
                bHalfYear = this.isEarlySemiYear(beginTime) ? this.getResource("EARLY_SEMI_YEAR") : this.getResource("AFTER_SEMI_YEAR");
                String eHalfYear = "";
                eHalfYear = this.isEarlySemiYear(endTime) ? this.getResource("EARLY_SEMI_YEAR") : this.getResource("AFTER_SEMI_YEAR");
                rang[0] = beginTime.get(1) + bHalfYear;
                rang[1] = endTime.get(1) + eHalfYear;
                break;
            }
            case -6: {
                rang[0] = beginTime.get(1) + "";
                rang[1] = endTime.get(1) + "";
                break;
            }
            default: {
                rang[0] = MMUtils.getResourceWithParam((String)this.titleFormat, (Object[])new Object[]{String.valueOf(beginTime.get(1)), this.year, String.valueOf(beginTime.get(2) + 1), this.month});
                rang[1] = MMUtils.getResourceWithParam((String)this.titleFormat, (Object[])new Object[]{String.valueOf(endTime.get(1)), this.year, String.valueOf(endTime.get(2) + 1), this.month});
            }
        }
        return rang;
    }

    private int compareTime(Date from, Date to) {
        int ret;
        switch (this.issueType) {
            case -1: {
                ret = this.compareTimeByDay(from, to);
                break;
            }
            case -2: {
                ret = this.compareTimeByWeek(from, to);
                break;
            }
            case -3: {
                ret = this.compareTimeByMonth(from, to);
                break;
            }
            case -4: {
                ret = this.compareTimeByQuarter(from, to);
                break;
            }
            case -5: {
                ret = this.compareTimeByHalfYear(from, to);
                break;
            }
            case -6: {
                ret = this.compareTimeByYear(from, to);
                break;
            }
            default: {
                ret = this.compareTimeByMonth(from, to);
            }
        }
        return ret;
    }

    private int compareTimeByDay(Date from, Date to) {
        Calendar calF = Calendar.getInstance();
        calF.setTime(from);
        calF.set(11, 0);
        calF.set(12, 0);
        calF.set(13, 0);
        calF.set(14, 0);
        Calendar calT = Calendar.getInstance();
        calT.setTime(to);
        calT.set(11, 0);
        calT.set(12, 0);
        calT.set(13, 0);
        calT.set(14, 0);
        if (calF.after(calT)) {
            return 1;
        }
        if (calF.before(calT)) {
            return -1;
        }
        return 0;
    }

    private int compareTimeByHalfYear(Date from, Date to) {
        int qt;
        Calendar calF = Calendar.getInstance();
        calF.setTime(from);
        Calendar calT = Calendar.getInstance();
        calT.setTime(to);
        int f = calF.get(1);
        int t = calT.get(1);
        if (f < t) {
            return -1;
        }
        if (f > t) {
            return 1;
        }
        int qf = this.getQuarterNum(calF);
        if (qf < (qt = this.getQuarterNum(calT))) {
            return -1;
        }
        if (qf > qt) {
            return 1;
        }
        return 0;
    }

    private int compareTimeByMonth(Date from, Date to) {
        Calendar calF = Calendar.getInstance();
        calF.setTime(from);
        calF.set(5, 1);
        calF.set(11, 0);
        calF.set(12, 0);
        calF.set(13, 0);
        calF.set(14, 0);
        Calendar calT = Calendar.getInstance();
        calT.setTime(to);
        calT.set(5, 1);
        calT.set(11, 0);
        calT.set(12, 0);
        calT.set(13, 0);
        calT.set(14, 0);
        if (calF.before(calT)) {
            return -1;
        }
        if (calF.after(calT)) {
            return 1;
        }
        return 0;
    }

    private int compareTimeByQuarter(Date from, Date to) {
        Calendar calF = Calendar.getInstance();
        calF.setTime(from);
        Calendar calT = Calendar.getInstance();
        calT.setTime(to);
        int f = calF.get(1);
        int t = calT.get(1);
        if (f < t) {
            return -1;
        }
        if (f > t) {
            return 1;
        }
        if (f == t) {
            int qt;
            int qf = this.getQuarterNum(calF);
            if (qf < (qt = this.getQuarterNum(calT))) {
                return -1;
            }
            if (qf > qt) {
                return 1;
            }
        }
        return 0;
    }

    private int compareTimeByWeek(Date from, Date to) {
        Calendar calF = Calendar.getInstance();
        calF.setTime(from);
        Calendar calT = Calendar.getInstance();
        calT.setTime(to);
        int f = calF.get(1);
        int t = calT.get(1);
        if (f < t) {
            return -1;
        }
        if (f > t) {
            return 1;
        }
        f = calF.get(2);
        if (f < (t = calF.get(2))) {
            return -1;
        }
        if (f > t) {
            return 1;
        }
        f = calF.get(3);
        if (f == (t = calT.get(3))) {
            return 0;
        }
        return this.compareTimeByDay(from, to);
    }

    private int compareTimeByYear(Date from, Date to) {
        Calendar calF = Calendar.getInstance();
        calF.setTime(from);
        Calendar calT = Calendar.getInstance();
        calT.setTime(to);
        int f = calF.get(1);
        int t = calT.get(1);
        if (f > t) {
            return 1;
        }
        if (f < t) {
            return -1;
        }
        return 0;
    }

    private int getCurExpectationIssueDay(Calendar beginTime, Calendar currentTime) {
        return this.getDay(beginTime.getTime(), currentTime.getTime()) - 1;
    }

    private int getCurExpectationIssueHalfYear(Calendar beginTime, Calendar currentTime) {
        return this.getHalfYear(beginTime.getTime(), currentTime.getTime()) - 1;
    }

    private int getCurExpectationIssueMonth(Calendar beginTime, Calendar currentTime) {
        return this.getMonth(beginTime.getTime(), currentTime.getTime()) - 1;
    }

    private int getCurExpectationIssueQuarter(Calendar beginTime, Calendar currentTime) {
        return this.getQuarter(beginTime.getTime(), currentTime.getTime()) - 1;
    }

    private int getCurExpectationIssueWeek(Calendar beginTime, Calendar currentTime) {
        return this.getWeek(beginTime.getTime(), currentTime.getTime()) - 1;
    }

    private int getCurExpectationIssueYear(Calendar beginTime, Calendar currentTime) {
        return this.getYear(beginTime.getTime(), currentTime.getTime()) - 1;
    }

    public int getCurExpectationIssue(Calendar beginTime, Calendar currentTime) {
        int ret = -1;
        switch (this.issueType) {
            case -1: {
                ret = this.getCurExpectationIssueDay(beginTime, currentTime);
                break;
            }
            case -2: {
                ret = this.getCurExpectationIssueWeek(beginTime, currentTime);
                break;
            }
            case -3: {
                ret = this.getCurExpectationIssueMonth(beginTime, currentTime);
                break;
            }
            case -4: {
                ret = this.getCurExpectationIssueQuarter(beginTime, currentTime);
                break;
            }
            case -5: {
                ret = this.getCurExpectationIssueHalfYear(beginTime, currentTime);
                break;
            }
            case -6: {
                ret = this.getCurExpectationIssueYear(beginTime, currentTime);
            }
        }
        return ret;
    }

    public int getDay(Date begin, Date end) {
        Calendar beginCalendar = Calendar.getInstance();
        beginCalendar.setTime(begin);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        Calendar actualTime = (Calendar)beginCalendar.clone();
        int year = this.getYear(begin, end) - 1;
        int retVal = 0;
        if (year == 0) {
            retVal = endCalendar.get(6) - beginCalendar.get(6) + 1;
        } else {
            for (int i = year; i >= 0; --i) {
                retVal = i == 0 ? retVal + endCalendar.get(6) - actualTime.get(6) + 1 : retVal + actualTime.getActualMaximum(6) - actualTime.get(6) + 1;
                actualTime.set(1, actualTime.get(1) + 1);
                actualTime.set(2, 0);
                actualTime.set(6, 1);
            }
        }
        return retVal;
    }

    public int getHalfYear(Date begin, Date end) {
        Calendar beginCalendar = Calendar.getInstance();
        beginCalendar.setTime(this.getEndDayOfHalfYear(begin));
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        int halfYearNum = 1;
        while (this.compareTimeByMonth(beginCalendar.getTime(), endCalendar.getTime()) <= 0 && this.compareTimeByMonth(beginCalendar.getTime(), endCalendar.getTime()) < 0) {
            beginCalendar = this.getNextEndDayOfHalfYear(beginCalendar);
            ++halfYearNum;
        }
        return halfYearNum;
    }

    public int getMonth(Date begin, Date end) {
        Calendar beginCalendar = Calendar.getInstance();
        beginCalendar.setTime(begin);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        int year = endCalendar.get(1) - beginCalendar.get(1);
        int retVal = year * 12 + (endCalendar.get(2) - beginCalendar.get(2)) + 1;
        return retVal;
    }

    public Calendar getNextEndDayOfHalfYear(Calendar c) {
        if (this.isEarlySemiYear(c)) {
            c.set(c.get(1), 11, 31);
        } else {
            c.set(c.get(1) + 1, 5, 30);
        }
        return c;
    }

    public Calendar getNextEndDayOfQuarter(Calendar c) {
        switch (this.getQuarterNum(c)) {
            case 1: {
                c.set(c.get(1), 5, 30);
                break;
            }
            case 2: {
                c.set(c.get(1), 8, 30);
                break;
            }
            case 3: {
                c.set(c.get(1), 11, 31);
                break;
            }
            case 4: {
                c.set(c.get(1) + 1, 2, 31);
            }
        }
        return c;
    }

    public int getQuarter(Date begin, Date end) {
        Calendar beginCalendar = Calendar.getInstance();
        beginCalendar.setTime(begin);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        int quarterNum = 1;
        while (beginCalendar.before(endCalendar) && (beginCalendar.get(1) != endCalendar.get(1) || this.getQuarterNum(beginCalendar) != this.getQuarterNum(endCalendar))) {
            ++quarterNum;
            beginCalendar = this.getNextEndDayOfQuarter(beginCalendar);
        }
        return quarterNum;
    }

    public int getWeek(Date begin, Date end) {
        Calendar beginCalendar = Calendar.getInstance();
        beginCalendar.setTime(begin);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        Calendar actualTime = (Calendar)beginCalendar.clone();
        actualTime.setTime(this.getEndDayOfWeek(beginCalendar.getTime()));
        int weekNum = 1;
        while (this.compareTimeByDay(actualTime.getTime(), endCalendar.getTime()) < 0) {
            ++weekNum;
            actualTime.set(6, actualTime.get(6) + 7);
            if (actualTime.get(3) != endCalendar.get(3)) continue;
            break;
        }
        return weekNum;
    }

    public int getYear(Date begin, Date end) {
        Calendar beginCalendar = Calendar.getInstance();
        beginCalendar.setTime(begin);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        int year = endCalendar.get(1) - beginCalendar.get(1) + 1;
        return year;
    }

    public Date getEndDayOfHalfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (this.isEarlySemiYear(calendar)) {
            calendar.set(2, 5);
        } else {
            calendar.set(2, 11);
        }
        int endDay = calendar.getActualMaximum(5);
        calendar.set(5, endDay);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public Date getEndDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int endDay = calendar.getActualMaximum(5);
        calendar.set(5, endDay);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public Date getEndDayOfQuarter(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int quarter = this.getQuarterNum(calendar);
        int m = 0;
        switch (quarter) {
            case 1: {
                m = 2;
                break;
            }
            case 2: {
                m = 5;
                break;
            }
            case 3: {
                m = 8;
                break;
            }
            case 4: {
                m = 11;
            }
        }
        int endDay = calendar.getActualMaximum(5);
        calendar.set(2, m);
        calendar.set(5, endDay);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public Date getEndDayOfWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(7, 7);
        calendar.set(7, calendar.get(7));
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public Date getEndDayOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int endDay = calendar.getActualMaximum(6);
        calendar.set(6, endDay);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public Calendar getExpectationEndTimeDay(Date date, int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(6, calendar.get(6) + num - 1);
        return calendar;
    }

    public Calendar getExpectationEndTimeMonth(Date date, int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, calendar.get(2) + num - 1);
        return calendar;
    }

    public Calendar getExpectationEndTimeHalfYear(Date date, int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, calendar.get(2) + (num - 1) * 6);
        return calendar;
    }

    public Calendar getExpectationEndTimeQuarter(Date date, int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, calendar.get(2) + (num - 1) * 3);
        return calendar;
    }

    public Calendar getExpectationEndTimeWeek(Date date, int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(7, 7);
        calendar.set(3, calendar.get(3) + num - 1);
        return calendar;
    }

    public Calendar getExpectationEndTimeYear(Date date, int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(1, calendar.get(1) + num - 1);
        return calendar;
    }

    public Calendar getExpectationEndTime(Date date, int num) {
        Calendar calendar = Calendar.getInstance();
        switch (this.issueType) {
            case -1: {
                calendar = this.getExpectationEndTimeDay(date, num);
                break;
            }
            case -2: {
                calendar = this.getExpectationEndTimeWeek(date, num);
                break;
            }
            case -3: {
                calendar = this.getExpectationEndTimeMonth(date, num);
                break;
            }
            case -4: {
                calendar = this.getExpectationEndTimeQuarter(date, num);
                break;
            }
            case -5: {
                calendar = this.getExpectationEndTimeHalfYear(date, num);
                break;
            }
            case -6: {
                calendar = this.getExpectationEndTimeYear(date, num);
            }
        }
        return calendar;
    }

    public Date getFirstDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        return c.getTime();
    }

    public Date getFirstDayOfQuarter(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int quarter = this.getQuarterNum(c);
        int m = 0;
        switch (quarter) {
            case 1: {
                m = 0;
                break;
            }
            case 2: {
                m = 3;
                break;
            }
            case 3: {
                m = 6;
                break;
            }
            case 4: {
                m = 9;
            }
        }
        c.set(2, m);
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public Date getFirstDayOfSemiYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int semiYear = this.getSemiYearNum(c);
        if (semiYear == 1) {
            c.set(2, 0);
        } else {
            c.set(2, 6);
        }
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public Date getFirstDayOfWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(7, 1);
        return c.getTime();
    }

    public Calendar buildBeginTime() {
        String time = this.filter.getString("beginTime");
        try {
            Date date = DateParser.pasterDate((String)time);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            return cal;
        }
        catch (FormatException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Calendar buildBeginTime(String time) {
        try {
            Date date = DateParser.pasterDate((String)time);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            return cal;
        }
        catch (FormatException e) {
            e.printStackTrace();
            return null;
        }
    }

    private RptTableColumn createColumn(String key, int width, int align, String format) {
        RptTableColumn col = null;
        col = new RptTableColumn(key);
        col.setWidth(width);
        col.setAligment(align);
        if (format != null) {
            col.setFormatPattern(format);
        }
        return col;
    }

    public RptTableHeader getReportHeader() {
        int expectationNum = new Integer(this.filter.getString("expectationNum"));
        Calendar beginTime = this.buildBeginTime(this.filter.getString("beginTime"));
        Calendar actualTime = (Calendar)beginTime.clone();
        RptTableHeader reportHeader = new RptTableHeader();
        reportHeader.addColumn(this.createColumn("FStorageName", 80, 0, null));
        reportHeader.addColumn(this.createColumn("FProjectName", 80, 0, null));
        reportHeader.addColumn(this.createColumn("FTaskType", 80, 0, null));
        reportHeader.addColumn(this.createColumn("FTaskName", 80, 0, null));
        reportHeader.addColumn(this.createColumn("FMaterialName", 80, 0, null));
        reportHeader.addColumn(this.createColumn("FMileStone", 80, 0, null));
        reportHeader.addColumn(this.createColumn("FMeasureUnit", 80, 0, null));
        block7: for (int i = 0; i < expectationNum; ++i) {
            switch (this.issueType) {
                case -1: {
                    Date da = actualTime.getTime();
                    SimpleDateFormat f = new SimpleDateFormat("yyyy.MM.dd");
                    reportHeader.addColumn(this.createColumn("FPeroid" + i, 80, 2, "#,##0.########"));
                    actualTime.set(6, actualTime.get(6) + 1);
                    continue block7;
                }
                case -2: {
                    Date df = actualTime.getTime();
                    Date dt = this.getEndDayOfWeek(actualTime.getTime());
                    SimpleDateFormat format = new SimpleDateFormat("yyyy.MM.dd");
                    reportHeader.addColumn(this.createColumn("FPeroid" + i, 150, 2, "#,##0.########"));
                    actualTime.setTime(dt);
                    actualTime.set(6, actualTime.get(6) + 1);
                    continue block7;
                }
                case -4: {
                    reportHeader.addColumn(this.createColumn("FPeroid" + i, 80, 2, "#,##0.########"));
                    actualTime = this.getNextEndDayOfQuarter(actualTime);
                    continue block7;
                }
                case -5: {
                    String halfYear = "";
                    halfYear = this.isEarlySemiYear(actualTime) ? this.getResource("EARLY_SEMI_YEAR") : this.getResource("AFTER_SEMI_YEAR");
                    reportHeader.addColumn(this.createColumn("FPeroid" + i, 80, 2, "#,##0.########"));
                    actualTime = this.getNextEndDayOfHalfYear(actualTime);
                    continue block7;
                }
                case -6: {
                    reportHeader.addColumn(this.createColumn("FPeroid" + i, 80, 2, "#,##0.########"));
                    actualTime.set(1, actualTime.get(1) + 1);
                    continue block7;
                }
                default: {
                    reportHeader.addColumn(this.createColumn("FPeroid" + i, 80, 2, "#,##0.########"));
                    actualTime.set(2, actualTime.get(2) + 1);
                }
            }
        }
        this.setLabels(reportHeader, this.ctx);
        return reportHeader;
    }

    private void setLabels(RptTableHeader header, Context ctx) {
        Object[][] labels = null;
        labels = new Object[2][7 + this.expectationNum];
        labels[0][0] = this.getResource("STORAGEOURUNIT").substring(0, this.getResource("STORAGEOURUNIT").length() - 1);
        labels[0][1] = this.getResource("PROJECTNAME");
        labels[0][2] = this.getResource("TASKTYPE");
        labels[0][3] = this.getResource("TASKNAME");
        labels[0][4] = this.getResource("MATERIALNAME");
        labels[0][5] = this.getResource("MILESTONE");
        labels[0][6] = this.getResource("com.kingdee.eas.mm.project.PROJECTAutoGenerateResource", "0_ProjectTaskPlanningReport");
        labels[1][0] = this.getResource("STORAGEOURUNIT").substring(0, this.getResource("STORAGEOURUNIT").length() - 1);
        labels[1][1] = this.getResource("PROJECTNAME");
        labels[1][2] = this.getResource("TASKTYPE");
        labels[1][3] = this.getResource("TASKNAME");
        labels[1][4] = this.getResource("MATERIALNAME");
        labels[1][5] = this.getResource("MILESTONE");
        labels[1][6] = this.getResource("com.kingdee.eas.mm.project.PROJECTAutoGenerateResource", "0_ProjectTaskPlanningReport");
        Calendar beginTime = this.buildBeginTime(this.filter.getString("beginTime"));
        Calendar actualTime = (Calendar)beginTime.clone();
        Calendar endTime = (Calendar)beginTime.clone();
        Date dateFrom = null;
        Date dateTo = null;
        SimpleDateFormat format = new SimpleDateFormat("yyyy.MM.dd");
        String halfYear = "";
        block7: for (int i = 0; i < this.expectationNum; ++i) {
            switch (this.issueType) {
                case -1: {
                    dateFrom = actualTime.getTime();
                    dateTo = this.getEndDayOfWeek(actualTime.getTime());
                    endTime.setTime(dateTo);
                    String weekTxt = MMUtils.getResourceWithParam((String)this.titleFormat, (Object[])new Object[]{String.valueOf(endTime.get(1)), this.year, String.valueOf(endTime.get(3)), this.week});
                    labels[0][7 + i] = weekTxt;
                    labels[1][7 + i] = format.format(dateFrom);
                    actualTime.set(6, actualTime.get(6) + 1);
                    continue block7;
                }
                case -2: {
                    dateFrom = actualTime.getTime();
                    dateTo = this.getEndDayOfWeek(actualTime.getTime());
                    actualTime.setTime(dateTo);
                    String monthTxt = MMUtils.getResourceWithParam((String)this.titleFormat, (Object[])new Object[]{String.valueOf(actualTime.get(1)), this.year, String.valueOf(actualTime.get(2) + 1), this.month});
                    String weekTxt = MMUtils.getResourceWithParam((String)this.titleFormat, (Object[])new Object[]{String.valueOf(actualTime.get(1)), this.year, String.valueOf(actualTime.get(3)), this.week});
                    labels[0][7 + i] = monthTxt;
                    labels[1][7 + i] = weekTxt;
                    actualTime.set(6, actualTime.get(6) + 1);
                    continue block7;
                }
                case -4: {
                    String quterTxt = MMUtils.getResourceWithParam((String)this.titleFormat, (Object[])new Object[]{String.valueOf(actualTime.get(1)), this.year, String.valueOf(this.getQuarterNum(actualTime)), this.quater});
                    halfYear = "";
                    halfYear = this.isEarlySemiYear(actualTime) ? this.getResource("EARLY_SEMI_YEAR") : this.getResource("AFTER_SEMI_YEAR");
                    String halfTxt = actualTime.get(1) + halfYear;
                    labels[0][7 + i] = halfTxt;
                    labels[1][7 + i] = quterTxt;
                    actualTime = this.getNextEndDayOfQuarter(actualTime);
                    continue block7;
                }
                case -5: {
                    halfYear = this.isEarlySemiYear(actualTime) ? this.getResource("EARLY_SEMI_YEAR") : this.getResource("AFTER_SEMI_YEAR");
                    String halfTxt = actualTime.get(1) + halfYear;
                    String yearTxt = String.valueOf(actualTime.get(1)).toString() + this.year;
                    labels[0][7 + i] = yearTxt;
                    labels[1][7 + i] = halfTxt;
                    actualTime = this.getNextEndDayOfHalfYear(actualTime);
                    continue block7;
                }
                case -6: {
                    String yearTxt = String.valueOf(actualTime.get(1));
                    labels[0][7 + i] = yearTxt;
                    labels[1][7 + i] = yearTxt;
                    actualTime.set(1, actualTime.get(1) + 1);
                    continue block7;
                }
                default: {
                    String quterTxt = MMUtils.getResourceWithParam((String)this.titleFormat, (Object[])new Object[]{String.valueOf(actualTime.get(1)), this.year, String.valueOf(this.getQuarterNum(actualTime)), this.quater});
                    String monthTxt = MMUtils.getResourceWithParam((String)this.titleFormat, (Object[])new Object[]{String.valueOf(actualTime.get(1)), this.year, String.valueOf(actualTime.get(2) + 1), this.month});
                    labels[0][7 + i] = quterTxt;
                    labels[1][7 + i] = monthTxt;
                    actualTime.set(2, actualTime.get(2) + 1);
                }
            }
        }
        header.setLabels(labels, true);
    }

    protected ReportTitles getReportTitles(String arg0, RptParams filter) throws BaseException {
        int expectationNum = new Integer(filter.getString("expectationNum"));
        Calendar beginTime = this.buildBeginTime(filter.getString("beginTime"));
        Calendar endTime = this.getExpectationEndTime(beginTime.getTime(), expectationNum);
        ReportTitles titles = new ReportTitles();
        switch (this.issueType) {
            case -1: {
                titles.AddTitle(0, this.getResource("PLANISSUESTART") + beginTime.get(1) + "." + (beginTime.get(2) + 1) + "." + beginTime.get(5));
                titles.AddTitle(1, this.getResource("PLANISSUEEND") + endTime.get(1) + "." + (endTime.get(2) + 1) + "." + endTime.get(5));
                break;
            }
            case -2: {
                titles.AddTitle(0, this.getResource("PLANISSUESTART") + MMUtils.getResourceWithParam((String)this.titleFormat, (Object[])new Object[]{new Integer(beginTime.get(1)), this.year, new Integer(beginTime.get(3)), this.week}));
                titles.AddTitle(1, this.getResource("PLANISSUEEND") + MMUtils.getResourceWithParam((String)this.titleFormat, (Object[])new Object[]{new Integer(endTime.get(1)), this.year, new Integer(endTime.get(3)), this.week}));
                break;
            }
            case -4: {
                titles.AddTitle(0, this.getResource("PLANISSUESTART") + MMUtils.getResourceWithParam((String)this.titleFormat, (Object[])new Object[]{new Integer(beginTime.get(1)), this.year, new Integer(beginTime.get(3)), this.quater}));
                titles.AddTitle(1, this.getResource("PLANISSUEEND") + MMUtils.getResourceWithParam((String)this.titleFormat, (Object[])new Object[]{new Integer(endTime.get(1)), this.year, new Integer(endTime.get(3)), this.quater}));
                break;
            }
            case -5: {
                String bHalfYear = "";
                bHalfYear = this.isEarlySemiYear(beginTime) ? this.getResource("EARLY_SEMI_YEAR") : this.getResource("AFTER_SEMI_YEAR");
                String eHalfYear = "";
                eHalfYear = this.isEarlySemiYear(endTime) ? this.getResource("EARLY_SEMI_YEAR") : this.getResource("AFTER_SEMI_YEAR");
                titles.AddTitle(0, this.getResource("PLANISSUESTART") + beginTime.get(1) + bHalfYear);
                titles.AddTitle(1, this.getResource("PLANISSUEEND") + endTime.get(1) + eHalfYear);
                break;
            }
            case -6: {
                titles.AddTitle(0, this.getResource("PLANISSUESTART") + beginTime.get(1));
                titles.AddTitle(1, this.getResource("PLANISSUEEND") + endTime.get(1));
                break;
            }
            default: {
                titles.AddTitle(0, this.getResource("PLANISSUESTART") + MMUtils.getResourceWithParam((String)this.titleFormat, (Object[])new Object[]{new Integer(beginTime.get(1)), this.year, new Integer(beginTime.get(3)), this.month}));
                titles.AddTitle(1, this.getResource("PLANISSUEEND") + MMUtils.getResourceWithParam((String)this.titleFormat, (Object[])new Object[]{new Integer(endTime.get(1)), this.year, new Integer(endTime.get(3)), this.month}));
            }
        }
        return titles;
    }

    public StringBuffer getTempRowSet(String[] tableName) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("   SELECT ");
        sb.append("     FStorageName ,");
        sb.append("     FProjectName , ");
        sb.append("     FTaskType ,");
        sb.append("     FTaskName ,");
        sb.append("     FMaterialName ,");
        sb.append("     FMileStone ,");
        sb.append("     FMeasureUnit , ");
        sb.append(" to_number(FPlanningNumTotal)  FPlanningNumTotal ");
        for (int i = 0; i < this.expectationNum; ++i) {
            sb.append(" , ");
            sb.append(" to_number(Fexpectation" + i + ")   Fexpectation" + i + " ");
        }
        sb.append(" , FID");
        sb.append(" , FParentID");
        sb.append("     from " + tableName[0] + " ");
        return sb;
    }

    public String getResource(String strKey) {
        return this.getResource("com.kingdee.eas.mm.project.ProjectProblemResource", strKey);
    }

    public String getResource(String classes, String strKey) {
        String strTemp = null;
        strTemp = this.ctx != null ? ResourceBase.getString((String)classes, (String)strKey, (Locale)this.ctx.getLocale()) : EASResource.getString((String)classes, (String)strKey);
        return strTemp;
    }

    public Context getContext() {
        return this.ctx;
    }

    private Calendar getPerIssueEndTime(Calendar perIssueBeginTime, Date planEndTime) {
        Date endTime = new Date();
        Calendar calF = Calendar.getInstance();
        Calendar calT = Calendar.getInstance();
        calT.setTime(planEndTime);
        switch (this.issueType) {
            case -1: {
                endTime = perIssueBeginTime.getTime();
                break;
            }
            case -2: {
                endTime = this.getEndDayOfWeek(perIssueBeginTime.getTime());
                calF.setTime(endTime);
                if (!calF.after(calT)) break;
                endTime = planEndTime;
                break;
            }
            case -3: {
                endTime = this.getEndDayOfMonth(perIssueBeginTime.getTime());
                calF.setTime(endTime);
                if (!calF.after(calT)) break;
                endTime = planEndTime;
                break;
            }
            case -4: {
                endTime = this.getEndDayOfQuarter(perIssueBeginTime.getTime());
                calF.setTime(endTime);
                if (!calF.after(calT)) break;
                endTime = planEndTime;
                break;
            }
            case -5: {
                endTime = this.getEndDayOfHalfYear(perIssueBeginTime.getTime());
                calF.setTime(endTime);
                if (!calF.after(calT)) break;
                endTime = planEndTime;
                break;
            }
            case -6: {
                endTime = this.getEndDayOfYear(perIssueBeginTime.getTime());
                calF.setTime(endTime);
                if (!calF.after(calT)) break;
                endTime = planEndTime;
            }
        }
        Calendar ret = Calendar.getInstance();
        ret.setTime(endTime);
        return ret;
    }

    public BigDecimal getPlanQtyResult(int a, int b, BigDecimal planQty, int qtyPrecision) {
        BigDecimal result = planQty.multiply(new BigDecimal(a)).divide(new BigDecimal(b), qtyPrecision, 2);
        return result;
    }

    private BigDecimal getPlanSum(List list) {
        BigDecimal sum = new BigDecimal("0.00000000");
        for (int i = 0; i < list.size(); ++i) {
            sum = ((BigDecimal)list.get(i)).add(sum);
        }
        return sum;
    }

    public int getQuarterNum(Calendar c) {
        int m = c.get(2);
        if (m >= 0 && m <= 2) {
            return 1;
        }
        if (m >= 3 && m <= 5) {
            return 2;
        }
        if (m >= 6 && m <= 8) {
            return 3;
        }
        if (m >= 9 && m <= 11) {
            return 4;
        }
        return 0;
    }

    public int getSemiYearNum(Calendar c) {
        int month = c.get(2);
        if (month <= 5) {
            return 1;
        }
        return 2;
    }

    private StringBuffer getTempTableMain(int num) {
        StringBuffer createTable = new StringBuffer();
        createTable.append("CREATE TABLE tempPlanning (");
        createTable.append("KSQL_SEQ INT IDENTITY (1, 1) not null");
        createTable.append(",FStorageName   varchar(255) ");
        createTable.append(",FProjectName   varchar(255) ");
        createTable.append(",FTaskType      varchar(44)  ");
        createTable.append(",FTaskName      varchar(255) ");
        createTable.append(",FMaterialName  varchar(255) ");
        createTable.append(",FMileStone     int default(0)");
        createTable.append(",FPlanningNumTotal  DECIMAL(21,8) default(0)");
        for (int i = 0; i < num; ++i) {
            createTable.append(",Fexpectation" + i + " DECIMAL(21,8) default(0)");
        }
        createTable.append(",FID            varchar(44)  ");
        createTable.append(",FPlanBeginTime DateTime  ");
        createTable.append(",FPlanEndTime DateTime  ");
        createTable.append(",FQty Decimal(21,8)  default(0)");
        createTable.append(",FQtyPrecision int  default(0)");
        createTable.append(",FParentID       varchar(44)  ");
        createTable.append(",FStorageID      varchar(44)  ");
        createTable.append(",FMeasureUnit    varchar(255) ");
        createTable.append(")");
        return createTable;
    }

    private boolean isInExpectationDay(Calendar curDay, Date begin, Date end) {
        return this.compareTime(curDay.getTime(), begin) >= 0 && this.compareTime(curDay.getTime(), end) <= 0;
    }

    private boolean isInExpectationHalfYear(Calendar curTime, Date begin, Date end) {
        return this.compareTime(curTime.getTime(), begin) >= 0 && this.compareTime(curTime.getTime(), end) <= 0;
    }

    private boolean isInExpectationMonth(Calendar curMonth, Date begin, Date end) {
        return this.compareTime(curMonth.getTime(), begin) >= 0 && this.compareTime(curMonth.getTime(), end) <= 0;
    }

    private boolean isInExpectationQuarter(Calendar curMonth, Date begin, Date end) {
        return this.compareTime(curMonth.getTime(), begin) >= 0 && this.compareTime(curMonth.getTime(), end) <= 0;
    }

    private boolean isInExpectationWeek(Calendar curWeek, Date begin, Date end) {
        return this.compareTime(curWeek.getTime(), begin) >= 0 && this.compareTime(curWeek.getTime(), end) <= 0;
    }

    private boolean isInExpectationYear(Calendar curYear, Date begin, Date end) {
        return this.compareTime(curYear.getTime(), begin) >= 0 && this.compareTime(curYear.getTime(), end) <= 0;
    }

    private boolean isEarlySemiYear(Calendar c) {
        return c.get(2) < 6;
    }

    private Calendar[] nextIssue(Calendar perIssueBeginTime, Calendar perIssueEndTime, Date planEndTime, MMProjectCalendarFactory fac) throws EASBizException, BOSException {
        Calendar[] ret = new Calendar[2];
        switch (this.issueType) {
            case -1: {
                do {
                    perIssueBeginTime.set(6, perIssueEndTime.get(6) + 1);
                    perIssueEndTime.setTime(perIssueBeginTime.getTime());
                } while (!fac.isWorkDay(perIssueBeginTime.getTime()));
                break;
            }
            case -2: {
                perIssueBeginTime.set(6, perIssueEndTime.get(6) + 1);
                perIssueBeginTime.set(1, perIssueEndTime.get(1));
                perIssueBeginTime.set(2, perIssueEndTime.get(2));
                perIssueEndTime.setTime(this.getPerIssueEndTime(perIssueBeginTime, planEndTime).getTime());
                break;
            }
            case -3: {
                perIssueBeginTime.set(5, perIssueEndTime.get(5) + 1);
                perIssueEndTime.setTime(this.getPerIssueEndTime(perIssueBeginTime, planEndTime).getTime());
                break;
            }
            case -4: {
                perIssueBeginTime.set(6, perIssueEndTime.get(6) + 1);
                perIssueBeginTime.set(1, perIssueEndTime.get(1));
                perIssueBeginTime.set(2, perIssueEndTime.get(2));
                perIssueEndTime.setTime(this.getPerIssueEndTime(perIssueBeginTime, planEndTime).getTime());
                break;
            }
            case -5: {
                perIssueBeginTime.set(6, perIssueEndTime.get(6) + 1);
                perIssueBeginTime.set(1, perIssueEndTime.get(1));
                perIssueBeginTime.set(2, perIssueEndTime.get(2));
                perIssueEndTime.setTime(this.getPerIssueEndTime(perIssueBeginTime, planEndTime).getTime());
                break;
            }
            case -6: {
                perIssueBeginTime.set(6, perIssueEndTime.get(6) + 1);
                perIssueBeginTime.set(1, perIssueEndTime.get(1));
                perIssueBeginTime.set(2, perIssueEndTime.get(2));
                perIssueEndTime.setTime(this.getPerIssueEndTime(perIssueBeginTime, planEndTime).getTime());
            }
        }
        ret[0] = perIssueBeginTime;
        ret[1] = perIssueEndTime;
        return ret;
    }

    private boolean isInExpectation(Calendar curTime, Date begin, Date end) {
        boolean ret = false;
        switch (this.issueType) {
            case -1: {
                ret = this.isInExpectationDay(curTime, begin, end);
                break;
            }
            case -2: {
                ret = this.isInExpectationWeek(curTime, begin, end);
                break;
            }
            case -3: {
                ret = this.isInExpectationMonth(curTime, begin, end);
                break;
            }
            case -4: {
                ret = this.isInExpectationQuarter(curTime, begin, end);
                break;
            }
            case -5: {
                ret = this.isInExpectationHalfYear(curTime, begin, end);
                break;
            }
            case -6: {
                ret = this.isInExpectationYear(curTime, begin, end);
            }
        }
        return ret;
    }

    public String time2String(Calendar cal, String flag) {
        switch (this.issueType) {
            case -1: {
                break;
            }
            case -2: {
                if (flag.equals("begin")) {
                    cal.setTime(this.getFirstDayOfWeek(cal.getTime()));
                    break;
                }
                cal.setTime(this.getEndDayOfWeek(cal.getTime()));
                break;
            }
            case -4: {
                if (flag.equals("begin")) {
                    cal.setTime(this.getFirstDayOfQuarter(cal.getTime()));
                    break;
                }
                cal.setTime(this.getEndDayOfQuarter(cal.getTime()));
                break;
            }
            case -5: {
                if (flag.equals("begin")) {
                    cal.setTime(this.getFirstDayOfSemiYear(cal.getTime()));
                    break;
                }
                cal.setTime(this.getEndDayOfHalfYear(cal.getTime()));
                break;
            }
            case -6: {
                if (flag.equals("begin")) {
                    cal.set(6, 1);
                    break;
                }
                cal.setTime(this.getEndDayOfYear(cal.getTime()));
                break;
            }
            default: {
                if (flag.equals("begin")) {
                    cal.set(5, 1);
                    break;
                }
                cal.setTime(this.getEndDayOfMonth(cal.getTime()));
            }
        }
        Date date = cal.getTime();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
        return format.format(date);
    }
}

