/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.mm.project.AbstractProjectTaskInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.mm.project.ProjectTaskCollection;
import com.kingdee.eas.mm.project.ProjectTaskFactory;
import com.kingdee.eas.mm.project.ProjectTaskInfo;
import com.kingdee.eas.mm.project.app.AbstractBOM2WBSFacadeControllerBean;
import com.kingdee.eas.mm.project.app.BOMExpand4WBS;
import com.kingdee.eas.mm.project.util.MMProjectCalendarFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class BOM2WBSFacadeControllerBean
extends AbstractBOM2WBSFacadeControllerBean {
    protected IObjectValue buildTree(Context ctx, IObjectCollection tasks) throws BOSException {
        if (tasks.size() == 0) {
            return null;
        }
        for (int i = 0; i < tasks.size(); ++i) {
            ProjectTaskInfo projectTask = (ProjectTaskInfo)tasks.getObject(i);
            if (projectTask.get("children") == null) {
                projectTask.put("children", new ArrayList());
            }
            if (projectTask.get("rearNodes") == null) {
                projectTask.put("rearNodes", new ArrayList());
            }
            if (projectTask.getParent() != null) {
                BOSUuid parentId = projectTask.getParent().getId();
                ProjectTaskInfo parentInfo = (ProjectTaskInfo)tasks.getObject((Object)parentId);
                if (parentInfo != null) {
                    if (parentInfo.get("children") == null) {
                        parentInfo.put("children", new ArrayList());
                    }
                    ArrayList childrenList = (ArrayList)parentInfo.get("children");
                    childrenList.add(projectTask);
                    projectTask.setParent(parentInfo);
                } else if (projectTask.get("isBOMExp") == null) {
                    projectTask.setParent(null);
                }
            }
            if (projectTask.getPreTask() == null) continue;
            BOSUuid preId = projectTask.getPreTask().getId();
            ProjectTaskInfo preInfo = (ProjectTaskInfo)tasks.getObject((Object)preId);
            if (preInfo != null) {
                if (preInfo.get("rearNodes") == null) {
                    preInfo.put("rearNodes", new ArrayList());
                }
                ArrayList rearNodesList = (ArrayList)preInfo.get("rearNodes");
                rearNodesList.add(projectTask);
                projectTask.setPreTask(preInfo);
                continue;
            }
            projectTask.setPreTask(null);
        }
        return tasks.getObject(0);
    }

    @Override
    protected void _scheduleTask(Context ctx, String taskId, boolean forwardSchedule) throws BOSException, EASBizException {
        ProjectTaskInfo projectTaskInfo = null;
        ProjectTaskInfo parentProjectTaskInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("parent"));
        selector.add(new SelectorItemInfo("preTask"));
        selector.add(new SelectorItemInfo("planBeginTime"));
        selector.add(new SelectorItemInfo("planEndTime"));
        selector.add(new SelectorItemInfo("totalTime"));
        selector.add(new SelectorItemInfo("iteratorType"));
        selector.add(new SelectorItemInfo("interval"));
        selector.add(new SelectorItemInfo("wbsNumber"));
        selector.add(new SelectorItemInfo("storageOrgUnit"));
        selector.add(new SelectorItemInfo("project.planBeginTime"));
        selector.add(new SelectorItemInfo("project.planEndTime"));
        projectTaskInfo = (ProjectTaskInfo)ProjectTaskFactory.getLocalInstance(ctx).getCoreBillBaseInfo((IObjectPK)new ObjectUuidPK(taskId), selector);
        selector.remove(new SelectorItemInfo("project.planBeginTime"));
        selector.remove(new SelectorItemInfo("project.planEndTime"));
        if (projectTaskInfo.getParent() != null) {
            parentProjectTaskInfo = (ProjectTaskInfo)ProjectTaskFactory.getLocalInstance(ctx).getCoreBillBaseInfo((IObjectPK)new ObjectUuidPK(projectTaskInfo.getParent().getId().toString()), selector);
        }
        filter.getFilterItems().add(new FilterItemInfo("project", (Object)projectTaskInfo.getProject().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("wbsNumber", (Object)(projectTaskInfo.getWbsNumber() + ".%"), CompareType.LIKE));
        SorterItemInfo wbsNumber = new SorterItemInfo("wbsNumber");
        wbsNumber.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(wbsNumber);
        viewInfo.setFilter(filter);
        viewInfo.setSelector(selector);
        CoreBaseCollection collection = ProjectTaskFactory.getLocalInstance(ctx).getCollection(viewInfo);
        collection.addObject(0, (IObjectValue)projectTaskInfo);
        ProjectTaskInfo rootProjectTask = (ProjectTaskInfo)this.buildTree(ctx, (IObjectCollection)collection);
        MMProjectCalendarFactory mmCalendarFactory = new MMProjectCalendarFactory(ctx, rootProjectTask.getProject().getId().toString());
        this.calculateParentTime(ctx, (IObjectValue)rootProjectTask);
        Calendar rootTime = Calendar.getInstance();
        if (forwardSchedule) {
            if (parentProjectTaskInfo != null && parentProjectTaskInfo.getPlanBeginTime() != null) {
                rootTime.setTimeInMillis(parentProjectTaskInfo.getPlanBeginTime().getTime());
            } else {
                rootTime.setTimeInMillis(rootProjectTask.getProject().getPlanBeginTime().getTime());
            }
            this.forwardSchedule(ctx, (IObjectValue)rootProjectTask, rootTime, mmCalendarFactory);
        } else {
            if (parentProjectTaskInfo != null && parentProjectTaskInfo.getPlanEndTime() != null) {
                rootTime.setTimeInMillis(parentProjectTaskInfo.getPlanEndTime().getTime());
            } else {
                rootTime.setTimeInMillis(rootProjectTask.getProject().getPlanEndTime().getTime());
            }
            this.backwardShedule(ctx, rootProjectTask, rootTime, mmCalendarFactory);
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement("update t_mm_projecttask set fplanBeginTime=?,fplanEndTime=?,FTotalTime=? where fid=?");
            for (int i = 0; i < collection.size(); ++i) {
                ProjectTaskInfo projectTaskUpdate = (ProjectTaskInfo)collection.get(i);
                pstmt.setDate(1, new Date(projectTaskUpdate.getPlanBeginTime().getTime()));
                pstmt.setDate(2, new Date(projectTaskUpdate.getPlanEndTime().getTime()));
                pstmt.setBigDecimal(3, projectTaskUpdate.getTotalTime());
                pstmt.setString(4, projectTaskUpdate.getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected Calendar backwardShedule(Context ctx, ProjectTaskInfo task, Calendar endTime, MMProjectCalendarFactory mmCalendarFactory) throws BOSException, EASBizException {
        Calendar calender = Calendar.getInstance();
        if (task.get("BACKWARDSHEDULE") != null) {
            calender.setTime(task.getPlanBeginTime());
            return calender;
        }
        if (task.get("FORWARD_IN_BACKWARD") == null) {
            int taskTime = task.getTotalTime().intValue();
            ArrayList tasks = (ArrayList)task.get("rearNodes");
            if (tasks != null && tasks.size() > 0) {
                int maxTime = this.rearTotalTime(task);
                java.util.Date taskEndTime = mmCalendarFactory.addLeadtime(endTime.getTime(), -maxTime);
                java.util.Date taskBeginTime = mmCalendarFactory.addWroklength(taskEndTime, -taskTime);
                task.setPlanBeginTime(new Timestamp(taskBeginTime.getTime()));
                task.setPlanEndTime(new Timestamp(taskEndTime.getTime()));
                this.forwardInBackward(task, mmCalendarFactory);
            } else {
                ProjectTaskInfo preTask = task.getPreTask();
                if (preTask != null) {
                    ProjectTaskInfo earistPreTask = null;
                    while (preTask != null) {
                        earistPreTask = preTask;
                        preTask = preTask.getPreTask();
                    }
                    this.backwardShedule(ctx, earistPreTask, endTime, mmCalendarFactory);
                } else {
                    java.util.Date beginTime = mmCalendarFactory.addWroklength(endTime.getTime(), -taskTime);
                    task.setPlanBeginTime(new Timestamp(beginTime.getTime()));
                    task.setPlanEndTime(new Timestamp(endTime.getTime().getTime()));
                }
            }
        }
        task.put("BACKWARDSHEDULE", Boolean.TRUE);
        ArrayList taskChild = (ArrayList)task.get("children");
        if (taskChild != null && taskChild.size() > 0) {
            for (int i = 0; i < taskChild.size(); ++i) {
                ProjectTaskInfo l_task = (ProjectTaskInfo)taskChild.get(i);
                calender.setTime(task.getPlanEndTime());
                this.backwardShedule(ctx, l_task, calender, mmCalendarFactory);
            }
        }
        calender.setTime(task.getPlanBeginTime());
        return calender;
    }

    protected Calendar forwardSchedule(Context ctx, IObjectValue task, Calendar beginTime, MMProjectCalendarFactory mmCalendarFactory) throws BOSException, EASBizException {
        Calendar endCalendar = Calendar.getInstance();
        Calendar beginCalendar = Calendar.getInstance();
        ProjectTaskInfo info = (ProjectTaskInfo)task;
        ArrayList list = (ArrayList)info.get("children");
        if (info.get("flag2") == null) {
            if (info.getPreTask() != null) {
                endCalendar = this.forwardSchedule(ctx, (IObjectValue)info.getPreTask(), beginTime, mmCalendarFactory);
                if (info.getIteratorType().getId().toString().equals("Fq4GNbRIRsycITnKFLeBd5pMH64=")) {
                    beginCalendar.setTime(mmCalendarFactory.addLeadtime4(endCalendar.getTime(), info.getInterval().intValue(), 1));
                }
                if (info.getIteratorType().getId().toString().equals("v1VYDRfdTvK2ahwoFyvCLppMH64=")) {
                    beginCalendar.setTime(mmCalendarFactory.addLeadtime4(beginTime.getTime(), info.getInterval().intValue(), 0));
                }
                if (info.getIteratorType().getId().toString().equals("lS5zDgcXS7Ovp7Xx1hjzJZpMH64=")) {
                    beginCalendar.setTime(mmCalendarFactory.addWroklength(mmCalendarFactory.addLeadtime4(endCalendar.getTime(), info.getInterval().intValue(), 0), -info.getTotalTime().intValue()));
                }
                if (info.getIteratorType().getId().toString().equals("V7CLkDIwR9Cbr4Bs/mppV5pMH64=")) {
                    beginCalendar.setTime(mmCalendarFactory.addWroklength(mmCalendarFactory.addLeadtime4(beginTime.getTime(), info.getInterval().intValue(), -1), -info.getTotalTime().intValue()));
                }
            } else {
                beginCalendar = beginTime;
            }
            info.setPlanBeginTime(new Timestamp(beginCalendar.getTime().getTime()));
            info.setPlanEndTime(new Timestamp(mmCalendarFactory.addWroklength(beginCalendar.getTime(), info.getTotalTime().intValue()).getTime()));
            info.put("flag2", new Boolean(true));
            for (int i = 0; i < list.size(); ++i) {
                this.forwardSchedule(ctx, (IObjectValue)((ProjectTaskInfo)list.get(i)), beginCalendar, mmCalendarFactory);
            }
        }
        endCalendar.setTimeInMillis(info.getPlanEndTime().getTime());
        return endCalendar;
    }

    protected int calculateParentTime(Context ctx, IObjectValue root) throws BOSException, EASBizException {
        int taskTotalTime = 0;
        ProjectTaskInfo task = (ProjectTaskInfo)root;
        if (task.get("countTime") != null) {
            return task.getTotalTime().intValue();
        }
        taskTotalTime = task.getTotalTime().intValue();
        ArrayList taskChild = (ArrayList)task.get("children");
        ProjectTaskInfo localTask = null;
        if (taskChild != null && taskChild.size() > 0) {
            taskTotalTime = 0;
            int t_Time = 0;
            for (int i = 0; i < taskChild.size(); ++i) {
                localTask = (ProjectTaskInfo)taskChild.get(i);
                t_Time = this.calculateParentTime(ctx, (IObjectValue)localTask);
                if (t_Time <= taskTotalTime) continue;
                taskTotalTime = t_Time;
                task.setTotalTime(new BigDecimal(taskTotalTime));
            }
        } else {
            ProjectTaskInfo preTask = task.getPreTask();
            if (preTask != null && task.getIteratorType().getId().toString().equals("Fq4GNbRIRsycITnKFLeBd5pMH64=")) {
                int perTaskTime = this.calculateParentTime(ctx, (IObjectValue)preTask);
                int interval = task.getInterval().intValue();
                int totalTime = task.getTotalTime().intValue();
                taskTotalTime = totalTime + perTaskTime + interval;
            }
        }
        task.put("countTime", Boolean.TRUE);
        return taskTotalTime;
    }

    protected int calculateParentTime4BOMExpand(Context ctx, IObjectValue root) throws BOSException, EASBizException {
        int taskTotalTime = 0;
        ProjectTaskInfo task = (ProjectTaskInfo)root;
        AbstractProjectTaskInfo maxTotalTimeChildTask = null;
        AbstractProjectTaskInfo copyChildTask = null;
        if (task.get("countTime") != null) {
            return task.getTotalTime().intValue();
        }
        taskTotalTime = task.getTotalTime().intValue();
        ArrayList taskChild = (ArrayList)task.get("children");
        ProjectTaskInfo localTask = null;
        if (taskChild != null && taskChild.size() > 0) {
            taskTotalTime = 0;
            int t_Time = 0;
            for (int i = 0; i < taskChild.size(); ++i) {
                localTask = (ProjectTaskInfo)taskChild.get(i);
                t_Time = this.calculateParentTime4BOMExpand(ctx, (IObjectValue)localTask);
                if (t_Time <= taskTotalTime) continue;
                if (localTask.get("isCopy") == null || !localTask.getBoolean("isCopy")) {
                    maxTotalTimeChildTask = localTask;
                } else if (localTask.get("isCopy") != null && localTask.getBoolean("isCopy")) {
                    copyChildTask = localTask;
                    continue;
                }
                taskTotalTime = t_Time;
            }
            if (copyChildTask != null) {
                copyChildTask.setPreTask((ProjectTaskInfo)maxTotalTimeChildTask);
            }
            if (task.get("10020") != null && maxTotalTimeChildTask != null) {
                int perTaskTime = maxTotalTimeChildTask.getTotalTime().intValue();
                if (copyChildTask != null) {
                    int interval = copyChildTask.getInterval().intValue();
                    int totalTime = copyChildTask.getTotalTime().intValue();
                    taskTotalTime = totalTime + perTaskTime + interval;
                    task.setTotalTime(new BigDecimal(taskTotalTime));
                }
            } else {
                task.setTotalTime(new BigDecimal(taskTotalTime));
            }
        }
        task.put("countTime", Boolean.TRUE);
        return taskTotalTime;
    }

    private IObjectValue buildPostRelation(Context ctx, IObjectCollection tasks) throws BOSException {
        if (tasks.size() == 0) {
            return null;
        }
        for (int i = 0; i < tasks.size(); ++i) {
            ProjectTaskInfo pretask;
            ProjectTaskInfo projectTask = (ProjectTaskInfo)tasks.getObject(i);
            if (projectTask.get("rearNodes") == null) {
                projectTask.put("rearNodes", new ArrayList());
            }
            if (projectTask.getPreTask() == null || (pretask = projectTask.getPreTask()) == null) continue;
            if (pretask.get("rearNodes") == null) {
                pretask.put("rearNodes", new ArrayList());
            }
            ArrayList rearNodesList = (ArrayList)pretask.get("rearNodes");
            rearNodesList.add(projectTask);
        }
        return tasks.getObject(0);
    }

    private void forwardInBackward(ProjectTaskInfo task, MMProjectCalendarFactory mmCalendarFactory) throws EASBizException, BOSException {
        ArrayList tasks = (ArrayList)task.get("rearNodes");
        Calendar beginDate = Calendar.getInstance();
        Calendar endDate = Calendar.getInstance();
        if (tasks != null && tasks.size() > 0) {
            for (int i = 0; i < tasks.size(); ++i) {
                int toTalTime;
                ProjectTaskInfo l_task = (ProjectTaskInfo)tasks.get(i);
                int l_time = l_task.getTotalTime().intValue();
                int l_Interval = l_task.getInterval().intValue();
                if (l_task.getIteratorType().getId().toString().equals("v1VYDRfdTvK2ahwoFyvCLppMH64=")) {
                    toTalTime = task.getTotalTime().intValue();
                    beginDate.setTime(mmCalendarFactory.addLeadtime2(mmCalendarFactory.addWroklength(task.getPlanBeginTime(), toTalTime), l_Interval - toTalTime));
                    endDate.setTime(mmCalendarFactory.addWroklength(beginDate.getTime(), l_time));
                }
                if (l_task.getIteratorType().getId().toString().equals("Fq4GNbRIRsycITnKFLeBd5pMH64=")) {
                    beginDate.setTime(mmCalendarFactory.addLeadtime2(task.getPlanEndTime(), l_Interval));
                    endDate.setTime(mmCalendarFactory.addWroklength(beginDate.getTime(), l_time));
                }
                if (l_task.getIteratorType().getId().toString().equals("V7CLkDIwR9Cbr4Bs/mppV5pMH64=")) {
                    toTalTime = task.getTotalTime().intValue();
                    java.util.Date taskEndTime = mmCalendarFactory.addWroklength(task.getPlanBeginTime(), toTalTime);
                    beginDate.setTime(mmCalendarFactory.addLeadtime2(taskEndTime, l_Interval - toTalTime - l_time));
                    endDate.setTime(mmCalendarFactory.addWroklength(beginDate.getTime(), l_time));
                }
                if (l_task.getIteratorType().getId().toString().equals("lS5zDgcXS7Ovp7Xx1hjzJZpMH64=")) {
                    beginDate.setTime(mmCalendarFactory.addLeadtime2(task.getPlanEndTime(), l_Interval - l_time));
                    endDate.setTime(mmCalendarFactory.addWroklength(beginDate.getTime(), l_time));
                }
                l_task.setPlanBeginTime(new Timestamp(beginDate.getTime().getTime()));
                l_task.setPlanEndTime(new Timestamp(endDate.getTime().getTime()));
                l_task.put("FORWARD_IN_BACKWARD", Boolean.TRUE);
                this.forwardInBackward(l_task, mmCalendarFactory);
            }
        }
    }

    private int rearTotalTime(ProjectTaskInfo task) throws EASBizException, BOSException {
        ArrayList tasks = (ArrayList)task.get("rearNodes");
        int preTotalTime = task.getTotalTime().intValue();
        int maxTime = 0;
        if (tasks != null && tasks.size() > 0) {
            for (int i = 0; i < tasks.size(); ++i) {
                int rearTotalTime;
                ProjectTaskInfo l_task = (ProjectTaskInfo)tasks.get(i);
                int l_time = l_task.getTotalTime().intValue();
                int l_Interval = l_task.getInterval().intValue();
                if (l_task.getIteratorType().getId().toString().equals("Fq4GNbRIRsycITnKFLeBd5pMH64=")) {
                    l_time += l_Interval;
                }
                if (l_task.getIteratorType().getId().toString().equals("lS5zDgcXS7Ovp7Xx1hjzJZpMH64=")) {
                    l_time = l_Interval;
                }
                if (l_task.getIteratorType().getId().toString().equals("v1VYDRfdTvK2ahwoFyvCLppMH64=")) {
                    l_time += l_Interval - preTotalTime;
                }
                if (l_task.getIteratorType().getId().toString().equals("V7CLkDIwR9Cbr4Bs/mppV5pMH64=")) {
                    l_time = l_Interval - preTotalTime;
                }
                ArrayList rearTasks = (ArrayList)l_task.get("rearNodes");
                int rearTime = 0;
                if (rearTasks != null && rearTasks.size() > 0) {
                    rearTime = this.rearTotalTime(l_task);
                }
                if ((rearTotalTime = rearTime + l_time) <= maxTime) continue;
                maxTime = rearTotalTime;
            }
        }
        return maxTime;
    }

    @Override
    protected String _bom2wbs(Context ctx, Map map) throws BOSException, EASBizException {
        ProjectTaskCollection coll = new ProjectTaskCollection();
        boolean isTemplate = false;
        boolean isForWard = false;
        isTemplate = (Boolean)map.get("ISTEMP");
        isForWard = (Boolean)map.get("FORWARD");
        AbstractProjectTaskInfo parent = null;
        if (map.get("PARENT") != null) {
            parent = (ProjectTaskInfo)map.get("PARENT");
        }
        if (parent != null && parent.getCarNumber() != null) {
            String trackID = parent.getCarNumber().getId().toString();
            map.put("trackID", trackID);
        }
        ProjectInfo project = (ProjectInfo)map.get("PROJECT");
        Calendar start = null;
        Calendar end = null;
        if (parent != null) {
            start = Calendar.getInstance();
            end = Calendar.getInstance();
            start.setTime(parent.getPlanBeginTime());
            end.setTime(parent.getPlanEndTime());
        } else {
            start = Calendar.getInstance();
            end = Calendar.getInstance();
            start.setTime(project.getPlanBeginTime());
            end.setTime(project.getPlanEndTime());
        }
        BOMExpand4WBS bomexp = new BOMExpand4WBS(ctx, isTemplate);
        Map resultMap = bomexp.bomExpand(map);
        List errorMaterialNumberList = (List)resultMap.get("errorNumber");
        if (errorMaterialNumberList.size() > 0) {
            String materialNumberStr = ResourceBase.getString((String)"com.kingdee.eas.mm.project.ProjectTaskResource.MATERIAL_NUMBER", (Locale)ctx.getLocale());
            String noETOMaterailStr = ResourceBase.getString((String)"com.kingdee.eas.mm.project.ProjectTaskResource.NOT_ETO", (Locale)ctx.getLocale());
            String errowLableStr = ResourceBase.getString((String)"com.kingdee.eas.mm.project.ProjectTaskResource.ERROR_LABLE", (Locale)ctx.getLocale());
            StringBuffer errorStringBuffer = new StringBuffer();
            errorStringBuffer.append(materialNumberStr).append("\t\t").append(errowLableStr).append("\n\r");
            int size = errorMaterialNumberList.size();
            for (int i = 0; i < size; ++i) {
                errorStringBuffer.append(errorMaterialNumberList.get(i)).append("\t\t").append(noETOMaterailStr).append("\n\r");
            }
            return errorStringBuffer.toString();
        }
        coll = (ProjectTaskCollection)((Object)resultMap.get("projectTaskCollection"));
        MMProjectCalendarFactory mmCalendarFactory = null;
        if (coll != null && coll.size() > 0) {
            mmCalendarFactory = new MMProjectCalendarFactory(ctx, coll.get(0).getProject().getId().toString());
            this.buildTree(ctx, (IObjectCollection)coll);
            this.calculateParentTime4BOMExpand(ctx, (IObjectValue)coll.get(0));
            this.buildPostRelation(ctx, (IObjectCollection)coll);
            if (isForWard) {
                this.forwardSchedule(ctx, (IObjectValue)coll.get(0), start, mmCalendarFactory);
            } else {
                this.backwardShedule(ctx, coll.get(0), end, mmCalendarFactory);
            }
            Connection con = this.getConnection(ctx);
            try {
                IORMappingDAO dao = ORMappingDAO.getInstance((BOSObjectType)new ProjectTaskInfo().getBOSType(), (Context)ctx, (Connection)con);
                for (int i = 0; i < coll.size(); ++i) {
                    dao.addNewBatch((IObjectValue)coll.get(i));
                }
                dao.executeBatch();
            }
            catch (DataAccessException e) {
                throw e;
            }
            finally {
                SQLUtils.cleanup((Connection)con);
            }
        }
        return null;
    }
}

