/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.project.MonthPlanCalendarData;
import com.kingdee.eas.mm.project.MonthPlanCollection;
import com.kingdee.eas.mm.project.MonthPlanEntryCollection;
import com.kingdee.eas.mm.project.MonthPlanEntryInfo;
import com.kingdee.eas.mm.project.MonthPlanFilterPharser;
import com.kingdee.eas.mm.project.MonthPlanInfo;
import com.kingdee.eas.mm.project.Peroid;
import com.kingdee.eas.mm.project.ProjectDictDataInfo;
import com.kingdee.eas.mm.project.app.AbstractMonthPlanControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MonthPlanControllerBean
extends AbstractMonthPlanControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.project.app.MonthPlanControllerBean");
    private static String tableProject = null;
    private static String tableTask = null;

    @Override
    protected void _saveBatch(Context ctx, IObjectCollection models) throws BOSException, EASBizException {
        MonthPlanCollection colls = (MonthPlanCollection)models;
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"1", (BOSObjectType)new MonthPlanInfo().getBOSType(), null, null, (String)"mm_project_monthplanedit");
        Connection conn = null;
        Statement pstmAddMonthPlan = null;
        Statement pstmAddMonthPlanEntry = null;
        Statement pstmUpdateMonthPlanEntry = null;
        StringBuffer insertMonthPlan = new StringBuffer(8);
        insertMonthPlan.append("insert into t_mm_monthPlan (FID,FProjectID,FTaskTemplateID) values(?,?,?)");
        StringBuffer insertMonthPlanEntry = new StringBuffer(8);
        insertMonthPlanEntry.append("insert into t_mm_monthPlanEntry (FID,FParentID,FAdjustQty,");
        insertMonthPlanEntry.append("FYear,FPeroid,FPeroidTypeID) values(?,?,?,?,?,?)");
        StringBuffer updateMonthPlanEntry = new StringBuffer(8);
        updateMonthPlanEntry.append("update t_mm_monthPlanEntry set FAdjustQty = ? where FID = ?");
        try {
            conn = this.getConnection(ctx);
            String pk = null;
            for (int i = 0; i < colls.size(); ++i) {
                MonthPlanInfo monthPlan = colls.get(i);
                if (monthPlan.getId() == null) {
                    pk = BOSUuid.create((BOSObjectType)monthPlan.getBOSType()).toString();
                    if (pstmAddMonthPlan == null) {
                        pstmAddMonthPlan = conn.prepareStatement(insertMonthPlan.toString());
                    }
                    pstmAddMonthPlan.setString(1, pk);
                    pstmAddMonthPlan.setString(2, monthPlan.getProject().getId().toString());
                    pstmAddMonthPlan.setString(3, monthPlan.getTaskTemplate().getId().toString());
                    pstmAddMonthPlan.addBatch();
                } else {
                    pk = monthPlan.getId().toString();
                }
                MonthPlanEntryCollection entries = monthPlan.getEntries();
                String entryPk = null;
                for (int j = 0; j < entries.size(); ++j) {
                    MonthPlanEntryInfo entry = entries.get(j);
                    if (entry.getId() == null) {
                        if (pstmAddMonthPlanEntry == null) {
                            pstmAddMonthPlanEntry = conn.prepareStatement(insertMonthPlanEntry.toString());
                        }
                        entryPk = BOSUuid.create((BOSObjectType)entry.getBOSType()).toString();
                        pstmAddMonthPlanEntry.setString(1, entryPk);
                        pstmAddMonthPlanEntry.setString(2, pk);
                        pstmAddMonthPlanEntry.setBigDecimal(3, entry.getAdjustQty());
                        pstmAddMonthPlanEntry.setInt(4, entry.getYear());
                        pstmAddMonthPlanEntry.setInt(5, entry.getPeroid());
                        pstmAddMonthPlanEntry.setString(6, null);
                        pstmAddMonthPlanEntry.addBatch();
                        continue;
                    }
                    entryPk = entry.getId().toString();
                    if (pstmUpdateMonthPlanEntry == null) {
                        pstmUpdateMonthPlanEntry = conn.prepareStatement(updateMonthPlanEntry.toString());
                    }
                    pstmUpdateMonthPlanEntry.setBigDecimal(1, entry.getAdjustQty());
                    pstmUpdateMonthPlanEntry.setString(2, entryPk);
                    pstmUpdateMonthPlanEntry.addBatch();
                }
            }
            if (pstmAddMonthPlan != null) {
                pstmAddMonthPlan.executeBatch();
            }
            if (pstmAddMonthPlanEntry != null) {
                pstmAddMonthPlanEntry.executeBatch();
            }
            if (pstmUpdateMonthPlanEntry != null) {
                pstmUpdateMonthPlanEntry.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmAddMonthPlanEntry);
                SQLUtils.cleanup(pstmUpdateMonthPlanEntry);
                SQLUtils.cleanup(pstmAddMonthPlan, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmAddMonthPlanEntry);
        SQLUtils.cleanup((Statement)pstmUpdateMonthPlanEntry);
        SQLUtils.cleanup((Statement)pstmAddMonthPlan, (Connection)conn);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
    }

    private String createTempTableProject(Context ctx) throws BOSException {
        String expandTablName = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        StringBuffer table = new StringBuffer(8);
        table.append("create table t_temp_monthPlanProject (");
        table.append("KSQL_SEQ INT IDENTITY (1, 1) not null,");
        table.append("FStorageOrgUnitID varchar(44),");
        table.append("FTaskTemplateID varchar(44),");
        table.append("FTasktemplateName nvarchar(255),");
        table.append("FPrecision INT default(0) not null,");
        table.append("FDayQty NUMERIC(21,8) default(0),");
        table.append("FDayMaxQty NUMERIC(21,8) default(0),");
        table.append("FPeriodMaxQty NUMERIC(21,8) default(0),");
        table.append("FProjectID varchar(44),");
        table.append("FProjectName nvarchar(255),");
        table.append("FProjectPriority int,");
        table.append("FMaterialName nvarchar(255)");
        table.append(");");
        try {
            expandTablName = pool.createTempTable(table.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return expandTablName;
    }

    private String createTempTableTask(Context ctx) throws BOSException {
        String expandTablName = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        StringBuffer table = new StringBuffer(8);
        table.append("create table t_temp_monthPlanTask (");
        table.append("FTaskTemplateID varchar(44),");
        table.append("FProjectID varchar(44),");
        table.append("FTaskID varchar(44),");
        table.append("FPlanEndTime DateTime,");
        table.append("FQty NUMERIC(21,8) default(0)");
        table.append(");");
        try {
            expandTablName = pool.createTempTable(table.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return expandTablName;
    }

    @Override
    protected void _releaseTempTable(Context ctx, List tables) throws BOSException {
        if (tables == null) {
            return;
        }
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        for (String tableName : tables) {
            pool.releaseTable(tableName);
        }
    }

    @Override
    protected Map _createData(Context ctx, FilterInfo filter, Map tables) throws BOSException, EASBizException {
        HashMap<String, Object> returnTables = new HashMap<String, Object>();
        if (tables == null) {
            tableProject = this.createTempTableProject(ctx);
            tableTask = this.createTempTableTask(ctx);
            this.insertProjectData(ctx, filter);
            returnTables.put("canlendar", this.getCanlendar(ctx, filter));
            returnTables.put("peroidType", this.getPeroidType(ctx, filter));
        } else {
            tableProject = (String)tables.get("TempProject");
            tableTask = (String)tables.get("TempTask");
            StringBuffer sql = new StringBuffer(8);
            sql.append("delete from ");
            sql.append(tableProject);
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("delete from ");
            sql.append(tableTask);
            DbUtil.execute((Context)ctx, (String)sql.toString());
            this.insertProjectData(ctx, filter);
            returnTables.put("canlendar", this.getCanlendar(ctx, filter));
            returnTables.put("peroidType", this.getPeroidType(ctx, filter));
        }
        returnTables.put("TempProject", tableProject);
        returnTables.put("TempTask", tableTask);
        return returnTables;
    }

    private Map getCanlendar(Context ctx, FilterInfo filter) throws BOSException {
        MonthPlanFilterPharser pharser = new MonthPlanFilterPharser(filter);
        Map calendar = null;
        try {
            StringBuffer selectCalander = new StringBuffer(8);
            selectCalander.append("select T0.FStorageOrgUnitID FStorageOrgUnitID,T1.FWorkDate FWorkDate,");
            selectCalander.append("T1.FWorkDateSeq FWorkDateSeq from t_mm_factorycalendar T0 inner join ");
            selectCalander.append("t_mm_factorycalendarentry T1 on t0.FID = T1.FParentID ");
            selectCalander.append("inner join t_org_storage T2 on T0.FStorageOrgUnitID = T2.FID where ");
            selectCalander.append(pharser.getStorageFilter("T2"));
            selectCalander.append("and T1.FWorkDate >= to_date('");
            selectCalander.append(pharser.getDateString(true));
            selectCalander.append("') and T1.FWorkDate <= to_date('");
            selectCalander.append(pharser.getDateString(false));
            selectCalander.append("') and FDateType = 1 order by T0.FStorageOrgUnitID,T1.FWorkDateSeq");
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)selectCalander.toString());
            calendar = this.buildCalendar(rowset);
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return calendar;
    }

    private ProjectDictDataInfo getPeroidType(Context ctx, FilterInfo filter) throws BOSException {
        MonthPlanFilterPharser pharser = new MonthPlanFilterPharser(filter);
        String local = ctx.getLocale().toString();
        ProjectDictDataInfo info = null;
        try {
            StringBuffer selectPeroidType = new StringBuffer(8);
            selectPeroidType.append("select FID,FNumber,FName_");
            selectPeroidType.append(local);
            selectPeroidType.append(" FName from t_mm_projectdictdata where FNumber='");
            selectPeroidType.append(pharser.getPeriodType());
            selectPeroidType.append("'");
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)selectPeroidType.toString());
            if (rowset != null && rowset.next()) {
                info = new ProjectDictDataInfo();
                info.setId(BOSUuid.read((String)rowset.getString("FID")));
                info.setNumber(rowset.getString("FNumber"));
                info.setName(rowset.getString("FName"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return info;
    }

    private void insertProjectData(Context ctx, FilterInfo filter) throws BOSException {
        MonthPlanFilterPharser pharser = new MonthPlanFilterPharser(filter);
        String filterSQL = null;
        StringBuffer sql = new StringBuffer(8);
        StringBuffer selectSql = new StringBuffer(8);
        String local = ctx.getLocale().toString();
        try {
            filterSQL = pharser.toSql();
            selectSql.append("insert into ");
            selectSql.append(tableProject);
            selectSql.append("(KSQL_SEQ,FStorageOrgUnitID,FPrecision,FTaskTemplateID,FTasktemplateName,FDayQty,");
            selectSql.append("FDayMaxQty,FPeriodMaxQty,FProjectID,");
            selectSql.append("FProjectName,FProjectPriority,FMaterialName) ");
            selectSql.append("select distinct ");
            selectSql.append("TaskTemplate");
            selectSql.append(".FStorageOrgUnitID");
            selectSql.append(" OrgID,");
            selectSql.append("T5.FQtyPrecision FPrecision,");
            selectSql.append("TaskTemplate");
            selectSql.append(".FID");
            selectSql.append(" tempID,");
            selectSql.append("TaskTemplate");
            selectSql.append(".FName_");
            selectSql.append(local);
            selectSql.append(" tempName,");
            selectSql.append("TaskTemplate");
            selectSql.append(".FDayQty,");
            selectSql.append("TaskTemplate");
            selectSql.append(".FDayMaxQty");
            selectSql.append(",0,");
            selectSql.append("Project");
            selectSql.append(".FID");
            selectSql.append(" projectID,");
            selectSql.append("Project");
            selectSql.append(".FName_");
            selectSql.append(local);
            selectSql.append(" projectName,");
            selectSql.append("Project");
            selectSql.append(".FPriority,");
            selectSql.append("T3.FName_");
            selectSql.append(local);
            selectSql.append(" materialName");
            sql.append(" from t_mm_projecttask ");
            sql.append("Task");
            sql.append(" inner join t_mm_project ");
            sql.append("Project");
            sql.append(" on ");
            sql.append("Task");
            sql.append(".FProjectID = ");
            sql.append("Project");
            sql.append(".FID ");
            sql.append(" inner join t_mm_taskTemplate ");
            sql.append("TaskTemplate");
            sql.append(" on ");
            sql.append("Task");
            sql.append(".FTaskTemplateID = ");
            sql.append("TaskTemplate");
            sql.append(".FID");
            sql.append(" inner join t_bd_material T3 on ");
            sql.append("Task");
            sql.append(".FMaterialID = T3.FID ");
            sql.append("inner join t_bd_multimeasureunit T5 on ");
            sql.append("T5.FMATERIALID = T3.FID and T5.FMeasureunitID=T3.FBaseUnit ");
            sql.append(" inner join t_org_storage ");
            sql.append("Storage");
            sql.append(" on ");
            sql.append("Task");
            sql.append(".FStorageOrgUnitID = ");
            sql.append("Storage");
            sql.append(".FID ");
            sql.append(" where ");
            sql.append("TaskTemplate");
            sql.append(".FIsInBalance = 1 and ");
            sql.append(filterSQL);
            selectSql.append(sql.toString());
            DbUtil.execute((Context)ctx, (String)selectSql.toString());
            this.insertTaskData(ctx, sql.toString());
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private Map buildCalendar(IRowSet set) throws SQLException {
        HashMap calendar = new HashMap();
        String storageId = null;
        Date date = null;
        int seq = 0;
        List<MonthPlanCalendarData> datas = null;
        while (set != null && set.next()) {
            storageId = set.getString("FStorageOrgUnitID");
            date = set.getDate("FWorkDate");
            seq = set.getInt("FWorkDateSeq");
            MonthPlanCalendarData data = new MonthPlanCalendarData(date, seq);
            if (calendar.get(storageId) != null) {
                datas = (List)calendar.get(storageId);
                datas.add(data);
                continue;
            }
            datas = new ArrayList();
            datas.add(data);
            calendar.put(storageId, datas);
        }
        return calendar;
    }

    private void insertTaskData(Context ctx, String sql) throws BOSException {
        StringBuffer selectSql = new StringBuffer(8);
        selectSql.append("insert into ");
        selectSql.append(tableTask);
        selectSql.append(" (FTaskTemplateID,FProjectID,FTaskID,FPlanEndTime,FQty) select ");
        selectSql.append("Task");
        selectSql.append(".FTaskTemplateID, ");
        selectSql.append("Task");
        selectSql.append(".FProjectID, ");
        selectSql.append("Task");
        selectSql.append(".FID, ");
        selectSql.append("Task");
        selectSql.append(".FPlanEndTime, ");
        selectSql.append("Task");
        selectSql.append(".FQty ");
        selectSql.append(sql);
        DbUtil.execute((Context)ctx, (String)selectSql.toString());
    }

    @Override
    protected Map _getOnePageData(Context ctx, Map tables, int from, int size, Peroid[] peroids) throws BOSException {
        tableProject = (String)tables.get("TempProject");
        tableTask = (String)tables.get("TempTask");
        HashMap<String, IRowSet> result = new HashMap<String, IRowSet>();
        StringBuffer sql = new StringBuffer(8);
        sql.append("select FStorageOrgUnitID,FPrecision,FTaskTemplateID,FTasktemplateName,FDayQty,FDayMaxQty,FPeriodMaxQty,FProjectID, ");
        sql.append("FProjectName,FProjectPriority,FMaterialName from ");
        sql.append(tableProject);
        sql.append(" where KSQL_SEQ >= ");
        sql.append(from);
        sql.append(" AND KSQL_SEQ <= ");
        sql.append(from + size - 1);
        sql.append(" order by FTasktemplateName");
        IRowSet rsProject = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("select T1.FStorageOrgUnitID FStorageOrgUnitID,T1.FPrecision FPrecision,");
        sql.append("T0.FTaskTemplateID FTaskTemplateID,");
        sql.append("T0.FProjectID FProjectID,T0.FTaskID FTaskID,T0.FPlanEndTime FPlanEndTime,T0.FQty FQty from ");
        sql.append(tableTask);
        sql.append(" T0 inner join ");
        sql.append(tableProject);
        sql.append(" T1 on T0.FProjectID = T1.FProjectID and T0.FTaskTemplateID = T1.FTaskTemplateID ");
        sql.append("where T1.KSQL_SEQ >= ");
        sql.append(from);
        sql.append(" AND T1.KSQL_SEQ <= ");
        sql.append(from + size - 1);
        sql.append(" order by T0.FTaskTemplateID,T0.FProjectID,T0.FPlanEndTime");
        IRowSet rsTask = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("select T2.FStorageOrgUnitID FStorageOrgUnitID,T2.FPrecision FPrecision,T0.FID FID,");
        sql.append("T0.FProjectID FProjectID,T0.FTaskTemplateID FTaskTemplateID,");
        sql.append("T1.FID FEntryID,T1.FAdjustQty FAdjustQty,T1.FYear FYear,T1.FPeroid FPeroid from ");
        sql.append("T_MM_MonthPlan T0 inner join ");
        sql.append("T_MM_MonthPlanEntry T1 on T0.FID = T1.FParentID inner join ");
        sql.append(tableProject);
        sql.append(" T2 on T0.FProjectID = T2.FProjectID and T0.FTaskTemplateID = T2.FTaskTemplateID ");
        sql.append("where T2.KSQL_SEQ >= ");
        sql.append(from);
        sql.append(" AND T2.KSQL_SEQ <= ");
        sql.append(from + size - 1);
        sql.append(" and (");
        for (int i = 0; i < peroids.length; ++i) {
            Peroid peroid = peroids[i];
            sql.append("( T1.FYear = ");
            sql.append(peroid.getYear());
            sql.append(" and T1.FPeroid =");
            sql.append(peroid.getPeriod());
            sql.append(")");
            if (i == peroids.length - 1) continue;
            sql.append(" OR ");
        }
        sql.append(") order by T0.FTaskTemplateID,T0.FProjectID ");
        IRowSet rsMonthPlan = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        IRowSet rsRowConut = null;
        if (from == 1) {
            sql.setLength(0);
            sql.append("select count(*) FRowCount from ");
            sql.append(tableProject);
            rsRowConut = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        }
        result.put("Task", rsProject);
        result.put("Project", rsTask);
        result.put("MonthPlan", rsMonthPlan);
        result.put("rowCount", rsRowConut);
        return result;
    }
}

