/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.IBatchExecute;
import com.kingdee.eas.dynbusiness.app.DynamicBusinessProcessHelper;
import com.kingdee.eas.dynbusiness.app.IBusinessProcessorBuilder;
import com.kingdee.eas.dynbusiness.app.processor.BillsExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.MMBaseException;
import com.kingdee.eas.mm.common.MMBaseStatusEnum;
import com.kingdee.eas.mm.common.app.CodingRulerSrvHelper;
import com.kingdee.eas.mm.common.app.CommonUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.project.ChangeTypeEnum;
import com.kingdee.eas.mm.project.FieldTypeEnum;
import com.kingdee.eas.mm.project.IProjectTask;
import com.kingdee.eas.mm.project.PMChangeCarCollection;
import com.kingdee.eas.mm.project.PMChangeCarInfo;
import com.kingdee.eas.mm.project.PMChangeCollection;
import com.kingdee.eas.mm.project.PMChangeEntryCollection;
import com.kingdee.eas.mm.project.PMChangeEntryInfo;
import com.kingdee.eas.mm.project.PMChangeException;
import com.kingdee.eas.mm.project.PMChangeFactory;
import com.kingdee.eas.mm.project.PMChangeInfo;
import com.kingdee.eas.mm.project.PMChangeOrgCollection;
import com.kingdee.eas.mm.project.PMChangeOrgInfo;
import com.kingdee.eas.mm.project.PMChangeWBSCollection;
import com.kingdee.eas.mm.project.PMChangeWBSInfo;
import com.kingdee.eas.mm.project.ProjectCarCollection;
import com.kingdee.eas.mm.project.ProjectCarInfo;
import com.kingdee.eas.mm.project.ProjectCollection;
import com.kingdee.eas.mm.project.ProjectDictDataInfo;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.mm.project.ProjectOrgCollection;
import com.kingdee.eas.mm.project.ProjectOrgInfo;
import com.kingdee.eas.mm.project.ProjectTaskCollection;
import com.kingdee.eas.mm.project.ProjectTaskFactory;
import com.kingdee.eas.mm.project.ProjectTaskInfo;
import com.kingdee.eas.mm.project.RowTypeEnum;
import com.kingdee.eas.mm.project.app.AbstractPMChangeControllerBean;
import com.kingdee.eas.mm.project.util.MMProjectCalendarFactory;
import com.kingdee.eas.mm.project.util.MMProjectFinalVariable;
import com.kingdee.eas.mm.project.util.ProjectChangeField;
import com.kingdee.eas.scm.common.app.bizprocess.processorbuilder.SCMBusinessProcessorBuilder4common;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PMChangeControllerBean
extends AbstractPMChangeControllerBean
implements IBatchExecute {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.project.app.PMChangeControllerBean");

    @Override
    protected Map _getProjectField(Context ctx, Map fileds) throws BOSException {
        this.getCentralPurstgOrg(ctx, fileds);
        this.getAdminOrgUnit(ctx, fileds);
        this.getProject(ctx, fileds);
        this.getPrinciple(ctx, fileds);
        return fileds;
    }

    private void getProject(Context ctx, Map fields) throws BOSException {
        String id = (String)fields.get("PROJECTPK");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("centralPurStgOrg.*"));
        sic.add(new SelectorItemInfo("carNumberRange.*"));
        sic.add(new SelectorItemInfo("carNumberRange.trackNumber.*"));
        sic.add(new SelectorItemInfo("carNumberRange.trackNumber.number"));
        sic.add(new SelectorItemInfo("projectOrg.*"));
        sic.add(new SelectorItemInfo("projectOrg.storageOrgUnit.*"));
        sic.add(new SelectorItemInfo("projectOrg.storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("projectOrg.storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("projectOrg.storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.name"));
        view.setSelector(sic);
        view.setFilter(filter);
        ProjectCollection projects = ProjectFactory.getLocalInstance(ctx).getProjectCollection(view);
        if (projects != null && projects.size() > 0) {
            ProjectInfo project = projects.get(0);
            fields.put("PROJECT", project);
        }
    }

    private void getPrinciple(Context ctx, Map fileds) throws BOSException {
        if (fileds.get((Object)FieldTypeEnum.PRINCIPLE) != null) {
            ProjectChangeField field = (ProjectChangeField)fileds.get((Object)FieldTypeEnum.PRINCIPLE);
            HashSet<String> ids = new HashSet<String>();
            if (field.getOldStrValue() != null) {
                ids.add(field.getOldStrValue());
            }
            if (field.getNewStrValue() != null) {
                ids.add(field.getNewStrValue());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            view.setFilter(filter);
            PersonCollection colls = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(view);
            if (colls != null && colls.size() > 0) {
                for (int i = 0; i < colls.size(); ++i) {
                    if (field.getOldStrValue() != null && field.getOldStrValue().equalsIgnoreCase(colls.get(i).getId().toString())) {
                        field.setOldValue(colls.get(i));
                    }
                    if (field.getNewStrValue() == null || !field.getNewStrValue().equalsIgnoreCase(colls.get(i).getId().toString())) continue;
                    field.setNewValue(colls.get(i));
                }
            }
        }
    }

    private void getAdminOrgUnit(Context ctx, Map fileds) throws BOSException {
        if (fileds.get((Object)FieldTypeEnum.ADMINORGUNIT) != null) {
            ProjectChangeField field = (ProjectChangeField)fileds.get((Object)FieldTypeEnum.ADMINORGUNIT);
            HashSet<String> ids = new HashSet<String>();
            if (field.getOldStrValue() != null) {
                ids.add(field.getOldStrValue());
            }
            if (field.getNewStrValue() != null) {
                ids.add(field.getNewStrValue());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            view.setFilter(filter);
            AdminOrgUnitCollection colls = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(view);
            if (colls != null && colls.size() > 0) {
                for (int i = 0; i < colls.size(); ++i) {
                    if (field.getOldStrValue() != null && field.getOldStrValue().equalsIgnoreCase(colls.get(i).getId().toString())) {
                        field.setOldValue(colls.get(i));
                    }
                    if (field.getNewStrValue() == null || !field.getNewStrValue().equalsIgnoreCase(colls.get(i).getId().toString())) continue;
                    field.setNewValue(colls.get(i));
                }
            }
        }
    }

    private void getCentralPurstgOrg(Context ctx, Map fileds) throws BOSException {
        if (fileds.get((Object)FieldTypeEnum.CENTRALPURSTGORG) != null) {
            ProjectChangeField field = (ProjectChangeField)fileds.get((Object)FieldTypeEnum.CENTRALPURSTGORG);
            HashSet<String> ids = new HashSet<String>();
            if (field.getOldStrValue() != null) {
                ids.add(field.getOldStrValue());
            }
            if (field.getNewStrValue() != null) {
                ids.add(field.getNewStrValue());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            view.setFilter(filter);
            StorageOrgUnitCollection colls = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitCollection(view);
            if (colls != null && colls.size() > 0) {
                for (int i = 0; i < colls.size(); ++i) {
                    if (field.getOldStrValue() != null && field.getOldStrValue().equalsIgnoreCase(colls.get(i).getId().toString())) {
                        field.setOldValue(colls.get(i));
                    }
                    if (field.getNewStrValue() == null || !field.getNewStrValue().equalsIgnoreCase(colls.get(i).getId().toString())) continue;
                    field.setNewValue(colls.get(i));
                }
            }
        }
    }

    private void checkNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PMChangeInfo prjInfo = (PMChangeInfo)model;
        CodingRulerSrvHelper codeHelper = new CodingRulerSrvHelper();
        codeHelper.setBizOrgPropertyName("CU");
        codeHelper.checkNumber(ctx, this.getBizInterface(ctx), model, (OrgUnitInfo)prjInfo.getCU());
    }

    protected ICoreBase getBizInterface(Context ctx) throws BOSException, EASBizException {
        return PMChangeFactory.getLocalInstance(ctx);
    }

    public void batchCheck(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        if (batchAction.equals((Object)BatchActionEnum.SUBMIT)) {
            this.submitCheck(ctx, batchResults);
        } else if (batchAction.equals((Object)BatchActionEnum.DELETE)) {
            this.deleteCheck(ctx, batchResults);
        }
    }

    public void batchExecute(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        if (batchAction.equals((Object)BatchActionEnum.DELETE)) {
            String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
            String billSql = this.getRecycleNumberSQL(idStr);
            CommonUtils.batchRecycleNumber((Context)ctx, (String)billSql, (IObjectValue)this.getBillInstance());
            this.delete(ctx, batchResults);
        }
        if (batchAction.equals((Object)BatchActionEnum.AUDIT)) {
            this.writebackProjectTask(ctx, batchResults);
        }
    }

    private PMChangeCollection getChangeCollection(Context ctx, Set ids) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        viewInfo.setSelector(this.getAuditSelectors());
        PMChangeCollection billCol = this.getPMChangeCollection(ctx, viewInfo);
        return billCol;
    }

    private void writebackProjectTask(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        Connection con = null;
        PreparedStatement batchProject = null;
        PreparedStatement batchCar = null;
        PreparedStatement batchOrg = null;
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        String locStr = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sqlProject = new StringBuffer();
        StringBuffer sqlTask = new StringBuffer();
        StringBuffer sqlOrg = new StringBuffer();
        StringBuffer sqlCar = new StringBuffer();
        sqlProject.append("update t_mm_project set ");
        sqlProject.append("FTotalTime=?,FPlanBeginTime=?,FPlanEndTime=?,FQty=?,FAdminOrgUnitID=?,FPersonID=?,");
        sqlProject.append("FIsChanging=?,FDescription_");
        sqlProject.append(locStr);
        sqlProject.append(" = ?");
        sqlProject.append(",FTotalCost=decimal(FUnitCost*?,17,4)");
        sqlProject.append(" where FID = ?");
        sqlOrg.append("insert into t_mm_projectOrg (FStorageOrgUnitID,FProjectID,FSeq,FID)");
        sqlOrg.append(" values (?,?,?,?)");
        sqlCar.append("insert into t_mm_projectCar (FTrackNumberID,FProjectID,FSeq,FID)");
        sqlCar.append(" values (?,?,?,?)");
        sqlTask.append("update t_mm_projecttask as t0 set (");
        sqlTask.append(" FCarNumberID,FQty,FBaseQty,FTotalTime,FInterval,FPlanBeginTime,FPlanEndTime,");
        sqlTask.append(" FPreTaskID,FIsMileStone,FFeedbackModeID,FIteratorTypeID,FComment,FIsChanging");
        sqlTask.append(" ) = (select t1.FNewCarNumID,t1.FNewQty,");
        sqlTask.append(" round(decimal(t1.FNewQty * t3.FBaseConvsRate,21,8),t4.FQtyPrecision),");
        sqlTask.append(" t1.FNewTotalTime,t1.FNewInterval,t1.FNewPlanBeginTime,");
        sqlTask.append(" t1.FNewPlanEndTime,t1.FNewPreTaskID,t1.FNewIsMileStone,t1.FNewFeedbackModeID,t1.FNewIteratorTypeID,t1.FNewRemark,0 ");
        sqlTask.append(" from t_mm_pmchangewbs t1, t_mm_pmchange t2, t_bd_multimeasureunit t3, t_bd_multimeasureunit t4 ");
        sqlTask.append(" where t2.FID = t1.FParentID ");
        sqlTask.append(" and t0.FMaterialId=t3.FmaterialId and t0.FUnitID=t3.FmeasureUnitId  ");
        sqlTask.append(" and t0.FMaterialId=t4.FmaterialId and t0.FBaseUnitId=t4.FmeasureUnitId ");
        sqlTask.append(" and t0.FID = t1.FTaskID and t2.FID in (");
        sqlTask.append(idStr);
        sqlTask.append("))");
        con = this.getConnection(ctx);
        try {
            batchProject = con.prepareStatement(sqlProject.toString());
            batchCar = con.prepareStatement(sqlCar.toString());
            batchOrg = con.prepareStatement(sqlOrg.toString());
            PMChangeCollection col = this.getChangeCollection(ctx, batchResults.getToDoIdsSet());
            String datePattern = "yyyy-MM-dd HH:mm:ss";
            for (int i = 0; i < col.size(); ++i) {
                PMChangeInfo pmchangeInfo = (PMChangeInfo)col.getObject(i);
                ProjectInfo tempProject = new ProjectInfo();
                tempProject.setId(pmchangeInfo.getProject().getId());
                SimpleDateFormat dateFormat = new SimpleDateFormat(datePattern);
                PMChangeEntryCollection entries = pmchangeInfo.getEntries();
                for (int j = 0; j < entries.size(); ++j) {
                    PMChangeEntryInfo entry = entries.get(j);
                    if (entry.getColumnName().equals((Object)FieldTypeEnum.QTY) && entry.getNewValue() != null) {
                        tempProject.setQty(new BigDecimal(entry.getNewValue()));
                    }
                    if (entry.getColumnName().equals((Object)FieldTypeEnum.TOTALTIME) && entry.getNewValue() != null) {
                        tempProject.setTotalTime(new BigDecimal(entry.getNewValue()));
                    }
                    try {
                        if (entry.getColumnName().equals((Object)FieldTypeEnum.PLANBEGINTIME) && entry.getNewValue() != null) {
                            tempProject.setPlanBeginTime(new Timestamp(dateFormat.parse(entry.getNewValue()).getTime()));
                        }
                        if (entry.getColumnName().equals((Object)FieldTypeEnum.PLANENDTIME) && entry.getNewValue() != null) {
                            tempProject.setPlanEndTime(new Timestamp(dateFormat.parse(entry.getNewValue()).getTime()));
                        }
                    }
                    catch (ParseException e) {
                        throw new BOSException((Throwable)e);
                    }
                    if (entry.getColumnName().equals((Object)FieldTypeEnum.ADMINORGUNIT) && entry.getNewValue() != null) {
                        AdminOrgUnitInfo admin = new AdminOrgUnitInfo();
                        admin.setId(BOSUuid.read((String)entry.getNewValue()));
                        tempProject.setAdminOrgUnit(admin);
                    }
                    if (entry.getColumnName().equals((Object)FieldTypeEnum.PRINCIPLE) && entry.getNewValue() != null) {
                        PersonInfo person = new PersonInfo();
                        person.setId(BOSUuid.read((String)entry.getNewValue()));
                        tempProject.setPerson(person);
                    }
                    if (!entry.getColumnName().equals((Object)FieldTypeEnum.REMARK)) continue;
                    tempProject.setDescription(entry.getNewValue());
                }
                batchProject.setBigDecimal(1, tempProject.getTotalTime());
                batchProject.setTimestamp(2, tempProject.getPlanBeginTime());
                batchProject.setTimestamp(3, tempProject.getPlanEndTime());
                if (tempProject.getQty() == null) {
                    batchProject.setBigDecimal(4, MMProjectFinalVariable.ZERO);
                } else {
                    batchProject.setBigDecimal(4, tempProject.getQty());
                }
                if (tempProject.getAdminOrgUnit() != null && tempProject.getAdminOrgUnit().getId() != null) {
                    batchProject.setString(5, tempProject.getAdminOrgUnit().getId().toString());
                } else {
                    batchProject.setString(5, null);
                }
                if (tempProject.getPerson() != null && tempProject.getPerson().getId() != null) {
                    batchProject.setString(6, tempProject.getPerson().getId().toString());
                } else {
                    batchProject.setString(6, null);
                }
                batchProject.setInt(7, 0);
                batchProject.setString(8, tempProject.getDescription());
                batchProject.setBigDecimal(9, tempProject.getQty());
                batchProject.setString(10, tempProject.getId().toString());
                batchProject.addBatch();
                PMChangeCarCollection cars = pmchangeInfo.getPmChangeCar();
                int seq = 0;
                for (int j = 0; j < cars.size(); ++j) {
                    PMChangeCarInfo car = cars.get(j);
                    ProjectCarCollection projectCars = pmchangeInfo.getProject().getCarNumberRange();
                    if (seq == 0) {
                        seq = projectCars.size();
                    }
                    boolean isOrigin = false;
                    if (car.getOldCarNum() != null) {
                        isOrigin = true;
                    }
                    if (isOrigin) continue;
                    batchCar.setString(1, car.getNewCarNum().getId().toString());
                    batchCar.setString(2, pmchangeInfo.getProject().getId().toString());
                    batchCar.setInt(3, seq + 1);
                    batchCar.setString(4, BOSUuid.create((String)"EC5B3FE6").toString());
                    batchCar.addBatch();
                }
                PMChangeOrgCollection orgs = pmchangeInfo.getPmChangeOrg();
                seq = 0;
                for (int j = 0; j < orgs.size(); ++j) {
                    PMChangeOrgInfo org = orgs.get(j);
                    ProjectOrgCollection projectOrgs = pmchangeInfo.getProject().getProjectOrg();
                    if (seq == 0) {
                        seq = projectOrgs.size();
                    }
                    boolean isOrigin = false;
                    if (org.getOldOrgUnit() != null) {
                        isOrigin = true;
                    }
                    if (isOrigin) continue;
                    batchOrg.setString(1, org.getNewOrgUnit().getId().toString());
                    batchOrg.setString(2, pmchangeInfo.getProject().getId().toString());
                    batchOrg.setInt(3, seq + 1);
                    batchOrg.setString(4, BOSUuid.create((String)"EC5B6EF6").toString());
                    batchOrg.addBatch();
                }
            }
            batchProject.executeBatch();
            batchCar.executeBatch();
            batchOrg.executeBatch();
            DbUtil.execute((Context)ctx, (String)sqlTask.toString());
        }
        catch (SQLException e1) {
            try {
                throw new BOSException((Throwable)e1);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchProject);
                SQLUtils.cleanup(batchCar);
                SQLUtils.cleanup(batchOrg);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchProject);
        SQLUtils.cleanup((Statement)batchCar);
        SQLUtils.cleanup((Statement)batchOrg);
        SQLUtils.cleanup((Connection)con);
    }

    protected String getRecycleNumberSQL(String idStr) {
        return "select FID,FNumber,FControlUnitID forgid from T_MM_PMChange where FID in (" + idStr + ")";
    }

    protected IObjectValue getBillInstance() {
        return new PMChangeInfo();
    }

    protected void delete(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        String[] sqlUpdates = new String[2];
        StringBuffer updateProject = new StringBuffer("");
        updateProject.append("update t_mm_project set FIsChanging = 0 where FID in (");
        updateProject.append("select FProjectID from t_mm_pmchange where FID in (");
        updateProject.append(idStr);
        updateProject.append(") and FBaseStatus = 2)");
        StringBuffer updateTask = new StringBuffer("");
        updateTask.append("update t_mm_projecttask set FIsChanging = 0 where FID in(");
        updateTask.append(" select t2.FID from t_mm_pmchange t0 inner join t_mm_pmchangewbs t1 on t0.FID = t1.FParentID");
        updateTask.append(" inner join t_mm_projecttask t2 on t1.FTaskID = t2.FID where t0.FBaseStatus = 2 and t0.FID in (");
        updateTask.append(idStr);
        updateTask.append(") and t0.FBaseStatus = 2)");
        sqlUpdates[0] = updateProject.toString();
        sqlUpdates[1] = updateTask.toString();
        SQLUtil.batchExecuteSql((Context)ctx, (String[])sqlUpdates);
        String[] sqls = new String[]{"DELETE FROM T_MM_PMChange WHERE FID in (" + idStr + ")", "DELETE FROM T_MM_PMChangeOrg WHERE FParentID in (" + idStr + ")", "DELETE FROM T_MM_PMChangeEntry WHERE FParentID in (" + idStr + ")", "DELETE FROM T_MM_PMChangeWBS WHERE FParentID in (" + idStr + ")", "DELETE FROM T_MM_PMChangeCar WHERE FParentID in (" + idStr + ")"};
        SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
    }

    protected BatchActionResults batchExecute(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchActionEnum) throws EASBizException, BOSException {
        BillsExecuteContext executeContext = new BillsExecuteContext(ctx, this.getBOSType(), batchActionEnum, (BizController)this, (Object[])entries);
        executeContext.setXmlFileName(this.getXmlFileName(batchActionEnum));
        executeContext.setBillTypeID(this.getBillTypeId());
        SCMBusinessProcessorBuilder4common builder = new SCMBusinessProcessorBuilder4common((ExecuteContext)executeContext);
        return DynamicBusinessProcessHelper.batchExecute((Context)ctx, (BizController)this, (IBusinessProcessorBuilder)builder, (BatchExecuteParamsEntry[])entries, (String)this.getXmlFileName(batchActionEnum));
    }

    protected String getBillTypeId() {
        return "g6SAqxHIC0HgQKjAHD1YK0Y+1VI=";
    }

    protected String getXmlFileName(BatchActionEnum batchActionEnum) {
        return "com.kingdee.eas.mm.project.app.xml.pmchange.xml";
    }

    protected BatchExecuteParamsEntry[] buildBatchParam(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class});
        entry.add((Object)pk);
        return new BatchExecuteParamsEntry[]{entry};
    }

    public BatchActionResults batchSubmit(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchSubmitRelations(ctx, entries);
    }

    private void deleteCheck(Context ctx, BatchActionResults batchResults) throws EASBizException, BOSException {
        try {
            String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
            String sql = "select FID,FNumber from t_mm_pmchange where FID in(" + idStr + ")";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            String[] ids = new String[rs.size()];
            int idIndex = 0;
            while (rs.next()) {
                ids[idIndex] = rs.getString("FID");
                ++idIndex;
            }
            for (int i = 0; i < batchResults.getToDoIdsArray().length; ++i) {
                String originId = batchResults.getToDoIdsArray()[i];
                boolean isExist = false;
                for (int j = 0; j < ids.length; ++j) {
                    if (isExist || !ids[j].equalsIgnoreCase(originId)) continue;
                    isExist = true;
                    break;
                }
                if (isExist) continue;
                batchResults.addError(originId, (Exception)new MMBaseException(MMBaseException.RECORD_NOT_EXIST));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void submitCheck(Context ctx, BatchActionResults batchResults) throws EASBizException, BOSException {
        try {
            String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
            String sql = "select FID,FNumber from t_mm_pmchange where FBaseStatus = 4 and FID in(" + idStr + ")";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                batchResults.addError(rs.getString("FID"), (Exception)((Object)new PMChangeException(PMChangeException.PMCHANGE_AUDIT, new String[]{rs.getString("FNumber")})));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        IObjectCollection col = batchResults.getObjCollection();
        for (int i = 0; i < col.size(); ++i) {
            int j;
            PMChangeInfo pmchangeInfo = (PMChangeInfo)col.getObject(i);
            boolean isChange = false;
            if (pmchangeInfo.getChangeType().equals((Object)ChangeTypeEnum.PROJECTCHANGE)) {
                PMChangeEntryCollection entries = pmchangeInfo.getEntries();
                for (j = 0; j < entries.size(); ++j) {
                    BigDecimal newValue;
                    PMChangeEntryInfo entry = entries.get(j);
                    if (entry.getOldValue() == null && entry.getNewValue() != null) {
                        isChange = true;
                        break;
                    }
                    if (entry.getOldValue() == null) continue;
                    if (entry.getNewValue() == null) {
                        isChange = true;
                        break;
                    }
                    if (entry.getColumnName().equals((Object)FieldTypeEnum.PLANBEGINTIME) || entry.getColumnName().equals((Object)FieldTypeEnum.PLANENDTIME)) {
                        entry.setOldValue(this.dateToString(this.toCalendar(this.stringToDate(entry.getOldValue())).getTime()));
                        entry.setNewValue(this.dateToString(this.toCalendar(this.stringToDate(entry.getNewValue())).getTime()));
                    }
                    if (!entry.getColumnName().equals((Object)FieldTypeEnum.QTY)) {
                        if (entry.getOldValue().equalsIgnoreCase(entry.getNewValue())) continue;
                        isChange = true;
                        break;
                    }
                    BigDecimal oldValue = new BigDecimal(entry.getOldValue());
                    if (oldValue.subtract(newValue = new BigDecimal(entry.getNewValue())).floatValue() == 0.0f) continue;
                    isChange = true;
                    break;
                }
                if (!isChange) {
                    PMChangeCarCollection cars = pmchangeInfo.getPmChangeCar();
                    StringBuffer sqlCar = new StringBuffer("");
                    sqlCar.append("select t1.FID from t_mm_projectCar t0 inner join t_mm_TrackNumber t1 on ");
                    sqlCar.append(" t0.FTrackNumberID = t1.FID where t0.FProjectID = '");
                    sqlCar.append(pmchangeInfo.getProject().getId().toString());
                    sqlCar.append("'");
                    IRowSet rsCar = DbUtil.executeQuery((Context)ctx, (String)sqlCar.toString());
                    for (int j2 = 0; j2 < cars.size(); ++j2) {
                        PMChangeCarInfo car = cars.get(j2);
                        if (car.getNewCarNum() == null) continue;
                        try {
                            boolean isHasCar = false;
                            while (rsCar != null && rsCar.next()) {
                                if (!rsCar.getString("FID").equalsIgnoreCase(car.getNewCarNum().getId().toString())) {
                                    isHasCar = false;
                                    continue;
                                }
                                isHasCar = true;
                                rsCar.beforeFirst();
                                break;
                            }
                            if (isHasCar) continue;
                            isChange = true;
                            break;
                        }
                        catch (SQLException e) {
                            throw new BOSException((Throwable)e);
                        }
                    }
                }
                if (!isChange) {
                    PMChangeOrgCollection orgs = pmchangeInfo.getPmChangeOrg();
                    StringBuffer sqlOrg = new StringBuffer("");
                    sqlOrg.append("select t1.FID from t_mm_projectOrg t0 inner join T_ORG_Storage t1 on ");
                    sqlOrg.append(" t0.FStorageOrgUnitID = t1.FID where t0.FProjectID = '");
                    sqlOrg.append(pmchangeInfo.getProject().getId().toString());
                    sqlOrg.append("'");
                    IRowSet rsOrg = DbUtil.executeQuery((Context)ctx, (String)sqlOrg.toString());
                    for (int j3 = 0; j3 < orgs.size(); ++j3) {
                        PMChangeOrgInfo org = orgs.get(j3);
                        if (org.getNewOrgUnit() == null) continue;
                        try {
                            boolean isHasOrg = false;
                            while (rsOrg != null && rsOrg.next()) {
                                if (!rsOrg.getString("FID").equalsIgnoreCase(org.getNewOrgUnit().getId().toString())) {
                                    isHasOrg = false;
                                    continue;
                                }
                                isHasOrg = true;
                                break;
                            }
                            if (isHasOrg) continue;
                            isChange = true;
                            break;
                        }
                        catch (SQLException e) {
                            throw new BOSException((Throwable)e);
                        }
                    }
                }
            } else if (!isChange) {
                PMChangeWBSCollection wbs = pmchangeInfo.getPmChangeWBS();
                if (wbs.size() <= 0) {
                    isChange = false;
                }
                for (j = 0; j < wbs.size() && !(isChange = this.isTaskChanged(wbs.get(j))); ++j) {
                }
            }
            if (!isChange) {
                throw new PMChangeException(PMChangeException.NOT_ANY_CHANGE, new String[]{pmchangeInfo.getNumber()});
            }
            this.checkInChanging(ctx, batchResults, pmchangeInfo);
        }
    }

    private boolean isTaskChanged(PMChangeWBSInfo info) {
        boolean isTaskChanged = false;
        if (info.getTask() == null) {
            return false;
        }
        if (!isTaskChanged && this.isObjectChanged(info.getOldCarNum(), info.getNewCarNum())) {
            isTaskChanged = true;
        }
        if (!isTaskChanged && this.isObjectChanged(info.getOldPreTask(), info.getNewPreTask())) {
            isTaskChanged = true;
        }
        if (!isTaskChanged && this.isObjectChanged(info.getOldFeedBackMode(), info.getNewFeedBackMode())) {
            isTaskChanged = true;
        }
        if (!isTaskChanged && this.isObjectChanged(info.getOldIteratorType(), info.getNewIteratorType())) {
            isTaskChanged = true;
        }
        if (!isTaskChanged && this.isNormalsChanged(info.getOldQty(), info.getNewQty())) {
            isTaskChanged = true;
        }
        if (!isTaskChanged && this.isNormalsChanged(info.getOldTotalTime(), info.getNewTotalTime())) {
            isTaskChanged = true;
        }
        if (!isTaskChanged && this.isNormalsChanged(info.getOldInterval(), info.getNewInterval())) {
            isTaskChanged = true;
        }
        if (!isTaskChanged && this.isNormalsChanged(info.getOldPlanBeginTime(), info.getNewPlanBeginTime())) {
            isTaskChanged = true;
        }
        if (!isTaskChanged && this.isNormalsChanged(info.getOldPlanEndTime(), info.getNewPlanEndTime())) {
            isTaskChanged = true;
        }
        if (!isTaskChanged && this.isNormalsChanged(info.getOldReMark(), info.getNewReMark())) {
            isTaskChanged = true;
        }
        if (!isTaskChanged) {
            if (info.isOldIsMileStone()) {
                if (!info.isNewIsMileStone()) {
                    isTaskChanged = true;
                }
            } else if (info.isNewIsMileStone()) {
                isTaskChanged = true;
            }
        }
        return isTaskChanged;
    }

    private boolean isObjectChanged(Object oldValue, Object newValue) {
        boolean isChanged = false;
        if (oldValue == null && newValue != null) {
            isChanged = true;
        }
        if (oldValue != null) {
            if (newValue == null) {
                isChanged = true;
            } else if (!(oldValue = ((CoreBaseInfo)oldValue).getId()).equals(newValue = ((CoreBaseInfo)newValue).getId())) {
                isChanged = true;
            }
        }
        return isChanged;
    }

    private boolean isNormalsChanged(Object oldValue, Object newValue) {
        boolean isChanged = false;
        if (oldValue == null && newValue != null) {
            isChanged = true;
        }
        if (oldValue != null) {
            if (newValue == null) {
                isChanged = true;
            } else if (oldValue instanceof BigDecimal) {
                BigDecimal oldQty = (BigDecimal)oldValue;
                BigDecimal newQty = (BigDecimal)newValue;
                if (oldQty.subtract(newQty).floatValue() != 0.0f) {
                    isChanged = true;
                }
            } else if (!oldValue.equals(newValue)) {
                isChanged = true;
            }
        }
        return isChanged;
    }

    private boolean isZero(String value) {
        BigDecimal newValue = new BigDecimal(value);
        return newValue.intValue() == 0;
    }

    private String dateToString(Date date) {
        if (date == null) {
            return null;
        }
        String datePattern = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat dateFormat = new SimpleDateFormat(datePattern);
        return dateFormat.format(date);
    }

    private Date stringToDate(String value) {
        if (value == null) {
            return null;
        }
        String datePattern = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat dateFormat = new SimpleDateFormat(datePattern);
        Date date = null;
        try {
            if (value != null) {
                date = dateFormat.parse(value);
            }
        }
        catch (ParseException e) {
            new BOSException((Throwable)e);
        }
        return date;
    }

    private void checkInChanging(Context ctx, BatchActionResults batchResults, PMChangeInfo pmchangeInfo) throws EASBizException, BOSException {
        StringBuffer numbers;
        String id = null;
        id = pmchangeInfo.getId() != null ? pmchangeInfo.getId().toString() : "NEWID";
        ProjectInfo projectDate = new ProjectInfo();
        projectDate.setName(pmchangeInfo.getProject().getName());
        projectDate.setNumber(pmchangeInfo.getProject().getNumber());
        PMChangeWBSCollection wbsCol = pmchangeInfo.getPmChangeWBS();
        PMChangeEntryCollection entries = pmchangeInfo.getEntries();
        StringBuffer nullField = new StringBuffer("");
        nullField.setLength(0);
        for (int i = 0; i < entries.size(); ++i) {
            PMChangeEntryInfo entry = entries.get(i);
            if (entry.getColumnName().equals((Object)FieldTypeEnum.TOTALTIME)) {
                if (entry.getNewValue() == null || entry.getNewValue() != null && this.isZero(entry.getNewValue())) {
                    nullField.append("[");
                    nullField.append(this.getResource(ctx, "TOTAL_TIME"));
                    nullField.append("]");
                } else {
                    projectDate.setTotalTime(new BigDecimal(entry.getNewValue()));
                }
            }
            if (entry.getColumnName().equals((Object)FieldTypeEnum.PLANBEGINTIME)) {
                if (entry.getNewValue() == null) {
                    nullField.append("[");
                    nullField.append(this.getResource(ctx, "PLAN_BEGINTIME"));
                    nullField.append("]");
                } else {
                    projectDate.setPlanBeginTime(new Timestamp(this.stringToDate(entry.getNewValue()).getTime()));
                }
            }
            if (entry.getColumnName().equals((Object)FieldTypeEnum.PLANENDTIME)) {
                if (entry.getNewValue() == null) {
                    nullField.append("[");
                    nullField.append(this.getResource(ctx, "PLAN_ENDTIME"));
                    nullField.append("]");
                } else {
                    projectDate.setPlanEndTime(new Timestamp(this.stringToDate(entry.getNewValue()).getTime()));
                }
            }
            if (entry.getColumnName().equals((Object)FieldTypeEnum.FIRSTBENGINTIME) && this.stringToDate(entry.getNewValue()) != null) {
                projectDate.setEaristBeginTime(new Timestamp(this.stringToDate(entry.getNewValue()).getTime()));
            }
            if (entry.getColumnName().equals((Object)FieldTypeEnum.FIRSTENDTIME) && this.stringToDate(entry.getNewValue()) != null) {
                projectDate.setEaristEndTime(new Timestamp(this.stringToDate(entry.getNewValue()).getTime()));
            }
            if (entry.getColumnName().equals((Object)FieldTypeEnum.LASTBEGINTIME) && this.stringToDate(entry.getNewValue()) != null) {
                projectDate.setLastBeginTime(new Timestamp(this.stringToDate(entry.getNewValue()).getTime()));
            }
            if (!entry.getColumnName().equals((Object)FieldTypeEnum.LASTENDTIME) || this.stringToDate(entry.getNewValue()) == null) continue;
            projectDate.setLastEndTime(new Timestamp(this.stringToDate(entry.getNewValue()).getTime()));
        }
        if (nullField.length() > 0) {
            batchResults.addError(id, (Exception)((Object)new PMChangeException(PMChangeException.PROJECT_FIELD_CANT_NULL, new String[]{pmchangeInfo.getProject().getNumber(), nullField.toString()})));
            return;
        }
        if (projectDate.getPlanBeginTime().compareTo(projectDate.getPlanEndTime()) > 0) {
            batchResults.addError(id, (Exception)((Object)new PMChangeException(PMChangeException.PLAN_BEGIN_AFTER_END)));
            return;
        }
        if (projectDate.getEaristBeginTime() != null && projectDate.getPlanBeginTime().compareTo(projectDate.getEaristBeginTime()) < 0) {
            batchResults.addError(id, (Exception)((Object)new PMChangeException(PMChangeException.PLANBEGIN_BEFORE_FIRSTBEGIN)));
            return;
        }
        if (projectDate.getLastBeginTime() != null && projectDate.getPlanBeginTime().compareTo(projectDate.getLastBeginTime()) > 0) {
            batchResults.addError(id, (Exception)((Object)new PMChangeException(PMChangeException.PLANBEGINI_AFTER_LASTBEGIN)));
            return;
        }
        if (projectDate.getEaristEndTime() != null && projectDate.getPlanEndTime().compareTo(projectDate.getEaristEndTime()) < 0) {
            batchResults.addError(id, (Exception)((Object)new PMChangeException(PMChangeException.PLANEND_BEFORE_FIRSTEND)));
            return;
        }
        if (projectDate.getLastEndTime() != null && projectDate.getPlanEndTime().compareTo(projectDate.getLastEndTime()) > 0) {
            batchResults.addError(id, (Exception)((Object)new PMChangeException(PMChangeException.PLAN_BEGIN_AFTER_END)));
            return;
        }
        StringBuffer sqlProject = new StringBuffer("");
        sqlProject.append("select t0.FNumber FNumber from t_mm_project t0 inner join t_mm_pmchange t1 ");
        sqlProject.append("on t0.FID = t1.FProjectID where t0.FIsChanging = 1 and t0.FID ='");
        sqlProject.append(pmchangeInfo.getProject().getId().toString());
        sqlProject.append("' and t1.FNumber != '");
        sqlProject.append(pmchangeInfo.getNumber());
        sqlProject.append("' and t1.FBaseStatus not in (1,4)");
        IRowSet setProject = DbUtil.executeQuery((Context)ctx, (String)sqlProject.toString());
        try {
            if (setProject != null && setProject.next()) {
                batchResults.addError(id, (Exception)((Object)new PMChangeException(PMChangeException.PROJECT_INCHANGING, new String[]{setProject.getString("FNumber")})));
                return;
            }
        }
        catch (SQLException e) {
            new BOSException((Throwable)e);
        }
        StringBuffer taskIds = new StringBuffer("");
        for (int i = 0; i < wbsCol.size(); ++i) {
            taskIds.append("'");
            taskIds.append(wbsCol.get(i).getTask().getId().toString());
            taskIds.append("'");
            taskIds.append(",");
        }
        taskIds.append("'null'");
        StringBuffer sql = new StringBuffer("");
        sql.append("select distinct t0.FNumber FNumber from t_mm_projecttask t0 inner join t_mm_pmchangewbs t1 on");
        sql.append(" t0.FID = t1.FTaskID inner join t_mm_pmchange t2 on t1.FparentID = t2.FID ");
        sql.append(" where t0.FIsChanging = 1 and t2.FNumber != '");
        sql.append(pmchangeInfo.getNumber());
        sql.append("' and t0.FID in (");
        sql.append(taskIds);
        sql.append(") and t2.FBaseStatus not in (1,4)");
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            numbers = new StringBuffer("");
            numbers.setLength(0);
            while (set != null && set.next()) {
                numbers.append("[");
                numbers.append(set.getString("FNumber"));
                numbers.append("]");
            }
            if (numbers.length() > 0) {
                batchResults.addError(id, (Exception)((Object)new PMChangeException(PMChangeException.PROJECT_TASK_INCHANGING, new String[]{pmchangeInfo.getProject().getNumber(), numbers.toString()})));
                return;
            }
        }
        catch (SQLException e) {
            new BOSException((Throwable)e);
        }
        if (pmchangeInfo.getChangeType().equals((Object)ChangeTypeEnum.WBSCHANGE)) {
            numbers = new StringBuffer("");
            numbers.setLength(0);
            for (int i = 0; i < wbsCol.size(); ++i) {
                PMChangeWBSInfo wbsInfo = wbsCol.get(i);
                if (RowTypeEnum.ASSOSIATEROW.equals((Object)wbsInfo.getRowType()) || wbsInfo.isIsProcessed()) continue;
                numbers.append("[");
                numbers.append(wbsInfo.getTask().getNumber());
                numbers.append("]");
            }
            if (numbers.length() > 0) {
                batchResults.addError(id, (Exception)((Object)new PMChangeException(PMChangeException.TASK_NOT_GETASSOCIATE, new String[]{numbers.toString()})));
                return;
            }
        } else if (!pmchangeInfo.isIsProcessed()) {
            batchResults.addError(id, (Exception)((Object)new PMChangeException(PMChangeException.PROJECT_NOT_GETTASK, new String[]{pmchangeInfo.getProject().getNumber()})));
            return;
        }
        this.pmChangeWBSCheck(ctx, batchResults, id, wbsCol, projectDate);
    }

    private void pmChangeWBSCheck(Context ctx, BatchActionResults batchResults, String id, PMChangeWBSCollection wbsCols, ProjectInfo projectDate) throws EASBizException, BOSException {
        for (int i = 0; i < wbsCols.size(); ++i) {
            PMChangeWBSInfo wbsInfo = wbsCols.get(i);
            StringBuffer nullField = new StringBuffer("");
            nullField.setLength(0);
            if (wbsInfo.getNewTotalTime() == null || wbsInfo.getNewTotalTime().intValue() == 0) {
                nullField.append("[");
                nullField.append(this.getResource(ctx, "TOTAL_TIME"));
                nullField.append("]");
            }
            if (wbsInfo.getNewPlanBeginTime() == null) {
                nullField.append("[");
                nullField.append(this.getResource(ctx, "PLAN_BEGINTIME"));
                nullField.append("]");
            }
            if (wbsInfo.getNewPlanEndTime() == null) {
                nullField.append("[");
                nullField.append(this.getResource(ctx, "PLAN_ENDTIME"));
                nullField.append("]");
            }
            if (wbsInfo.getNewPreTask() != null) {
                if (wbsInfo.getNewIteratorType() == null) {
                    nullField.append("[");
                    nullField.append(this.getResource(ctx, "ITERATOER_TYPE"));
                    nullField.append("]");
                }
            } else if (wbsInfo.getNewIteratorType() != null) {
                nullField.append("[");
                nullField.append(this.getResource(ctx, "PRE_TASK"));
                nullField.append("]");
            }
            if (nullField.length() > 0) {
                batchResults.addError(id, (Exception)((Object)new PMChangeException(PMChangeException.TASK_FIELD_CANT_NULL, new String[]{wbsInfo.getTask().getNumber(), nullField.toString()})));
                return;
            }
            if (wbsInfo.getNewPlanBeginTime().compareTo(wbsInfo.getNewPlanEndTime()) > 0) {
                batchResults.addError(id, (Exception)((Object)new PMChangeException(PMChangeException.PLAN_BEGIN_AFTER_END)));
                return;
            }
            if (wbsInfo.getTask().getParent() != null) {
                PMChangeWBSInfo wbsEntryInfo = this.getTaskEntry(wbsInfo.getTask().getParent().getId(), wbsCols);
                if (wbsEntryInfo != null) {
                    if (wbsInfo.getNewPlanBeginTime().compareTo(wbsEntryInfo.getNewPlanBeginTime()) < 0) {
                        batchResults.addError(id, (Exception)((Object)new PMChangeException(PMChangeException.TASK_PLANBEGIN_BEFORE_PARENT, new String[]{wbsInfo.getTask().getNumber(), wbsEntryInfo.getTask().getNumber()})));
                        return;
                    }
                    if (wbsInfo.getNewPlanEndTime().compareTo(wbsEntryInfo.getNewPlanEndTime()) <= 0) continue;
                    batchResults.addError(id, (Exception)((Object)new PMChangeException(PMChangeException.TASK_PLANEND_AFTER_PARENT, new String[]{wbsInfo.getTask().getNumber(), wbsEntryInfo.getTask().getNumber()})));
                    return;
                }
                ProjectTaskInfo parentTask = new ProjectTaskInfo();
                StringBuffer sql = new StringBuffer("");
                sql.setLength(0);
                String locStr = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
                sql.append("select FID,FNumber,FName_").append(locStr);
                sql.append(" FName, FPlanBeginTime,FPlanEndTime,FEaristBeginTime,FEaristEndTime,FLastBeginTime,FLastEndTime ");
                sql.append(" from t_mm_projecttask where FID = '");
                sql.append(wbsInfo.getTask().getParent().getId().toString());
                sql.append("'");
                IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                try {
                    if (set != null && set.next()) {
                        parentTask.setId(BOSUuid.read((String)set.getString("FID")));
                        parentTask.setName(set.getString("FName"));
                        parentTask.setNumber(set.getString("FNumber"));
                        parentTask.setPlanBeginTime(set.getTimestamp("FPlanBeginTime"));
                        parentTask.setPlanEndTime(set.getTimestamp("FPlanEndTime"));
                        parentTask.setEaristBeginTime(set.getTimestamp("FEaristBeginTime"));
                        parentTask.setEaristEndTime(set.getTimestamp("FEaristEndTime"));
                        parentTask.setLastBeginTime(set.getTimestamp("FLastBeginTime"));
                        parentTask.setLastEndTime(set.getTimestamp("FLastEndTime"));
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                if (wbsInfo.getNewPlanBeginTime().compareTo(parentTask.getPlanBeginTime()) < 0) {
                    batchResults.addError(id, (Exception)((Object)new PMChangeException(PMChangeException.TASK_PLANEND_AFTER_PARENT, new String[]{wbsInfo.getTask().getNumber(), parentTask.getNumber()})));
                    return;
                }
                if (wbsInfo.getNewPlanEndTime().compareTo(parentTask.getPlanEndTime()) <= 0) continue;
                batchResults.addError(id, (Exception)((Object)new PMChangeException(PMChangeException.TASK_PLANEND_AFTER_PARENT, new String[]{wbsInfo.getTask().getNumber(), parentTask.getNumber()})));
                return;
            }
            if (wbsInfo.getNewPlanBeginTime().compareTo(projectDate.getPlanBeginTime()) < 0) {
                batchResults.addError(id, (Exception)((Object)new PMChangeException(PMChangeException.TASK_PLANBEGIN_BEFORE_PROJECT, new String[]{wbsInfo.getTask().getNumber(), projectDate.getNumber()})));
                return;
            }
            if (wbsInfo.getNewPlanEndTime().compareTo(projectDate.getPlanEndTime()) <= 0) continue;
            batchResults.addError(id, (Exception)((Object)new PMChangeException(PMChangeException.TASK_PLANEND_AFTER_PROJECT, new String[]{wbsInfo.getTask().getNumber(), projectDate.getNumber()})));
            return;
        }
    }

    private PMChangeWBSInfo getTaskEntry(BOSUuid taskId, PMChangeWBSCollection wbsCols) {
        PMChangeWBSInfo wbsInfo = null;
        for (int i = 0; i < wbsCols.size(); ++i) {
            PMChangeWBSInfo wbsIterator = wbsCols.get(i);
            if (!taskId.equals((Object)wbsIterator.getTask().getId())) continue;
            wbsInfo = wbsIterator;
        }
        return wbsInfo;
    }

    public BatchActionResults batchSubmitRelations(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, BatchActionEnum.SUBMIT);
    }

    public BatchActionResults batchSaveRelations(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, BatchActionEnum.SAVE);
    }

    @Override
    protected IObjectPK _submitInBatch(Context ctx, IObjectValue model, IObjectCollection relations) throws BOSException, EASBizException {
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        return iBTPManager.submitRelations((CoreBillBaseInfo)model, (BOTRelationCollection)relations);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchActionResults result = this.batchDelete(ctx, this.buildBatchParam(ctx, pk));
        result.throwExceptions();
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PMChangeInfo info = (PMChangeInfo)model;
        info.setBaseStatus(MMBaseStatusEnum.SUBMIT);
        this.checkNumber(ctx, model);
        this.removeCarOrOrg(info);
        StringBuffer sql = new StringBuffer("");
        sql.setLength(0);
        sql.append("update T_MM_Project set FISChanging = 1 where FID='");
        sql.append(info.getProject().getId().toString());
        sql.append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        PMChangeWBSCollection cols = info.getPmChangeWBS();
        StringBuffer ids = new StringBuffer("");
        ids.setLength(0);
        for (int i = 0; i < cols.size(); ++i) {
            PMChangeWBSInfo wbschange = cols.get(i);
            ids.append("'");
            ids.append(wbschange.getTask().getId().toString());
            ids.append("',");
        }
        ids.append("'null'");
        sql.setLength(0);
        sql.append("update T_MM_ProjectTask set FIsChanging = 1 where FID in (");
        sql.append(ids);
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getProject().getId().toString()));
        SelectorItemCollection col = new SelectorItemCollection();
        col.add(new SelectorItemInfo("carNumberRange.*"));
        col.add(new SelectorItemInfo("projectOrg.*"));
        ProjectInfo project = ProjectFactory.getLocalInstance(ctx).getProjectInfo((IObjectPK)new ObjectUuidPK(info.getProject().getId()), col);
        PMChangeCarCollection cars = info.getPmChangeCar();
        block1: for (int i = 0; i < cars.size(); ++i) {
            PMChangeCarInfo car = cars.get(i);
            ProjectCarCollection projectCars = project.getCarNumberRange();
            for (int j = 0; j < projectCars.size(); ++j) {
                ProjectCarInfo projectCar = projectCars.get(j);
                if (!car.getNewCarNum().getId().equals((Object)projectCar.getTrackNumber().getId())) continue;
                car.setOldCarNum(car.getNewCarNum());
                continue block1;
            }
        }
        PMChangeOrgCollection orgs = info.getPmChangeOrg();
        block3: for (int i = 0; i < orgs.size(); ++i) {
            PMChangeOrgInfo org = orgs.get(i);
            ProjectOrgCollection projectOrgs = project.getProjectOrg();
            for (int j = 0; j < projectOrgs.size(); ++j) {
                ProjectOrgInfo projectOrg = projectOrgs.get(j);
                if (!org.getNewOrgUnit().getId().equals((Object)projectOrg.getStorageOrgUnit().getId())) continue;
                org.setOldOrgUnit(org.getNewOrgUnit());
                continue block3;
            }
        }
        return super._submit(ctx, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PMChangeInfo info = (PMChangeInfo)model;
        IObjectPK pkLog = LogUtil.beginLog((Context)ctx, (String)"1", (BOSObjectType)info.getBOSType(), (IObjectPK)new ObjectUuidPK(info.getId()), (String)info.getNumber(), (String)"mm_pmchange_addnew");
        IObjectPK pk = super._addnew(ctx, model);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkLog);
        return pk;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PMChangeInfo info = (PMChangeInfo)model;
        info.setBaseStatus(MMBaseStatusEnum.SAVED);
        this.checkNumber(ctx, model);
        this.removeCarOrOrg(info);
        return super._save(ctx, model);
    }

    private void removeCarOrOrg(PMChangeInfo info) {
        PMChangeOrgCollection orgs;
        PMChangeCarCollection cars = info.getPmChangeCar();
        if (cars != null && cars.size() > 0) {
            for (int i = 0; i < cars.size(); ++i) {
                PMChangeCarInfo carInfo = cars.get(i);
                if (carInfo.getNewCarNum() != null) continue;
                cars.remove(carInfo);
                --i;
            }
        }
        if ((orgs = info.getPmChangeOrg()) != null && orgs.size() > 0) {
            for (int i = 0; i < orgs.size(); ++i) {
                PMChangeOrgInfo orgInfo = orgs.get(i);
                if (orgInfo.getNewOrgUnit() != null) continue;
                orgs.remove(orgInfo);
                --i;
            }
        }
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchActionResults result = this.batchAudit(ctx, this.buildBatchParam(ctx, pk));
        result.throwExceptions();
    }

    public BatchActionResults batchDelete(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, BatchActionEnum.DELETE);
    }

    public BatchActionResults batchAudit(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, BatchActionEnum.AUDIT);
    }

    protected SelectorItemCollection getAuditSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("proejct.*"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("pmChangeOrg.*"));
        sic.add(new SelectorItemInfo("pmChangeCar.*"));
        sic.add(new SelectorItemInfo("pmChangeWBS.*"));
        return sic;
    }

    @Override
    protected Map _getAssociateWBS(Context ctx, IObjectValue model, boolean isProject, ProjectInfo project) throws BOSException, EASBizException {
        ProjectTaskCollection tasks = null;
        HashMap<String, Object> results = new HashMap<String, Object>();
        MMProjectCalendarFactory mmCalendarFactory = null;
        tasks = isProject ? this.getWBS4ProjectChange(ctx, model, mmCalendarFactory) : this.getWBS4TaskChange(ctx, model, project, mmCalendarFactory);
        results.put("TASKS", (Object)tasks);
        results.put("PROJECT", project);
        return results;
    }

    private ProjectTaskCollection getWBS4ProjectChange(Context ctx, IObjectValue model, MMProjectCalendarFactory mmCalendarFactory) throws BOSException, EASBizException {
        ProjectInfo project = (ProjectInfo)model;
        String projectId = project.getId().toString();
        ProjectTaskCollection tasks = this.getTasks(ctx, projectId);
        this.buildTree(tasks, null);
        ProjectTaskCollection results = new ProjectTaskCollection();
        this.projectChange(ctx, project, tasks, results, mmCalendarFactory);
        return results;
    }

    private ProjectTaskCollection getWBS4TaskChange(Context ctx, IObjectValue model, ProjectInfo project, MMProjectCalendarFactory mmCalendarFactory) throws BOSException, EASBizException {
        ProjectTaskInfo task = (ProjectTaskInfo)model;
        String projectId = project.getId().toString();
        ProjectTaskCollection tasks = this.getTasks(ctx, projectId);
        this.buildTree(tasks, task);
        ProjectTaskCollection results = new ProjectTaskCollection();
        ProjectTaskInfo currentTask = (ProjectTaskInfo)tasks.getObject(task.getId());
        this.taskChange(ctx, project, currentTask, results, mmCalendarFactory);
        return results;
    }

    private void projectChange(Context ctx, ProjectInfo project, ProjectTaskCollection tasks, ProjectTaskCollection results, MMProjectCalendarFactory mmCalendarFactory) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select t0.FID ,t0.FNumber,case when t0.FActualBeginTime is null then 0 else 1 end isActualNull from t_mm_projecttask t0 where t0.FProjectID = '").append(project.getId().toString()).append("' and (t0.FIsTransfered = 1 or t0.FIsTransferedCentral = 1 or t0.FActualBeginTime is not null) ");
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowset != null && rowset.next()) {
                if (rowset.getInt("isActualNull") == 1) {
                    throw new PMChangeException(PMChangeException.WBS_IN_WORK, new String[]{rowset.getString("FNumber")});
                }
                throw new PMChangeException(PMChangeException.WBS_IS_TRANSFER, new String[]{rowset.getString("FNumber")});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        Iterator it = tasks.iterator();
        while (it.hasNext()) {
            Date projectPlanBegin = project.getPlanBeginTime();
            Date projectPlanEnd = project.getPlanEndTime();
            projectPlanBegin = this.toCalendar(projectPlanBegin).getTime();
            projectPlanEnd = this.toCalendar(projectPlanEnd).getTime();
            ProjectTaskInfo task = (ProjectTaskInfo)it.next();
            MMBaseStatusEnum status = task.getBaseStatus();
            if (status.equals((Object)MMBaseStatusEnum.SAVED) || status.equals((Object)MMBaseStatusEnum.SUBMIT) || status.equals((Object)MMBaseStatusEnum.SUBMITCOST)) continue;
            String orgId = task.getStorageOrgUnit().getId().toString();
            String projectID = task.getProject().getId().toString();
            if (mmCalendarFactory == null) {
                mmCalendarFactory = new MMProjectCalendarFactory(ctx, projectID);
            } else if (!mmCalendarFactory.getProjectId().equalsIgnoreCase(projectID)) {
                mmCalendarFactory.changeOrg(orgId);
            }
            int projectTotal = mmCalendarFactory.getWorklength(projectPlanBegin, projectPlanEnd);
            if (task.getTotalTime().intValue() > projectTotal) {
                throw new PMChangeException(PMChangeException.PROJECT_TOTAL_TOOSMALL, new String[]{task.getNumber()});
            }
            boolean isChange = false;
            if (projectPlanBegin.compareTo(task.getPlanBeginTime()) > 0) {
                Date planBegin = mmCalendarFactory.getWorkdate(projectPlanBegin);
                task.setPlanBeginTime(new Timestamp(planBegin.getTime()));
                Date planEnd = mmCalendarFactory.addWroklength(task.getPlanBeginTime(), task.getTotalTime().intValue());
                task.setPlanEndTime(new Timestamp(planEnd.getTime()));
                isChange = true;
            } else if (projectPlanEnd.compareTo(task.getPlanEndTime()) < 0) {
                Date planEnd = mmCalendarFactory.getWorkdate2(projectPlanEnd, false);
                task.setPlanEndTime(new Timestamp(planEnd.getTime()));
                Date planbegin = mmCalendarFactory.addWroklength(task.getPlanEndTime(), -task.getTotalTime().intValue());
                task.setPlanBeginTime(new Timestamp(planbegin.getTime()));
                isChange = true;
            }
            if (!isChange) continue;
            results.add(task);
            this.taskChange(ctx, project, task, results, mmCalendarFactory);
            ProjectTaskInfo preTask = task.getPreTask();
            ProjectDictDataInfo iteratorType = task.getIteratorType();
            if (iteratorType == null) continue;
            this.setRearTaskIterval(ctx, preTask, task, iteratorType.getNumber(), mmCalendarFactory);
        }
    }

    private void taskChange(Context ctx, ProjectInfo project, ProjectTaskInfo task, ProjectTaskCollection results, MMProjectCalendarFactory mmCalendarFactory) throws BOSException, EASBizException {
        Boolean isCal = (Boolean)task.get("isCal");
        if (isCal == null || isCal.booleanValue()) {
            return;
        }
        task.put("isCal", Boolean.TRUE);
        List children = (List)task.get("children");
        Iterator it = null;
        if (children != null) {
            it = children.iterator();
        }
        Timestamp parentPlanBegin = task.getPlanBeginTime();
        Timestamp parentPlanEnd = task.getPlanEndTime();
        BigDecimal parentTotalTime = task.getTotalTime();
        while (it != null && it.hasNext()) {
            ProjectTaskInfo child = (ProjectTaskInfo)it.next();
            Timestamp planBegin = child.getPlanBeginTime();
            Timestamp planEnd = child.getPlanEndTime();
            BigDecimal totalTime = child.getTotalTime();
            MMBaseStatusEnum status = child.getBaseStatus();
            if (status.equals((Object)MMBaseStatusEnum.SAVED) || status.equals((Object)MMBaseStatusEnum.SUBMIT) || status.equals((Object)MMBaseStatusEnum.SUBMITCOST) || ((Date)planBegin).compareTo(parentPlanBegin) >= 0 && ((Date)planEnd).compareTo(parentPlanEnd) <= 0) continue;
            if (parentTotalTime.subtract(totalTime).intValue() < 0) {
                throw new PMChangeException(PMChangeException.TOTALTIME_LT_CHILD, new String[]{task.getNumber(), child.getNumber()});
            }
            if (child.isIsTransfered() || child.isIsTransferedCentral()) {
                throw new PMChangeException(PMChangeException.ISTRANSFERED, new String[]{child.getNumber()});
            }
            if (child.getActualBeginTime() != null) {
                throw new PMChangeException(PMChangeException.WBS_IN_WORK, new String[]{child.getNumber()});
            }
            this.setChildTime(ctx, parentPlanBegin, parentPlanEnd, child, mmCalendarFactory);
            results.add(child);
            this.taskChange(ctx, project, child, results, mmCalendarFactory);
        }
        ProjectTaskInfo parent = task.getParent();
        if (parent != null) {
            boolean isChange = false;
            if (((Date)parentPlanBegin).compareTo(parent.getPlanBeginTime()) < 0) {
                if (parent.isIsTransferedCentral() || parent.isIsTransfered()) {
                    throw new PMChangeException(PMChangeException.ISTRANSFERED, new String[]{parent.getNumber()});
                }
                this.setParentTime(ctx, parentPlanBegin, null, parent, mmCalendarFactory);
                isChange = true;
                if (parent.getActualBeginTime() != null) {
                    throw new PMChangeException(PMChangeException.WBS_IN_WORK, new String[]{parent.getNumber()});
                }
            }
            if (((Date)parentPlanEnd).compareTo(parent.getPlanEndTime()) > 0) {
                if (parent.isIsTransferedCentral() || parent.isIsTransfered()) {
                    throw new PMChangeException(PMChangeException.ISTRANSFERED, new String[]{parent.getNumber()});
                }
                this.setParentTime(ctx, null, parentPlanEnd, parent, mmCalendarFactory);
                isChange = true;
                if (parent.getActualBeginTime() != null) {
                    throw new PMChangeException(PMChangeException.WBS_IN_WORK, new String[]{parent.getNumber()});
                }
            }
            if (isChange) {
                String projectID = parent.getProject().getId().toString();
                if (mmCalendarFactory == null) {
                    mmCalendarFactory = new MMProjectCalendarFactory(ctx, projectID);
                } else if (!mmCalendarFactory.getProjectId().equalsIgnoreCase(projectID)) {
                    mmCalendarFactory.changeOrg(projectID);
                }
                int total = mmCalendarFactory.getWorklength(parent.getPlanBeginTime(), parent.getPlanEndTime());
                parent.setTotalTime(new BigDecimal(total));
                results.add(parent);
                this.taskChange(ctx, project, parent, results, mmCalendarFactory);
            }
        } else {
            if (project.getActualBeginTime() != null) {
                throw new PMChangeException(PMChangeException.PROJECT_IN_WORK, new String[]{project.getNumber()});
            }
            if (((Date)parentPlanBegin).compareTo(project.getPlanBeginTime()) < 0) {
                project.setPlanBeginTime(new Timestamp(((Date)parentPlanBegin).getTime()));
                project.put("PROJECTCHANGED", Boolean.TRUE);
            }
            if (((Date)parentPlanEnd).compareTo(project.getPlanEndTime()) > 0) {
                project.setPlanEndTime(new Timestamp(((Date)parentPlanEnd).getTime()));
                project.put("PROJECTCHANGED", Boolean.TRUE);
            }
        }
        ProjectTaskInfo preTask = task.getPreTask();
        if (preTask != null) {
            ProjectDictDataInfo iteratorType = task.getIteratorType();
            this.setRearTaskIterval(ctx, preTask, task, iteratorType.getNumber(), mmCalendarFactory);
        }
        List rearTasks = (List)task.get("rearNodes");
        Iterator itRear = null;
        if (rearTasks != null) {
            itRear = rearTasks.iterator();
        }
        boolean isChange = false;
        while (itRear != null && itRear.hasNext()) {
            ProjectDictDataInfo interatorType;
            ProjectTaskInfo rearTask = (ProjectTaskInfo)itRear.next();
            MMBaseStatusEnum status = rearTask.getBaseStatus();
            if (status.equals((Object)MMBaseStatusEnum.SAVED) || status.equals((Object)MMBaseStatusEnum.SUBMIT) || status.equals((Object)MMBaseStatusEnum.SUBMITCOST) || !(isChange = this.setRearTaskIterval(ctx, task, rearTask, (interatorType = rearTask.getIteratorType()).getNumber(), mmCalendarFactory))) continue;
            results.add(rearTask);
        }
    }

    private boolean setRearTaskIterval(Context ctx, ProjectTaskInfo task, ProjectTaskInfo rearTask, String iteratorType, MMProjectCalendarFactory mmCalendarFactory) throws EASBizException, BOSException {
        String projectID = rearTask.getProject().getId().toString();
        if (mmCalendarFactory == null) {
            mmCalendarFactory = new MMProjectCalendarFactory(ctx, projectID);
        } else if (!mmCalendarFactory.getProjectId().equalsIgnoreCase(projectID)) {
            mmCalendarFactory.changeOrg(projectID);
        }
        int interval = 0;
        if (iteratorType.equalsIgnoreCase("FS")) {
            interval = mmCalendarFactory.getLeadtime3(task.getPlanEndTime(), rearTask.getPlanBeginTime(), 1);
        } else if (iteratorType.equalsIgnoreCase("SS")) {
            interval = mmCalendarFactory.getLeadtime3(task.getPlanBeginTime(), rearTask.getPlanBeginTime(), 0);
        } else if (iteratorType.equalsIgnoreCase("SF")) {
            interval = mmCalendarFactory.getLeadtime3(task.getPlanBeginTime(), rearTask.getPlanEndTime(), -1);
        } else if (iteratorType.equalsIgnoreCase("FF")) {
            interval = mmCalendarFactory.getLeadtime3(task.getPlanEndTime(), rearTask.getPlanEndTime(), 0);
        }
        if (rearTask.getInterval() != null && rearTask.getInterval().intValue() - interval == 0) {
            return false;
        }
        rearTask.setInterval(new BigDecimal(interval));
        return true;
    }

    private void setParentTime(Context ctx, Date planBegin, Date planEnd, ProjectTaskInfo parent, MMProjectCalendarFactory mmCalendarFactory) throws EASBizException, BOSException {
        Date date;
        String projectID = parent.getProject().getId().toString();
        if (mmCalendarFactory == null) {
            mmCalendarFactory = new MMProjectCalendarFactory(ctx, projectID);
        } else if (!mmCalendarFactory.getProjectId().equalsIgnoreCase(projectID)) {
            mmCalendarFactory.changeOrg(projectID);
        }
        Calendar calendar = Calendar.getInstance();
        if (planBegin != null) {
            date = mmCalendarFactory.getWorkdate2(planBegin, false);
            calendar.setTime(date);
            parent.setPlanBeginTime(new Timestamp(calendar.getTimeInMillis()));
        }
        if (planEnd != null) {
            date = mmCalendarFactory.getWorkdate2(planEnd, true);
            calendar.setTime(date);
            parent.setPlanEndTime(new Timestamp(calendar.getTimeInMillis()));
        }
    }

    private void setChildTime(Context ctx, Date parentPlanBegin, Date parentPlanEnd, ProjectTaskInfo child, MMProjectCalendarFactory mmCalendarFactory) throws EASBizException, BOSException {
        String projectID = child.getProject().getId().toString();
        if (mmCalendarFactory == null) {
            mmCalendarFactory = new MMProjectCalendarFactory(ctx, projectID);
        } else if (!mmCalendarFactory.getProjectId().equalsIgnoreCase(projectID)) {
            mmCalendarFactory.changeOrg(projectID);
        }
        Calendar calendar = Calendar.getInstance();
        if (parentPlanBegin.compareTo(child.getPlanBeginTime()) > 0) {
            calendar.setTime(parentPlanBegin);
            child.setPlanBeginTime(new Timestamp(calendar.getTimeInMillis()));
            Date planEnd = mmCalendarFactory.addWroklength(parentPlanBegin, child.getTotalTime().intValue());
            calendar.setTime(planEnd);
            child.setPlanEndTime(new Timestamp(calendar.getTimeInMillis()));
        }
        if (parentPlanEnd.compareTo(child.getPlanEndTime()) < 0) {
            calendar.setTime(parentPlanEnd);
            child.setPlanEndTime(new Timestamp(calendar.getTimeInMillis()));
            Date planBegin = mmCalendarFactory.addWroklength(parentPlanEnd, -child.getTotalTime().intValue());
            calendar.setTime(planBegin);
            child.setPlanBeginTime(new Timestamp(calendar.getTimeInMillis()));
        }
    }

    private ProjectTaskCollection getTasks(Context ctx, String projectId) throws BOSException {
        IProjectTask iProjectTask = ProjectTaskFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("project.id", (Object)projectId));
        filter.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(0), CompareType.NOTEQUALS));
        view.setFilter(filter);
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("*"));
        coll.add(new SelectorItemInfo("iteratorType.*"));
        coll.add(new SelectorItemInfo("feedbackMode.*"));
        coll.add(new SelectorItemInfo("preTask.id"));
        coll.add(new SelectorItemInfo("preTask.name"));
        coll.add(new SelectorItemInfo("preTask.number"));
        coll.add(new SelectorItemInfo("carNumber.id"));
        coll.add(new SelectorItemInfo("carNumber.name"));
        coll.add(new SelectorItemInfo("carNumber.number"));
        view.getSorter().add(new SorterItemInfo("wbsNumber"));
        view.setSelector(coll);
        ProjectTaskCollection tasks = iProjectTask.getProjectTaskCollection(view);
        return tasks;
    }

    private void buildTree(ProjectTaskCollection tasks, ProjectTaskInfo currentTask) {
        Iterator it = tasks.iterator();
        while (it.hasNext()) {
            ProjectTaskInfo task = (ProjectTaskInfo)it.next();
            if (currentTask != null && task.getId().equals((Object)currentTask.getId())) {
                this.copyTask(currentTask, task);
            }
            task.put("isCal", Boolean.FALSE);
            ProjectTaskInfo preTask = task.getPreTask();
            ProjectTaskInfo parentTask = task.getParent();
            if (preTask != null && (preTask = (ProjectTaskInfo)tasks.getObject(preTask.getId())) != null) {
                task.setPreTask(preTask);
                List postTasks = (List)preTask.get("rearNodes");
                if (postTasks != null) {
                    postTasks.add(task);
                } else {
                    ArrayList<ProjectTaskInfo> rearNodes = new ArrayList<ProjectTaskInfo>();
                    rearNodes.add(task);
                    preTask.put("rearNodes", rearNodes);
                }
            }
            if (parentTask == null || (parentTask = (ProjectTaskInfo)tasks.getObject(parentTask.getId())) == null) continue;
            task.setParent(parentTask);
            List children = (List)parentTask.get("children");
            if (children != null) {
                children.add(task);
                continue;
            }
            ArrayList<ProjectTaskInfo> childrenNode = new ArrayList<ProjectTaskInfo>();
            childrenNode.add(task);
            parentTask.put("children", childrenNode);
        }
    }

    private void copyTask(ProjectTaskInfo taskSrc, ProjectTaskInfo taskDesc) {
        taskDesc.setCarNumber(taskSrc.getCarNumber());
        taskDesc.setFeedbackMode(taskSrc.getFeedbackMode());
        taskDesc.setInterval(taskSrc.getInterval());
        taskDesc.setIsMileStone(taskSrc.isIsMileStone());
        taskDesc.setIteratorType(taskSrc.getIteratorType());
        taskDesc.setPlanBeginTime(new Timestamp(taskSrc.getPlanBeginTime().getTime()));
        taskDesc.setPlanEndTime(new Timestamp(taskSrc.getPlanEndTime().getTime()));
        taskDesc.setPreTask(taskSrc.getPreTask());
        taskDesc.setQty(taskSrc.getQty());
        taskDesc.setTotalTime(taskSrc.getTotalTime());
        taskDesc.setComment(taskSrc.getComment());
        taskDesc.setProject(taskSrc.getProject());
    }

    private String getResource(Context ctx, String strKey) {
        String strTemp = ResourceBase.getString((String)"com.kingdee.eas.mm.project.PMChangeResource", (String)strKey, (Locale)ctx.getLocale());
        return strTemp;
    }

    private Calendar toCalendar(Date theDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(theDate);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    @Override
    protected IObjectValue _createNewData(Context ctx) throws BOSException, EASBizException {
        PMChangeInfo info = new PMChangeInfo();
        Calendar cal = Calendar.getInstance();
        info.setCreateTime(new Timestamp(cal.getTimeInMillis()));
        return info;
    }
}

