/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.MMBaseStatusEnum;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.project.ProjectException;
import com.kingdee.eas.mm.project.ProjectFeedBackFactory;
import com.kingdee.eas.mm.project.ProjectFeedBackInfo;
import com.kingdee.eas.mm.project.ProjectFeedbackException;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.mm.project.ProjectTaskException;
import com.kingdee.eas.mm.project.ProjectTaskInfo;
import com.kingdee.eas.mm.project.app.AbstractProjectFeedBackControllerBean;
import com.kingdee.eas.mm.project.app.ProjectFeedbackUpdater;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ProjectFeedBackControllerBean
extends AbstractProjectFeedBackControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.project.app.ProjectFeedBackControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectFeedBackInfo feedBackInfo = (ProjectFeedBackInfo)model;
        feedBackInfo.setBaseStatus(MMBaseStatusEnum.SAVED);
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectFeedBackInfo feedBackInfo = (ProjectFeedBackInfo)model;
        if (feedBackInfo.getBaseStatus() != MMBaseStatusEnum.SUBMITCOST) {
            feedBackInfo.setBaseStatus(MMBaseStatusEnum.SUBMIT);
        }
        return super._submit(ctx, model);
    }

    protected IObjectPK _submitInBatch(Context ctx, IObjectValue model, IObjectCollection relations) throws BOSException, EASBizException {
        ProjectFeedBackInfo feedBackInfo = (ProjectFeedBackInfo)model;
        if (feedBackInfo.getBaseStatus() == MMBaseStatusEnum.ADDNEW) {
            feedBackInfo.setBaseStatus(MMBaseStatusEnum.SUBMIT);
        }
        if (feedBackInfo.getBaseStatus() != MMBaseStatusEnum.SUBMITCOST) {
            feedBackInfo.setBaseStatus(MMBaseStatusEnum.SUBMIT);
        }
        return super._submitInBatch(ctx, model, relations);
    }

    protected void delete(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        String[] sqls = new String[]{"DELETE FROM T_MM_ProjectFeedBack WHERE FID in (" + idStr + ")"};
        SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
    }

    protected String getBillTypeId() {
        return "p8Cd4ZbXQWup7765GSqJukY+1VI=";
    }

    protected ICoreBase getBizInterface(Context ctx) throws BOSException, EASBizException {
        return ProjectFeedBackFactory.getLocalInstance(ctx);
    }

    protected String getRecycleNumberSQL(String idStr) {
        return "select fid,fnumber,fstorageorgunitid forgid from T_MM_ProjectFeedBack where fid in (" + idStr + ")";
    }

    protected String getXmlFileName(BatchActionEnum batchActionEnum) {
        return "com.kingdee.eas.mm.project.app.xml.projectfeedback.xml";
    }

    protected IObjectValue getBillInstance() {
        return new ProjectFeedBackInfo();
    }

    public void batchCheck(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        super.batchCheck(ctx, batchAction, batchResults);
        if (batchAction.equals((Object)BatchActionEnum.AUDIT) || batchAction.equals((Object)BatchActionEnum.UNAUDIT)) {
            this.checkTaskProjectInChanging(ctx, batchResults);
            ProjectFeedbackUpdater billUpdater = new ProjectFeedbackUpdater(ctx);
            billUpdater.setBatchResults(batchResults);
            billUpdater.setAuditAction(batchAction.equals((Object)BatchActionEnum.AUDIT));
            billUpdater.execute();
        }
        if (batchAction.equals((Object)BatchActionEnum.SAVE)) {
            this.saveCheck(ctx, batchResults);
        }
        if (batchAction.equals((Object)BatchActionEnum.SUBMIT)) {
            this.submitCheck(ctx, batchResults);
        }
    }

    private void checkTaskProjectInChanging(Context ctx, BatchActionResults batchResults) throws BOSException {
        Object[] ids = batchResults.getToDoIdsArray();
        StringBuffer sql = new StringBuffer();
        sql.append("select  t1.fid  from  t_mm_projecttask t0 left outer join ");
        sql.append("t_mm_projectfeedback t1 on t0.Fid = t1.FProjectTaskID ");
        sql.append("where t1.fid in  (");
        sql.append(SQLUtil.arrayToString((Object[])ids));
        sql.append(") and t0.FIsChanging = 1");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ProjectTaskException exceptionTask = null;
        exceptionTask = new ProjectTaskException(ProjectTaskException.TASK_INCHANGING);
        try {
            while (rs.next()) {
                batchResults.addError(rs.getString("fid"), (Exception)((Object)exceptionTask));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        ids = batchResults.getToDoIdsArray();
        sql.setLength(0);
        sql.append("select  t1.fid  from  t_mm_project t0 left outer join ");
        sql.append("t_mm_projectfeedback t1 on t0.Fid = t1.FProjectID ");
        sql.append("where t1.fid in  (");
        sql.append(SQLUtil.arrayToString((Object[])ids));
        sql.append(") and t0.FIsChanging = 1");
        IRowSet rsProject = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ProjectException exception = new ProjectException(ProjectException.PROJECT_INCHANGINGE);
        try {
            while (rsProject.next()) {
                batchResults.addError(rsProject.getString("fid"), (Exception)((Object)exception));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public BatchActionResults batchConfirmCost(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("CONFIRMCOST"));
    }

    public BatchActionResults batchUnConfirmCost(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("UNCONFIRMCOST"));
    }

    public BatchActionResults batchSaveCost(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("SAVECOST"));
    }

    public void batchExecute(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        if (batchResults.getToDoIdsList() != null && batchResults.getToDoIdsList().size() > 0) {
            if (batchAction.equals((Object)BatchActionEnum.SAVE) || batchAction.equals((Object)BatchActionEnum.SUBMIT)) {
                if (batchAction.equals((Object)BatchActionEnum.SUBMIT)) {
                    this.checkTime(ctx, batchResults);
                }
                this.afterSave(ctx, batchResults);
            }
            if (batchAction.equals((Object)new BatchActionEnum("CONFIRMCOST")) || batchAction.equals((Object)new BatchActionEnum("SAVECOST"))) {
                this.updateCost(ctx, batchAction, batchResults);
            }
        }
        super.batchExecute(ctx, batchAction, batchResults);
    }

    private void checkTime(Context ctx, BatchActionResults batchResults) throws BOSException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        StringBuffer sb = new StringBuffer();
        sb.append("select fid,isnull(fprojecttaskid,'project') fprojecttaskid,case when fprojecttaskid is null  ");
        sb.append("then factBeginTimef-fearistBeginTimep else factBeginTimef-fearistBeginTimet end flagBeginTime, ");
        sb.append("case when fprojecttaskid is null then flastEndTimep-factEndTimef else flastEndTimet-factEndTimef ");
        sb.append("end flagEndTime from (select  a.fid ,a.fprojectid ,a.fprojecttaskid,a.factBeginTime factBeginTimef, ");
        sb.append("a.factEndTime factEndTimef,b.fearistBeginTime fearistBeginTimep,b.flastEndTime flastEndTimep, ");
        sb.append("c.fearistBeginTime fearistBeginTimet,c.flastEndTime flastEndTimet from t_mm_projectfeedback  a ");
        sb.append("left join t_mm_project  b  on a.fprojectid = b.fid left join t_mm_projecttask  c on a.fprojecttaskid  ");
        sb.append("= c.fid where a.fid in (");
        sb.append(idStr);
        sb.append(")  a)");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rs.next()) {
                String flagBegin = rs.getString("flagBeginTime");
                String flagEnd = rs.getString("flagEndTime");
                if (flagBegin != null && flagBegin.startsWith("-") && flagEnd != null && flagEnd.startsWith("-")) {
                    batchResults.addError(rs.getString("fid"), (Exception)((Object)new ProjectFeedbackException(ProjectFeedbackException.ERRORTIME)));
                    continue;
                }
                if (flagBegin != null && flagBegin.startsWith("-")) {
                    batchResults.addError(rs.getString("fid"), (Exception)((Object)new ProjectFeedbackException(ProjectFeedbackException.ERRORBEGINTIME)));
                    continue;
                }
                if (flagEnd == null || !flagEnd.startsWith("-")) continue;
                batchResults.addError(rs.getString("fid"), (Exception)((Object)new ProjectFeedbackException(ProjectFeedbackException.ERRORENDTIME)));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void updateCost(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException {
        Connection conn = null;
        Statement statement = null;
        ProjectFeedBackInfo info = null;
        BatchExecuteParamsEntry[] entries = batchResults.getParamEntries();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            ResultSet rs = null;
            String taskCostSql = null;
            for (int i = 0; i < entries.length; ++i) {
                info = (ProjectFeedBackInfo)entries[i].get(0);
                String update = null;
                if (batchAction.equals((Object)new BatchActionEnum("CONFIRMCOST"))) {
                    if (info.getProjectTask().getId() != null) {
                        taskCostSql = "select isnull(FActTotalCost,0) FActTotalCost,isnull(FTotalCost,0) FTotalCost from t_mm_projecttask where FID = '" + info.getProjectTask().getId().toString() + "'";
                        rs = statement.executeQuery(taskCostSql);
                        rs.next();
                        if (rs.getBigDecimal("FTotalCost").add(rs.getBigDecimal("FActTotalCost").negate()).add(info.getActTotalCost().negate()).signum() >= 0) {
                            update = "update T_MM_ProjectFeedBack set factTotalCost=" + info.getActTotalCost() + ",FActUnitCost =" + info.getActUnitCost() + ",fbasestatus=60 where fid = '" + info.getId().toString() + "'";
                            statement.execute(update);
                            continue;
                        }
                        batchResults.addError(info.getId().toString(), (Exception)((Object)new ProjectFeedbackException(ProjectFeedbackException.INVALID_COST)));
                        continue;
                    }
                    taskCostSql = "select isnull(FActTotalCost,0) FActTotalCost,isnull(FTotalCost,0) FTotalCost from t_mm_project where FID = '" + info.getProject().getId().toString() + "'";
                    rs = statement.executeQuery(taskCostSql);
                    rs.next();
                    if (rs.getBigDecimal("FTotalCost").add(rs.getBigDecimal("FActTotalCost").negate()).add(info.getActTotalCost().negate()).signum() >= 0) {
                        update = "update T_MM_ProjectFeedBack set factTotalCost=" + info.getActTotalCost() + ",FActUnitCost =" + info.getActUnitCost() + ",fbasestatus=60 where fid = '" + info.getId().toString() + "'";
                        statement.execute(update);
                        continue;
                    }
                    batchResults.addError(info.getId().toString(), (Exception)((Object)new ProjectFeedbackException(ProjectFeedbackException.INVALID_COST)));
                    continue;
                }
                if (!batchAction.equals((Object)new BatchActionEnum("SAVECOST"))) continue;
                update = "update T_MM_ProjectFeedBack set factTotalCost=" + info.getActTotalCost() + ",FActUnitCost =" + info.getActUnitCost() + " where fid = '" + info.getId().toString() + "'";
                statement.execute(update);
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
    }

    @Override
    protected void _confirmCost(Context ctx, IObjectValue model, IObjectPK pk) throws BOSException, EASBizException {
        BatchActionResults result = this.batchConfirmCost(ctx, this.buildBatchParam(ctx, model, pk));
        result.throwExceptions();
    }

    @Override
    protected void _saveCost(Context ctx, IObjectValue model, IObjectPK pk) throws BOSException, EASBizException {
        BatchActionResults result = this.batchSaveCost(ctx, this.buildBatchParam(ctx, model, pk));
        result.throwExceptions();
    }

    protected BatchExecuteParamsEntry[] buildBatchParam(Context ctx, IObjectValue model, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectValue.class, IObjectPK.class});
        entry.add((Object)model);
        entry.add((Object)pk);
        return new BatchExecuteParamsEntry[]{entry};
    }

    private void afterSave(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update  t_mm_projectfeedback as t0 set (FACTBASEQTY)=(select round(decimal(qty,21,8),8)  from(select t0.FACTQTY * t1.FBaseConvsRate  ");
        updateSql.append("qty from t_bd_multimeasureunit t1,t_mm_projectfeedback t0 where  t0.FMaterialID = t1.FMaterialID and t0.FUNITID = t1.fmeasureunitid  ");
        updateSql.append("and t0.fid in (");
        updateSql.append(idStr);
        updateSql.append(")) cc ) where t0.FID in (");
        updateSql.append(idStr);
        updateSql.append(") ");
        StringBuffer updateNoMaterial = new StringBuffer("");
        updateNoMaterial.setLength(0);
        updateNoMaterial.append("update t_mm_projectfeedback as t0 ").append("set FACTBASEQTY = FACTQTY ").append("where t0.FID in (").append(idStr).append(") ").append("and t0.FMaterialID is null ");
        SQLUtil.batchExecuteSql((Context)ctx, (String[])new String[]{updateSql.toString(), updateNoMaterial.toString()});
    }

    private String arrayToString(Object[] ids) {
        String idStr = "'null'";
        if (ids != null && ids.length > 0) {
            for (int i = 0; i < ids.length; ++i) {
                if (ids[i].toString().equalsIgnoreCase("NEWID")) continue;
                idStr = idStr + ",'" + ids[i].toString() + "'";
            }
        }
        return idStr;
    }

    private void submitCheck(Context ctx, BatchActionResults batchResults) throws BOSException {
        String ids = this.arrayToString(batchResults.getToDoIdsArray());
        StringBuffer statusCheck = new StringBuffer("");
        statusCheck.append("select FID from t_mm_projectfeedback where FID in ( ").append(ids).append(") and FBaseStatus not in (1,2)");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)statusCheck.toString());
        try {
            while (rs.next()) {
                String msg = ResourceBase.getString((String)"com.kingdee.eas.mm.project.ProjectFeedBackResource", (String)"STATUS_NOT_CORRECT", (Locale)ctx.getLocale());
                batchResults.addError(rs.getString("FID"), msg);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        IObjectCollection col = batchResults.getObjCollection();
        if (col != null && col.size() > 0) {
            for (int i = 0; i < col.size(); ++i) {
                String msg = null;
                ProjectFeedBackInfo feedback = (ProjectFeedBackInfo)col.getObject(i);
                String id = null;
                id = feedback.getId() == null ? "NEWID" : feedback.getId().toString();
                ProjectInfo project = feedback.getProject();
                ProjectTaskInfo task = feedback.getProjectTask();
                boolean isErrorBegin = false;
                boolean isErrorEnd = false;
                if (task != null) {
                    if (task.getEaristBeginTime() != null) {
                        boolean bl = isErrorBegin = feedback.getActBeginTime().compareTo(task.getEaristBeginTime()) < 0;
                    }
                    if (task.getLastEndTime() != null) {
                        isErrorEnd = feedback.getActEndTime().compareTo(task.getLastEndTime()) > 0;
                    }
                } else {
                    if (project.getEaristBeginTime() != null) {
                        boolean bl = isErrorBegin = feedback.getActBeginTime().compareTo(project.getEaristBeginTime()) < 0;
                    }
                    if (project.getLastEndTime() != null) {
                        boolean bl = isErrorEnd = feedback.getActEndTime().compareTo(project.getLastEndTime()) > 0;
                    }
                }
                if (isErrorBegin && isErrorEnd) {
                    batchResults.addError(id, (Exception)((Object)new ProjectFeedbackException(ProjectFeedbackException.ERRORTIME)));
                } else if (isErrorBegin) {
                    batchResults.addError(id, (Exception)((Object)new ProjectFeedbackException(ProjectFeedbackException.ERRORBEGINTIME)));
                } else if (isErrorEnd) {
                    batchResults.addError(id, (Exception)((Object)new ProjectFeedbackException(ProjectFeedbackException.ERRORENDTIME)));
                }
                Timestamp actBegin = feedback.getActBeginTime();
                Timestamp actEnd = feedback.getActEndTime();
                Date actBeginDate = this.toCalendar(actBegin).getTime();
                Date actEndDate = this.toCalendar(actEnd).getTime();
                if (!actBeginDate.after(actEndDate)) continue;
                msg = ResourceBase.getString((String)"com.kingdee.eas.mm.project.ProjectFeedBackResource", (String)"ENDTIME_GREAT_BEGINTIME", (Locale)ctx.getLocale());
                batchResults.addError(id, msg);
            }
        }
    }

    private Calendar toCalendar(Date theDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(theDate);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    private void saveCheck(Context ctx, BatchActionResults batchResults) throws SQLDataException {
        IObjectCollection col = batchResults.getObjCollection();
        if (col != null && col.size() > 0) {
            for (int i = 0; i < col.size(); ++i) {
                String msg = null;
                ProjectFeedBackInfo feedback = (ProjectFeedBackInfo)col.getObject(i);
                String id = null;
                id = feedback.getId() == null ? "NEWID" : feedback.getId().toString();
                if (feedback.getBizDate() != null && !feedback.getBizDate().equals("")) continue;
                msg = ResourceBase.getString((String)"com.kingdee.eas.mm.project.ProjectFeedBackResource", (String)"BIZDATEISNULL", (Locale)ctx.getLocale());
                batchResults.addError(id, msg);
            }
        }
    }

    @Override
    protected void _unConfirmCost(Context ctx, IObjectValue model, IObjectPK pk) throws BOSException, EASBizException {
        BatchActionResults result = this.batchUnConfirmCost(ctx, this.buildBatchParam(ctx, model, pk));
        result.throwExceptions();
    }

    protected String getDeleteTableName() {
        return "t_mm_projectfeedback";
    }
}

