/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.BasedataException;
import com.kingdee.eas.mm.common.MMBaseStatusEnum;
import com.kingdee.eas.mm.project.IProjectFeedBack;
import com.kingdee.eas.mm.project.ProjectCollection;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectFeedBackFactory;
import com.kingdee.eas.mm.project.ProjectFeedBackInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.mm.project.ProjectTaskCollection;
import com.kingdee.eas.mm.project.ProjectTaskFactory;
import com.kingdee.eas.mm.project.ProjectTaskInfo;
import com.kingdee.eas.mm.project.app.ProjectFeedBackControllerBean;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Locale;

public class ProjectFeedbackCostImpExp
extends AbstractDataTransmission {
    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FProjectNumber", rs.getString("project.number"));
            this.putTable(result, "FTaskNumber", rs.getString("projectTask.number"));
            this.putTable(result, "FWbsNumber", rs.getString("projectTask.wbsNumber"));
            this.putTable(result, "FMaterialName", rs.getString("material.number"));
            this.putTable(result, "FTotalCost", rs.getString("projectTask.totalCost"));
            this.putTable(result, "FUnitCost", rs.getString("projectTask.unitCost"));
            this.putTable(result, "FActTotalCost", rs.getString("actTotalCost"));
            this.putTable(result, "FActUnitCost", rs.getString("actUnitCost"));
            this.putTable(result, "FTaskStatus", MMBaseStatusEnum.getEnum((int)rs.getInt("baseStatus")).getAlias());
            this.putTable(result, "FCurrency", rs.getString("currency.name"));
            this.putTable(result, "FUnit", rs.getString("baseUnit.name"));
            this.putTable(result, "FActQty", rs.getString("actQty"));
            this.putTable(result, "FBizDate", rs.getString("bizDate"));
            if (rs.getString("projectTask.number") == null || rs.getString("projectTask.number").length() == 0) {
                this.putTable(result, "FMaterialName", rs.getString("material1.number"));
                this.putTable(result, "FTotalCost", rs.getString("project.totalCost"));
                this.putTable(result, "FUnitCost", rs.getString("project.unitCost"));
                this.putTable(result, "FUnit", rs.getString("baseUnit1.name"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return ProjectFeedBackFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable paramHashtable, Context paramContext) throws TaskExternalException {
        try {
            return this.innerTransmit(paramHashtable, paramContext);
        }
        catch (TaskExternalException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private CoreBaseInfo innerTransmit(Hashtable hsData, Context ctx) throws TaskExternalException, Exception {
        ProjectFeedBackInfo info = new ProjectFeedBackInfo();
        Object projectNumber = ((DataToken)hsData.get((Object)"FProjectNumber")).data;
        if (projectNumber == null) {
            throw new BasedataException(BasedataException.FIELD_CANT_NULL, (Object[])new String[]{"FProjectNumber"});
        }
        ProjectInfo project = this.getProjectByNumber(ctx, projectNumber.toString());
        if (project == null) {
            throw new BasedataException(BasedataException.FIELD_ILEGAL, (Object[])new String[]{"FProjectNumber"});
        }
        info.setProject(project);
        Object projectTaskNumber = ((DataToken)hsData.get((Object)"FTaskNumber")).data;
        if (projectTaskNumber == null) {
            info.setProjectTask(null);
        } else {
            ProjectTaskInfo projectTask = this.getProjectTaskByNumber(ctx, projectTaskNumber.toString());
            info.setProjectTask(projectTask);
        }
        info = this.handleInfo(hsData, ctx, info);
        return info;
    }

    private ProjectFeedBackInfo handleInfo(Hashtable hsData, Context ctx, ProjectFeedBackInfo info) throws TaskExternalException, BOSException, EASBizException {
        ObjectUuidPK projectPK = new ObjectUuidPK(info.getProject().getId());
        String number = DataImportTools.getDataString((Hashtable)hsData, (String)"FNumber");
        FilterInfo filter = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        if (info.getProjectTask() != null && !"".equals(info.getProjectTask())) {
            ObjectUuidPK projectTaskPK = new ObjectUuidPK(info.getProjectTask().getId());
            filter.getFilterItems().add(new FilterItemInfo("projectTask.id", (Object)projectTaskPK, CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("projectTask.id", null, CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("project.id", (Object)projectPK, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        IProjectFeedBack projectFeedBack = null;
        try {
            projectFeedBack = ProjectFeedBackFactory.getLocalInstance(ctx);
        }
        catch (BOSException e2) {
            throw new TaskExternalException(ProjectFeedbackCostImpExp.getResource(ctx, "FEEDBACK_ERROR"));
        }
        CoreBaseCollection feedBackCollection = null;
        try {
            feedBackCollection = projectFeedBack.getCollection(viewInfo);
        }
        catch (BOSException e1) {
            throw new TaskExternalException(ProjectFeedbackCostImpExp.getResource(ctx, "NOT_FOUND_FEEDBACK"));
        }
        if (null != feedBackCollection) {
            if (0 == feedBackCollection.size()) {
                throw new TaskExternalException(ProjectFeedbackCostImpExp.getResource(ctx, "NOT_FOUND_FEEDBACK"));
            }
            if (1 < feedBackCollection.size()) {
                throw new TaskExternalException(ProjectFeedbackCostImpExp.getResource(ctx, "MORE_FEEDBACK"));
            }
        } else {
            throw new TaskExternalException(ProjectFeedbackCostImpExp.getResource(ctx, "NOT_FOUND_FEEDBACK"));
        }
        info = (ProjectFeedBackInfo)feedBackCollection.get(0);
        ICurrency icurreny = CurrencyFactory.getLocalInstance((Context)ctx);
        if (info.getBaseStatus() == MMBaseStatusEnum.SUBMIT || info.getBaseStatus() == MMBaseStatusEnum.SUBMITCOST) {
            ProjectTaskInfo ptinfo;
            int premision = icurreny.getCurrencyInfo((IObjectPK)new ObjectUuidPK(info.getCurrency().getId().toString())).getPrecision();
            BigDecimal fqty = info.getActQty();
            String totalCost = DataImportTools.getDataString((Hashtable)hsData, (String)"FActTotalCost");
            String unitCost = DataImportTools.getDataString((Hashtable)hsData, (String)"FActUnitCost");
            String basedate = DataImportTools.getDataString((Hashtable)hsData, (String)"FTaskStatus");
            BigDecimal bigtotalCost = new BigDecimal(totalCost);
            BigDecimal bigunitCost = new BigDecimal(unitCost);
            if (bigtotalCost.compareTo(bigunitCost) < 0 || bigunitCost.compareTo(new BigDecimal("0")) < 0) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.mm.project.ProjectTaskResource", (String)"TASK_QTY_IS_NOT_FU", (Locale)ctx.getLocale()));
            }
            if (fqty != null && fqty.compareTo(new BigDecimal("0")) == 0) {
                if (bigtotalCost.compareTo(bigunitCost) != 0) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.mm.project.ProjectTaskResource", (String)"TASK_QTY_IS_EQUL_ZERO", (Locale)ctx.getLocale()));
                }
            } else if (bigunitCost.multiply(fqty).compareTo(bigtotalCost) != 0 && bigtotalCost.divide(fqty, premision, 4).compareTo(bigunitCost) != 0) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.mm.project.ProjectTaskResource", (String)"TASK_QTY_IS_NOT_HE_DAYE", (Locale)ctx.getLocale()));
            }
            if (info.getProjectTask() != null ? bigtotalCost.compareTo((ptinfo = ProjectTaskFactory.getLocalInstance(ctx).getProjectTaskInfo((IObjectPK)new ObjectUuidPK(info.getProjectTask().getId()))).getTotalCost()) > 0 : bigtotalCost.compareTo((ptinfo = ProjectFactory.getLocalInstance(ctx).getProjectInfo((IObjectPK)new ObjectUuidPK(info.getProject().getId()))).getTotalCost()) > 0) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.mm.project.ProjectTaskResource", (String)"TASK_COMPARTETO_COST", (Locale)ctx.getLocale()));
            }
            info.setActTotalCost(bigtotalCost);
            info.setActUnitCost(bigunitCost);
            if (basedate.equalsIgnoreCase(MMBaseStatusEnum.SUBMIT.getAlias()) || basedate.equalsIgnoreCase(MMBaseStatusEnum.SUBMITCOST.getAlias())) {
                info.setBaseStatus(MMBaseStatusEnum.SUBMIT);
            }
        }
        return info;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (coreBaseInfo == null) {
                return;
            }
            if (coreBaseInfo.getId() == null || !this.getController(ctx).exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                ProjectFeedBackInfo feedBackInfo = (ProjectFeedBackInfo)coreBaseInfo;
                if (feedBackInfo.getBaseStatus() != null && feedBackInfo.getBaseStatus().equals((Object)MMBaseStatusEnum.SUBMIT)) {
                    BatchExecuteParamsEntry[] entrys = new BatchExecuteParamsEntry[1];
                    BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectValue.class, IObjectPK.class});
                    entry.add((Object)feedBackInfo);
                    entry.add((Object)new ObjectUuidPK(feedBackInfo.getId()));
                    entrys[0] = entry;
                    ProjectFeedBackControllerBean projectFeedBackBean = new ProjectFeedBackControllerBean();
                    projectFeedBackBean.batchSaveCost(ctx, entrys);
                } else if (feedBackInfo.getBaseStatus() != null && feedBackInfo.getBaseStatus().equals((Object)MMBaseStatusEnum.SUBMITCOST)) {
                    BatchExecuteParamsEntry[] entrys = new BatchExecuteParamsEntry[1];
                    BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectValue.class, IObjectPK.class});
                    entry.add((Object)feedBackInfo);
                    entry.add((Object)new ObjectUuidPK(feedBackInfo.getId()));
                    entrys[0] = entry;
                    ProjectFeedBackControllerBean projectFeedBackBean = new ProjectFeedBackControllerBean();
                    projectFeedBackBean.batchConfirmCost(ctx, entrys);
                }
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private ProjectInfo getProjectByNumber(Context ctx, String number) throws BOSException, BasedataException {
        if (number == null || "".equals(number)) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        ProjectCollection coll = ProjectFactory.getLocalInstance(ctx).getProjectCollection(viewInfo);
        ProjectInfo info = coll.get(0);
        return info;
    }

    private ProjectTaskInfo getProjectTaskByNumber(Context ctx, String number) throws BOSException, BasedataException {
        if (number == null || "".equals(number)) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        ProjectTaskCollection coll = ProjectTaskFactory.getLocalInstance(ctx).getProjectTaskCollection(viewInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        ProjectTaskInfo info = coll.get(0);
        return info;
    }

    public static String getResource(Context ctx, String strKey) {
        String strTemp = ResourceBase.getString((String)"com.kingdee.eas.mm.project.ProjectFeedBackResource", (String)strKey, (Locale)ctx.getLocale());
        return strTemp;
    }
}

