/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.industry.emm.mm.pm.basedata.IVehicleType;
import com.kingdee.eas.industry.emm.mm.pm.basedata.VehicleTypeCollection;
import com.kingdee.eas.industry.emm.mm.pm.basedata.VehicleTypeFactory;
import com.kingdee.eas.industry.emm.mm.pm.basedata.VehicleTypeInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.ProjectTypesCollection;
import com.kingdee.eas.industry.emm.pcm.basedata.ProjectTypesFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.ProjectTypesInfo;
import com.kingdee.eas.industry.emm.pcp.IProjectPlanModel;
import com.kingdee.eas.industry.emm.pcp.ProjectPlanModelCollection;
import com.kingdee.eas.industry.emm.pcp.ProjectPlanModelFactory;
import com.kingdee.eas.industry.emm.pcp.ProjectPlanModelInfo;
import com.kingdee.eas.mm.basedata.TrackNumberCollection;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.MMBaseStatusEnum;
import com.kingdee.eas.mm.project.CertaintyEnum;
import com.kingdee.eas.mm.project.ControlDimensionEnum;
import com.kingdee.eas.mm.project.DeliveryTypeEnum;
import com.kingdee.eas.mm.project.IProjectCalendar;
import com.kingdee.eas.mm.project.ProjectCalendarFactory;
import com.kingdee.eas.mm.project.ProjectCalendarInfo;
import com.kingdee.eas.mm.project.ProjectCarCollection;
import com.kingdee.eas.mm.project.ProjectCarInfo;
import com.kingdee.eas.mm.project.ProjectCentralPurOrgCollection;
import com.kingdee.eas.mm.project.ProjectCentralPurOrgInfo;
import com.kingdee.eas.mm.project.ProjectCollection;
import com.kingdee.eas.mm.project.ProjectDeliveryEntryInfo;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectGroupCollection;
import com.kingdee.eas.mm.project.ProjectGroupFactory;
import com.kingdee.eas.mm.project.ProjectGroupInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.mm.project.ProjectOrgCollection;
import com.kingdee.eas.mm.project.ProjectOrgInfo;
import com.kingdee.eas.mm.project.ProjectPriorityEnum;
import com.kingdee.eas.mm.project.util.MMProjectCalendarFactory;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.DataSubmitModeEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.record.IRecord;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class ProjectImpExp
extends AbstractDataTransmission {
    private static String resources = "com.kingdee.eas.mm.project.ProjectResource";
    private Logger logger = Logger.getLogger(ProjectImpExp.class);
    private MMProjectCalendarFactory mmCalendar = null;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return ProjectFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public int getSubmitType() {
        return 1;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            BigDecimal ZERO = new BigDecimal("0.00");
            ProjectInfo info = (ProjectInfo)coreBaseInfo;
            if (info.getCU() == null) {
                throw new TaskExternalException(this.getResource(ctx, "MUST_IS_BILU"));
            }
            if (info.getNumber() == null) {
                throw new TaskExternalException(this.getResource(ctx, "PROJECT_NUMBER_NOT_NULL"));
            }
            if (info.getNumber() != null) {
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS));
                ev.setFilter(filter);
                ev.getSelector().add(new SelectorItemInfo("id"));
                ProjectCollection col = ProjectFactory.getLocalInstance(ctx).getProjectCollection(ev);
                if (col.size() > 0) {
                    throw new TaskExternalException(this.getResource(ctx, "PROJECT_IS_EXITS"));
                }
            }
            if (info.getName() == null) {
                throw new TaskExternalException(this.getResource(ctx, "PROJECT_NAME_CANT_NULL"));
            }
            boolean hasTotalTime = false;
            boolean hasBeginTime = false;
            boolean hasEndTime = false;
            int inputNum = 0;
            if (info.getTotalTime().compareTo(ZERO) > 0) {
                hasTotalTime = true;
                ++inputNum;
            }
            if (info.getPlanBeginTime() != null) {
                hasBeginTime = true;
                ++inputNum;
            }
            if (info.getPlanEndTime() != null) {
                hasEndTime = true;
                ++inputNum;
            }
            this.mmCalendar = new MMProjectCalendarFactory(ctx, null);
            if (inputNum < 2) {
                throw new TaskExternalException(this.getResource(ctx, "PROJECT_AT_LEASE_TWO"));
            }
            if (inputNum == 2) {
                if (hasTotalTime && hasBeginTime) {
                    Date dFrom = this.mmCalendar.getWorkdate(info.getPlanBeginTime());
                    Date dTo = this.mmCalendar.addWroklength(dFrom, info.getTotalTime().intValue());
                    info.setPlanEndTime(new Timestamp(dTo.getTime()));
                } else if (hasTotalTime && hasEndTime) {
                    Date dTo = this.mmCalendar.getWorkdate(info.getPlanEndTime());
                    Date dFrom = this.mmCalendar.addWroklength(dTo, info.getTotalTime().intValue() * -1);
                    info.setPlanBeginTime(new Timestamp(dFrom.getTime()));
                } else {
                    Timestamp dTo = info.getPlanEndTime();
                    Timestamp dFrom = info.getPlanBeginTime();
                    int time = this.mmCalendar.getWorklength(dFrom, dTo);
                    info.setTotalTime(new BigDecimal(time));
                }
            } else {
                Timestamp dFrom;
                Timestamp dTo = info.getPlanEndTime();
                int time = this.mmCalendar.getWorklength(dTo, dFrom = info.getPlanBeginTime());
                if (time != info.getTotalTime().intValue()) {
                    throw new TaskExternalException(this.getResource(ctx, "PROJECT_TOTALTIME_MUST_DAYU"));
                }
            }
            if (info.getCurrency() == null) {
                throw new TaskExternalException(this.getResource(ctx, "PROJECT_CURRENTY_IS_NOT_NULL"));
            }
            if (info.getProjectOrg().size() == 0) {
                throw new TaskExternalException(this.getResource(ctx, "PROJECTORG_IS_NOT_NULL"));
            }
            if (this.compareDate(info.getPlanBeginTime(), info.getPlanEndTime())) {
                throw new TaskExternalException(this.getResource(ctx, "ENDTIME_GREAT_BEGINTIME"));
            }
            if (info.getEaristBeginTime() != null && info.getEaristEndTime() != null && this.compareDate(info.getEaristBeginTime(), info.getEaristEndTime())) {
                throw new TaskExternalException(this.getResource(ctx, "EARLSTCMPTIME_LESS_EARLISTWORKTIME"));
            }
            if (info.getLastBeginTime() != null && info.getLastEndTime() != null && info.getEaristBeginTime() != null && this.compareDate(info.getEaristBeginTime(), info.getLastBeginTime())) {
                throw new TaskExternalException(this.getResource(ctx, "LASTCMPTIME_LESS_LASTWORKTIME"));
            }
            BigDecimal sum = info.getQty().multiply(info.getUnitCost()).setScale(2, 4);
            if (sum.compareTo(info.getTotalCost()) != 0) {
                throw new TaskExternalException(this.getResource(ctx, "PROJECT_DEVEI_QTY"));
            }
            Boolean result = Boolean.FALSE;
            if (ctx.get((Object)"isTemplate") != null) {
                result = (Boolean)ctx.get((Object)"isTemplate");
            }
            info.setIsTemplate(result);
            if (info.getAdminOrgUnit() != null && info.getPerson() != null) {
                this.personIsExitAdminCU(ctx, info.getPerson().getNumber(), info.getAdminOrgUnit().getNumber());
            }
            if (result.booleanValue()) {
                info.getCarNumberRange().clear();
            }
            IProjectCalendar iprojectcalendar = ProjectCalendarFactory.getLocalInstance(ctx);
            iprojectcalendar.getProjectCalendar();
            ProjectCalendarInfo projectcalendarInfo = (ProjectCalendarInfo)iprojectcalendar.getValue((IObjectPK)new ObjectUuidPK("nz4fwnlKQs2UUNYLZfS4U5nUdmw="));
            info.setProjectCalendar(projectcalendarInfo);
            super.submit((CoreBaseInfo)info, ctx);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        Hashtable innerTable;
        if (hsData == null || hsData.isEmpty()) {
            return null;
        }
        ProjectInfo pro = null;
        for (Map.Entry entry : hsData.entrySet()) {
            innerTable = (Hashtable)entry.getValue();
            String tempNumber = this.getDataString(innerTable, "FNumber");
            if (pro != null) continue;
            pro = new ProjectInfo();
            try {
                this.setHeadValue(ctx, pro, innerTable);
                break;
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        for (Map.Entry entry : hsData.entrySet()) {
            innerTable = (Hashtable)entry.getValue();
            if (pro == null) continue;
            try {
                this.setEntryValue(ctx, pro, innerTable);
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        return pro;
    }

    private void setEntryValue(Context ctx, ProjectInfo pro, Hashtable innerTable) throws TaskExternalException, Exception {
        String deliveryPlanModel;
        String deliveryEndTN;
        String deliveryStartTN;
        String deliveryLevel;
        String deliveryEndTime;
        String deliveryOrg;
        String deliveryQty;
        String deliveryModel;
        String deliveryMaterial;
        String carnumber = this.getDataString(innerTable, "FCarNumberRange$trackNumber_number");
        TrackNumberInfo trackinfo = this.getTrackNumber(ctx, carnumber);
        ProjectCarInfo carinfo = new ProjectCarInfo();
        carinfo.setTrackNumber(trackinfo);
        if (trackinfo != null && !this.judgeCarNumber(carinfo, pro.getCarNumberRange())) {
            this.tackNumberIsExitCU(ctx, trackinfo.getNumber(), pro.getCU().getNumber());
            pro.getCarNumberRange().add(carinfo);
        }
        String orgnumber = this.getDataString(innerTable, "FProjectOrg$storageOrgUnit_number");
        StorageOrgUnitInfo storageOrgUnit = this.getStorageOrgUnit(ctx, orgnumber);
        ProjectOrgInfo projectorg = new ProjectOrgInfo();
        projectorg.setStorageOrgUnit(storageOrgUnit);
        if (storageOrgUnit != null && !this.judgeOrgNumber(projectorg, pro.getProjectOrg())) {
            pro.getProjectOrg().add(projectorg);
        }
        String centralPurOrgsStorageOrgUnit_number = this.getDataString(innerTable, "FCentralPurOrgs$storageOrgUnit_number");
        StorageOrgUnitInfo storageOrgUnit1 = this.getStorageOrgUnit(ctx, centralPurOrgsStorageOrgUnit_number);
        ProjectCentralPurOrgInfo purOrginfo = new ProjectCentralPurOrgInfo();
        purOrginfo.setStorageOrgUnit(storageOrgUnit1);
        if (storageOrgUnit1 != null && !this.judgeOrgNumber(purOrginfo, pro.getCentralPurOrgs())) {
            pro.getCentralPurOrgs().add(purOrginfo);
        }
        ProjectDeliveryEntryInfo deliveryentry = new ProjectDeliveryEntryInfo();
        String deliveryType = this.getDataString(innerTable, "FDeliveryEntry_deliveryType");
        if (deliveryType != null && !deliveryType.equals("")) {
            deliveryentry.setDeliveryType(DeliveryTypeEnum.getEnum((String)deliveryType));
        }
        if ((deliveryMaterial = this.getDataString(innerTable, "FDeliveryEntry$material_number")) != null && !deliveryMaterial.equals("")) {
            deliveryentry.setMaterial(this.getMaterialInfo(ctx, deliveryMaterial));
        }
        if ((deliveryModel = this.getDataString(innerTable, "FDeliveryEntry$productModel_number")) != null && !deliveryModel.equals("")) {
            deliveryentry.setProductModel(this.getVehicleTypeInfo(ctx, deliveryModel));
        }
        if ((deliveryQty = this.getDataString(innerTable, "FDeliveryEntry_qty")) != null && !deliveryQty.equals("")) {
            deliveryentry.setQty(new BigDecimal(deliveryQty));
        }
        if ((deliveryOrg = this.getDataString(innerTable, "FDeliveryEntry$storageOrgUnit_number")) != null && !deliveryOrg.equals("")) {
            deliveryentry.setStorageOrgUnit(this.getStorageOrgUnit(ctx, deliveryOrg));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String deliveryStartTime = this.getDataString(innerTable, "FDeliveryEntry_startTime");
        if (deliveryStartTime != null && !deliveryStartTime.equals("")) {
            deliveryentry.setStartTime(new Timestamp(sdf.parse(deliveryStartTime).getTime()));
        }
        if ((deliveryEndTime = this.getDataString(innerTable, "FDeliveryEntry_endTime")) != null && !deliveryEndTime.equals("")) {
            deliveryentry.setEndTime(new Timestamp(sdf.parse(deliveryEndTime).getTime()));
        }
        if ((deliveryLevel = this.getDataString(innerTable, "FDeliveryEntry_priorLevel")) != null && !deliveryLevel.equals("")) {
            deliveryentry.setPriorLevel(Integer.valueOf(deliveryLevel).intValue());
        }
        if ((deliveryStartTN = this.getDataString(innerTable, "FDeliveryEntry$startTrackNumber_number")) != null && !deliveryStartTN.equals("")) {
            deliveryentry.setStartTrackNumber(this.getTrackNumber(ctx, deliveryStartTN));
        }
        if ((deliveryEndTN = this.getDataString(innerTable, "FDeliveryEntry$endTrackNumber_number")) != null && !deliveryEndTN.equals("")) {
            deliveryentry.setEndTrackNumber(this.getTrackNumber(ctx, deliveryEndTN));
        }
        if ((deliveryPlanModel = this.getDataString(innerTable, "FDeliveryEntry$projectPlanModel_number")) != null && !deliveryPlanModel.equals("")) {
            deliveryentry.setProjectPlanModel(this.getPlanModelInfo(ctx, deliveryPlanModel));
        }
        pro.getDeliveryEntry().add(deliveryentry);
    }

    private boolean judgeCarNumber(ProjectCarInfo carinfo, ProjectCarCollection cols) {
        ProjectCarInfo carnumber = null;
        if (cols != null) {
            for (int i = 0; i < cols.size(); ++i) {
                carnumber = cols.get(i);
                if (!carinfo.getTrackNumber().getNumber().equals(carnumber.getTrackNumber().getNumber())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean judgeOrgNumber(ProjectOrgInfo projectorg, ProjectOrgCollection cols) {
        ProjectOrgInfo carnumber = null;
        if (cols != null) {
            for (int i = 0; i < cols.size(); ++i) {
                carnumber = cols.get(i);
                if (!projectorg.getStorageOrgUnit().getNumber().equals(carnumber.getStorageOrgUnit().getNumber())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean judgeOrgNumber(ProjectCentralPurOrgInfo projectorg, ProjectCentralPurOrgCollection cols) {
        ProjectCentralPurOrgInfo carnumber = null;
        if (cols != null) {
            for (int i = 0; i < cols.size(); ++i) {
                carnumber = cols.get(i);
                if (!projectorg.getStorageOrgUnit().getNumber().equals(carnumber.getStorageOrgUnit().getNumber())) continue;
                return true;
            }
        }
        return false;
    }

    protected TrackNumberInfo getTrackNumber(Context ctx, String number) throws BOSException, TaskExternalException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.getSelector().add(new SelectorItemInfo("adminCU"));
        ev.getSelector().add(new SelectorItemInfo("number"));
        if (number != null && !number.equals("")) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            ev.setFilter(filter);
            TrackNumberCollection col = TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberCollection(ev);
            if (col.size() > 0) {
                TrackNumberInfo info = col.get(0);
                return info;
            }
            throw new TaskExternalException(this.getResource(ctx, "PROJECTCARIS_NOT_EXIT"));
        }
        return null;
    }

    protected void setHeadValue(Context ctx, ProjectInfo pro, Hashtable innerTable) throws TaskExternalException, BOSException, EASBizException, ParseException {
        String certainty;
        String controlDimension;
        BigDecimal bQty;
        BigDecimal bTotalCost;
        BigDecimal bUnitCost;
        block38: {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            BigDecimal ZERO = new BigDecimal("0.00");
            CtrlUnitInfo info = this.getCU(ctx, this.getDataString(innerTable, "FAdminCU_number"));
            pro.setCU(info);
            pro.setAdminCU(info);
            String number = this.getDataString(innerTable, "FNumber");
            if (number.length() >= 80) {
                throw new TaskExternalException(this.getResource(ctx, "RPOJECTNUMBER_IS"));
            }
            if (number == null || number.equals("")) {
                throw new TaskExternalException(this.getResource(ctx, "PROJECT_NUMBER_NOT_NULL"));
            }
            pro.setNumber(number);
            String name = this.getDataString(innerTable, "FName_l2");
            if (name == null || name.equals("") || name.length() > 255) {
                throw new TaskExternalException(this.getResource(ctx, "PROJECT_NAME_CANT_NULL"));
            }
            pro.setName(name);
            String status = this.getDataString(innerTable, "FBaseStatus");
            if (status != null) {
                if ("\u4fdd\u5b58".equals(status)) {
                    pro.setBaseStatus(MMBaseStatusEnum.SAVED);
                } else if ("\u63d0\u4ea4".equals(status)) {
                    pro.setBaseStatus(MMBaseStatusEnum.SUBMIT);
                } else if ("\u5ba1\u6838".equals(status)) {
                    pro.setBaseStatus(MMBaseStatusEnum.AUDIT);
                } else {
                    pro.setBaseStatus(MMBaseStatusEnum.getEnum((String)status));
                }
            }
            String groupNumber = this.getDataString(innerTable, "FGroup_number");
            ProjectGroupInfo projectGroupInfo = this.getProjectGroupInfo(ctx, groupNumber);
            pro.setGroup(projectGroupInfo);
            String material_number = this.getDataString(innerTable, "FMaterial_number");
            MaterialInfo materialInfo = this.getMaterialInfo(ctx, material_number);
            pro.setMaterial(materialInfo);
            if (materialInfo != null) {
                String baseUnit_number = this.getDataString(innerTable, "FBaseUnit_number");
                MeasureUnitInfo measureUnitInfo = this.getMeasureUnitInfo(ctx, baseUnit_number);
                pro.setBaseUnit(measureUnitInfo);
            } else {
                pro.setQty(ZERO);
            }
            String adminOrgUnit_number = this.getDataString(innerTable, "FAdminOrgUnit_number");
            AdminOrgUnitInfo adminOrgUnitInfo = this.getAdminOrgUnitInfo(ctx, adminOrgUnit_number);
            pro.setAdminOrgUnit(adminOrgUnitInfo);
            String person_number = this.getDataString(innerTable, "FPerson_number");
            PersonInfo personInfo = this.getPersonInfo(ctx, person_number);
            pro.setPerson(personInfo);
            String projectType_number = this.getDataString(innerTable, "FProjectType_name_l2");
            ProjectTypesInfo item = this.getProjectTypesInfo(ctx, projectType_number);
            pro.setProjectTypes(item);
            ProjectPriorityEnum penum = this.getProjectPriorityEnum(this.getDataString(innerTable, "FPriority"));
            if (penum != null) {
                pro.setPriority(penum);
            }
            BigDecimal totalTime = null;
            if (!StringUtils.isEmpty((String)this.getDataString(innerTable, "FTotalTime"))) {
                totalTime = new BigDecimal(this.getDataString(innerTable, "FTotalTime"));
            }
            if (totalTime != null) {
                pro.setTotalTime(totalTime);
            } else {
                pro.setTotalTime(ZERO);
            }
            try {
                String lastEndTime;
                String lastBeginTime;
                String earistEndTime;
                String earistBeginTime;
                String planEndTime;
                String planBeginTime = this.getDataString(innerTable, "FPlanBeginTime");
                if (planBeginTime != null && !planBeginTime.equals("")) {
                    Timestamp time = new Timestamp(sdf.parse(planBeginTime).getTime());
                    pro.setPlanBeginTime(time);
                }
                if ((planEndTime = this.getDataString(innerTable, "FPlanEndTime")) != null && !planEndTime.equals("")) {
                    Timestamp time = new Timestamp(sdf.parse(planEndTime).getTime());
                    pro.setPlanEndTime(time);
                }
                if ((earistBeginTime = this.getDataString(innerTable, "FEaristBeginTime")) != null && !earistBeginTime.equals("")) {
                    Timestamp time = new Timestamp(sdf.parse(earistBeginTime).getTime());
                    pro.setEaristBeginTime(time);
                }
                if ((earistEndTime = this.getDataString(innerTable, "FEaristEndTime")) != null && !earistEndTime.equals("")) {
                    Timestamp time = new Timestamp(sdf.parse(earistEndTime).getTime());
                    pro.setEaristEndTime(time);
                }
                if ((lastBeginTime = this.getDataString(innerTable, "FLastBeginTime")) != null && !lastBeginTime.equals("")) {
                    Timestamp time = new Timestamp(sdf.parse(lastBeginTime).getTime());
                    pro.setLastBeginTime(time);
                }
                if ((lastEndTime = this.getDataString(innerTable, "FLastEndTime")) != null && !lastEndTime.equals("")) {
                    Timestamp time = new Timestamp(sdf.parse(lastEndTime).getTime());
                    pro.setLastEndTime(time);
                }
            }
            catch (Exception e) {
                if (!(e instanceof ParseException)) break block38;
                throw new TaskExternalException(this.getResource(ctx, "TIME_FORMAT_ERROR"));
            }
        }
        String currency_number = this.getDataString(innerTable, "FCurrency_number");
        CurrencyInfo currencyInfo = this.getCurrencyInfo(ctx, currency_number);
        pro.setCurrency(currencyInfo);
        String qty = this.getDataString(innerTable, "FQty");
        String unitCost = this.getDataString(innerTable, "FUnitCost");
        String totalCost = this.getDataString(innerTable, "FTotalCost");
        int notNullNum = 0;
        if (!StringUtil.isEmpty((String)qty)) {
            ++notNullNum;
        }
        if (!StringUtil.isEmpty((String)unitCost)) {
            ++notNullNum;
        }
        if (!StringUtil.isEmpty((String)totalCost)) {
            ++notNullNum;
        }
        if (notNullNum < 2) {
            throw new TaskExternalException(this.getResource(ctx, "QTY_UNITCOST_TOTALCOST"));
        }
        if (notNullNum == 2) {
            if (StringUtil.isEmpty((String)qty)) {
                bUnitCost = new BigDecimal(unitCost);
                bTotalCost = new BigDecimal(totalCost);
                bQty = bTotalCost.divide(bUnitCost);
            } else if (StringUtil.isEmpty((String)unitCost)) {
                bQty = new BigDecimal(qty);
                bTotalCost = new BigDecimal(totalCost);
                bUnitCost = bTotalCost.divide(bQty);
            } else {
                bQty = new BigDecimal(qty);
                bUnitCost = new BigDecimal(unitCost);
                bTotalCost = bQty.multiply(bUnitCost);
            }
        } else {
            bQty = new BigDecimal(qty);
            bUnitCost = new BigDecimal(unitCost);
            bTotalCost = new BigDecimal(totalCost);
            BigDecimal testTotalCost = bQty.multiply(bUnitCost);
            if (testTotalCost.compareTo(bTotalCost) != 0) {
                throw new TaskExternalException(this.getResource(ctx, "QTY_UNITCOST_TOTALCOST_RELATIONSHIP"));
            }
        }
        pro.setQty(bQty);
        pro.setUnitCost(bUnitCost);
        pro.setTotalCost(bTotalCost);
        String setuporgnumber = this.getDataString(innerTable, "FSetUpStorageOrg_number");
        if (setuporgnumber != null) {
            StorageOrgUnitInfo storageOrgUnit = this.getStorageOrgUnit(ctx, setuporgnumber);
            pro.setSetUpStorageOrg(storageOrgUnit);
        }
        if ((controlDimension = this.getDataString(innerTable, "FControlDimension")) != null) {
            pro.setControlDimension(ControlDimensionEnum.getEnum(controlDimension));
        }
        if ((certainty = this.getDataString(innerTable, "FCertainty")) != null) {
            pro.setCertainty(CertaintyEnum.getEnum((String)certainty));
        }
    }

    private ProjectPriorityEnum getProjectPriorityEnum(String value) {
        if (value != null && !value.equals("")) {
            if (value.equals(ProjectPriorityEnum.A + "")) {
                return ProjectPriorityEnum.A;
            }
            if (value.equals(ProjectPriorityEnum.B + "")) {
                return ProjectPriorityEnum.B;
            }
            if (value.equals(ProjectPriorityEnum.C + "")) {
                return ProjectPriorityEnum.C;
            }
            if (value.equals(ProjectPriorityEnum.D + "")) {
                return ProjectPriorityEnum.D;
            }
        }
        return null;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        DataToken fndt = (DataToken)firstData.get("FNumber");
        String firstNumber = (String)fndt.data;
        DataToken ctdt = (DataToken)currentData.get("FNumber");
        String currentFnumber = (String)ctdt.data;
        if (firstData != null && currentData != null && firstNumber.equals(currentFnumber)) {
            return true;
        }
        return firstData != null && currentData != null && (currentFnumber == null || currentFnumber.length() == 0);
    }

    protected CurrencyInfo getCurrencyInfo(Context ctx, String name) throws BOSException, TaskExternalException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (name != null && !name.equals("")) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)name, CompareType.EQUALS));
            ev.setFilter(filter);
            CurrencyCollection col = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(ev);
            if (col.size() > 0) {
                CurrencyInfo info = col.get(0);
                return info;
            }
            throw new TaskExternalException(this.getResource(ctx, "PROJECT_NOT_IXCEZT_CURRYE"));
        }
        return null;
    }

    protected ProjectTypesInfo getProjectTypesInfo(Context ctx, String name) throws BOSException, TaskExternalException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (name != null) {
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)name, CompareType.EQUALS));
            ev.setFilter(filter);
            ev.getSelector().add(new SelectorItemInfo("id"));
            ev.getSelector().add(new SelectorItemInfo("name"));
            ev.getSelector().add(new SelectorItemInfo("number"));
            ProjectTypesCollection col = ProjectTypesFactory.getLocalInstance((Context)ctx).getProjectTypesCollection(ev);
            if (col.size() > 0) {
                ProjectTypesInfo info = col.get(0);
                return info;
            }
            throw new TaskExternalException(this.getResource(ctx, "PROJECT_NOT_LEIXING"));
        }
        return null;
    }

    protected DataSubmitModeEnum getDataSubmitMode() {
        return DataSubmitModeEnum.ORMAPPING;
    }

    protected CoreBaseInfo toCoreBaseInfo(Context ctx, IRecord rec) {
        return null;
    }

    protected PersonInfo getPersonInfo(Context ctx, String number) throws BOSException, TaskExternalException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (number != null && !number.equals("")) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            ev.setFilter(filter);
            ev.getSelector().add(new SelectorItemInfo("id"));
            ev.getSelector().add(new SelectorItemInfo("name"));
            ev.getSelector().add(new SelectorItemInfo("number"));
            PersonCollection col = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(ev);
            if (col.size() > 0) {
                PersonInfo info = col.get(0);
                return info;
            }
            throw new TaskExternalException(this.getResource(ctx, "PROJECT_PESON_IS_NOT"));
        }
        return null;
    }

    protected AdminOrgUnitInfo getAdminOrgUnitInfo(Context ctx, String number) throws BOSException, TaskExternalException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (number != null && !number.equals("")) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            ev.setFilter(filter);
            ev.getSelector().add(new SelectorItemInfo("id"));
            ev.getSelector().add(new SelectorItemInfo("name"));
            ev.getSelector().add(new SelectorItemInfo("number"));
            AdminOrgUnitCollection col = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(ev);
            if (col.size() > 0) {
                AdminOrgUnitInfo info = col.get(0);
                return info;
            }
            throw new TaskExternalException(this.getResource(ctx, "PROJECT_ADMIN_IS_NOT_NULL"));
        }
        return null;
    }

    protected MeasureUnitInfo getMeasureUnitInfo(Context ctx, String number) throws BOSException, TaskExternalException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (number != null && !number.equals("")) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            ev.setFilter(filter);
            ev.getSelector().add(new SelectorItemInfo("id"));
            ev.getSelector().add(new SelectorItemInfo("name"));
            ev.getSelector().add(new SelectorItemInfo("number"));
            MeasureUnitCollection cos = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection(ev);
            if (cos.size() > 0) {
                MeasureUnitInfo info = cos.get(0);
                return info;
            }
            throw new TaskExternalException(this.getResource(ctx, "PRJECT_UNIT_NOT_EXTIT"));
        }
        return null;
    }

    protected String getDataString(Hashtable hsData, String key) {
        DataToken dataToken = (DataToken)hsData.get(key);
        if (dataToken == null) {
            System.err.println(key + "not exist");
            return null;
        }
        String number = (String)dataToken.data;
        return number;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            if (rs.getString("CU.NUMBER") != null) {
                this.putTable(result, "FAdminCU_number", rs.getString("CU.NUMBER"));
            }
            if (rs.getString("number") != null) {
                this.putTable(result, "FNumber", rs.getString("number"));
            }
            if (rs.getString("name") != null) {
                this.putTable(result, "FName_l2", rs.getString("name"));
            }
            if (rs.getString("group.number") != null) {
                this.putTable(result, "FGroup_number", rs.getString("group.number"));
            }
            if (rs.getString("material.number") != null) {
                this.putTable(result, "FMaterial_number", rs.getString("material.number"));
            }
            if (rs.getString("unit.number") != null) {
                this.putTable(result, "FBaseUnit_number", rs.getString("unit.number"));
            }
            if (rs.getBigDecimal("qty") != null) {
                this.putTable(result, "FQty", rs.getBigDecimal("qty"));
            }
            if (rs.getBigDecimal("totalQty") != null) {
                this.putTable(result, "FTotalQty", rs.getBigDecimal("totalQty"));
            }
            if (rs.getBigDecimal("completePercent") != null) {
                this.putTable(result, "FCompletePercent", rs.getBigDecimal("completePercent"));
            }
            if (rs.getString("adminOrgUnit.number") != null) {
                this.putTable(result, "FAdminOrgUnit_number", rs.getString("adminOrgUnit.number"));
            }
            if (rs.getString("person.number") != null) {
                this.putTable(result, "FPerson_number", rs.getString("person.number"));
            }
            this.putTable(result, "FBaseStatus", MMBaseStatusEnum.getEnum((int)rs.getInt("baseStatus")) + "");
            if (rs.getString("projectType.name") != null) {
                this.putTable(result, "FProjectType_name_l2", rs.getString("projectType.name"));
            }
            if (rs.getString("storageOrgUnit1.number") != null) {
                this.putTable(result, "FCentralPurOrgs$storageOrgUnit_number", rs.getString("storageOrgUnit1.number"));
            }
            this.putTable(result, "FPriority", ProjectPriorityEnum.getEnum((int)rs.getInt("priority")) + "");
            if (rs.getBigDecimal("totalTime") != null) {
                this.putTable(result, "FTotalTime", rs.getBigDecimal("totalTime"));
            }
            if (rs.getTimestamp("planBeginTime") != null) {
                this.putTable(result, "FPlanBeginTime", sdf.format(rs.getTimestamp("planBeginTime")));
            }
            if (rs.getTimestamp("planEndTime") != null) {
                this.putTable(result, "FPlanEndTime", sdf.format(rs.getTimestamp("planEndTime")));
            }
            if (rs.getTimestamp("earistBeginTime") != null) {
                this.putTable(result, "FEaristBeginTime", sdf.format(rs.getTimestamp("earistBeginTime")));
            }
            if (rs.getTimestamp("earistEndTime") != null) {
                this.putTable(result, "FEaristEndTime", sdf.format(rs.getTimestamp("earistEndTime")));
            }
            if (rs.getTimestamp("lastBeginTime") != null) {
                this.putTable(result, "FLastBeginTime", sdf.format(rs.getTimestamp("lastBeginTime")));
            }
            if (rs.getTimestamp("lastEndTime") != null) {
                this.putTable(result, "FLastEndTime", sdf.format(rs.getTimestamp("lastEndTime")));
            }
            if (rs.getTimestamp("actualBeginTime") != null) {
                this.putTable(result, "FActualBeginTime", sdf.format(rs.getTimestamp("actualBeginTime")));
            }
            if (rs.getTimestamp("actualEndTime") != null) {
                this.putTable(result, "FActualEndTime", sdf.format(rs.getTimestamp("actualEndTime")));
            }
            if (rs.getBigDecimal("actualTotalTime") != null) {
                this.putTable(result, "FActualTotalTime", rs.getBigDecimal("actualTotalTime"));
            }
            if (rs.getString("currency.number") != null) {
                this.putTable(result, "FCurrency_number", rs.getString("currency.number"));
            }
            if (rs.getBigDecimal("unitCost") != null) {
                this.putTable(result, "FUnitCost", rs.getBigDecimal("unitCost"));
            }
            if (rs.getBigDecimal("totalCost") != null) {
                this.putTable(result, "FTotalCost", rs.getBigDecimal("totalCost"));
            }
            if (rs.getString("trackNumber.number") != null) {
                this.putTable(result, "FCarNumberRange$trackNumber_number", rs.getString("trackNumber.number"));
            }
            if (rs.getString("storageOrgUnit.number") != null) {
                this.putTable(result, "FProjectOrg$storageOrgUnit_number", rs.getString("storageOrgUnit.number"));
            }
            if (rs.getString("setUpStorageOrg.number") != null) {
                this.putTable(result, "FSetUpStorageOrg_number", rs.getString("setUpStorageOrg.number"));
            }
            if (rs.getString("controlDimension") != null) {
                this.putTable(result, "FControlDimension", rs.getString("controlDimension"));
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    protected StorageOrgUnitInfo getStorageOrgUnit(Context ctx, String orgNumber) throws TaskExternalException {
        try {
            IStorageOrgUnit isou = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if (orgNumber != null && !orgNumber.equals("")) {
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)orgNumber, CompareType.EQUALS));
                ev.setFilter(filter);
                ev.getSelector().add(new SelectorItemInfo("id"));
                ev.getSelector().add(new SelectorItemInfo("name"));
                ev.getSelector().add(new SelectorItemInfo("number"));
                ev.getSelector().add(new SelectorItemInfo("isBizUnit"));
                StorageOrgUnitCollection cols = isou.getStorageOrgUnitCollection(ev);
                if (cols.size() > 0) {
                    StorageOrgUnitInfo orgInfo = cols.get(0);
                    if (orgInfo.isIsBizUnit()) {
                        return orgInfo;
                    }
                    throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.mm.basedata.StandardRootResource", (String)"StorageOrgUnit_IsNotBizUnit", (Context)ctx));
                }
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.mm.basedata.StandardRootResource", (String)"StorageOrgUnit_Not_Exist", (Context)ctx));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected CtrlUnitInfo getCU(Context ctx, String orgNumber) throws TaskExternalException {
        try {
            ICtrlUnit isou = CtrlUnitFactory.getLocalInstance((Context)ctx);
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if (orgNumber != null) {
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)orgNumber, CompareType.EQUALS));
                ev.setFilter(filter);
                ev.getSelector().add(new SelectorItemInfo("id"));
                ev.getSelector().add(new SelectorItemInfo("name"));
                ev.getSelector().add(new SelectorItemInfo("number"));
                CtrlUnitCollection cols = isou.getCtrlUnitCollection(ev);
                if (cols.size() > 0) {
                    CtrlUnitInfo orgInfo = cols.get(0);
                    return orgInfo;
                }
                throw new TaskExternalException(this.getResource(ctx, "PROJECT_WS_CU_NOT"));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected ProjectGroupInfo getProjectGroupInfo(Context ctx, String orgNumber) throws TaskExternalException, BOSException, EASBizException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (orgNumber != null) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)orgNumber, CompareType.EQUALS));
            ev.setFilter(filter);
            ev.getSelector().add(new SelectorItemInfo("id"));
            ev.getSelector().add(new SelectorItemInfo("name"));
            ev.getSelector().add(new SelectorItemInfo("number"));
            ProjectGroupCollection cols = ProjectGroupFactory.getLocalInstance(ctx).getProjectGroupCollection(ev);
            if (cols.size() > 0) {
                ProjectGroupInfo info = cols.get(0);
                return info;
            }
            ProjectGroupInfo info = ProjectGroupFactory.getLocalInstance(ctx).getProjectGroupInfo((IObjectPK)new ObjectUuidPK("K8Er4JuzTpys1ipFv+b8dkLK+hE="));
            return info;
        }
        ProjectGroupInfo info = ProjectGroupFactory.getLocalInstance(ctx).getProjectGroupInfo((IObjectPK)new ObjectUuidPK("K8Er4JuzTpys1ipFv+b8dkLK+hE="));
        return info;
    }

    private void strogeIsExitCU(Context ctx, String number, String cuNumber) throws Exception {
        if (number != null && cuNumber != null) {
            StringBuffer sql = new StringBuffer();
            sql.append("");
            sql.append("");
            sql.append("");
            sql.append("");
            sql.append("");
            sql.append("");
            sql.append("");
            sql.append("");
            sql.append("");
            sql.append("");
            sql.append("");
            sql.append("");
            sql.append("");
        }
    }

    private void tackNumberIsExitCU(Context ctx, String number, String adminNumber) throws Exception {
        if (number != null && adminNumber != null) {
            StringBuffer sql = new StringBuffer();
            sql.append(" select TRACKNUMBER.fid   ");
            sql.append(" FROM T_MM_TrackNumber  as TRACKNUMBER");
            sql.append(" INNER JOIN T_ORG_CtrlUnit AS ADMINCU ");
            sql.append(" ON TRACKNUMBER.FAdminCUID = ADMINCU.FID ");
            sql.append(" where TRACKNUMBER.fnumber='").append(number).append("' ");
            sql.append(" and ADMINCU.fnumber='").append(adminNumber).append("'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs != null && rs.size() == 0) {
                throw new TaskExternalException(number + "  " + this.getResource(ctx, "PROJECT_TACKNUMBER_NOT_EXTITY"));
            }
            sql.setLength(0);
            sql.append(" select distinct tracknumber.fid  from T_MM_ProjectCar  as car ");
            sql.append(" left outer join T_MM_TrackNumber tracknumber ");
            sql.append(" on car.FTrackNumberID = tracknumber.fid ");
            sql.append("where tracknumber.fnumber in('").append(number).append("')");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs != null && rs.size() == 1) {
                throw new TaskExternalException(number + "  " + this.getResource(ctx, "PROJECT_TRACK_NOT_YIN"));
            }
        }
    }

    private void personIsExitAdminCU(Context ctx, String personNumber, String adminNumber) throws Exception {
        if (personNumber != null && adminNumber != null) {
            StringBuffer sql = new StringBuffer();
            sql.append(" select PERSON.fid   ");
            sql.append(" from T_BD_Person as PERSON ");
            sql.append("  INNER JOIN T_ORG_PositionMember AS POSITIONMEMBER ");
            sql.append("  ON PERSON.FID = POSITIONMEMBER.FPersonID ");
            sql.append("  INNER JOIN T_ORG_Position AS POSITION   ");
            sql.append(" ON POSITIONMEMBER.FPositionID = POSITION.FID ");
            sql.append(" INNER JOIN T_ORG_Admin  as  ADMINORGUNIT ");
            sql.append(" ON POSITION.FAdminOrgUnitID = ADMINORGUNIT.FID  ");
            sql.append(" where PERSON.fnumber='").append(personNumber).append("' ");
            sql.append(" and ADMINORGUNIT.fnumber='").append(adminNumber).append("'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs != null && rs.size() == 0) {
                throw new TaskExternalException(personNumber + "  " + this.getResource(ctx, "PROJECT_ADMINI_NUMBER"));
            }
        }
    }

    protected MaterialInfo getMaterialInfo(Context ctx, String number) throws TaskExternalException {
        try {
            IMaterial ibiz = MaterialFactory.getLocalInstance((Context)ctx);
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if (number != null && !number.equals("")) {
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("status", (Object)UsedStatusEnum.APPROVED, CompareType.EQUALS));
                ev.setFilter(filter);
                ev.getSelector().add(new SelectorItemInfo("id"));
                ev.getSelector().add(new SelectorItemInfo("name"));
                ev.getSelector().add(new SelectorItemInfo("number"));
                MaterialCollection cols = ibiz.getMaterialCollection(ev);
                if (cols.size() > 0) {
                    MaterialInfo orgInfo = cols.get(0);
                    return orgInfo;
                }
                throw new TaskExternalException(this.getResource(ctx, "PROJECT_MATERIL_NOT_IXITIE"));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected VehicleTypeInfo getVehicleTypeInfo(Context ctx, String number) throws TaskExternalException {
        try {
            IVehicleType ibiz = VehicleTypeFactory.getLocalInstance((Context)ctx);
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if (number != null && !number.equals("")) {
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
                ev.setFilter(filter);
                ev.getSelector().add(new SelectorItemInfo("id"));
                ev.getSelector().add(new SelectorItemInfo("name"));
                ev.getSelector().add(new SelectorItemInfo("number"));
                VehicleTypeCollection cols = ibiz.getVehicleTypeCollection(ev);
                if (cols.size() > 0) {
                    VehicleTypeInfo vehicleTypeInfo = cols.get(0);
                    return vehicleTypeInfo;
                }
                throw new TaskExternalException("\u4ea7\u54c1\u578b\u53f7\u4e0d\u5b58\u5728");
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected ProjectPlanModelInfo getPlanModelInfo(Context ctx, String number) throws TaskExternalException {
        try {
            IProjectPlanModel ibiz = ProjectPlanModelFactory.getLocalInstance((Context)ctx);
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if (number != null && !number.equals("")) {
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
                ev.setFilter(filter);
                ev.getSelector().add(new SelectorItemInfo("id"));
                ev.getSelector().add(new SelectorItemInfo("name"));
                ev.getSelector().add(new SelectorItemInfo("number"));
                ProjectPlanModelCollection cols = ibiz.getProjectPlanModelCollection(ev);
                if (cols.size() > 0) {
                    ProjectPlanModelInfo planModelInfo = cols.get(0);
                    return planModelInfo;
                }
                throw new TaskExternalException("\u9879\u76ee\u8ba1\u5212\u6a21\u578b\u4e0d\u5b58\u5728");
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public String getResource(Context ctx, String strKey) {
        String resource = resources;
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return SCMUtils.getResource((String)resource, (String)strKey, (Context)ctx);
    }

    public boolean compareDate(Date start, Date end) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        int startDay = Integer.parseInt(dateFormat.format(start).toString());
        int endDay = Integer.parseInt(dateFormat.format(end).toString());
        boolean result = false;
        if (endDay - startDay < 0) {
            result = true;
        }
        return result;
    }

    public int getWorkData(Date dateFrom, Date dateTo) {
        int workdays = 0;
        Calendar c1 = Calendar.getInstance();
        c1.setTime(dateFrom);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(dateTo);
        if (c2.getTimeInMillis() > c1.getTimeInMillis()) {
            workdays = (int)((c2.getTimeInMillis() - c1.getTimeInMillis()) / 1000L / 60L / 60L / 24L) + 1;
        }
        if (workdays == 0) {
            workdays = 1;
        }
        return workdays;
    }

    public Date getWorkDataByInt(Date dateFrom, int workdatas) {
        Date dataTo = new Date();
        if (workdatas <= 1) {
            return dateFrom;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateFrom);
        cal.add(5, workdatas - 1);
        dataTo = cal.getTime();
        return dataTo;
    }
}

