/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.project.app.ReportUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import java.awt.Color;
import java.util.HashMap;
import java.util.Locale;

public class ProjectProblemReport
extends ReportServerBase {
    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        String tempTableNameMain;
        StringBuffer createTableMain = this.getTempTableMain();
        try {
            tempTableNameMain = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTableMain.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        DbUtil.execute((Context)this.getContext(), (String)this.insertTempTable(tempTableNameMain, filter));
        return tempTableNameMain;
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions reportFormatConditions = new ReportFormatConditions();
        Appearance red = new Appearance();
        Appearance yellow = new Appearance();
        red.backColor = Color.RED;
        yellow.backColor = Color.YELLOW;
        reportFormatConditions.add("FUrgent", 1, (Object)this.getResource("DANGER"), red, false);
        reportFormatConditions.add("FUrgent", 1, (Object)this.getResource("CRITICAL"), yellow, false);
        return reportFormatConditions;
    }

    private String buildTempSelectResult(RptParams filter, String parm) throws BaseException {
        Locale locale = this.getContext().getLocale();
        StringBuffer sb = new StringBuffer();
        sb.append("Select ");
        sb.append("       case tmp.furgent ");
        sb.append("       when 10 then '" + this.getResource("NORMAL") + "' ");
        sb.append("       when 20 then '" + this.getResource("CRITICAL") + "' ");
        sb.append("       when 30 then '" + this.getResource("DANGER") + "' ");
        sb.append("       end  FUrgent, ");
        sb.append("       tmp.storagename  FStorageName,");
        sb.append("       tmp.tasktype  FTaskType,");
        sb.append("       tmp.tasknumber  FTaskNum,");
        sb.append("       tmp.projectnum  FProjectNum,");
        sb.append("       t3.fnumber  FMaterial,");
        sb.append("       t3.fname_" + locale + " as FMaterialName,");
        sb.append("       t4.fname_" + locale + " FAdminOrgUnit,");
        sb.append("       t5.fname_" + locale + " FPerson,");
        sb.append("       tmp.milestone  FMileStone,");
        sb.append("       tochar(tmp.fbizdate,'yyyy-mm-dd')  FBizDate,");
        sb.append("       tmp.fcontent  FContent,");
        sb.append("       tmp.fwbsnumber  FWBS,");
        sb.append("       tmp.billnum  FNumber,");
        sb.append("       case tmp.fbasestatus ");
        sb.append("       when 0 then '" + this.getResource("ADDNEW") + "' ");
        sb.append("       when 1 then '" + this.getResource("SAVED") + "' ");
        sb.append("       when 2 then '" + this.getResource("SUBMIT") + "' ");
        sb.append("       when 4 then '" + this.getResource("AUDIT") + "' ");
        sb.append("       when 5 then '" + this.getResource("RELEASED") + "' ");
        sb.append("       when 7 then '" + this.getResource("CLOSED") + "' ");
        sb.append("       when 50 then '" + this.getResource("FORBID") + "' ");
        sb.append("       end  FBillStatus, ");
        sb.append("       tmp.creator  FCreator,");
        sb.append("       to_char(tmp.fcreatetime,'yyyy-mm-dd')  FCreateTime,");
        sb.append("       tmp.parentID  FParentID,");
        sb.append("       tmp.FID  FID");
        sb.append("  from (select t.fprojectid,");
        sb.append("               t.Fprojecttaskid,");
        sb.append("               isnull(t2.FmaterialID, t1.FmaterialID) FMaterialID,");
        sb.append("               isnull(t2.FPERSONID, t1.FPersonID) FPersonID,");
        sb.append("               isnull(t2.FADMINORGUNITID, t1.FADMINORGUNITID) FadminOrgUnitID,");
        sb.append("               t2.fnumber as tasknumber,");
        sb.append("               t2.fname_" + locale + " as taskname,");
        sb.append("               t2.ftasktypeid,");
        sb.append("               t6.fname_" + locale + " as tasktype,");
        sb.append("               t2.FISMILESTONE as milestone,");
        sb.append("               t1.fnumber as projectnum,");
        sb.append("               t.furgent,");
        sb.append("               t.Fbizdate,");
        sb.append("               t.fcontent,");
        sb.append("               t.fbasestatus,");
        sb.append("               t2.fwbsnumber,");
        sb.append("               t.fcreatorid,");
        sb.append("               to_date(tochar(t.fcreatetime,'yyyy-mm-dd HH24:MI:SS')) fcreatetime ,");
        sb.append("               t7.fname_" + locale + " as creator,");
        sb.append("               t.FNumber as billnum,");
        sb.append("               t8.fname_" + locale + " as storagename,");
        sb.append("               t2.FID as parentID,");
        sb.append("               t.FID  FID");
        sb.append("          from t_mm_projectProblem AS t");
        sb.append("          LEFT OUTER JOIN T_MM_PROJECT AS t1 ON t.FProjectID = t1.FID");
        sb.append("          LEFT OUTER JOIN T_MM_ProjectTask AS t2 ON t.FProjectTaskID =");
        sb.append("                                                      t2.FID");
        sb.append("          LEFT OUTER JOIN T_MM_ProjectDictData AS t6 ON t2.FTaskTypeID =");
        sb.append("                                                          t6.FID");
        sb.append("          LEFT OUTER JOIN T_PM_USER AS t7 ON t.FCreatorID = t7.FID");
        sb.append("          LEFT OUTER JOIN T_ORG_Storage AS t8 ON t.FStorageOrgUnitID = t8.FID");
        sb.append("          WHERE ");
        if (parm != null && !"".equals(parm)) {
            sb.append(" (t2.FPARENTID ='" + parm + "' and  t8.FNumber in (" + ReportUtil.StringUtil(filter.getString("storageOrgUnit.number")) + "))");
        } else {
            sb.append(" ((t2.FPARENTID is null and  t8.FNumber in (" + ReportUtil.StringUtil(filter.getString("storageOrgUnit.number")) + "))");
            sb.append(" or (t2.FPARENTID is not null and t8.FNumber not in (" + ReportUtil.StringUtil(filter.getString("storageOrgUnit.number")) + "))");
            sb.append(" ) ");
        }
        if (filter.getString("bizBillNumF") != null && filter.getString("bizBillNumF").length() > 0) {
            sb.append("      and t.FNumber in (" + ReportUtil.StringUtil(filter.getString("bizBillNumF")) + " )");
        }
        if (filter.getString("project.numberF") != null && filter.getString("project.numberF").length() > 0) {
            sb.append("      and t1.FNumber in ( " + ReportUtil.StringUtil(filter.getString("project.numberF")) + " ) ");
        }
        if (filter.getString("task.numberF") != null && filter.getString("task.numberF").length() > 0) {
            sb.append("      and t2.FNumber in (" + ReportUtil.StringUtil(filter.getString("task.numberF")) + ") ");
        }
        sb.append("\t\t\t   ) tmp");
        sb.append("  LEFT OUTER JOIN T_BD_Material AS t3 ON tmp.FMaterialID = t3.FID");
        sb.append("  LEFT OUTER JOIN T_ORG_Admin AS t4 ON tmp.FadminOrgUnitID = t4.FID");
        sb.append("  LEFT OUTER JOIN T_BD_Person AS t5 ON tmp.FPersonID = t5.FID");
        sb.append(this.buildWhereFilters(filter));
        return sb.toString();
    }

    private String buildWhereFilters(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append(" where ");
        if (filter.getString("dateF") != null && !"".equals(filter.getString("dateF")) && filter.getString("dateT") != null && !"".equals(filter.getString("dateT"))) {
            String dateF = filter.getString("dateF");
            String dateT = filter.getString("dateT");
            if (dateT.length() > 10) {
                dateT = dateT.substring(0, 10) + " 23:59:59.0";
            }
            sb.append(" tmp.fbizdate >= to_date('" + dateF + "') and tmp.fbizdate <= to_date('" + dateT + "')");
        }
        if (filter.getString("normal") != null && "true".equals(filter.getString("normal"))) {
            sb.append(" and ( tmp.furgent = 10 ");
        }
        if (filter.getString("normal") != null && "true".equals(filter.getString("normal")) && filter.getString("critical") != null && "true".equals(filter.getString("critical"))) {
            sb.append(" or tmp.furgent = 20 ");
        } else if (filter.getString("normal") != null && "false".equals(filter.getString("normal")) && filter.getString("critical") != null && "true".equals(filter.getString("critical"))) {
            sb.append(" and ( tmp.furgent = 20 ");
        }
        if (filter.getString("danger") != null && "true".equals(filter.getString("danger"))) {
            if (filter.getString("normal") != null && "true".equals(filter.getString("normal")) || filter.getString("critical") != null && "true".equals(filter.getString("critical"))) {
                sb.append(" or tmp.furgent = 30");
            } else {
                sb.append(" and ( tmp.furgent = 30");
            }
        }
        sb.append(" )");
        if (filter.getString("save") != null && "true".equals(filter.getString("save"))) {
            sb.append(" and ( tmp.fbasestatus = 1");
        }
        if (filter.getString("audit") != null && "true".equals(filter.getString("audit"))) {
            if (filter.getString("save") != null && "true".equals(filter.getString("save"))) {
                sb.append(" or tmp.fbasestatus = 4");
            } else {
                sb.append(" and ( tmp.fbasestatus = 4");
            }
        }
        if (filter.getString("forbid") != null && "true".equals(filter.getString("forbid"))) {
            if (filter.getString("save") != null && "true".equals(filter.getString("save")) || filter.getString("audit") != null && "true".equals(filter.getString("audit"))) {
                sb.append(" or tmp.fbasestatus = 50");
            } else {
                sb.append(" and ( tmp.fbasestatus = 50");
            }
        }
        sb.append(" )");
        return sb.toString();
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("Select FUrgent , ");
        sb.append("       FstorageName , ");
        sb.append("       FTaskType , ");
        sb.append("       FTaskNum , ");
        sb.append("\t\t  FProjectNum , ");
        sb.append("\t\t  FMaterial , ");
        sb.append("\t\t  FMaterialName , ");
        sb.append("       FAdminOrgUnit , ");
        sb.append("       FPerson , ");
        sb.append("       FMileStone , ");
        sb.append("       FBizDate , ");
        sb.append("       FContent , ");
        sb.append("       FWBS , ");
        sb.append("       FNumber , ");
        sb.append("       FBillStatus , ");
        sb.append("       FCreator , ");
        sb.append("       FCreateTime , ");
        sb.append("       FID ");
        sb.append("FROM " + tableName);
        sb.append(" where KSQL_seq >");
        sb.append(new Integer(start).toString());
        sb.append(" and KSQL_seq <=");
        sb.append(new Integer(start + rows).toString());
        sb.append(" order by FUrgent desc");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sb.toString());
        return rs;
    }

    public IRowSet getHiberarchyData(String reportID, RptParams filter, HashMap rowData) throws BaseException {
        String parentID = (String)rowData.get("FPARENTID");
        String sql = this.buildTempSelectResult(filter, parentID);
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql);
        return rs;
    }

    protected IRowSet getReportData(String arg0, RptParams filter) throws Exception {
        IRowSet rs = null;
        rs = DbUtil.executeQuery((Context)this.getContext(), (String)this.buildTempSelectResult(filter, ""));
        return rs;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BaseException {
        Locale locale = this.getContext().getLocale();
        String storageNumber = "";
        if (filter.getString("storageOrgUnit.number") != null && !"".equals(filter.getString("storageOrgUnit.number"))) {
            storageNumber = ReportUtil.StringUtil(filter.getString("storageOrgUnit.number"));
            StringBuffer sb = new StringBuffer();
            sb.append("select FName_" + locale + " from T_ORG_Storage storage where storage.FNumber");
            sb.append(" in (" + storageNumber + ")");
            storageNumber = ReportUtil.getNameByNumber(sb, storageNumber, this.getContext());
        }
        String projectNum = "";
        if (filter.getString("project.numberF") != null && !"".equals("project.numberF")) {
            projectNum = ReportUtil.StringUtil(filter.getString("project.numberF"));
            StringBuffer sb = new StringBuffer();
            sb.append("select FName_" + locale + " from T_MM_Project project where project.FNumber");
            sb.append(" in (" + projectNum + ")");
            projectNum = ReportUtil.getNameByNumber(sb, projectNum, this.getContext());
        }
        String dateF = "";
        if (filter.getString("dateF") != null && !"".equals(filter.getString("dateF"))) {
            dateF = filter.getString("dateF").substring(0, 10);
        }
        String dateT = "";
        if (filter.getString("dateT") != null && !"".equals(filter.getString("dateT"))) {
            dateT = filter.getString("dateT").substring(0, 10);
        }
        ReportTitles titles = new ReportTitles();
        titles.AddTitle(0, this.getResource("STORAGEOURUNIT") + storageNumber);
        titles.AddTitle(3, this.getResource("PROJECT") + projectNum);
        titles.AddTitle(6, this.getResource("DATEFROM") + dateF);
        titles.AddTitle(7, this.getResource("DATETO") + dateT);
        return titles;
    }

    public String getResource(String strKey) {
        return ResourceBase.getString((String)"com.kingdee.eas.mm.project.ProjectProblemResource", (String)strKey, (Locale)this.getLocale());
    }

    private Locale getLocale() {
        return this.getContext().getLocale();
    }

    protected StringBuffer getTempTableMain() {
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table getProjectProblemReportResult (");
        createTable.append("KSQL_SEQ INT IDENTITY (1, 1) not null");
        createTable.append(",FUrgent        varchar(44)  ");
        createTable.append(",FStorageName   varchar(255) ");
        createTable.append(",FTaskType      varchar(44)  ");
        createTable.append(",FTaskNum       varchar(44)  ");
        createTable.append(",FProjectNum    varchar(44)  ");
        createTable.append(",FMaterial      varchar(44)  ");
        createTable.append(",FMaterialName  varchar(255) ");
        createTable.append(",FAdminOrgUnit  varchar(44)  ");
        createTable.append(",FPerson        varchar(44)  ");
        createTable.append(",FMileStone     int DEFAULT(0)");
        createTable.append(",FBizDate       DATETIME      ");
        createTable.append(",FContent       varchar(1000) ");
        createTable.append(",FWBS           Nvarchar(300) ");
        createTable.append(",FNumber        Nvarchar(80) ");
        createTable.append(",FBillStatus    Nvarchar(255) ");
        createTable.append(",FCreator       varchar(44) ");
        createTable.append(",FCreateTime    DATETIME  ");
        createTable.append(",FID            varchar(44)  ");
        createTable.append(" ) ");
        return createTable;
    }

    private String insertTempTable(String tempTableNameMain, RptParams filter) throws BaseException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into  " + tempTableNameMain + "( KSQL_SEQ ,FUrgent , FStorageName ,FTaskType , FTaskNum ,FProjectNum , FMaterial , FMaterialName ,FAdminOrgUnit , FPerson , FMileStone ,FBizDate ,FContent ,FWBS ,FNumber , FBillStatus , FCreator , FCreateTime , FID )\n");
        sql.append(this.buildTempSelectResult(filter, ""));
        return sql.toString();
    }

    private String setFilter(String sql, String parentID) {
        sql = sql.replaceFirst("and t2.FParentID is null", "and t2.FParentID = '" + parentID + "'  ");
        return sql;
    }
}

