/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.MMBaseStatusEnum;
import com.kingdee.eas.mm.common.MMCommonException;
import com.kingdee.eas.mm.common.app.CommonUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.planning.CentralPurReqPlanFacadeFactory;
import com.kingdee.eas.mm.planning.ICentralPurReqPlanFacade;
import com.kingdee.eas.mm.planning.IReqPlanForProjectTaskFacade;
import com.kingdee.eas.mm.planning.ReqPlanForProjectTaskFacadeFactory;
import com.kingdee.eas.mm.project.BOM2WBSFacadeFactory;
import com.kingdee.eas.mm.project.IProjectTask;
import com.kingdee.eas.mm.project.IWBSRuler;
import com.kingdee.eas.mm.project.ProjectException;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.mm.project.ProjectTaskException;
import com.kingdee.eas.mm.project.ProjectTaskFactory;
import com.kingdee.eas.mm.project.ProjectTaskInfo;
import com.kingdee.eas.mm.project.WBSException;
import com.kingdee.eas.mm.project.WBSInfo;
import com.kingdee.eas.mm.project.WBSRulerFactory;
import com.kingdee.eas.mm.project.app.AbstractProjectTaskControllerBean;
import com.kingdee.eas.mm.project.app.ProjectCalendarFacadeControllerBean;
import com.kingdee.eas.mm.project.util.MMProjectCalendarFactory;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.sm.pur.IPurRequest;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ProjectTaskControllerBean
extends AbstractProjectTaskControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.project.app.ProjectTaskControllerBean");
    private final String cr = "\r\n";

    private void checkProjectStatus(Context ctx, String projectid) throws BOSException, EASBizException {
        String check = "select FBaseStatus from t_mm_project where FID='" + projectid + "'";
        IRowSet set = DBUtil.executeQuery((Context)ctx, (String)check);
        try {
            int status;
            if (set.next() && 4 != (status = set.getInt("FBaseStatus"))) {
                throw new WBSException(WBSException.PROJECT_NOT_AUDIT);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectTaskInfo projectTaskInfo = (ProjectTaskInfo)model;
        ProjectTaskInfo parent = projectTaskInfo.getParent();
        IWBSRuler iWBSRuler = WBSRulerFactory.getLocalInstance(ctx);
        WBSInfo wbsInfo = null;
        BOSUuid projectID = projectTaskInfo.getProject().getId();
        this.checkProjectStatus(ctx, projectID.toString());
        wbsInfo = parent != null ? iWBSRuler.getNextWBS(projectID.toString(), parent.getId().toString(), 1)[0] : iWBSRuler.getNextWBS(projectID.toString(), null, 1)[0];
        projectTaskInfo.setWbsNumber(wbsInfo.getWBS());
        projectTaskInfo.setLevel(wbsInfo.getLevel());
        projectTaskInfo.setSeq(wbsInfo.getSeq());
        projectTaskInfo.setNextSeq(1);
        return super._addnew(ctx, (IObjectValue)projectTaskInfo);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectTaskInfo projectTaskInfo = (ProjectTaskInfo)model;
        if (projectTaskInfo.getProject() == null) {
            throw new WBSException(WBSException.NULL, new String[]{ProjectTaskControllerBean.getResource(ctx, "PROJECT_NOT_NULL")});
        }
        if (projectTaskInfo.getStorageOrgUnit() == null) {
            throw new WBSException(WBSException.NULL, new String[]{ProjectTaskControllerBean.getResource(ctx, "STORAGEORGUNIT_CANT_NULL")});
        }
        projectTaskInfo.setBaseStatus(MMBaseStatusEnum.SAVED);
        return super._save(ctx, (IObjectValue)projectTaskInfo);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ProjectTaskInfo projectTaskInfo = (ProjectTaskInfo)model;
        ProjectTaskInfo parent = projectTaskInfo.getParent();
        boolean isChanged = false;
        isChanged = this.isParentChanged(ctx, parent, projectTaskInfo.getId().toString(), projectTaskInfo);
        if (isChanged) {
            this.updateTask(ctx, projectTaskInfo, parent);
        }
        super._update(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectTaskInfo projectTaskInfo = (ProjectTaskInfo)model;
        if (!projectTaskInfo.getBaseStatus().equals((Object)MMBaseStatusEnum.SUBMITCOST)) {
            projectTaskInfo.setBaseStatus(MMBaseStatusEnum.SUBMIT);
        }
        return super._submit(ctx, (IObjectValue)projectTaskInfo);
    }

    private ProjectTaskInfo updateTask(Context ctx, ProjectTaskInfo task, ProjectTaskInfo parent) throws BOSException, EASBizException {
        ProjectTaskInfo result = task;
        IWBSRuler iWBSRuler = WBSRulerFactory.getLocalInstance(ctx);
        WBSInfo wbsInfo = null;
        BOSUuid projectID = result.getProject().getId();
        wbsInfo = parent != null ? iWBSRuler.getNextWBS(projectID.toString(), parent.getId().toString(), 1)[0] : iWBSRuler.getNextWBS(projectID.toString(), null, 1)[0];
        result.setWbsNumber(wbsInfo.getWBS());
        result.setLevel(wbsInfo.getLevel());
        result.setSeq(wbsInfo.getSeq());
        return result;
    }

    private WBSInfo getWbs(ProjectTaskInfo theTaskNode, ProjectTaskInfo toTaskNode) {
        String toTaskNodeWBS = toTaskNode.getWbsNumber();
        int pos = toTaskNodeWBS.lastIndexOf(".");
        String lastGroup = toTaskNodeWBS.substring(pos + 1);
        WBSInfo wbsInfo = new WBSInfo();
        wbsInfo.setDelimitor(".");
        wbsInfo.setLevel(theTaskNode.getLevel());
        wbsInfo.setSeq(theTaskNode.getSeq());
        wbsInfo.setDigists(lastGroup.length());
        return wbsInfo;
    }

    @Override
    protected void _moveTaskNode(Context ctx, String projectID, String toNodeID, String theNodeID, boolean isAfter) throws BOSException, EASBizException {
        IProjectTask iTask = ProjectTaskFactory.getLocalInstance(ctx);
        ProjectTaskInfo toTask = iTask.getProjectTaskInfo((IObjectPK)new ObjectUuidPK(toNodeID));
        ProjectTaskInfo theTask = iTask.getProjectTaskInfo((IObjectPK)new ObjectUuidPK(theNodeID));
        this.moveTaskNodeLocal(ctx, projectID, toTask, theTask, isAfter);
    }

    public void moveTaskNodeLocal(Context ctx, String projectID, ProjectTaskInfo toTaskNode, ProjectTaskInfo theTaskNode, boolean isAfter) throws BOSException {
        Connection con = null;
        Statement statement = null;
        ResultSet followSet = null;
        ResultSet parentSet = null;
        ArrayList<String> batchSqls = new ArrayList<String>();
        boolean postMove = true;
        int parentNextSeq = 0;
        int levelOffset = 0;
        try {
            String updateChildSql = null;
            con = this.getConnection(ctx);
            statement = con.createStatement();
            ProjectTaskInfo parentNode = null;
            String theNodeOldWBS = theTaskNode.getWbsNumber();
            String findParentSql = null;
            findParentSql = toTaskNode.getLevel() == 1 ? this.getRootSQL(projectID, "FID,FWbsNumber, FNextSeq,FLevel") : "select FID,FWbsNumber, FNextSeq,FLevel from T_MM_ProjectTask where FID ='" + toTaskNode.getParent().getId().toString() + "'";
            parentSet = statement.executeQuery(findParentSql);
            if (parentSet.next()) {
                parentNode = new ProjectTaskInfo();
                parentNode.setId(BOSUuid.read((String)parentSet.getString("FID")));
                parentNode.setWbsNumber(parentSet.getString("FWbsNumber"));
                parentNode.setNextSeq(parentSet.getInt("FNextSeq"));
                parentNode.setLevel(parentSet.getInt("FLevel"));
                parentNextSeq = parentSet.getInt("FNextSeq");
            }
            if (theTaskNode.getLevel() != toTaskNode.getLevel()) {
                ++parentNextSeq;
            } else if (theTaskNode.getSeq() < toTaskNode.getSeq()) {
                ++parentNextSeq;
            } else {
                postMove = false;
            }
            levelOffset = toTaskNode.getLevel() - theTaskNode.getLevel();
            theTaskNode.setSeq(toTaskNode.getSeq() + (isAfter ? 1 : 0));
            if (theTaskNode.getSeq() == 0) {
                theTaskNode.setSeq(1);
            }
            StringBuffer lockSql = new StringBuffer("");
            lockSql.append("update T_MM_ProjectTask set FNextSeq = FNextSeq where FID = '");
            if (parentNode != null) {
                lockSql.append("" + parentNode.getId().toString() + "'");
            }
            statement.execute(lockSql.toString());
            theTaskNode.setLevel(toTaskNode.getLevel());
            WBSInfo newWbsInfo = this.getWbs(theTaskNode, toTaskNode);
            this.checkWBSOutOfBounds(theTaskNode.getSeq(), newWbsInfo.getDigists());
            if (toTaskNode.getLevel() == 1) {
                theTaskNode.setParent(null);
                theTaskNode.setWbsNumber(newWbsInfo.getWBS());
            } else if (parentNode != null && newWbsInfo != null) {
                theTaskNode.setWbsNumber(parentNode.getWbsNumber() + "." + newWbsInfo.getWBS());
            }
            if (theTaskNode.getNextSeq() > 1) {
                int wbsNumberLength = theNodeOldWBS.length();
                int fromPos = wbsNumberLength + 1;
                if (postMove && toTaskNode.getLevel() != 1) {
                    updateChildSql = levelOffset >= 0 ? "update T_MM_ProjectTask set FWbsNumber ='" + theTaskNode.getWbsNumber() + "'||SUBSTRING(FWbsNumber," + fromPos + ", len(FWbsNumber) - " + wbsNumberLength + "),FLevel=FLevel + " + levelOffset + " where FWbsNumber like '" + theNodeOldWBS + "'||'.%' and FProjectID ='" + projectID + "'" : "update T_MM_ProjectTask set FWbsNumber ='" + theTaskNode.getWbsNumber() + "'||SUBSTRING(FWbsNumber," + fromPos + ", len(FWbsNumber) - " + wbsNumberLength + "),FLevel=FLevel - " + Math.abs(levelOffset) + " where FWbsNumber like '" + theNodeOldWBS + "'||'.%' and FProjectID ='" + projectID + "'";
                } else {
                    updateChildSql = levelOffset >= 0 ? "update T_MM_ProjectTask set FWbsNumber ='" + theTaskNode.getWbsNumber() + "'||SUBSTRING(FWbsNumber," + ("temp".length() + 1) + ", len(FWbsNumber) - " + "temp".length() + "),FLevel=FLevel + " + levelOffset + " where FWbsNumber like 'temp'||'.%' and FProjectID ='" + projectID + "'" : "update T_MM_ProjectTask set FWbsNumber ='" + theTaskNode.getWbsNumber() + "'||SUBSTRING(FWbsNumber," + ("temp".length() + 1) + ", len(FWbsNumber) - " + "temp".length() + "),FLevel=FLevel - " + Math.abs(levelOffset) + " where FWbsNumber like 'temp'||'.%' and FProjectID ='" + projectID + "'";
                    String updateChildTemp = "update T_MM_ProjectTask set FWbsNumber ='temp'||SUBSTRING(FWbsNumber," + fromPos + ", len(FWbsNumber) - " + wbsNumberLength + ") where FWbsNumber like '" + theNodeOldWBS + "'||'.%' and FProjectID ='" + projectID + "'";
                    statement.execute(updateChildTemp);
                }
                batchSqls.add(updateChildSql);
            }
            if (parentNode != null && theTaskNode.getSeq() != parentNode.getNextSeq()) {
                String followNodeSql = null;
                followNodeSql = parentNode != null && parentNode.getLevel() == 0 ? "select FID,FSeq,FWbsNumber from T_MM_ProjectTask where FProjectID='" + projectID + "' and FLevel=1  and FSeq >= " + theTaskNode.getSeq() + " order by FSeq asc" : "select FID,FSeq,FWbsNumber from T_MM_ProjectTask where FProjectID='" + projectID + "' and FParentID='" + parentNode.getId().toString() + "'  and FSeq >= " + theTaskNode.getSeq() + " order by FSeq asc";
                followSet = statement.executeQuery(followNodeSql);
                int nextSeq = theTaskNode.getSeq() + 1;
                while (followSet.next()) {
                    StringBuffer updateSef = new StringBuffer("");
                    String wbs = null;
                    String FID = followSet.getString("FID");
                    int tempSeq = followSet.getInt("FSeq");
                    String oldWbs = followSet.getString("FWbsNumber");
                    ProjectTaskInfo info = new ProjectTaskInfo();
                    info.setSeq(nextSeq);
                    wbs = toTaskNode.getLevel() == 1 ? this.getWbs(info, toTaskNode).getWBS() : parentNode.getWbsNumber() + "." + this.getWbs(info, toTaskNode).getWBS();
                    if (FID.equalsIgnoreCase(theTaskNode.getId().toString()) || tempSeq >= nextSeq) continue;
                    updateSef.append("update T_MM_ProjectTask set FSeq=");
                    updateSef.append(nextSeq);
                    updateSef.append(",FWbsNumber ='");
                    updateSef.append(wbs);
                    updateSef.append("' where FID='");
                    updateSef.append(FID);
                    updateSef.append("'");
                    batchSqls.add(updateSef.toString());
                    int wbsNumberLength = oldWbs.length();
                    int fromPos = wbsNumberLength + 1;
                    StringBuffer updateFollowChild = new StringBuffer("");
                    updateFollowChild.append("update T_MM_ProjectTask set FWbsNumber ='");
                    updateFollowChild.append(wbs);
                    updateFollowChild.append("'||SUBSTRING(FWbsNumber,");
                    updateFollowChild.append(fromPos);
                    updateFollowChild.append(", len(FWbsNumber) - ");
                    updateFollowChild.append(wbsNumberLength);
                    updateFollowChild.append(")  where FWbsNumber like '");
                    updateFollowChild.append(oldWbs);
                    updateFollowChild.append("'||'.%' and FProjectID ='");
                    updateFollowChild.append(projectID);
                    updateFollowChild.append("'");
                    batchSqls.add(updateFollowChild.toString());
                    ++nextSeq;
                }
            }
            if (parentNode != null && parentNode.getId() != null) {
                StringBuffer updateParent = new StringBuffer("");
                updateParent.append("update T_MM_ProjectTask set FNextSeq = ");
                updateParent.append(parentNextSeq);
                updateParent.append(" where FID = '");
                updateParent.append(parentNode.getId().toString());
                updateParent.append("'");
                batchSqls.add(updateParent.toString());
            }
            StringBuffer updateOwn = new StringBuffer("");
            updateOwn.append("update T_MM_ProjectTask set FSeq=");
            updateOwn.append(theTaskNode.getSeq());
            updateOwn.append(",FParentID=");
            if (theTaskNode.getParent() != null) {
                updateOwn.append("'" + theTaskNode.getParent().getId().toString() + "'");
            } else {
                updateOwn.append("null");
            }
            updateOwn.append(",FWbsNumber='");
            updateOwn.append(theTaskNode.getWbsNumber());
            updateOwn.append("',FLevel=");
            updateOwn.append(theTaskNode.getLevel());
            updateOwn.append(" where FID='");
            updateOwn.append(theTaskNode.getId().toString());
            updateOwn.append("'");
            batchSqls.add(updateOwn.toString());
            for (int i = batchSqls.size() - 1; i >= 0; --i) {
                statement.addBatch(batchSqls.get(i).toString());
            }
            statement.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(followSet);
                SQLUtils.cleanup(parentSet);
                SQLUtils.cleanup(statement);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)followSet);
        SQLUtils.cleanup((ResultSet)parentSet);
        SQLUtils.cleanup((Statement)statement);
        SQLUtils.cleanup((Connection)con);
    }

    private void checkWBSOutOfBounds(int seq, int digists) throws WBSException {
        if ((double)seq > Math.pow(10.0, digists) - 1.0) {
            throw new WBSException(WBSException.WBSSEQ_OUTOFBOUNDS);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String _indentNode(Context ctx, String projectId, String parentId, String theTaskID) throws BOSException, EASBizException {
        String string;
        int fromPos;
        int levelOffset;
        String oldWBS;
        ProjectTaskInfo theTask;
        ProjectTaskInfo parent;
        int digists;
        int level;
        ResultSet set;
        Statement statement;
        Connection con;
        block10: {
            block11: {
                con = null;
                statement = null;
                set = null;
                level = 0;
                digists = 0;
                IProjectTask iTask = ProjectTaskFactory.getLocalInstance(ctx);
                parent = iTask.getProjectTaskInfo((IObjectPK)new ObjectUuidPK(parentId));
                theTask = iTask.getProjectTaskInfo((IObjectPK)new ObjectUuidPK(theTaskID));
                con = this.getConnection(ctx);
                statement = con.createStatement();
                oldWBS = theTask.getWbsNumber();
                levelOffset = 0;
                fromPos = oldWBS.length() + 1;
                levelOffset = parent.getLevel() >= theTask.getLevel() ? 1 : -1;
                if (levelOffset < 0) break block10;
                Timestamp parentBegin = parent.getPlanBeginTime();
                Timestamp beginTime = theTask.getPlanBeginTime();
                if (!beginTime.before(parentBegin)) break block11;
                String string2 = ProjectTaskControllerBean.getResource(ctx, "CHILD_BEGINTIME_BEFORE_FATHER");
                SQLUtils.cleanup((Statement)statement);
                SQLUtils.cleanup((Connection)con);
                return string2;
            }
            Timestamp parentEnd = parent.getPlanEndTime();
            Timestamp endTime = theTask.getPlanEndTime();
            if (!parentEnd.before(endTime)) break block10;
            String string3 = ProjectTaskControllerBean.getResource(ctx, "CHILD_ENDTIME_AFTER_FATHER");
            SQLUtils.cleanup((Statement)statement);
            SQLUtils.cleanup((Connection)con);
            return string3;
        }
        try {
            theTask.setSeq(parent.getNextSeq());
            theTask.setLevel(theTask.getLevel() + levelOffset);
            level = parent.getLevel() + 1;
            String sqlWBSRuler = null;
            sqlWBSRuler = level > 9 ? "select max(FDigists) FDigists from T_MM_WBSRuler where FProjectID= '" + projectId + "'" : "select FDigists from T_MM_WBSRuler where FProjectID= '" + projectId + "' and FLEVEL = " + level;
            set = statement.executeQuery(sqlWBSRuler);
            if (set.next()) {
                digists = set.getInt("FDigists");
            }
            this.checkWBSOutOfBounds(theTask.getSeq(), digists);
            WBSInfo wbsInfo = new WBSInfo();
            wbsInfo.setParentWBS(parent.getWbsNumber());
            wbsInfo.setLevel(level);
            wbsInfo.setSeq(theTask.getSeq());
            wbsInfo.setDigists(digists);
            String newWBS = wbsInfo.getWBS();
            theTask.setWbsNumber(newWBS);
            String lockSql = "update T_MM_ProjectTask set FNextSeq = FNextSeq where FID = '" + parent.getId().toString() + "'";
            statement.execute(lockSql);
            StringBuffer updateParent = new StringBuffer("");
            updateParent.append("update T_MM_ProjectTask set FNextSeq = FNextSeq + 1");
            updateParent.append(" where FID = '");
            updateParent.append(parent.getId().toString());
            updateParent.append("'");
            statement.addBatch(updateParent.toString());
            String updateChildSql = "";
            updateChildSql = levelOffset >= 0 ? "update T_MM_ProjectTask set FWbsNumber ='" + theTask.getWbsNumber() + "'||SUBSTRING(FWbsNumber," + fromPos + ", len(FWbsNumber) - " + oldWBS.length() + "),FLevel=FLevel + " + levelOffset + " where FWbsNumber like '" + oldWBS + "'||'.%' and FProjectID ='" + projectId + "'" : "update T_MM_ProjectTask set FWbsNumber ='" + theTask.getWbsNumber() + "'||SUBSTRING(FWbsNumber," + fromPos + ", len(FWbsNumber) - " + oldWBS.length() + "),FLevel=FLevel - " + Math.abs(levelOffset) + " where FWbsNumber like '" + oldWBS + "'||'.%' and FProjectID ='" + projectId + "'";
            statement.addBatch(updateChildSql);
            StringBuffer updateOwn = new StringBuffer("");
            updateOwn.append("update T_MM_ProjectTask set FSeq=");
            updateOwn.append(parent.getNextSeq());
            updateOwn.append(",FParentID=");
            if (parent.getLevel() != 0) {
                updateOwn.append("'" + parent.getId().toString() + "'");
            } else {
                updateOwn.append("null");
            }
            updateOwn.append(",FWbsNumber='");
            updateOwn.append(theTask.getWbsNumber());
            updateOwn.append("',FLevel=");
            updateOwn.append(level);
            updateOwn.append(" where FID='");
            updateOwn.append(theTask.getId().toString());
            updateOwn.append("'");
            statement.addBatch(updateOwn.toString());
            statement.executeBatch();
            string = null;
        }
        catch (EASBizException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement);
        SQLUtils.cleanup((Connection)con);
        return string;
    }

    private String getRootSQL(String projectId, String cols) {
        StringBuffer getRootSQL = new StringBuffer("");
        getRootSQL.append("select ");
        getRootSQL.append(cols);
        getRootSQL.append(" from T_MM_ProjectTask ");
        getRootSQL.append("where FProjectID = '");
        getRootSQL.append(projectId);
        getRootSQL.append("' and FLevel = 0");
        return getRootSQL.toString();
    }

    @Override
    protected ProjectTaskInfo _getRootProject(Context ctx, String projectId) throws BOSException, EASBizException {
        ProjectTaskInfo projectTaskInfo;
        String locStr = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        Connection con = null;
        Statement statement = null;
        ResultSet set = null;
        ProjectTaskInfo projectTask = null;
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            StringBuffer getRootSQL = new StringBuffer("");
            String field = "FID,FName_" + locStr + ",FWbsNumber,FTotalTime,FIsMileStone,FPlanBeginTime,FPlanEndTime ";
            getRootSQL.append(this.getRootSQL(projectId, field));
            set = statement.executeQuery(getRootSQL.toString());
            if (set.next()) {
                projectTask = new ProjectTaskInfo();
                projectTask.setId(BOSUuid.read((String)set.getString("FID")));
                projectTask.setName(set.getString("FName_" + locStr));
                projectTask.setWbsNumber(set.getString("FWbsNumber"));
                projectTask.setTotalTime(set.getBigDecimal("FTotalTime"));
                projectTask.setIsMileStone(set.getBoolean("FIsMileStone"));
                projectTask.setPlanBeginTime(set.getTimestamp("FPlanBeginTime"));
                projectTask.setPlanEndTime(set.getTimestamp("FPlanEndTime"));
            }
            projectTaskInfo = projectTask;
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(set, statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)set, (Statement)statement, (Connection)con);
        return projectTaskInfo;
    }

    protected void delete(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        String[] sqls = new String[]{"DELETE FROM T_MM_ProjectTask WHERE FID in (" + idStr + ")"};
        SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
    }

    public void batchCheck(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        this.checkTaskInChanging(ctx, batchResults);
        if (batchAction.equals((Object)BatchActionEnum.DELETE)) {
            this.childCheck4Delete(ctx, batchResults);
        } else if (batchAction.equals((Object)BatchActionEnum.SAVE)) {
            this.saveCheck(ctx, batchResults);
        } else if (batchAction.equals((Object)BatchActionEnum.SUBMIT)) {
            this.submitCheck(ctx, batchResults);
        } else if (batchAction.equals((Object)BatchActionEnum.UNAUDIT)) {
            this.checkProjectIsClose(ctx, batchResults);
            this.checkProjectTastkIsNotAudit(ctx, batchResults);
            this.checkProjectTastkPreTask(ctx, batchResults);
        } else if (batchAction.equals((Object)BatchActionEnum.AUDIT)) {
            this.checkProjectIsClose(ctx, batchResults);
            this.auditCheck(ctx, batchResults);
            this.auditTimeCheck(ctx, batchResults);
        } else if (batchAction.equals((Object)new BatchActionEnum("PRJ_RELESER"))) {
            this.checkProjectIsClose(ctx, batchResults);
            this.checkRelseser2(ctx, batchAction, batchResults);
        } else if (batchAction.equals((Object)new BatchActionEnum("PRJ_UNRELESER"))) {
            this.checkProjectIsClose(ctx, batchResults);
            this.checkUnReleser(ctx, batchAction, batchResults);
        } else if (batchAction.equals((Object)new BatchActionEnum("PRJ_CLOSE"))) {
            this.closeProjectTask(ctx, batchAction, batchResults);
        } else if (batchAction.equals((Object)new BatchActionEnum("PRJ_ALLTRANSER"))) {
            this.checkProjectIsClose(ctx, batchResults);
            this.checkProjectHasPurOrg(ctx, batchResults);
            this.checkAllTranserMete(ctx, batchAction, batchResults);
            this.checkMaterial(ctx, batchAction, batchResults);
            this.checkAllTranserTrial(ctx, batchAction, batchResults);
        } else if (batchAction.equals((Object)new BatchActionEnum("PRJ_UNALLTRANSER"))) {
            this.checkUnAllTranserTrial(ctx, batchAction, batchResults);
        }
        super.batchCheck(ctx, batchAction, batchResults);
    }

    public void checkRelseser(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException {
        String sql = " select t2.fid fid from t_mm_projecttask t1  ,t_mm_projecttask   t2 ,   t_mm_project   t3  where t3.fid= t2.fprojectid and  SUBSTRING(t2.fwbsnumber,0,LENGTH(t1.fwbsnumber) + 1 ) = t1.fwbsnumber || '.' AND t1.FLevel < t2.flevel and t2.fstorageOrgUnitId  = t1.fstorageOrgUnitId  and t2.fprojectid =t1.fprojectid  and t3.fprojecttypeid='U+F6TI7tSwWsxrdj4TYytZpMH64='  and t2.fid in  (" + SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray()) + ") ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                batchResults.addError(rs.getString("fid"), (Exception)((Object)new ProjectException(ProjectException.PROJECT_IS_HAVING_ZI)));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public void checkRelseser2(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException {
        String id = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        String sql = "select fid from t_mm_projecttask  where  fid in (" + id + ") and fparentid in(select fid from t_mm_projecttask where fid in (select  fparentid  from t_mm_projecttask  where fid in (" + id + ")) and fbasestatus in(1,2,50,7,60,4)) ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                batchResults.addError(rs.getString("fid"), (Exception)((Object)new ProjectException(ProjectException.PROJECTTASK_IS_RELESER)));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public void checkUnReleser(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException {
        String id = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        StringBuffer sql = new StringBuffer("");
        sql.append("select distinct temp.fparentid from (  select  fparentid from t_mm_projecttask where  fparentid in(").append(id).append(") and  (fbasestatus =5 or FActualBeginTime is not null )").append("  union all  ").append(" select  fid fparentid from t_mm_projecttask where  (FIsTransfered =1 or FIsTransferedCentral=1) and fid in( ").append(id).append(")  union all ").append(" select FProjectTaskID  fparentid from t_mm_projectfeedback where FProjectTaskID in (").append(id).append(") ) temp");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                batchResults.addError(rs.getString("fparentid"), (Exception)((Object)new ProjectException(ProjectException.PROJECTTASK_IS_UNRELESER)));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void saveCheck(Context ctx, BatchActionResults batchResults) throws EASBizException, BOSException {
        IObjectCollection col = batchResults.getObjCollection();
        if (col != null && col.size() > 0) {
            for (int i = 0; i < col.size(); ++i) {
                String msg = null;
                ProjectTaskInfo task = (ProjectTaskInfo)col.getObject(i);
                String id = null;
                Object parentId = null;
                String preTaskId = null;
                id = task.getId() == null ? "NEWID" : task.getId().toString();
                ProjectCalendarFacadeControllerBean calFacade = new ProjectCalendarFacadeControllerBean();
                if (task.getPreTask() == null) continue;
                msg = ProjectTaskControllerBean.getResource(ctx, "CHILD_CANT_AS_PRETASK");
                this.isChildAsParentOrPreTask(ctx, batchResults, id, task.getWbsNumber(), preTaskId, msg);
            }
        }
    }

    private String arrayToString(Object[] ids) {
        String idStr = "'null'";
        if (ids != null && ids.length > 0) {
            for (int i = 0; i < ids.length; ++i) {
                if (ids[i].toString().equalsIgnoreCase("NEWID")) continue;
                idStr = idStr + ",'" + ids[i].toString() + "'";
            }
        }
        return idStr;
    }

    private void submitCheck(Context ctx, BatchActionResults batchResults) throws EASBizException, BOSException {
        String ids = this.arrayToString(batchResults.getToDoIdsArray());
        int idLength = ids.split(",").length;
        IObjectCollection objects = batchResults.getObjCollection();
        StringBuffer sqlETO = new StringBuffer();
        if (idLength > 1) {
            sqlETO.append("SELECT t0.FID FID FROM t_mm_projecttask t0 ");
            sqlETO.append("LEFT OUTER JOIN t_bd_material t1 on t0.FMaterialID = t1.FID ");
            sqlETO.append("LEFT OUTER JOIN t_bd_materialPlan t2 on t1.FID = t2.FMaterialID ");
            sqlETO.append("LEFT OUTER JOIN t_bd_manufactureStrategy t3 on t3.FID = t2.FManufactureStrategyID ");
            sqlETO.append("WHERE t3.FID not in ('");
            sqlETO.append("GE2FIa4GQ6uhdx0RDGuibtg0uEU=','qAXoUB/uBg/gQKjAYj0WQ9g0uEU=");
            sqlETO.append("') AND t0.FID in (");
            sqlETO.append(ids);
            sqlETO.append(") AND t0.FStorageORgUnitID= t2.FOrgUnit");
        } else {
            String materialID = "";
            String orgID = "";
            if (objects != null && objects.size() > 0) {
                ProjectTaskInfo task = (ProjectTaskInfo)objects.getObject(0);
                materialID = task.getMaterial() != null ? task.getMaterial().getId().toString() : "null";
                orgID = task.getStorageOrgUnit().getId().toString();
            }
            sqlETO.append("select t1.FID from t_bd_material t1 LEFT OUTER JOIN t_bd_materialPlan t2 on t1.FID = t2.FMaterialID ");
            sqlETO.append("LEFT OUTER JOIN t_bd_manufactureStrategy t3 on t3.FID = t2.FManufactureStrategyID ");
            sqlETO.append(" WHERE t3.FID not in('");
            sqlETO.append("GE2FIa4GQ6uhdx0RDGuibtg0uEU=','qAXoUB/uBg/gQKjAYj0WQ9g0uEU=");
            sqlETO.append("') AND t1.FID ='");
            sqlETO.append(materialID);
            sqlETO.append("' and t2.FOrgUnit='");
            sqlETO.append(orgID);
            sqlETO.append("'");
        }
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sqlETO.toString());
        try {
            String id = "";
            while (set != null && set.next()) {
                id = idLength > 1 ? set.getString("FID") : "NEWID";
                batchResults.addError(id, ProjectTaskControllerBean.getResource(ctx, "MATERIAL_MUST_ETO10"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer statusCheck = new StringBuffer("");
        statusCheck.append("select FID from T_MM_ProjectTask where FID in ( ").append(ids).append(") and FBaseStatus not in (1,2)");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)statusCheck.toString());
        try {
            while (rs.next()) {
                batchResults.addError(rs.getString("FID"), ProjectTaskControllerBean.getResource(ctx, "STATUS_NOT_CORRECT"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        IObjectCollection col = batchResults.getObjCollection();
        MMProjectCalendarFactory mmCalendarFactory = null;
        if (col != null && col.size() > 0) {
            for (int i = 0; i < col.size(); ++i) {
                String msg = null;
                ProjectTaskInfo task = (ProjectTaskInfo)col.getObject(i);
                String id = null;
                String parentId = null;
                String preTaskId = null;
                id = task.getId() == null ? "NEWID" : task.getId().toString();
                ProjectCalendarFacadeControllerBean calFacade = new ProjectCalendarFacadeControllerBean();
                if (task.getCentralPurStgOrg() != null && task.getStorageOrgUnit().getId().equals((Object)task.getCentralPurStgOrg().getId())) {
                    msg = ProjectTaskControllerBean.getResource(ctx, "STORAGE_PUR_CANT_SAME");
                    batchResults.addError(id, msg);
                }
                if (task.getParent() != null && id.equalsIgnoreCase(parentId = task.getParent().getId().toString())) {
                    msg = ProjectTaskControllerBean.getResource(ctx, "PARENT_CANT_SELF");
                    batchResults.addError(id, msg);
                }
                if (task.getPreTask() != null && id.equalsIgnoreCase(preTaskId = task.getPreTask().getId().toString())) {
                    msg = ProjectTaskControllerBean.getResource(ctx, "PRE_TASK_CANT_SELF");
                    batchResults.addError(id, msg);
                }
                if (task.getPreTask() != null) {
                    preTaskId = task.getPreTask().getId().toString();
                    ProjectTaskInfo prepreTask = task.getPreTask().getPreTask();
                    if (prepreTask != null && id.equalsIgnoreCase(prepreTask.getId().toString())) {
                        msg = ProjectTaskControllerBean.getResource(ctx, "PRETASK_CIRCLE");
                        batchResults.addError(id, msg);
                    }
                }
                if (task.getParent() != null && task.getPreTask() != null && preTaskId != null && preTaskId.equalsIgnoreCase(parentId)) {
                    msg = ProjectTaskControllerBean.getResource(ctx, "PARENT_PRE_CANT_SAME");
                    batchResults.addError(id, msg);
                }
                if (task.getPreTask() != null) {
                    msg = ProjectTaskControllerBean.getResource(ctx, "CHILD_CANT_AS_PRETASK");
                    this.isChildAsParentOrPreTask(ctx, batchResults, id, task.getWbsNumber(), preTaskId, msg);
                }
                if (task.getMaterial() != null) {
                    this.checkMaterial(ctx, batchResults, task.getMaterial().getId().toString(), task.getStorageOrgUnit().getId().toString(), id);
                }
                if (mmCalendarFactory == null) {
                    mmCalendarFactory = new MMProjectCalendarFactory(ctx, task.getProject().getId().toString());
                } else if (!task.getProject().getId().toString().equalsIgnoreCase(mmCalendarFactory.getProjectId())) {
                    mmCalendarFactory.changeOrg(task.getProject().getId().toString());
                }
                int total = mmCalendarFactory.getWorklength(task.getPlanBeginTime(), task.getPlanEndTime());
                if (total != task.getTotalTime().intValue()) {
                    batchResults.addError(id, (Exception)((Object)new WBSException(WBSException.TOTALTIME_ERROR)));
                }
                this.submitTimeCheck(ctx, batchResults, task);
            }
        }
    }

    private void submitTimeCheck(Context ctx, BatchActionResults batchResults, ProjectTaskInfo task) throws SQLDataException {
        ProjectTaskInfo preTask = null;
        ProjectTaskInfo parent = null;
        ProjectTaskInfo project = null;
        Connection con = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            if (task.getPreTask() != null) {
                StringBuffer qPreTask = new StringBuffer("");
                qPreTask.append("select ");
                qPreTask.append("FID,FPlanBeginTime,FPlanEndTime,FEaristBeginTime,FEaristEndTime,FLastBeginTime,FLastEndTime ");
                qPreTask.append("from T_MM_ProjectTask where FID='");
                qPreTask.append(task.getPreTask().getId().toString());
                qPreTask.append("' and ");
                qPreTask.append("FProjectID = '");
                qPreTask.append(task.getProject().getId().toString());
                qPreTask.append("'");
                rs = statement.executeQuery(qPreTask.toString());
                preTask = task.getPreTask();
                while (rs.next()) {
                    preTask.setPlanBeginTime(rs.getTimestamp("FPlanBeginTime"));
                    preTask.setPlanEndTime(rs.getTimestamp("FPlanEndTime"));
                    preTask.setEaristBeginTime(rs.getTimestamp("FEaristBeginTime"));
                    preTask.setEaristEndTime(rs.getTimestamp("FEaristEndTime"));
                    preTask.setLastBeginTime(rs.getTimestamp("FLastBeginTime"));
                    preTask.setLastEndTime(rs.getTimestamp("FLastEndTime"));
                }
            }
            if (task.getParent() != null) {
                StringBuffer qParent = new StringBuffer("");
                qParent.append("select ");
                qParent.append("FID,FPlanBeginTime,FPlanEndTime,FEaristBeginTime,FEaristEndTime,FLastBeginTime,FLastEndTime ");
                qParent.append("from T_MM_ProjectTask where FID='");
                qParent.append(task.getParent().getId().toString());
                qParent.append("' and ");
                qParent.append("FProjectID = '");
                qParent.append(task.getProject().getId().toString());
                qParent.append("'");
                rs = statement.executeQuery(qParent.toString());
                parent = task.getParent();
                while (rs.next()) {
                    parent.setPlanBeginTime(rs.getTimestamp("FPlanBeginTime"));
                    parent.setPlanEndTime(rs.getTimestamp("FPlanEndTime"));
                    parent.setEaristBeginTime(rs.getTimestamp("FEaristBeginTime"));
                    parent.setEaristEndTime(rs.getTimestamp("FEaristEndTime"));
                    parent.setLastBeginTime(rs.getTimestamp("FLastBeginTime"));
                    parent.setLastEndTime(rs.getTimestamp("FLastEndTime"));
                }
            }
            StringBuffer qProject = new StringBuffer("");
            qProject.append("select ");
            qProject.append("FID,FPlanBeginTime,FPlanEndTime,FEaristBeginTime,FEaristEndTime,FLastBeginTime,FLastEndTime ");
            qProject.append("from T_MM_Project where ");
            qProject.append("FID = '");
            qProject.append(task.getProject().getId().toString());
            qProject.append("'");
            rs = statement.executeQuery(qProject.toString());
            if (rs.next()) {
                project = new ProjectTaskInfo();
                project.setId(BOSUuid.read((String)rs.getString("FID")));
                project.setPlanBeginTime(rs.getTimestamp("FPlanBeginTime"));
                project.setPlanEndTime(rs.getTimestamp("FPlanEndTime"));
                project.setEaristBeginTime(rs.getTimestamp("FEaristBeginTime"));
                project.setEaristEndTime(rs.getTimestamp("FEaristEndTime"));
                project.setLastBeginTime(rs.getTimestamp("FLastBeginTime"));
                project.setLastEndTime(rs.getTimestamp("FLastEndTime"));
            }
            this.timeCheck(ctx, batchResults, parent, task, project);
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)con);
    }

    private void isChildAsParentOrPreTask(Context ctx, BatchActionResults batchResults, String id, String wbs, String parentOrPreTaskID, String msg) throws SQLDataException {
        Connection con = null;
        Statement statement = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer("");
        sql.append("select FID from T_MM_ProjectTask where ");
        sql.append("FWBSNumber like '");
        sql.append(wbs);
        sql.append(".%' and ");
        sql.append("FID = '");
        sql.append(parentOrPreTaskID);
        sql.append("'");
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            rs = statement.executeQuery(sql.toString());
            if (rs.next()) {
                batchResults.addError(id, msg);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)con);
    }

    private void checkMaterial(Context ctx, BatchActionResults batchResults, String materialID, String strorageID, String id) throws SQLDataException {
        ResultSet rs;
        Statement statement;
        Connection con;
        block5: {
            con = null;
            statement = null;
            rs = null;
            StringBuffer sql = new StringBuffer("");
            sql.append("select FID from T_BD_MaterialPlan where FMaterialID ='");
            sql.append(materialID + "' and FOrgUnit = '");
            sql.append(strorageID + "'");
            con = this.getConnection(ctx);
            statement = con.createStatement();
            rs = statement.executeQuery(sql.toString());
            if (!rs.next()) break block5;
            SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)con);
            return;
        }
        try {
            batchResults.addError(id, ProjectTaskControllerBean.getResource(ctx, "MATERIAL_NOT_IN_ORGUNIT"));
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)con);
    }

    private boolean isParentChanged(Context ctx, ProjectTaskInfo parent, String id, ProjectTaskInfo projectTask) throws SQLDataException {
        boolean bl;
        ResultSet rs;
        Statement statement;
        Connection con;
        block12: {
            String ID;
            block13: {
                String parentID;
                block11: {
                    block10: {
                        parentID = null;
                        if (parent != null) {
                            parentID = parent.getId().toString();
                        }
                        con = null;
                        statement = null;
                        rs = null;
                        StringBuffer select = new StringBuffer("");
                        select.append("select FParentID,fProjectId from T_MM_ProjectTask where FID = '").append(id).append("'");
                        con = this.getConnection(ctx);
                        statement = con.createStatement();
                        rs = statement.executeQuery(select.toString());
                        ID = null;
                        String oldProjectId = null;
                        while (rs.next()) {
                            ID = rs.getString("FParentID");
                            oldProjectId = rs.getString("fProjectId");
                        }
                        if (projectTask == null || oldProjectId == null || projectTask.getProject() == null || oldProjectId.equals(projectTask.getProject().getId().toString())) break block10;
                        boolean bl2 = true;
                        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)con);
                        return bl2;
                    }
                    if (ID == null || parentID == null) break block11;
                    if (ID.equalsIgnoreCase(parentID)) break block12;
                    boolean bl3 = true;
                    SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)con);
                    return bl3;
                }
                if (parentID == null) break block13;
                boolean bl4 = true;
                SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)con);
                return bl4;
            }
            if (ID == null) break block12;
            boolean bl5 = true;
            SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)con);
            return bl5;
        }
        try {
            bl = false;
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)con);
        return bl;
    }

    private void childCheck4ChangeParent(Context ctx, BatchActionResults batchResults, String parentID, String id) throws SQLDataException {
        Connection con = null;
        Statement statement = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer("");
        sql.append("select FParentID from T_MM_ProjectTask where FParentID in('");
        sql.append(id);
        sql.append("')");
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            if (this.isParentChanged(ctx, null, id, null)) {
                rs = statement.executeQuery(sql.toString());
                while (rs.next()) {
                    String ID = rs.getString("FParentID");
                    batchResults.addError(ID, ProjectTaskControllerBean.getResource(ctx, "CANT_CHANGE_PARENT"));
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)statement, (Connection)con);
    }

    private void childCheck4Delete(Context ctx, BatchActionResults batchResults) throws SQLDataException {
        Connection con = null;
        Statement statement = null;
        ResultSet rs = null;
        if (batchResults.getToDoIdsArray().length == 0) {
            return;
        }
        String ids = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        StringBuffer sql = new StringBuffer("");
        sql.append("select FID,FNumber from T_MM_ProjectTask where FID in (select FParentID from T_MM_ProjectTask where FParentID in(");
        sql.append(ids);
        sql.append("))");
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            rs = statement.executeQuery(sql.toString());
            String number = null;
            while (rs.next()) {
                String ID = rs.getString("FID");
                number = rs.getString("FNumber");
                batchResults.addError(ID, (Exception)((Object)new WBSException(WBSException.CANT_DELETE_PARENT_TASK, new String[]{number})));
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)con);
    }

    private void unAuditCheck(Context ctx, BatchActionResults batchResults) throws SQLDataException {
        Connection con = null;
        Statement statement = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer("");
        String ids = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        sql.append("select FID,FNumber from T_MM_ProjectTask where FID in (select FParentID from T_MM_ProjectTask where FParentID in(");
        sql.append(ids);
        sql.append("))");
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            rs = statement.executeQuery(sql.toString());
            while (rs.next()) {
                String ID = rs.getString("FID");
                String number = rs.getString("FNumber");
                batchResults.addError(ID, (Exception)((Object)new WBSException(WBSException.CANT_UNAUDIT_PARENT_TASK, new String[]{number})));
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)con);
    }

    private void timeCheck(Context ctx, BatchActionResults batchResults, ProjectTaskInfo parent, ProjectTaskInfo task, ProjectTaskInfo project) {
        String msg = null;
        String id = null;
        id = task.getId() == null ? "NEWID" : task.getId().toString();
        if (parent != null && parent.getPlanBeginTime() != null) {
            if (this.compareTwoDateBefore(task.getPlanBeginTime(), parent.getPlanBeginTime())) {
                msg = ProjectTaskControllerBean.getResource(ctx, "BEGIN_GREATER_THAN_EARISTBEGIN");
                batchResults.addError(id, msg);
            }
        } else if (project.getPlanBeginTime() != null && this.compareTwoDateBefore(task.getPlanBeginTime(), project.getPlanBeginTime())) {
            msg = ProjectTaskControllerBean.getResource(ctx, "BEGIN_GREATER_THAN_PROJECT");
            batchResults.addError(id, msg);
        }
        if (parent != null && parent.getPlanEndTime() != null) {
            if (this.compareTwoDateAfter(task.getPlanEndTime(), parent.getPlanEndTime())) {
                msg = ProjectTaskControllerBean.getResource(ctx, "END_LT_LASTEND");
                batchResults.addError(id, msg);
            }
        } else if (project.getPlanEndTime() != null && this.compareTwoDateAfter(task.getPlanEndTime(), project.getPlanEndTime())) {
            msg = ProjectTaskControllerBean.getResource(ctx, "END_LT_LASTEND_PROJECT");
            batchResults.addError(id, msg);
        }
        if (parent != null && parent.getEaristBeginTime() != null) {
            if (task.getEaristBeginTime() != null && this.compareTwoDateBefore(task.getEaristBeginTime(), parent.getEaristBeginTime())) {
                msg = ProjectTaskControllerBean.getResource(ctx, "EARISTBEGIN_GREATER_THAN_PARENT");
                batchResults.addError(id, msg);
            }
        } else if (project.getEaristBeginTime() != null && task.getEaristBeginTime() != null && this.compareTwoDateBefore(task.getEaristBeginTime(), project.getEaristBeginTime())) {
            msg = ProjectTaskControllerBean.getResource(ctx, "EARISTBEGIN_GREATER_THAN_PROJECT");
            batchResults.addError(id, msg);
        }
        if (parent != null && parent.getEaristEndTime() != null) {
            if (task.getEaristEndTime() != null && this.compareTwoDateAfter(task.getEaristEndTime(), parent.getEaristEndTime())) {
                msg = ProjectTaskControllerBean.getResource(ctx, "EARISTEND_GREATER_THAN_PARENT");
                batchResults.addError(id, msg);
            }
        } else if (project.getEaristEndTime() != null && task.getEaristEndTime() != null && this.compareTwoDateAfter(task.getEaristEndTime(), project.getEaristEndTime())) {
            msg = ProjectTaskControllerBean.getResource(ctx, "EARISTEND_GREATER_THAN_PROJECT");
            batchResults.addError(id, msg);
        }
        if (parent != null && parent.getLastBeginTime() != null) {
            if (task.getLastBeginTime() != null && this.compareTwoDateBefore(task.getLastBeginTime(), parent.getLastBeginTime())) {
                msg = ProjectTaskControllerBean.getResource(ctx, "LASTBEGIN_GREATER_THAN_PARENT");
                batchResults.addError(id, msg);
            }
        } else if (project.getLastBeginTime() != null && task.getLastBeginTime() != null && this.compareTwoDateBefore(task.getLastBeginTime(), project.getLastBeginTime())) {
            msg = ProjectTaskControllerBean.getResource(ctx, "LASTBEGIN_GREATER_THAN_PROJECT");
            batchResults.addError(id, msg);
        }
        if (parent != null && parent.getLastEndTime() != null) {
            if (task.getLastEndTime() != null && this.compareTwoDateAfter(task.getLastEndTime(), parent.getLastEndTime())) {
                msg = ProjectTaskControllerBean.getResource(ctx, "LASTEND_GREATER_THAN_PARENT");
                batchResults.addError(id, msg);
            }
        } else if (project.getLastEndTime() != null && task.getLastEndTime() != null && this.compareTwoDateAfter(task.getLastEndTime(), project.getLastEndTime())) {
            msg = ProjectTaskControllerBean.getResource(ctx, "LASTEND_GREATER_THAN_PROJECT");
            batchResults.addError(id, msg);
        }
    }

    private void auditTimeCheck(Context ctx, BatchActionResults batchResults) throws SQLDataException {
        String projectID = null;
        IObjectCollection col = batchResults.getObjCollection();
        if (col == null || col.size() <= 0) {
            return;
        }
        ProjectTaskInfo temp = (ProjectTaskInfo)col.getObject(0);
        projectID = temp.getProject().getId().toString();
        if (batchResults.getToDoIdsArray().length == 0) {
            return;
        }
        String msg = null;
        StringBuffer queryHasParent = new StringBuffer("");
        String ids = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        queryHasParent.append("select ").append("T0.FPlanBeginTime PlanBegin,T0.FPlanEndTime PlanEnd,T0.FEaristBeginTime EaristBegin, T0.FEaristEndTime EaristEnd, ").append("T0.FLastBeginTime LastBegin, T0.FLastEndTime LastEnd, ").append("T1.FPlanBeginTime PPlanBegin,T1.FPlanEndTime PPlanEnd,T1.FEaristBeginTime PEaristBegin, T1.FEaristEndTime PEaristEnd, ").append("T1.FLastBeginTime PLastBegin, T1.FLastEndTime PLastEnd ").append("from T_MM_ProjectTask T0 ").append("inner join T_MM_ProjectTask T1  ").append("on T0.FParentID = T1.FID where ").append("T0.FID in (").append(ids).append(")");
        StringBuffer queryNoParent = new StringBuffer("");
        queryNoParent.append("select ").append("T0.FPlanBeginTime PlanBegin,T0.FPlanEndTime PlanEnd,T0.FEaristBeginTime EaristBegin, T0.FEaristEndTime EaristEnd,").append("T0.FLastBeginTime LastBegin, T0.FLastEndTime LastEnd ").append("from ( ").append("select ").append("T2.FPlanBeginTime FPlanBeginTime,T2.FPlanEndTime FPlanEndTime,T2.FEaristBeginTime FEaristBeginTime, ").append("T2.FEaristEndTime FEaristEndTime,T2.FLastBeginTime FLastBeginTime,T2.FLastEndTime FLastEndTime ").append("from T_MM_ProjectTask T2 where ").append("T2.FID in (").append(ids).append(")) T0");
        StringBuffer queryProject = new StringBuffer("");
        queryProject.append("select ").append("T0.FPlanBeginTime PlanBegin,T0.FPlanEndTime PlanEnd,T0.FEaristBeginTime EaristBegin, T0.FEaristEndTime EaristEnd,").append("T0.FLastBeginTime LastBegin, T0.FLastEndTime LastEnd ").append("from T_MM_Project T0 where ").append("T0.FID = '").append(projectID).append("'");
        Connection con = null;
        Statement statement = null;
        ResultSet rs = null;
        ProjectTaskInfo project = null;
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            rs = statement.executeQuery(queryProject.toString());
            if (rs.next()) {
                project = new ProjectTaskInfo();
                project.setPlanBeginTime(rs.getTimestamp("PlanBegin"));
                project.setPlanEndTime(rs.getTimestamp("PlanEnd"));
                project.setEaristBeginTime(rs.getTimestamp("EaristBegin"));
                project.setEaristEndTime(rs.getTimestamp("EaristEnd"));
                project.setLastBeginTime(rs.getTimestamp("LastBegin"));
                project.setLastEndTime(rs.getTimestamp("LastEnd"));
            }
            rs = statement.executeQuery(queryHasParent.toString());
            while (rs.next()) {
                ProjectTaskInfo parent = new ProjectTaskInfo();
                ProjectTaskInfo task = new ProjectTaskInfo();
                parent.setPlanBeginTime(rs.getTimestamp("PPlanBegin"));
                parent.setPlanEndTime(rs.getTimestamp("PPlanEnd"));
                parent.setEaristBeginTime(rs.getTimestamp("PEaristBegin"));
                parent.setEaristEndTime(rs.getTimestamp("PEaristEnd"));
                parent.setLastBeginTime(rs.getTimestamp("PLastBegin"));
                parent.setLastEndTime(rs.getTimestamp("PLastEnd"));
                task.setPlanBeginTime(rs.getTimestamp("PlanBegin"));
                task.setPlanEndTime(rs.getTimestamp("PlanEnd"));
                task.setEaristBeginTime(rs.getTimestamp("EaristBegin"));
                task.setEaristEndTime(rs.getTimestamp("EaristEnd"));
                task.setLastBeginTime(rs.getTimestamp("LastBegin"));
                task.setLastEndTime(rs.getTimestamp("LastEnd"));
                this.timeCheck(ctx, batchResults, parent, task, project);
            }
            rs = statement.executeQuery(queryNoParent.toString());
            while (rs.next()) {
                ProjectTaskInfo task = new ProjectTaskInfo();
                task.setPlanBeginTime(rs.getTimestamp("PlanBegin"));
                task.setPlanEndTime(rs.getTimestamp("PlanEnd"));
                task.setEaristBeginTime(rs.getTimestamp("EaristBegin"));
                task.setEaristEndTime(rs.getTimestamp("EaristEnd"));
                task.setLastBeginTime(rs.getTimestamp("LastBegin"));
                task.setLastEndTime(rs.getTimestamp("LastEnd"));
                if (project != null && project.getEaristBeginTime() != null && task.getPlanBeginTime().compareTo(project.getEaristBeginTime()) < 0) {
                    msg = ProjectTaskControllerBean.getResource(ctx, "BEGIN_GREATER_THAN_PROJECT");
                    batchResults.addError(task.getId().toString(), msg);
                }
                if (project != null && project.getEaristEndTime() != null && task.getPlanEndTime().compareTo(project.getLastEndTime()) > 0) {
                    msg = ProjectTaskControllerBean.getResource(ctx, "END_LT_LASTEND_PROJECT");
                    batchResults.addError(task.getId().toString(), msg);
                }
                if (project != null && project.getEaristBeginTime() != null && task.getEaristBeginTime() != null && task.getEaristBeginTime().compareTo(project.getEaristBeginTime()) < 0) {
                    msg = ProjectTaskControllerBean.getResource(ctx, "EARISTBEGIN_GREATER_THAN_PROJECT");
                    batchResults.addError(task.getId().toString(), msg);
                }
                if (project != null && project.getEaristEndTime() != null && task.getEaristEndTime() != null && task.getEaristEndTime().compareTo(project.getEaristEndTime()) > 0) {
                    msg = ProjectTaskControllerBean.getResource(ctx, "EARISTEND_GREATER_THAN_PROJECT");
                    batchResults.addError(task.getId().toString(), msg);
                }
                if (project != null && project.getLastBeginTime() != null && task.getLastBeginTime() != null && task.getLastBeginTime().compareTo(project.getLastBeginTime()) < 0) {
                    msg = ProjectTaskControllerBean.getResource(ctx, "LASTBEGIN_GREATER_THAN_PROJECT");
                    batchResults.addError(task.getId().toString(), msg);
                }
                if (project == null || project.getLastEndTime() == null || task.getLastEndTime() == null || task.getLastEndTime().compareTo(project.getLastEndTime()) <= 0) continue;
                msg = ProjectTaskControllerBean.getResource(ctx, "LASTEND_GREATER_THAN_PROJECT");
                batchResults.addError(task.getId().toString(), msg);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)con);
    }

    private void auditCheck(Context ctx, BatchActionResults batchResults) throws SQLDataException {
        Connection con = null;
        Statement statement = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer("");
        String ids = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        sql.append("select C.FID FID,C.FNumber FNumber from T_MM_ProjectTask as C ");
        sql.append("inner join T_MM_ProjectTask as P ");
        sql.append("on C.FParentID=P.FID ");
        sql.append("where C.FID in(");
        sql.append(ids);
        sql.append(") and P.FBaseStatus in (0,1,2,50,70,60) ");
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            rs = statement.executeQuery(sql.toString());
            while (rs.next()) {
                String ID = rs.getString("FID");
                String number = rs.getString("FNumber");
                batchResults.addError(ID, (Exception)((Object)new WBSException(WBSException.CANT_AUDIT_CHILD_TASK, new String[]{number, number})));
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)con);
    }

    @Override
    protected Date _getWorkDay(Context ctx, String storageOrgUnitId, Date currentDay) throws BOSException, EASBizException {
        return currentDay;
    }

    @Override
    protected Date _getNextDay(Context ctx, String storageOrgUnitId, Date currentDay, int totalTime) throws BOSException, EASBizException {
        int sign = 1;
        if (totalTime != 0) {
            sign = totalTime / Math.abs(totalTime);
        }
        int newTime = (Math.abs(totalTime) - 1) * sign;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDay);
        calendar.add(5, newTime);
        return calendar.getTime();
    }

    @Override
    protected int _getTotalTime(Context ctx, String storageOrgUnitId, Date beginDate, Date endDate) throws BOSException, EASBizException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(beginDate);
        long startMillis = calendar.getTimeInMillis();
        calendar.setTime(endDate);
        long endMillis = calendar.getTimeInMillis();
        long lengthOffset = Math.abs(endMillis - startMillis);
        int total = (int)(lengthOffset / 86400000L) + 1;
        return total;
    }

    protected String getBillTypeId() {
        return "cV8Sqe5UQ3eI+vH675lGxUY+1VI=";
    }

    protected ICoreBase getBizInterface(Context ctx) throws BOSException, EASBizException {
        return ProjectTaskFactory.getLocalInstance(ctx);
    }

    protected String getRecycleNumberSQL(String idStr) {
        return "select FID,FNumber,FStorageOrgUnitID forgid from T_MM_ProjectTask where FID in (" + idStr + ")";
    }

    protected String getXmlFileName(BatchActionEnum batchActionEnum) {
        return "com.kingdee.eas.mm.project.app.xml.projectTask.xml";
    }

    protected IObjectValue getBillInstance() {
        return new ProjectTaskInfo();
    }

    protected SelectorItemCollection getSubmitSelectors() {
        SelectorItemCollection sic = super.getSubmitSelectors();
        sic.add(new SelectorItemInfo("taskType.id"));
        sic.add(new SelectorItemInfo("taskType.number"));
        sic.add(new SelectorItemInfo("preTask.*"));
        sic.add(new SelectorItemInfo("parent.baseStatus"));
        return sic;
    }

    public BatchActionResults batchForwardSchedule(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("FORWARDSCHEDULE"));
    }

    public BatchActionResults batchBackwardShedule(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("BACKWARDSHEDULE"));
    }

    public BatchActionResults batchSaveCost(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("SAVECOST"));
    }

    public BatchActionResults batchConfirmCost(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("CONFIRMCOST"));
    }

    public BatchActionResults batchUnConfirmCost(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("UNCONFIRMCOST"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void batchExecute(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        super.batchExecute(ctx, batchAction, batchResults);
        ICentralPurReqPlanFacade iCentralPurReqPlanFacade = CentralPurReqPlanFacadeFactory.getLocalInstance((Context)ctx);
        if (batchAction.equals((Object)BatchActionEnum.SUBMIT) && batchResults.getToDoIdsList() != null && batchResults.getToDoIdsList().size() > 0) {
            this.afterSubmit(ctx, batchResults);
        }
        if (batchAction.equals((Object)new BatchActionEnum("SAVECOST"))) {
            this.updateSaveCost(ctx, batchAction, batchResults);
            return;
        } else if (batchAction.equals((Object)new BatchActionEnum("CONFIRMCOST"))) {
            this.updateConfirmCostCost(ctx, batchAction, batchResults);
            return;
        } else if (batchAction.equals((Object)new BatchActionEnum("CONFIRMCOSTIMP"))) {
            this.updateConfirmCostImport(ctx, batchAction, batchResults);
            return;
        } else if (batchAction.equals((Object)new BatchActionEnum("FORWARDSCHEDULE")) || batchAction.equals((Object)new BatchActionEnum("BACKWARDSHEDULE"))) {
            String taskId = ((IObjectPK)batchResults.getParamEntries()[0].get(0)).toString();
            boolean isContinue = this.checkProjectTaskId(ctx, batchResults, taskId);
            if (!isContinue) return;
            BOM2WBSFacadeFactory.getLocalInstance(ctx).scheduleTask(taskId, batchAction.equals((Object)new BatchActionEnum("FORWARDSCHEDULE")));
            return;
        } else {
            if (batchAction.equals((Object)new BatchActionEnum("PRJ_RELESER")) || batchAction.equals((Object)new BatchActionEnum("PRJ_UNRELESER"))) return;
            if (batchAction.equals((Object)new BatchActionEnum("REQPROJECTPLAN"))) {
                this.requestPlan(ctx, batchAction, batchResults);
                return;
            } else if (batchAction.equals((Object)new BatchActionEnum("UNREQPROJECTPLAN"))) {
                this.unRequestPlan(ctx, batchAction, batchResults);
                return;
            } else if (batchAction.equals((Object)new BatchActionEnum("PRJ_ALLTRANSER"))) {
                batchResults.getToDoIdsArray();
                List<String> list = Arrays.asList(batchResults.getToDoIdsArray());
                if (list == null || list.size() <= 0) return;
                Map is = iCentralPurReqPlanFacade.centralPurReqTransfer(list);
                if (is != null && is.size() > 0) {
                    for (Map.Entry entry : is.entrySet()) {
                        String key = (String)entry.getKey();
                        batchResults.addError(key, (Exception)((Object)((EASBizException)((Object)entry.getValue()))));
                    }
                }
                this.changerProjettaskTranser(ctx, batchResults);
                return;
            } else if (batchAction.equals((Object)new BatchActionEnum("PRJ_UNALLTRANSER"))) {
                Map is;
                batchResults.getToDoIdsArray();
                List<String> list = Arrays.asList(batchResults.getToDoIdsArray());
                if (list != null && list.size() > 0 && (is = iCentralPurReqPlanFacade.centralPurReqUnTransfer(list)) != null && is.size() > 0) {
                    for (Map.Entry entry : is.entrySet()) {
                        String key = (String)entry.getKey();
                        batchResults.addError(key, (Exception)((Object)((EASBizException)((Object)entry.getValue()))));
                    }
                }
                this.unChangerProjettaskTranser(ctx, batchResults);
                return;
            } else {
                if (!batchAction.equals((Object)new BatchActionEnum("PRJ_CLOSE"))) return;
                this.updateActTotalTime(ctx, batchResults);
            }
        }
    }

    private void updateActTotalTime(Context ctx, BatchActionResults batchResults) throws BOSException {
        StringBuffer sqlCreateTable = new StringBuffer();
        String tempTableName = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        sqlCreateTable.append("create table t_temp_totalTime (").append("\r\n").append("FTaskID varchar(44) null,").append("\r\n").append("FBeginSeq numeric(21,8) not null default 0,").append("\r\n").append("FEndSeq numeric(21,8) not null default 0").append("\r\n").append(")");
        try {
            tempTableName = pool.createTempTable(sqlCreateTable.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        String ids = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        StringBuffer sqlQueryPks = new StringBuffer("");
        sqlQueryPks.append("select Fid from t_mm_projecttask where Fid in (").append(ids).append(") and FActualEndTime is not null");
        IRowSet set = DBUtil.executeQuery((Context)ctx, (String)sqlQueryPks.toString());
        HashSet<String> pks = new HashSet<String>();
        try {
            while (set.next()) {
                pks.add(set.getString("Fid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer sqlInsert = new StringBuffer("");
        StringBuffer sqlUpdate = new StringBuffer("");
        StringBuffer sqlReWrite = new StringBuffer("");
        ids = SQLUtil.arrayToString((Object[])pks.toArray());
        sqlInsert.append("insert into ").append(tempTableName).append(" (FTaskID,FBeginSeq) ").append(" select t0.FID,").append(" case when t2.FWorkDateSeq=0 and t2.FNextWorkDaySeq<>0 then t2.FNextWorkDaySeq").append(" when t2.FWorkDateSeq=0 and t2.FNextWorkDaySeq=0 then t2.FPreWorkDaySeq else t2.FWorkDateSeq end").append(" from T_MM_ProjectTask t0").append(" inner join T_MM_FactoryCalendar t1 on  ").append(" t0.FStorageOrgUnitID = t1.FStorageOrgUnitID ").append(" inner join T_MM_FactoryCalendarEntry t2 on").append(" t1.FID = t2.FParentID").append(" where to_char(t2.FWorkDate,'YYYY-MM-DD') = TO_CHAR(t0.FActualBeginTime,'YYYY-MM-DD')").append(" and t0.FID in (").append(ids).append(")");
        sqlUpdate.append("update ").append(tempTableName).append(" as t3 set FEndSeq = ").append(" (select ").append(" case when t2.FWorkDateSeq=0 and t2.FNextWorkDaySeq<>0 then t2.FNextWorkDaySeq").append(" when t2.FWorkDateSeq=0 and t2.FNextWorkDaySeq=0 then t2.FPreWorkDaySeq else t2.FWorkDateSeq end").append(" from T_MM_ProjectTask t0").append(" inner join T_MM_FactoryCalendar t1 on  ").append(" t0.FStorageOrgUnitID = t1.FStorageOrgUnitID ").append(" inner join T_MM_FactoryCalendarEntry t2 on").append(" t1.FID = t2.FParentID").append(" where to_char(t2.FWorkDate,'YYYY-MM-DD') = TO_CHAR(t0.FActualEndTime,'YYYY-MM-DD')").append(" and t0.FID in (").append(ids).append(") and t3.FTaskID = t0.FID)");
        sqlReWrite.append("update T_MM_ProjectTask as t0 ").append(" set ( FActualTotalTime ) = ").append(" (select t1.FEndSeq - t1.FBeginSeq + 1").append(" from ").append(tempTableName).append(" t1 where t0.FID=t1.FTaskID)");
        SQLUtil.batchExecuteSql((Context)ctx, (String[])new String[]{sqlInsert.toString(), sqlUpdate.toString(), sqlReWrite.toString()});
        if (tempTableName != null) {
            pool.releaseTable(tempTableName);
        }
    }

    private void changerProjettaskTranser(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        String sql = "update T_MM_ProjectTask set FIsTransferedCentral=1 where fid in (" + idStr + ")";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void unChangerProjettaskTranser(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        String sql = "update T_MM_ProjectTask set FIsTransferedCentral=0 where fid in (" + idStr + ")";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private List transertPlan(Context ctx, ArrayList parentId, ArrayList entryTaskId) throws BOSException, EASBizException {
        IReqPlanForProjectTaskFacade iReqPlanForProjectTask = ReqPlanForProjectTaskFacadeFactory.getLocalInstance((Context)ctx);
        String[] tableName = this.createTempleTable(ctx, parentId, entryTaskId);
        List list = iReqPlanForProjectTask.transferRequirement(tableName[0], tableName[1], BizActionEnum.ENTRYRELEASE);
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        pool.releaseTable(tableName[0]);
        pool.releaseTable(tableName[1]);
        return list;
    }

    private List unTransertPlan(Context ctx, ArrayList parentId, ArrayList entryTaskId) throws BOSException, EASBizException {
        IReqPlanForProjectTaskFacade iReqPlanForProjectTask = ReqPlanForProjectTaskFacadeFactory.getLocalInstance((Context)ctx);
        String wbsNumber = null;
        String currentWbsNumber = null;
        for (int i = 0; i < entryTaskId.size(); ++i) {
            if (i == 0) {
                wbsNumber = ((String[])entryTaskId.get(i))[2];
            } else {
                wbsNumber = ((String[])entryTaskId.get(i - 1))[2];
                currentWbsNumber = ((String[])entryTaskId.get(i))[2];
            }
            if (currentWbsNumber == null || !currentWbsNumber.startsWith(wbsNumber)) continue;
            entryTaskId.remove(i);
            --i;
        }
        String[] tableName = this.createTempleTable(ctx, parentId, entryTaskId);
        List list = iReqPlanForProjectTask.transferRequirement(tableName[0], tableName[1], BizActionEnum.ENTRYUNRELEASE);
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        pool.releaseTable(tableName[0]);
        pool.releaseTable(tableName[1]);
        return list;
    }

    private void afterSubmit(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        StringBuffer updateSql = new StringBuffer("");
        updateSql.setLength(0);
        updateSql.append("update T_MM_ProjectTask as t0  ").append("set (FBaseUnitID,FBaseQty) = ").append("(select t2.FBaseUnit,round(decimal(t0.FQty * t1.FBaseConvsRate,21,8),t3.FQtyPrecision) ").append("from t_bd_multimeasureunit t1,t_bd_material t2,t_bd_multimeasureunit t3 ").append("where t0.FMaterialID = t1.FMaterialID and t0.FUnitID = t1.fmeasureunitid ").append("and t0.FMaterialID = t2.FID ").append("and t0.FMaterialID = t3.FMaterialID and  t2.FBaseUnit = t3.fmeasureunitid ").append("and t0.FID in (").append(idStr).append(") ").append(")");
        StringBuffer updateNoMaterial = new StringBuffer("");
        updateNoMaterial.setLength(0);
        updateNoMaterial.append("update T_MM_ProjectTask as t0 ").append("set FBaseUnitID = FUnitID,FBaseQty = FQty ").append("where t0.FID in (").append(idStr).append(") ").append("and t0.FMaterialID is null");
        SQLUtil.batchExecuteSql((Context)ctx, (String[])new String[]{updateSql.toString(), updateNoMaterial.toString()});
    }

    public String[] createTempleTable(Context ctx, ArrayList parentId, ArrayList entryTaskId) throws BOSException {
        StringBuffer entryTable = new StringBuffer();
        entryTable.append("create table getprojectentrytask (");
        entryTable.append("FProjectTaskID NVARCHAR(80) not null,");
        entryTable.append("fParentID NVARCHAR(80) not null)");
        StringBuffer projectTable = new StringBuffer();
        projectTable.append("create table getprojecttask (");
        projectTable.append("fid NVARCHAR(80) not null,");
        projectTable.append("fNumber NVARCHAR(80),");
        projectTable.append("fStorageOrgUnitID  VARCHAR(44),");
        projectTable.append("FBizDate DateTime,");
        projectTable.append("fMaterialID  VARCHAR(44),");
        projectTable.append("fBaseUnitID  VARCHAR(44),");
        projectTable.append("FBaseQty NUMERIC(21,8) DEFAULT 0 NOT NULL,");
        projectTable.append("fCreatorID  VARCHAR(44),");
        projectTable.append("fProjectID  VARCHAR(44),");
        projectTable.append("fTrackNumberID  VARCHAR(44))");
        String temptablename = null;
        String tempentrytablename = null;
        try {
            temptablename = TempTablePool.getInstance((Context)ctx).createTempTable(projectTable.toString());
            tempentrytablename = TempTablePool.getInstance((Context)ctx).createTempTable(entryTable.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer insertsql = new StringBuffer();
        insertsql.append(" insert into ");
        insertsql.append(temptablename);
        insertsql.append("(fid ,fNumber,fStorageOrgUnitID,FBizDate,fMaterialID,fBaseUnitID,FBaseQty,fCreatorID,fProjectID,fTrackNumberID )");
        insertsql.append(" select fid,fnumber,fStorageOrgUnitID,FBizDate,fMaterialID,fBaseUnitID,decimal(FQty * FBaseConvsRate,21,8)");
        insertsql.append(" FBaseQty,fCreatorID,fProjectID,fProjectCarID from (");
        insertsql.append(" select t.fid fid,  t.fnumber fNumber,t.fstorageorgunitid fStorageOrgUnitID,t.fplanbegintime FBizDate, ");
        insertsql.append("  t.fmaterialid fMaterialID, mu.FBaseConvsRate FBaseConvsRate,  t.funitid fBaseUnitID,");
        insertsql.append("t.fqty FQty,t.fcreatorid fCreatorID,t.fprojectid fProjectID,t.fcarnumberid fProjectCarID ");
        insertsql.append(" from t_mm_projecttask t  LEFT OUTER JOIN t_mm_project as p on p.fid= t.fprojectid ");
        insertsql.append(" left join T_BD_MultiMeasureUnit mu on t.FMaterialID=mu.FMaterialID and t.FUnitID=mu.FMeasureUnitID ");
        insertsql.append(" LEFT OUTER JOIN t_mm_tracknumber as c on c.fid= t.fcarnumberid ");
        insertsql.append("  where   t.fid in (");
        insertsql.append(SQLUtil.arrayToString((Object[])parentId.toArray()));
        insertsql.append("  ) and t.FTaskTypeID in ('AyKjxAUlS9KdlMIjwVdddZpMH64=','uxqG1JcyTNKWqD8KTZatKppMH64=' )");
        insertsql.append(" and t.fmaterialid is not null and t.fbaseQty>0 tt )");
        DbUtil.execute((Context)ctx, (String)insertsql.toString());
        String[] insertentrysql = new String[entryTaskId.size()];
        for (int i = 0; i < entryTaskId.size(); ++i) {
            String[] ids = (String[])entryTaskId.get(i);
            insertentrysql[i] = "insert into " + tempentrytablename + " values('" + ids[0] + "','" + ids[1] + "')";
        }
        SQLUtil.batchExecuteSql((Context)ctx, (String[])insertentrysql);
        return new String[]{temptablename, tempentrytablename};
    }

    public void updateSaveCost(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException {
        Connection conn = null;
        Statement statement = null;
        ProjectTaskInfo info = null;
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        BatchExecuteParamsEntry[] entries = batchResults.getParamEntries();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            for (int i = 0; i < entries.length; ++i) {
                info = (ProjectTaskInfo)entries[i].get(0);
                String update = "update t_mm_projecttask set ftotalcost=" + info.getTotalCost() + ",funitCost =" + info.getUnitCost() + " where fid = '" + info.getId().toString() + "'";
                statement.addBatch(update);
            }
            statement.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
    }

    public void updateConfirmCostCost(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException {
        Connection conn = null;
        Statement statement = null;
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        String idParent = "";
        BatchExecuteParamsEntry[] entries = batchResults.getParamEntries();
        try {
            JdbcRowSet rowset = new JdbcRowSet();
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            StringBuffer selectMaxCost = new StringBuffer();
            selectMaxCost.append("select distinct fparentid from t_mm_projecttask where fid in (" + idStr + ") and flevel > 1  union ");
            selectMaxCost.append("select fid fparentid from t_mm_projecttask where FProjectID in (select distinct FProjectID from t_mm_projecttask where fid in (" + idStr + ") and flevel = 1) and flevel = 0");
            ResultSet rsParentId = statement.executeQuery(selectMaxCost.toString());
            ArrayList<String> arrayList = new ArrayList<String>();
            while (rsParentId.next()) {
                arrayList.add(rsParentId.getString("fparentid"));
            }
            idParent = SQLUtil.arrayToString((Object[])arrayList.toArray());
            statement.execute("update t_mm_projecttask set fid = fid where fid in (" + idParent + ")");
            selectMaxCost = new StringBuffer();
            selectMaxCost.append("select fid id,FWbsNumber wbsnumber, case when flevel=1 then FProjectID when flevel > 1 then fparentid end parentid,flevel projecttasklevel from t_mm_projecttask where fid in (" + idStr + ") order by flevel,fwbsnumber");
            ResultSet rsSelect = statement.executeQuery(selectMaxCost.toString());
            rowset.populate(rsSelect);
            while (rowset.next()) {
                String parentid = rowset.getString("parentid");
                String id = rowset.getString("id");
                int level = rowset.getInt("projecttasklevel");
                ProjectTaskInfo info = null;
                for (int i = 0; i < entries.length && !id.equals((info = (ProjectTaskInfo)entries[i].get(0)).getId().toString()); ++i) {
                }
                String stringSum = null;
                ResultSet rsCostSum = null;
                String string = null;
                ResultSet rsCost = null;
                ResultSet nextLevelCostSet = null;
                String nextLevelCostSum = null;
                BigDecimal costSum = new BigDecimal(0);
                BigDecimal cost = new BigDecimal(0);
                BigDecimal nextLevelCost = new BigDecimal(0);
                if (level > 1) {
                    stringSum = "select isnull(sum(ftotalcost),0) ftotalcost from t_mm_projecttask where fparentid = '" + parentid + "' and fid !='" + id + "'";
                    string = "select ftotalcost from t_mm_projecttask where fid = '" + parentid + "'";
                } else {
                    stringSum = "select isnull(sum(ftotalcost),0) ftotalcost from t_mm_projecttask where FProjectID = '" + parentid + "' and fid !='" + id + "' and flevel =1";
                    string = "select b.ftotalcost ftotalcost from t_mm_projecttask a,t_mm_project b where a.FProjectID = b.fid and a.fid ='" + id + "'";
                }
                nextLevelCostSum = "select isnull(sum(ftotalcost),0) ftotalcost from t_mm_projecttask where fparentid = '" + id + "'";
                nextLevelCostSet = statement.executeQuery(nextLevelCostSum);
                if (nextLevelCostSet.next()) {
                    nextLevelCost = nextLevelCostSet.getBigDecimal(1);
                }
                if ((rsCostSum = statement.executeQuery(stringSum)).next()) {
                    costSum = rsCostSum.getBigDecimal(1);
                }
                if ((rsCost = statement.executeQuery(string)).next()) {
                    cost = rsCost.getBigDecimal(1);
                }
                if (info != null && cost.add(costSum.negate()).add(info.getTotalCost().negate()).signum() >= 0 && info.getTotalCost().add(nextLevelCost.negate()).signum() >= 0) {
                    String update = "update t_mm_projecttask set fbasestatus = 60 ,ftotalcost=" + info.getTotalCost() + ",funitCost =" + info.getUnitCost() + " where fid = '" + id + "'";
                    statement.executeUpdate(update);
                    continue;
                }
                batchResults.addError(id, (Exception)((Object)new ProjectTaskException(ProjectTaskException.INVALID_COST)));
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
    }

    @Override
    protected void _saveCost(Context ctx, IObjectValue model, IObjectPK pk) throws BOSException, EASBizException {
        BatchActionResults result = this.batchSaveCost(ctx, this.buildBatchParam(ctx, model, pk));
        result.throwExceptions();
    }

    @Override
    protected void _confirmCost(Context ctx, IObjectValue model, IObjectPK pk) throws BOSException, EASBizException {
        BatchActionResults result = this.batchConfirmCost(ctx, this.buildBatchParam(ctx, model, pk));
        result.throwExceptions();
    }

    protected BatchExecuteParamsEntry[] buildBatchParam(Context ctx, IObjectValue model, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectValue.class, IObjectPK.class});
        entry.add((Object)model);
        entry.add((Object)pk);
        return new BatchExecuteParamsEntry[]{entry};
    }

    @Override
    protected void _backwardShedule(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchActionResults result = this.batchBackwardShedule(ctx, this.buildBatchParam(ctx, pk));
        result.throwExceptions();
    }

    @Override
    protected void _forwardSchedule(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchActionResults result = this.batchForwardSchedule(ctx, this.buildBatchParam(ctx, pk));
        result.throwExceptions();
    }

    private void checkTaskInChanging(Context ctx, BatchActionResults batchResults) throws BOSException {
        Object[] ids = batchResults.getToDoIdsArray();
        StringBuffer sql = new StringBuffer();
        sql.append("select  fid  from  t_mm_projecttask where fid in  (");
        sql.append(SQLUtil.arrayToString((Object[])ids));
        sql.append(") and FIsChanging = 1");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ProjectTaskException exception = new ProjectTaskException(ProjectTaskException.TASK_INCHANGING);
        try {
            while (rs.next()) {
                batchResults.addError(rs.getString("fid"), (Exception)((Object)exception));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public void checkProjectIsClose(Context ctx, BatchActionResults batchResults) throws BOSException {
        Object[] ids = batchResults.getToDoIdsArray();
        String psql = "select projecttask.fid  from  t_mm_projecttask   as projecttask  left outer join   t_mm_project as project    on projecttask.fprojectid=project.fid  where project.fbasestatus=7   and projecttask.fid in(" + SQLUtil.arrayToString((Object[])ids) + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)psql.toString());
        try {
            while (rs.next()) {
                batchResults.addError(rs.getString("fid"), (Exception)((Object)new ProjectException(ProjectException.PROJECT_IS_CLOSE)));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public void checkProjectHasPurOrg(Context ctx, BatchActionResults batchResults) throws BOSException {
        Object[] ids = batchResults.getToDoIdsArray();
        String psql = "select purOrg.FStorageOrgUnitID as FStorageOrgUnitID,projecttask.fid as fid from  T_MM_ProjectTask  as projecttask   left outer join  T_MM_ProjectTaskCentralPurOrg  as purOrg      on projecttask.fid=purOrg.fparentid  where  projecttask.fid in(" + SQLUtil.arrayToString((Object[])ids) + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)psql.toString());
        try {
            while (rs.next()) {
                if (!StringUtils.isEmpty((String)rs.getString("FStorageOrgUnitID"))) continue;
                batchResults.addError(rs.getString("fid"), (Exception)((Object)new ProjectTaskException(ProjectTaskException.NOT_EXIST_PUR_ORG)));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public void checkProjectTastkIsNotAudit(Context ctx, BatchActionResults batchResults) throws BOSException {
        Object[] ids = batchResults.getToDoIdsArray();
        String psql = "select distinct fparentid  from t_mm_projecttask where fparentid in (" + SQLUtil.arrayToString((Object[])ids) + ")  and  fbasestatus in (4,5,7)";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)psql.toString());
        try {
            while (rs.next()) {
                batchResults.addError(rs.getString("fparentid"), (Exception)((Object)new ProjectException(ProjectException.PROJECTTASK_ISPARENT_NOT_UNAUDIT)));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public void checkProjectTastkPreTask(Context ctx, BatchActionResults batchResults) throws BOSException {
        Object[] ids = batchResults.getToDoIdsArray();
        String psql = "select distinct FPreTaskID  from t_mm_projecttask where FPreTaskID in (" + SQLUtil.arrayToString((Object[])ids) + ")  and  fbasestatus in (4,5,7)";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)psql.toString());
        try {
            while (rs.next()) {
                batchResults.addError(rs.getString("FPreTaskID"), (Exception)((Object)new ProjectException(ProjectException.PROJECT_PERTASK_IS)));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public void checkCostSubmit(Context ctx, BatchActionResults batchResults) throws BOSException {
        Object[] ids = batchResults.getToDoIdsArray();
        StringBuffer psql = new StringBuffer();
        psql.append("select fid from  t_mm_projecttask ").append("where fparentid in ( ").append("select fid from(").append("select a1.fid , a1.ftotalCost from ").append("( select fid,ftotalCost from  t_mm_projecttask      where fid in ").append(" (select fparentid from t_mm_projecttask where fid in (").append(SQLUtil.arrayToString((Object[])ids)).append(") and flevel >1 )").append("  )  a1  ").append("  left outer join ").append("(select fid, ftotalCost ").append("from ( ").append("select fparentid fid,sum(ftotalCost) ftotalCost from t_mm_projecttask ").append("where fparentid in  ").append("(select fparentid from t_mm_projecttask where fid in (").append(SQLUtil.arrayToString((Object[])ids)).append(")   and flevel >1 and fbasestatus in(4,7,5))  ").append("group by fparentid    ) ").append("union all ").append("select fparentid, sum(ftotalCost)  ftotalCost from t_mm_projecttask where fid in (").append(SQLUtil.arrayToString((Object[])ids)).append(") ").append("group by fparentid  ").append(")   a2  ").append(" on a1.fid = a2.fid  where  a1.ftotalCost < a2.ftotalCost  and a2.fid is not null )) and   fid in(").append(SQLUtil.arrayToString((Object[])ids)).append(")           union all     ").append("   select fid from  t_mm_projecttask ").append("where fprojectid in ( ").append("select fprojectid from(").append("select a1.fprojectid , a1.ftotalCost from ").append("( select fid fprojectid,ftotalCost from  t_mm_project      where fid in ").append(" (select fprojectid from t_mm_projecttask where fid in (").append(SQLUtil.arrayToString((Object[])ids)).append(") and flevel =1 )").append("  )  a1  ").append("  left outer  join ").append("(select fid fprojectid, ftotalCost ").append("from ( ").append("select fprojectid fid,sum(ftotalCost) ftotalCost from t_mm_projecttask ").append("where fprojectid in  ").append("(select fprojectid from t_mm_projecttask where fid in (").append(SQLUtil.arrayToString((Object[])ids)).append(")   and flevel = 1 and fbasestatus in(4,7,5))  ").append("group by fprojectid    ) ").append("union all ").append("select fprojectid, sum(ftotalCost)  ftotalCost from t_mm_projecttask where fid in (").append(SQLUtil.arrayToString((Object[])ids)).append(") and flevel =1 ").append("group by fprojectid  ").append(")   a2  ").append(" on a1.fprojectid = a2.fprojectid  where  a1.ftotalCost < a2.ftotalCost  and a2.fprojectid is not null )) ").append("and flevel =1  and   fid in(").append(SQLUtil.arrayToString((Object[])ids)).append(") ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)psql.toString());
        try {
            while (rs.next()) {
                batchResults.addError(rs.getString("fid"), (Exception)((Object)new ProjectException(ProjectException.PROJECTTASK_COST_ERROR)));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    protected void _close(Context ctx, IObjectPK PK) throws BOSException, EASBizException {
        BatchActionResults result = this.batchClose(ctx, this.buildBatchParam(ctx, PK));
        result.throwExceptions();
    }

    @Override
    protected void _releser(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchActionResults result = this.batchRelese(ctx, this.buildBatchParam(ctx, pk));
        result.throwExceptions();
    }

    @Override
    protected void _unclose(Context ctx, IObjectPK PK) throws BOSException, EASBizException {
        BatchActionResults result = this.batchUnClose(ctx, this.buildBatchParam(ctx, PK));
        result.throwExceptions();
    }

    @Override
    protected void _unReleser(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchActionResults result = this.batchUnRelese(ctx, this.buildBatchParam(ctx, pk));
        result.throwExceptions();
    }

    public BatchActionResults batchClose(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("PRJ_CLOSE"));
    }

    public BatchActionResults batchUnClose(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("PRJ_UNCLOSE"));
    }

    public BatchActionResults batchRelese(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("PRJ_RELESER"));
    }

    public BatchActionResults batchUnRelese(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("PRJ_UNRELESER"));
    }

    public static String getResource(Context ctx, String strKey) {
        String strTemp = ResourceBase.getString((String)"com.kingdee.eas.mm.project.WBSResource", (String)strKey, (Locale)ctx.getLocale());
        return strTemp;
    }

    public void checkClose(Context ctx, BatchActionResults batchResults) throws BOSException {
        Object[] ids = batchResults.getToDoIdsArray();
        String sql = " select distinct fid from t_mm_projecttask t where t.fparentid in(" + SQLUtil.arrayToString((Object[])ids) + ")and fbasestatus in (0,1,2,5,50,70)";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                batchResults.addError(rs.getString("fid"), (Exception)((Object)new ProjectException(ProjectException.PROJECTTASK_COST_ERROR)));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    protected ArrayList _getReleserProjectTask(Context ctx, String projectStr, String orgUnitInfos, String flag) throws BOSException {
        StringBuffer selectSql = new StringBuffer();
        ArrayList<ProjectTaskInfo> projectTaskList = new ArrayList<ProjectTaskInfo>();
        if (orgUnitInfos.length() < 1) {
            return projectTaskList;
        }
        selectSql.append("select a.fnumber fnumber,a.fwbsNumber fwbsNumber,a.fid fid,a.fisTransfered fisTransfered,");
        selectSql.append("a.fprojectid fprojectid,a.fStorageOrgUnitid fStorageOrgUnitid,");
        selectSql.append("a.fBaseStatus fBaseStatus,a.fTaskTypeid fTaskTypeid,a.fisTransferedCentral fisTransferedCentral,");
        selectSql.append("b.fnumber orgnumber,c.fnumber projectnumber from t_mm_projecttask a ");
        selectSql.append("LEFT JOIN T_ORG_Storage b on a.fstorageOrgUnitid = b.fid ");
        selectSql.append("left join T_MM_Project c on a.fprojectid = c.fid ");
        selectSql.append("where a.fprojectid in (");
        selectSql.append(projectStr);
        selectSql.append(") and a.fStorageOrgUnitid in (");
        selectSql.append(orgUnitInfos);
        selectSql.append(") and a.flevel>0 order by a.fprojectid,a.ftasktypeid, a.fwbsNumber");
        HashMap projectMap = new HashMap();
        Connection con = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            resultSet = statement.executeQuery(selectSql.toString());
            while (resultSet.next()) {
                ArrayList list;
                HashMap taskTypeMap;
                HashMap storageMap;
                boolean hasParent = false;
                String taskTypeId = resultSet.getString("fTaskTypeid");
                String storageId = resultSet.getString("fStorageOrgUnitid");
                String projectId = resultSet.getString("fprojectid");
                String isTransfered = resultSet.getString("fisTransfered");
                if (projectMap.get(projectId) == null) {
                    projectMap.put(projectId, new HashMap());
                }
                if ((storageMap = (HashMap)projectMap.get(projectId)).get(storageId) == null) {
                    storageMap.put(storageId, new HashMap());
                }
                if ((taskTypeMap = (HashMap)storageMap.get(storageId)).get(taskTypeId) == null) {
                    taskTypeMap.put(taskTypeId, new ArrayList());
                }
                if ((list = (ArrayList)taskTypeMap.get(taskTypeId)).size() > 0) {
                    for (int x = 0; x < list.size(); ++x) {
                        if (!resultSet.getString("fwbsNumber").startsWith((String)list.get(x))) continue;
                        hasParent = true;
                        break;
                    }
                }
                if (hasParent) continue;
                list.add(resultSet.getString("fwbsNumber"));
                if (resultSet.getInt("fBaseStatus") != 5 || !isTransfered.equals(flag) || !resultSet.getString("fTaskTypeid").equals("uxqG1JcyTNKWqD8KTZatKppMH64=") && !resultSet.getString("fTaskTypeid").equals("AyKjxAUlS9KdlMIjwVdddZpMH64=")) continue;
                ProjectTaskInfo info = new ProjectTaskInfo();
                StorageOrgUnitInfo unit = new StorageOrgUnitInfo();
                ProjectInfo project = new ProjectInfo();
                project.setNumber(resultSet.getString("projectnumber"));
                unit.setNumber(resultSet.getString("orgnumber"));
                unit.setId(BOSUuid.read((String)resultSet.getString("fStorageOrgUnitid")));
                project.setId(BOSUuid.read((String)resultSet.getString("fprojectid")));
                info.setId(BOSUuid.read((String)resultSet.getString("fid")));
                info.setNumber(resultSet.getString("fnumber"));
                info.setWbsNumber(resultSet.getString("fwbsnumber"));
                info.setStorageOrgUnit(unit);
                info.setProject(project);
                projectTaskList.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)statement, (Connection)con);
        return projectTaskList;
    }

    public BatchActionResults batchReqProjectPlan(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("REQPROJECTPLAN"));
    }

    public BatchActionResults batchUnReqProjectPlan(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("UNREQPROJECTPLAN"));
    }

    public void requestPlan(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        int i;
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        Object[] object = this.getTranserProjectTask(ctx, idStr);
        HashSet purSet = (HashSet)object[0];
        ArrayList makeList = (ArrayList)object[1];
        HashMap closePur = (HashMap)object[2];
        ArrayList closeMake = (ArrayList)object[3];
        ArrayList errors = (ArrayList)object[4];
        ArrayList checkMaterial = (ArrayList)object[5];
        HashSet requestSet = new HashSet();
        ArrayList refusedList = new ArrayList();
        ArrayList purTaskId = new ArrayList();
        if (closePur.size() > 0) {
            Object[] purObject = this.getPurRequest(ctx, SQLUtil.arrayToString((Object[])closePur.keySet().toArray()));
            requestSet = (HashSet)purObject[2];
            refusedList = (ArrayList)purObject[0];
            purTaskId = (ArrayList)purObject[1];
        }
        for (int i2 = 0; i2 < refusedList.size(); ++i2) {
            batchResults.addError((String)closePur.get((String)refusedList.get(i2)), (Exception)((Object)new ProjectTaskException(ProjectTaskException.NOT_SAVE)));
            if (!purSet.contains((String)closePur.get((String)refusedList.get(i2)))) continue;
            purSet.remove((String)closePur.get((String)refusedList.get(i2)));
        }
        if (purSet.size() > 0) {
            String botpID = "qkej3IH5RWKyMtcb0BHqTgRRIsQ=";
            BOSObjectType soruceBOSType = BOSObjectType.create((String)"9F1477B3");
            BOSObjectType destBOSType = BOSObjectType.create((String)"25428F2E");
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)purSet, CompareType.INCLUDE));
            viewInfo.setFilter(filter);
            IBOTMapping ibt = BOTMappingFactory.getLocalInstance((Context)ctx);
            BOTMappingInfo botMappingInfo = null;
            BTPTransformResult botpResult = null;
            try {
                botMappingInfo = ibt.getBOTMappingInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)botpID)));
            }
            catch (Exception e) {
                throw new MMCommonException(MMCommonException.BOTPERROR);
            }
            if (!botMappingInfo.getExtRule().isIsEffected()) {
                throw new MMCommonException(MMCommonException.BOTPERROR);
            }
            botpResult = CommonUtils.mapppingToBills((Context)ctx, null, null, (BOSObjectType)soruceBOSType, (BOSObjectType)destBOSType, (String)botpID, (EntityViewInfo)viewInfo);
        }
        List fail = null;
        StringBuffer checkQty = new StringBuffer();
        String sqlStringIds = SQLUtil.arrayToString((Object[])makeList.toArray());
        checkQty.append("select fid from t_mm_projecttask where fid in (").append(sqlStringIds).append(")");
        checkQty.append(" and fqty=0");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checkQty.toString());
        ArrayList<String> checkQtyList = new ArrayList<String>();
        try {
            while (rs.next()) {
                checkQtyList.add(rs.getString("fid"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        makeList.removeAll(checkQtyList);
        if (makeList.size() > 0) {
            fail = this.transertPlan(ctx, makeList, closeMake);
            if (fail == null) {
                for (int i3 = 0; i3 < makeList.size(); ++i3) {
                    batchResults.addError((String)makeList.get(i3), (Exception)((Object)new ProjectTaskException(ProjectTaskException.NOTCANEXCUTEORG)));
                }
                makeList.removeAll(makeList);
            } else if (fail.size() > 0) {
                for (int i4 = 0; i4 < fail.size(); ++i4) {
                    batchResults.addError((String)fail.get(i4), (Exception)((Object)new ProjectTaskException(ProjectTaskException.FAIL_REQUESTPLAN)));
                    if (!makeList.contains(fail.get(i4))) continue;
                    makeList.remove(fail.get(i4));
                }
            }
        }
        for (i = 0; i < errors.size(); ++i) {
            batchResults.addError((String)errors.get(i), (Exception)((Object)new ProjectTaskException(ProjectTaskException.NOT_REQUESTPLAN)));
        }
        for (i = 0; i < checkMaterial.size(); ++i) {
            Object[] o = (Object[])checkMaterial.get(i);
            batchResults.addError((String)o[0], (Exception)((Object)((ProjectTaskException)((Object)o[1]))));
        }
        for (i = 0; i < checkQtyList.size(); ++i) {
            String id = (String)checkQtyList.get(i);
            batchResults.addError(id, (Exception)((Object)new ProjectTaskException(ProjectTaskException.QTY_IS_ZERO)));
        }
        String update = "update t_mm_projecttask set fisTransfered=1 where fid in(" + SQLUtil.arrayToString((Object[])makeList.toArray()) + "," + SQLUtil.arrayToString((Object[])purSet.toArray()) + ")";
        SQLUtil.batchExecuteSql((Context)ctx, (String[])new String[]{update});
    }

    public Object[] getTranserProjectTask(Context ctx, String proTaskId) throws BOSException {
        Connection con = null;
        Statement statement = null;
        ResultSet set = null;
        HashSet<String> purSet = new HashSet<String>();
        ArrayList<String> makeList = new ArrayList<String>();
        HashMap<String, String> closePur = new HashMap<String, String>();
        ArrayList<String[]> closeMake = new ArrayList<String[]>();
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<Object[]> checkMaterial = new ArrayList<Object[]>();
        HashMap projectMap = new HashMap();
        HashMap storUnitMap = new HashMap();
        HashMap taskTypeMap = new HashMap();
        ArrayList list = new ArrayList();
        StringBuffer strBuff = new StringBuffer();
        strBuff.append("select distinct p.fid,p.fprojectid,p.fstorageorgunitid, ");
        strBuff.append("p.fwbsnumber,");
        strBuff.append("p.fisTransfered,p.ftasktypeid,p.fisTransferedCentral from t_mm_projecttask  p ");
        strBuff.append("   left outer join  T_MM_ProjectTaskCentralPurOrg as  porg   on  p.fid =   porg.FParentID   ");
        strBuff.append("where p.fprojectid in (select distinct fprojectid from t_mm_projecttask where fid in ");
        strBuff.append("(");
        strBuff.append(proTaskId);
        strBuff.append(")) and p.ftasktypeid in ('");
        strBuff.append("AyKjxAUlS9KdlMIjwVdddZpMH64=");
        strBuff.append("','");
        strBuff.append("uxqG1JcyTNKWqD8KTZatKppMH64=");
        strBuff.append("') and (p.fisTransfered = 1) ");
        strBuff.append(" order by p.fprojectid ,p.fstorageorgunitid,p.fwbsnumber asc ");
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            set = statement.executeQuery(strBuff.toString());
            while (set.next()) {
                String id = set.getString("fid");
                String projectId = set.getString("fprojectid");
                String storageOrgUnitId = set.getString("fstorageorgunitid");
                Object centralPurStgOrgID = null;
                String tasktypeid = set.getString("ftasktypeid");
                String wbsNumber = set.getString("fwbsnumber");
                String isTransfered = set.getString("fisTransfered");
                String isTransferedCentral = set.getString("fisTransferedCentral");
                if (projectMap.get(projectId) == null) {
                    projectMap.put(projectId, new HashMap());
                }
                storUnitMap = (HashMap)projectMap.get(projectId);
                if (isTransfered.equals("1")) {
                    if (storUnitMap.get(storageOrgUnitId) == null) {
                        storUnitMap.put(storageOrgUnitId, new HashMap());
                    }
                    if ((taskTypeMap = (HashMap)storUnitMap.get(storageOrgUnitId)).get(tasktypeid) == null) {
                        taskTypeMap.put(tasktypeid, new ArrayList());
                    }
                    list = (ArrayList)taskTypeMap.get(tasktypeid);
                    list.add(new String[]{id, wbsNumber});
                    continue;
                }
                if (!isTransferedCentral.equalsIgnoreCase("1")) continue;
                if (storUnitMap.get(centralPurStgOrgID) == null) {
                    storUnitMap.put(centralPurStgOrgID, new HashMap());
                }
                if ((taskTypeMap = (HashMap)storUnitMap.get(centralPurStgOrgID)).get(tasktypeid) == null) {
                    taskTypeMap.put(tasktypeid, new ArrayList());
                }
                list = (ArrayList)taskTypeMap.get(tasktypeid);
                list.add(new String[]{id, wbsNumber});
            }
        }
        catch (SQLException e1) {
            try {
                throw new BOSException((Throwable)e1);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(set, statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)set, (Statement)statement, (Connection)con);
        String strIds = "select distinct  p.fid,p.ftasktypeid,p.fprojectid,p.fstorageorgunitid,p.fwbsnumber  ,p.FMaterialID from t_mm_projecttask  p  left outer join  T_MM_ProjectTaskCentralPurOrg as  porg   on  p.fid =   porg.FParentID where p.fid in (" + proTaskId + ") order by p.fprojectid ,p.fwbsnumber asc ";
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            set = statement.executeQuery(strIds.toString());
            String[] preTask = new String[4];
            while (set.next()) {
                int i;
                ArrayList varList;
                boolean flag = false;
                String id = set.getString("fid");
                String storageOrgUnitId = set.getString("fstorageorgunitid");
                Object centralPurStgOrgID = null;
                String projectId = set.getString("fprojectid");
                String materialId = set.getString("FMaterialID");
                String wbsNumber = set.getString("fwbsnumber");
                String tasktype = set.getString("ftasktypeid");
                if (projectId.equals(preTask[0]) && storageOrgUnitId.equals(preTask[1]) && tasktype.equalsIgnoreCase(preTask[2]) && wbsNumber.startsWith(preTask[3])) {
                    flag = true;
                    errors.add(id);
                } else if (projectMap.get(projectId) != null && ((HashMap)projectMap.get(projectId)).get(storageOrgUnitId) != null && ((HashMap)((HashMap)projectMap.get(projectId)).get(storageOrgUnitId)).get(tasktype) != null) {
                    varList = (ArrayList)((HashMap)((HashMap)projectMap.get(projectId)).get(storageOrgUnitId)).get(tasktype);
                    for (i = 0; i < varList.size(); ++i) {
                        if (!id.equals(((String[])varList.get(i))[0]) && ((String[])varList.get(i))[1].startsWith(wbsNumber)) {
                            if (tasktype.equals("AyKjxAUlS9KdlMIjwVdddZpMH64=")) {
                                closePur.put(((String[])varList.get(i))[0], id);
                                continue;
                            }
                            closeMake.add(new String[]{((String[])varList.get(i))[0], id, ((String[])varList.get(i))[1]});
                            continue;
                        }
                        if (id.equals(((String[])varList.get(i))[0]) || !wbsNumber.startsWith(((String[])varList.get(i))[1])) continue;
                        flag = true;
                        errors.add(id);
                        break;
                    }
                } else if (projectMap.get(projectId) != null && ((HashMap)projectMap.get(projectId)).get(centralPurStgOrgID) != null && ((HashMap)((HashMap)projectMap.get(projectId)).get(centralPurStgOrgID)).get(tasktype) != null) {
                    varList = (ArrayList)((HashMap)((HashMap)projectMap.get(projectId)).get(centralPurStgOrgID)).get(tasktype);
                    for (i = 0; i < varList.size(); ++i) {
                        if (!id.equals(((String[])varList.get(i))[0]) && ((String[])varList.get(i))[1].startsWith(wbsNumber)) {
                            if (tasktype.equals("AyKjxAUlS9KdlMIjwVdddZpMH64=")) {
                                closePur.put(((String[])varList.get(i))[0], id);
                                continue;
                            }
                            closeMake.add(new String[]{((String[])varList.get(i))[0], id, wbsNumber});
                            continue;
                        }
                        if (id.equals(((String[])varList.get(i))[0]) || !wbsNumber.startsWith(((String[])varList.get(i))[1])) continue;
                        flag = true;
                        errors.add(id);
                        break;
                    }
                }
                if (!flag) {
                    if (materialId == null) {
                        checkMaterial.add(new Object[]{id, new ProjectTaskException(ProjectTaskException.NO_MATERIAL)});
                    } else if (tasktype.equals("uxqG1JcyTNKWqD8KTZatKppMH64=")) {
                        makeList.add(id);
                    } else {
                        ProjectTaskException taskException = this.checkMaterialPurchase(ctx, new String[]{materialId, storageOrgUnitId});
                        if (taskException != null) {
                            checkMaterial.add(new Object[]{id, taskException});
                        } else {
                            purSet.add(id);
                        }
                    }
                }
                preTask = new String[]{projectId, storageOrgUnitId, tasktype, wbsNumber};
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        finally {
            SQLUtils.cleanup((ResultSet)set, (Statement)statement, (Connection)con);
        }
        return new Object[]{purSet, makeList, closePur, closeMake, errors, checkMaterial};
    }

    public void unRequestPlan(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        int i;
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        Object con = null;
        Object statement = null;
        Object set = null;
        Object[] object = this.getTranserProjectTask(ctx, idStr);
        HashSet purSet = (HashSet)object[0];
        ArrayList makeList = (ArrayList)object[1];
        HashMap closePur = (HashMap)object[2];
        ArrayList closeMake = (ArrayList)object[3];
        ArrayList errors = (ArrayList)object[4];
        HashSet requestSet = new HashSet();
        ArrayList refusedList = new ArrayList();
        ArrayList purTaskId = new ArrayList();
        if (purSet.size() > 0) {
            Object[] purObject = this.getPurRequest(ctx, SQLUtil.arrayToString((Object[])purSet.toArray()));
            requestSet = (HashSet)purObject[2];
            refusedList = (ArrayList)purObject[0];
            purTaskId = (ArrayList)purObject[1];
        }
        for (int i2 = 0; i2 < refusedList.size(); ++i2) {
            batchResults.addError((String)refusedList.get(i2), (Exception)((Object)new ProjectTaskException(ProjectTaskException.CUR_NOT_SAVE)));
            if (!purSet.contains((String)refusedList.get(i2))) continue;
            purSet.remove((String)refusedList.get(i2));
        }
        List fail = null;
        if (makeList.size() > 0) {
            fail = this.unTransertPlan(ctx, makeList, closeMake);
            if (fail == null) {
                for (i = 0; i < makeList.size(); ++i) {
                    batchResults.addError((String)makeList.get(i), (Exception)((Object)new ProjectTaskException(ProjectTaskException.NOTCANEXCUTEORG)));
                }
                makeList.removeAll(makeList);
            } else if (fail.size() > 0) {
                for (i = 0; i < fail.size(); ++i) {
                    batchResults.addError((String)fail.get(i), (Exception)((Object)new ProjectTaskException(ProjectTaskException.FAILED_UNREQUEST)));
                    if (!makeList.contains(fail.get(i))) continue;
                    makeList.remove(fail.get(i));
                }
            }
        }
        for (i = 0; i < errors.size(); ++i) {
            batchResults.addError((String)errors.get(i), (Exception)((Object)new ProjectTaskException(ProjectTaskException.NOT_REQUESTPLAN)));
        }
        String update = "update t_mm_projecttask set fisTransfered=0 where fid in(" + SQLUtil.arrayToString((Object[])makeList.toArray()) + "," + SQLUtil.arrayToString((Object[])purTaskId.toArray()) + ")";
        SQLUtil.batchExecuteSql((Context)ctx, (String[])new String[]{update});
    }

    public Object[] getPurRequest(Context ctx, String string) throws BOSException {
        Connection con = null;
        Statement statement = null;
        ResultSet set = null;
        StringBuffer buffer = new StringBuffer();
        ArrayList<String> purTaskId = new ArrayList<String>();
        HashSet<String> reqList = new HashSet<String>();
        ArrayList<String> refusedList = new ArrayList<String>();
        buffer.append("select t1.fid projecttaskid,t1.ftasktypeid as tasktypeid ,t2.id purrequestid,t2.BASESTATUS BASESTATUS from(  ");
        buffer.append("SELECT fid,fnumber,ftasktypeid,FMATERIALID,FCarNumberID,FProjectID  FROM T_MM_ProjectTask AS PROJECTTASK ");
        buffer.append("  where PROJECTTASK.fid in  (");
        buffer.append(string);
        buffer.append(")) t1 left join ( ");
        buffer.append("SELECT PURREQUEST.FID AS ID, PURREQUEST.FBaseStatus AS BASESTATUS,ENTRIES.fMATERIAlid AS MATERIALID, ENTRIES.fsourcebillnumber  ");
        buffer.append("fsourcebillnumber, ENTRIES.FTrackNoID AS ENTRIESTRACKNUMBER,ENTRIES.FProjectID AS FProjectID FROM T_SM_PurRequest AS PURREQUEST  ");
        buffer.append("left  JOIN T_SM_PurRequestEntry AS ENTRIES ON PURREQUEST.FID = ENTRIES.FParentID ");
        buffer.append(") t2 on t1.fMATERIALID = t2.MATERIALID AND t1.FProjectID = t2.FProjectID and t1.fnumber = t2.fsourcebillnumber  ");
        buffer.append("where ( t1.FCarNumberID   is null or t1.FCarNumberID = t2.ENTRIESTRACKNUMBER or t2.id is null )");
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            set = statement.executeQuery(buffer.toString());
            while (set.next()) {
                String id = set.getString("projecttaskid");
                String requestId = set.getString("purrequestid");
                int baseStatus = set.getInt("BASESTATUS");
                if (set.getString("BASESTATUS") != null && baseStatus != 1) {
                    refusedList.add(id);
                    continue;
                }
                purTaskId.add(id);
                if (set.getString("BASESTATUS") == null) continue;
                reqList.add(requestId);
            }
            if (reqList.size() > 0) {
                IPurRequest purRequest = PurRequestFactory.getLocalInstance((Context)ctx);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", reqList, CompareType.INCLUDE));
                purRequest.delete(filter);
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(set, statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)set, (Statement)statement, (Connection)con);
        return new Object[]{refusedList, purTaskId, reqList};
    }

    public BatchActionResults batchConfirmCostImport(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("CONFIRMCOSTIMP"));
    }

    public void updateConfirmCostImport(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException {
        Connection conn = null;
        Statement statement = null;
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        String idParent = "";
        BatchExecuteParamsEntry[] entries = batchResults.getParamEntries();
        try {
            JdbcRowSet rowset = new JdbcRowSet();
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            StringBuffer selectMaxCost = new StringBuffer();
            selectMaxCost.append("select distinct fparentid from t_mm_projecttask where fid in (" + idStr + ") and flevel > 1  union ");
            selectMaxCost.append("select fid fparentid from t_mm_projecttask where FProjectID in (select distinct FProjectID from t_mm_projecttask where fid in (" + idStr + ") and flevel = 1) and flevel = 0");
            ResultSet rsParentId = statement.executeQuery(selectMaxCost.toString());
            ArrayList<String> arrayList = new ArrayList<String>();
            while (rsParentId.next()) {
                arrayList.add(rsParentId.getString("fparentid"));
            }
            idParent = SQLUtil.arrayToString((Object[])arrayList.toArray());
            statement.execute("update t_mm_projecttask set fid = fid where fid in (" + idParent + ")");
            selectMaxCost = new StringBuffer();
            selectMaxCost.append("select fid id,FWbsNumber wbsnumber, case when flevel=1 then FProjectID when flevel > 1 then fparentid end parentid,flevel projecttasklevel from t_mm_projecttask where fid in (" + idStr + ") order by flevel,fwbsnumber");
            ResultSet rsSelect = statement.executeQuery(selectMaxCost.toString());
            rowset.populate(rsSelect);
            while (rowset.next()) {
                String parentid = rowset.getString("parentid");
                String id = rowset.getString("id");
                int level = rowset.getInt("projecttasklevel");
                ProjectTaskInfo info = null;
                for (int i = 0; i < entries.length && !id.equals((info = (ProjectTaskInfo)entries[i].get(0)).getId().toString()); ++i) {
                }
                String stringSum = null;
                ResultSet rsCostSum = null;
                String string = null;
                ResultSet rsCost = null;
                if (level > 1) {
                    stringSum = "select isnull(sum(ftotalcost),0) ftotalcost from t_mm_projecttask where fparentid = '" + parentid + "' and fid !='" + id + "'";
                    string = "select ftotalcost from t_mm_projecttask where fid = '" + parentid + "'";
                } else {
                    stringSum = "select isnull(sum(ftotalcost),0) ftotalcost from t_mm_projecttask where FProjectID = '" + parentid + "' and fid !='" + id + "' and flevel =1";
                    string = "select b.ftotalcost ftotalcost from t_mm_projecttask a,t_mm_project b where a.FProjectID = b.fid and a.fid ='" + id + "'";
                }
                BigDecimal costSum = new BigDecimal(0);
                BigDecimal cost = new BigDecimal(0);
                rsCostSum = statement.executeQuery(stringSum);
                if (rsCostSum.next()) {
                    costSum = rsCostSum.getBigDecimal(1);
                }
                if ((rsCost = statement.executeQuery(string)).next()) {
                    cost = rsCost.getBigDecimal(1);
                }
                if (info != null && cost.add(costSum.negate()).add(info.getTotalCost().negate()).signum() >= 0) {
                    String update = "update t_mm_projecttask set fbasestatus = 60 ,ftotalcost=" + info.getTotalCost() + ",funitCost =" + info.getUnitCost() + " where fid = '" + id + "'";
                    statement.executeUpdate(update);
                    continue;
                }
                throw new ProjectTaskException(ProjectTaskException.INVALID_COST);
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
    }

    @Override
    protected void _reqProjectPlan(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchActionResults result = this.batchForwardSchedule(ctx, this.buildBatchParam(ctx, pk));
        result.throwExceptions();
    }

    @Override
    protected void _unReqProjectPlan(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchActionResults result = this.batchForwardSchedule(ctx, this.buildBatchParam(ctx, pk));
        result.throwExceptions();
    }

    public void closeProjectTask(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        String sql = "select FWBSNUMBER,FID,FPROJECTID,FNUMBER from  t_mm_projecttask where fwbsnumber is not null and Fid in (" + idStr + ") order by FWBSNUMBER desc";
        Connection con = null;
        Statement statement1 = null;
        Statement statement = null;
        ResultSet resultSet = null;
        IRowSet closeStatus = null;
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            resultSet = statement.executeQuery(sql);
            while (resultSet.next()) {
                String FWbsNumber = resultSet.getString("FWBSNUMBER");
                String FProjectId = resultSet.getString("FPROJECTID");
                String FNumber = resultSet.getString("FNUMBER");
                String FID = resultSet.getString("FID");
                String closeSql = "select FID,FBASESTATUS,FNUMBER from t_mm_projecttask where fwbsnumber like '?%' and fwbsnumber <> ? and FPROJECTID=?";
                closeStatus = DbUtil.executeQuery((Context)ctx, (String)closeSql, (Object[])new Object[]{FWbsNumber, FWbsNumber, FProjectId});
                while (closeStatus.next()) {
                    int fbaseStatus = -1;
                    fbaseStatus = closeStatus.getInt("FBASESTATUS");
                    if (fbaseStatus == 7) continue;
                    batchResults.addError(FID, (Exception)((Object)new ProjectTaskException(ProjectTaskException.CHILD_TASK_NOT_CLOSED, new String[]{closeStatus.getString("FNUMBER"), FNumber})));
                }
                if (closeStatus == null) continue;
                closeStatus = null;
            }
            batchResults.getToDoIdsArray();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, statement, (Connection)con);
                SQLUtils.cleanup(closeStatus);
                SQLUtils.cleanup(statement1);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)statement, (Connection)con);
        SQLUtils.cleanup(closeStatus);
        SQLUtils.cleanup(statement1);
    }

    @Override
    protected void _allTranser(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchActionResults result = this.batchAllTranser(ctx, this.buildBatchParam(ctx, pk));
        result.throwExceptions();
    }

    @Override
    protected void _unAllTranser(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchActionResults result = this.batchUnAllTranser(ctx, this.buildBatchParam(ctx, pk));
        result.throwExceptions();
    }

    public BatchActionResults batchAllTranser(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("PRJ_ALLTRANSER"));
    }

    public BatchActionResults batchUnAllTranser(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("PRJ_UNALLTRANSER"));
    }

    protected void checkAllTranserMete(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct temp.fid from ( ").append("  select  t1.fid from t_mm_projecttask t1 ").append(" left outer join  t_mm_project t2 on t1.fprojectid=t2.fid ").append("   where ( t2.FProjecttypeID='U+F6TI7tSwWsxrdj4TYytZpMH64='   and ").append(" t1.FTaskTypeID in('mEO3X6Y0RxqFu6+ypiPdoppMH64=','AyKjxAUlS9KdlMIjwVdddZpMH64=')  )").append(" and t1.fid in (").append(idStr).append(")      ").append("       union all     ").append(" select  t1.fid from t_mm_projecttask t1, t_mm_projecttask t2 ").append(" where SUBSTRING(t2.fwbsnumber,0,LENGTH(t1.fwbsnumber) + 1 ) = t1.fwbsnumber || '.' AND t1.FLevel < t2.flevel  ").append("  and t2.fprojectid =t1.fprojectid    and t1.fid in (").append(idStr).append(") ").append(" and t2.FTaskTypeID='AyKjxAUlS9KdlMIjwVdddZpMH64=' and t2.FIsTransfered=1   ").append("   union all   ").append("  select  t1.fid from t_mm_projecttask t1 ").append(" left outer join  t_mm_project t2 on t1.fprojectid=t2.fid ").append("   where ( t2.FProjecttypeID='U+F6TI7tSwWsxrdj4TYytZpMH64='   and ").append(" t1.FTaskTypeID in('LCjtHmEGRSCChKDBR/R9jJpMH64=','uxqG1JcyTNKWqD8KTZatKppMH64=')  )").append(" and t1.FMATERIALID is null   and t1.fid in (").append(idStr).append(")    union all  ").append("  select   t1.fid  from t_mm_projecttask t1 ,t_mm_projecttask   t2  ").append(",  t_mm_project   t3  where  t3.fid= t1.fprojectid ").append(" and SUBSTRING(t1.fwbsnumber,0,LENGTH(t2.fwbsnumber) + 1 ) = t2.fwbsnumber || '.' AND t1.FLevel > t2.flevel ").append("and t2.fprojectid =t1.fprojectid   ").append(" and  t1.fstorageOrgUnitId =t2.fstorageOrgUnitId  ").append("and  t2.fid in (").append(idStr).append(")  ").append("  ) temp");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                batchResults.addError(rs.getString("fid"), (Exception)((Object)new ProjectException(ProjectException.PRROJECT_ALLCHUANLIANG)));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    protected void checkAllTranserTrial(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        String sql = "  select distinct t1.fid from t_mm_projecttask t1  left outer join  t_mm_project t2 on t1.fprojectid=t2.fid    where  t2.FProjecttypeID='3wKAJXGVQDCR67xs+7qRWJpMH64='  and t1.FTaskTypeID in('mEO3X6Y0RxqFu6+ypiPdoppMH64=')   and t1.fid in (" + idStr + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                batchResults.addError(rs.getString("fid"), (Exception)((Object)new ProjectException(ProjectException.PROJECT_IS_SYSTELIST)));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    protected void checkUnAllTranserTrial(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        String sql = "select t1.fid  from t_mm_projecttask t1, t_mm_projecttask t2   where SUBSTRING(t1.fwbsnumber,0,LENGTH(t2.fwbsnumber) + 1 ) = t2.fwbsnumber || '.' AND t1.FLevel > t2.flevel  and t2.fprojectid =t1.fprojectid   and t1.fid in (" + idStr + ")  and t1.FTaskTypeID =t2.FTaskTypeID  and t2.fstorageOrgUnitId  = t1.fstorageOrgUnitId  and t2.FIsTransferedCentral=1 ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                batchResults.addError(rs.getString("fid"), (Exception)((Object)new ProjectException(ProjectException.PROJECT_TRANE_ISEROR)));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    protected void checkAllTranserTrialCaigou(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        String sql = "select fid from t_mm_projecttask where ftasktypeid='AyKjxAUlS9KdlMIjwVdddZpMH64=' and  fisTransfered=1 and fid in (" + idStr + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                batchResults.addError(rs.getString("fid"), (Exception)((Object)new ProjectException(ProjectException.PROJECT_IS_PUTONG)));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    protected void checkAllTranserTrialMertrail(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        StringBuffer sql = new StringBuffer();
        sql.append("  select  t1.fid from t_mm_projecttask t1 ").append(" left outer join  t_mm_project t2 on t1.fprojectid=t2.fid ").append("   where ( t2.FProjecttypeID='U+F6TI7tSwWsxrdj4TYytZpMH64='   and ").append(" t1.FTaskTypeID in('mEO3X6Y0RxqFu6+ypiPdoppMH64=','AyKjxAUlS9KdlMIjwVdddZpMH64=')  )").append(" and t1.FMATERIALID is null   and t1.fid in (").append(idStr).append(")   ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                batchResults.addError(rs.getString("fid"), (Exception)((Object)new ProjectException(ProjectException.PROJECT_IS_PUTONG)));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private boolean compareTwoDateAfter(Date first, Date second) {
        Calendar calendar = this.toCalendar(first);
        Date date1 = calendar.getTime();
        calendar = this.toCalendar(second);
        Date date2 = calendar.getTime();
        return date1.getTime() > date2.getTime();
    }

    private boolean compareTwoDateBefore(Date first, Date second) {
        Calendar calendar = this.toCalendar(first);
        Date date1 = calendar.getTime();
        calendar = this.toCalendar(second);
        Date date2 = calendar.getTime();
        return date1.getTime() < date2.getTime();
    }

    private Calendar toCalendar(Date theDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(theDate);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    private boolean checkProjectTaskId(Context ctx, BatchActionResults batchResults, String taskId) throws BOSException {
        String sql = "select count(fpretaskid) countPreTask from t_mm_projecttask t1 ,(select fwbsnumber,fprojectid from t_mm_projecttask where fid  = '" + taskId + "'  ) t2 where t1.fprojectid = t2.fprojectid   and  substring(t1.fwbsnumber,0,LENGTH(t2.fwbsnumber)) = t2.fwbsnumber";
        try {
            int count = 0;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                count = rs.getInt("countPreTask");
            }
            if (count != 0) {
                batchResults.addError(taskId, (Exception)((Object)new ProjectTaskException(ProjectTaskException.HAS_PRETASK)));
                return false;
            }
            return true;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private ProjectTaskException checkMaterialPurchase(Context ctx, String[] params) throws BOSException {
        ArrayList<ProjectTaskException> list = new ArrayList<ProjectTaskException>();
        StringBuffer sb = new StringBuffer();
        sb.append("select fstatus from T_BD_MaterialPurchasing where FMaterialID =?");
        sb.append("  and forgunit in (select FToUnitID from T_ORG_UnitRelation where FTypeRelationID");
        sb.append("='00000000-0000-0000-0000-0000000000080FE9F8B5' and FFromUnitID=? )");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])params);
        try {
            if (rs.next()) {
                if (!"1".equals(rs.getString("fstatus"))) {
                    list.add(new ProjectTaskException(ProjectTaskException.MATERIALPURCHASE));
                }
            } else {
                list.add(new ProjectTaskException(ProjectTaskException.MATERIALPURCHASE));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String materialID = params[0];
        String storageOrgUnit = params[1];
        FilterInfo matFilter = new FilterInfo();
        matFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID));
        matFilter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storageOrgUnit));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(matFilter);
        MaterialPlanCollection colls = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanCollection(viewInfo);
        MaterialPlanInfo comInfo = colls.get(0);
        if (comInfo == null || comInfo.isIsCentralizedPar()) {
            list.add(new ProjectTaskException(ProjectTaskException.ISCENTRALIZEDPAR));
        }
        if (list.size() == 1) {
            return (ProjectTaskException)((Object)list.get(0));
        }
        if (list.size() == 2) {
            return new ProjectTaskException(ProjectTaskException.ISCENTRALIZEDPAR_MATERIALPURCHASE);
        }
        return null;
    }

    private void checkMaterial(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        StringBuffer sqlM = new StringBuffer();
        sqlM.append(" select distinct temp.fid from  (");
        sqlM.append("  select p.fid from  t_mm_projecttask p   ");
        sqlM.append("   inner join  T_MM_ProjectTaskCentralPurOrg as  porg   on  p.fid =   porg.FParentID   ");
        sqlM.append("  left outer join T_BD_MaterialPlan  t on  p.FMaterialID =t.FMaterialID and  porg.FStorageOrgUnitID =t.forgunit ");
        sqlM.append("  left outer join  t_mm_project x on p.fprojectid =x.fid  ");
        sqlM.append(" where  x.FProjecttypeID='U+F6TI7tSwWsxrdj4TYytZpMH64=' ");
        sqlM.append(" and p.fid in (");
        sqlM.append(idStr);
        sqlM.append(")  and (t.fid is null or t.fstatus =0) ");
        sqlM.append("   union all  ");
        sqlM.append("  select p.fid from  t_mm_projecttask p   ");
        sqlM.append("   inner join  T_MM_ProjectTaskCentralPurOrg as  porg   on  p.fid =   porg.FParentID   ");
        sqlM.append("  left outer join T_BD_MaterialInventory  t on  p.FMaterialID =t.FMaterialID and  porg.FStorageOrgUnitID =t.forgunit ");
        sqlM.append("  left outer join  t_mm_project x on p.fprojectid =x.fid  ");
        sqlM.append(" where  x.FProjecttypeID='U+F6TI7tSwWsxrdj4TYytZpMH64=' ");
        sqlM.append(" and p.fid in (");
        sqlM.append(idStr);
        sqlM.append(")  and (t.fid is null or t.fstatus =0) ");
        sqlM.append("   union all  ");
        sqlM.append("   select p.fid   from T_BD_Material  t, t_mm_projecttask p  ");
        sqlM.append(" left outer join  t_mm_project x on p.fprojectid =x.fid   ");
        sqlM.append("where  t.fID=p.FMaterialID  and x.FProjecttypeID='U+F6TI7tSwWsxrdj4TYytZpMH64='  ");
        sqlM.append("  and t.fID in (select FMaterialID from t_mm_projecttask where fid in(");
        sqlM.append(idStr);
        sqlM.append("))   and t.fstatus =0  and p.fid in ( ");
        sqlM.append(idStr);
        sqlM.append(" )) temp ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlM.toString());
        try {
            while (rs.next()) {
                batchResults.addError(rs.getString("fid"), (Exception)((Object)new ProjectException(ProjectException.PROJECT_METAIL_AUDIT)));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    protected void _unConfirmCost(Context ctx, IObjectValue model, IObjectPK pk) throws BOSException, EASBizException {
        BatchActionResults result = this.batchUnConfirmCost(ctx, this.buildBatchParam(ctx, model, pk));
        result.throwExceptions();
    }

    protected String getDeleteTableName() {
        return "t_mm_projecttask";
    }
}

