/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.mm.project.ProjectTaskPlanningFacadeFactory;
import com.kingdee.eas.mm.project.ProjectTaskPlanningReportUtil;
import com.kingdee.eas.mm.project.app.AbstractProjectTaskPlanningFacadeControllerBean;
import com.kingdee.eas.mm.project.app.ReportUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ProjectTaskPlanningFacadeControllerBean
extends AbstractProjectTaskPlanningFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.project.app.ProjectTaskPlanningFacadeControllerBean");

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        ProjectTaskPlanningReportUtil util = new ProjectTaskPlanningReportUtil(ctx, params);
        StringBuffer createTableMain = this.getTempTableMain();
        String tempTable = params.getString("tempTable");
        try {
            if (tempTable != null) {
                ProjectTaskPlanningFacadeFactory.getLocalInstance(ctx).dropTempTable(tempTable);
            }
            tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(createTableMain.toString());
            logger.error((Object)("Mandy : err Table Name is " + tempTable));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        DbUtil.execute((Context)ctx, (String)this.insertTempTable(ctx, tempTable, params, util));
        RptParams result = new RptParams();
        result.setString("tempTable", tempTable);
        result.setObject("peroidType", (Object)util.getPeroidType());
        result.setObject("peroidRang", (Object)util.getPeroidRang());
        return result;
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        String tempTable = params.getString("tempTable");
        StringBuffer selectsql = new StringBuffer();
        selectsql.append("select * from ");
        selectsql.append(tempTable);
        selectsql.append(" where KSQL_SEQ >= ");
        selectsql.append(from + 1);
        selectsql.append(" and KSQL_SEQ <= ");
        selectsql.append(from + len);
        Connection con = null;
        Statement statement = null;
        ResultSet followSet = null;
        RptRowSet rsSelect = null;
        con = this.getConnection(ctx);
        try {
            statement = con.createStatement(1004, 1007);
            followSet = statement.executeQuery(selectsql.toString());
            rsSelect = RptRowSet.parse((ResultSet)followSet, (int)0, (int)len);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(followSet);
                SQLUtils.cleanup((Statement)statement);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)followSet);
        SQLUtils.cleanup((Statement)statement);
        SQLUtils.cleanup((Connection)con);
        Object[][] datas = rsSelect.toArray();
        RptParams result = new RptParams();
        result.setString("tempTable", tempTable);
        result.setObject("datas", (Object)datas);
        result.setObject("rowset", (Object)rsSelect);
        return result;
    }

    private String insertTempTable(Context ctx, String tempTableNameMain, RptParams filter, ProjectTaskPlanningReportUtil util) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempTableNameMain + " ( KSQL_SEQ , FStorageName , FProjectName , FTaskType , FTaskName , FMaterialName , FMileStone ,FID , FPlanBeginTime , FPlanEndTime , FQty , FQtyPrecision , FParentID , FStorageID , FMeasureUnit ");
        sql.append(" ) \n");
        sql.append(this.buildTempSelectResult(ctx, filter, util));
        return sql.toString();
    }

    private StringBuffer buildTempSelectResult(Context ctx, RptParams filter, ProjectTaskPlanningReportUtil util) throws BOSException, EASBizException {
        Locale locale = ctx.getLocale();
        StringBuffer sb = new StringBuffer();
        sb.append("select ");
        sb.append("       t2.fname_" + locale + "  as FStorageName, \n");
        sb.append("       t1.fname_" + locale + "  as FProjectName, \n");
        sb.append("       t5.fname_" + locale + "  as FTaskType, \n");
        sb.append("       t.fname_" + locale + "  as FTaskName, \n");
        sb.append("       t3.fname_" + locale + "  as FMaterialName, \n");
        sb.append("       \t t.FIsMileStone        as FMileStone, \n");
        sb.append("       \t t.FID                 as FID, \n");
        sb.append("       \t t.FPlanBeginTime      as FPlanBeginTime, \n");
        sb.append("       \t t.FPlanEndTime        as FPlanEndTime, \n");
        sb.append("       \t t.FQty                as FQty, \n");
        sb.append("       \t isnull(t4.FQtyPrecision,0)  \n");
        sb.append("       \t   as FQtyPrecision, \n");
        sb.append("       \t t.FParentID           as FParentID , \n");
        sb.append("       \t t2.FID as FStorageID, \n");
        sb.append("       \t t6.FName_" + locale + " as FMeasureUnit \n");
        sb.append("  from T_MM_ProjectTask t \n");
        sb.append("  left join T_MM_Project t1 on t.FProjectID = t1.FID \n");
        sb.append("  left join T_ORG_Storage t2 on t.FStorageOrgUnitID = t2.FID \n");
        sb.append("  left join T_BD_Material t3 on t.FMaterialID = t3.FID  \n");
        sb.append("  left join T_BD_MultiMeasureUnit t4 on t.FMaterialID = t4.FMaterialID  and t.FUnitID = t4.FMeasureUnitID \n");
        sb.append("  left join T_MM_ProjectDictData t5 on t.FTaskTypeID = t5.FID \n");
        sb.append("  left join t_bd_measureunit t6 on t.funitid = t6.fid \n");
        sb.append(this.buildFilter(filter, util));
        sb.append(" order by t2.FNumber,t1.FNumber,t.FNumber");
        logger.error((Object)(new Date() + "-- Mandy : " + sb));
        return sb;
    }

    private String buildFilter(RptParams filter, ProjectTaskPlanningReportUtil util) {
        int expectationNum = new Integer(filter.getString("expectationNum"));
        String storageOrg = filter.getString("storageOrgUnit.number");
        String projectNum = filter.getString("project.numberF");
        String taskNumF = filter.getString("task.numberF");
        Calendar beginTime = util.buildBeginTime(filter.getString("beginTime"));
        String beginTimeStr = util.time2String(beginTime, "begin");
        Calendar endTime = util.getExpectationEndTime(beginTime.getTime(), expectationNum);
        String endTimeStr = util.time2String(endTime, "end");
        boolean mileStone = filter.getBoolean("mileStone");
        StringBuffer sb = new StringBuffer();
        sb.append(" WHERE ");
        sb.append(" t2.FNumber in ( " + ReportUtil.StringUtil(storageOrg) + " ) ");
        sb.append(" and ");
        sb.append("t.fbasestatus in (");
        sb.append(5);
        sb.append(",");
        sb.append(4);
        sb.append(") ");
        sb.append("\n AND t1.FNumber in ( " + ReportUtil.StringUtil(projectNum) + " ) ");
        if (taskNumF != null && !"".equals(taskNumF)) {
            sb.append(" and ");
            sb.append("  t.FNumber in ( " + ReportUtil.StringUtil(taskNumF) + ") ");
        }
        if (beginTime != null) {
            sb.append(" AND t.FPlanEndTime >= to_date('" + beginTimeStr + "') ");
        }
        if (endTime != null) {
            sb.append(" AND t.FPlanEndTime <= to_date('" + endTimeStr + "') ");
        }
        if (mileStone) {
            sb.append("\n AND t.FIsMileStone = 1");
        }
        return sb.toString();
    }

    private StringBuffer getTempTableMain() {
        StringBuffer createTable = new StringBuffer();
        createTable.append("CREATE TABLE tempPlanning (");
        createTable.append("KSQL_SEQ INT IDENTITY (1, 1) not null");
        createTable.append(",FStorageName   varchar(255) ");
        createTable.append(",FProjectName   varchar(255) ");
        createTable.append(",FTaskType      varchar(44)  ");
        createTable.append(",FTaskName      varchar(255) ");
        createTable.append(",FMaterialName  varchar(255) ");
        createTable.append(",FMileStone     int default(0)");
        createTable.append(",FID            varchar(44)  ");
        createTable.append(",FPlanBeginTime DateTime  ");
        createTable.append(",FPlanEndTime DateTime  ");
        createTable.append(",FQty Decimal(21,8)  default(0)");
        createTable.append(",FQtyPrecision int  default(0)");
        createTable.append(",FParentID       varchar(44)  ");
        createTable.append(",FStorageID      varchar(44)  ");
        createTable.append(",FMeasureUnit    varchar(255) ");
        createTable.append(")");
        return createTable;
    }

    protected void _dropTempTable(Context ctx, String tableName) throws BOSException, EASBizException {
        try {
            if (tableName != null && tableName.length() != 0) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tableName);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

