/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.kdf.formatter.DateParser;
import com.kingdee.bos.ctrl.kdf.formatter.FormatException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.project.app.ReportUtil;
import com.kingdee.eas.mm.project.app.TaskObject4Planning;
import com.kingdee.eas.mm.project.util.MMProjectCalendarFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ProjectTaskPlanningReport
extends ReportServerBase {
    private static final Logger logger = CoreUIObject.getLogger(ProjectTaskPlanningReport.class);
    private int issueType;
    private int expectationNum;
    private Map facCalendarMap = new HashMap();
    private ArrayList precision = new ArrayList();

    protected String buildReportDataForVirtual(String reportID, RptParams filter, String parm) throws BOSException, EASBizException {
        String tempTableNameMain;
        this.issueType = new Integer(filter.getString("planningType"));
        this.expectationNum = new Integer(filter.getString("expectationNum"));
        StringBuffer createTableMain = this.getTempTableMain(this.expectationNum);
        try {
            tempTableNameMain = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTableMain.toString());
            logger.error((Object)("Mandy : err Table Name is " + tempTableNameMain));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        DbUtil.execute((Context)this.getContext(), (String)this.insertTempTable(tempTableNameMain, filter, parm));
        this.buildPlanning(filter, tempTableNameMain, parm);
        return tempTableNameMain;
    }

    private StringBuffer buildTempSelectResult(RptParams filter, String parm) throws BOSException, EASBizException {
        Locale locale = this.getContext().getLocale();
        StringBuffer sb = new StringBuffer();
        sb.append("select ");
        sb.append("       t2.fname_" + locale + "  as FStorageName, \n");
        sb.append("       t1.fname_" + locale + "  as FProjectName, \n");
        sb.append("       t5.fname_" + locale + "  as FTaskType, \n");
        sb.append("       t.fname_" + locale + "  as FTaskName, \n");
        sb.append("       t3.fname_" + locale + "  as FMaterialName, \n");
        sb.append("       \t t.FIsMileStone        as FMileStone, \n");
        sb.append("       \t t.FID                 as FID, \n");
        sb.append("       \t t.FPlanBeginTime      as FPlanBeginTime, \n");
        sb.append("       \t t.FPlanEndTime        as FPlanEndTime, \n");
        sb.append("       \t t.FQty                as FQty, \n");
        sb.append("       \t isnull(t4.FQtyPrecision,0)  \n");
        sb.append("       \t   as FQtyPrecision, \n");
        sb.append("       \t t.FParentID           as FParentID , \n");
        sb.append("       \t t2.FID as FStorageID, \n");
        sb.append("       \t t6.FName_" + locale + " as FMeasureUnit \n");
        sb.append("  from T_MM_ProjectTask t \n");
        sb.append("  left join T_MM_Project t1 on t.FProjectID = t1.FID \n");
        sb.append("  left join T_ORG_Storage t2 on t.FStorageOrgUnitID = t2.FID \n");
        sb.append("  left join T_BD_Material t3 on t.FMaterialID = t3.FID  \n");
        sb.append("  left join T_BD_MultiMeasureUnit t4 on t.FMaterialID = t4.FMaterialID  and t.FUnitID = t4.FMeasureUnitID \n");
        sb.append("  left join T_MM_ProjectDictData t5 on t.FTaskTypeID = t5.FID \n");
        sb.append("  left join t_bd_measureunit t6 on t.funitid = t6.fid \n");
        sb.append(this.buildWhereFilters(filter, parm));
        logger.error((Object)(new Date() + "-- Mandy : \u6839\u636e\u8fc7\u6ee4\u6761\u4ef6\u9009\u62e9\u6570\u636e\u5230\u4e34\u65f6\u8868\u4e2d"));
        logger.error((Object)(new Date() + "-- Mandy : " + sb));
        return sb;
    }

    private StringBuffer buildWhereFilters(RptParams filter, String parm) {
        int expectationNum = new Integer(filter.getString("expectationNum"));
        String storageOrg = filter.getString("storageOrgUnit.number");
        String projectNum = filter.getString("project.numberF");
        String taskNumF = filter.getString("task.numberF");
        Calendar beginTime = this.buildBeginTime(filter.getString("beginTime"));
        String beginTimeStr = this.time2String(beginTime, "begin");
        Calendar endTime = this.getExpectationEndTime(beginTime.getTime(), expectationNum);
        String endTimeStr = this.time2String(endTime, "end");
        boolean mileStone = filter.getBoolean("mileStone");
        StringBuffer sb = new StringBuffer();
        sb.append(" WHERE ");
        sb.append(" t2.FNumber in ( " + ReportUtil.StringUtil(storageOrg) + " ) ");
        sb.append(" and ");
        sb.append("t.fbasestatus=");
        sb.append(5);
        if (parm != null && !"".equals(parm)) {
            sb.append(" and ");
            sb.append(" t.FPARENTID = '" + parm + "' ");
        } else {
            if (taskNumF == null) {
                sb.append(" and ");
                sb.append(" t.FPARENTID IS NULL  ");
            }
            sb.append(" \n ");
        }
        if (projectNum != null) {
            sb.append("\n AND t1.FNumber in ( " + ReportUtil.StringUtil(projectNum) + " ) ");
            if (!(parm != null && parm.length() != 0 || taskNumF == null || "".equals(taskNumF))) {
                sb.append(" and ");
                sb.append("  t.FNumber in ( " + ReportUtil.StringUtil(taskNumF) + ") ");
            }
        }
        if (beginTime != null && !"".equals(beginTime)) {
            sb.append("\n AND ( (t.FPlanBeginTime <= to_date('" + beginTimeStr + "') and ").append(" t.FPlanEndTime >= to_date('").append(beginTimeStr).append("'))");
        }
        if (endTime != null && !"".equals(endTime)) {
            sb.append("\n OR (t.FPlanBeginTime <= to_date('" + endTimeStr + "')  and ").append(" t.FPlanEndTime >= to_date('").append(endTimeStr).append("'))").append(" OR (t.FPlanBeginTime >= to_date('").append(beginTimeStr).append("') and t.FPlanEndTime <= to_date('").append(endTimeStr).append("')").append("))");
        }
        if (mileStone) {
            sb.append("\n AND t.FIsMileStone = 1");
        }
        return sb;
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT * FROM " + tableName);
        sb.append(" where KSQL_seq >");
        sb.append(new Integer(start).toString());
        sb.append(" and KSQL_seq <=");
        sb.append(new Integer(start + rows).toString());
        sb.append(" order by KSQL_seq");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sb.toString());
        return rs;
    }

    private int compareTime(Date from, Date to) {
        int ret;
        switch (this.issueType) {
            case -1: {
                ret = this.compareTimeByDay(from, to);
                break;
            }
            case -2: {
                ret = this.compareTimeByWeek(from, to);
                break;
            }
            case -3: {
                ret = this.compareTimeByMonth(from, to);
                break;
            }
            case -4: {
                ret = this.compareTimeByQuarter(from, to);
                break;
            }
            case -5: {
                ret = this.compareTimeByHalfYear(from, to);
                break;
            }
            case -6: {
                ret = this.compareTimeByYear(from, to);
                break;
            }
            default: {
                ret = this.compareTimeByMonth(from, to);
            }
        }
        return ret;
    }

    private int compareTimeByDay(Date from, Date to) {
        Calendar calF = Calendar.getInstance();
        calF.setTime(from);
        calF.set(11, 0);
        calF.set(12, 0);
        calF.set(13, 0);
        calF.set(14, 0);
        Calendar calT = Calendar.getInstance();
        calT.setTime(to);
        calT.set(11, 0);
        calT.set(12, 0);
        calT.set(13, 0);
        calT.set(14, 0);
        if (calF.after(calT)) {
            return 1;
        }
        if (calF.before(calT)) {
            return -1;
        }
        return 0;
    }

    private int compareTimeByHalfYear(Date from, Date to) {
        int qt;
        Calendar calF = Calendar.getInstance();
        calF.setTime(from);
        Calendar calT = Calendar.getInstance();
        calT.setTime(to);
        int f = calF.get(1);
        int t = calT.get(1);
        if (f < t) {
            return -1;
        }
        if (f > t) {
            return 1;
        }
        int qf = this.getQuarterNum(calF);
        if (qf < (qt = this.getQuarterNum(calT))) {
            return -1;
        }
        if (qf > qt) {
            return 1;
        }
        return 0;
    }

    private int compareTimeByMonth(Date from, Date to) {
        Calendar calF = Calendar.getInstance();
        calF.setTime(from);
        calF.set(5, 1);
        calF.set(11, 0);
        calF.set(12, 0);
        calF.set(13, 0);
        calF.set(14, 0);
        Calendar calT = Calendar.getInstance();
        calT.setTime(to);
        calT.set(5, 1);
        calT.set(11, 0);
        calT.set(12, 0);
        calT.set(13, 0);
        calT.set(14, 0);
        if (calF.before(calT)) {
            return -1;
        }
        if (calF.after(calT)) {
            return 1;
        }
        return 0;
    }

    private int compareTimeByQuarter(Date from, Date to) {
        Calendar calF = Calendar.getInstance();
        calF.setTime(from);
        Calendar calT = Calendar.getInstance();
        calT.setTime(to);
        int f = calF.get(1);
        int t = calT.get(1);
        if (f < t) {
            return -1;
        }
        if (f > t) {
            return 1;
        }
        if (f == t) {
            int qt;
            int qf = this.getQuarterNum(calF);
            if (qf < (qt = this.getQuarterNum(calT))) {
                return -1;
            }
            if (qf > qt) {
                return 1;
            }
        }
        return 0;
    }

    private int compareTimeByWeek(Date from, Date to) {
        Calendar calF = Calendar.getInstance();
        calF.setTime(from);
        Calendar calT = Calendar.getInstance();
        calT.setTime(to);
        int f = calF.get(1);
        int t = calT.get(1);
        if (f < t) {
            return -1;
        }
        if (f > t) {
            return 1;
        }
        f = calF.get(2);
        if (f < (t = calF.get(2))) {
            return -1;
        }
        if (f > t) {
            return 1;
        }
        f = calF.get(3);
        if (f == (t = calT.get(3))) {
            return 0;
        }
        return this.compareTimeByDay(from, to);
    }

    private int compareTimeByYear(Date from, Date to) {
        Calendar calF = Calendar.getInstance();
        calF.setTime(from);
        Calendar calT = Calendar.getInstance();
        calT.setTime(to);
        int f = calF.get(1);
        int t = calT.get(1);
        if (f > t) {
            return 1;
        }
        if (f < t) {
            return -1;
        }
        return 0;
    }

    private int getCurExpectationIssueDay(Calendar beginTime, Calendar currentTime) {
        return this.getDay(beginTime.getTime(), currentTime.getTime()) - 1;
    }

    private int getCurExpectationIssueHalfYear(Calendar beginTime, Calendar currentTime) {
        return this.getHalfYear(beginTime.getTime(), currentTime.getTime()) - 1;
    }

    private int getCurExpectationIssueMonth(Calendar beginTime, Calendar currentTime) {
        return this.getMonth(beginTime.getTime(), currentTime.getTime()) - 1;
    }

    private int getCurExpectationIssueQuarter(Calendar beginTime, Calendar currentTime) {
        return this.getQuarter(beginTime.getTime(), currentTime.getTime()) - 1;
    }

    private int getCurExpectationIssueWeek(Calendar beginTime, Calendar currentTime) {
        return this.getWeek(beginTime.getTime(), currentTime.getTime()) - 1;
    }

    private int getCurExpectationIssueYear(Calendar beginTime, Calendar currentTime) {
        return this.getYear(beginTime.getTime(), currentTime.getTime()) - 1;
    }

    private int getCurExpectationIssue(Calendar beginTime, Calendar currentTime) {
        int ret = -1;
        switch (this.issueType) {
            case -1: {
                ret = this.getCurExpectationIssueDay(beginTime, currentTime);
                break;
            }
            case -2: {
                ret = this.getCurExpectationIssueWeek(beginTime, currentTime);
                break;
            }
            case -3: {
                ret = this.getCurExpectationIssueMonth(beginTime, currentTime);
                break;
            }
            case -4: {
                ret = this.getCurExpectationIssueQuarter(beginTime, currentTime);
                break;
            }
            case -5: {
                ret = this.getCurExpectationIssueHalfYear(beginTime, currentTime);
                break;
            }
            case -6: {
                ret = this.getCurExpectationIssueYear(beginTime, currentTime);
            }
        }
        return ret;
    }

    public int getDay(Date begin, Date end) {
        Calendar beginCalendar = Calendar.getInstance();
        beginCalendar.setTime(begin);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        Calendar actualTime = (Calendar)beginCalendar.clone();
        int year = this.getYear(begin, end) - 1;
        int retVal = 0;
        if (year == 0) {
            retVal = endCalendar.get(6) - beginCalendar.get(6) + 1;
        } else {
            for (int i = year; i >= 0; --i) {
                retVal = i == 0 ? retVal + endCalendar.get(6) - actualTime.get(6) + 1 : retVal + actualTime.getActualMaximum(6) - actualTime.get(6) + 1;
                actualTime.set(1, actualTime.get(1) + 1);
                actualTime.set(2, 0);
                actualTime.set(6, 1);
            }
        }
        return retVal;
    }

    public IRowSet getHiberarchyData(String reportID, RptParams filter, HashMap rowData) throws BaseException {
        String parentID = (String)rowData.get("FID");
        String tableName = this.buildReportDataForVirtual(reportID, filter, parentID);
        StringBuffer sql = this.getTempRowSet(new String[]{tableName});
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString());
        return rs;
    }

    public int getHalfYear(Date begin, Date end) {
        Calendar beginCalendar = Calendar.getInstance();
        beginCalendar.setTime(this.getEndDayOfHalfYear(begin));
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        int halfYearNum = 1;
        while (this.compareTimeByMonth(beginCalendar.getTime(), endCalendar.getTime()) <= 0 && this.compareTimeByMonth(beginCalendar.getTime(), endCalendar.getTime()) < 0) {
            beginCalendar = this.getNextEndDayOfHalfYear(beginCalendar);
            ++halfYearNum;
        }
        return halfYearNum;
    }

    public int getMonth(Date begin, Date end) {
        Calendar beginCalendar = Calendar.getInstance();
        beginCalendar.setTime(begin);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        int year = endCalendar.get(1) - beginCalendar.get(1);
        int retVal = year * 12 + (endCalendar.get(2) - beginCalendar.get(2)) + 1;
        return retVal;
    }

    public Calendar getNextEndDayOfHalfYear(Calendar c) {
        if (this.isEarlySemiYear(c)) {
            c.set(c.get(1), 11, 31);
        } else {
            c.set(c.get(1) + 1, 5, 30);
        }
        return c;
    }

    public Calendar getNextEndDayOfQuarter(Calendar c) {
        switch (this.getQuarterNum(c)) {
            case 1: {
                c.set(c.get(1), 5, 30);
                break;
            }
            case 2: {
                c.set(c.get(1), 8, 30);
                break;
            }
            case 3: {
                c.set(c.get(1), 11, 31);
                break;
            }
            case 4: {
                c.set(c.get(1) + 1, 2, 31);
            }
        }
        return c;
    }

    public int getQuarter(Date begin, Date end) {
        Calendar beginCalendar = Calendar.getInstance();
        beginCalendar.setTime(begin);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        int quarterNum = 1;
        while (beginCalendar.before(endCalendar) && (beginCalendar.get(1) != endCalendar.get(1) || this.getQuarterNum(beginCalendar) != this.getQuarterNum(endCalendar))) {
            ++quarterNum;
            beginCalendar = this.getNextEndDayOfQuarter(beginCalendar);
        }
        return quarterNum;
    }

    public int getWeek(Date begin, Date end) {
        Calendar beginCalendar = Calendar.getInstance();
        beginCalendar.setTime(begin);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        Calendar actualTime = (Calendar)beginCalendar.clone();
        actualTime.setTime(this.getEndDayOfWeek(beginCalendar.getTime()));
        int weekNum = 1;
        while (this.compareTimeByDay(actualTime.getTime(), endCalendar.getTime()) < 0) {
            ++weekNum;
            actualTime.set(6, actualTime.get(6) + 7);
            if (actualTime.get(3) != endCalendar.get(3)) continue;
            break;
        }
        return weekNum;
    }

    public int getYear(Date begin, Date end) {
        Calendar beginCalendar = Calendar.getInstance();
        beginCalendar.setTime(begin);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        int year = endCalendar.get(1) - beginCalendar.get(1) + 1;
        return year;
    }

    public Date getEndDayOfHalfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (this.isEarlySemiYear(calendar)) {
            calendar.set(2, 5);
        } else {
            calendar.set(2, 11);
        }
        int endDay = calendar.getActualMaximum(5);
        calendar.set(5, endDay);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public Date getEndDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int endDay = calendar.getActualMaximum(5);
        calendar.set(5, endDay);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public Date getEndDayOfQuarter(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int quarter = this.getQuarterNum(calendar);
        int m = 0;
        switch (quarter) {
            case 1: {
                m = 2;
                break;
            }
            case 2: {
                m = 5;
                break;
            }
            case 3: {
                m = 8;
                break;
            }
            case 4: {
                m = 11;
            }
        }
        int endDay = calendar.getActualMaximum(5);
        calendar.set(2, m);
        calendar.set(5, endDay);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public Date getEndDayOfWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(7, 7);
        calendar.set(7, calendar.get(7));
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public Date getEndDayOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int endDay = calendar.getActualMaximum(6);
        calendar.set(6, endDay);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public Calendar getExpectationEndTimeDay(Date date, int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(6, calendar.get(6) + num - 1);
        return calendar;
    }

    public Calendar getExpectationEndTimeMonth(Date date, int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, calendar.get(2) + num - 1);
        return calendar;
    }

    public Calendar getExpectationEndTimeHalfYear(Date date, int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, calendar.get(2) + (num - 1) * 6);
        return calendar;
    }

    public Calendar getExpectationEndTimeQuarter(Date date, int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, calendar.get(2) + (num - 1) * 3);
        return calendar;
    }

    public Calendar getExpectationEndTimeWeek(Date date, int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(7, 7);
        calendar.set(3, calendar.get(3) + num - 1);
        return calendar;
    }

    public Calendar getExpectationEndTimeYear(Date date, int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(1, calendar.get(1) + num - 1);
        return calendar;
    }

    public Calendar getExpectationEndTime(Date date, int num) {
        Calendar calendar = Calendar.getInstance();
        switch (this.issueType) {
            case -1: {
                calendar = this.getExpectationEndTimeDay(date, num);
                break;
            }
            case -2: {
                calendar = this.getExpectationEndTimeWeek(date, num);
                break;
            }
            case -3: {
                calendar = this.getExpectationEndTimeMonth(date, num);
                break;
            }
            case -4: {
                calendar = this.getExpectationEndTimeQuarter(date, num);
                break;
            }
            case -5: {
                calendar = this.getExpectationEndTimeHalfYear(date, num);
                break;
            }
            case -6: {
                calendar = this.getExpectationEndTimeYear(date, num);
            }
        }
        return calendar;
    }

    public Date getFirstDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        return c.getTime();
    }

    public Date getFirstDayOfQuarter(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int quarter = this.getQuarterNum(c);
        int m = 0;
        switch (quarter) {
            case 1: {
                m = 0;
                break;
            }
            case 2: {
                m = 3;
                break;
            }
            case 3: {
                m = 6;
                break;
            }
            case 4: {
                m = 9;
            }
        }
        c.set(2, m);
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public Date getFirstDayOfSemiYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int semiYear = this.getSemiYearNum(c);
        if (semiYear == 1) {
            c.set(2, 0);
        } else {
            c.set(2, 6);
        }
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public Date getFirstDayOfWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(7, 1);
        return c.getTime();
    }

    public Calendar buildBeginTime(String time) {
        try {
            Date date = DateParser.pasterDate((String)time);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            return cal;
        }
        catch (FormatException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StringBuffer buildPlanning(RptParams filter, String tableName, String parm) throws BOSException, EASBizException {
        Locale locale = this.getContext().getLocale();
        ArrayList<TaskObject4Planning> taskList = new ArrayList<TaskObject4Planning>();
        String storageName = "";
        String storageFID = "";
        StringBuffer getStorageOrgID = new StringBuffer();
        getStorageOrgID.append("select FID,FNumber,FName_" + locale + " as storageName from T_ORG_Storage ");
        IRowSet irs = DbUtil.executeQuery((Context)this.getContext(), (String)getStorageOrgID.toString());
        try {
            while (irs.next()) {
                this.facCalendarMap.put(irs.getString("FID"), new MMProjectCalendarFactory(this.getContext(), irs.getString("FID")));
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        int expectationNum = new Integer(filter.getString("expectationNum"));
        Calendar beginTime = this.buildBeginTime(filter.getString("beginTime"));
        Calendar endTime = this.getExpectationEndTime(beginTime.getTime(), expectationNum);
        Calendar actualTime = (Calendar)beginTime.clone();
        StringBuffer sb = new StringBuffer();
        sb.append("select \t t.Ftaskname as taskname, \n");
        sb.append("       \t t.FID as taskFId, \n");
        sb.append("       \t t.FPlanBeginTime, \n");
        sb.append("       \t t.FPlanEndTime, \n");
        sb.append("       \t t.FQty as planqty, \n");
        sb.append("       \t t.FQtyPrecision  as FQtyPrecision, \n");
        sb.append("       \t t.FStorageName, \n");
        sb.append("       \t t.FStorageID    \n");
        sb.append("  from " + tableName + " t");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sb.toString());
            String taskName = "";
            int qtyPrecision = 0;
            StringBuffer updateSql = new StringBuffer();
            this.precision = new ArrayList();
            while (rs.next()) {
                ArrayList<BigDecimal> allIssuePlans = new ArrayList<BigDecimal>();
                ArrayList<BigDecimal> expectationIssuePlans = new ArrayList<BigDecimal>();
                HashMap<Integer, BigDecimal> issuePlanMap = new HashMap<Integer, BigDecimal>();
                String fid = rs.getString("taskFId");
                taskName = rs.getString("taskname");
                Timestamp planBeginTime = rs.getTimestamp("FPlanBeginTime");
                Timestamp planEndTime = rs.getTimestamp("FPlanEndTime");
                qtyPrecision = rs.getInt("FQtyPrecision");
                this.precision.add(new Integer(rs.getInt("FQtyPrecision")));
                BigDecimal planQty = rs.getBigDecimal("planqty");
                if (qtyPrecision == 0) {
                    qtyPrecision = planQty.scale();
                }
                if (qtyPrecision == 0) {
                    qtyPrecision = 8;
                }
                storageName = rs.getString("FStorageName");
                storageFID = rs.getString("FStorageID");
                MMProjectCalendarFactory calendarFac = (MMProjectCalendarFactory)this.facCalendarMap.get(storageFID);
                int allWorkDay = 0;
                allWorkDay = calendarFac.getWorklength2(planBeginTime, planEndTime);
                Calendar perIssueBeginTime = Calendar.getInstance();
                perIssueBeginTime.setTime(planBeginTime);
                int flag = 0;
                BigDecimal issuePlanNum = new BigDecimal("0.00000000");
                Calendar perIssueEndTime = Calendar.getInstance();
                perIssueEndTime.setTime(this.getPerIssueEndTime(perIssueBeginTime, planEndTime).getTime());
                while (this.compareTime(perIssueEndTime.getTime(), planEndTime) <= 0 && (this.compareTime(perIssueEndTime.getTime(), planEndTime) != 0 || ++flag <= 1)) {
                    int workDay = calendarFac.getWorklength2(perIssueBeginTime.getTime(), perIssueEndTime.getTime());
                    if (this.issueType == -1) {
                        workDay = !calendarFac.isWorkDay(perIssueBeginTime.getTime()) ? 0 : 1;
                    }
                    if (this.getPlanSum(allIssuePlans).add(this.getPlanQtyResult(workDay, allWorkDay, planQty, qtyPrecision)).compareTo(planQty) > 0) {
                        issuePlanNum = planQty.subtract(this.getPlanSum(allIssuePlans));
                        allIssuePlans.add(issuePlanNum);
                        if (this.issueType == -1) {
                            issuePlanMap.put(new Integer(this.getCurExpectationIssue(beginTime, perIssueBeginTime)), issuePlanNum);
                        }
                        if (!this.isInExpectation(perIssueBeginTime, beginTime.getTime(), endTime.getTime())) break;
                        expectationIssuePlans.add(issuePlanNum);
                        if (this.issueType == -1) break;
                        issuePlanMap.put(new Integer(this.getCurExpectationIssue(beginTime, perIssueBeginTime)), issuePlanNum);
                        break;
                    }
                    issuePlanNum = flag == 1 ? planQty.subtract(this.getPlanSum(allIssuePlans)) : this.getPlanQtyResult(workDay, allWorkDay, planQty, qtyPrecision);
                    allIssuePlans.add(issuePlanNum);
                    if (this.issueType == -1) {
                        issuePlanMap.put(new Integer(this.getCurExpectationIssue(beginTime, perIssueBeginTime)), issuePlanNum);
                    }
                    if (this.isInExpectation(perIssueBeginTime, beginTime.getTime(), endTime.getTime())) {
                        expectationIssuePlans.add(issuePlanNum);
                        if (this.issueType != -1) {
                            issuePlanMap.put(new Integer(this.getCurExpectationIssue(beginTime, perIssueBeginTime)), issuePlanNum);
                        }
                    }
                    Calendar[] tmpTime = this.nextIssue(perIssueBeginTime, perIssueEndTime, planEndTime, calendarFac);
                    perIssueBeginTime = tmpTime[0];
                    perIssueEndTime = tmpTime[1];
                }
                taskList.add(new TaskObject4Planning(fid, issuePlanMap, expectationIssuePlans));
            }
            updateSql.append(" update " + tableName + " set ");
            conn = EJBFactory.getConnection((Context)this.getContext());
            for (int t = 0; t < expectationNum; ++t) {
                updateSql.append(" Fexpectation" + t + "=?,");
            }
            updateSql.append(" FPlanningNumTotal =? ");
            updateSql.append(" where " + tableName + ".FID=?");
            updateSql.append(";");
            logger.error((Object)(new Date() + " Mandy err: update SQL is " + updateSql.toString()));
            pstmt = conn.prepareStatement(updateSql.toString());
            for (int i = 0; i < taskList.size(); ++i) {
                int j;
                TaskObject4Planning t4p = (TaskObject4Planning)taskList.get(i);
                int intPrecision = (Integer)this.precision.get(i);
                BigDecimal sum = new BigDecimal("0.00000000").setScale(intPrecision, 2);
                BigDecimal totalQty = this.getPlanSum(t4p.getExpectationIssuePlans()).setScale(intPrecision, 2);
                for (j = 0; j < expectationNum; ++j) {
                    BigDecimal tmp = (BigDecimal)t4p.getIssuePlanMap().get(new Integer(j));
                    if (tmp == null) {
                        tmp = new BigDecimal("0.00000000");
                    }
                    if (sum.add(tmp = tmp.setScale(intPrecision, 2)).compareTo(totalQty) >= 0) {
                        tmp = totalQty.add(sum.negate());
                        pstmt.setDouble(j + 1, tmp.doubleValue());
                    } else {
                        pstmt.setDouble(j + 1, tmp.doubleValue());
                        sum = sum.add(tmp);
                    }
                    logger.error((Object)(new Date() + " Mandy err: SQL's parameter[" + (j + 1) + "] is " + tmp.doubleValue()));
                }
                pstmt.setDouble(j + 1, totalQty.doubleValue());
                pstmt.setString(j + 2, t4p.getFid());
                logger.error((Object)(new Date() + " Mandy err: SQL's parameter[" + (j + 1) + "] is " + totalQty.doubleValue()));
                logger.error((Object)(new Date() + " Mandy err: SQL's parameter[" + (j + 2) + "] is " + t4p.getFid()));
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (BOSException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (SQLException e1) {
                    throw new SQLDataException(e1);
                }
                catch (EASBizException e2) {
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return null;
    }

    protected IRowSet getReportData(String reportID, RptParams filter) throws Exception {
        String tableName = this.buildReportDataForVirtual(reportID, filter, "");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)this.getTempRowSet(new String[]{tableName}).toString());
        return rs;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        int expectationNum = new Integer(filter.getString("expectationNum"));
        Calendar beginTime = this.buildBeginTime(filter.getString("beginTime"));
        Calendar actualTime = (Calendar)beginTime.clone();
        ReportHeader reportHeader = new ReportHeader();
        reportHeader.addChild("FStorageName", this.getResource("STORAGEOURUNIT").substring(0, this.getResource("STORAGEOURUNIT").length() - 1));
        reportHeader.addChild("FProjectName", this.getResource("PROJECTNAME"));
        reportHeader.addChild("FTaskType", this.getResource("TASKTYPE"));
        reportHeader.addChild("FTaskName", this.getResource("TASKNAME")).setIshiberarchy(true);
        reportHeader.addChild("FMaterialName", this.getResource("MATERIALNAME"));
        reportHeader.addChild("FMileStone", this.getResource("MILESTONE")).setType(3);
        reportHeader.addChild("FMeasureUnit", ResourceBase.getString((String)"com.kingdee.eas.mm.project.PROJECTAutoGenerateResource", (String)"0_ProjectTaskPlanningReport", (Locale)this.getLocale()));
        ReportHeader col = reportHeader.addChild("FPlanningNumTotal", this.getResource("ISSUETOTALNUM"));
        col.setType(2);
        col.setFormatstring("#,##0.########");
        block7: for (int i = 0; i < expectationNum; ++i) {
            switch (this.issueType) {
                case -1: {
                    Date da = actualTime.getTime();
                    SimpleDateFormat f = new SimpleDateFormat("yyyy.MM.dd");
                    col = reportHeader.addChild("Fexpectation" + i, f.format(da));
                    col.setType(2);
                    col.setFormatstring("#,##0.########");
                    actualTime.set(6, actualTime.get(6) + 1);
                    continue block7;
                }
                case -2: {
                    Date df = actualTime.getTime();
                    Date dt = this.getEndDayOfWeek(actualTime.getTime());
                    SimpleDateFormat format = new SimpleDateFormat("yyyy.MM.dd");
                    String date = format.format(df) + "--" + format.format(dt);
                    col = reportHeader.addChild("Fexpectation" + i, date).setWidth(150);
                    col.setType(2);
                    col.setFormatstring("#,##0.########");
                    actualTime.setTime(dt);
                    actualTime.set(6, actualTime.get(6) + 1);
                    continue block7;
                }
                case -4: {
                    col = reportHeader.addChild("Fexpectation" + i, actualTime.get(1) + ".Q" + this.getQuarterNum(actualTime));
                    col.setType(2);
                    col.setFormatstring("#,##0.########");
                    actualTime = this.getNextEndDayOfQuarter(actualTime);
                    continue block7;
                }
                case -5: {
                    String halfYear = "";
                    halfYear = this.isEarlySemiYear(actualTime) ? this.getResource("EARLY_SEMI_YEAR") : this.getResource("AFTER_SEMI_YEAR");
                    col = reportHeader.addChild("Fexpectation" + i, actualTime.get(1) + halfYear);
                    col.setType(2);
                    col.setFormatstring("#,##0.########");
                    actualTime = this.getNextEndDayOfHalfYear(actualTime);
                    continue block7;
                }
                case -6: {
                    col = reportHeader.addChild("Fexpectation" + i, new Integer(actualTime.get(1)).toString());
                    col.setType(2);
                    col.setFormatstring("#,##0.########");
                    actualTime.set(1, actualTime.get(1) + 1);
                    continue block7;
                }
                default: {
                    col = reportHeader.addChild("Fexpectation" + i, actualTime.get(1) + ".M" + (actualTime.get(2) + 1));
                    col.setType(2);
                    col.setFormatstring("#,##0.########");
                    actualTime.set(2, actualTime.get(2) + 1);
                }
            }
        }
        return reportHeader;
    }

    protected ReportTitles getReportTitles(String arg0, RptParams filter) throws BaseException {
        int expectationNum = new Integer(filter.getString("expectationNum"));
        Calendar beginTime = this.buildBeginTime(filter.getString("beginTime"));
        Calendar endTime = this.getExpectationEndTime(beginTime.getTime(), expectationNum);
        ReportTitles titles = new ReportTitles();
        switch (this.issueType) {
            case -1: {
                titles.AddTitle(0, this.getResource("PLANISSUESTART") + beginTime.get(1) + "." + (beginTime.get(2) + 1) + "." + beginTime.get(5));
                titles.AddTitle(1, this.getResource("PLANISSUEEND") + endTime.get(1) + "." + (endTime.get(2) + 1) + "." + endTime.get(5));
                break;
            }
            case -2: {
                titles.AddTitle(0, this.getResource("PLANISSUESTART") + beginTime.get(1) + ".W" + beginTime.get(3));
                titles.AddTitle(1, this.getResource("PLANISSUEEND") + endTime.get(1) + ".W" + endTime.get(3));
                break;
            }
            case -4: {
                titles.AddTitle(0, this.getResource("PLANISSUESTART") + beginTime.get(1) + ".Q" + this.getQuarterNum(beginTime));
                titles.AddTitle(1, this.getResource("PLANISSUEEND") + endTime.get(1) + ".Q" + this.getQuarterNum(beginTime));
                break;
            }
            case -5: {
                String bHalfYear = "";
                bHalfYear = this.isEarlySemiYear(beginTime) ? this.getResource("EARLY_SEMI_YEAR") : this.getResource("AFTER_SEMI_YEAR");
                String eHalfYear = "";
                eHalfYear = this.isEarlySemiYear(endTime) ? this.getResource("EARLY_SEMI_YEAR") : this.getResource("AFTER_SEMI_YEAR");
                titles.AddTitle(0, this.getResource("PLANISSUESTART") + beginTime.get(1) + bHalfYear);
                titles.AddTitle(1, this.getResource("PLANISSUEEND") + endTime.get(1) + eHalfYear);
                break;
            }
            case -6: {
                titles.AddTitle(0, this.getResource("PLANISSUESTART") + beginTime.get(1));
                titles.AddTitle(1, this.getResource("PLANISSUEEND") + endTime.get(1));
                break;
            }
            default: {
                titles.AddTitle(0, this.getResource("PLANISSUESTART") + beginTime.get(1) + ".M" + (beginTime.get(2) + 1));
                titles.AddTitle(1, this.getResource("PLANISSUEEND") + endTime.get(1) + ".M" + (endTime.get(2) + 1));
            }
        }
        return titles;
    }

    public StringBuffer getTempRowSet(String[] tableName) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("   SELECT ");
        sb.append("     FStorageName ,");
        sb.append("     FProjectName , ");
        sb.append("     FTaskType ,");
        sb.append("     FTaskName ,");
        sb.append("     FMaterialName ,");
        sb.append("     FMileStone ,");
        sb.append("     FMeasureUnit , ");
        sb.append(" to_number(FPlanningNumTotal)  FPlanningNumTotal ");
        for (int i = 0; i < this.expectationNum; ++i) {
            sb.append(" , ");
            sb.append(" to_number(Fexpectation" + i + ")   Fexpectation" + i + " ");
        }
        sb.append(" , FID");
        sb.append(" , FParentID");
        sb.append("     from " + tableName[0] + " ");
        return sb;
    }

    public String getResource(String strKey) {
        return ResourceBase.getString((String)"com.kingdee.eas.mm.project.ProjectProblemResource", (String)strKey, (Locale)this.getLocale());
    }

    private Locale getLocale() {
        return this.getContext().getLocale();
    }

    private Calendar getPerIssueEndTime(Calendar perIssueBeginTime, Date planEndTime) {
        Date endTime = new Date();
        Calendar calF = Calendar.getInstance();
        Calendar calT = Calendar.getInstance();
        calT.setTime(planEndTime);
        switch (this.issueType) {
            case -1: {
                endTime = perIssueBeginTime.getTime();
                break;
            }
            case -2: {
                endTime = this.getEndDayOfWeek(perIssueBeginTime.getTime());
                calF.setTime(endTime);
                if (!calF.after(calT)) break;
                endTime = planEndTime;
                break;
            }
            case -3: {
                endTime = this.getEndDayOfMonth(perIssueBeginTime.getTime());
                calF.setTime(endTime);
                if (!calF.after(calT)) break;
                endTime = planEndTime;
                break;
            }
            case -4: {
                endTime = this.getEndDayOfQuarter(perIssueBeginTime.getTime());
                calF.setTime(endTime);
                if (!calF.after(calT)) break;
                endTime = planEndTime;
                break;
            }
            case -5: {
                endTime = this.getEndDayOfHalfYear(perIssueBeginTime.getTime());
                calF.setTime(endTime);
                if (!calF.after(calT)) break;
                endTime = planEndTime;
                break;
            }
            case -6: {
                endTime = this.getEndDayOfYear(perIssueBeginTime.getTime());
                calF.setTime(endTime);
                if (!calF.after(calT)) break;
                endTime = planEndTime;
            }
        }
        Calendar ret = Calendar.getInstance();
        ret.setTime(endTime);
        return ret;
    }

    public BigDecimal getPlanQtyResult(int a, int b, BigDecimal planQty, int qtyPrecision) {
        BigDecimal result = planQty.multiply(new BigDecimal(a)).divide(new BigDecimal(b), qtyPrecision, 2);
        return result;
    }

    private BigDecimal getPlanSum(List list) {
        BigDecimal sum = new BigDecimal("0.00000000");
        for (int i = 0; i < list.size(); ++i) {
            sum = ((BigDecimal)list.get(i)).add(sum);
        }
        return sum;
    }

    public int getQuarterNum(Calendar c) {
        int m = c.get(2);
        if (m >= 0 && m <= 2) {
            return 1;
        }
        if (m >= 3 && m <= 5) {
            return 2;
        }
        if (m >= 6 && m <= 8) {
            return 3;
        }
        if (m >= 9 && m <= 11) {
            return 4;
        }
        return 0;
    }

    public int getSemiYearNum(Calendar c) {
        int month = c.get(2);
        if (month <= 5) {
            return 1;
        }
        return 2;
    }

    private StringBuffer getTempTableMain(int num) {
        StringBuffer createTable = new StringBuffer();
        createTable.append("CREATE TABLE tempPlanning (");
        createTable.append("KSQL_SEQ INT IDENTITY (1, 1) not null");
        createTable.append(",FStorageName   varchar(255) ");
        createTable.append(",FProjectName   varchar(255) ");
        createTable.append(",FTaskType      varchar(44)  ");
        createTable.append(",FTaskName      varchar(255) ");
        createTable.append(",FMaterialName  varchar(255) ");
        createTable.append(",FMileStone     int default(0)");
        createTable.append(",FPlanningNumTotal  DECIMAL(21,8) default(0)");
        for (int i = 0; i < num; ++i) {
            createTable.append(",Fexpectation" + i + " DECIMAL(21,8) default(0)");
        }
        createTable.append(",FID            varchar(44)  ");
        createTable.append(",FPlanBeginTime DateTime  ");
        createTable.append(",FPlanEndTime DateTime  ");
        createTable.append(",FQty Decimal(21,8)  default(0)");
        createTable.append(",FQtyPrecision int  default(0)");
        createTable.append(",FParentID       varchar(44)  ");
        createTable.append(",FStorageID      varchar(44)  ");
        createTable.append(",FMeasureUnit    varchar(255) ");
        createTable.append(")");
        return createTable;
    }

    private String insertTempTable(String tempTableNameMain, RptParams filter, String parm) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempTableNameMain + " ( KSQL_SEQ , FStorageName , FProjectName , FTaskType , FTaskName , FMaterialName , FMileStone ,FID , FPlanBeginTime , FPlanEndTime , FQty , FQtyPrecision , FParentID , FStorageID , FMeasureUnit ");
        sql.append(" ) \n");
        sql.append(this.buildTempSelectResult(filter, parm));
        logger.error((Object)(new Date() + "-- Mandy : \u63d2\u5165\u6570\u636e\u5230\u4e34\u65f6\u8868"));
        return sql.toString();
    }

    private boolean isInExpectationDay(Calendar curDay, Date begin, Date end) {
        return this.compareTime(curDay.getTime(), begin) >= 0 && this.compareTime(curDay.getTime(), end) <= 0;
    }

    private boolean isInExpectationHalfYear(Calendar curTime, Date begin, Date end) {
        return this.compareTime(curTime.getTime(), begin) >= 0 && this.compareTime(curTime.getTime(), end) <= 0;
    }

    private boolean isInExpectationMonth(Calendar curMonth, Date begin, Date end) {
        return this.compareTime(curMonth.getTime(), begin) >= 0 && this.compareTime(curMonth.getTime(), end) <= 0;
    }

    private boolean isInExpectationQuarter(Calendar curMonth, Date begin, Date end) {
        return this.compareTime(curMonth.getTime(), begin) >= 0 && this.compareTime(curMonth.getTime(), end) <= 0;
    }

    private boolean isInExpectationWeek(Calendar curWeek, Date begin, Date end) {
        return this.compareTime(curWeek.getTime(), begin) >= 0 && this.compareTime(curWeek.getTime(), end) <= 0;
    }

    private boolean isInExpectationYear(Calendar curYear, Date begin, Date end) {
        return this.compareTime(curYear.getTime(), begin) >= 0 && this.compareTime(curYear.getTime(), end) <= 0;
    }

    private boolean isEarlySemiYear(Calendar c) {
        return c.get(2) < 6;
    }

    private Calendar[] nextIssue(Calendar perIssueBeginTime, Calendar perIssueEndTime, Date planEndTime, MMProjectCalendarFactory fac) throws EASBizException, BOSException {
        Calendar[] ret = new Calendar[2];
        switch (this.issueType) {
            case -1: {
                do {
                    perIssueBeginTime.set(6, perIssueEndTime.get(6) + 1);
                    perIssueEndTime.setTime(perIssueBeginTime.getTime());
                } while (!fac.isWorkDay(perIssueBeginTime.getTime()));
                break;
            }
            case -2: {
                perIssueBeginTime.set(6, perIssueEndTime.get(6) + 1);
                perIssueBeginTime.set(1, perIssueEndTime.get(1));
                perIssueBeginTime.set(2, perIssueEndTime.get(2));
                perIssueEndTime.setTime(this.getPerIssueEndTime(perIssueBeginTime, planEndTime).getTime());
                break;
            }
            case -3: {
                perIssueBeginTime.set(5, perIssueEndTime.get(5) + 1);
                perIssueEndTime.setTime(this.getPerIssueEndTime(perIssueBeginTime, planEndTime).getTime());
                break;
            }
            case -4: {
                perIssueBeginTime.set(6, perIssueEndTime.get(6) + 1);
                perIssueBeginTime.set(1, perIssueEndTime.get(1));
                perIssueBeginTime.set(2, perIssueEndTime.get(2));
                perIssueEndTime.setTime(this.getPerIssueEndTime(perIssueBeginTime, planEndTime).getTime());
                break;
            }
            case -5: {
                perIssueBeginTime.set(6, perIssueEndTime.get(6) + 1);
                perIssueBeginTime.set(1, perIssueEndTime.get(1));
                perIssueBeginTime.set(2, perIssueEndTime.get(2));
                perIssueEndTime.setTime(this.getPerIssueEndTime(perIssueBeginTime, planEndTime).getTime());
                break;
            }
            case -6: {
                perIssueBeginTime.set(6, perIssueEndTime.get(6) + 1);
                perIssueBeginTime.set(1, perIssueEndTime.get(1));
                perIssueBeginTime.set(2, perIssueEndTime.get(2));
                perIssueEndTime.setTime(this.getPerIssueEndTime(perIssueBeginTime, planEndTime).getTime());
            }
        }
        ret[0] = perIssueBeginTime;
        ret[1] = perIssueEndTime;
        return ret;
    }

    private boolean isInExpectation(Calendar curTime, Date begin, Date end) {
        boolean ret = false;
        switch (this.issueType) {
            case -1: {
                ret = this.isInExpectationDay(curTime, begin, end);
                break;
            }
            case -2: {
                ret = this.isInExpectationWeek(curTime, begin, end);
                break;
            }
            case -3: {
                ret = this.isInExpectationMonth(curTime, begin, end);
                break;
            }
            case -4: {
                ret = this.isInExpectationQuarter(curTime, begin, end);
                break;
            }
            case -5: {
                ret = this.isInExpectationHalfYear(curTime, begin, end);
                break;
            }
            case -6: {
                ret = this.isInExpectationYear(curTime, begin, end);
            }
        }
        return ret;
    }

    public String time2String(Calendar cal, String flag) {
        switch (this.issueType) {
            case -2: {
                if (flag.equals("begin")) {
                    cal.setTime(this.getFirstDayOfWeek(cal.getTime()));
                    break;
                }
                cal.setTime(this.getEndDayOfWeek(cal.getTime()));
                break;
            }
            case -4: {
                if (flag.equals("begin")) {
                    cal.setTime(this.getFirstDayOfQuarter(cal.getTime()));
                    break;
                }
                cal.setTime(this.getEndDayOfQuarter(cal.getTime()));
                break;
            }
            case -5: {
                if (flag.equals("begin")) {
                    cal.setTime(this.getFirstDayOfSemiYear(cal.getTime()));
                    break;
                }
                cal.setTime(this.getEndDayOfHalfYear(cal.getTime()));
                break;
            }
            case -6: {
                if (flag.equals("begin")) {
                    cal.set(6, 1);
                    break;
                }
                cal.setTime(this.getEndDayOfYear(cal.getTime()));
                break;
            }
            default: {
                if (flag.equals("begin")) {
                    cal.set(5, 1);
                    break;
                }
                cal.setTime(this.getEndDayOfMonth(cal.getTime()));
            }
        }
        Date date = cal.getTime();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
        return format.format(date);
    }
}

