/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.MMBaseStatusEnum;
import com.kingdee.eas.mm.project.IProjectTask;
import com.kingdee.eas.mm.project.PMChangeException;
import com.kingdee.eas.mm.project.ProjectDictDataInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.mm.project.ProjectTaskCollection;
import com.kingdee.eas.mm.project.ProjectTaskException;
import com.kingdee.eas.mm.project.ProjectTaskFactory;
import com.kingdee.eas.mm.project.ProjectTaskInfo;
import com.kingdee.eas.mm.project.app.AbstractProjectTaskSyncFacadeControllerBean;
import com.kingdee.eas.mm.project.util.MMProjectCalendarFactory;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class ProjectTaskSyncFacadeControllerBean
extends AbstractProjectTaskSyncFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.project.app.ProjectTaskSyncFacadeControllerBean");

    @Override
    protected void _syncTask(Context ctx, ProjectTaskInfo taskInfo, ProjectInfo projectInfo) throws BOSException, EASBizException {
        MMProjectCalendarFactory mmCalendarFactory = null;
        Timestamp projectOldBeginDate = projectInfo.getPlanBeginTime();
        Timestamp projectOldEndDate = projectInfo.getPlanEndTime();
        ProjectTaskCollection tasks = this.getWBS4TaskChange(ctx, taskInfo, projectInfo, mmCalendarFactory);
        Timestamp projectNewBeginDate = projectInfo.getPlanBeginTime();
        Timestamp projectNewEndDate = projectInfo.getPlanEndTime();
        if (((Date)projectNewBeginDate).compareTo(projectOldBeginDate) < 0 || ((Date)projectNewBeginDate).compareTo(projectOldEndDate) > 0 || ((Date)projectNewEndDate).compareTo(projectOldBeginDate) < 0 || ((Date)projectNewEndDate).compareTo(projectOldEndDate) > 0) {
            throw new ProjectTaskException(ProjectTaskException.EXCEED_PROJECT_DATE);
        }
        int size = tasks.size();
        for (int i = 0; i < size; ++i) {
            ProjectTaskInfo projectTaskInfo = tasks.get(i);
            if (1 == projectTaskInfo.getBaseStatus().getValue()) continue;
            throw new ProjectTaskException(ProjectTaskException.EXIST_NOT_SAVED);
        }
        String updateProjectSql = "update t_mm_project set FTotalTime=?,FPlanBeginTime=?,FPlanEndTime=? where fid =?";
        String updateTaskSql = "update t_mm_projecttask set FTotalTime=?,FPlanBeginTime=?,FPlanEndTime=?, finterval=? where fid =?";
        DbUtil.execute((Context)ctx, (String)updateProjectSql, (Object[])new Object[]{projectInfo.getTotalTime(), projectInfo.getPlanBeginTime(), projectInfo.getPlanEndTime(), projectInfo.getId().toString()});
        ArrayList<Object[]> updateTaskParamList = new ArrayList<Object[]>();
        int size2 = tasks.size();
        for (int i = 0; i < size2; ++i) {
            ProjectTaskInfo projectTaskInfo = tasks.get(i);
            updateTaskParamList.add(new Object[]{projectTaskInfo.getTotalTime(), projectTaskInfo.getPlanBeginTime(), projectTaskInfo.getPlanEndTime(), projectTaskInfo.getInterval(), projectTaskInfo.getId().toString()});
        }
        DbUtil.executeBatch((Context)ctx, (String)updateTaskSql, updateTaskParamList);
    }

    private ProjectTaskCollection getWBS4TaskChange(Context ctx, ProjectTaskInfo taskInfo, ProjectInfo projectInfo, MMProjectCalendarFactory mmCalendarFactory) throws BOSException, EASBizException {
        String projectId = projectInfo.getId().toString();
        ProjectTaskCollection tasks = this.getTasks(ctx, projectId);
        this.buildTree(tasks, taskInfo);
        ProjectTaskCollection results = new ProjectTaskCollection();
        ProjectTaskInfo currentTask = (ProjectTaskInfo)tasks.getObject(taskInfo.getId());
        this.taskChange(ctx, projectInfo, currentTask, results, mmCalendarFactory);
        return results;
    }

    private void taskChange(Context ctx, ProjectInfo project, ProjectTaskInfo task, ProjectTaskCollection results, MMProjectCalendarFactory mmCalendarFactory) throws BOSException, EASBizException {
        Boolean isCal = (Boolean)task.get("isCal");
        if (isCal == null || isCal.booleanValue()) {
            return;
        }
        task.put("isCal", Boolean.TRUE);
        List children = (List)task.get("children");
        Iterator it = null;
        if (children != null) {
            it = children.iterator();
        }
        Timestamp parentPlanBegin = task.getPlanBeginTime();
        Timestamp parentPlanEnd = task.getPlanEndTime();
        BigDecimal parentTotalTime = task.getTotalTime();
        while (it != null && it.hasNext()) {
            ProjectTaskInfo child = (ProjectTaskInfo)it.next();
            Timestamp planBegin = child.getPlanBeginTime();
            Timestamp planEnd = child.getPlanEndTime();
            BigDecimal totalTime = child.getTotalTime();
            MMBaseStatusEnum status = child.getBaseStatus();
            if (!status.equals((Object)MMBaseStatusEnum.SAVED) || ((Date)planBegin).compareTo(parentPlanBegin) >= 0 && ((Date)planEnd).compareTo(parentPlanEnd) <= 0) continue;
            if (parentTotalTime.subtract(totalTime).intValue() < 0) {
                throw new PMChangeException(PMChangeException.TOTALTIME_LT_CHILD, new String[]{task.getNumber(), child.getNumber()});
            }
            this.setChildTime(ctx, parentPlanBegin, parentPlanEnd, child, mmCalendarFactory);
            results.add(child);
            this.taskChange(ctx, project, child, results, mmCalendarFactory);
        }
        ProjectTaskInfo parent = task.getParent();
        if (parent != null) {
            boolean isChange = false;
            if (parent.getPlanBeginTime() != null && ((Date)parentPlanBegin).compareTo(parent.getPlanBeginTime()) < 0) {
                if (parent.isIsTransferedCentral() || parent.isIsTransfered()) {
                    throw new PMChangeException(PMChangeException.ISTRANSFERED, new String[]{parent.getNumber()});
                }
                this.setParentTime(ctx, parentPlanBegin, null, parent, mmCalendarFactory);
                isChange = true;
                if (parent.getActualBeginTime() != null) {
                    throw new PMChangeException(PMChangeException.WBS_IN_WORK, new String[]{parent.getNumber()});
                }
            }
            if (parent.getPlanEndTime() != null && ((Date)parentPlanEnd).compareTo(parent.getPlanEndTime()) > 0) {
                if (parent.isIsTransferedCentral() || parent.isIsTransfered()) {
                    throw new PMChangeException(PMChangeException.ISTRANSFERED, new String[]{parent.getNumber()});
                }
                this.setParentTime(ctx, null, parentPlanEnd, parent, mmCalendarFactory);
                isChange = true;
                if (parent.getActualBeginTime() != null) {
                    throw new PMChangeException(PMChangeException.WBS_IN_WORK, new String[]{parent.getNumber()});
                }
            }
            if (isChange) {
                String projectid = parent.getProject().getId().toString();
                if (mmCalendarFactory == null) {
                    mmCalendarFactory = new MMProjectCalendarFactory(ctx, projectid);
                } else if (!mmCalendarFactory.getProjectId().equalsIgnoreCase(projectid)) {
                    mmCalendarFactory.changeOrg(projectid);
                }
                int total = mmCalendarFactory.getWorklength(parent.getPlanBeginTime(), parent.getPlanEndTime());
                parent.setTotalTime(new BigDecimal(total));
                results.add(parent);
                this.taskChange(ctx, project, parent, results, mmCalendarFactory);
            }
        } else {
            if (project.getActualBeginTime() != null) {
                throw new PMChangeException(PMChangeException.PROJECT_IN_WORK, new String[]{project.getNumber()});
            }
            if (((Date)parentPlanBegin).compareTo(project.getPlanBeginTime()) < 0) {
                project.setPlanBeginTime(new Timestamp(((Date)parentPlanBegin).getTime()));
                project.put("PROJECTCHANGED", Boolean.TRUE);
            }
            if (((Date)parentPlanEnd).compareTo(project.getPlanEndTime()) > 0) {
                project.setPlanEndTime(new Timestamp(((Date)parentPlanEnd).getTime()));
                project.put("PROJECTCHANGED", Boolean.TRUE);
            }
        }
        ProjectTaskInfo preTask = task.getPreTask();
        if (preTask != null) {
            ProjectDictDataInfo iteratorType = task.getIteratorType();
            this.setRearTaskIterval(ctx, preTask, task, iteratorType.getNumber(), mmCalendarFactory);
        }
        List rearTasks = (List)task.get("rearNodes");
        Iterator itRear = null;
        if (rearTasks != null) {
            itRear = rearTasks.iterator();
        }
        boolean isChange = false;
        while (itRear != null && itRear.hasNext()) {
            ProjectDictDataInfo interatorType;
            ProjectTaskInfo rearTask = (ProjectTaskInfo)itRear.next();
            MMBaseStatusEnum status = rearTask.getBaseStatus();
            if (!status.equals((Object)MMBaseStatusEnum.SAVED) || (interatorType = rearTask.getIteratorType()) == null || !(isChange = this.setRearTaskIterval(ctx, task, rearTask, interatorType.getNumber(), mmCalendarFactory))) continue;
            results.add(rearTask);
        }
        results.add(task);
    }

    private ProjectTaskCollection getTasks(Context ctx, String projectId) throws BOSException {
        IProjectTask iProjectTask = ProjectTaskFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("project.id", (Object)projectId));
        filter.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(0), CompareType.NOTEQUALS));
        view.setFilter(filter);
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("*"));
        coll.add(new SelectorItemInfo("iteratorType.*"));
        coll.add(new SelectorItemInfo("feedbackMode.*"));
        coll.add(new SelectorItemInfo("preTask.id"));
        coll.add(new SelectorItemInfo("preTask.name"));
        coll.add(new SelectorItemInfo("preTask.number"));
        coll.add(new SelectorItemInfo("carNumber.id"));
        coll.add(new SelectorItemInfo("carNumber.name"));
        coll.add(new SelectorItemInfo("carNumber.number"));
        view.getSorter().add(new SorterItemInfo("wbsNumber"));
        view.setSelector(coll);
        ProjectTaskCollection tasks = iProjectTask.getProjectTaskCollection(view);
        return tasks;
    }

    private void buildTree(ProjectTaskCollection tasks, ProjectTaskInfo currentTask) {
        int size = tasks.size();
        for (int i = 0; i < size; ++i) {
            ProjectTaskInfo task = tasks.get(i);
            if (currentTask != null && task.getId().equals((Object)currentTask.getId())) {
                this.copyTask(currentTask, task);
            }
            task.put("isCal", Boolean.FALSE);
            ProjectTaskInfo preTask = task.getPreTask();
            ProjectTaskInfo parentTask = task.getParent();
            if (preTask != null && (preTask = (ProjectTaskInfo)tasks.getObject(preTask.getId())) != null) {
                task.setPreTask(preTask);
                List postTasks = (List)preTask.get("rearNodes");
                if (postTasks != null) {
                    postTasks.add(task);
                } else {
                    ArrayList<ProjectTaskInfo> rearNodes = new ArrayList<ProjectTaskInfo>();
                    rearNodes.add(task);
                    preTask.put("rearNodes", rearNodes);
                }
            }
            if (parentTask == null || (parentTask = (ProjectTaskInfo)tasks.getObject(parentTask.getId())) == null) continue;
            task.setParent(parentTask);
            List children = (List)parentTask.get("children");
            if (children != null) {
                children.add(task);
                continue;
            }
            ArrayList<ProjectTaskInfo> childrenNode = new ArrayList<ProjectTaskInfo>();
            childrenNode.add(task);
            parentTask.put("children", childrenNode);
        }
    }

    private void setChildTime(Context ctx, Date parentPlanBegin, Date parentPlanEnd, ProjectTaskInfo child, MMProjectCalendarFactory mmCalendarFactory) throws EASBizException, BOSException {
        String projectid = child.getProject().getId().toString();
        if (mmCalendarFactory == null) {
            mmCalendarFactory = new MMProjectCalendarFactory(ctx, projectid);
        } else if (!mmCalendarFactory.getProjectId().equalsIgnoreCase(projectid)) {
            mmCalendarFactory.changeOrg(projectid);
        }
        Calendar calendar = Calendar.getInstance();
        if (parentPlanBegin.compareTo(child.getPlanBeginTime()) > 0) {
            calendar.setTime(parentPlanBegin);
            child.setPlanBeginTime(new Timestamp(calendar.getTimeInMillis()));
            Date planEnd = mmCalendarFactory.addWroklength(parentPlanBegin, child.getTotalTime().intValue());
            calendar.setTime(planEnd);
            child.setPlanEndTime(new Timestamp(calendar.getTimeInMillis()));
        }
        if (parentPlanEnd.compareTo(child.getPlanEndTime()) < 0) {
            calendar.setTime(parentPlanEnd);
            child.setPlanEndTime(new Timestamp(calendar.getTimeInMillis()));
            Date planBegin = mmCalendarFactory.addWroklength(parentPlanEnd, -child.getTotalTime().intValue());
            calendar.setTime(planBegin);
            child.setPlanBeginTime(new Timestamp(calendar.getTimeInMillis()));
        }
    }

    private void setParentTime(Context ctx, Date planBegin, Date planEnd, ProjectTaskInfo parent, MMProjectCalendarFactory mmCalendarFactory) throws EASBizException, BOSException {
        Date date;
        String projectid = parent.getProject().getId().toString();
        if (mmCalendarFactory == null) {
            mmCalendarFactory = new MMProjectCalendarFactory(ctx, projectid);
        } else if (!mmCalendarFactory.getProjectId().equalsIgnoreCase(projectid)) {
            mmCalendarFactory.changeOrg(projectid);
        }
        Calendar calendar = Calendar.getInstance();
        if (planBegin != null) {
            date = mmCalendarFactory.getWorkdate2(planBegin, false);
            calendar.setTime(date);
            parent.setPlanBeginTime(new Timestamp(calendar.getTimeInMillis()));
        }
        if (planEnd != null) {
            date = mmCalendarFactory.getWorkdate2(planEnd, true);
            calendar.setTime(date);
            parent.setPlanEndTime(new Timestamp(calendar.getTimeInMillis()));
        }
    }

    private boolean setRearTaskIterval(Context ctx, ProjectTaskInfo task, ProjectTaskInfo rearTask, String iteratorType, MMProjectCalendarFactory mmCalendarFactory) throws EASBizException, BOSException {
        String projectid = rearTask.getProject().getId().toString();
        if (mmCalendarFactory == null) {
            mmCalendarFactory = new MMProjectCalendarFactory(ctx, projectid);
        } else if (!mmCalendarFactory.getProjectId().equalsIgnoreCase(projectid)) {
            mmCalendarFactory.changeOrg(projectid);
        }
        int interval = 0;
        if (iteratorType.equalsIgnoreCase("FS")) {
            interval = mmCalendarFactory.getLeadtime3(task.getPlanEndTime(), rearTask.getPlanBeginTime(), 1);
        } else if (iteratorType.equalsIgnoreCase("SS")) {
            interval = mmCalendarFactory.getLeadtime3(task.getPlanBeginTime(), rearTask.getPlanBeginTime(), 0);
        } else if (iteratorType.equalsIgnoreCase("SF")) {
            interval = mmCalendarFactory.getLeadtime3(task.getPlanBeginTime(), rearTask.getPlanEndTime(), -1);
        } else if (iteratorType.equalsIgnoreCase("FF")) {
            interval = mmCalendarFactory.getLeadtime3(task.getPlanEndTime(), rearTask.getPlanEndTime(), 0);
        }
        if (rearTask.getInterval() != null && rearTask.getInterval().intValue() - interval == 0) {
            return false;
        }
        rearTask.setInterval(new BigDecimal(interval));
        return true;
    }

    private void copyTask(ProjectTaskInfo taskSrc, ProjectTaskInfo taskDesc) {
        taskDesc.setPlanBeginTime(new Timestamp(taskSrc.getPlanBeginTime().getTime()));
        taskDesc.setPlanEndTime(new Timestamp(taskSrc.getPlanEndTime().getTime()));
        taskDesc.setTotalTime(taskSrc.getTotalTime());
    }
}

