/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.BasedataException;
import com.kingdee.eas.mm.common.MMBaseStatusEnum;
import com.kingdee.eas.mm.project.IProjectTask;
import com.kingdee.eas.mm.project.ProjectCollection;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.mm.project.ProjectTaskCollection;
import com.kingdee.eas.mm.project.ProjectTaskFactory;
import com.kingdee.eas.mm.project.ProjectTaskInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Locale;

public class TaskCostImpExp
extends AbstractDataTransmission {
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return ProjectTaskFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        try {
            return this.innerTransmit(hsData, ctx);
        }
        catch (TaskExternalException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            if (rs.getString("storageOrgUnit.number") != null) {
                this.putTable(result, "FStorageOrgUnit", rs.getString("storageOrgUnit.number"));
            }
            if (rs.getString("project.name") != null) {
                this.putTable(result, "FProjectName", rs.getString("project.name"));
            }
            if (rs.getString("number") != null) {
                this.putTable(result, "FNumber", rs.getString("number"));
            }
            if (rs.getString("name") != null) {
                this.putTable(result, "FName", rs.getString("name"));
            }
            if (rs.getString("wbsNumber") != null) {
                this.putTable(result, "FWbsNumber", rs.getString("wbsNumber"));
            }
            if (rs.getString("material.name") != null) {
                this.putTable(result, "FMaterialName", rs.getString("material.name"));
            }
            if (rs.getString("baseStatus") != null) {
                this.putTable(result, "FTaskStatus", MMBaseStatusEnum.getEnum((int)rs.getInt("baseStatus")).getAlias());
            }
            if (rs.getString("currency.name") != null) {
                this.putTable(result, "FCurrency", rs.getString("currency.name"));
            }
            if (rs.getString("totalCost") != null) {
                this.putTable(result, "FTotalCost", rs.getString("totalCost"));
            }
            if (rs.getString("unitCost") != null) {
                this.putTable(result, "FUnitCost", rs.getString("unitCost"));
            }
            if (rs.getString("qty") != null) {
                this.putTable(result, "FQty", rs.getString("qty"));
            }
            if (rs.getString("adminOrgUnit.name") != null) {
                this.putTable(result, "FAdminOrgUnit", rs.getString("adminOrgUnit.name"));
            }
            if (rs.getString("project.number") != null) {
                this.putTable(result, "FProjectNumber", rs.getString("project.number"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    private CoreBaseInfo innerTransmit(Hashtable hsData, Context ctx) throws TaskExternalException, Exception {
        Object data = ((DataToken)hsData.get((Object)"FStorageOrgUnit")).data;
        if (data == null) {
            throw new BasedataException(BasedataException.FIELD_CANT_NULL, (Object[])new String[]{"FStorageOrgUnit"});
        }
        StorageOrgUnitInfo storageOrgUnit = this.getOrgByNumber(ctx, data.toString());
        if (storageOrgUnit == null) {
            throw new BasedataException(BasedataException.FIELD_ILEGAL, (Object[])new String[]{"FStorageOrgUnit"});
        }
        ProjectTaskInfo info = new ProjectTaskInfo();
        info.setStorageOrgUnit(storageOrgUnit);
        Object projectNumber = ((DataToken)hsData.get((Object)"FProjectNumber")).data;
        if (projectNumber == null) {
            throw new BasedataException(BasedataException.FIELD_CANT_NULL, (Object[])new String[]{"FProjectNumber"});
        }
        ProjectInfo project = this.getProjectByNumber(ctx, projectNumber.toString());
        if (project == null) {
            throw new BasedataException(BasedataException.FIELD_ILEGAL, (Object[])new String[]{"FProjectNumber"});
        }
        info.setProject(project);
        info = this.handleInfo(hsData, ctx, info);
        return info;
    }

    private StorageOrgUnitInfo getOrgByNumber(Context ctx, String number) throws TaskExternalException, BOSException, BasedataException {
        if (number == null || "".equals(number)) {
            throw new BasedataException(BasedataException.FIELD_CANT_NULL, (Object[])new String[]{"FStorageOrgUnit_number"});
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        StorageOrgUnitCollection coll = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitCollection(viewInfo);
        if (coll == null || coll.size() <= 0) {
            throw new BasedataException(BasedataException.FIELD_ILEGAL, (Object[])new String[]{"FStorageOrgUnit"});
        }
        StorageOrgUnitInfo info = coll.get(0);
        return info;
    }

    private ProjectTaskInfo handleInfo(Hashtable hsData, Context ctx, ProjectTaskInfo info) throws TaskExternalException, BOSException, EASBizException {
        ObjectUuidPK orgPK = new ObjectUuidPK(info.getStorageOrgUnit().getId());
        ObjectUuidPK projectPK = new ObjectUuidPK(info.getProject().getId());
        String number = DataImportTools.getDataString((Hashtable)hsData, (String)"FNumber");
        FilterInfo filter = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgPK, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("project.id", (Object)projectPK, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        IProjectTask projectTask = null;
        try {
            projectTask = ProjectTaskFactory.getLocalInstance(ctx);
        }
        catch (BOSException e2) {
            throw new TaskExternalException(TaskCostImpExp.getResource(ctx, "TASK_ERROR"));
        }
        ProjectTaskCollection taskCollection = null;
        try {
            taskCollection = projectTask.getProjectTaskCollection(viewInfo);
        }
        catch (BOSException e1) {
            throw new TaskExternalException(TaskCostImpExp.getResource(ctx, "NOT_FOUND_TASK"));
        }
        if (null != taskCollection) {
            if (0 == taskCollection.size()) {
                throw new TaskExternalException(TaskCostImpExp.getResource(ctx, "NOT_FOUND_TASK"));
            }
            if (1 < taskCollection.size()) {
                throw new TaskExternalException(TaskCostImpExp.getResource(ctx, "MORE_TASKS"));
            }
        } else {
            throw new TaskExternalException(TaskCostImpExp.getResource(ctx, "NOT_FOUND_TASK"));
        }
        info = taskCollection.get(0);
        ICurrency icurreny = CurrencyFactory.getLocalInstance((Context)ctx);
        if (info.getBaseStatus() == MMBaseStatusEnum.SUBMIT || info.getBaseStatus() == MMBaseStatusEnum.SUBMITCOST) {
            int premision = icurreny.getCurrencyInfo((IObjectPK)new ObjectUuidPK(info.getCurrency().getId().toString())).getPrecision();
            BigDecimal fqty = info.getQty();
            String totalCost = DataImportTools.getDataString((Hashtable)hsData, (String)"FTotalCost");
            String unitCost = DataImportTools.getDataString((Hashtable)hsData, (String)"FUnitCost");
            String basedate = DataImportTools.getDataString((Hashtable)hsData, (String)"FTaskStatus");
            BigDecimal bigtotalCost = new BigDecimal(totalCost);
            BigDecimal bigunitCost = new BigDecimal(unitCost);
            if (bigtotalCost.compareTo(bigunitCost) < 0 || bigunitCost.compareTo(new BigDecimal("0")) < 0) {
                throw new TaskExternalException(TaskCostImpExp.getResource(ctx, "TASK_QTY_IS_NOT_FU"));
            }
            if (fqty != null && fqty.compareTo(new BigDecimal("0")) == 0) {
                if (bigtotalCost.compareTo(bigunitCost) != 0) {
                    throw new TaskExternalException(TaskCostImpExp.getResource(ctx, "TASK_QTY_IS_EQUL_ZERO"));
                }
            } else if (bigunitCost.multiply(fqty).compareTo(bigtotalCost) != 0 && bigtotalCost.divide(fqty, premision, 4).compareTo(bigunitCost) != 0) {
                throw new TaskExternalException(TaskCostImpExp.getResource(ctx, "TASK_QTY_IS_NOT_HE_DAYE"));
            }
            info.setTotalCost(bigtotalCost);
            info.setUnitCost(bigunitCost);
            if (basedate.equalsIgnoreCase(MMBaseStatusEnum.SUBMIT.getAlias()) || basedate.equalsIgnoreCase(MMBaseStatusEnum.SUBMITCOST.getAlias())) {
                info.setBaseStatus(MMBaseStatusEnum.SUBMIT);
            }
        }
        return info;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (coreBaseInfo == null) {
                return;
            }
            if (coreBaseInfo.getId() == null || !this.getController(ctx).exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                ProjectTaskInfo taskInfo = (ProjectTaskInfo)coreBaseInfo;
                if (taskInfo.getBaseStatus() != null && taskInfo.getBaseStatus().equals((Object)MMBaseStatusEnum.SUBMIT)) {
                    this.getController(ctx).update((IObjectPK)new ObjectUuidPK(taskInfo.getId()), (CoreBaseInfo)taskInfo);
                } else if (taskInfo.getBaseStatus() != null && taskInfo.getBaseStatus().equals((Object)MMBaseStatusEnum.SUBMITCOST)) {
                    this.getController(ctx).update((IObjectPK)new ObjectUuidPK(taskInfo.getId()), (CoreBaseInfo)taskInfo);
                }
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private ProjectInfo getProjectByNumber(Context ctx, String number) throws BOSException, BasedataException {
        if (number == null || "".equals(number)) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        ProjectCollection coll = ProjectFactory.getLocalInstance(ctx).getProjectCollection(viewInfo);
        ProjectInfo info = coll.get(0);
        return info;
    }

    public static String getResource(Context ctx, String strKey) {
        String strTemp = ResourceBase.getString((String)"com.kingdee.eas.mm.project.ProjectTaskResource", (String)strKey, (Locale)ctx.getLocale());
        return strTemp;
    }
}

