/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.MMBaseStatusEnum;
import com.kingdee.eas.mm.common.util.MMCommonUtils;
import com.kingdee.eas.mm.project.IProjectTask;
import com.kingdee.eas.mm.project.ProjectDictDataInfo;
import com.kingdee.eas.mm.project.ProjectException;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.mm.project.ProjectTaskCentralPurOrgCollection;
import com.kingdee.eas.mm.project.ProjectTaskCentralPurOrgInfo;
import com.kingdee.eas.mm.project.ProjectTaskCollection;
import com.kingdee.eas.mm.project.ProjectTaskFactory;
import com.kingdee.eas.mm.project.ProjectTaskInfo;
import com.kingdee.eas.mm.project.TaskTemplateInfo;
import com.kingdee.eas.mm.project.WBSException;
import com.kingdee.eas.mm.project.WBSInfo;
import com.kingdee.eas.mm.project.WBSRulerFactory;
import com.kingdee.eas.mm.project.WBSRulerInfo;
import com.kingdee.eas.mm.project.app.AbstractWBSImportorFacadeControllerBean;
import com.kingdee.eas.mm.project.util.MMProjectCalendarFactory;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class WBSImportorFacadeControllerBean
extends AbstractWBSImportorFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.project.app.WBSImportorFacadeControllerBean");
    private MMProjectCalendarFactory mmCalendarFactory = null;
    private static final String RES_PRD_ORDER = "com.kingdee.eas.mm.project.WBSImportResource";

    @Override
    protected int _getLeadTime(Context ctx, String orgId, Date theDate, Date toDate) throws BOSException, EASBizException {
        if (this.mmCalendarFactory == null) {
            this.mmCalendarFactory = new MMProjectCalendarFactory(ctx, orgId);
        }
        return this.mmCalendarFactory.getLeadtime(theDate, toDate);
    }

    private Date getWorkDateLength(Context ctx, String orgId, Date theDate, int workdatelenth) throws BOSException, EASBizException {
        if (this.mmCalendarFactory == null) {
            this.mmCalendarFactory = new MMProjectCalendarFactory(ctx, orgId);
        }
        return this.mmCalendarFactory.addWroklength(theDate, workdatelenth);
    }

    @Override
    protected void _copyProjectTask(Context ctx, String orgId, IObjectValue srcProject, IObjectValue toProject, IObjectValue parent, List param, boolean model) throws BOSException, EASBizException {
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(5));
        status.add(new Integer(4));
        status.add(new Integer(7));
        IProjectTask ipro = ProjectTaskFactory.getLocalInstance(ctx);
        BigDecimal defaultQty = SysConstant.BIGZERO;
        UserInfo person = ContextUtil.getCurrentUserInfo((Context)ctx);
        Calendar cal = Calendar.getInstance();
        Timestamp t = new Timestamp(cal.getTimeInMillis());
        if (param != null && param.size() > 0) {
            Iterator it = param.iterator();
            ArrayList<ProjectTaskInfo> newTasks = new ArrayList<ProjectTaskInfo>();
            FilterInfo filter1 = new FilterInfo();
            FilterItemInfo projectfilter = new FilterItemInfo("project", (Object)((ProjectInfo)srcProject).getId().toString(), CompareType.EQUALS);
            FilterItemInfo basetstats = new FilterItemInfo("baseStatus", status, CompareType.INCLUDE);
            filter1.getFilterItems().add(projectfilter);
            filter1.getFilterItems().add(basetstats);
            FilterInfo filter2 = new FilterInfo();
            String maskStr = null;
            int inx = 1;
            while (it.hasNext()) {
                ProjectTaskInfo pro = (ProjectTaskInfo)it.next();
                FilterItemInfo wbsnumber = new FilterItemInfo("wbsnumber", (Object)(pro.getWbsNumber() + ".%"), CompareType.LIKE);
                filter2.getFilterItems().add(wbsnumber);
                if (maskStr == null) {
                    maskStr = "#0";
                    continue;
                }
                maskStr = maskStr + " OR #" + String.valueOf(inx++);
            }
            filter2.setMaskString(maskStr);
            filter1.mergeFilter(filter2, "AND");
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter1);
            SorterItemInfo sorterInfo = new SorterItemInfo("wbsnumber");
            sorterInfo.setSortType(SortType.ASCEND);
            viewInfo.getSorter().add(sorterInfo);
            ProjectTaskCollection pros = ipro.getProjectTaskCollection(viewInfo);
            for (ProjectTaskInfo pro : param) {
                pros.add(pro);
            }
            MMCommonUtils.objectValueSort((IObjectCollection)pros, (boolean)true, (String)"wbsNumber");
            for (int i = 0; i < pros.size(); ++i) {
                ProjectTaskInfo task = pros.get(i);
                task.setCarNumber(null);
                task.setBaseStatus(MMBaseStatusEnum.SAVED);
                task.setTotalQty(defaultQty);
                task.setCompletePercent(defaultQty);
                task.setActTotalCost(defaultQty);
                task.setComment(null);
                task.setAuditor(null);
                task.setAuditTime(null);
                task.setLastUpdateTime(null);
                task.setLastUpdateUser(null);
                task.setCreator(person);
                task.setCreateTime(t);
                task.setIsTemplate(model);
                task.setTotalCost(defaultQty);
                task.setUnitCost(defaultQty);
                task.setActualBeginTime(null);
                task.setActualEndTime(null);
                task.setActualTotalTime(new BigDecimal("0"));
                task.setIsTransferedCentral(false);
                task.setIsTransfered(false);
                newTasks.add(task);
            }
            this.importWBSLocal(ctx, orgId, srcProject, toProject, parent, newTasks, true);
        } else {
            FilterInfo filter1 = new FilterInfo();
            FilterItemInfo basetstats = new FilterItemInfo("baseStatus", status, CompareType.INCLUDE);
            FilterItemInfo projectfilter = new FilterItemInfo("project", (Object)((ProjectInfo)srcProject).getId().toString(), CompareType.EQUALS);
            filter1.getFilterItems().add(basetstats);
            filter1.getFilterItems().add(projectfilter);
            filter1.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer("0"), CompareType.NOTEQUALS));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter1);
            SorterItemInfo sorterInfo = new SorterItemInfo("wbsnumber");
            sorterInfo.setSortType(SortType.ASCEND);
            viewInfo.getSorter().add(sorterInfo);
            ProjectTaskCollection pros = ipro.getProjectTaskCollection(viewInfo);
            ArrayList<ProjectTaskInfo> newTasks = new ArrayList<ProjectTaskInfo>();
            for (int i = 0; i < pros.size(); ++i) {
                ProjectTaskInfo task = pros.get(i);
                task.setCarNumber(null);
                task.setBaseStatus(MMBaseStatusEnum.SAVED);
                task.setTotalQty(defaultQty);
                task.setCompletePercent(defaultQty);
                task.setActTotalCost(defaultQty);
                task.setComment(null);
                task.setAuditor(null);
                task.setAuditTime(null);
                task.setLastUpdateTime(null);
                task.setLastUpdateUser(null);
                task.setIsTemplate(model);
                task.setCreator(person);
                task.setCreateTime(t);
                task.setTotalCost(defaultQty);
                task.setUnitCost(defaultQty);
                task.setActualBeginTime(null);
                task.setActualEndTime(null);
                task.setActualTotalTime(new BigDecimal("0"));
                task.setIsTransferedCentral(false);
                task.setIsTransfered(false);
                newTasks.add(task);
            }
            if (newTasks.size() == 0) {
                throw new WBSException(WBSException.TASK_NUM_IS_0);
            }
            this.importWBSLocal(ctx, orgId, srcProject, toProject, parent, newTasks, true);
        }
    }

    private List importWBSLocal(Context ctx, String orgId, IObjectValue srcProject, IObjectValue toProject, IObjectValue parent, List param, boolean isCopy) throws BOSException, EASBizException {
        ICodingRuleManager codingRuleManager;
        RuleStatus ruleStatus;
        ArrayList<String> list = new ArrayList<String>();
        ProjectInfo projectSrc = (ProjectInfo)srcProject;
        ProjectInfo projectDest = (ProjectInfo)toProject;
        ProjectTaskInfo parentTask = null;
        ProjectTaskInfo root = null;
        ProjectTaskInfo taskInstance = new ProjectTaskInfo();
        if (!isCopy) {
            taskInstance.setProject(projectDest);
        }
        if (!(ruleStatus = (codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx)).getRuleStatus((IObjectValue)taskInstance, orgId)).isExist()) {
            throw new WBSException(WBSException.TASK_CODING_RULE_WRONG);
        }
        String[] nums = codingRuleManager.getBatchNumber((IObjectValue)taskInstance, orgId, param.size());
        Connection con = null;
        try {
            ProjectTaskInfo task;
            con = this.getConnection(ctx);
            root = parent != null ? (parentTask = (ProjectTaskInfo)parent) : ProjectTaskFactory.getLocalInstance(ctx).getRootProject(projectDest.getId().toString());
            WBSRulerInfo[] wbsRulers = null;
            Iterator itTree = param.iterator();
            Iterator tempIt = param.iterator();
            ArrayList<ProjectTaskInfo> pTaskLevel1 = new ArrayList<ProjectTaskInfo>();
            HashMap<BOSUuid, ProjectTaskInfo> pTasks = new HashMap<BOSUuid, ProjectTaskInfo>();
            while (tempIt.hasNext()) {
                task = (ProjectTaskInfo)tempIt.next();
                pTasks.put(task.getId(), task);
            }
            while (itTree.hasNext()) {
                task = (ProjectTaskInfo)itTree.next();
                task.setProject(projectDest);
                if (task.getPreTask() != null && pTasks.get(task.getPreTask().getId()) != null) {
                    task.setPreTask((ProjectTaskInfo)pTasks.get(task.getPreTask().getId()));
                }
                if (task.getParent() == null) {
                    pTaskLevel1.add(task);
                    task.setParent(parentTask);
                    continue;
                }
                Object objTask = pTasks.get(task.getParent().getId());
                if (objTask != null) {
                    ProjectTaskInfo p_task = (ProjectTaskInfo)objTask;
                    task.setParent(p_task);
                    continue;
                }
                task.setParent(parentTask);
                pTaskLevel1.add(task);
            }
            int pt_plan_it = this._getLeadTime(ctx, projectDest.getId().toString(), projectDest.getPlanBeginTime(), root.getPlanBeginTime());
            int t_old_plan_it = 0;
            int old_p_it = 0;
            Date t_planBeginDate = null;
            Date t_planEndDate = null;
            int workdate = 0;
            Iterator it = param.iterator();
            IORMappingDAO dao = ORMappingDAO.getInstance((BOSObjectType)new ProjectTaskInfo().getBOSType(), (Context)ctx, (Connection)con);
            WBSInfo[] wbsInfoLevel1 = null;
            String parentID = null;
            if (parentTask != null) {
                parentID = parentTask.getId().toString();
            }
            if (pTaskLevel1.size() != 0) {
                wbsInfoLevel1 = WBSRulerFactory.getLocalInstance(ctx).getNextWBS(projectDest.getId().toString(), parentID, pTaskLevel1.size());
            }
            int level1Number = 0;
            wbsRulers = WBSRulerFactory.getLocalInstance(ctx).getWBSRuler(projectDest.getId().toString());
            int codingNum = 0;
            while (it.hasNext()) {
                ProjectTaskInfo task2 = (ProjectTaskInfo)it.next();
                t_old_plan_it = this._getLeadTime(ctx, projectDest.getId().toString(), projectSrc.getPlanBeginTime(), task2.getPlanBeginTime());
                String oldWbs = null;
                String theWbs = task2.getWbsNumber();
                if (oldWbs == null || oldWbs != null && (theWbs + ".").indexOf(oldWbs) <= 0) {
                    old_p_it = t_old_plan_it;
                    oldWbs = theWbs;
                }
                task2.setNumber(nums[codingNum]);
                if (task2.getParent() == null || parentTask != null && task2.getParent().equals(parentTask)) {
                    task2.setId(BOSUuid.create((BOSObjectType)task2.getBOSType()));
                    if (wbsInfoLevel1 != null) {
                        task2.setWbsNumber(wbsInfoLevel1[level1Number].getWBS());
                        task2.setSeq(wbsInfoLevel1[level1Number].getSeq());
                        task2.setLevel(wbsInfoLevel1[level1Number].getLevel());
                    }
                    task2.setNextSeq(1);
                    ++level1Number;
                } else {
                    ProjectTaskInfo currParent = task2.getParent();
                    WBSInfo wbsInfo = new WBSInfo();
                    int rulerLevel = currParent.getLevel();
                    if (rulerLevel > 8) {
                        rulerLevel = 8;
                    }
                    wbsInfo.setDelimitor(".");
                    wbsInfo.setDigists(wbsRulers[rulerLevel].getDigists());
                    wbsInfo.setSeq(currParent.getNextSeq());
                    wbsInfo.setParentWBS(currParent.getWbsNumber());
                    task2.setId(BOSUuid.create((BOSObjectType)task2.getBOSType()));
                    task2.setLevel(currParent.getLevel() + 1);
                    task2.setSeq(currParent.getNextSeq());
                    task2.setNextSeq(1);
                    this.checkWBSOutOfBounds(currParent.getNextSeq(), wbsRulers[rulerLevel].getDigists());
                    task2.setWbsNumber(wbsInfo.getWBS());
                    currParent.setNextSeq(currParent.getNextSeq() + 1);
                }
                int t_Old_PlanBeginDate_it = this._getLeadTime(ctx, projectDest.getId().toString(), projectSrc.getPlanBeginTime(), task2.getPlanBeginTime());
                int t_Old_PlanEndDate_it = this._getLeadTime(ctx, projectDest.getId().toString(), projectSrc.getPlanBeginTime(), task2.getPlanEndTime());
                if (old_p_it * pt_plan_it == 0) {
                    t_planBeginDate = this._getDay(ctx, projectDest.getId().toString(), root.getPlanBeginTime(), t_Old_PlanBeginDate_it);
                    t_planEndDate = this._getDay(ctx, projectDest.getId().toString(), root.getPlanBeginTime(), t_Old_PlanEndDate_it);
                } else {
                    t_planBeginDate = this._getDay(ctx, projectDest.getId().toString(), root.getPlanBeginTime(), t_Old_PlanBeginDate_it / old_p_it * pt_plan_it);
                    t_planEndDate = this._getDay(ctx, projectDest.getId().toString(), root.getPlanBeginTime(), t_Old_PlanEndDate_it / old_p_it * pt_plan_it);
                }
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(t_planBeginDate);
                if (isCopy) {
                    task2.setPlanBeginTime(new Timestamp(calendar.getTimeInMillis()));
                }
                workdate = task2.getTotalTime().setScale(0, 4).intValue();
                calendar.setTime(this.getWorkDateLength(ctx, projectDest.getId().toString(), task2.getPlanBeginTime(), workdate));
                task2.setPlanEndTime(new Timestamp(calendar.getTimeInMillis()));
                task2.setTotalTime(new BigDecimal(workdate));
                int t_Old_earistBeginDate_it = 0;
                int t_Old_earistEndDate_it = 0;
                Date t_EaristBeginDate = null;
                Date t_EaristEndDate = null;
                boolean isSetEaristBegin = false;
                boolean isSetEaristEnd = false;
                if (projectSrc.getPlanBeginTime() != null && task2.getEaristBeginTime() != null) {
                    t_Old_earistBeginDate_it = this._getLeadTime(ctx, projectDest.getId().toString(), projectSrc.getPlanBeginTime(), task2.getEaristBeginTime());
                    isSetEaristBegin = true;
                }
                if (projectSrc.getPlanBeginTime() != null && task2.getEaristEndTime() != null) {
                    t_Old_earistEndDate_it = this._getLeadTime(ctx, projectDest.getId().toString(), projectSrc.getPlanBeginTime(), task2.getEaristEndTime());
                    isSetEaristEnd = true;
                }
                if (old_p_it * pt_plan_it == 0) {
                    t_EaristBeginDate = this._getDay(ctx, projectDest.getId().toString(), root.getPlanBeginTime(), t_Old_earistBeginDate_it);
                    t_EaristEndDate = this._getDay(ctx, projectDest.getId().toString(), root.getPlanBeginTime(), t_Old_earistEndDate_it);
                } else {
                    t_EaristBeginDate = this._getDay(ctx, projectDest.getId().toString(), root.getPlanBeginTime(), t_Old_earistBeginDate_it / old_p_it * pt_plan_it);
                    t_EaristEndDate = this._getDay(ctx, projectDest.getId().toString(), root.getPlanBeginTime(), t_Old_earistEndDate_it / old_p_it * pt_plan_it);
                }
                if (isSetEaristBegin) {
                    calendar.setTime(t_EaristBeginDate);
                    task2.setEaristBeginTime(new Timestamp(calendar.getTimeInMillis()));
                }
                if (isSetEaristEnd) {
                    calendar.setTime(this.getWorkDateLength(ctx, projectDest.getId().toString(), t_EaristBeginDate, workdate));
                    task2.setEaristEndTime(new Timestamp(calendar.getTimeInMillis()));
                }
                int t_Old_lastBeginDate_it = 0;
                int t_Old_lastEndDate_it = 0;
                Date t_LastBeginDate = null;
                Date t_LastEndDate = null;
                boolean isSetLastBegin = false;
                boolean isSetLastEnd = false;
                if (projectSrc.getPlanBeginTime() != null && task2.getLastBeginTime() != null) {
                    t_Old_lastBeginDate_it = this._getLeadTime(ctx, projectDest.getId().toString(), projectSrc.getPlanBeginTime(), task2.getLastBeginTime());
                    isSetLastBegin = true;
                }
                if (projectSrc.getPlanBeginTime() != null && task2.getLastEndTime() != null) {
                    t_Old_lastEndDate_it = this._getLeadTime(ctx, projectDest.getId().toString(), projectSrc.getPlanBeginTime(), task2.getLastEndTime());
                    isSetLastEnd = true;
                }
                if (old_p_it * pt_plan_it == 0) {
                    t_LastBeginDate = this._getDay(ctx, projectDest.getId().toString(), root.getPlanBeginTime(), t_Old_lastBeginDate_it);
                    t_LastEndDate = this._getDay(ctx, projectDest.getId().toString(), root.getPlanBeginTime(), t_Old_lastEndDate_it);
                } else {
                    t_LastBeginDate = this._getDay(ctx, projectDest.getId().toString(), root.getPlanBeginTime(), t_Old_lastBeginDate_it / old_p_it * pt_plan_it);
                    t_LastEndDate = this._getDay(ctx, projectDest.getId().toString(), root.getPlanBeginTime(), t_Old_lastEndDate_it / old_p_it * pt_plan_it);
                }
                if (isSetLastBegin) {
                    calendar.setTime(t_LastBeginDate);
                    task2.setLastBeginTime(new Timestamp(calendar.getTimeInMillis()));
                }
                if (isSetLastEnd) {
                    calendar.setTime(this.getWorkDateLength(ctx, projectDest.getId().toString(), t_LastBeginDate, workdate));
                    task2.setLastEndTime(new Timestamp(calendar.getTimeInMillis()));
                }
                if (task2.getName() == null || task2.getName().equals("")) {
                    list.add(task2.getNumber());
                }
                dao.addNewBatch((IObjectValue)task2);
                ++codingNum;
            }
            dao.executeBatch();
        }
        catch (DataAccessException e) {
            codingRuleManager.recycleBatchNumber((IObjectValue)taskInstance, orgId, nums);
            throw e;
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        return list;
    }

    private void checkWBSOutOfBounds(int seq, int digists) throws WBSException {
        if ((double)seq > Math.pow(10.0, digists) - 1.0) {
            throw new WBSException(WBSException.WBSSEQ_OUTOFBOUNDS);
        }
    }

    @Override
    protected List _importWBS(Context ctx, String orgId, IObjectValue srcProject, IObjectValue toProject, IObjectValue parent, List param) throws BOSException, EASBizException {
        ProjectInfo projectDest = (ProjectInfo)toProject;
        if (this.mmCalendarFactory == null) {
            this.mmCalendarFactory = new MMProjectCalendarFactory(ctx, projectDest.getId().toString());
        }
        IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)"1", (BOSObjectType)new ProjectTaskInfo().getBOSType(), null, (String)WBSImportorFacadeControllerBean.getResource(ctx, "WBS_IMP"), (String)"mm_projecttask_wbsimp");
        param = this.dealParam(ctx, param, orgId, projectDest);
        List list = this.importWBSLocal(ctx, orgId, srcProject, toProject, parent, param, false);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
        return list;
    }

    @Override
    protected Date _getDay(Context ctx, String orgId, Date theDate, int leadTime) throws BOSException, EASBizException {
        if (this.mmCalendarFactory == null) {
            this.mmCalendarFactory = new MMProjectCalendarFactory(ctx, orgId);
        }
        return this.mmCalendarFactory.addLeadtime(theDate, leadTime);
    }

    public static String getResource(Context ctx, String strKey) {
        String strTemp = ResourceBase.getString((String)"com.kingdee.eas.mm.project.WBSResource", (String)strKey, (Locale)ctx.getLocale());
        return strTemp;
    }

    private List dealParam(Context ctx, List param, String orgId, ProjectInfo projectDest) throws BOSException, ProjectException {
        if (param != null && param.size() > 0) {
            ProjectTaskInfo taskInfo = null;
            String number = null;
            StorageOrgUnitInfo orgUnitInfo = null;
            AdminOrgUnitInfo adminUnitInfo = null;
            MaterialInfo materialInfo = null;
            PersonInfo personInfo = null;
            ProjectDictDataInfo projectDictInfo = null;
            TrackNumberInfo trackNum = null;
            TaskTemplateInfo taskTemp = null;
            String currentOrgId = null;
            String projectId = projectDest.getId().toString();
            String adminUnitId = null;
            ProjectTaskCentralPurOrgCollection col = null;
            ProjectTaskCentralPurOrgInfo cenOrgInfo = null;
            for (int i = 0; i < param.size(); ++i) {
                taskInfo = (ProjectTaskInfo)param.get(i);
                if (taskInfo.getString("storageorgunit") != null) {
                    number = taskInfo.getString("storageorgunit");
                    orgUnitInfo = this.getStorageByNumber(ctx, number, projectId, "fstorageOrgUnit");
                } else {
                    orgUnitInfo = new StorageOrgUnitInfo();
                    orgUnitInfo.setId(BOSUuid.read((String)orgId));
                }
                taskInfo.setStorageOrgUnit(orgUnitInfo);
                currentOrgId = orgUnitInfo.getId().toString();
                if (taskInfo.getString("createOrgUnit") != null) {
                    number = taskInfo.getString("createOrgUnit");
                    orgUnitInfo = this.getStorageByNumber(ctx, number, null, "fcreateOrgUnit");
                } else {
                    orgUnitInfo = new StorageOrgUnitInfo();
                    orgUnitInfo.setId(BOSUuid.read((String)orgId));
                }
                taskInfo.setCreateOrgUnit(orgUnitInfo);
                if (taskInfo.getString("centralPurStgOrg") != null) {
                    number = taskInfo.getString("centralPurStgOrg");
                    col = new ProjectTaskCentralPurOrgCollection();
                    cenOrgInfo = new ProjectTaskCentralPurOrgInfo();
                    orgUnitInfo = this.getStorageByNumber(ctx, number, projectId, "fcentralPurStgOrg");
                    cenOrgInfo.setParent(taskInfo);
                    cenOrgInfo.setStorageOrgUnit(orgUnitInfo);
                    col.add(cenOrgInfo);
                    taskInfo.setCentralPurStgOrg(null);
                    taskInfo.put("centralPurStorageOrg", (Object)col);
                }
                if (taskInfo.getString("adminOrgUnit") != null) {
                    number = taskInfo.getString("adminOrgUnit");
                    adminUnitInfo = this.getAdminOrgByNumber(ctx, number, "fadminOrgUnit");
                    taskInfo.setAdminOrgUnit(adminUnitInfo);
                    adminUnitId = adminUnitInfo.getId().toString();
                    if (taskInfo.getString("person") != null) {
                        number = taskInfo.getString("person");
                        personInfo = this.getPersonByNumber(ctx, number, adminUnitId, "fperson");
                        taskInfo.setPerson(personInfo);
                    }
                } else {
                    taskInfo.setPerson(null);
                }
                if (taskInfo.getString("material") != null) {
                    number = taskInfo.getString("material");
                    materialInfo = this.getMaterialByNumber(ctx, number, currentOrgId, "fmaterial");
                    taskInfo.setMaterial(materialInfo);
                    taskInfo.setUnit(materialInfo.getBaseUnit());
                    taskInfo.setBaseUnit(materialInfo.getBaseUnit());
                }
                if (taskInfo.getString("taskType") != null) {
                    number = taskInfo.getString("taskType");
                    projectDictInfo = this.getProjectDictDataByNumber(ctx, number, 10);
                } else {
                    projectDictInfo = new ProjectDictDataInfo();
                    projectDictInfo.setId(BOSUuid.read((String)"LCjtHmEGRSCChKDBR/R9jJpMH64="));
                }
                taskInfo.setTaskType(projectDictInfo);
                if (taskInfo.getString("feedbackMode") != null) {
                    number = taskInfo.getString("feedbackMode");
                    projectDictInfo = this.getProjectDictDataByNumber(ctx, number, 60);
                } else {
                    projectDictInfo = new ProjectDictDataInfo();
                    projectDictInfo.setId(BOSUuid.read((String)"8/nx9bmpQC6M7x3BBwNUappMH64="));
                }
                taskInfo.setFeedbackMode(projectDictInfo);
                if (taskInfo.getString("carNumber") != null) {
                    number = taskInfo.getString("carNumber");
                    trackNum = this.getTrackNumberByNumber(ctx, number, projectId, "fcarNumber");
                    taskInfo.setCarNumber(trackNum);
                }
                if (taskInfo.getString("taskTemplate") == null) continue;
                number = taskInfo.getString("taskTemplate");
                taskTemp = this.getTaskTemplateByNumber(ctx, number, currentOrgId, "ftaskTemplate");
                taskInfo.setTaskTemplate(taskTemp);
            }
        }
        return param;
    }

    private StorageOrgUnitInfo getStorageByNumber(Context ctx, String number, String projectId, String filedName) throws BOSException, ProjectException {
        StorageOrgUnitInfo unitInfo = new StorageOrgUnitInfo();
        String id = null;
        StringBuffer sb = new StringBuffer();
        number = number.trim();
        sb.append("select s.fid fid from t_org_storage s ");
        if (projectId != null) {
            if ("fstorageOrgUnit".equalsIgnoreCase(filedName)) {
                sb.append(" inner join t_mm_projectorg p on s.fid = p.fstorageorgunitid ");
            } else {
                sb.append(" inner join T_MM_ProjectCentralPurOrg p on s.fid = p.FStorageOrgUnitID ");
            }
        }
        sb.append("where s.fnumber = '").append(number).append("'");
        if (projectId != null) {
            if ("fstorageOrgUnit".equalsIgnoreCase(filedName)) {
                sb.append(" and p.fprojectid = '").append(projectId).append("'");
            } else {
                sb.append(" and p.FParentID = '").append(projectId).append("'");
            }
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rowSet.next()) {
                id = rowSet.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (id == null) {
            String name = this.getResourceMsg(filedName);
            throw new ProjectException(ProjectException.PROJECT_IS_FIELDERRO, new String[]{name, number});
        }
        unitInfo.setId(BOSUuid.read((String)id));
        return unitInfo;
    }

    private AdminOrgUnitInfo getAdminOrgByNumber(Context ctx, String number, String filedName) throws BOSException, ProjectException {
        AdminOrgUnitInfo unitInfo = new AdminOrgUnitInfo();
        String id = null;
        StringBuffer sb = new StringBuffer();
        number = number.trim();
        sb.append("select fid from T_ORG_Admin where fnumber = '").append(number).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rowSet.next()) {
                id = rowSet.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (id == null) {
            String name = this.getResourceMsg(filedName);
            throw new ProjectException(ProjectException.PROJECT_IS_FIELDERRO, new String[]{name, number});
        }
        unitInfo.setId(BOSUuid.read((String)id));
        return unitInfo;
    }

    private MaterialInfo getMaterialByNumber(Context ctx, String number, String orgid, String filedName) throws BOSException, ProjectException {
        MaterialInfo materialInfo = new MaterialInfo();
        MeasureUnitInfo unitInfo = new MeasureUnitInfo();
        String id = null;
        String unitId = null;
        StringBuffer sb = new StringBuffer();
        number = number.trim();
        sb.append("select m.fid,m.fbaseunit from t_bd_material m INNER JOIN T_BD_MaterialPlan PLAN ");
        sb.append(" oN m.FID = PLAN.FMaterialID").append("where m.fnumber = '").append(number).append("'");
        sb.append(" and m.fstatus = ").append(1);
        sb.append(" and PLAN.FOrgUnit = '").append(orgid).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rowSet.next()) {
                id = rowSet.getString("fid");
                unitId = rowSet.getString("fbaseunit");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (id == null) {
            String name = this.getResourceMsg(filedName);
            throw new ProjectException(ProjectException.PROJECT_IS_FIELDERRO, new String[]{name, number});
        }
        materialInfo.setId(BOSUuid.read((String)id));
        unitInfo.setId(BOSUuid.read((String)unitId));
        materialInfo.setBaseUnit(unitInfo);
        return materialInfo;
    }

    private PersonInfo getPersonByNumber(Context ctx, String number, String adminUnitId, String filedName) throws BOSException, ProjectException {
        PersonInfo personInfo = new PersonInfo();
        String id = null;
        StringBuffer sb = new StringBuffer();
        number = number.trim();
        sb.append("select p.fid  fid from T_BD_Person p INNER JOIN T_ORG_PositionMember pm ON p.FID = pm.FPersonID ");
        sb.append(" INNER JOIN T_ORG_Position  pt ON pm.FPositionID = pt.FID ");
        sb.append(" where p.fnumber = '").append(number).append("'");
        sb.append(" and pt.FAdminOrgUnitID = '").append(adminUnitId).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rowSet.next()) {
                id = rowSet.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (id == null) {
            personInfo.setId(null);
        } else {
            personInfo.setId(BOSUuid.read((String)id));
        }
        return personInfo;
    }

    private ProjectDictDataInfo getProjectDictDataByNumber(Context ctx, String number, int ProjectDictType) throws BOSException, ProjectException {
        ProjectDictDataInfo projectDictDataInfo = new ProjectDictDataInfo();
        String id = null;
        StringBuffer sb = new StringBuffer();
        number = number.trim();
        sb.append("select fid from T_MM_ProjectDictData where fnumber = '").append(number).append("'");
        sb.append(" and FDictDataTypeEnum = ").append(ProjectDictType);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rowSet.next()) {
                id = rowSet.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (id == null) {
            String filedName = null;
            if (ProjectDictType == 10) {
                filedName = "ftaskType";
            } else if (ProjectDictType == 20) {
                filedName = "fiteratorType";
            } else if (ProjectDictType == 60) {
                filedName = "ffeedbackMode";
            }
            String name = this.getResourceMsg(filedName);
            throw new ProjectException(ProjectException.PROJECT_IS_FIELDERRO, new String[]{name, number});
        }
        projectDictDataInfo.setId(BOSUuid.read((String)id));
        return projectDictDataInfo;
    }

    private TrackNumberInfo getTrackNumberByNumber(Context ctx, String number, String projectId, String filedName) throws BOSException, ProjectException {
        TrackNumberInfo trackNumInfo = new TrackNumberInfo();
        String id = null;
        StringBuffer sb = new StringBuffer();
        number = number.trim();
        sb.append("select t.fid fid from T_MM_TrackNumber t inner join  T_MM_ProjectCar p on t.fid = p.ftracknumberid");
        sb.append(" where t.fnumber = '").append(number).append("'");
        sb.append(" and p.fprojectid = '").append(projectId).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rowSet.next()) {
                id = rowSet.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (id == null) {
            String name = this.getResourceMsg(filedName);
            throw new ProjectException(ProjectException.PROJECT_IS_FIELDERRO, new String[]{name, number});
        }
        trackNumInfo.setId(BOSUuid.read((String)id));
        return trackNumInfo;
    }

    private TaskTemplateInfo getTaskTemplateByNumber(Context ctx, String number, String orgid, String filedName) throws BOSException, ProjectException {
        TaskTemplateInfo taskTemp = new TaskTemplateInfo();
        String id = null;
        StringBuffer sb = new StringBuffer();
        number = number.trim();
        sb.append("select fid from t_mm_tasktemplate where fnumber = '").append(number).append("'");
        sb.append(" and fstorageorgunitid = '").append(orgid).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rowSet.next()) {
                id = rowSet.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (id == null) {
            String name = this.getResourceMsg(filedName);
            throw new ProjectException(ProjectException.PROJECT_IS_FIELDERRO, new String[]{name, number});
        }
        taskTemp.setId(BOSUuid.read((String)id));
        return taskTemp;
    }

    private String getResourceMsg(String key) {
        return ResourceUtils.getMessage((String)RES_PRD_ORDER, (String)key);
    }
}

