/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.project.WBSException;
import com.kingdee.eas.mm.project.WBSInfo;
import com.kingdee.eas.mm.project.WBSRulerCollection;
import com.kingdee.eas.mm.project.WBSRulerInfo;
import com.kingdee.eas.mm.project.app.AbstractWBSRulerControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class WBSRulerControllerBean
extends AbstractWBSRulerControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.project.app.WBSRulerControllerBean");

    @Override
    protected void _save(Context ctx, WBSRulerInfo[] models) throws BOSException, EASBizException {
        StringBuffer sqlBuf = new StringBuffer("");
        sqlBuf.append("update T_MM_WBSRuler set FDigists=?");
        sqlBuf.append(" where FID = ?");
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = this.getConnection(ctx);
            statement = con.prepareStatement(sqlBuf.toString());
            for (int i = 0; i < models.length; ++i) {
                WBSRulerInfo wbsInfo = models[i];
                statement.setInt(1, wbsInfo.getDigists());
                statement.setString(2, wbsInfo.getId().toString());
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
    }

    @Override
    protected WBSRulerInfo[] _getWBSRuler(Context ctx, String projectId) throws BOSException {
        Connection con = null;
        PreparedStatement statement = null;
        ResultSet set = null;
        WBSRulerCollection coll = new WBSRulerCollection();
        WBSRulerInfo[] infos = null;
        String sql = null;
        sql = null != projectId ? "select FID,FLEVEL,FDigists from T_MM_WBSRuler where FProjectID = '" + projectId + "' order by FLEVEL asc" : "select FID,FLEVEL,FDigists from T_MM_WBSRuler where FProjectID is null order by FLEVEL asc";
        try {
            con = this.getConnection(ctx);
            statement = con.prepareStatement(sql);
            set = statement.executeQuery();
            while (set.next()) {
                WBSRulerInfo info = new WBSRulerInfo();
                info.setId(BOSUuid.read((String)set.getString("FID")));
                info.setLevel(set.getInt("FLEVEL"));
                info.setDigists(set.getInt("FDigists"));
                coll.add(info);
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(set, statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)set, (Statement)statement, (Connection)con);
        infos = new WBSRulerInfo[coll.size()];
        System.arraycopy(coll.toArray(), 0, infos, 0, coll.size());
        return infos;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected WBSInfo[] _getNextWBS(Context ctx, String projectId, String parentTaskId, int number) throws BOSException, EASBizException {
        Connection con = null;
        Statement statement = null;
        ResultSet set = null;
        String parentWBSNumber = null;
        int parentLevel = 0;
        int nextSeq = 0;
        int lastWBS = 0;
        int nextWBS = 0;
        int level = 0;
        int digists = 0;
        try {
            String sqlFindParentId = "select FID from T_MM_ProjectTask where FProjectID= '" + projectId + "' and FLevel=0 and FParentID is null";
            con = this.getConnection(ctx);
            if (parentTaskId == null) {
                if (statement != null) {
                    set = statement.executeQuery(sqlFindParentId);
                }
                if (set != null && set.next()) {
                    parentTaskId = set.getString("FID");
                }
            }
            String sqlLock = "update T_MM_ProjectTask set FNextSeq=FNextSeq where FID= ?";
            String sqlWBSSeq = "select FLevel,FNextSeq,FWbsNumber from T_MM_ProjectTask where FID= ?";
            DbUtil.execute((Context)ctx, (String)sqlLock, (Object[])new Object[]{parentTaskId});
            set = DbUtil.executeQuery((Context)ctx, (String)sqlWBSSeq, (Object[])new Object[]{parentTaskId});
            if (set.next()) {
                parentLevel = set.getInt("FLevel");
                nextSeq = set.getInt("FNextSeq");
                parentWBSNumber = set.getString("FWbsNumber");
                level = parentLevel + 1;
            }
            String sqlWBSRuler = null;
            sqlWBSRuler = level > 9 ? "select max(FDigists) FDigists from T_MM_WBSRuler where FProjectID= '" + projectId + "'" : "select FDigists from T_MM_WBSRuler where FProjectID= '" + projectId + "' and FLEVEL = " + level;
            statement = con.prepareStatement(sqlWBSRuler);
            set = statement.executeQuery();
            if (set.next()) {
                digists = set.getInt("FDigists");
            }
            lastWBS = nextSeq + number - 1;
            nextWBS = nextSeq + number;
            if ((double)lastWBS > Math.pow(10.0, digists) - 1.0) {
                throw new WBSException(WBSException.WBSSEQ_OUTOFBOUNDS);
            }
            String sqlUpdate = "update T_MM_ProjectTask set FNextSeq= ? where FID= ?";
            DbUtil.execute((Context)ctx, (String)sqlUpdate, (Object[])new Object[]{nextWBS, parentTaskId});
        }
        catch (EASBizException e) {
            try {
                throw e;
                catch (SQLException e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(set, statement, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)set, (Statement)statement, (Connection)con);
        WBSInfo[] wbsInfos = new WBSInfo[number];
        int i = 0;
        while (i < number) {
            WBSInfo info = new WBSInfo();
            info.setDelimitor(".");
            info.setDigists(digists);
            info.setParentWBS(parentWBSNumber);
            info.setLevel(level);
            info.setSeq(nextSeq + i);
            wbsInfos[i] = info;
            ++i;
        }
        return wbsInfos;
    }
}

