/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.project.ProjectException;
import com.kingdee.eas.mm.project.WBSTypeEnum;
import com.kingdee.eas.mm.project.app.AbstractWriteBackWBSFacadeControllerBean;
import com.kingdee.eas.mm.project.app.ProjectTaskControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class WriteBackWBSFacadeControllerBean
extends AbstractWriteBackWBSFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.project.app.WriteBackWBSFacadeControllerBean");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _batchWriteBackByQty(Context ctx, String tempTableName, int bizAction, WBSTypeEnum taskType) throws BOSException, EASBizException {
        ArrayList<String> errorlist = new ArrayList<String>();
        if (bizAction == 109) {
            StringBuffer subSql = new StringBuffer();
            subSql.append("SELECT distinct FBillID FROM ");
            subSql.append(tempTableName + " temp ,T_MM_ProjectTask ");
            subSql.append(" WHERE temp.FPROJECTID=T_MM_ProjectTask.FPROJECTID");
            subSql.append(" AND temp.FMaterialID=T_MM_ProjectTask.FMaterialID");
            subSql.append(" AND temp.FStorageOrgUnitID=T_MM_ProjectTask.FStorageOrgUnitID");
            subSql.append(" AND (temp.FTrackNumberID is null and T_MM_ProjectTask.FCarNumberID is null or temp.FTrackNumberID=T_MM_ProjectTask.FCarNumberID) ");
            subSql.append(" AND  T_MM_ProjectTask.FBaseStatus=");
            subSql.append(7);
            subSql.append("  AND T_MM_ProjectTask.FFeedbackModeID='8RJ1z1oESdOXmsnCpkmCeppMH64=' ");
            subSql.append("  AND  T_MM_ProjectTask.FTaskTypeID='");
            subSql.append(taskType == WBSTypeEnum.PURCHASE ? "AyKjxAUlS9KdlMIjwVdddZpMH64=" : "uxqG1JcyTNKWqD8KTZatKppMH64=");
            subSql.append("'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)subSql.toString());
            try {
                if (rs != null && rs.size() > 0) {
                    while (rs.next()) {
                        errorlist.add(rs.getString("FBillID"));
                    }
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (errorlist.size() > 0) {
                throw new ProjectException(ProjectException.PROJET_WBS_WRITER);
            }
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FProjectID,FTrackNumberID,FMaterialID,FBaseQty,FAuditTime,FStorageOrgUnitID FROM ");
        sql.append(tempTableName);
        StringBuffer subsql = new StringBuffer();
        subsql.append("SELECT FID,FQty,FBaseQty,FTotalQty,FTotalBaseQty FROM T_MM_ProjectTask").append(" WHERE FPROJECTID=? AND FCarNumberID=? AND FMaterialID=? AND FStorageOrgUnitID=? ").append(" AND FTaskTypeID=?").append(" AND FActualBeginTime IS NOT NULL").append(" AND FBaseStatus=").append(5);
        if (bizAction == 103) {
            subsql.append(" AND FBaseQty > FTotalBaseQty ");
            subsql.append(" ORDER BY FActualBeginTime,FSeq ASC");
        } else {
            subsql.append(" ORDER BY FActualBeginTime,FSeq DESC");
        }
        StringBuffer taskUpdateQtySQL = new StringBuffer();
        taskUpdateQtySQL.append("UPDATE T_MM_ProjectTask as t0 ");
        taskUpdateQtySQL.append(" SET FTotalQty=FTotalQty ");
        taskUpdateQtySQL.append(bizAction == 103 ? "+" : "-");
        taskUpdateQtySQL.append(" (select round(decimal(? / t1.FBaseConvsRate,21,8),t2.FQtyPrecision) ");
        taskUpdateQtySQL.append(" from t_bd_multimeasureunit t1 , t_bd_multimeasureunit t2 where t0.FMaterialID = t1.FMaterialID and t0.FUnitID = t1.fmeasureunitid ");
        taskUpdateQtySQL.append(" and t0.FMaterialID = t2.FMaterialID and t0.FBaseUnitID = t2.fmeasureunitid ");
        taskUpdateQtySQL.append(") ,FTotalBaseQty=FTotalBaseQty ");
        taskUpdateQtySQL.append(bizAction == 103 ? "+" : "-");
        taskUpdateQtySQL.append(" ? , FCompletePercent=((FTotalBaseQty ").append(bizAction == 103 ? "+" : "-").append("?)/FBaseQty)*100  WHERE FID=?  AND FFeedbackModeID='8RJ1z1oESdOXmsnCpkmCeppMH64=' ");
        StringBuffer taskUpdateEndTimeSQL = new StringBuffer();
        taskUpdateEndTimeSQL.append("UPDATE T_MM_ProjectTask SET FTotalQty=? ,FTotalBaseQty=? ,FActualEndTime=?  , FCompletePercent=(?/FBaseQty)*100 WHERE FID=?  AND FFeedbackModeID='8RJ1z1oESdOXmsnCpkmCeppMH64='");
        Connection conn = null;
        PreparedStatement batchStatement = null;
        PreparedStatement updateStatement = null;
        conn = this.getConnection(ctx);
        ArrayList<String> entryIdList = new ArrayList<String>();
        try {
            batchStatement = conn.prepareStatement(taskUpdateEndTimeSQL.toString());
            updateStatement = conn.prepareStatement(taskUpdateQtySQL.toString());
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            block8: while (true) {
                BigDecimal baseQty;
                IRowSet taskRowSet;
                BigDecimal bizBaseQty;
                block25: {
                    Timestamp auditTime;
                    block26: {
                        block24: {
                            block23: {
                                if (!rowSet.next()) break block23;
                                String project = rowSet.getString("FProjectID");
                                String trackNumber = rowSet.getString("FTrackNumberID");
                                String material = rowSet.getString("FMaterialID");
                                bizBaseQty = rowSet.getBigDecimal("FBaseQty");
                                auditTime = rowSet.getTimestamp("FAuditTime");
                                String FStorageOrgUnitID = rowSet.getString("FStorageOrgUnitID");
                                if (project == null || trackNumber == null) break block24;
                                taskRowSet = DbUtil.executeQuery((Context)ctx, (String)subsql.toString(), (Object[])new Object[]{project, trackNumber, material, FStorageOrgUnitID, taskType == WBSTypeEnum.PURCHASE ? "AyKjxAUlS9KdlMIjwVdddZpMH64=" : "uxqG1JcyTNKWqD8KTZatKppMH64="});
                                if (bizAction != 103) break block25;
                                break block26;
                            }
                            batchStatement.executeBatch();
                            ProjectTaskControllerBean projectTaskBean = new ProjectTaskControllerBean();
                            if (entryIdList.size() != 0) {
                                BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[entryIdList.size()];
                                int n = entryIdList.size();
                                for (int i = 0; i < n; ++i) {
                                    entries[i] = new BatchExecuteParamsEntry(new Class[]{String.class}, new Object[]{entryIdList.get(i)});
                                }
                                if (bizAction == 103) {
                                    projectTaskBean.batchClose(ctx, entries);
                                } else {
                                    projectTaskBean.batchUnAudit(ctx, entries);
                                }
                            }
                            SQLUtils.cleanup((Statement)updateStatement, (Connection)conn);
                            SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
                            return;
                        }
                        SQLUtils.cleanup((Statement)updateStatement, (Connection)conn);
                        SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
                        return;
                    }
                    while (true) {
                        if (!taskRowSet.next()) continue block8;
                        baseQty = taskRowSet.getBigDecimal("FBaseQty");
                        BigDecimal qty = taskRowSet.getBigDecimal("FQty");
                        BigDecimal totalBaseQty = taskRowSet.getBigDecimal("FTotalBaseQty");
                        String taskID = taskRowSet.getString("FID");
                        if (baseQty.compareTo(bizBaseQty.add(totalBaseQty)) > 0) {
                            updateStatement.setBigDecimal(1, bizBaseQty);
                            updateStatement.setBigDecimal(2, bizBaseQty);
                            updateStatement.setBigDecimal(3, bizBaseQty);
                            updateStatement.setString(4, taskID);
                            updateStatement.executeUpdate();
                            continue block8;
                        }
                        bizBaseQty = bizBaseQty.add(totalBaseQty).subtract(baseQty);
                        batchStatement.setBigDecimal(1, qty);
                        batchStatement.setBigDecimal(2, baseQty);
                        batchStatement.setTimestamp(3, auditTime);
                        batchStatement.setBigDecimal(4, baseQty);
                        batchStatement.setString(5, taskID);
                        entryIdList.add(taskID);
                        batchStatement.addBatch();
                    }
                }
                while (true) {
                    if (!taskRowSet.next()) continue block8;
                    baseQty = taskRowSet.getBigDecimal("FBaseQty");
                    BigDecimal totalBaseQty = taskRowSet.getBigDecimal("FTotalBaseQty");
                    String taskID = taskRowSet.getString("FID");
                    if (bizBaseQty.compareTo(totalBaseQty) < 0) {
                        updateStatement.setBigDecimal(1, bizBaseQty);
                        updateStatement.setBigDecimal(2, bizBaseQty);
                        updateStatement.setBigDecimal(3, bizBaseQty);
                        updateStatement.setString(4, taskID);
                        if (baseQty.compareTo(totalBaseQty) == 0) {
                            entryIdList.add(taskID);
                        }
                        updateStatement.executeUpdate();
                        continue block8;
                    }
                    bizBaseQty = bizBaseQty.subtract(totalBaseQty);
                    batchStatement.setBigDecimal(1, new BigDecimal("0"));
                    batchStatement.setBigDecimal(2, new BigDecimal("0"));
                    batchStatement.setTimestamp(3, null);
                    batchStatement.setBigDecimal(4, new BigDecimal("0"));
                    batchStatement.setString(5, taskID);
                    entryIdList.add(taskID);
                    batchStatement.addBatch();
                }
                break;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(updateStatement, (Connection)conn);
                SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
                throw throwable;
            }
        }
    }

    @Override
    protected void _batchWriteBackByDate(Context ctx, String tempTableName, int bizAction, WBSTypeEnum taskType) throws BOSException, EASBizException {
        if (bizAction == 103) {
            StringBuffer sql = new StringBuffer();
            StringBuffer subSql = new StringBuffer();
            subSql.append("SELECT min(temp.FBizDate) FROM ");
            subSql.append(tempTableName + " temp");
            subSql.append(" WHERE temp.FPROJECTID=T_MM_ProjectTask.FPROJECTID");
            subSql.append(" AND temp.FMaterialID=T_MM_ProjectTask.FMaterialID");
            subSql.append(" AND temp.FStorageOrgUnitID=T_MM_ProjectTask.FStorageOrgUnitID");
            subSql.append(" AND (temp.FTrackNumberID is null and T_MM_ProjectTask.FCarNumberID is null or temp.FTrackNumberID=T_MM_ProjectTask.FCarNumberID)");
            sql.append("UPDATE T_MM_ProjectTask SET FActualBeginTime=( ");
            sql.append(subSql);
            sql.append(") WHERE EXISTS(");
            sql.append(subSql);
            sql.append(") AND FFeedbackModeID='8RJ1z1oESdOXmsnCpkmCeppMH64='  AND FTaskTypeID = ?");
            sql.append(" AND FBaseStatus = ");
            sql.append(5);
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{taskType == WBSTypeEnum.PURCHASE ? "AyKjxAUlS9KdlMIjwVdddZpMH64=" : "uxqG1JcyTNKWqD8KTZatKppMH64="});
        }
    }
}

