/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.project.IProjectCalendarFacade;
import com.kingdee.eas.mm.project.ProjectCalendarFacadeFactory;
import com.kingdee.eas.mm.project.WBSException;
import com.kingdee.eas.mm.project.util.MMProjectCalendar;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

public class MMProjectCalendarFactory {
    private Context ctx;
    private String projectID;
    private HashMap workdateMap;
    private ArrayList workdateList;
    private HashMap freedateMap;

    public MMProjectCalendarFactory(Context ctx, String projectId) {
        this.ctx = ctx;
        this.projectID = projectId;
    }

    private MMProjectCalendar getProjectCalendar(Date theDate) throws BOSException, EASBizException {
        return this.getProjectCalendar(theDate, true);
    }

    private MMProjectCalendar getProjectCalendar(Date theDate, boolean isPost) throws BOSException, EASBizException {
        int seq;
        this.buildData();
        Calendar calendar = this.toCalendar(theDate);
        if (this.workdateMap != null && this.workdateMap.size() > 0) {
            Object objSeq = this.workdateMap.get(calendar.getTime());
            seq = 0;
            if (objSeq != null) {
                seq = (Integer)objSeq;
                if (this.workdateList.size() >= seq) {
                    MMProjectCalendar mmCalendar = (MMProjectCalendar)this.workdateList.get(seq - 1);
                    return mmCalendar;
                }
            }
        }
        if (this.freedateMap != null && this.freedateMap.size() > 0) {
            Object objFreeDate = null;
            objFreeDate = this.freedateMap.get(calendar.getTime());
            seq = 0;
            if (objFreeDate != null) {
                MMProjectCalendar freeDate = objFreeDate;
                seq = isPost ? freeDate.getNextSeq() : freeDate.getPreSeq();
                if (this.workdateList.size() >= seq) {
                    MMProjectCalendar mmCalendar = (MMProjectCalendar)this.workdateList.get(seq - 1);
                    return mmCalendar;
                }
            }
        }
        MMProjectCalendar firstDate = this.getFirstWorkdate();
        MMProjectCalendar lastDate = this.getLastWorkdate();
        if (calendar.after(lastDate.getWorkDate())) {
            return lastDate;
        }
        return firstDate;
    }

    public void changeOrg(String projectID) {
        this.projectID = projectID;
        this.workdateMap = null;
        this.workdateList = null;
        this.freedateMap = null;
    }

    public boolean isWorkDay(Date theDate) throws EASBizException, BOSException {
        this.buildData();
        Calendar calendar = this.toCalendar(theDate);
        if (this.workdateMap != null && this.workdateMap.size() > 0) {
            Object objSeq = this.workdateMap.get(calendar.getTime());
            int seq = 0;
            if (objSeq != null) {
                seq = (Integer)objSeq;
                if (this.workdateList.size() >= seq) {
                    return true;
                }
            }
        }
        if (this.freedateMap != null && this.freedateMap.size() > 0) {
            Object objFreeDate = null;
            objFreeDate = this.freedateMap.get(calendar.getTime());
            if (objFreeDate != null) {
                return false;
            }
        }
        return false;
    }

    public Date getWorkdate(Date theDate) throws BOSException, EASBizException {
        if (theDate == null) {
            return null;
        }
        return this.getProjectCalendar(theDate).getWorkDate().getTime();
    }

    public Date getWorkdate2(Date theDate, boolean isPost) throws BOSException, EASBizException {
        return this.getProjectCalendar(theDate, isPost).getWorkDate().getTime();
    }

    public int getLeadtime(Date dateFrom, Date dateTo) throws BOSException, EASBizException {
        MMProjectCalendar mmDateFrom = this.getProjectCalendar(dateFrom);
        MMProjectCalendar mmDateTo = this.getProjectCalendar(dateTo);
        return Math.abs(mmDateFrom.getSeq() - mmDateTo.getSeq());
    }

    public int getLeadtime2(Date dateFrom, Date dateTo) throws BOSException, EASBizException {
        MMProjectCalendar mmDateFrom = this.getProjectCalendar(dateFrom);
        MMProjectCalendar mmDateTo = this.getProjectCalendar(dateTo);
        return mmDateTo.getSeq() - mmDateFrom.getSeq();
    }

    public int getLeadtime3(Date dateFrom, Date dateTo, int iteratorType) throws BOSException, EASBizException {
        int iteravel = this.getLeadtime2(dateFrom, dateTo);
        switch (iteratorType) {
            case 0: {
                break;
            }
            case 1: {
                --iteravel;
                break;
            }
            case -1: {
                ++iteravel;
            }
        }
        return iteravel;
    }

    public int getWorklength(Date dateFrom, Date dateTo) throws BOSException, EASBizException {
        return this.getLeadtime(dateFrom, dateTo) + 1;
    }

    public int getWorklength2(Date dateFrom, Date dateTo) throws BOSException, EASBizException {
        MMProjectCalendar mmDateFrom = this.getProjectCalendar(dateFrom, true);
        MMProjectCalendar mmDateTo = this.getProjectCalendar(dateTo, false);
        return Math.abs(mmDateFrom.getSeq() - mmDateTo.getSeq()) + 1;
    }

    public Date addWroklength(Date dateFrom, int length) throws BOSException, EASBizException {
        int sign = 1;
        if (length != 0) {
            sign = length / Math.abs(length);
        }
        int newLength = (Math.abs(length) - 1) * sign;
        return this.addLeadtime(dateFrom, newLength);
    }

    public Date addLeadtime(Date dateFrom, int leadTime) throws BOSException, EASBizException {
        MMProjectCalendar mmDateFrom = this.getProjectCalendar(dateFrom);
        int seq = mmDateFrom.getSeq() + leadTime;
        if (this.workdateList.size() > seq && seq > 0) {
            return ((MMProjectCalendar)this.workdateList.get(seq - 1)).getWorkDate().getTime();
        }
        throw new WBSException(WBSException.FACTORYCANLENDAR_OUTOFBOUNDS);
    }

    public Date addLeadtime2(Date dateFrom, int leadTime) throws BOSException, EASBizException {
        return this.addLeadtime(dateFrom, leadTime + 1);
    }

    public Date addLeadtime3(Date dateFrom, int leadTime) throws BOSException, EASBizException {
        return this.addLeadtime(dateFrom, leadTime - 1);
    }

    public Date addLeadtime4(Date dateFrom, int leadTime, int iteratorType) throws BOSException, EASBizException {
        Date result = null;
        switch (iteratorType) {
            case 0: {
                result = this.addLeadtime(dateFrom, leadTime);
                break;
            }
            case 1: {
                result = this.addLeadtime2(dateFrom, leadTime);
                break;
            }
            case -1: {
                result = this.addLeadtime3(dateFrom, leadTime);
            }
        }
        return result;
    }

    public Calendar toCalendar(Date theDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(theDate);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public void buildData() throws BOSException, EASBizException {
        if (this.workdateList != null) {
            return;
        }
        this.workdateMap = new HashMap();
        this.workdateList = new ArrayList();
        this.freedateMap = new HashMap();
        IProjectCalendarFacade iProjectCalendar = null;
        iProjectCalendar = this.ctx == null ? ProjectCalendarFacadeFactory.getRemoteInstance() : ProjectCalendarFacadeFactory.getLocalInstance(this.ctx);
        try {
            ArrayList projectCalendar = iProjectCalendar.getProjectCalendars(this.projectID);
            for (int i = 0; i < projectCalendar.size(); ++i) {
                MMProjectCalendar mmCalendar = (MMProjectCalendar)projectCalendar.get(i);
                Date mmDate = this.toCalendar(mmCalendar.getWorkDate().getTime()).getTime();
                if (mmCalendar.getSeq() != 0) {
                    this.workdateMap.put(mmDate, new Integer(mmCalendar.getSeq()));
                    this.workdateList.add(mmCalendar);
                    continue;
                }
                this.freedateMap.put(mmDate, mmCalendar);
            }
        }
        catch (EASBizException e) {
            this.workdateMap = null;
            this.workdateList = null;
            this.freedateMap = null;
            throw e;
        }
    }

    public MMProjectCalendar getFirstWorkdate() throws BOSException, EASBizException {
        this.buildData();
        return (MMProjectCalendar)this.workdateList.get(0);
    }

    public MMProjectCalendar getLastWorkdate() throws BOSException, EASBizException {
        this.buildData();
        return (MMProjectCalendar)this.workdateList.get(this.workdateList.size() - 1);
    }

    public String getProjectId() {
        return this.projectID;
    }
}

