/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.framework.DataBaseDAssignCollection;
import com.kingdee.eas.basedata.framework.DataBaseDAssignFactory;
import com.kingdee.eas.basedata.ncm.AllocStdTypeEnum;
import com.kingdee.eas.basedata.ncm.AllocStdUnitFactory;
import com.kingdee.eas.basedata.ncm.AllocStdUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.IStrategy;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerCCO.EoPWIPQtyStrategy;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerCCO.FinishedQtyStrategy;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerCCO.HourStrategy;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerOverHead.AssistantAmountStrategy;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerOverHead.AssistantPricesStrategy;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.DirectMatQtyStrategy;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.EquivalentCoefStrategy;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.InputQtyStrategy;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.MaterialRateStrategy;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.UnitStandardHourStrategy;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.UserDefinedAllocByResCostItemStrategy;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.UserDefined_D_Strategy;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerWIP.AsFinishedQtyStrategy;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerWIP.BoPWIPQtyAdjustStrategy;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerWIP.BoPWIPQtyStrategy;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerWIP.NotCalcWIPStrategy;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerWIP.UserDefinedStrategy;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.AllocTable;
import com.kingdee.eas.ncm.bill.app.Alloc.helper.AllocUtils;
import com.kingdee.eas.ncm.common.utils.NCMCommonParams;
import com.kingdee.eas.ncm.common.utils.NCMCommonParamsAdapter;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.Assert;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class AUSContext {
    private static Logger logger = Logger.getLogger((String)AUSContext.class.getName());
    protected Map _param = null;
    protected NCMCommonParams _ncmCommonParam;
    protected String _formula = null;
    protected AllocTable _allocTable;
    protected String tblObjectRange = null;
    protected String tblValidObjectRange = null;
    protected String tblAllocData = null;
    protected String tblResultTable = null;
    protected AllocStdTypeEnum _allocStdType = null;
    protected Map _strategyCache = null;
    private Map isCostObjectLevelMap = new HashMap();

    public AUSContext(Map param) {
        this._param = param;
        Assert.that((boolean)param.containsKey("allocStdType"));
        this._allocStdType = (AllocStdTypeEnum)param.get("allocStdType");
        this._ncmCommonParam = NCMCommonParamsAdapter.build((Map)param);
    }

    public AUSContext(NCMCommonParams param) {
        this._ncmCommonParam = param;
        Assert.that((boolean)param.containsKey("allocStdType"));
        this._allocStdType = param.getALLOC_STD_TYPE();
    }

    public void setAllocStdType(AllocStdTypeEnum allocStdType) {
        this._allocStdType = allocStdType;
    }

    public void setStrategyContext(String formula, AllocTable allocTable) throws AllocateException {
        Assert.that((formula != null ? 1 : 0) != 0);
        Assert.that((allocTable != null ? 1 : 0) != 0);
        this._formula = formula;
        this._allocTable = allocTable;
        this._param.put("TblMatRateData", this._allocTable.GetMaterialRateDataTable());
        this._param.put("TblValidMatRateData", this._allocTable.GetValidMaterialRateDataTable());
        this._ncmCommonParam.setTBL_MATRATE_DATA(this._allocTable.GetMaterialRateDataTable());
        this.setTblObjectRange(this._allocTable.GetObjectRangeTable());
        this.setTblValidObjectRange(this._allocTable.GetValidObjectRangeTable());
        this._param.put("TblObjectRange", this.getTblObjectRange());
        this._param.put("TblValidObjectRange", this.getTblValidObjectRange());
        String createFieldList = this.GetFieldListForCreateTbl();
        this.setTblAllocData(this._allocTable.GetAllocDataTable(createFieldList));
        this._param.put("TblAllocData", this.getTblAllocData());
        this._ncmCommonParam.setTBL_ALLOC_DATA(this.getTblAllocData());
        this._param.put("hourStrategyTbl", this._allocTable.getHourStrategyTbl());
    }

    public String GetAllocStdUnitDataSql() throws AllocateException {
        Assert.that((this._formula != null ? 1 : 0) != 0);
        String[] factors = this.SplitFormula(this._formula);
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < factors.length; ++i) {
            IStrategy s = this.GetStrategyByFactor(factors[i]);
            b.append(s.GetAllocStdDataSql()).append(";");
        }
        return b.toString();
    }

    public String GetAllocStdFormulaUpdateSql() throws AllocateException {
        Assert.that((this._formula != null ? 1 : 0) != 0);
        String formula = this.parseFormula(this._formula);
        String sql = null;
        if (this._allocStdType.equals((Object)AllocStdTypeEnum.WIPSTD) || this._allocStdType.equals((Object)AllocStdTypeEnum.CLASSI)) {
            sql = "UPDATE " + this.tblAllocData + " SET FRatio = (" + formula + ") ";
        } else if (this._allocStdType.equals((Object)AllocStdTypeEnum.INNERPRD)) {
            sql = "UPDATE " + this.tblAllocData + " SET FQty = (" + formula + ") ";
        } else if (this._allocStdType.equals((Object)AllocStdTypeEnum.INNERCC)) {
            sql = "UPDATE " + this.tblAllocData + " SET FQty = (" + formula + ") ";
        } else if (this._allocStdType.equals((Object)AllocStdTypeEnum.AUX)) {
            sql = "UPDATE " + this.tblAllocData + " SET FQty = (" + formula + ") ";
        } else if (this._allocStdType.equals((Object)AllocStdTypeEnum.DYN_INNERPRD)) {
            sql = "UPDATE " + this.tblAllocData + " SET FQty = (" + formula + ") ";
        }
        return sql;
    }

    public boolean isCostObjectLevelForCCAlloc() throws AllocateException {
        boolean ifCostObjectLevel = false;
        String[] factors = this.SplitFormula(this._formula);
        for (int i = 0; i < factors.length; ++i) {
            ifCostObjectLevel = ifCostObjectLevel || this.getIsCostObjectLevel(factors[i]);
        }
        return ifCostObjectLevel;
    }

    public String[] getColumns() throws AllocateException {
        String[] factors = this.SplitFormula(this._formula);
        String[] columns = new String[factors.length];
        for (int i = 0; i < factors.length; ++i) {
            columns[i] = this.GetFldFlag(factors[i]);
        }
        return columns;
    }

    public String[] GetNoAllocStdDataHint() throws AllocateException {
        Assert.that((this._formula != null ? 1 : 0) != 0);
        String[] retHint = new String[2];
        Context ctx = this._ncmCommonParam.getCTX();
        retHint[0] = AllocUtils.getAllocResource(ctx, "NoData_Hint_0");
        retHint[1] = AllocUtils.getAllocResource(ctx, "NoData_Hint_1");
        String[] factors = this.SplitFormula(this._formula);
        String[] unitHint = null;
        for (int i = 0; i < factors.length; ++i) {
            IStrategy s = this.GetStrategyByFactor(factors[i]);
            unitHint = s instanceof com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.HourStrategy || s instanceof com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerWIP.HourStrategy || s instanceof HourStrategy ? new String[]{AllocUtils.getAllocResource(ctx, factors[i]), AllocUtils.getAllocResource(ctx, "NoData_Hint_Hour_1")} : s.GetNoAllocStdDataHint();
            String sep = i == 0 ? "" : "\u3001";
            if (!retHint[0].contains(unitHint[0])) {
                retHint[0] = retHint[0] + sep + unitHint[0];
            }
            if (retHint[1].contains(unitHint[1])) continue;
            retHint[1] = retHint[1] + sep + unitHint[1];
        }
        return retHint;
    }

    public String GetFieldListForCreateTbl() throws AllocateException {
        Assert.that((this._formula != null ? 1 : 0) != 0);
        return this.GetMergeFormatStr("{0} NUMERIC(24,10) Default(0)", ",");
    }

    public String GetFieldListForQuery() throws AllocateException {
        Assert.that((this._formula != null ? 1 : 0) != 0);
        return this.GetMergeFormatStr("{0}", ",");
    }

    public String GetMergeFormatStr(String format, String separator) throws AllocateException {
        Assert.that((this._formula != null ? 1 : 0) != 0);
        if (separator == null) {
            separator = ",";
        }
        String[] factors = this.SplitFormula(this._formula);
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < factors.length; ++i) {
            String fildFlag = this.GetFldFlag(factors[i]);
            String item = MessageFormat.format(format, fildFlag);
            b.append(item).append(separator);
        }
        return b.toString();
    }

    private String GetFldFlag(String factor) throws AllocateException {
        IStrategy s = this.GetStrategyByFactor(factor);
        if (factor.equalsIgnoreCase("R7RYVfZajUyhuMxXZbnRtZ3UGuM=")) {
            return "F5130";
        }
        if (factor.equalsIgnoreCase("mXnhTEHTbEOJwMGIvqwBUJ3UGuM=")) {
            return "F5140";
        }
        if (factor.equalsIgnoreCase("hF5b7q6i+EK+JxAVcDrC1p3UGuM=")) {
            return "F5150";
        }
        if (factor.equalsIgnoreCase("avWra7GTk0ieaVZnfx1vGp3UGuM=")) {
            return "F5160";
        }
        if (factor.equalsIgnoreCase("pqfESLJ7y0uJaMGO3/0LmJ3UGuM=")) {
            return "F5170";
        }
        if (factor.equalsIgnoreCase("B3UjmMmO4UKBD50i+WMYoZ3UGuM=")) {
            return "F5180";
        }
        if (factor.equalsIgnoreCase("fnF9c2pkSNGSG59XheeFw53UGuM=")) {
            return "F5185";
        }
        if (factor.equalsIgnoreCase("Q4PwrSBmRxmj8oTRNemMMZ3UGuM=")) {
            return "F5186";
        }
        if (factor.equalsIgnoreCase("vrNL8ObtQRyPZFFz5FjgSJ3UGuM=")) {
            return "F5187";
        }
        if (factor.equalsIgnoreCase("rrBzL4UyikChQkkkDeUfOZ3UGuM=")) {
            return "F5230";
        }
        if (factor.equalsIgnoreCase("1BtaeWTWO0GqvPeyTR8wlZ3UGuM=")) {
            return "F5240";
        }
        if (factor.equalsIgnoreCase("xRVe+zOOW02En0LThhKGpZ3UGuM=")) {
            return "F5250";
        }
        if (factor.equalsIgnoreCase("LeaUZ/DID02pWgeQQ3SVep3UGuM=")) {
            return "F5260";
        }
        if (factor.equalsIgnoreCase("rbZQcotqVEC3y5R1huodIZ3UGuM=")) {
            return "F5270";
        }
        if (factor.equalsIgnoreCase("KdKGUtWMYU2Ly3gwKmrm/53UGuM=")) {
            return "F5280";
        }
        if (factor.equalsIgnoreCase("Slx8keqNTmmVZHhM0PMxH53UGuM=")) {
            return "F5285";
        }
        if (factor.equalsIgnoreCase("z0LvJtqTTqCP8jVhfjyAFp3UGuM=")) {
            return "F5286";
        }
        if (factor.equalsIgnoreCase("3SnZiJ8VRcCEorOplCyeOp3UGuM=")) {
            return "F5287";
        }
        if (factor.equalsIgnoreCase("0fM3wowOtEaT5v0sBDd5153UGuM=")) {
            return "F5330";
        }
        if (factor.equalsIgnoreCase("ksnowdTQP0Kn9kG6okfG553UGuM=")) {
            return "F5340";
        }
        if (factor.equalsIgnoreCase("zspO7+rF2065wonKbClk3Z3UGuM=")) {
            return "F5350";
        }
        if (factor.equalsIgnoreCase("1PJdGt8SNEGSREPPtDm+P53UGuM=")) {
            return "F5360";
        }
        if (factor.equalsIgnoreCase("5u46laO2q0CDyGcpPKxMgJ3UGuM=")) {
            return "F5370";
        }
        if (factor.equalsIgnoreCase("16HIPkaMBEeZwDw14nlGOJ3UGuM=")) {
            return "F5380";
        }
        if (s != null) {
            return s.GetFieldFlag();
        }
        return null;
    }

    public Map GetFactor_FldFlagMapping(String formula) throws AllocateException {
        String[] list = this.SplitFormula(formula);
        HashMap<String, String> ret = new HashMap<String, String>();
        for (int i = 0; i < list.length; ++i) {
            String factor = list[i].toString();
            ret.put(factor, this.GetFldFlag(factor));
        }
        return ret;
    }

    private String parseFormula(String formula) throws AllocateException {
        String retFormula = formula;
        String[] factors = this.SplitFormula(formula);
        for (int i = 0; i < factors.length; ++i) {
            String factor = factors[i].toString();
            String factorReg = "~#" + factor + "~@";
            factorReg = factorReg.replaceAll("\\+", "\\\\+");
            retFormula = retFormula.replaceAll(factorReg, this.GetFldFlag(factor));
        }
        return this.dealWithDivisor(retFormula);
    }

    private String dealWithDivisor(String originalStr) {
        StringBuffer finalSb = new StringBuffer();
        StringBuffer returnSb = new StringBuffer();
        if (originalStr.indexOf("/") != -1) {
            originalStr = this.delThePlace(originalStr);
            int division = originalStr.indexOf("/");
            int next = division + 1;
            finalSb.append("TO_DECIMAL(" + originalStr.substring(0, next - 1) + ",24,13)");
            finalSb.append("/");
            int subEnd = 0;
            String divisoinStr = null;
            if (originalStr.substring(next, next + 1).equals("(")) {
                subEnd = this.getSubEnd(originalStr, next + 1);
                divisoinStr = this.dealWithDivisor(originalStr.substring(next, subEnd));
            } else {
                subEnd = this.getSignExsitNo(originalStr, next);
                divisoinStr = subEnd == -1 ? originalStr.substring(next) : originalStr.substring(next, subEnd);
            }
            finalSb.append("TO_DECIMAL(" + divisoinStr + ",21,8)");
            if (subEnd > 0) {
                String restStr = this.dealWithDivisor(originalStr.substring(subEnd));
                finalSb.append(restStr);
            }
            returnSb.append(" case when ").append(divisoinStr).append(" = 0 then 0 else ").append(finalSb).append(" end ");
        } else if (originalStr.length() > 0) {
            return originalStr;
        }
        return returnSb.toString();
    }

    private String delThePlace(String originalStr) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < originalStr.length(); ++i) {
            if (" ".equals(originalStr.substring(i, i + 1))) continue;
            sb.append(originalStr.substring(i, i + 1));
        }
        return sb.toString();
    }

    private int getSubEnd(String originalStr, int subStart) {
        int subEnd = subStart;
        int loss = 1;
        for (int i = subStart; i < originalStr.length(); ++i) {
            if (originalStr.substring(i, i + 1).equals(")")) {
                --loss;
            }
            if (originalStr.substring(i, i + 1).equals("(")) {
                ++loss;
            }
            if (loss != 0) continue;
            subEnd = i + 1;
            break;
        }
        return subEnd;
    }

    private int getSignExsitNo(String finalFormula, int next) {
        int signNo = -1;
        for (int i = next; i < finalFormula.length(); ++i) {
            if (!finalFormula.substring(i, i + 1).equals("+") && !finalFormula.substring(i, i + 1).equals("-") && !finalFormula.substring(i, i + 1).equals("*") && !finalFormula.substring(i, i + 1).equals("/")) continue;
            signNo = i;
            break;
        }
        return signNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected IStrategy GetStrategyByFactor(String factor) throws AllocateException {
        IStrategy ret;
        block33: {
            Context ctx;
            block64: {
                block77: {
                    block76: {
                        block75: {
                            block74: {
                                block73: {
                                    block72: {
                                        block71: {
                                            block70: {
                                                block69: {
                                                    block68: {
                                                        block67: {
                                                            block66: {
                                                                block65: {
                                                                    block53: {
                                                                        block63: {
                                                                            block62: {
                                                                                block61: {
                                                                                    block60: {
                                                                                        block59: {
                                                                                            block58: {
                                                                                                block57: {
                                                                                                    block56: {
                                                                                                        block55: {
                                                                                                            block54: {
                                                                                                                block34: {
                                                                                                                    block52: {
                                                                                                                        block51: {
                                                                                                                            block50: {
                                                                                                                                block49: {
                                                                                                                                    block48: {
                                                                                                                                        block47: {
                                                                                                                                            block46: {
                                                                                                                                                block45: {
                                                                                                                                                    block44: {
                                                                                                                                                        block43: {
                                                                                                                                                            block42: {
                                                                                                                                                                block41: {
                                                                                                                                                                    block40: {
                                                                                                                                                                        block39: {
                                                                                                                                                                            block38: {
                                                                                                                                                                                block37: {
                                                                                                                                                                                    block36: {
                                                                                                                                                                                        block35: {
                                                                                                                                                                                            Assert.that((this._param != null ? 1 : 0) != 0);
                                                                                                                                                                                            Assert.that((this.getTblObjectRange() != null ? 1 : 0) != 0);
                                                                                                                                                                                            ctx = (Context)this._param.get("ctx");
                                                                                                                                                                                            this._param.put("TblObjectRange", this.getTblObjectRange());
                                                                                                                                                                                            this._ncmCommonParam.setTBL_OBJECT_RANGE(this.getTblObjectRange());
                                                                                                                                                                                            if (this._strategyCache == null) {
                                                                                                                                                                                                Class<AUSContext> clazz = AUSContext.class;
                                                                                                                                                                                                // MONITORENTER : com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.AUSContext.class
                                                                                                                                                                                                this._strategyCache = Collections.synchronizedMap(new HashMap());
                                                                                                                                                                                                // MONITOREXIT : clazz
                                                                                                                                                                                            }
                                                                                                                                                                                            if (this._strategyCache.containsKey(factor)) {
                                                                                                                                                                                                ret = (IStrategy)this._strategyCache.get(factor);
                                                                                                                                                                                                ret.set_tblObjectRange(this.getTblObjectRange());
                                                                                                                                                                                                return ret;
                                                                                                                                                                                            }
                                                                                                                                                                                            ret = null;
                                                                                                                                                                                            if (!this._allocStdType.equals((Object)AllocStdTypeEnum.INNERPRD)) break block34;
                                                                                                                                                                                            if (!"d2T+lgEaEADgAAlAwKgRj53UGuM=".equals(factor)) break block35;
                                                                                                                                                                                            ret = new InputQtyStrategy(this._param);
                                                                                                                                                                                            break block33;
                                                                                                                                                                                        }
                                                                                                                                                                                        if (!"mWHdWlFpQkmnaFS+vqOZEp3UGuM=".equals(factor)) break block36;
                                                                                                                                                                                        ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.BoPWIPQtyAdjustStrategy(this._param);
                                                                                                                                                                                        break block33;
                                                                                                                                                                                    }
                                                                                                                                                                                    if (!"d2T+lgEaEADgAAkYwKgRj53UGuM=".equals(factor)) break block37;
                                                                                                                                                                                    ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.BoPWIPQtyStrategy(this._param);
                                                                                                                                                                                    break block33;
                                                                                                                                                                                }
                                                                                                                                                                                if (!"d2T+lgEaEADgAAl5wKgRj53UGuM=".equals(factor)) break block38;
                                                                                                                                                                                ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.FinishedQtyStrategy(this._param);
                                                                                                                                                                                break block33;
                                                                                                                                                                            }
                                                                                                                                                                            if (!"d2T+lgEaEADgAAl+wKgRj53UGuM=".equals(factor)) break block39;
                                                                                                                                                                            ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.EoPWIPQtyStrategy(this._param);
                                                                                                                                                                            break block33;
                                                                                                                                                                        }
                                                                                                                                                                        if (!"d2T+lgEaEADgAAmXwKgRj53UGuM=".equals(factor)) break block40;
                                                                                                                                                                        this._param.put("hourType", "7");
                                                                                                                                                                        this._param.put("factor", factor);
                                                                                                                                                                        ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.HourStrategy(this._param);
                                                                                                                                                                        break block33;
                                                                                                                                                                    }
                                                                                                                                                                    if (!"rrBzL4UyikChQkkkDeUfOZ3UGuM=".equals(factor)) break block41;
                                                                                                                                                                    this._param.put("hourType", "1");
                                                                                                                                                                    this._param.put("factor", factor);
                                                                                                                                                                    ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.HourStrategy(this._param);
                                                                                                                                                                    break block33;
                                                                                                                                                                }
                                                                                                                                                                if (!"1BtaeWTWO0GqvPeyTR8wlZ3UGuM=".equals(factor)) break block42;
                                                                                                                                                                this._param.put("hourType", "2");
                                                                                                                                                                this._param.put("factor", factor);
                                                                                                                                                                ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.HourStrategy(this._param);
                                                                                                                                                                break block33;
                                                                                                                                                            }
                                                                                                                                                            if (!"xRVe+zOOW02En0LThhKGpZ3UGuM=".equals(factor)) break block43;
                                                                                                                                                            this._param.put("hourType", "3");
                                                                                                                                                            this._param.put("factor", factor);
                                                                                                                                                            ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.HourStrategy(this._param);
                                                                                                                                                            break block33;
                                                                                                                                                        }
                                                                                                                                                        if (!"LeaUZ/DID02pWgeQQ3SVep3UGuM=".equals(factor)) break block44;
                                                                                                                                                        this._param.put("hourType", "4");
                                                                                                                                                        this._param.put("factor", factor);
                                                                                                                                                        ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.HourStrategy(this._param);
                                                                                                                                                        break block33;
                                                                                                                                                    }
                                                                                                                                                    if (!"rbZQcotqVEC3y5R1huodIZ3UGuM=".equals(factor)) break block45;
                                                                                                                                                    this._param.put("hourType", "5");
                                                                                                                                                    this._param.put("factor", factor);
                                                                                                                                                    ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.HourStrategy(this._param);
                                                                                                                                                    break block33;
                                                                                                                                                }
                                                                                                                                                if (!"KdKGUtWMYU2Ly3gwKmrm/53UGuM=".equals(factor)) break block46;
                                                                                                                                                this._param.put("hourType", "6");
                                                                                                                                                this._param.put("factor", factor);
                                                                                                                                                ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.HourStrategy(this._param);
                                                                                                                                                break block33;
                                                                                                                                            }
                                                                                                                                            if (!"Slx8keqNTmmVZHhM0PMxH53UGuM=".equals(factor)) break block47;
                                                                                                                                            this._param.put("hourType", "8");
                                                                                                                                            this._param.put("factor", factor);
                                                                                                                                            ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.HourStrategy(this._param);
                                                                                                                                            break block33;
                                                                                                                                        }
                                                                                                                                        if (!"z0LvJtqTTqCP8jVhfjyAFp3UGuM=".equals(factor)) break block48;
                                                                                                                                        this._param.put("hourType", "9");
                                                                                                                                        this._param.put("factor", factor);
                                                                                                                                        ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.HourStrategy(this._param);
                                                                                                                                        break block33;
                                                                                                                                    }
                                                                                                                                    if (!"d2T+lgEaEADgAAmCwKgRj53UGuM=".equals(factor)) break block49;
                                                                                                                                    ret = new MaterialRateStrategy(this._param);
                                                                                                                                    break block33;
                                                                                                                                }
                                                                                                                                if (!"3SnZiJ8VRcCEorOplCyeOp3UGuM=".equals(factor)) break block50;
                                                                                                                                ret = new EquivalentCoefStrategy(this._param);
                                                                                                                                break block33;
                                                                                                                            }
                                                                                                                            if (!"wSCGfwEgEADgABg2wKgSMp3UGuM=".equals(factor)) break block51;
                                                                                                                            ret = new DirectMatQtyStrategy(this._param);
                                                                                                                            break block33;
                                                                                                                        }
                                                                                                                        if (!"/ETLIPe3QZ2l/VRF/OAtwp3UGuM=".equals(factor)) break block52;
                                                                                                                        ret = new UnitStandardHourStrategy(this._param);
                                                                                                                        break block33;
                                                                                                                    }
                                                                                                                    AllocStdUnitInfo allocStdUnit = this.getAllocStdUnitByFactor(factor);
                                                                                                                    if (allocStdUnit.isIsByCU()) {
                                                                                                                        ret = new UserDefined_D_Strategy(this._param, factor);
                                                                                                                        break block33;
                                                                                                                    } else if (allocStdUnit.isIsAllocByResCostItem()) {
                                                                                                                        this.checkCostItem(allocStdUnit.getResCostItem());
                                                                                                                        ret = new UserDefinedAllocByResCostItemStrategy(this._param, this.getTblResultTable(), allocStdUnit.getNumber(), allocStdUnit.getResCostItem().getId().toString());
                                                                                                                        break block33;
                                                                                                                    } else {
                                                                                                                        ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.UserDefinedStrategy(this._param, factor);
                                                                                                                    }
                                                                                                                    break block33;
                                                                                                                }
                                                                                                                if (!this._allocStdType.equals((Object)AllocStdTypeEnum.WIPSTD)) break block53;
                                                                                                                if (!"d2T+lgEaEADgAAoiwKgRj53UGuM=".equals(factor)) break block54;
                                                                                                                ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerWIP.InputQtyStrategy(this._param);
                                                                                                                break block33;
                                                                                                            }
                                                                                                            if (!"NX0VB5PDdEu9JjKP5BcjFJ3UGuM=".equals(factor)) break block55;
                                                                                                            ret = new BoPWIPQtyAdjustStrategy(this._param);
                                                                                                            break block33;
                                                                                                        }
                                                                                                        if (!"d2T+lgEaEADgAAodwKgRj53UGuM=".equals(factor)) break block56;
                                                                                                        ret = new BoPWIPQtyStrategy(this._param);
                                                                                                        break block33;
                                                                                                    }
                                                                                                    if (!"d2T+lgEaEADgAAomwKgRj53UGuM=".equals(factor)) break block57;
                                                                                                    ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerWIP.FinishedQtyStrategy(this._param);
                                                                                                    break block33;
                                                                                                }
                                                                                                if (!"d2T+lgEaEADgAAoqwKgRj53UGuM=".equals(factor)) break block58;
                                                                                                ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerWIP.EoPWIPQtyStrategy(this._param);
                                                                                                break block33;
                                                                                            }
                                                                                            if (!"d2T+lgEaEADgAAoxwKgRj53UGuM=".equals(factor)) break block59;
                                                                                            this._param.put("hourType", "7");
                                                                                            this._param.put("factor", factor);
                                                                                            ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerWIP.HourStrategy(this._param);
                                                                                            break block33;
                                                                                        }
                                                                                        if (!"0fM3wowOtEaT5v0sBDd5153UGuM=".equals(factor)) break block60;
                                                                                        this._param.put("hourType", "1");
                                                                                        this._param.put("factor", factor);
                                                                                        ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.HourStrategy(this._param);
                                                                                        break block33;
                                                                                    }
                                                                                    if (!"ksnowdTQP0Kn9kG6okfG553UGuM=".equals(factor)) break block61;
                                                                                    this._param.put("hourType", "2");
                                                                                    this._param.put("factor", factor);
                                                                                    ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.HourStrategy(this._param);
                                                                                    break block33;
                                                                                }
                                                                                if (!"zspO7+rF2065wonKbClk3Z3UGuM=".equals(factor)) break block62;
                                                                                this._param.put("hourType", "3");
                                                                                this._param.put("factor", factor);
                                                                                ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.HourStrategy(this._param);
                                                                                break block33;
                                                                            }
                                                                            if (!"1PJdGt8SNEGSREPPtDm+P53UGuM=".equals(factor)) break block63;
                                                                            this._param.put("hourType", "4");
                                                                            this._param.put("factor", factor);
                                                                            ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.HourStrategy(this._param);
                                                                            break block33;
                                                                        }
                                                                        if ("5u46laO2q0CDyGcpPKxMgJ3UGuM=".equals(factor)) {
                                                                            this._param.put("hourType", "5");
                                                                            this._param.put("factor", factor);
                                                                            ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.HourStrategy(this._param);
                                                                            break block33;
                                                                        } else if ("16HIPkaMBEeZwDw14nlGOJ3UGuM=".equals(factor)) {
                                                                            this._param.put("hourType", "6");
                                                                            this._param.put("factor", factor);
                                                                            ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.HourStrategy(this._param);
                                                                            break block33;
                                                                        } else {
                                                                            ret = "d2T+lgEaEADgAAovwKgRj53UGuM=".equals(factor) ? new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerWIP.EquivalentCoefStrategy(this._param) : ("d2T+lgEaEADgAAobwKgRj53UGuM=".equals(factor) ? new AsFinishedQtyStrategy(this._param) : ("d2T+lgEaEADgAAoawKgRj53UGuM=".equals(factor) ? new NotCalcWIPStrategy(this._param) : new UserDefinedStrategy(this._param, factor)));
                                                                        }
                                                                        break block33;
                                                                    }
                                                                    if (!this._allocStdType.equals((Object)AllocStdTypeEnum.INNERCC)) break block64;
                                                                    if (!"dvtbCAEaEADgAArMwKgRj53UGuM=".equals(factor)) break block65;
                                                                    ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerCCO.InputQtyStrategy(this._param);
                                                                    break block33;
                                                                }
                                                                if (!"dvtbCAEaEADgAAqwwKgRj53UGuM=".equals(factor)) break block66;
                                                                ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerCCO.BoPWIPQtyStrategy(this._param);
                                                                break block33;
                                                            }
                                                            if (!"dvtbCAEaEADgAArRwKgRj53UGuM=".equals(factor)) break block67;
                                                            ret = new FinishedQtyStrategy(this._param);
                                                            break block33;
                                                        }
                                                        if (!"dvtbCAEaEADgAArVwKgRj53UGuM=".equals(factor)) break block68;
                                                        ret = new EoPWIPQtyStrategy(this._param);
                                                        break block33;
                                                    }
                                                    if (!"dvtbCAEaEADgAArawKgRj53UGuM=".equals(factor)) break block69;
                                                    this._param.put("hourType", "7");
                                                    this._param.put("factor", factor);
                                                    ret = new HourStrategy(this._param);
                                                    break block33;
                                                }
                                                if (!"R7RYVfZajUyhuMxXZbnRtZ3UGuM=".equals(factor)) break block70;
                                                this._param.put("hourType", "1");
                                                this._param.put("factor", factor);
                                                ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.HourStrategy(this._param);
                                                break block33;
                                            }
                                            if (!"mXnhTEHTbEOJwMGIvqwBUJ3UGuM=".equals(factor)) break block71;
                                            this._param.put("hourType", "2");
                                            this._param.put("factor", factor);
                                            ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.HourStrategy(this._param);
                                            break block33;
                                        }
                                        if (!"hF5b7q6i+EK+JxAVcDrC1p3UGuM=".equals(factor)) break block72;
                                        this._param.put("hourType", "3");
                                        this._param.put("factor", factor);
                                        ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.HourStrategy(this._param);
                                        break block33;
                                    }
                                    if (!"avWra7GTk0ieaVZnfx1vGp3UGuM=".equals(factor)) break block73;
                                    this._param.put("hourType", "4");
                                    this._param.put("factor", factor);
                                    ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.HourStrategy(this._param);
                                    break block33;
                                }
                                if (!"pqfESLJ7y0uJaMGO3/0LmJ3UGuM=".equals(factor)) break block74;
                                this._param.put("hourType", "5");
                                this._param.put("factor", factor);
                                ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.HourStrategy(this._param);
                                break block33;
                            }
                            if (!"B3UjmMmO4UKBD50i+WMYoZ3UGuM=".equals(factor)) break block75;
                            this._param.put("hourType", "6");
                            this._param.put("factor", factor);
                            ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.HourStrategy(this._param);
                            break block33;
                        }
                        if (!"fnF9c2pkSNGSG59XheeFw53UGuM=".equals(factor)) break block76;
                        this._param.put("hourType", "8");
                        this._param.put("factor", factor);
                        ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.HourStrategy(this._param);
                        break block33;
                    }
                    if (!"Q4PwrSBmRxmj8oTRNemMMZ3UGuM=".equals(factor)) break block77;
                    this._param.put("hourType", "9");
                    this._param.put("factor", factor);
                    ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.HourStrategy(this._param);
                    break block33;
                }
                if ("vrNL8ObtQRyPZFFz5FjgSJ3UGuM=".equals(factor)) {
                    ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerCCO.EquivalentCoefStrategy(this._param);
                    break block33;
                } else if ("1gu6hOFLQuiyGb00BTOJzJ3UGuM=".equals(factor)) {
                    ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerCCO.UnitStandardHourStrategy(this._param);
                    break block33;
                } else {
                    AllocStdUnitInfo allocStdUnit = this.getAllocStdUnitByFactor(factor);
                    boolean isToCenter = allocStdUnit.isIsToCenter();
                    if (allocStdUnit.isIsAllocByResCostItem()) {
                        this.checkCostItem(allocStdUnit.getResCostItem());
                        ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerCCO.UserDefinedAllocByResCostItemStrategy(this._param, this.getTblResultTable(), allocStdUnit.getNumber(), allocStdUnit.getResCostItem().getId().toString(), isToCenter);
                    } else {
                        ret = new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerCCO.UserDefinedStrategy(this._param, factor, isToCenter);
                    }
                    this.isCostObjectLevelMap.put(factor, new Boolean(!isToCenter));
                }
                break block33;
            }
            if (this._allocStdType.equals((Object)AllocStdTypeEnum.AUX)) {
                ret = "V/AvLEEZStSevMvDzAMTbp3UGuM=".equals(factor) ? new AssistantAmountStrategy(this._param) : ("QAuKFIfxSz2ZKEpGeh8dX53UGuM=".equals(factor) ? new AssistantPricesStrategy(this._param) : new com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerOverHead.UserDefinedStrategy(this._param, factor));
            } else if (this._allocStdType.equals((Object)AllocStdTypeEnum.DYN_INNERPRD)) {
                if ("d2T+lgEaEADgAAlAwKgRj53UGuM=".equals(factor)) {
                    throw new AllocateException(AllocateException.ITEM_ALLOC_DYN_NOT_SUPPORT, new IllegalArgumentException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"0_AUSContext", (Locale)ctx.getLocale())));
                }
                if ("mWHdWlFpQkmnaFS+vqOZEp3UGuM=".equals(factor)) {
                    throw new AllocateException(AllocateException.ITEM_ALLOC_DYN_NOT_SUPPORT, new IllegalArgumentException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"1_AUSContext", (Locale)ctx.getLocale())));
                }
                if ("d2T+lgEaEADgAAkYwKgRj53UGuM=".equals(factor)) {
                    throw new AllocateException(AllocateException.ITEM_ALLOC_DYN_NOT_SUPPORT, new IllegalArgumentException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"2_AUSContext", (Locale)ctx.getLocale())));
                }
                if ("d2T+lgEaEADgAAl5wKgRj53UGuM=".equals(factor)) {
                    ret = new com.kingdee.eas.ncm.dynamic.bill.app.Alloc.AllcoUnitStrategy.InnerProd.FinishedQtyStrategy(this._param);
                } else {
                    if ("d2T+lgEaEADgAAl+wKgRj53UGuM=".equals(factor)) {
                        throw new AllocateException(AllocateException.ITEM_ALLOC_DYN_NOT_SUPPORT, new IllegalArgumentException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"3_AUSContext", (Locale)ctx.getLocale())));
                    }
                    if ("d2T+lgEaEADgAAmXwKgRj53UGuM=".equals(factor)) {
                        ret = new com.kingdee.eas.ncm.dynamic.bill.app.Alloc.AllcoUnitStrategy.InnerProd.HourStrategy(this._param);
                    } else if ("d2T+lgEaEADgAAmCwKgRj53UGuM=".equals(factor)) {
                        ret = new MaterialRateStrategy(this._param);
                    } else {
                        if ("wSCGfwEgEADgABg2wKgSMp3UGuM=".equals(factor)) {
                            throw new AllocateException(AllocateException.ITEM_ALLOC_DYN_NOT_SUPPORT, new IllegalArgumentException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"4_AUSContext", (Locale)ctx.getLocale())));
                        }
                        if ("/ETLIPe3QZ2l/VRF/OAtwp3UGuM=".equals(factor)) {
                            throw new AllocateException(AllocateException.ITEM_ALLOC_DYN_NOT_SUPPORT, new IllegalArgumentException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"5_AUSContext", (Locale)ctx.getLocale())));
                        }
                        ret = new com.kingdee.eas.ncm.dynamic.bill.app.Alloc.AllcoUnitStrategy.InnerProd.UserDefinedStrategy(this._param, factor);
                    }
                }
            }
        }
        this._strategyCache.put(factor, ret);
        return ret;
    }

    private boolean getIsCostObjectLevel(String factor) {
        boolean isCostObjectLevel = false;
        isCostObjectLevel = this.isCostObjectLevelMap.get(factor) != null ? (Boolean)this.isCostObjectLevelMap.get(factor) : true;
        return isCostObjectLevel;
    }

    public String getTblAllocData() {
        return this.tblAllocData;
    }

    public void setTblAllocData(String tblAllocData) {
        this.tblAllocData = tblAllocData;
    }

    public String getTblObjectRange() {
        return this.tblObjectRange;
    }

    public void setTblObjectRange(String tblObjectRange) {
        this.tblObjectRange = tblObjectRange;
    }

    public String getTblValidObjectRange() {
        return this.tblValidObjectRange;
    }

    public void setTblValidObjectRange(String tblValidObjectRange) {
        this.tblValidObjectRange = tblValidObjectRange;
    }

    public String getTblResultTable() throws AllocateException {
        if (this.tblResultTable == null) {
            try {
                this.tblResultTable = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)((Context)this._param.get("ctx")), (String)this._param.get("companyId").toString(), (String)"T_NCM_MatAllocResult");
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
                throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
                throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
            }
        }
        return this.tblResultTable;
    }

    private String[] SplitFormula(String formula) {
        if (formula == null) {
            return null;
        }
        String delim = "~#";
        String[] list = formula.split(delim);
        int count = list.length;
        String[] retArr = new String[count];
        int index = 0;
        int pos = -1;
        boolean hasRec = false;
        for (int i = 0; i < count; ++i) {
            String item = list[i];
            pos = item.indexOf("~@");
            if (pos == -1) continue;
            item = item.substring(0, pos);
            hasRec = false;
            for (int j = 0; j < count; ++j) {
                if (item == null || !item.equals(retArr[j])) continue;
                hasRec = true;
                break;
            }
            if (hasRec) continue;
            retArr[index++] = item;
        }
        if (index < count) {
            String[] retNewArr = new String[index];
            System.arraycopy(retArr, 0, retNewArr, 0, index);
            return retNewArr;
        }
        return retArr;
    }

    protected boolean isByCU_UserDefined(String factor) throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)factor, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isByCU", (Object)"1", CompareType.EQUALS));
        try {
            return AllocStdUnitFactory.getLocalInstance((Context)ctx).exists(filter);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
    }

    protected AllocStdUnitInfo getAllocStdUnitByFactor(String factor) throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        try {
            return AllocStdUnitFactory.getLocalInstance((Context)ctx).getAllocStdUnitInfo((IObjectPK)new ObjectUuidPK(factor), this.getSelectors());
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("resCostItem.*"));
        return sic;
    }

    private void checkCostItem(CostItemInfo resCostItem) throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        String CUId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        String costItemCUId = resCostItem.getCU().getId().toString();
        String bosType = "548C5A91";
        String costItemId = resCostItem.getId().toString();
        try {
            if (!AUSContext.isDataBaseDPermission(ctx, CUId, costItemCUId, bosType, costItemId)) {
                throw new AllocateException(AllocateException.ITEM_ALLOC_COSTITEMVALID, new Object[]{resCostItem.getNumber() + "\uff0c" + resCostItem.getName()});
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
    }

    public static boolean isDataBaseDPermission(Context ctx, String thisCUId, String compareCUId, String bosType, String checkDataId) throws BOSException {
        return AUSContext.isAdminData(thisCUId, compareCUId) || AUSContext.isAssignedDataBaseDId(ctx, bosType, thisCUId, checkDataId);
    }

    public static boolean isAdminData(String thisCUId, String compareCUId) {
        return thisCUId.equals(compareCUId);
    }

    public static boolean isAssignedDataBaseDId(Context ctx, String bosObjectType, String assignCUId, String dataBaseDID) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bosObjectType", (Object)bosObjectType));
        filter.getFilterItems().add(new FilterItemInfo("assignCU", (Object)assignCUId));
        filter.getFilterItems().add(new FilterItemInfo("dataBaseDID", (Object)dataBaseDID));
        view.setFilter(filter);
        DataBaseDAssignCollection coll = DataBaseDAssignFactory.getLocalInstance((Context)ctx).getDataBaseDAssignCollection(view);
        return coll != null && coll.size() > 0;
    }
}

