/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.Alloc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.ncm.AllocStdTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.ncm.bill.AllocTypeEnum;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.AUSContext;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Allocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.AutoCostAdjustAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.AutoMatAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.AutoOtherAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.AutoOtherInWHAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.ManuCostAdjustAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.ManuMatAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.ManuOtherAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.ManuOtherInWHAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.MatAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.MatReqAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.AllocTable;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.WizMatAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.WizOtherAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.BatchAllocIterator.AutoMatBatchAllocIterator;
import com.kingdee.eas.ncm.bill.app.Alloc.BatchAllocIterator.AutoOtherBatchAllocIterator;
import com.kingdee.eas.ncm.bill.app.Alloc.BatchAllocIterator.IBatchAllocIterator;
import com.kingdee.eas.ncm.bill.app.Alloc.BatchAllocIterator.ManuMatBatchAllocIterator;
import com.kingdee.eas.ncm.bill.app.Alloc.BatchAllocIterator.ManuOtherBatchAllocIterator;
import com.kingdee.eas.ncm.bill.app.Alloc.BatchAllocIterator.WizMatBatchAllocIterator;
import com.kingdee.eas.ncm.bill.app.Alloc.BatchAllocIterator.WizOtherBatchAllocIterator;
import com.kingdee.eas.ncm.bill.app.Alloc.helper.AllocateExceptionLog;
import com.kingdee.eas.ncm.bill.app.AuxFeeAlloc.AuxAUSContext;
import com.kingdee.eas.ncm.bill.app.AuxFeeAlloc.AuxAllocator;
import com.kingdee.eas.ncm.bill.app.CostDataCache;
import com.kingdee.eas.ncm.common.AllocSourceBillEnum;
import com.kingdee.eas.ncm.common.AllocStdSetModeByPrdEnum;
import com.kingdee.eas.ncm.common.task.CostTaskEntryInfo;
import com.kingdee.eas.ncm.common.task.CostTaskResultEnum;
import com.kingdee.eas.ncm.common.task.CostTaskStatusEnum;
import com.kingdee.eas.ncm.common.task.CostTaskUtils;
import com.kingdee.eas.ncm.common.task.app.CostTaskExecutor;
import com.kingdee.eas.ncm.common.utils.NCMConst;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.Assert;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class AllocDispatch {
    private static final Logger log = Logger.getLogger((String)"com.kingdee.eas.ncm.bill.app.Alloc.AllocDispatchLog");
    private static final String RES_CLASSNAME = "com.kingdee.eas.ncm.bill.task.AllocResource";
    protected Map _param;
    private Allocator allocator;
    private AllocateExceptionLog _logger;
    private String companyId;
    private String periodId;
    private String userId;
    protected AllocTypeEnum allocType;
    private AllocSourceBillEnum allocSourceBill;
    protected FilterInfo filterInfo;
    private boolean isMat = false;
    private Map costTaskEntryMap = null;
    private Integer typeSeq = 1;
    private CostDataCache costDataCache = null;

    public AllocDispatch(Map param) {
        Assert.that((boolean)param.containsKey("companyId"));
        Assert.that((boolean)param.containsKey("periodId"));
        Assert.that((boolean)param.containsKey("userId"));
        Assert.that((boolean)param.containsKey("allocType"));
        Assert.that((boolean)param.containsKey("filterInfo"));
        Assert.that((boolean)param.containsKey("isMat"));
        this._param = param;
        Context ctx = (Context)this._param.get("ctx");
        this.companyId = param.get("companyId").toString();
        this.periodId = param.get("periodId").toString();
        this.userId = param.get("userId").toString();
        this.allocType = (AllocTypeEnum)((Object)param.get("allocType"));
        this.filterInfo = (FilterInfo)param.get("filterInfo");
        if (String.valueOf(true).equals(param.get("isMat"))) {
            this.isMat = true;
        }
        this._param.put("allocStdType", AllocStdTypeEnum.INNERPRD);
        this.allocSourceBill = (AllocSourceBillEnum)param.get("allocSourceBill");
        AllocStdSetModeByPrdEnum allocenum = null;
        try {
            allocenum = NCMUtils.getAllocStdSetModeByPrd((Context)ctx, (String)this.companyId);
            this._param.put("allocenum", allocenum);
            this._param.put("shareCostObjectId", this.getShareCostObjectId(ctx, this.companyId));
        }
        catch (BOSException e) {
            log.error((Object)e.getMessage());
        }
        if (!this._param.containsKey("CostDataCache")) {
            this.costDataCache = new CostDataCache(this._param);
            this._param.put("CostDataCache", this.costDataCache);
        }
        this.costTaskEntryMap = new HashMap();
        Object value = param.get("typeSeq");
        if (value instanceof Integer) {
            this.typeSeq = (Integer)value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map DoAllocate() throws Exception {
        Context ctx = (Context)this._param.get("ctx");
        AUSContext ausCtx = new AUSContext(this._param);
        this.allocator = this.CreateAllocator(ausCtx);
        this.allocator.GetFeeDataControl();
        AllocTable allocTable = this.allocator.getAllocTable();
        this._param.put("allocTable", allocTable);
        IBatchAllocIterator iterator = this.CreateBatchAllocIterator(this.allocator);
        boolean hasFeeData = true;
        Map<String, String> ret = new HashMap<String, String>();
        try {
            this.updateCostCalEntryRunning(ctx, "allocStepSum");
            try {
                this.allocator.buildTargetBillEntryID();
                hasFeeData = this.allocator.GetFeeDataControl().hasTargetBillEntryID() > 0;
            }
            catch (Exception e) {
                this.updateCostCalEntryFinished(ctx, "allocStepSum", CostTaskResultEnum.FAILURE);
                AllocateException ae = new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
                this._logger.AddLog(ae);
                log.error((Object)"", (Throwable)e);
                throw ae;
            }
            this.updateCostCalEntryFinished(ctx, "allocStepSum");
            this.updateCostCalEntryRunning(ctx, "allocStepCheck");
            try {
                CostTaskResultEnum result = CostTaskResultEnum.SUCCESS;
                if (hasFeeData) {
                    result = this.allocator.preCheck();
                }
                this.updateCostCalEntryFinished(ctx, "allocStepCheck", result);
                if (result.getValue() >= 7) {
                    ret = new HashMap();
                    ret.put("HasError", String.valueOf(true));
                    HashMap<String, String> ae = ret;
                    return ae;
                }
            }
            catch (Exception e) {
                this.updateCostCalEntryFinished(ctx, "allocStepCheck", CostTaskResultEnum.FAILURE);
                AllocateException ae = new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
                this._logger.AddLog(ae);
                log.error((Object)"", (Throwable)e);
                throw ae;
            }
            this.updateCostCalEntryRunning(ctx, "allocStepClear");
            try {
                if (hasFeeData) {
                    this.allocator.clearPreAllocResult();
                }
            }
            catch (Exception e) {
                this.updateCostCalEntryFinished(ctx, "allocStepClear", CostTaskResultEnum.FAILURE);
                AllocateException ae = new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
                this._logger.AddLog(ae);
                log.error((Object)"", (Throwable)e);
                throw ae;
            }
            this.updateCostCalEntryFinished(ctx, "allocStepClear");
            this.updateCostCalEntryRunning(ctx, "allocStepUnallocated");
            try {
                if (hasFeeData) {
                    this.allocator.resetAllocFlagToUnallocated();
                }
            }
            catch (Exception e) {
                this.updateCostCalEntryFinished(ctx, "allocStepUnallocated", CostTaskResultEnum.FAILURE);
                AllocateException ae = new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
                this._logger.AddLog(ae);
                log.error((Object)"", (Throwable)e);
                throw ae;
            }
            this.updateCostCalEntryFinished(ctx, "allocStepUnallocated");
            this.updateCostCalEntryRunning(ctx, "allocStepRange");
            try {
                if (hasFeeData) {
                    this.allocator.fillAllocObjectRange();
                }
            }
            catch (Exception e) {
                this.updateCostCalEntryFinished(ctx, "allocStepRange", CostTaskResultEnum.FAILURE);
                AllocateException ae = new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
                this._logger.AddLog(ae);
                log.error((Object)"", (Throwable)e);
                throw ae;
            }
            this.updateCostCalEntryFinished(ctx, "allocStepRange");
            this.updateCostCalEntryRunning(ctx, "allocStepPre");
            try {
                if (hasFeeData) {
                    this.allocator.preProcess();
                }
            }
            catch (Exception e) {
                this.updateCostCalEntryFinished(ctx, "allocStepPre", CostTaskResultEnum.FAILURE);
                AllocateException ae = new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
                this._logger.AddLog(ae);
                log.error((Object)"", (Throwable)e);
                throw ae;
            }
            this.updateCostCalEntryFinished(ctx, "allocStepPre");
            this.updateCostCalEntryRunning(ctx, "allocStepDirect");
            if (hasFeeData) {
                this.allocator.allocDirect();
            }
            this.updateCostCalEntryFinished(ctx, "allocStepDirect");
            this.updateCostCalEntryRunning(ctx, "allocStepFetch");
            try {
                if (hasFeeData) {
                    iterator.initData();
                }
            }
            catch (Exception e) {
                this.updateCostCalEntryFinished(ctx, "allocStepFetch", CostTaskResultEnum.FAILURE);
                AllocateException ae = new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
                this._logger.AddLog(ae);
                log.error((Object)"", (Throwable)e);
                throw ae;
            }
            this.updateCostCalEntryFinished(ctx, "allocStepFetch");
            int batchCount = iterator.getBatchCount();
            int count = 0;
            CostTaskEntryInfo entry = (CostTaskEntryInfo)this.costTaskEntryMap.get("allocStepIndirect");
            if (entry != null) {
                entry.setProgressInfo(count + "/" + batchCount);
            }
            this.updateCostCalEntryRunning(ctx, "allocStepIndirect");
            if (hasFeeData) {
                iterator.FirstBatch();
                while (!iterator.IsDone()) {
                    iterator.AllocateCurrBatch();
                    if (++count % 50 == 0 && entry != null) {
                        entry.setProgressInfo(count + "/" + batchCount);
                        this.updateCostCalEntry(ctx, "allocStepIndirect", null, null, -1L, -1L);
                    }
                    iterator.NextBatch();
                }
            }
            if (count % 50 != 0 && entry != null) {
                entry.setProgressInfo(count + "/" + batchCount);
            }
            this.updateCostCalEntryFinished(ctx, "allocStepIndirect");
            try {
                this.updateCostCalEntryRunning(ctx, "allocStepResult");
                if (hasFeeData) {
                    this.allocator.commitAllocResult(true);
                    ret = this.allocator.processResult();
                }
                this.updateCostCalEntryFinished(ctx, "allocStepResult");
            }
            catch (Exception e) {
                this.updateCostCalEntryFinished(ctx, "allocStepResult", CostTaskResultEnum.EXCEPTION);
                throw e;
            }
        }
        finally {
            Exception ex;
            block58: {
                block57: {
                    block56: {
                        ex = null;
                        try {
                            this.allocator.updateAllocFlagToAllocated();
                        }
                        catch (Exception e) {
                            AllocateException ae = new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
                            this._logger.AddLog(ae);
                            log.error((Object)"", (Throwable)e);
                            if (ex != null) break block56;
                            ex = e;
                        }
                    }
                    try {
                        this.allocator.endProcess();
                    }
                    catch (Exception e) {
                        if (ex != null) break block57;
                        ex = e;
                    }
                }
                try {
                    if (this.costDataCache != null) {
                        this.costDataCache.release();
                    }
                }
                catch (Exception e) {
                    if (ex != null) break block58;
                    ex = e;
                }
            }
            if (ex != null) {
                throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, ex);
            }
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)ctx.get((Object)OrgType.Company);
            boolean isSuccessed = false;
            if (this._logger == null || this._logger.getLogCount() == 0) {
                isSuccessed = true;
            }
            NCMUtils.addEASLogForAlloc((Context)ctx, (String)"DoAllocate", (String)(company.getNumber() + ' ' + company.getName()), (AllocSourceBillEnum)this.allocSourceBill, (AllocTypeEnum)this.allocType, (String)this.companyId, (boolean)isSuccessed);
        }
        return ret;
    }

    private Allocator CreateAllocator(AUSContext ausCtx) {
        Allocator alloc = null;
        if (this.isMat) {
            alloc = "OtherInWarehs".equals(this._param.get("matType")) ? this.createOtherInWarehsAllocator(ausCtx) : ("CostAdjust".equals(this._param.get("matType")) ? this.createCostAdjustAllocator(ausCtx) : this.createManufactureRecAllocator(ausCtx));
        } else {
            switch (this.allocType.getValue()) {
                case 2: {
                    this._param.put("logTblName", "T_NCM_LOG_Other");
                    if (this._logger == null || this._logger.getLogCount() <= 0) {
                        this._logger = new AllocateExceptionLog(this._param);
                        this._param.put("logger", this._logger);
                    }
                    alloc = new AutoOtherAllocator(this._param, ausCtx);
                    break;
                }
                case 1: {
                    alloc = new ManuOtherAllocator(this._param, ausCtx);
                    break;
                }
                case 3: {
                    this._param.put("logTblName", "T_NCM_LOG_Other");
                    if (this._logger == null || this._logger.getLogCount() <= 0) {
                        this._logger = new AllocateExceptionLog(this._param);
                        this._param.put("logger", this._logger);
                    }
                    alloc = new WizOtherAllocator(this._param, ausCtx);
                }
            }
        }
        if (this.allocSourceBill != null && 5 == this.allocSourceBill.getValue()) {
            alloc = new AuxAllocator(this._param, new AuxAUSContext(this._param));
        }
        return alloc;
    }

    private Allocator createOtherInWarehsAllocator(AUSContext ausCtx) {
        MatAllocator alloc = null;
        switch (this.allocType.getValue()) {
            case 2: {
                this._param.put("logTblName", "T_NCM_LOG_OtherInWH");
                this._logger = new AllocateExceptionLog(this._param);
                this._param.put("logger", this._logger);
                alloc = new AutoOtherInWHAllocator(this._param, ausCtx);
                break;
            }
            case 1: {
                alloc = new ManuOtherInWHAllocator(this._param, ausCtx);
                break;
            }
            case 3: {
                this._param.put("logTblName", "T_NCM_LOG_OtherInWH");
                this._logger = new AllocateExceptionLog(this._param);
                this._param.put("logger", this._logger);
                alloc = new WizMatAllocator(this._param, ausCtx);
            }
        }
        return alloc;
    }

    private Allocator createCostAdjustAllocator(AUSContext ausCtx) {
        MatAllocator alloc = null;
        switch (this.allocType.getValue()) {
            case 2: {
                this._param.put("logTblName", "T_NCM_LOG_CostAdjust");
                this._logger = new AllocateExceptionLog(this._param);
                this._param.put("logger", this._logger);
                alloc = new AutoCostAdjustAllocator(this._param, ausCtx);
                break;
            }
            case 1: {
                alloc = new ManuCostAdjustAllocator(this._param, ausCtx);
                break;
            }
            case 3: {
                this._param.put("logTblName", "T_NCM_LOG_CostAdjust");
                this._logger = new AllocateExceptionLog(this._param);
                this._param.put("logger", this._logger);
                alloc = new WizMatAllocator(this._param, ausCtx);
            }
        }
        return alloc;
    }

    private Allocator createManufactureRecAllocator(AUSContext ausCtx) {
        MatReqAllocator alloc = null;
        switch (this.allocType.getValue()) {
            case 2: {
                this._param.put("logTblName", "T_NCM_LOG_Mat");
                if (this._logger == null || this._logger.getLogCount() <= 0) {
                    this._logger = new AllocateExceptionLog(this._param);
                    this._param.put("logger", this._logger);
                }
                alloc = new AutoMatAllocator(this._param, ausCtx);
                break;
            }
            case 1: {
                alloc = new ManuMatAllocator(this._param, ausCtx);
                break;
            }
            case 3: {
                this._param.put("logTblName", "T_NCM_LOG_Mat");
                if (this._logger == null || this._logger.getLogCount() <= 0) {
                    this._logger = new AllocateExceptionLog(this._param);
                    this._param.put("logger", this._logger);
                }
                alloc = new WizMatAllocator(this._param, ausCtx);
            }
        }
        return alloc;
    }

    private IBatchAllocIterator CreateBatchAllocIterator(Allocator allocatorAdapter) throws AllocateException {
        IBatchAllocIterator alloc = null;
        if (this.isMat) {
            switch (this.allocType.getValue()) {
                case 2: {
                    alloc = new AutoMatBatchAllocIterator(this._param, allocatorAdapter);
                    break;
                }
                case 1: {
                    alloc = new ManuMatBatchAllocIterator(this._param, allocatorAdapter);
                    break;
                }
                case 3: {
                    alloc = new WizMatBatchAllocIterator(this._param, allocatorAdapter);
                }
            }
        } else {
            switch (this.allocType.getValue()) {
                case 2: {
                    alloc = new AutoOtherBatchAllocIterator(this._param, allocatorAdapter);
                    break;
                }
                case 1: {
                    alloc = new ManuOtherBatchAllocIterator(this._param, allocatorAdapter);
                    break;
                }
                case 3: {
                    alloc = new WizOtherBatchAllocIterator(this._param, allocatorAdapter);
                }
            }
        }
        return alloc;
    }

    public AllocTypeEnum getAllocType() {
        return this.allocType;
    }

    public String getCompanyId() {
        return this.companyId;
    }

    public FilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    public String getPeriodId() {
        return this.periodId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Allocator getAllocator() {
        return this.allocator;
    }

    private String getShareCostObjectId(Context ctx, String companyId) throws BOSException {
        String shareCostObjectId = "SCOID";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"SCOID"));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        view.setSelector(selector);
        CostObjectCollection coll = CostObjectFactory.getLocalInstance((Context)ctx).getCostObjectCollection(view);
        if (coll.size() > 0) {
            shareCostObjectId = coll.get(0).getId().toString();
        }
        return shareCostObjectId;
    }

    public LinkedList buildCostTaskEntries() {
        LinkedList<CostTaskEntryInfo> costTaskEntries = new LinkedList<CostTaskEntryInfo>();
        int level = 0;
        Object oLevel = this._param.get("CostTaskLevel");
        if (oLevel != null && oLevel instanceof Integer && (level = ((Integer)oLevel).intValue()) < 0) {
            level = 0;
        }
        ++level;
        int seq = 0;
        CostTaskEntryInfo allocStepSum = new CostTaskEntryInfo();
        this.setCostTaskEntryName(allocStepSum, "allocStepSum");
        allocStepSum.setTypeSeq(this.typeSeq.intValue());
        allocStepSum.setSeq(++seq);
        allocStepSum.setProgress(3);
        allocStepSum.setResult(CostTaskResultEnum.NULL);
        allocStepSum.setLevel(level);
        allocStepSum.setLeaf(true);
        costTaskEntries.add(allocStepSum);
        this.costTaskEntryMap.put("allocStepSum", allocStepSum);
        CostTaskEntryInfo allocStepCheck = new CostTaskEntryInfo();
        this.setCostTaskEntryName(allocStepCheck, "allocStepCheck");
        allocStepCheck.setTypeSeq(this.typeSeq.intValue());
        allocStepCheck.setSeq(++seq);
        allocStepCheck.setProgress(2);
        allocStepCheck.setResult(CostTaskResultEnum.NULL);
        allocStepCheck.setLevel(level);
        allocStepCheck.setLeaf(true);
        costTaskEntries.add(allocStepCheck);
        this.costTaskEntryMap.put("allocStepCheck", allocStepCheck);
        CostTaskEntryInfo allocStepClear = new CostTaskEntryInfo();
        this.setCostTaskEntryName(allocStepClear, "allocStepClear");
        allocStepClear.setTypeSeq(this.typeSeq.intValue());
        allocStepClear.setSeq(++seq);
        allocStepClear.setProgress(3);
        allocStepClear.setResult(CostTaskResultEnum.NULL);
        allocStepClear.setLevel(level);
        allocStepClear.setLeaf(true);
        costTaskEntries.add(allocStepClear);
        this.costTaskEntryMap.put("allocStepClear", allocStepClear);
        CostTaskEntryInfo allocStepUnallocated = new CostTaskEntryInfo();
        this.setCostTaskEntryName(allocStepUnallocated, "allocStepUnallocated");
        allocStepUnallocated.setTypeSeq(this.typeSeq.intValue());
        allocStepUnallocated.setSeq(++seq);
        allocStepUnallocated.setProgress(3);
        allocStepUnallocated.setResult(CostTaskResultEnum.NULL);
        allocStepUnallocated.setLevel(level);
        allocStepUnallocated.setLeaf(true);
        costTaskEntries.add(allocStepUnallocated);
        this.costTaskEntryMap.put("allocStepUnallocated", allocStepUnallocated);
        CostTaskEntryInfo allocStepRange = new CostTaskEntryInfo();
        this.setCostTaskEntryName(allocStepRange, "allocStepRange");
        allocStepRange.setTypeSeq(this.typeSeq.intValue());
        allocStepRange.setSeq(++seq);
        allocStepRange.setProgress(3);
        allocStepRange.setResult(CostTaskResultEnum.NULL);
        allocStepRange.setLevel(level);
        allocStepRange.setLeaf(true);
        costTaskEntries.add(allocStepRange);
        this.costTaskEntryMap.put("allocStepRange", allocStepRange);
        CostTaskEntryInfo allocStepPre = new CostTaskEntryInfo();
        this.setCostTaskEntryName(allocStepPre, "allocStepPre");
        allocStepPre.setTypeSeq(this.typeSeq.intValue());
        allocStepPre.setSeq(++seq);
        allocStepPre.setProgress(2);
        allocStepPre.setResult(CostTaskResultEnum.NULL);
        allocStepPre.setLevel(level);
        allocStepPre.setLeaf(true);
        costTaskEntries.add(allocStepPre);
        this.costTaskEntryMap.put("allocStepPre", allocStepPre);
        CostTaskEntryInfo allocStepDirect = new CostTaskEntryInfo();
        this.setCostTaskEntryName(allocStepDirect, "allocStepDirect");
        allocStepDirect.setTypeSeq(this.typeSeq.intValue());
        allocStepDirect.setSeq(++seq);
        allocStepDirect.setProgress(3);
        allocStepDirect.setResult(CostTaskResultEnum.NULL);
        allocStepDirect.setLevel(level);
        allocStepDirect.setLeaf(true);
        costTaskEntries.add(allocStepDirect);
        this.costTaskEntryMap.put("allocStepDirect", allocStepDirect);
        CostTaskEntryInfo allocStepFetch = new CostTaskEntryInfo();
        this.setCostTaskEntryName(allocStepFetch, "allocStepFetch");
        allocStepFetch.setTypeSeq(this.typeSeq.intValue());
        allocStepFetch.setSeq(++seq);
        allocStepFetch.setProgress(1);
        allocStepFetch.setResult(CostTaskResultEnum.NULL);
        allocStepFetch.setLevel(level);
        allocStepFetch.setLeaf(true);
        costTaskEntries.add(allocStepFetch);
        this.costTaskEntryMap.put("allocStepFetch", allocStepFetch);
        CostTaskEntryInfo allocStepIndirect = new CostTaskEntryInfo();
        this.setCostTaskEntryName(allocStepIndirect, "allocStepIndirect");
        allocStepIndirect.setTypeSeq(this.typeSeq.intValue());
        allocStepIndirect.setSeq(++seq);
        allocStepIndirect.setProgress(4);
        allocStepIndirect.setResult(CostTaskResultEnum.NULL);
        allocStepIndirect.setLevel(level);
        allocStepIndirect.setLeaf(true);
        costTaskEntries.add(allocStepIndirect);
        this.costTaskEntryMap.put("allocStepIndirect", allocStepIndirect);
        CostTaskEntryInfo allocStepResult = new CostTaskEntryInfo();
        this.setCostTaskEntryName(allocStepResult, "allocStepResult");
        allocStepResult.setTypeSeq(this.typeSeq.intValue());
        allocStepResult.setSeq(++seq);
        allocStepResult.setProgress(2);
        allocStepResult.setResult(CostTaskResultEnum.NULL);
        allocStepResult.setLevel(level);
        allocStepResult.setLeaf(true);
        costTaskEntries.add(allocStepResult);
        this.costTaskEntryMap.put("allocStepResult", allocStepResult);
        return costTaskEntries;
    }

    private void setCostTaskEntryName(CostTaskEntryInfo costTaskEntry, String resName) {
        this.setCostTaskEntryName(costTaskEntry, resName, null);
    }

    private void setCostTaskEntryName(CostTaskEntryInfo costTaskEntry, String resName, Object[] params) {
        if (params == null) {
            costTaskEntry.setName(this.getResource(resName, NCMConst.l1), NCMConst.l1);
            costTaskEntry.setName(this.getResource(resName, NCMConst.l2), NCMConst.l2);
            costTaskEntry.setName(this.getResource(resName, NCMConst.l3), NCMConst.l3);
        } else {
            costTaskEntry.setName(this.getResource(resName, NCMConst.l1, params), NCMConst.l1);
            costTaskEntry.setName(this.getResource(resName, NCMConst.l2, params), NCMConst.l2);
            costTaskEntry.setName(this.getResource(resName, NCMConst.l3, params), NCMConst.l3);
        }
    }

    private void updateCostCalEntryRunning(Context ctx, String entryKey) {
        try {
            this.updateCostCalEntry(ctx, entryKey, CostTaskStatusEnum.RUNNING, null, CostTaskUtils.getCurrentTime((Context)ctx), -1L);
        }
        catch (BOSException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void updateCostCalEntryFinished(Context ctx, String entryKey) {
        this.updateCostCalEntryFinished(ctx, entryKey, CostTaskResultEnum.SUCCESS);
    }

    private void updateCostCalEntryFinished(Context ctx, String entryKey, CostTaskResultEnum result) {
        try {
            this.updateCostCalEntry(ctx, entryKey, CostTaskStatusEnum.FINISHED, result, -1L, CostTaskUtils.getCurrentTime((Context)ctx));
        }
        catch (BOSException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void updateCostCalEntry(Context ctx, String entryKey, CostTaskStatusEnum status, CostTaskResultEnum result, long beginTime, long endTime) {
        try {
            CostTaskEntryInfo entry = (CostTaskEntryInfo)this.costTaskEntryMap.get(entryKey);
            CostTaskExecutor executor = (CostTaskExecutor)this._param.get("CostTaskExecutor");
            if (entry != null && executor != null) {
                if (status != null) {
                    entry.setStatus(status);
                }
                if (result != null) {
                    entry.setResult(result);
                }
                if (beginTime > 0L) {
                    entry.setBeginTime(new Timestamp(CostTaskUtils.getCurrentTime((Context)ctx)));
                }
                if (endTime > 0L) {
                    entry.setEndTime(new Timestamp(CostTaskUtils.getCurrentTime((Context)ctx)));
                }
                executor.updateCostTaskEntry(entry);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected String getResource(String resName, Locale locale) {
        return ResourceBase.getString((String)RES_CLASSNAME, (String)resName, (Locale)locale);
    }

    protected String getResource(String resName, Locale locale, Object[] params) {
        String str = ResourceBase.getString((String)RES_CLASSNAME, (String)resName, (Locale)locale);
        if (params != null) {
            str = MessageFormat.format(str, params);
        }
        return str;
    }
}

