/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.ncm.AllocStdInfo;
import com.kingdee.eas.ncm.bill.AllocStdSetByCCOCollection;
import com.kingdee.eas.ncm.bill.AllocStdSetByCCOFactory;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.IAllocStdSetByCCO;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.AUSContext;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.CCOAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.FeeData;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.Info.IFeeInfo;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.AllocTable;
import com.kingdee.eas.ncm.bill.app.Alloc.helper.AllocUtils;
import com.kingdee.eas.ncm.bill.app.Alloc.helper.AllocateExceptionLog;
import com.kingdee.eas.ncm.common.AllocStdSetModeByCCOEnum;
import com.kingdee.eas.ncm.common.task.CostTaskResultEnum;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class AutoCCOAllocator
extends CCOAllocator {
    private static Logger logger = Logger.getLogger((String)AutoCCOAllocator.class.getName());
    private AllocStdSetByCCOCollection allocStdSettingCache = null;
    private AllocateExceptionLog _logger;
    AllocStdSetModeByCCOEnum allocStdSetModeByCCO = null;

    public AutoCCOAllocator(Map param, AUSContext ausCtx) {
        super(param, ausCtx);
        Assert.that((boolean)param.containsKey("logger"));
        this._logger = (AllocateExceptionLog)param.get("logger");
    }

    @Override
    public CostTaskResultEnum preCheck() throws Exception {
        CostTaskResultEnum result = super.preCheck();
        Context ctx = (Context)this._param.get("ctx");
        String companyId = this._param.get("companyId").toString();
        try {
            this.allocStdSetModeByCCO = NCMUtils.getAllocStdSetModeByCCO((Context)ctx, (String)companyId);
        }
        catch (BOSException e) {
            this._logger.AddLog(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e));
            logger.error((Object)"", (Throwable)e);
            result = CostTaskResultEnum.FAILURE;
        }
        return result;
    }

    @Override
    public AllocTable getAllocTable() {
        try {
            return super.getAllocTable();
        }
        catch (AllocateException e) {
            this._logger.AddLog(e);
            logger.error((Object)"", (Throwable)((Object)e));
            return null;
        }
    }

    @Override
    public void preProcess() {
        try {
            super.preProcess();
        }
        catch (AllocateException e) {
            this._logger.AddLog(e);
            logger.error((Object)"", (Throwable)((Object)e));
        }
    }

    @Override
    public AllocStdInfo GetAllocStdSetting(IFeeInfo currFee) {
        AllocStdInfo setting;
        Context ctx = (Context)this._param.get("ctx");
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        if (this.allocStdSettingCache == null) {
            StringBuffer sb = new StringBuffer();
            try {
                IAllocStdSetByCCO fact = AllocStdSetByCCOFactory.getLocalInstance(ctx);
                sb.append("select allocStd.*,expense.*,costCenterGroup.* \n");
                sb.append("where company = '" + companyId + "' \n");
                sb.append("and calculatePeriod = '" + periodId + "' \n");
                sb.append("and allocStd.id is not null \n");
                if (this.allocStdSetModeByCCO.getValue() == "0") {
                    sb.append("and costCenterGroup.id is not null ");
                }
                this.allocStdSettingCache = fact.getAllocStdSetByCCOCollection(sb.toString());
            }
            catch (BOSException e) {
                this._logger.AddLog(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e));
                logger.error((Object)"", (Throwable)e);
            }
        }
        if ((setting = this.GetAllocStdFromCache(currFee)) == null) {
            String possibleReason = AllocUtils.getAllocResource(ctx, "possible_reason_allocStd_notSet");
            String adviceHandle = AllocUtils.getAllocResource(ctx, "advice_handle_allocStd_toSet");
            if (this.allocStdSetModeByCCO.getValue() == "0") {
                this._logger.AddLog("\u8981\u7d20\u8d39\u7528[" + currFee.GetExpenseNumber().concat(" ").concat(currFee.GetExpenseName()) + "]\u6210\u672c\u4e2d\u5fc3\u7ec4[" + currFee.GetCostCenterGroupNumber().concat(" ").concat(currFee.GetCostCenterGroupName()) + "]\u7684\u5206\u914d\u6807\u51c6\u672a\u8bbe\u7f6e\uff01", possibleReason, adviceHandle);
            } else {
                this._logger.AddLog("\u8981\u7d20\u8d39\u7528[" + currFee.GetExpenseNumber().concat(" ").concat(currFee.GetExpenseName()) + "]\u7684\u5206\u914d\u6807\u51c6\u672a\u8bbe\u7f6e\uff01", possibleReason, adviceHandle);
            }
        }
        return setting;
    }

    @Override
    public FeeData GetFeeDataControl() {
        try {
            return super.GetFeeDataControl();
        }
        catch (AllocateException e) {
            this._logger.AddLog(e);
            logger.error((Object)"", (Throwable)((Object)e));
            return null;
        }
    }

    @Override
    public void allocDirect() {
        try {
            super.allocDirect();
        }
        catch (AllocateException e) {
            this._logger.AddLog(e);
            logger.error((Object)"", (Throwable)((Object)e));
        }
    }

    @Override
    public void allocIndirect(IFeeInfo currFee, int position) {
        try {
            super.allocIndirect(currFee, position);
        }
        catch (AllocateException e) {
            this._logger.AddLog(e);
            logger.error((Object)"", (Throwable)((Object)e));
        }
    }

    @Override
    public Map processResult() {
        HashMap<String, String> ret = null;
        try {
            ret = super.processResult();
        }
        catch (AllocateException e) {
            this._logger.AddLog(e);
            logger.error((Object)"", (Throwable)((Object)e));
        }
        if (ret == null) {
            ret = new HashMap<String, String>();
        } else {
            ret.put("HalfAlloc", String.valueOf(true));
        }
        if (this._logger.getLogCount() > 0) {
            IRowSet logData = this._logger.GetLogData();
            ret.put("HasError", String.valueOf(true));
            ret.put("logData", (String)logData);
        }
        return ret;
    }

    @Override
    public void endProcess() {
        try {
            super.endProcess();
        }
        catch (AllocateException e) {
            this._logger.AddLog(e);
            logger.error((Object)"", (Throwable)((Object)e));
        }
    }

    private AllocStdInfo GetAllocStdFromCache(IFeeInfo currFee) {
        String expenseId = null;
        String costCenterGroupId = null;
        for (int i = 0; i < this.allocStdSettingCache.size(); ++i) {
            expenseId = this.allocStdSettingCache.get(i).getExpense().getId().toString();
            if (!currFee.GetExpenseId().equals(expenseId)) continue;
            if (this.allocStdSetModeByCCO.getValue() == "0") {
                costCenterGroupId = this.allocStdSettingCache.get(i).getCostCenterGroup().getId().toString();
                if (!currFee.GetCostCenterGroupId().equals(costCenterGroupId)) continue;
                return this.allocStdSettingCache.get(i).getAllocStd();
            }
            return this.allocStdSettingCache.get(i).getAllocStd();
        }
        return null;
    }

    @Override
    public void processAllocateException(AllocateException e, String possibleReason, String adviceHandle) throws AllocateException {
        if (possibleReason == null || adviceHandle == null) {
            this._logger.AddLog(e);
        } else {
            this._logger.AddLog(e, possibleReason, adviceHandle);
        }
    }
}

