/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.basedata.ncm.AllocStdInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.AllocStdSetByOverheadCollection;
import com.kingdee.eas.ncm.bill.AllocStdSetByOverheadFactory;
import com.kingdee.eas.ncm.bill.AllocStdSetByPrdCollection;
import com.kingdee.eas.ncm.bill.AllocStdSetByPrdFactory;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.IAllocStdSetByOverhead;
import com.kingdee.eas.ncm.bill.IAllocStdSetByPrd;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.AUSContext;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.FeeData;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.Info.IFeeInfo;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.Info.IMatFeeInfo;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.MatReqAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.AllocTable;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.MatAllocTable;
import com.kingdee.eas.ncm.bill.app.Alloc.helper.AllocUtils;
import com.kingdee.eas.ncm.bill.app.Alloc.helper.AllocateExceptionLog;
import com.kingdee.eas.ncm.common.AllocStdSetModeByPrdEnum;
import com.kingdee.eas.ncm.common.task.CostTaskResultEnum;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;

public class AutoMatAllocator
extends MatReqAllocator {
    private static Logger logger = Logger.getLogger((String)AutoMatAllocator.class.getName());
    private AllocateExceptionLog _logger;
    private Map directAllocStdSettingCache = null;
    private Map indirectAllocStdSettingCache = null;
    private Map _tblResultForTempUse = null;
    private Stack<String> tblStack = null;
    AllocStdSetModeByPrdEnum allocStdSetModeByPrd = null;
    private boolean hasClearIndexs = false;

    public AutoMatAllocator(Map param, AUSContext ausCtx) {
        super(param, ausCtx);
        Assert.that((boolean)param.containsKey("logger"));
        this._logger = (AllocateExceptionLog)param.get("logger");
    }

    @Override
    public CostTaskResultEnum preCheck() throws Exception {
        CostTaskResultEnum result = super.preCheck();
        Context ctx = (Context)this._param.get("ctx");
        String companyId = this._param.get("companyId").toString();
        try {
            this.allocStdSetModeByPrd = NCMUtils.getAllocStdSetModeByPrd((Context)ctx, (String)companyId);
        }
        catch (BOSException e) {
            this._logger.AddLog(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e));
            logger.error((Object)"", (Throwable)e);
            result = CostTaskResultEnum.FAILURE;
        }
        return result;
    }

    @Override
    public AllocTable getAllocTable() {
        try {
            return super.getAllocTable();
        }
        catch (AllocateException e) {
            this._logger.AddLog(e);
            logger.error((Object)"", (Throwable)((Object)e));
            return null;
        }
    }

    @Override
    public void preProcess() {
        try {
            super.preProcess();
        }
        catch (AllocateException e) {
            this._logger.AddLog(e);
            logger.error((Object)"", (Throwable)((Object)e));
        }
    }

    @Override
    public AllocStdInfo GetAllocStdSetting(IFeeInfo currFee) {
        Context ctx = (Context)this._param.get("ctx");
        AllocStdInfo setting = this.GetAllocStdFromCache(currFee);
        if (setting == null) {
            String possibleReason = AllocUtils.getAllocResource(ctx, "possible_reason_allocStd_notSet");
            String adviceHandle = AllocUtils.getAllocResource(ctx, "advice_handle_allocStd_toSet");
            if (this.allocStdSetModeByPrd.getValue() == "0") {
                this._logger.AddLog(new AllocateException(AllocateException.ITEM_ALLOC_NOTSET, new Object[]{currFee.GetExpenseNumber().concat(" ").concat(currFee.GetExpenseName()), currFee.GetCostCenterNumber().concat(" ").concat(currFee.GetCostCenterName())}));
            } else {
                this._logger.AddLog("\u8981\u7d20\u8d39\u7528[" + currFee.GetExpenseNumber().concat(" ").concat(currFee.GetExpenseName()) + "]\u7684\u5206\u914d\u6807\u51c6\u672a\u8bbe\u7f6e\uff01", possibleReason, adviceHandle);
            }
            try {
                this.updateFeeDataFlagToUnallocatedWhenCanntAlloc(currFee);
            }
            catch (AllocateException e) {
                logger.error((Object)"", (Throwable)((Object)e));
            }
        }
        return setting;
    }

    @Override
    public FeeData GetFeeDataControl() {
        try {
            return super.GetFeeDataControl();
        }
        catch (AllocateException e) {
            this._logger.AddLog(e);
            logger.error((Object)"", (Throwable)((Object)e));
            return null;
        }
    }

    @Override
    public void allocDirect() {
        try {
            super.allocDirect();
        }
        catch (AllocateException e) {
            this._logger.AddLog(e);
            logger.error((Object)"", (Throwable)((Object)e));
        }
    }

    @Override
    public void allocIndirect(IFeeInfo currFee, int position) {
        try {
            super.allocIndirect(currFee, position);
        }
        catch (AllocateException e) {
            this._logger.AddLog(e);
            logger.error((Object)"", (Throwable)((Object)e));
        }
    }

    @Override
    public Map processResult() {
        HashMap<String, String> ret = null;
        try {
            ret = super.processResult();
        }
        catch (AllocateException e) {
            this._logger.AddLog(e);
            logger.error((Object)"", (Throwable)((Object)e));
        }
        if (ret == null) {
            ret = new HashMap<String, String>();
            if (this._logger.getLogCount() > 0) {
                IRowSet logData = this._logger.GetLogData();
                ret.put("HasError", String.valueOf(true));
                ret.put("logData", (String)logData);
            }
        }
        return ret;
    }

    @Override
    public void endProcess() {
        try {
            super.endProcess();
            this.clearTempTable();
        }
        catch (AllocateException e) {
            this._logger.AddLog(e);
            logger.error((Object)"", (Throwable)((Object)e));
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            this._logger.AddLog(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e1));
        }
    }

    private AllocStdInfo GetAllocStdFromCache(IFeeInfo currFee) {
        Boolean isAssistant = this.isAssistantCostCenterReqFee(currFee);
        String key = "";
        if (isAssistant != null && isAssistant.booleanValue()) {
            this.initIndirectAllocStdSetting();
            key = currFee.GetExpenseId() + "_" + currFee.GetCostCenterId();
            return (AllocStdInfo)this.indirectAllocStdSettingCache.get(key);
        }
        this.initDirectAllocStdSetting();
        key = this.allocStdSetModeByPrd.getValue() == "0" ? currFee.GetExpenseId() + "_" + currFee.GetCostCenterId() : currFee.GetExpenseId();
        return (AllocStdInfo)this.directAllocStdSettingCache.get(key);
    }

    private void initDirectAllocStdSetting() {
        if (this.directAllocStdSettingCache != null) {
            return;
        }
        this.directAllocStdSettingCache = new HashMap();
        Context ctx = (Context)this._param.get("ctx");
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        StringBuffer sb = new StringBuffer();
        AllocStdSetByPrdCollection allocStdSettingCacheForDirect = null;
        try {
            sb.append("select \n");
            if (this.allocStdSetModeByPrd.getValue() == "0") {
                sb.append("    costCenter.id, \n");
            }
            sb.append("    expense.id, \n");
            sb.append("    allocStd.* \n");
            sb.append("where company = '" + companyId + "' \n");
            sb.append("and calculatePeriod = '" + periodId + "' \n");
            sb.append("and allocStd.id is not null \n");
            if (this.allocStdSetModeByPrd.getValue() == "0") {
                sb.append("and costCenter.id is not null \n");
            }
            IAllocStdSetByPrd fact = AllocStdSetByPrdFactory.getLocalInstance(ctx);
            allocStdSettingCacheForDirect = fact.getAllocStdSetByPrdCollection(sb.toString());
            String expenseId = null;
            String costCenterId = null;
            String key = null;
            for (int i = 0; i < allocStdSettingCacheForDirect.size(); ++i) {
                if (this.allocStdSetModeByPrd.getValue() == "0") {
                    costCenterId = allocStdSettingCacheForDirect.get(i).getCostCenter().getId().toString();
                }
                expenseId = allocStdSettingCacheForDirect.get(i).getExpense().getId().toString();
                key = this.allocStdSetModeByPrd.getValue() == "0" ? expenseId + "_" + costCenterId : expenseId;
                this.directAllocStdSettingCache.put(key, allocStdSettingCacheForDirect.get(i).getAllocStd());
            }
        }
        catch (BOSException e) {
            this._logger.AddLog(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e));
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void initIndirectAllocStdSetting() {
        if (this.indirectAllocStdSettingCache != null) {
            return;
        }
        this.indirectAllocStdSettingCache = new HashMap();
        Context ctx = (Context)this._param.get("ctx");
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        StringBuffer sb = new StringBuffer();
        AllocStdSetByOverheadCollection allocStdSettingCacheForAssisatant = null;
        try {
            IAllocStdSetByOverhead fact = AllocStdSetByOverheadFactory.getLocalInstance(ctx);
            sb.append("Select allocStd.*,expense.*,costCenter.* where company = '").append(companyId).append("' AND calculatePeriod = '").append(periodId).append("' AND allocStd.id is not null ");
            allocStdSettingCacheForAssisatant = fact.getAllocStdSetByOverheadCollection(sb.toString());
        }
        catch (BOSException e) {
            this._logger.AddLog(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e));
            logger.error((Object)"", (Throwable)e);
        }
        String expenseId = null;
        String costCenterId = null;
        String key = null;
        for (int i = 0; i < allocStdSettingCacheForAssisatant.size(); ++i) {
            expenseId = allocStdSettingCacheForAssisatant.get(i).getExpense().getId().toString();
            costCenterId = allocStdSettingCacheForAssisatant.get(i).getCostCenter().getId().toString();
            key = expenseId + "_" + costCenterId;
            this.indirectAllocStdSettingCache.put(key, allocStdSettingCacheForAssisatant.get(i).getAllocStd());
        }
    }

    @Override
    public void processAllocateException(AllocateException e, String possibleReason, String adviceHandle) throws AllocateException {
        if (possibleReason == null || adviceHandle == null) {
            this._logger.AddLog(e);
        } else {
            this._logger.AddLog(e, possibleReason, adviceHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void InsertDirectData(Context ctx, String companyId, String periodId, String userId) throws AllocateException {
        try {
            NCMDynamicTableManager.clearIndexsOfBusiTbl((Context)ctx, (String)companyId, (String)((MatAllocTable)this._allocTable).setAllocTblResult());
            NCMDynamicTableManager.DisablePrimaryKey((Context)ctx, (String)this.getTblResult());
            super.InsertDirectData(ctx, companyId, periodId, userId);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        finally {
            try {
                NCMDynamicTableManager.EnablePrimaryKey((Context)ctx, (String)this.getTblResult());
                NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)((MatAllocTable)this._allocTable).setAllocTblResult());
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
    }

    @Override
    protected boolean saveAllocResult(IFeeInfo currFee) throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        String userId = this._param.get("userId").toString();
        Context ctx = (Context)this._param.get("ctx");
        String allocStdStr = this.getAllocStd().getId().toString();
        boolean cancelAlloc = true;
        String sqlInsert = this.GetSql_InsertIndirectData(companyId, periodId, userId, allocStdStr, currFee);
        String sqlAdjustDiff = this.GetSql_AdjustDiff(currFee);
        try {
            NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sqlInsert, (String)";");
            NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sqlAdjustDiff, (String)";");
            if (this._tblResultForTempUse != null && this._tblResultForTempUse.size() > 100) {
                this.CopyTempData2AllocResult(ctx, companyId);
            }
        }
        catch (BOSException e) {
            log.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        cancelAlloc = false;
        return cancelAlloc;
    }

    @Override
    protected String GetSql_InsertIndirectData(String companyId, String periodId, String userId, String allocStdId, IFeeInfo currFee) throws AllocateException {
        Assert.that((boolean)(currFee instanceof IMatFeeInfo));
        IMatFeeInfo fee = (IMatFeeInfo)currFee;
        NumberFormat fm = NumberFormat.getInstance();
        fm.setGroupingUsed(false);
        fm.setMaximumFractionDigits(fee.GetQtyPrecision());
        String strQty = fm.format(fee.GetQty());
        fm.setMaximumFractionDigits(fee.GetCommonQtyPrecision());
        String strCommonQty = fm.format(fee.GetCommonQty());
        fm.setMaximumFractionDigits(fee.GetAssistQtyPrecision());
        String strAssistQty = fm.format(fee.GetAssistQty());
        fm.setMaximumFractionDigits(fee.GetAmountPrecision());
        String strAmount = fm.format(fee.GetAmount());
        fm.setMaximumFractionDigits(fee.GetPricePrecision());
        String strPrice = fm.format(BigDecimal.valueOf(0L));
        if (!fm.format(currFee.GetQty()).equals(BigDecimal.valueOf(0L).toString())) {
            strPrice = fm.format(fee.GetAmount().divide(fee.GetQty(), fee.GetPricePrecision(), 4));
        }
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO {0}(FID,FCompanyID,FCalculatePeriodID,FCostCenterID,").append('\n').append("FSourceBillID,FSourceBillEntryID,FCostObjectID,FCostItemID,FAllocStdID,").append('\n').append("FAllocStdData,FQty,FCommonQty,FAssistQty,FAmount,FPrice,FMaterialID,FLot,FBizDate,FSeq,FCreatorID,FCreateTime,FAdjustUserID,FAdjustTime,FIsDirect, AllocBillType )").append('\n').append("SELECT newbosid(''ADC37CB3'') AS FID, ''{1}'' As FCompanyID, ''{2}'' As FCalculatePeriodID,R.FCostCenterID,").append('\n').append("''{3}'' As FSourceBillID,''{4}'' As FSourceBillEntryID, R.FCostObjectID, {5} As FCostItemID, ''{6}'' As FAllocStdID,").append('\n').append("D.FQty As FAllocStdData, ROUND({7} * D.FRatio,{8})As FQty, ROUND({21} * D.FRatio,{22})As FCommonQty, ROUND({23} * D.FRatio,{24})As FAssistQty, ROUND({9} * D.FRatio,{10})As FAmount, {11} As FPrice, ").append('\n').append("''{12}'' As FMaterialID,{13} As FLot, TO_Date(''{14}'') As FBizDate, {15} As FSeq, ").append('\n').append("''{16}'' As FCreatorID, GetDate() As FCreateTime, ''{17}'' as FAdjustUserID, GetDate() as FAdjustTime,0 As FIsDirect , ''{18}'' as AllocBillType ").append('\n').append("FROM {19} R ").append('\n').append("INNER JOIN {20} D ON D.FID=R.FID ").append('\n').append("WHERE R.FIsValid =1 ");
        if (this.IsOnlyNotZero_AllcoStdData()) {
            sb.append(" AND D.FRatio <>0 ");
        }
        sb.append(";");
        String costItemId = fee.GetCostItemId();
        costItemId = costItemId != null && costItemId.length() > 0 ? "'" + costItemId + "'" : null;
        String lot = fee.GetLot();
        if (lot != null) {
            lot = "'" + lot + "'";
        }
        String sqlInsert = MessageFormat.format(sb.toString(), this.getTblResultForTempUse(currFee.GetEntryId()), companyId, periodId, fee.GetId(), fee.GetEntryId(), costItemId, this.getAllocStd().getId().toString(), strQty, String.valueOf(fee.GetQtyPrecision()), strAmount, String.valueOf(fee.GetAmountPrecision()), strPrice, fee.GetMaterialId(), lot, fee.GetBizDate(), String.valueOf(fee.GetSeq()), userId, this.GetAdjustUserId(), this.getAllocBillType(), this.getTblAllocObjectRange(), this.getTblAllocData(), strCommonQty, String.valueOf(fee.GetCommonQtyPrecision()), strAssistQty, String.valueOf(fee.GetAssistQtyPrecision()));
        return sqlInsert;
    }

    @Override
    protected String GetSql_AdjustDiff(IFeeInfo currFee) throws AllocateException {
        Assert.that((boolean)(currFee instanceof IMatFeeInfo));
        IMatFeeInfo fee = (IMatFeeInfo)currFee;
        NumberFormat fm = NumberFormat.getInstance();
        fm.setGroupingUsed(false);
        fm.setMaximumFractionDigits(fee.GetQtyPrecision());
        String strQty = fm.format(fee.GetQty());
        fm.setMaximumFractionDigits(fee.GetCommonQtyPrecision());
        String strCommonQty = fm.format(fee.GetCommonQty());
        fm.setMaximumFractionDigits(fee.GetAssistQtyPrecision());
        String strAssistQty = fm.format(fee.GetAssistQty());
        fm.setMaximumFractionDigits(fee.GetAmountPrecision());
        String strAmount = fm.format(fee.GetAmount());
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE {0} SET FQty=(FQty + {1} - ").append('\n').append("\t(SELECT ISNULL(SUM(S.FQty),0.00) ").append('\n').append("\tFROM {2} S").append('\n').append("\t)").append('\n').append(")").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom {3} ").append('\n').append("\tORDER BY FAllocStdData DESC ").append('\n').append(");");
        String sqlAdjustQty = MessageFormat.format(sb.toString(), this.getTblResultForTempUse(currFee.GetEntryId()), strQty, this.getTblResultForTempUse(currFee.GetEntryId()), this.getTblResultForTempUse(currFee.GetEntryId()));
        sb.delete(0, sb.length());
        sb.append("UPDATE {0} SET FAmount=(FAmount + {1} - ").append('\n').append("\t(SELECT ISNULL(SUM(S.FAmount),0.00) ").append('\n').append("\tFROM {2} S").append('\n').append("))").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom {3} ").append('\n').append("\tORDER BY FAllocStdData DESC ").append('\n').append(");");
        String sqlAdjustAmount = MessageFormat.format(sb.toString(), this.getTblResultForTempUse(currFee.GetEntryId()), strAmount, this.getTblResultForTempUse(currFee.GetEntryId()), this.getTblResultForTempUse(currFee.GetEntryId()));
        String sqlUpdatePrice_Zero = MessageFormat.format("UPDATE {0} SET FPrice=0 WHERE FQty=0 ;", this.getTblResultForTempUse(currFee.GetEntryId()));
        sb.delete(0, sb.length());
        sb.append("UPDATE {0} SET FCommonQty=(FCommonQty + {1} - ").append('\n').append("\t(SELECT ISNULL(SUM(S.FCommonQty),0.00) ").append('\n').append("\tFROM {2} S").append('\n').append("))").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom {3} ").append('\n').append("\tORDER BY FAllocStdData DESC ").append('\n').append(");");
        String sqlAdjustCommonQty = MessageFormat.format(sb.toString(), this.getTblResultForTempUse(currFee.GetEntryId()), strCommonQty, this.getTblResultForTempUse(currFee.GetEntryId()), this.getTblResultForTempUse(currFee.GetEntryId()));
        sb.delete(0, sb.length());
        sb.append("UPDATE {0} SET FAssistQty=(FAssistQty + {1} - ").append('\n').append("\t(SELECT ISNULL(SUM(S.FAssistQty),0.00) ").append('\n').append("\tFROM {2} S").append('\n').append("))").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom {3} ").append('\n').append("\tORDER BY FAllocStdData DESC ").append('\n').append(");");
        String sqlAdjustAssistQty = MessageFormat.format(sb.toString(), this.getTblResultForTempUse(currFee.GetEntryId()), strAssistQty, this.getTblResultForTempUse(currFee.GetEntryId()), this.getTblResultForTempUse(currFee.GetEntryId()));
        return sqlAdjustQty + '\n' + sqlAdjustAmount + '\n' + sqlUpdatePrice_Zero + '\n' + sqlAdjustCommonQty + '\n' + sqlAdjustAssistQty;
    }

    @Override
    public void commitAllocResult(boolean isLastBatch) throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        Context ctx = (Context)this._param.get("ctx");
        if (isLastBatch) {
            this.CopyTempData2AllocResult(ctx, companyId);
            try {
                NCMDynamicTableManager.EnablePrimaryKey((Context)ctx, (String)this.getTblResult());
                NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)((MatAllocTable)this._allocTable).setAllocTblResult());
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
            this.updateDefaultCostItem(ctx, companyId, periodId);
            this.removeNoCostItem(ctx, companyId, periodId);
            this.updateAllocResult();
            this.hasClearIndexs = false;
        }
    }

    protected void CopyTempData2AllocResult(Context ctx, String companyId) throws AllocateException {
        if (this._tblResultForTempUse == null || this._tblResultForTempUse.size() <= 0) {
            return;
        }
        try {
            if (!this.hasClearIndexs) {
                NCMDynamicTableManager.clearIndexsOfBusiTbl((Context)ctx, (String)companyId, (String)((MatAllocTable)this._allocTable).setAllocTblResult());
                NCMDynamicTableManager.DisablePrimaryKey((Context)ctx, (String)this.getTblResult());
                this.hasClearIndexs = true;
            }
            StringBuffer sbInsert = new StringBuffer();
            sbInsert.append("Insert into ").append(this.getTblResult()).append(" (").append("FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FSourceBillID ,FSourceBillEntryID ,FCostObjectID ,FCostItemID ,FAllocStdID ,FAllocStdData ,FQty ,FCommonQty ,FAssistQty ,FBaseUnitID ,FCommonUnitID ,FAssistUnitID ,FPrice ,FAmount ,FMaterialID ,FLot ,FBizDate ,FSeq ,FCreatorID ,FCreateTime ,FAdjustUserID ,FAdjustTime ,FIsDirect, AllocBillType , FIsRework, FAdminOrgUnitID , FWarehouseID").append(") ").append('\n');
            StringBuffer sbDrop = new StringBuffer();
            Iterator ite = this._tblResultForTempUse.entrySet().iterator();
            int i = 0;
            while (ite.hasNext()) {
                Map.Entry me = ite.next();
                if (me.getValue() == null) continue;
                String tblName = (String)me.getValue();
                if (i > 0) {
                    sbInsert.append(" UNION ALL ").append('\n');
                }
                sbInsert.append("Select ").append("FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FSourceBillID ,FSourceBillEntryID ,FCostObjectID ,FCostItemID ,FAllocStdID ,FAllocStdData ,FQty ,FCommonQty ,FAssistQty ,FBaseUnitID ,FCommonUnitID ,FAssistUnitID ,FPrice ,FAmount ,FMaterialID ,FLot ,FBizDate ,FSeq ,FCreatorID ,FCreateTime ,FAdjustUserID ,FAdjustTime ,FIsDirect, AllocBillType , FIsRework, FAdminOrgUnitID , FWarehouseID").append(" FROM ").append(tblName).append('\n');
                sbDrop.append("truncate table ").append(tblName).append(";").append('\n');
                ++i;
            }
            NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sbInsert.toString());
            NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sbDrop.toString(), (String)";");
            this.tblStack.addAll(this._tblResultForTempUse.values());
            this._tblResultForTempUse.clear();
            this._tblResultForTempUse = null;
        }
        catch (BOSException e) {
            log.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        catch (EASBizException e2) {
            log.error((Object)"", (Throwable)e2);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e2), null, null);
        }
    }

    public String getTblResultForTempUse(String id) throws AllocateException {
        if (this._tblResultForTempUse == null) {
            this._tblResultForTempUse = new HashMap();
        }
        if (this.tblStack == null) {
            this.tblStack = new Stack();
        }
        String tblName = null;
        try {
            if (this._tblResultForTempUse.containsKey(id)) {
                return (String)this._tblResultForTempUse.get(id);
            }
            if (this.tblStack.size() > 0) {
                tblName = this.tblStack.pop();
                this._tblResultForTempUse.put(id, tblName);
                return tblName;
            }
            String companyId = this._param.get("companyId").toString();
            Context ctx = (Context)this._param.get("ctx");
            tblName = this.CreateDynTableForTempUse(ctx, companyId, ((MatAllocTable)this._allocTable).setAllocTblResult());
            this._tblResultForTempUse.put(id, tblName);
            return tblName;
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
    }

    public String CreateDynTableForTempUse(Context ctx, String companyId, String busiTblName) throws BOSException, SQLException, EASBizException {
        String tblNameInfo = null;
        Object[] param = null;
        try {
            tblNameInfo = busiTblName;
            String sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FCostCenterID VARCHAR(44),FSourceBillID VARCHAR(44),FSourceBillEntryID VARCHAR(44),FCostObjectID VARCHAR(44),FCostItemID VARCHAR(44),FAllocStdID VARCHAR(44),FAllocStdData NUMERIC(24,12),FQty NUMERIC(21,8),FCommonQty NUMERIC(21,8),FAssistQty NUMERIC(21,8),FBaseUnitID varchar(44),FCommonUnitID varchar(44),FAssistUnitID varchar(44),FPrice NUMERIC(21,8),FAmount NUMERIC(17,4),FMaterialID VARCHAR(44),FLot NVARCHAR(80),FBizDate DateTime,FSeq INT,FCreatorID VARCHAR(44),FCreateTime DateTime,FAdjustUserID VARCHAR(44),FAdjustTime DateTime,FIsDirect INT, AllocBillType VARCHAR(4), FIsRework INT NOT NULL DEFAULT 0,FAdminOrgUnitID varchar(44),FWarehouseID varchar(44) )";
            param = new Object[]{tblNameInfo};
            sql = MessageFormat.format(sql, param);
            tblNameInfo = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tblNameInfo;
    }

    public void clearTempTable() throws BOSException {
        Context ctx = (Context)this._param.get("ctx");
        StringBuffer sql = new StringBuffer();
        if (this.tblStack != null) {
            Iterator iterator = this.tblStack.iterator();
            while (iterator.hasNext()) {
                sql.append("drop table ").append((String)iterator.next()).append(";");
            }
            this.tblStack.clear();
        }
        if (this._tblResultForTempUse != null) {
            for (Map.Entry me : this._tblResultForTempUse.entrySet()) {
                sql.append("drop table ").append((String)me.getValue()).append(";");
            }
        }
        NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sql.toString(), (String)";");
    }
}

