/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.ncm.AllocStdInfo;
import com.kingdee.eas.ncm.bill.AllocStdSetByPrdCollection;
import com.kingdee.eas.ncm.bill.AllocStdSetByPrdFactory;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.IAllocStdSetByPrd;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.AUSContext;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.FeeData;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.Info.IFeeInfo;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.OtherInWHAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.AllocTable;
import com.kingdee.eas.ncm.bill.app.Alloc.helper.AllocUtils;
import com.kingdee.eas.ncm.bill.app.Alloc.helper.AllocateExceptionLog;
import com.kingdee.eas.ncm.common.AllocStdSetModeByPrdEnum;
import com.kingdee.eas.ncm.common.task.CostTaskResultEnum;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class AutoOtherInWHAllocator
extends OtherInWHAllocator {
    private static Logger logger = Logger.getLogger((String)AutoOtherInWHAllocator.class.getName());
    private AllocateExceptionLog _logger;
    Map allocStdSettingCache = null;
    AllocStdSetModeByPrdEnum allocStdSetModeByPrd = null;

    public AutoOtherInWHAllocator(Map param, AUSContext ausCtx) {
        super(param, ausCtx);
        Assert.that((boolean)param.containsKey("logger"));
        this._logger = (AllocateExceptionLog)param.get("logger");
    }

    @Override
    public CostTaskResultEnum preCheck() throws Exception {
        CostTaskResultEnum result = super.preCheck();
        Context ctx = (Context)this._param.get("ctx");
        String companyId = this._param.get("companyId").toString();
        try {
            this.allocStdSetModeByPrd = NCMUtils.getAllocStdSetModeByPrd((Context)ctx, (String)companyId);
        }
        catch (BOSException e) {
            this._logger.AddLog(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e));
            logger.error((Object)"", (Throwable)e);
            result = CostTaskResultEnum.FAILURE;
        }
        return result;
    }

    @Override
    public AllocTable getAllocTable() {
        try {
            return super.getAllocTable();
        }
        catch (AllocateException e) {
            this._logger.AddLog(e);
            logger.error((Object)"", (Throwable)((Object)e));
            return null;
        }
    }

    @Override
    public void preProcess() {
        try {
            super.preProcess();
        }
        catch (AllocateException e) {
            this._logger.AddLog(e);
            logger.error((Object)"", (Throwable)((Object)e));
        }
    }

    @Override
    public AllocStdInfo GetAllocStdSetting(IFeeInfo currFee) throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        AllocStdInfo setting = this.GetAllocStdFromCache(currFee);
        if (setting == null) {
            String possibleReason = AllocUtils.getAllocResource(ctx, "possible_reason_allocStd_notSet");
            String adviceHandle = AllocUtils.getAllocResource(ctx, "advice_handle_allocStd_toSet");
            if (this.allocStdSetModeByPrd.getValue() == "0") {
                this._logger.AddLog(new AllocateException(AllocateException.ITEM_ALLOC_NOTSET, new Object[]{currFee.GetExpenseNumber().concat(" ").concat(currFee.GetExpenseName()), currFee.GetCostCenterNumber().concat(" ").concat(currFee.GetCostCenterName())}));
            } else {
                this._logger.AddLog("\u8981\u7d20\u8d39\u7528[" + currFee.GetExpenseNumber().concat(" ").concat(currFee.GetExpenseName()) + "]\u7684\u5206\u914d\u6807\u51c6\u672a\u8bbe\u7f6e\uff01", possibleReason, adviceHandle);
            }
        }
        return setting;
    }

    private AllocStdInfo GetAllocStdFromCache(IFeeInfo currFee) {
        if (this.allocStdSettingCache == null) {
            Context ctx = (Context)this._param.get("ctx");
            String companyId = this._param.get("companyId").toString();
            String periodId = this._param.get("periodId").toString();
            StringBuffer sb = new StringBuffer();
            this.allocStdSettingCache = new HashMap();
            AllocStdSetByPrdCollection allocStdSettingCacheForDirect = null;
            try {
                sb.append("select \n");
                if (this.allocStdSetModeByPrd.getValue() == "0") {
                    sb.append("    costCenter.id, \n");
                }
                sb.append("    expense.id, \n");
                sb.append("    allocStd.* \n");
                sb.append("where company = '" + companyId + "' \n");
                sb.append("and calculatePeriod = '" + periodId + "' \n");
                sb.append("and allocStd.id is not null \n");
                IAllocStdSetByPrd fact = AllocStdSetByPrdFactory.getLocalInstance(ctx);
                allocStdSettingCacheForDirect = fact.getAllocStdSetByPrdCollection(sb.toString());
                String expenseId = null;
                String costCenterId = null;
                String key = null;
                for (int i = 0; i < allocStdSettingCacheForDirect.size(); ++i) {
                    if (this.allocStdSetModeByPrd.getValue() == "0") {
                        costCenterId = allocStdSettingCacheForDirect.get(i).getCostCenter().getId().toString();
                    }
                    expenseId = allocStdSettingCacheForDirect.get(i).getExpense().getId().toString();
                    key = this.allocStdSetModeByPrd.getValue() == "0" ? expenseId + "_" + costCenterId : expenseId;
                    this.allocStdSettingCache.put(key, allocStdSettingCacheForDirect.get(i).getAllocStd());
                }
            }
            catch (BOSException e) {
                this._logger.AddLog(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e));
                logger.error((Object)"", (Throwable)e);
            }
        }
        String key = "";
        key = this.allocStdSetModeByPrd.getValue() == "0" ? currFee.GetExpenseId() + "_" + currFee.GetCostCenterId() : currFee.GetExpenseId();
        return (AllocStdInfo)this.allocStdSettingCache.get(key);
    }

    @Override
    public FeeData GetFeeDataControl() {
        try {
            return super.GetFeeDataControl();
        }
        catch (AllocateException e) {
            this._logger.AddLog(e);
            logger.error((Object)"", (Throwable)((Object)e));
            return null;
        }
    }

    @Override
    public void allocDirect() {
        try {
            super.allocDirect();
        }
        catch (AllocateException e) {
            this._logger.AddLog(e);
            logger.error((Object)"", (Throwable)((Object)e));
        }
    }

    @Override
    public void allocIndirect(IFeeInfo currFee, int position) {
        try {
            super.allocIndirect(currFee, position);
        }
        catch (AllocateException e) {
            this._logger.AddLog(e);
            logger.error((Object)"", (Throwable)((Object)e));
        }
    }

    @Override
    public Map processResult() {
        HashMap<String, String> ret = null;
        try {
            ret = super.processResult();
        }
        catch (AllocateException e) {
            this._logger.AddLog(e);
            logger.error((Object)"", (Throwable)((Object)e));
        }
        if (ret == null) {
            ret = new HashMap<String, String>();
            if (this._logger.getLogCount() > 0) {
                IRowSet logData = this._logger.GetLogData();
                ret.put("HasError", String.valueOf(true));
                ret.put("logData", (String)logData);
            }
        }
        return ret;
    }

    @Override
    public void endProcess() {
        try {
            super.endProcess();
        }
        catch (AllocateException e) {
            this._logger.AddLog(e);
            logger.error((Object)"", (Throwable)((Object)e));
        }
    }

    @Override
    public void processAllocateException(AllocateException e, String possibleReason, String adviceHandle) throws AllocateException {
        if (possibleReason == null || adviceHandle == null) {
            this._logger.AddLog(e);
        } else {
            this._logger.AddLog(e, possibleReason, adviceHandle);
        }
    }
}

