/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.ncm.AllocStdInfo;
import com.kingdee.eas.basedata.ncm.AllocStdTypeEnum;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.AUSContext;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Allocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.FeeData;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.Info.IFeeInfo;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.Info.MatFeeInfoAdapter;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.AllocTable;
import com.kingdee.eas.ncm.bill.app.Alloc.helper.AllocUtils;
import com.kingdee.eas.ncm.common.AllocSourceBillEnum;
import com.kingdee.eas.ncm.common.task.CostTaskResultEnum;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class BaseAllocator
extends Allocator {
    protected AllocTable _allocTable;
    private FeeData _feeData;
    private String _tblResult = null;
    protected String _tblAllocData = null;
    protected String _tblAllocObjectRange = null;
    private AllocStdInfo _allocStd = null;
    protected static final char CLF = '\n';
    protected static final Logger log = Logger.getLogger((String)BaseAllocator.class.getName());
    protected String lastCostObjectSuiteId = null;
    protected String lastCostCenterId = null;
    private String lastMaterialId = null;
    protected boolean bRangeChanged = false;
    protected boolean bMaterialChanged = false;

    public BaseAllocator(Map param, AUSContext ausCtx) {
        super(param, ausCtx);
    }

    @Override
    public void buildTargetBillEntryID() throws Exception {
        this.getFeeData().buildTargetBillEntryID(this.getAllocTable().GetResultTable());
    }

    @Override
    public CostTaskResultEnum preCheck() throws Exception {
        return CostTaskResultEnum.SUCCESS;
    }

    protected boolean hasDirectCostCenterReqFee() throws AllocateException {
        return true;
    }

    protected boolean hasAssistantCostCenterReqFee() throws AllocateException {
        return true;
    }

    @Override
    public void clearPreAllocResult() throws Exception {
        this.getFeeData().clearPreAllocResult(this.getAllocTable().GetResultTable());
    }

    @Override
    public void resetAllocFlagToUnallocated() throws Exception {
        if (this.GetFeeDataControl() != null) {
            this.GetFeeDataControl().updateFeeDataFlagToUnallocated(this.getAllocTable().GetResultTable());
        }
    }

    @Override
    public void fillAllocObjectRange() throws Exception {
        this.fillObjectRange();
        this.fillAllocTempData();
    }

    @Override
    public void preProcess() throws AllocateException {
        this.getAllocTable().CreateTempTableIndexs();
    }

    @Override
    public void allocDirect() throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        String userId = this._param.get("userId").toString();
        Context ctx = (Context)this._param.get("ctx");
        this.InsertDirectData(ctx, companyId, periodId, userId);
        this.removeInvalidCostObject(ctx, companyId, periodId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void allocIndirect(IFeeInfo currFee, int position) throws AllocateException {
        boolean cancelAlloc = false;
        Context ctx = (Context)this._param.get("ctx");
        try {
            boolean allocStdChanged;
            String materialId;
            log.debug((Object)"--E.00,begin allocIndirect");
            cancelAlloc = this.dataIsVouchered(currFee);
            if (cancelAlloc) {
                return;
            }
            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"14_BaseAllocator", (Locale)ctx.getLocale()));
            cancelAlloc = this.crossCostObjectSuiteRange(currFee);
            if (cancelAlloc) {
                return;
            }
            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"15_BaseAllocator", (Locale)ctx.getLocale()));
            cancelAlloc = this.filterAllocTempDataRange(currFee);
            if (cancelAlloc) {
                return;
            }
            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"16_BaseAllocator", (Locale)ctx.getLocale()));
            AllocStdInfo std = this.GetAllocStdSetting(currFee);
            if (std == null) {
                return;
            }
            boolean bc = true;
            if (currFee instanceof MatFeeInfoAdapter && !StringUtils.isEmpty((String)(materialId = ((MatFeeInfoAdapter)currFee).GetMaterialId()))) {
                this._param.put("currFeeMaterialId", materialId);
                if (materialId.equals(this.lastMaterialId)) {
                    bc = false;
                }
            }
            this.lastMaterialId = null;
            if (currFee instanceof MatFeeInfoAdapter && !StringUtils.isEmpty((String)(materialId = ((MatFeeInfoAdapter)currFee).GetMaterialId()))) {
                this.lastMaterialId = materialId;
            }
            boolean isDirectMatQtyStrategy = !StringUtils.isEmpty((String)std.getFormulaForParse()) && std.getFormulaForParse().indexOf("wSCGfwEgEADgABg2wKgSMp3UGuM=") != -1 && this._param.containsKey("currFeeMaterialId");
            boolean isMaterialRate = false;
            if (currFee instanceof MatFeeInfoAdapter) {
                boolean bl = isMaterialRate = !StringUtils.isEmpty((String)std.getFormulaForParse()) && std.getFormulaForParse().indexOf("d2T+lgEaEADgAAmCwKgRj53UGuM=") != -1;
                if (isMaterialRate) {
                    this._param.put("currFeeMaterialId", ((MatFeeInfoAdapter)currFee).GetMaterialId());
                    this._param.put("currFeeBizDate", ((MatFeeInfoAdapter)currFee).GetBizDate());
                }
            }
            isDirectMatQtyStrategy = bc && isDirectMatQtyStrategy;
            boolean bl = allocStdChanged = this._allocStd == null || !this._allocStd.getId().toString().equals(std.getId().toString());
            if (allocStdChanged) {
                if (this.isAssistantCostCenterReqFee(currFee).booleanValue()) {
                    this._ausCtx.setAllocStdType(AllocStdTypeEnum.AUX);
                } else {
                    this._ausCtx.setAllocStdType((AllocStdTypeEnum)this._param.get("allocStdType"));
                }
                this.setAllocStd(std);
            }
            if (allocStdChanged || this.bRangeChanged) {
                log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"17_BaseAllocator", (Locale)ctx.getLocale()));
                cancelAlloc = this.initAllocDataTable();
                if (cancelAlloc) {
                    return;
                }
            }
            if (allocStdChanged || this.bRangeChanged || this.bMaterialChanged || isDirectMatQtyStrategy || isMaterialRate) {
                log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"18_BaseAllocator", (Locale)ctx.getLocale()));
                cancelAlloc = this.updateAllocDataTable();
                if (cancelAlloc) {
                    return;
                }
            }
            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"19_BaseAllocator", (Locale)ctx.getLocale()));
            if (this.IsOnlyNotZero_AllcoStdData()) {
                this.checkNoAllocStdData(currFee);
            }
            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"20_BaseAllocator", (Locale)ctx.getLocale()));
            cancelAlloc = this.saveAllocResult(currFee);
            if (cancelAlloc) {
                return;
            }
        }
        finally {
            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
            log.debug((Object)"--E.00,end allocIndirect");
        }
    }

    protected Boolean isAssistantCostCenterReqFee(IFeeInfo currFee) {
        Boolean isAssistant = (Boolean)this._param.get("isAssistant");
        if (isAssistant != null) {
            return isAssistant;
        }
        return Boolean.FALSE;
    }

    protected boolean dataIsVouchered(IFeeInfo currFee) throws AllocateException {
        return false;
    }

    @Override
    public Map processResult() throws AllocateException {
        return null;
    }

    @Override
    public void updateAllocFlagToAllocated() throws Exception {
        if (this.GetFeeDataControl() != null) {
            this.GetFeeDataControl().updateFeeDataFlagToAllocated(this.getAllocTable().GetResultTable());
        }
    }

    @Override
    public void endProcess() throws AllocateException {
        this.getAllocTable().releaseTempTable();
    }

    protected void fillObjectRange() throws AllocateException {
        this.removeDataInObjectRange();
        boolean isAux = AllocSourceBillEnum.InnerOverheadBill.equals(this._param.get("allocSourceBill"));
        if (isAux) {
            this.fillDirectObjectRange();
            this.fillAssistantObjectRange();
            return;
        }
        this.fillAssistantObjectRange();
        this.fillDirectObjectRange();
    }

    private void removeDataInObjectRange() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        String sqlTruncateTbl = null;
        String tblObjRange = this.getAllocTable().GetObjectRangeTable();
        sqlTruncateTbl = "truncate table " + tblObjRange;
        try {
            NCMDbUtil.execute((Context)ctx, (String)sqlTruncateTbl);
        }
        catch (BOSException e) {
            log.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillAssistantObjectRange() throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        Context ctx = (Context)this._param.get("ctx");
        String tblObjRange = this.getAllocTable().GetObjectRangeTable();
        Object[] params = new Object[]{companyId, periodId};
        StringBuffer sb = new StringBuffer();
        this.appendSQLForInsertAuxAllocObjRangeTbl(tblObjRange, sb);
        try {
            NCMDbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])params);
        }
        catch (BOSException e) {
            log.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, tblObjRange);
        }
        catch (SQLException e) {
            log.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    protected void appendSQLForInsertAuxAllocObjRangeTbl(String tblObjRange, StringBuffer sb) throws AllocateException {
        sb.append("INSERT INTO ").append(tblObjRange).append(" (FID,FCostCenterID,FCostObjectID,FMaterialID,FCostItemID,FIsValid)").append('\n').append("SELECT newbosid('08F65F4A') AS FId, FCostCenterID,FCostObjectID,FMaterialID, null As FCostItemID, FIsValid ").append('\n').append("FROM (").append('\n').append("\tSELECT DISTINCT B.FCostCenterID as FCostCenterID,CO.FID as FCostObjectID,CO.FStdProductIDID as FMaterialID, 1 As FIsValid ").append('\n').append("\tFROM T_NCM_InnerOverheadBill B ").append('\n').append("\tRIGHT OUTER JOIN T_NCM_InnerOverheadBillEntry E ON B.FID = E.FParentID ").append('\n').append("\tINNER JOIN T_BD_CostObjectEntry COE ON COE.FRelatedID = E.FAuxOverheadID ").append('\n').append("\tINNER JOIN T_BD_CostObject CO ON CO.FID = COE.FParentID AND CO.FCompanyID = B.FCompanyOrg ").append('\n').append("\tWHERE B.FBillStatus=4 AND B.FCompanyOrg = ? AND B.FCalculatePeriod = ? ").append('\n').append(") As A ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillDirectObjectRange() throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        Context ctx = (Context)this._param.get("ctx");
        String tblObjRange = this.getAllocTable().GetObjectRangeTable();
        Object[] params = new Object[]{companyId, periodId, companyId, periodId};
        String tblBalance = null;
        try {
            tblBalance = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_Balance");
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ").append(tblObjRange).append(" (FID,FCostCenterID,FCostObjectID,FMaterialID,FCostItemID,FIsValid)").append('\n').append("SELECT newbosid('08F65F4A') AS FId, FCostCenterOrgUnitID,FCostObjectID,FMaterialID, null As FCostItemID, FIsValid ").append('\n').append("FROM (").append('\n').append("   select A.FCostCenterOrgUnitID,A.FCostObjectID,A.FMaterialID,sum(isnull(A.FQty,0)) as FQty,1 As FIsValid \n").append("     From (").append("\t        SELECT DISTINCT B.FCostCenterOrgUnitID as FCostCenterOrgUnitID,E.FCostObjectID as FCostObjectID,co.FStdProductIDID as FMaterialID, E.FQty as FQty ").append('\n').append("\t        FROM T_NCM_InputQtyBill B ").append('\n').append("\t        RIGHT OUTER JOIN T_NCM_InputQtyBillEntry E ON B.FID = E.FParentID ").append('\n').append("\t        left join t_bd_costObject co on co.FID = E.FCostObjectID ").append('\n').append("\t        WHERE B.FBillStatus=4 AND B.FCompanyOrg = ? AND B.FCalculatePeriod = ? ").append('\n').append("\t        UNION ").append('\n').append("\t        SELECT DISTINCT BB.FCostCenterID As FCostCenterOrgUnitID,BB.FCostObjectID as FCostObjectID,coo.FStdProductIDID as FMaterialID, BB.FBopWIPQty as Fqty ").append('\n').append("\t        FROM ").append(tblBalance).append(" BB ").append('\n').append("\t        left join t_bd_costObject coo on coo.FID = BB.FCostObjectID ").append('\n').append("\t        WHERE BB.FCompanyOrg = ? AND BB.FCalculatePeriodID = ? ").append('\n').append("          ) As A ").append("   group by A.FCostCenterOrgUnitID,A.FCostObjectID,A.FMaterialID ) as data \n").append(" where (data.FQty >0 or data.FQty < 0) \n");
        this.appendWhereSQLClause(sb, companyId, periodId);
        try {
            NCMDbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])params);
        }
        catch (BOSException e) {
            log.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, tblObjRange);
        }
        catch (SQLException e) {
            log.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    protected void appendWhereSQLClause(StringBuffer sb, String companyId, String periodId) {
    }

    protected void fillAllocTempData() throws AllocateException {
    }

    protected boolean crossCostObjectSuiteRange(IFeeInfo currFee) throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        Context ctx = (Context)this._param.get("ctx");
        String costObjectSuiteId = currFee.GetCostObjectSuiteId();
        String tblObjRange = this.getAllocTable().GetObjectRangeTable();
        String tblValidObjectRange = this.getAllocTable().GetValidObjectRangeTable();
        StringBuffer sb = new StringBuffer();
        boolean cancelAlloc = true;
        this.bRangeChanged = false;
        if (!((this.lastCostObjectSuiteId == null && costObjectSuiteId == null || this.lastCostObjectSuiteId != null && this.lastCostObjectSuiteId.equals(costObjectSuiteId)) && (this.lastCostCenterId == null && currFee.GetCostCenterId() == null || this.lastCostCenterId != null && this.lastCostCenterId.equals(currFee.GetCostCenterId())))) {
            Object[] params;
            String sqlInit = "UPDATE " + tblObjRange + " SET FIsValid = 0 ";
            if (costObjectSuiteId == null || "".equals(costObjectSuiteId)) {
                sb.append("UPDATE ").append(tblObjRange).append(" SET FIsValid = ? WHERE FCostCenterID = ?  ");
                params = new Object[]{String.valueOf(1), currFee.GetCostCenterId()};
            } else {
                sb.append("UPDATE ").append(tblObjRange).append(" SET (FIsValid)=(").append('\n').append("\tSELECT 1").append('\n').append("\tFROM T_NCM_CostObjectSuite S").append('\n').append("\tRIGHT OUTER JOIN T_NCM_CostObjectSuiteEntry E ON S.FID = E.FParentID").append('\n').append("\tWHERE S.FID = '").append(costObjectSuiteId).append("' AND S.FCompanyID = '").append(companyId).append("' AND E.FCostObjectID = ").append(tblObjRange).append(".FCostObjectID").append('\n').append(") WHERE FCostCenterID = ? ");
                params = new Object[]{currFee.GetCostCenterId()};
            }
            try {
                NCMDbUtil.execute((Context)ctx, (String)sqlInit);
                NCMDbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])params);
                sb.delete(0, sb.length());
                if (tblValidObjectRange != null) {
                    sb.append(" truncate table ").append(tblValidObjectRange).append("; \n");
                    sb.append("insert into ").append(tblValidObjectRange).append(" \n");
                    sb.append(" (FID,FCostCenterID,FCostObjectID,FMaterialID,FCostItemID,FIsValid) \n");
                    sb.append(" select FID,FCostCenterID,FCostObjectID,FMaterialID,FCostItemID,FIsValid \n");
                    sb.append(" From ").append(tblObjRange).append(" \n");
                    sb.append(" where FIsValid = 1; \n");
                    NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sb.toString());
                    sb.setLength(0);
                }
            }
            catch (BOSException e) {
                log.error((Object)"", (Throwable)e);
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
            }
            this.lastCostObjectSuiteId = costObjectSuiteId;
            this.lastCostCenterId = currFee.GetCostCenterId();
            this.bRangeChanged = true;
        }
        cancelAlloc = false;
        sb.append("Select top 1 FID ").append("FROM ").append(tblObjRange).append(" ").append("WHERE FIsValid = 1 ");
        try {
            IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (!rs.next()) {
                cancelAlloc = true;
                Boolean isAssistant = this.isAssistantCostCenterReqFee(currFee);
                if (isAssistant != null && isAssistant.booleanValue()) {
                    if (costObjectSuiteId != null && !"".equals(costObjectSuiteId)) {
                        this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_INVALID_COSTOBJSUITE_AUX, new Object[]{currFee.GetNumber(), currFee.GetEntrySeq(), currFee.GetCostObjectSuiteName()}), null, null);
                    } else {
                        Map checkAssistant = AllocUtils.checkAssistantCostObject(ctx, companyId, this._param.get("periodId").toString(), currFee.GetCostCenterId());
                        boolean existOverHead = (Boolean)checkAssistant.get("existOverHead");
                        if (!existOverHead) {
                            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_NO_INPUT_AUS_CC, new Object[]{currFee.GetNumber(), currFee.GetEntrySeq(), currFee.GetCostCenterName()}), null, null);
                        } else {
                            boolean existAUXOHcostObj = (Boolean)checkAssistant.get("existAUXOHcostObj");
                            if (!existAUXOHcostObj) {
                                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_NO_INPUT_AUSOBJ_CC, new Object[]{currFee.GetNumber(), currFee.GetEntrySeq(), currFee.GetCostCenterName()}), null, null);
                            }
                        }
                    }
                } else if (costObjectSuiteId != null && !"".equals(costObjectSuiteId)) {
                    if (this._param.get("isNormal") != null) {
                        this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_INVALID_DYNCOSTOBJSUITE, new Object[]{currFee.GetNumber(), currFee.GetEntrySeq(), currFee.GetCostObjectSuiteName()}), null, null);
                    } else {
                        this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_INVALID_COSTOBJSUITE, new Object[]{currFee.GetNumber(), currFee.GetEntrySeq(), currFee.GetCostObjectSuiteName()}), null, null);
                    }
                } else if (this._param.get("isNormal") != null) {
                    this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_INVALID_COSTOBJ_DYNCC, new Object[]{currFee.GetNumber(), currFee.GetEntrySeq(), currFee.GetCostCenterName()}), null, null);
                } else {
                    this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_INVALID_COSTOBJ_CC, new Object[]{currFee.GetNumber(), currFee.GetEntrySeq(), currFee.GetCostCenterName()}), null, null);
                }
            }
        }
        catch (BOSException e) {
            log.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        catch (SQLException e) {
            log.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e), null, null);
        }
        return cancelAlloc;
    }

    protected boolean filterAllocTempDataRange(IFeeInfo currFee) throws AllocateException {
        return false;
    }

    protected boolean initAllocDataTable() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        String fieldList = this._ausCtx.GetFieldListForQuery();
        String fldAstList = this._ausCtx.GetMergeFormatStr("0 As {0}", ",");
        boolean cancelAlloc = true;
        StringBuffer sb = new StringBuffer();
        sb.append("truncate table ").append(this.getTblAllocData()).append(";").append('\n');
        sb.append("INSERT INTO ").append(this.getTblAllocData()).append("(FID,").append(fieldList).append("FQty,FRatio)").append('\n').append("Select FID,").append(fldAstList).append("0 As FQty, 0 As FRatio ").append('\n').append("from ").append(this.getTblAllocObjectRange()).append('\n').append("where FIsValid =1 ;");
        try {
            NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
            cancelAlloc = false;
        }
        catch (BOSException e) {
            log.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        return cancelAlloc;
    }

    protected boolean updateAllocDataTable() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        boolean cancelAlloc = true;
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("update " + this.getTblAllocData() + " set " + this._ausCtx.GetMergeFormatStr("{0} = 0", ",") + " FRatio=0, FQty = 0;");
            NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
            sb.delete(0, sb.length());
            sb.append(this._ausCtx.GetAllocStdUnitDataSql()).append('\n');
            sb.append(this._ausCtx.GetAllocStdFormulaUpdateSql()).append(";").append('\n');
            sb.append(" UPDATE ").append(this.getTblAllocData()).append(" SET FQty = 0 WHERE FQty < 0 ;").append('\n');
            NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
            sb.setLength(0);
            this.processQtyBeforeCalRate();
            sb.append(" UPDATE ").append(this.getTblAllocData()).append(" SET FRatio = Round(To_Decimal(FQty,24,12)/").append("\t(").append("\tSelect To_Decimal(ISNULL(SUM(S.FQty),1),21,8)As FQty").append("\tFROM ").append(this.getTblAllocData()).append(" S ").append("\tWHERE S.FQty > 0 ").append("\tGROUP BY S.FRatio ").append("\tHAVING SUM(S.FQty) <> 0 ").append("\t),12);");
            NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
            cancelAlloc = false;
        }
        catch (BOSException e) {
            log.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        return cancelAlloc;
    }

    protected void processQtyBeforeCalRate() throws AllocateException, BOSException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected boolean checkNoAllocStdData(IFeeInfo currFee) throws AllocateException {
        IRowSet rs;
        boolean hasNoAllocStdData;
        block7: {
            Context ctx = (Context)this._param.get("ctx");
            hasNoAllocStdData = false;
            StringBuffer sb = new StringBuffer();
            sb.append("Select top 1 FQty ").append("FROM ").append(this.getTblAllocData()).append(" ").append("WHERE FQty <> 0 ");
            rs = null;
            try {
                rs = NCMDbUtil.executeQuery((Context)ctx, (String)sb.toString());
                if (rs.next()) break block7;
                hasNoAllocStdData = true;
                String[] hint = this._ausCtx.GetNoAllocStdDataHint();
                if (!this._param.containsKey("allocStdID")) {
                    this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_NO_ALLOCSTDDATA, new Object[]{currFee.GetNumber(), currFee.GetEntrySeq(), this.getAllocStd().getName()}), hint[0], hint[1]);
                    break block7;
                }
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_NO_ALLOCSTDDATA, new Object[]{currFee.GetNumber(), currFee.GetEntrySeq(), this.getAllocStd().getName()}), this.getAllocStd().getName() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"22_BaseAllocator", (Locale)ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"23_BaseAllocator", (Locale)ctx.getLocale()));
            }
            catch (BOSException e) {
                log.error((Object)"", (Throwable)e);
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
                SQLUtils.cleanup((ResultSet)rs);
            }
            catch (SQLException e2) {
                log.error((Object)"", (Throwable)e2);
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e2), null, null);
                {
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)rs);
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return hasNoAllocStdData;
    }

    protected boolean saveAllocResult(IFeeInfo currFee) throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        String userId = this._param.get("userId").toString();
        Context ctx = (Context)this._param.get("ctx");
        String allocStdStr = this.getAllocStd().getId().toString();
        boolean cancelAlloc = true;
        String sqlInsert = this.GetSql_InsertIndirectData(companyId, periodId, userId, allocStdStr, currFee);
        String sqlAdjustDiff = this.GetSql_AdjustDiff(currFee);
        try {
            NCMDbUtil.BatchSqlExecute((Context)ctx, (String)(sqlInsert + '\n' + sqlAdjustDiff), (String)";");
        }
        catch (BOSException e) {
            log.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        cancelAlloc = false;
        return cancelAlloc;
    }

    @Override
    public void commitAllocResult(boolean isLastBatch) throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        Context ctx = (Context)this._param.get("ctx");
        if (isLastBatch) {
            this.updateDefaultCostItem(ctx, companyId, periodId);
            this.removeNoCostItem(ctx, companyId, periodId);
        }
    }

    protected String GetAdjustUserId() {
        return null;
    }

    @Override
    public void processAllocateException(AllocateException e, String possibleReason, String adviceHandle) throws AllocateException {
        throw e;
    }

    protected abstract void InsertDirectData(Context var1, String var2, String var3, String var4) throws AllocateException;

    protected abstract String GetSql_InsertIndirectData(String var1, String var2, String var3, String var4, IFeeInfo var5) throws AllocateException;

    protected abstract boolean IsOnlyNotZero_AllcoStdData();

    protected abstract String GetSql_AdjustDiff(IFeeInfo var1) throws AllocateException;

    protected abstract void updateDefaultCostItem(Context var1, String var2, String var3) throws AllocateException;

    protected abstract void removeNoCostItem(Context var1, String var2, String var3) throws AllocateException;

    protected abstract void removeInvalidCostObject(Context var1, String var2, String var3) throws AllocateException;

    @Override
    public AllocTable getAllocTable() throws AllocateException {
        return this._allocTable;
    }

    public void setAllocTable(AllocTable table) {
        this._allocTable = table;
    }

    public FeeData getFeeData() {
        return this._feeData;
    }

    public void setFeeData(FeeData data) {
        this._feeData = data;
    }

    public AllocStdInfo getAllocStd() {
        return this._allocStd;
    }

    public void setAllocStd(AllocStdInfo allocStd) throws AllocateException {
        Assert.that((allocStd != null ? 1 : 0) != 0);
        Assert.that((this._ausCtx != null ? 1 : 0) != 0);
        String formulaForParse = allocStd.getFormulaForParse();
        this._ausCtx.setStrategyContext(formulaForParse, this.getAllocTable());
        this._allocStd = allocStd;
        this.setTblAllocData(null);
    }

    public String getTblAllocData() throws AllocateException {
        Assert.that((this.getAllocStd() != null ? 1 : 0) != 0);
        Assert.that((this._ausCtx != null ? 1 : 0) != 0);
        Assert.that((this.getAllocTable() != null ? 1 : 0) != 0);
        if (this._tblAllocData == null) {
            this.setTblAllocData(this.getAllocTable().GetAllocDataTable(this._ausCtx.GetFieldListForCreateTbl()));
        }
        return this._tblAllocData;
    }

    public void setTblAllocData(String tblAllocData) {
        this._tblAllocData = tblAllocData;
    }

    public String getTblAllocObjectRange() throws AllocateException {
        if (this._tblAllocObjectRange == null) {
            this._tblAllocObjectRange = this.getAllocTable().GetObjectRangeTable();
        }
        return this._tblAllocObjectRange;
    }

    public void setTblAllocObjectRange(String tblAllocObjectRange) {
        this._tblAllocObjectRange = tblAllocObjectRange;
    }

    public String getTblResult() throws AllocateException {
        if (this._tblResult == null) {
            this._tblResult = this.getAllocTable().GetResultTable();
        }
        return this._tblResult;
    }

    public void setTblResult(String tblResult) {
        this._tblResult = tblResult;
    }
}

