/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.OtherFeeBillCollection;
import com.kingdee.eas.ncm.bill.OtherFeeBillFactory;
import com.kingdee.eas.ncm.bill.OtherFeeBillInfo;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.AUSContext;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.BaseAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.CCOFeeData;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.FeeData;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.Info.CCOFeeInfoAdapter;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.Info.IFeeInfo;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.AllocTable;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.CCOAllocTable;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class CCOAllocator
extends BaseAllocator {
    private static Logger logger = Logger.getLogger((String)CCOAllocator.class.getName());
    private int costObjectOfBillRequired = -1;
    private String shareCostObjectID = null;

    public CCOAllocator(Map param, AUSContext ausCtx) {
        super(param, ausCtx);
    }

    @Override
    public AllocTable getAllocTable() throws AllocateException {
        if (super.getAllocTable() == null) {
            Context ctx = (Context)this._param.get("ctx");
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            this._param.put("pool", pool);
            this.setAllocTable(new CCOAllocTable(this._param));
        }
        return super.getAllocTable();
    }

    @Override
    public FeeData GetFeeDataControl() throws AllocateException {
        if (this.getFeeData() == null) {
            this.setFeeData(new CCOFeeData(this._param));
        }
        return super.getFeeData();
    }

    @Override
    protected boolean hasDirectCostCenterReqFee() throws AllocateException {
        return false;
    }

    @Override
    protected boolean hasAssistantCostCenterReqFee() throws AllocateException {
        return false;
    }

    @Override
    protected void InsertDirectData(Context ctx, String companyId, String periodId, String userId) throws AllocateException {
    }

    @Override
    protected String GetSql_InsertIndirectData(String companyId, String periodId, String userId, String allocStdId, IFeeInfo currFee) throws AllocateException {
        StringBuffer sb = new StringBuffer();
        NumberFormat fm = NumberFormat.getInstance();
        fm.setGroupingUsed(false);
        fm.setMaximumFractionDigits(currFee.GetQtyPrecision());
        String strQty = fm.format(currFee.GetQty());
        fm.setMaximumFractionDigits(currFee.GetAmountPrecision());
        String strAmount = fm.format(currFee.GetAmount());
        fm.setMaximumFractionDigits(currFee.GetPricePrecision());
        String strPrice = fm.format(BigDecimal.valueOf(0L));
        if (!fm.format(currFee.GetQty()).equals(BigDecimal.valueOf(0L).toString())) {
            strPrice = fm.format(currFee.GetAmount().divide(currFee.GetQty(), currFee.GetPricePrecision(), 4));
        }
        String sourceCCID = "";
        String departmentID = "";
        if (currFee instanceof CCOFeeInfoAdapter) {
            sourceCCID = ((CCOFeeInfoAdapter)currFee).GetSourceCostCenterId();
            departmentID = ((CCOFeeInfoAdapter)currFee).GetDepartmentId();
        }
        sb.append("INSERT INTO {0}(FID,FCompanyID,FCalculatePeriodID,FCostCenterGroupID,FCostCenterID,").append('\n').append("FSourceBillID,FSourceBillEntryID,FExpenseID,FCostItemID,FAllocStdID,").append('\n').append("FAllocStdData,FQty,FPrice,FAmount,FCreatorID,FCreateTime,FAdjustUserID,FAdjustTime,FIsDirect,FSourceCostCenterID,FDepartmentID )").append('\n').append("SELECT newbosid(''474CFD96'') AS FID, ''{1}'' As FCompanyID, ''{2}'' As FCalculatePeriodID, ''{3}'' As FCostCenterGroupID,R.FCostCenterID,").append('\n').append("''{4}'' As FSourceBillID,''{5}'' As FSourceBillEntryID, ''{6}'' As FExpenseID, ''{7}'' As FCostItemID, ''{8}'' As FAllocStdID,").append('\n').append("D.FQty As FAllocStdData, ROUND({9} * D.FRatio,{10})As FQty,{11} As FPrice, ROUND({12} * D.FRatio,{13})As FAmount,").append('\n').append("''{14}'' As FCreatorID, GetDate() As FCreateTime, ''{15}'' as FAdjustUserID, GetDate() as FAdjustTime, 0 As FIsDirect, ").append('\n').append("''").append(sourceCCID).append("'',''").append(departmentID).append("'' ").append('\n').append("FROM {16} R ").append('\n').append("INNER JOIN {17} D ON D.FID=R.FID ").append('\n').append("WHERE R.FIsValid =1 ");
        if (this.IsOnlyNotZero_AllcoStdData()) {
            sb.append(" AND D.FRatio <>0 ");
        }
        sb.append(";");
        String costCenterGroupId = currFee.GetCostCenterGroupId();
        String costItemId = currFee.GetCostItemId();
        String expenseId = currFee.GetExpenseId();
        String sqlInsert = MessageFormat.format(sb.toString(), this.getTblResult(), companyId, periodId, costCenterGroupId, currFee.GetId(), currFee.GetEntryId(), expenseId, costItemId, this.getAllocStd().getId().toString(), strQty, String.valueOf(currFee.GetQtyPrecision()), strPrice, strAmount, String.valueOf(currFee.GetAmountPrecision()), userId, this.GetAdjustUserId(), this.getTblAllocObjectRange(), this.getTblAllocData());
        return sqlInsert;
    }

    @Override
    protected String GetSql_AdjustDiff(IFeeInfo currFee) throws AllocateException {
        NumberFormat fm = NumberFormat.getInstance();
        fm.setGroupingUsed(false);
        fm.setMaximumFractionDigits(currFee.GetQtyPrecision());
        String strQty = fm.format(currFee.GetQty());
        fm.setMaximumFractionDigits(currFee.GetAmountPrecision());
        String strAmount = fm.format(currFee.GetAmount());
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE {0} SET FQty=(FQty + {1} - ").append('\n').append("\t(SELECT ISNULL(SUM(S.FQty),0.00) ").append('\n').append("\tFROM {2} S").append('\n').append("\tWHERE S.FSourceBillID=''{3}'' AND S.FSourceBillEntryID=''{4}'')").append('\n').append(")").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom {5} ").append('\n').append("\tWHERE FSourceBillID=''{6}'' AND FSourceBillEntryID=''{7}'' ").append('\n').append("\tORDER BY FAllocStdData DESC ").append('\n').append(");");
        String sqlAdjustQty = MessageFormat.format(sb.toString(), this.getTblResult(), strQty, this.getTblResult(), currFee.GetId(), currFee.GetEntryId(), this.getTblResult(), currFee.GetId(), currFee.GetEntryId());
        sb.delete(0, sb.length());
        sb.append("UPDATE {0} SET FAmount=(FAmount + {1} - ").append('\n').append("\t(SELECT ISNULL(SUM(S.FAmount),0.00) ").append('\n').append("\tFROM {2} S").append('\n').append("\tWHERE S.FSourceBillID=''{3}'' AND S.FSourceBillEntryID=''{4}'')").append('\n').append(")").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom {5} ").append('\n').append("\tWHERE FSourceBillID=''{6}'' AND FSourceBillEntryID=''{7}'' ").append('\n').append("\tORDER BY FAllocStdData DESC ").append('\n').append(");");
        String sqlAdjustAmount = MessageFormat.format(sb.toString(), this.getTblResult(), strAmount, this.getTblResult(), currFee.GetId(), currFee.GetEntryId(), this.getTblResult(), currFee.GetId(), currFee.GetEntryId());
        sb.delete(0, sb.length());
        String sqlUpdatePrice_Zero = MessageFormat.format("UPDATE {0} SET FPrice=0 WHERE FSourceBillID=''{1}'' AND FSourceBillEntryID=''{2}'' AND FQty=0 ;", this.getTblResult(), currFee.GetId(), currFee.GetEntryId());
        return sqlAdjustQty + '\n' + sqlAdjustAmount + '\n' + sqlUpdatePrice_Zero;
    }

    @Override
    protected void updateDefaultCostItem(Context ctx, String companyId, String periodId) throws AllocateException {
    }

    @Override
    protected void removeNoCostItem(Context ctx, String companyId, String periodId) throws AllocateException {
    }

    @Override
    protected void removeInvalidCostObject(Context ctx, String companyId, String periodId) throws AllocateException {
    }

    @Override
    protected boolean IsOnlyNotZero_AllcoStdData() {
        return true;
    }

    @Override
    public Map processResult() throws AllocateException {
        if (this._param.get("isForAllocate") != null && "true".equals(this._param.get("isForAllocate").toString())) {
            try {
                if (this.saveDataInOtherFeeBill()) {
                    return new HashMap();
                }
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return null;
    }

    private boolean saveDataInOtherFeeBill() throws AllocateException, BOSException {
        String id;
        String tempResTable = this.getTblResult();
        String tblToAlloc = this.getAllocTable().GetToAllocBillEntryIDTable();
        Context ctx = (Context)this._param.get("ctx");
        String tblName = ((CCOAllocTable)this.getAllocTable()).getCCOAllocTempTable(ctx);
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(tblName).append(" (FID) ").append('\n').append("\tselect b.FID from T_NCM_OtherFeeBill a, T_NCM_CCOFeeBillEntry b ").append('\n').append("\t\twhere a.FSourceBillID=b.fid and a.FFivouchered=1;").append('\n').append('\n');
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, tblName);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        String tblName2 = ((CCOAllocTable)this.getAllocTable()).getCCOAllocTempTable2(ctx);
        try {
            sql.append("INSERT INTO ").append(tblName2).append(" (FID) SELECT FID FROM T_NCM_OtherFeeBillEntry ").append('\n').append("\twhere exists(select 1 from {0} s, T_NCM_OtherFeeBill m ").append('\n').append("\t\twhere s.FSourceBillEntryID=T_NCM_OtherFeeBillEntry.FParentID ").append('\n').append("\t\t\tAND m.fid=T_NCM_OtherFeeBillEntry.FParentID ").append('\n').append("\t\t\tAND M.FFivouchered<>1  and m.FSourceBillID not in ").append('\n').append("\t\t\t\t(select FID from ").append(tblName).append("));").append('\n').append('\n');
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, tblName2);
            sql.append("DELETE FROM T_NCM_OtherFeeBillEntry WHERE FID IN (SELECT FID FROM ").append(tblName2).append(");").append('\n').append('\n');
            sql.append("DELETE FROM ").append(tblName2).append(";").append('\n');
            sql.append("INSERT INTO ").append(tblName2).append(" (FID) SELECT FID FROM T_NCM_OtherFeeBill ").append('\n').append("\twhere exists(select 1 from {1} s ").append('\n').append("\t\twhere s.FSourceBillEntryID=T_NCM_OtherFeeBill.FID ").append('\n').append("\t\t\tand FFivouchered<>1  and FSourceBillID not in ").append('\n').append("\t\t\t\t(select FID from ").append(tblName).append("));").append('\n');
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, tblName2);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        sql.append("DELETE FROM T_NCM_OtherFeeBill WHERE FID IN (SELECT FID FROM ").append(tblName2).append(");").append('\n');
        String sqlDelOldDataInOtherFeeBill = MessageFormat.format(sql.toString(), tblToAlloc, tblToAlloc);
        sql.delete(0, sql.length());
        sql.append("Insert into T_NCM_OtherFeeBill(FID, FNumber, FCompanyOrg, FCalculatePeriod, ").append('\n').append(" FCostCenterID, FDepartmentID, FSourceBillID, FCreatorID, FCreateTime,").append('\n').append(" FLastUpdateUserID, FLastUpdateTime, FControlUnitID,").append('\n').append(" FBizDate,FHasEffected, FAuditorID,FAuditTime,FAllocStdID,").append('\n').append(" FBillStatus, FIsAuto, FFivouchered,FSourceFunction, FFetchSource,FSourceCostCenterID)").append('\n').append(" select tt.FID, ''testAlloc'' as FNumber, tt.FCompanyID as FCompanyOrg, tt.FCalculatePeriodID as FCalculatePeriod, ").append('\n').append(" tt.FCostCenterID, cc.FDepartmentID, tt.FSourceBillEntryID as FSourceBillID, tt.FCreatorID, tt.FCreateTime,").append('\n').append(" tt.FCreatorID as FLastUpdateUserID, tt.FCreateTime as FLastUpdateTime, FControlUnitID as FControlUnitID,").append('\n').append(" cc.FBizDate as FBizDate, 1 as FHasEffected, tt.FCreatorID as FAuditorID, tt.FCreateTime as FAuditTime,tt.FAllocStdID,").append('\n').append(" 4 as FBillStatus, 1 as FIsAuto, 0 as FFivouchered,''").append(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"238_CCOAllocator", (Locale)ctx.getLocale())).append("''''''||cc.FNumber||''''''").append(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"239_CCOAllocator", (Locale)ctx.getLocale())).append("''||TO_CHAR(ce.FSeq)||''").append(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"240_CCOAllocator", (Locale)ctx.getLocale())).append("'',3 as FFetchSource, cc.FSourceCostCenterID \n").append('\n').append(" from T_NCM_CCOFeeBill cc, T_NCM_CCOFeeBillEntry ce, {0} tt").append('\n').append(" where cc.FID = ce.FParentID and cc.FID = tt.FSourceBillID and ce.FID = tt.FSourceBillEntryID and  ").append("not exists (select b.FID from T_NCM_OtherFeeBill a, T_NCM_CCOFeeBillEntry b where a.FSourceBillID=b.fid and a.FSourceBillID = ce.fid and  a.FFivouchered=1);");
        String sqlInsertOtherFeeBillHeader = MessageFormat.format(sql.toString(), tempResTable);
        sql.delete(0, sql.length());
        String coField = "";
        String coFieldValue = "";
        if (this.isCostObjectOfBillRequired(ctx, this._param.get("companyId").toString()) && (id = this.getShareCostObjectID(ctx)) != null && id.length() > 0) {
            coField = ", FCostObjectID";
            coFieldValue = ", ''" + id + "''";
        }
        sql.append("Insert into T_NCM_OtherFeeBillEntry(FID, FSeq, FParentID, FCostItemID, FAmount, FQty, FPrice,FExpenseID, FAllocStdData" + coField + ")").append('\n').append("select newbosid(''2640287C'') as FID, 1 as FSeq, FID as FParentID, FCostItemID, FAmount, FQty, FPrice,FExpenseID, FAllocStdData" + coFieldValue).append('\n').append("  from {0} T where  not exists  (select b.FID from T_NCM_OtherFeeBill a, T_NCM_CCOFeeBillEntry b where T.FSourceBillID = a.FSourceBillID and a.FSourceBillID=b.fid and a.FFivouchered=1);");
        String sqlInsertOtherFeeBillEntry = MessageFormat.format(sql.toString(), tempResTable);
        sql.delete(0, sql.length());
        sql.append("update T_NCM_CCOFeeBillEntry set FIsAlloced=1 ").append('\n').append("where exists(select 1 from T_NCM_CCOFeeBill cc, {0} tt").append('\n').append("              where cc.FID = T_NCM_CCOFeeBillEntry.FParentID and cc.FID = tt.FSourceBillID and T_NCM_CCOFeeBillEntry.FID = tt.FSourceBillEntryID);").append('\n');
        String sqlSetAlloced = MessageFormat.format(sql.toString(), tempResTable);
        sql.delete(0, sql.length());
        boolean allocSuccess = false;
        try {
            NCMDbUtil.BatchSqlExecute((Context)ctx, (String)(sqlDelOldDataInOtherFeeBill + '\n' + sqlInsertOtherFeeBillHeader + '\n' + sqlInsertOtherFeeBillEntry + '\n' + sqlSetAlloced), (String)";");
            allocSuccess = this.updateOtherFeeBillNumberAndSeq(ctx, tempResTable, this._param.get("companyId").toString());
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        return allocSuccess;
    }

    @Override
    public void preProcess() throws AllocateException {
        try {
            this.getFeeData().clearPreAllocResult(this.getAllocTable().GetResultTable());
        }
        catch (Exception e) {
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
        this.fillObjectRange();
        this.getAllocTable().CreateTempTableIndexs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fillObjectRange() throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        Context ctx = (Context)this._param.get("ctx");
        String tblObjRange = this.getAllocTable().GetObjectRangeTable();
        Connection conn = null;
        try {
            NCMDbUtil.execute((Context)ctx, (String)("truncate table " + tblObjRange));
            String tblBalance = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_Balance");
            StringBuffer kSql = new StringBuffer();
            kSql.append(" INSERT INTO " + tblObjRange).append('\n');
            kSql.append(" \t\t(FID,FCostCenterID,FCostObjectID,FMaterialID,FIsValid)").append('\n');
            kSql.append(" SELECT NEWBOSID('08F65F4A') AS FId, coData.FCostCenterOrgUnitID,coData.FCostObjectID,coData.FMaterialID,1 ").append('\n');
            kSql.append("   FROM (").append('\n');
            kSql.append("          select data.FCostCenterOrgUnitID as FCostCenterOrgUnitID,data.FCostObjectID,data.FMaterialID,sum(data.FQty) as FQty from (").append('\n');
            kSql.append("\t          SELECT DISTINCT B.FCostCenterOrgUnitID,E.FCostObjectID,co.FStdProductIDID as FMaterialID,E.FQty as FQty").append('\n');
            kSql.append("\t            FROM T_NCM_InputQtyBill B ").append('\n');
            kSql.append("\t                 RIGHT OUTER JOIN T_NCM_InputQtyBillEntry E ON B.FID = E.FParentID ").append('\n');
            kSql.append("\t\t\t    left join t_bd_costObject co on co.FID = E.FCostObjectID ").append('\n');
            kSql.append("\t           WHERE B.FBillStatus=4 AND B.FCompanyOrg = ? AND B.FCalculatePeriod = ? ").append('\n');
            kSql.append("\t          UNION ").append('\n');
            kSql.append("\t          SELECT DISTINCT BB.FCostCenterID As FCostCenterOrgUnitID,BB.FCostObjectID,co2.FStdProductIDID,BB.FBopWIPQty As FQty ").append('\n');
            kSql.append("\t            FROM " + tblBalance + " BB ").append('\n');
            kSql.append("\t    \t\tleft join t_Bd_CostObject co2 on co2.FID = BB.FCostObjectID ").append('\n');
            kSql.append("\t           WHERE BB.FCompanyOrg = ? AND BB.FCalculatePeriodID = ? ").append('\n');
            kSql.append("            ) as data ").append('\n');
            kSql.append("           group by data.FCostCenterOrgUnitID,data.FCostObjectID,data.FMaterialID").append('\n');
            kSql.append("         ) As coData ").append('\n');
            kSql.append("         INNER JOIN  ").append('\n');
            kSql.append("         (").append('\n');
            kSql.append("\t       SELECT DISTINCT E.FCostCenterOrgUnitID ").append('\n');
            kSql.append("\t         FROM T_NCM_CCOFeeBill B ").append('\n');
            kSql.append("\t              LEFT OUTER JOIN T_NCM_CostCenterGroupEntry E ON B.FCostCenterGroupID = E.FParentID ").append('\n');
            kSql.append("\t       WHERE B.FBillStatus=4 AND B.FCompanyOrg = ? AND B.FCalculatePeriod = ? ").append('\n');
            kSql.append("          ) As ccData ").append('\n');
            kSql.append("          ON coData.FCostCenterOrgUnitID = ccData.FCostCenterOrgUnitID ").append('\n');
            kSql.append("   where coData.FQty <> 0 ").append('\n');
            NCMDbUtil.execute((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{companyId, periodId, companyId, periodId, companyId, periodId});
            kSql.delete(0, kSql.length());
            kSql.append("INSERT INTO ").append(tblObjRange).append(" (FID,FCostCenterID,FIsValid)").append('\n').append("SELECT newbosid('08F65F4A') AS FId, FCostCenterOrgUnitID, FIsValid ").append('\n').append("FROM (").append('\n').append("\tSELECT DISTINCT E.FCostCenterOrgUnitID,1 As FIsValid ").append('\n').append("\tFROM T_NCM_CCOFeeBill B ").append('\n').append("\tLEFT OUTER JOIN T_NCM_CostCenterGroupEntry E ON B.FCostCenterGroupID = E.FParentID ").append('\n').append("   inner join (select FCostCenterID from (").append('\n').append("         select bill.FCostCenterID as FCostCenterID,sum(bill.FQty) as FQty from (").append('\n').append("\t          SELECT B.FCostCenterOrgUnitID as FCostCenterID,sum(Be.FQty) as FQty ").append('\n').append("\t            FROM T_NCM_InputQtyBill B ").append('\n').append("               inner join T_NCM_InputQtyBillEntry Be on B.Fid = Be.FParentID ").append('\n').append("\t           WHERE B.FBillStatus=4 AND B.FCompanyOrg = ? AND B.FCalculatePeriod = ? ").append('\n').append("              group by B.FCostCenterOrgUnitID").append('\n').append("\t          UNION ").append('\n').append("\t          SELECT BB.FCostCenterID As FCostCenterID, sum(BB.FBopWIPQty) as FQty ").append('\n').append("\t            FROM " + tblBalance + " BB ").append('\n').append("\t          WHERE BB.FCompanyOrg = ? AND BB.FCalculatePeriodID = ? and bb.FBopWipQty >0 ").append("             group by BB.FCostCenterID ").append('\n').append("             ) as bill").append('\n').append("             group by FCostCenterID ").append('\n').append("             union ").append('\n').append("             select cc.Fid as FCostCenterID , 1 as FQty ").append('\n').append("               FROM t_org_costcenter cc ").append('\n').append("               inner join T_ORG_UnitRelation re on cc.Fid = re.fFromunitID ").append('\n').append("               inner join T_ORG_TypeRelation ty on re.Ftyperelationid = ty.fid ").append('\n').append("             where ty.FfromType ='5' and ty.Ftotype = '1' and re.fTounitID = ? ").append('\n').append("                   and cc.Fcostcentertype = '1' ").append('\n').append("               ").append("         ) as data ").append('\n').append("         where data.FQty <> 0 ").append('\n').append("     ) as cc on  cc.FCostCenterID = E.FCostCenterOrgUnitID ").append('\n').append("\tWHERE B.FBillStatus=4 AND B.FCompanyOrg = ? AND B.FCalculatePeriod = ? ").append('\n').append(") As A ");
            NCMDbUtil.execute((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{companyId, periodId, companyId, periodId, companyId, companyId, periodId});
            conn = EJBFactory.getConnection((Context)ctx);
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, tblObjRange);
            SQLUtils.cleanup((Connection)conn);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        finally {
            SQLUtils.cleanup(conn);
        }
    }

    @Override
    protected boolean crossCostObjectSuiteRange(IFeeInfo currFee) throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        Context ctx = (Context)this._param.get("ctx");
        String costCenterGroupId = currFee.GetCostCenterGroupId();
        String tblObjRange = this.getAllocTable().GetObjectRangeTable();
        String sqlInit = "UPDATE " + tblObjRange + " SET FIsValid = 0 ";
        StringBuffer sb = new StringBuffer();
        boolean cancelAlloc = true;
        this.bRangeChanged = false;
        if (!(this.lastCostObjectSuiteId == null && costCenterGroupId == null || this.lastCostObjectSuiteId != null && this.lastCostObjectSuiteId.equals(costCenterGroupId))) {
            sb.append("UPDATE ").append(tblObjRange).append(" SET (FIsValid)=(").append('\n').append("\tSELECT 1").append('\n').append("\tFROM T_NCM_CostCenterOrgUnitGroup S").append('\n').append("\tRIGHT OUTER JOIN T_NCM_CostCenterGroupEntry E ON S.FID = E.FParentID").append('\n').append("\tWHERE S.FID = '").append(costCenterGroupId).append("' AND S.FCompanyOrgUnitID = '").append(companyId).append("' AND E.FCostCenterOrgUnitID = ").append(tblObjRange).append(".FCostCenterID").append('\n').append(") WHERE exists (select 1 from T_NCM_CostCenterGroupEntry a where FCostCenterID = a.FCostCenterOrgUnitID AND a.FParentID=?)");
            Object[] params = new Object[]{costCenterGroupId};
            try {
                NCMDbUtil.execute((Context)ctx, (String)sqlInit);
                NCMDbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])params);
                cancelAlloc = false;
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
            }
            this.lastCostObjectSuiteId = costCenterGroupId;
            this.bRangeChanged = true;
        }
        cancelAlloc = false;
        if (costCenterGroupId != null && !"".equals(costCenterGroupId)) {
            sb.delete(0, sb.length());
            sb.append("Select top 1 FID ").append("FROM ").append(tblObjRange).append(" ").append("WHERE FIsValid = 1 ");
            try {
                IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sb.toString());
                if (!rs.next()) {
                    cancelAlloc = true;
                    this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_INVALID_COSTCENTERGROUP, new Object[]{currFee.GetNumber(), currFee.GetEntrySeq(), currFee.GetCostCenterGroupNumber()}), null, null);
                }
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e), null, null);
            }
        } else {
            sb.delete(0, sb.length());
            sb.append("Select top 1 FID ").append("FROM ").append(tblObjRange).append(" ").append("WHERE FIsValid = 1 ");
            try {
                IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sb.toString());
                if (!rs.next()) {
                    cancelAlloc = true;
                    this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_INVALID_COSTOBJ_CC, new Object[]{currFee.GetNumber(), currFee.GetEntrySeq(), currFee.GetCostCenterName()}), null, null);
                }
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e), null, null);
            }
        }
        return cancelAlloc;
    }

    @Override
    protected boolean dataIsVouchered(IFeeInfo currFee) throws AllocateException {
        boolean isVouchered = true;
        Context ctx = (Context)this._param.get("ctx");
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("Select TOP 1 fid From T_NCM_OtherFeeBill ").append(" Where FSourceBillID = ?  And FFivouchered = 1");
        Object[] params = new Object[]{currFee.GetEntryId()};
        try {
            IRowSet voucheredRS = NCMDbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])params);
            if (voucheredRS.size() > 0) {
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_DATAISVOUCHERED, new Object[]{currFee.GetNumber(), currFee.GetEntrySeq()}), ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"25_CCOAllocator", (Locale)ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"26_CCOAllocator", (Locale)ctx.getLocale()));
            } else {
                isVouchered = false;
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return isVouchered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateOtherFeeBillNumberAndSeq(Context ctx, String tempResTable, String companyID) throws BOSException {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
        if (conn == null) {
            return false;
        }
        StringBuffer sb = new StringBuffer();
        PreparedStatement pstmtUpdateBill = null;
        PreparedStatement pstmtUpdateEntry = null;
        boolean allocSuccess = true;
        try {
            sb.append("select distinct FID from " + tempResTable + " order by FID;");
            IRowSet _Data = NCMDbUtil.executeQuery((Context)ctx, (String)sb.toString());
            sb.delete(0, sb.length());
            if (_Data != null && _Data.size() > 0) {
                ArrayList<String> idList = new ArrayList<String>();
                _Data.first();
                while (_Data.getRow() > 0 && !_Data.isAfterLast()) {
                    idList.add(_Data.getString("FID"));
                    _Data.next();
                }
                Map codingRuleNumber = this.getDispNumber(ctx, companyID, idList);
                String ids = "";
                String id = null;
                sb.append("update T_NCM_OtherFeeBill set FNumber = ? where FID = ?");
                pstmtUpdateBill = conn.prepareStatement(sb.toString());
                sb.delete(0, sb.length());
                for (int i = 0; i < idList.size(); ++i) {
                    id = (String)idList.get(i);
                    ids = ids + "'" + (i < idList.size() - 1 ? id + "', " : id + "'");
                    pstmtUpdateBill.setString(1, codingRuleNumber.get(id).toString());
                    pstmtUpdateBill.setString(2, id);
                    pstmtUpdateBill.addBatch();
                }
                pstmtUpdateBill.executeBatch();
                sb.append("select FParentID,FID from T_NCM_OtherFeeBillEntry where FParentID in (" + ids + ") order by FParentID,FID;");
                _Data = NCMDbUtil.executeQuery((Context)ctx, (String)sb.toString());
                sb.delete(0, sb.length());
                String sql = "update T_NCM_OtherFeeBillEntry set FSeq = ? where FID = ?";
                if (_Data != null && _Data.size() > 0) {
                    String FParentID = null;
                    String FID = null;
                    HashMap billMap = new HashMap();
                    _Data.first();
                    while (_Data.getRow() > 0 && !_Data.isAfterLast()) {
                        FParentID = _Data.getString("FParentID");
                        FID = _Data.getString("FID");
                        if (billMap.containsKey(FParentID)) {
                            ((List)billMap.get(FParentID)).add(FID);
                        } else {
                            ArrayList<String> entryList = new ArrayList<String>();
                            entryList.add(FID);
                            billMap.put(FParentID, entryList);
                        }
                        _Data.next();
                    }
                    pstmtUpdateEntry = conn.prepareStatement("update T_NCM_OtherFeeBillEntry set FSeq = ? where FID = ?");
                    List tempList = null;
                    for (int i = 0; i < billMap.size(); ++i) {
                        tempList = (List)billMap.get(FParentID);
                        for (int j = 0; j < tempList.size(); ++j) {
                            pstmtUpdateEntry.setBigDecimal(1, new BigDecimal(j + 1));
                            pstmtUpdateEntry.setString(2, (String)tempList.get(j));
                            pstmtUpdateEntry.addBatch();
                        }
                    }
                    pstmtUpdateEntry.executeBatch();
                }
            } else {
                allocSuccess = false;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        catch (AllocateException e) {
            logger.error((Object)"", (Throwable)((Object)e));
        }
        finally {
            SQLUtils.cleanup(pstmtUpdateBill);
            SQLUtils.cleanup(pstmtUpdateEntry);
            SQLUtils.cleanup((Connection)conn);
        }
        return allocSuccess;
    }

    private Map getDispNumber(Context ctx, String companyId, List idList) throws AllocateException {
        block8: {
            if (idList != null && idList.size() > 0) {
                try {
                    ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                    if (codingRuleManager.isExist((IObjectValue)new OtherFeeBillInfo(), companyId)) {
                        StringBuffer ids = new StringBuffer();
                        for (int i = 0; i < idList.size(); ++i) {
                            ids.append("'");
                            ids.append(idList.get(i).toString());
                            ids.append("'");
                            if (i >= idList.size() - 1) continue;
                            ids.append(",");
                        }
                        OtherFeeBillCollection coll = OtherFeeBillFactory.getLocalInstance(ctx).getOtherFeeBillCollection("select id where id in(" + ids + ")");
                        if (coll != null && coll.size() > 0) {
                            HashMap<String, String> numbers = new HashMap<String, String>();
                            OtherFeeBillInfo info = null;
                            for (int i = 0; i < coll.size(); ++i) {
                                info = coll.get(i);
                                numbers.put(info.getId().toString(), codingRuleManager.getNumber((IObjectValue)info, companyId));
                            }
                            return numbers;
                        }
                        break block8;
                    }
                    throw new AllocateException(AllocateException.ITEM_ALLOC_NOCODINGRULE);
                }
                catch (BOSException e) {
                    logger.error((Object)"", (Throwable)e);
                    throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
                }
                catch (EASBizException e) {
                    logger.error((Object)"", (Throwable)e);
                    throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
                }
            }
        }
        return null;
    }

    @Override
    protected boolean updateAllocDataTable() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        boolean cancelAlloc = true;
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(this._ausCtx.GetAllocStdUnitDataSql()).append('\n');
            if (sb.length() <= 1) {
                return false;
            }
            NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sb.toString());
            sb.delete(0, sb.length());
            if (this._ausCtx.isCostObjectLevelForCCAlloc()) {
                String[] columns = this._ausCtx.getColumns();
                StringBuffer updateList = new StringBuffer();
                StringBuffer dataList = new StringBuffer();
                StringBuffer zeroList = new StringBuffer();
                StringBuffer whereList = new StringBuffer();
                for (int i = 0; i < columns.length; ++i) {
                    String column = columns[i];
                    updateList.append(column);
                    dataList.append("isnull(tt.").append(column).append(",0)+ isnull(dd.").append(column).append(",0)");
                    zeroList.append(column).append("=0");
                    whereList.append("tt.").append(column).append("<>0");
                    if (i == columns.length - 1) continue;
                    updateList.append(",");
                    dataList.append(",");
                    zeroList.append(",");
                    whereList.append(" or ");
                }
                sb.append(" UPDATE ").append(this.getTblAllocData()).append(" as tt ").append('\n').append(" SET (").append(updateList).append(") = (").append('\n').append("select ").append(dataList).append('\n').append("  from ").append(this.getTblAllocData()).append(" dd ").append('\n').append(" where tt.FCostCenterID = dd.FCostCenterID and dd.FCostObjectID is null").append('\n').append(") WHERE tt.FCostObjectID is not null ").append('\n').append("   and (").append(whereList).append(");").append('\n');
                NCMDbUtil.execute((Context)ctx, (String)sb.toString());
                sb.delete(0, sb.length());
                sb.append(" UPDATE ").append(this.getTblAllocData()).append('\n').append(" SET ").append(zeroList).append('\n').append(" WHERE FCostCenterID in ").append('\n').append("(select tt.FCostCenterID from ").append(this.getTblAllocData()).append(" tt ").append('\n').append(" where tt.FCostObjectID is not null and (").append(whereList).append(")) ").append('\n').append("   and FCostObjectID is null ;").append('\n');
                NCMDbUtil.execute((Context)ctx, (String)sb.toString());
                sb.delete(0, sb.length());
            }
            String isToCenter = null;
            if (this._param.get("IsToCenter") != null) {
                isToCenter = this._param.get("IsToCenter").toString();
            }
            if (isToCenter != null && isToCenter.equals("true")) {
                sb.append(this._ausCtx.GetAllocStdFormulaUpdateSql()).append(";").append('\n');
            } else {
                sb.append(this._ausCtx.GetAllocStdFormulaUpdateSql()).append(" where FCostObjectID is not null;").append('\n');
            }
            sb.append(" UPDATE ").append(this.getTblAllocData()).append(" SET FQty = 0 WHERE FQty < 0;").append('\n');
            NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
            sb.delete(0, sb.length());
            sb.append(" UPDATE ").append(this.getTblAllocData()).append(" SET FQty = FQty+ISNULL((").append("Select sum(tt.FQty) As FQty from ").append(this.getTblAllocData()).append(" tt ").append('\n').append(" where tt.FCostCenterID= ").append(this.getTblAllocData()).append(".FCostCenterID ").append('\n').append("   and tt.FCostObjectID is not null and tt.FQty > 0 ").append('\n').append(" group by tt.FCostCenterID ),0) ").append('\n').append("where FCostObjectID is null;");
            NCMDbUtil.execute((Context)ctx, (String)sb.toString());
            sb.delete(0, sb.length());
            sb.append(" delete from ").append(this.getTblAllocData()).append(" where FCostObjectID is not null;");
            NCMDbUtil.execute((Context)ctx, (String)sb.toString());
            sb.delete(0, sb.length());
            sb.append(" UPDATE ").append(this.getTblAllocData()).append(" SET FRatio = Round(TO_Decimal(FQty,24,12)/").append("\t(").append("\tSelect TO_Decimal(ISNULL(SUM(S.FQty),1),21,8) As FQty").append("\tFROM ").append(this.getTblAllocData()).append(" S ").append("\tWHERE S.FQty > 0 ").append("\tGROUP BY S.FRatio ").append("\tHAVING SUM(S.FQty) <> 0 ").append("\t),12);");
            NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
            cancelAlloc = false;
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        return cancelAlloc;
    }

    @Override
    protected boolean initAllocDataTable() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        String fieldList = this._ausCtx.GetFieldListForQuery();
        String fldAstList = this._ausCtx.GetMergeFormatStr("0 As {0}", ",");
        boolean cancelAlloc = true;
        StringBuffer sb = new StringBuffer();
        sb.append("truncate table ").append(this.getTblAllocData()).append(";").append('\n');
        fieldList = fieldList + "FCostCenterID, FCostObjectID,FMaterialID,";
        fldAstList = fldAstList + "FCostCenterID, FCostObjectID,FMaterialID,";
        sb.append("INSERT INTO ").append(this.getTblAllocData()).append("(FID,").append(fieldList).append("FQty,FRatio)").append('\n').append("Select FID,").append(fldAstList).append("0 As FQty, 0 As FRatio ").append('\n').append("from ").append(this.getTblAllocObjectRange()).append('\n').append("where FIsValid =1 ;");
        try {
            NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
            cancelAlloc = false;
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        return cancelAlloc;
    }

    private boolean isCostObjectOfBillRequired(Context ctx, String companyID) throws AllocateException {
        if (this.costObjectOfBillRequired < 0) {
            this.costObjectOfBillRequired = 0;
            try {
                if (NCMUtils.isCostObjectOfBillRequired((Context)ctx, (String)companyID)) {
                    this.costObjectOfBillRequired = 1;
                }
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
            }
        }
        return this.costObjectOfBillRequired == 1;
    }

    private String getShareCostObjectID(Context ctx) throws AllocateException {
        if (this.shareCostObjectID == null) {
            this.shareCostObjectID = "";
            String companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)"SCOID", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID, CompareType.EQUALS));
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            try {
                CostObjectCollection coll = CostObjectFactory.getLocalInstance((Context)ctx).getCostObjectCollection(view);
                if (coll.size() > 0) {
                    this.shareCostObjectID = coll.get(0).getId().toString();
                }
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
            }
        }
        return this.shareCostObjectID;
    }
}

