/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.AUSContext;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.CostAdjustFeeData;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.FeeData;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.MatAllocator;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class CostAdjustAllocator
extends MatAllocator {
    private static Logger logger = Logger.getLogger((String)CostAdjustAllocator.class.getName());

    public CostAdjustAllocator(Map param, AUSContext ausCtx) {
        super(param, ausCtx);
    }

    @Override
    protected FeeData setFeeData(Map param) {
        return new CostAdjustFeeData(param);
    }

    @Override
    protected String getAllocBillType() {
        return "CA";
    }

    @Override
    protected String setPhsicalTblBill() {
        return "T_CL_CostAdjustBill";
    }

    @Override
    protected String setPhsicalTblEntry() {
        return "T_CL_CostAdjustBillEntry";
    }

    @Override
    protected String setFCostCenterOrgUnitID() {
        return "FCostCenterOrgUnitID";
    }

    @Override
    protected boolean hasDirectCostCenterReqFee() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        StringBuffer ksql = new StringBuffer();
        ksql.append("select top 1 \n");
        ksql.append("    1 \n");
        ksql.append("from " + this.getAllocTable().GetToAllocBillEntryIDTable() + " eids \n");
        ksql.append("join T_CL_CostAdjustBillEntry e on e.FID = eids.FSourceBillEntryID \n");
        ksql.append("join T_CL_CostAdjustBill b on b.FID = e.FParentID \n");
        ksql.append("join T_ORG_CostCenter cc on cc.FID = b.FCostCenterOrgUnitID \n");
        ksql.append("where cc.FCostCenterType = 0 \n");
        try {
            IRowSet rowSet = NCMDbUtil.executeQuery((Context)ctx, (String)ksql.toString());
            boolean result = rowSet.next();
            rowSet.close();
            return result;
        }
        catch (Exception e) {
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
            return false;
        }
    }

    @Override
    protected boolean hasAssistantCostCenterReqFee() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        StringBuffer ksql = new StringBuffer();
        ksql.append("select top 1 \n");
        ksql.append("    1 \n");
        ksql.append("from " + this.getAllocTable().GetToAllocBillEntryIDTable() + " eids \n");
        ksql.append("join T_CL_CostAdjustBillEntry e on e.FID = eids.FSourceBillEntryID \n");
        ksql.append("join T_CL_CostAdjustBill b on b.FID = e.FParentID \n");
        ksql.append("join T_ORG_CostCenter cc on cc.FID = b.FCostCenterOrgUnitID \n");
        ksql.append("where cc.FCostCenterType = 1 \n");
        try {
            IRowSet rowSet = NCMDbUtil.executeQuery((Context)ctx, (String)ksql.toString());
            boolean result = rowSet.next();
            rowSet.close();
            return result;
        }
        catch (Exception e) {
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
            return false;
        }
    }

    @Override
    protected void InsertDirectData(Context ctx, String companyId, String periodId, String userId) throws AllocateException {
        FeeData iFee = this.GetFeeDataControl();
        String sqlDirectFee = iFee.GetDirectFeeDataSql();
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO {0}(FID,FCompanyID,FCalculatePeriodID,FCostCenterID,").append("FSourceBillID,FSourceBillEntryID,FCostObjectID,FCostItemID,FAllocStdID,").append("FAllocStdData,FQty,FAmount,FPrice,FMaterialID,FLot,FBizDate,FSeq, FCreatorID,FCreateTime,FAdjustUserID,FAdjustTime,FIsDirect, AllocBillType )").append('\n').append("SELECT newbosid(''ADC37CB3'') AS FID, ''{1}'' As FCompanyID, ''{2}'' As FCalculatePeriodID,\"costCenterOrgUnit.id\" As FCostCenterID,").append('\n').append("\"ID\" As FSourceBillID,\"ENTRY.ID\" As FSourceBillEntryID, \"COSTOBJECT.ID\" As FCostObjectID, \"costItem.id\" As FCostItemID, null As FAllocStdID,").append("1 As FAllocStdData, \"entry.baseQty\" As FQty, \"entry.actualCost\" As FAmount, 0 As FPrice, ").append('\n').append("\"MATERIAL.ID\" As FMaterialId, \"ENTRY.LOT\" As FLot, \"BIZDATE\" As FBizDate, \"ENTRY.SEQ\" As FSeq, ").append('\n').append("''{3}'' As FCreatorID, GetDate() As FCreateTime, ''{4}'' as FAdjustUserID, GetDate() as FAdjustTime, 1 As FIsDirect, ''{5}'' as AllocBillType ").append('\n').append("FROM ( {6} ) S ").append('\n').append("Where \"ENTRY.ACTUALCOST\" <> 0 ");
        String sqlInsert = MessageFormat.format(sb.toString(), this.getTblResult(), companyId, periodId, userId, this.GetAdjustUserId(), "CA", sqlDirectFee);
        try {
            NCMDbUtil.execute((Context)ctx, (String)sqlInsert);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
    }

    public void preAllocProcess() throws AllocateException {
    }

    public void endAllocProcess() throws AllocateException {
    }

    @Override
    protected void removeInvalidCostObject(Context ctx, String companyId, String periodId) throws AllocateException {
        String tblObjRange = this.getAllocTable().GetObjectRangeTable();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT top 100 ").append('\n');
        sb.append(" MB.FNumber, ME.FSeq, ").append('\n');
        sb.append(" CO.FName_L2 As FCostObjectName, D.FID AS inValidId, CO.FNumber As FCostObjectNumber, CC.FCostCenterType FCostCenterType ").append('\n').append("FROM {0} D ").append('\n').append("INNER JOIN ").append(this.setPhsicalTblEntry()).append(" ME ON ME.FID=D.FSourceBillEntryID ").append('\n').append("INNER JOIN ").append(this.setPhsicalTblBill()).append(" MB ON MB.FID=D.FSourceBillID ").append('\n').append("INNER JOIN t_bd_CostObject CO ON CO.FID=D.FCostObjectID ").append('\n');
        if ("OtherInWarehs".equals(this._param.get("matType")) || "CostAdjust".equals(this._param.get("matType"))) {
            sb.append("INNER JOIN T_ORG_CostCenter CC ON MB.").append(this.setFCostCenterOrgUnitID()).append("=CC.FID ").append('\n');
        } else {
            sb.append("INNER JOIN T_ORG_CostCenter CC ON ME.").append(this.setFCostCenterOrgUnitID()).append("=CC.FID ").append('\n');
        }
        sb.append(" left outer join {1} S on s.fcostcenterid=d.fcostcenterid and s.fcostobjectid=d.fcostobjectid ").append('\n').append("WHERE D.FCompanyID=''{2}'' AND D.FCalculatePeriodID=''{3}'' ").append('\n').append("  AND CC.FCostCenterType in (0, 1) ").append('\n').append(" and ME.fcompanyorgunitid=''{4}'' ").append('\n').append(" and S.FID is null ").append('\n');
        String sqlInvalidCostObject = MessageFormat.format(sb.toString(), this.getTblResult(), tblObjRange, companyId, periodId, companyId);
        sb.delete(0, sb.length());
        try {
            IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sqlInvalidCostObject);
            rs.first();
            if (rs.getRow() > 0) {
                StringBuffer inVaildIds = new StringBuffer();
                rs.first();
                while (rs.getRow() > 0 && !rs.isAfterLast()) {
                    if (inVaildIds.length() > 0) {
                        inVaildIds.append(",");
                    }
                    inVaildIds.append("'").append(rs.getString("inValidId")).append("'");
                    rs.next();
                }
                sb.append("DELETE ").append(this.getTblResult()).append(" WHERE FID in (").append(inVaildIds).append(")").append('\n');
                NCMDbUtil.execute((Context)ctx, (String)sb.toString());
                NumericExceptionSubItem except = null;
                rs.first();
                while (rs.getRow() > 0 && !rs.isAfterLast()) {
                    String number = rs.getString("FNumber");
                    String seq = String.valueOf(rs.getInt("FSeq"));
                    String costObjNumber = rs.getString("FCostObjectNumber");
                    int costCenterType = rs.getInt("FCostCenterType");
                    except = costCenterType == 1 ? AllocateException.ITEM_ALLOC_INVALID_AUSCOSTOBJ : AllocateException.ITEM_ALLOC_INVALID_COSTOBJ;
                    this.processAllocateException(new AllocateException(except, new Object[]{number, seq, costObjNumber}), null, null);
                    rs.next();
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e), null, null);
        }
    }
}

