/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.Info;

import com.kingdee.bos.Context;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.Info.FeeInfoAdapter;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.Info.IMatFeeInfo;
import com.kingdee.eas.ncm.bill.app.Alloc.helper.AllocUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class MatFeeInfoAdapter
extends FeeInfoAdapter
implements IMatFeeInfo {
    private static Logger logger = Logger.getLogger((String)MatFeeInfoAdapter.class.getName());

    public MatFeeInfoAdapter(IRowSet data) {
        super(data);
    }

    @Override
    public String GetExpenseId() {
        try {
            String expensID = this._data.getString("FEXPENSEID");
            if (expensID != null) {
                return expensID;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            return "ml7t5QEaEADgAAwawKgRe0olWCc=";
        }
        return "ml7t5QEaEADgAAwawKgRe0olWCc=";
    }

    @Override
    public String GetExpenseNumber() {
        return "5001";
    }

    @Override
    public String GetExpenseName(Context ctx) {
        return AllocUtils.getAllocResource(ctx, "Expense_Mat");
    }

    @Override
    public String GetCostCenterId() {
        try {
            return this._data.getString("costCenterOrgUnit.id");
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            return "";
        }
    }

    @Override
    public String GetCostCenterNumber() {
        try {
            return this._data.getString("costCenterOrgUnit.number");
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            return "";
        }
    }

    @Override
    public String GetCostCenterName() {
        try {
            return this._data.getString("costCenterOrgUnit.name");
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            return "";
        }
    }

    @Override
    public int getCostCenterType() {
        try {
            return this._data.getInt("costCenterOrgUnit.type");
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            return 0;
        }
    }

    @Override
    public String GetEntryId() {
        try {
            return this._data.getString("entry.id");
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            return "";
        }
    }

    @Override
    public String GetEntrySeq() {
        try {
            return this._data.getString("entry.seq");
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            return "";
        }
    }

    @Override
    public BigDecimal GetAmount() {
        try {
            return this._data.getBigDecimal("entry.actualCost");
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            return BigDecimal.valueOf(0L);
        }
    }

    @Override
    public int GetAmountPrecision() {
        try {
            return this._data.getInt("baseCurrency.precision");
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            return 2;
        }
    }

    @Override
    public BigDecimal GetQty() {
        try {
            BigDecimal qty = this._data.getBigDecimal("entry.baseQty");
            if (qty == null) {
                qty = BigDecimal.valueOf(0L);
            }
            return qty;
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            return BigDecimal.valueOf(0L);
        }
    }

    @Override
    public BigDecimal GetCommonQty() {
        try {
            BigDecimal qty = this._data.getBigDecimal("entry.qty");
            if (qty == null) {
                qty = BigDecimal.valueOf(0L);
            }
            return qty;
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            return BigDecimal.valueOf(0L);
        }
    }

    @Override
    public BigDecimal GetAssistQty() {
        try {
            BigDecimal qty = this._data.getBigDecimal("entry.assistQty");
            if (qty == null) {
                qty = BigDecimal.valueOf(0L);
            }
            return qty;
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            return BigDecimal.valueOf(0L);
        }
    }

    @Override
    public BigDecimal GetPrice() {
        try {
            BigDecimal price = this._data.getBigDecimal("entry.unitActualCost");
            if (price == null) {
                price = BigDecimal.valueOf(0L);
            }
            return price;
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            return BigDecimal.valueOf(0L);
        }
    }

    @Override
    public int GetQtyPrecision() {
        try {
            return this._data.getInt("baseUnit.qtyPrecision");
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            return 8;
        }
    }

    @Override
    public int GetCommonQtyPrecision() {
        try {
            return this._data.getInt("unit.qtyPrecision");
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            return 8;
        }
    }

    @Override
    public int GetAssistQtyPrecision() {
        try {
            return this._data.getInt("assistUnit.qtyPrecision");
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            return 8;
        }
    }

    @Override
    public int GetPricePrecision() {
        try {
            return this._data.getInt("material.pricePrecision");
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            return 8;
        }
    }

    @Override
    public String GetMaterialId() {
        try {
            return this._data.getString("material.id");
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            return "";
        }
    }

    @Override
    public String GetLot() {
        try {
            return this._data.getString("entry.lot");
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            return "";
        }
    }

    @Override
    public String GetBizDate() {
        try {
            return this._data.getString("bizDate");
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            return "";
        }
    }

    @Override
    public int GetSeq() {
        try {
            return this._data.getInt("entry.seq");
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            return 0;
        }
    }
}

