/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.FeeData;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.AllocTable;
import com.kingdee.eas.ncm.cal.utils.app.CalSeverUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.log4j.Logger;

public class MatFeeData
extends FeeData {
    private static Logger logger = Logger.getLogger((String)MatFeeData.class.getName());
    protected IMetaDataPK mdPk = this.setMetaDataPK();
    protected String tblAllocResult = this.setTblAllocResult();
    protected String tblAllocResult_Physical = null;

    public MatFeeData(Map param) {
        super(param);
        this.getTblAllocResult_Physical();
    }

    protected MetaDataPK setMetaDataPK() {
        return new MetaDataPK("com.kingdee.eas.ncm.bill.app", "MaterialAllocFeeGroupQuery");
    }

    protected String setTblAllocResult() {
        return "T_NCM_MatAllocResult";
    }

    protected String setAllocBillType() {
        return "MF";
    }

    @Override
    public void buildTargetBillEntryID(String tblResult) throws Exception {
        Context ctx = (Context)this.param.get("ctx");
        AllocTable allocTable = (AllocTable)this.param.get("allocTable");
        String tblToAlloc = allocTable.GetToAllocBillEntryIDTable();
        StringBuffer ksql = new StringBuffer();
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)this.mdPk);
        FilterInfo filter = (FilterInfo)((FilterInfo)this.param.get("filterInfo")).clone();
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        exec.setObjectView(view);
        String sql = exec.getSQL();
        sql = this.parseQuerySql(tblResult, sql);
        ksql.setLength(0);
        ksql.append("insert into " + tblToAlloc + " ( \n");
        ksql.append("    FSourceBillEntryID, \n");
        ksql.append("    FIsDirect \n");
        ksql.append(") \n");
        ksql.append(sql);
        ksql.append(" \n");
        ksql.append("; \n");
        NCMDbUtil.BatchSqlExecute((Context)ctx, (String)ksql.toString(), (String)";");
        ((TempTablePool)this.param.get("pool")).createIndex(tblToAlloc, "FSourceBillEntryID", false, false);
    }

    @Override
    public int hasTargetBillEntryID() throws Exception {
        Context ctx = (Context)this.param.get("ctx");
        AllocTable allocTable = (AllocTable)this.param.get("allocTable");
        String tblToAlloc = allocTable.GetToAllocBillEntryIDTable();
        String sql = "select top 1 1 from " + tblToAlloc;
        IRowSet rowset = NCMDbUtil.executeQuery((Context)ctx, (String)sql);
        if (rowset.next()) {
            return 1;
        }
        return 0;
    }

    protected String parseQuerySql(String tblResult, String sql) {
        String tempSql;
        int index = sql.indexOf("GROUP BY");
        if (index >= 0 && (index = (tempSql = sql.substring(0, index)).indexOf("FROM")) >= 0) {
            tempSql = tempSql.substring(index);
            StringBuffer ksql = new StringBuffer();
            ksql.append("SELECT \n");
            ksql.append("     \"ENTRY\".FID, \n");
            ksql.append("     case \n");
            ksql.append("         when (\"COSTOBJECT\".FID IS NOT NULL) AND (\"COSTOBJECT\".FNumber <> 'SCOID') then 1 \n");
            ksql.append("         else 0 \n");
            ksql.append("     end   \n");
            ksql.append(" \n");
            sql = tempSql = ksql.toString() + tempSql;
        }
        if (this.param.containsKey("isOnlyUnAlloced") && this.param.get("isOnlyUnAlloced").equals(String.valueOf(true))) {
            sql = sql.replaceAll("WHERE", "\n LEFT OUTER JOIN " + tblResult + " AS \"TBLRESULT\" \n ON \"TBLRESULT\".FSourceBillEntryID=\"ENTRY\".FID \n WHERE ");
            sql = sql + " and \"TBLRESULT\".FSourceBillEntryID is null \n";
        }
        return sql;
    }

    @Override
    public IRowSet GetIndirectFeeData() throws AllocateException {
        Assert.that((boolean)this.param.containsKey("filterInfo"));
        FilterInfo filter = (FilterInfo)((FilterInfo)this.param.get("filterInfo")).clone();
        Context ctx = (Context)this.param.get("ctx");
        FilterInfo addFilter = new FilterInfo();
        addFilter.getFilterItems().add(new FilterItemInfo("costObject.id", null, CompareType.EQUALS));
        try {
            FilterInfo scoFilter = new FilterInfo();
            scoFilter.getFilterItems().add(new FilterItemInfo("costObject.number", (Object)"SCOID", CompareType.EQUALS));
            addFilter.mergeFilter(scoFilter, "or");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
        try {
            filter.mergeFilter(addFilter, "and");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)this.mdPk);
        IRowSet rs = null;
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        try {
            exec.setObjectView(ev);
            String sql = exec.getSQL();
            if (this.param.containsKey("isOnlyUnAlloced") && this.param.get("isOnlyUnAlloced").equals(String.valueOf(true))) {
                sql = sql.replaceAll("WHERE", " LEFT OUTER JOIN " + this.getTblAllocResult_Physical() + " AS \"TBLRESULT\" ON \"TBLRESULT\".FSourceBillEntryID=\"ENTRY\".FID WHERE ");
                sql = sql.replaceAll("GROUP BY", " and \"TBLRESULT\".FSourceBillEntryID is null GROUP BY ");
            }
            sql = sql.replaceAll("\"COSTCENTERORGUNIT.NAME\" ASC", " ");
            if ((sql = sql.replaceAll("ORDER BY", "ORDER BY \"COSTCENTERORGUNIT.ID\",\"COSTOBJECTSUITEID\", \"MATERIAL.ID\" ")).indexOf("ORDER BY") < 0) {
                sql = sql + "\nORDER BY \"COSTCENTERORGUNIT.ID\",\"COSTOBJECTSUITEID\", \"MATERIAL.ID\" ";
            }
            rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql);
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e1);
        }
        return rs;
    }

    @Override
    public String GetDirectFeeDataSql() throws AllocateException {
        Assert.that((boolean)this.param.containsKey("filterInfo"));
        FilterInfo filter = (FilterInfo)((FilterInfo)this.param.get("filterInfo")).clone();
        String sql = null;
        Context ctx = (Context)this.param.get("ctx");
        FilterInfo addFilter = new FilterInfo();
        addFilter.getFilterItems().add(new FilterItemInfo("costObject.id", null, CompareType.NOTEQUALS));
        addFilter.getFilterItems().add(new FilterItemInfo("costObject.number", (Object)"SCOID", CompareType.NOTEQUALS));
        try {
            filter.mergeFilter(addFilter, "and");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)this.mdPk);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        try {
            if (this.param.containsKey("isOnlyUnAlloced")) {
                exec.setObjectView(ev);
                sql = exec.getSQL();
                if (this.param.get("isOnlyUnAlloced").equals(String.valueOf(true))) {
                    sql = sql.replaceAll("WHERE", " LEFT OUTER JOIN " + this.getTblAllocResult_Physical() + " AS \"TBLRESULT\" ON \"TBLRESULT\".FSourceBillEntryID=\"ENTRY\".FID WHERE ");
                    sql = sql.replaceAll("GROUP BY", " and \"TBLRESULT\".FSourceBillEntryID is null GROUP BY ");
                }
            } else {
                exec.setObjectView(ev);
                sql = exec.getSQL();
            }
            sql = sql.replaceAll("ORDER BY", " ");
            if ((sql = sql.replaceAll("\"COSTCENTERORGUNIT.NAME\" ASC", " ")).indexOf("T_IM_MaterialReqBillEntry") > 0) {
                sql = sql.replaceAll("SELECT", "SELECT \"entry\".FWareHouseID as \"FWareHouseID\", \"MATERIALREQBILL\".FAdminOrgUnitID as \"FAdminOrgUnitID\",\"ENTRY\".FIsRework AS \"ENTRY.FIsRework\", ");
                sql = sql + " , \"entry\".FWareHouseID,\"MATERIALREQBILL\".FAdminOrgUnitID,\"ENTRY\".FIsReWork ";
            }
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e1);
        }
        return sql;
    }

    @Override
    public String GetIndirectFeeDataSql() throws AllocateException {
        Assert.that((boolean)this.param.containsKey("filterInfo"));
        FilterInfo filter = (FilterInfo)((FilterInfo)this.param.get("filterInfo")).clone();
        String sql = null;
        Context ctx = (Context)this.param.get("ctx");
        FilterInfo addFilter = new FilterInfo();
        addFilter.getFilterItems().add(new FilterItemInfo("costObject.id", null, CompareType.EQUALS));
        try {
            FilterInfo scoFilter = new FilterInfo();
            scoFilter.getFilterItems().add(new FilterItemInfo("costObject.number", (Object)"SCOID", CompareType.EQUALS));
            addFilter.mergeFilter(scoFilter, "or");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
        try {
            filter.mergeFilter(addFilter, "and");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)this.mdPk);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        try {
            if (this.param.containsKey("isOnlyUnAlloced")) {
                exec.setObjectView(ev);
                sql = exec.getSQL();
                if (this.param.get("isOnlyUnAlloced").equals(String.valueOf(true))) {
                    sql = sql.replaceAll("WHERE", " LEFT OUTER JOIN " + this.getTblAllocResult_Physical() + " AS \"TBLRESULT\" ON \"TBLRESULT\".FSourceBillEntryID=\"ENTRY\".FID WHERE ");
                    sql = sql.replaceAll("GROUP BY", " and \"TBLRESULT\".FSourceBillEntryID is null GROUP BY ");
                }
            } else {
                exec.setObjectView(ev);
                sql = exec.getSQL();
            }
            sql = sql.replaceAll("ORDER BY", " ");
            sql = sql.replaceAll("\"COSTCENTERORGUNIT.NAME\" ASC", " ");
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e1);
        }
        return sql;
    }

    @Override
    public void clearPreAllocResult(String tblResult) throws Exception {
        Assert.that((boolean)this.param.containsKey("filterInfo"));
        String sql = null;
        AllocTable allocTable = (AllocTable)this.param.get("allocTable");
        String tblToAlloc = allocTable.GetToAllocBillEntryIDTable();
        Context ctx = (Context)this.param.get("ctx");
        String companyId = this.param.get("companyId").toString();
        String periodId = this.param.get("periodId").toString();
        boolean bFilter_all = false;
        if (this.param.containsKey("bFilter_all")) {
            bFilter_all = this.param.get("bFilter_all").equals(String.valueOf(true));
        }
        StringBuffer ksql = new StringBuffer();
        if (bFilter_all) {
            String whereClause = " where AllocBillType = '" + this.setAllocBillType() + "'";
            ksql.setLength(0);
            ksql.append("select top 1 1 from " + tblResult + " \n");
            ksql.append("where AllocBillType <> '" + this.setAllocBillType() + "' \n");
            if (this.isCanUseTruncate(ctx, ksql.toString())) {
                whereClause = null;
            }
            NCMDynamicTableManager.DeleteTable((Context)ctx, (String)tblResult, (String)whereClause);
            return;
        }
        sql = " where exists (Select 1 from " + tblToAlloc + " S WHERE S.FSourceBillEntryID=" + tblResult + ".FSourceBillEntryID)";
        ksql.setLength(0);
        ksql.append("select top 1 1 from " + tblResult + " \n");
        ksql.append("where not exists ( \n");
        ksql.append("    Select 1 from " + tblToAlloc + " s \n");
        ksql.append("    WHERE s.FSourceBillEntryID = " + tblResult + ".FSourceBillEntryID \n");
        ksql.append(") \n");
        if (this.isCanUseTruncate(ctx, ksql.toString())) {
            sql = null;
        }
        NCMDynamicTableManager.DeleteTable((Context)ctx, (String)tblResult, (String)sql);
        CalSeverUtils.ClearInvalidMatFeeAllocResult((Context)ctx, (String)companyId, (String)periodId);
    }

    @Override
    public void updateFeeDataFlagToAllocated(String tblResult) throws Exception {
    }

    @Override
    public void updateFeeDataFlagToUnallocated(String tblResult) throws Exception {
        Assert.that((boolean)this.param.containsKey("filterInfo"));
        FilterInfo filter = (FilterInfo)((FilterInfo)this.param.get("filterInfo")).clone();
        String sql = null;
        Context ctx = (Context)this.param.get("ctx");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)this.mdPk);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        try {
            if (this.param.containsKey("isOnlyUnAlloced")) {
                exec.setObjectView(ev);
                sql = exec.getSQL();
                if (this.param.get("isOnlyUnAlloced").equals(String.valueOf(true))) {
                    sql = sql.replaceAll("WHERE", " LEFT OUTER JOIN " + tblResult + " AS \"TBLRESULT\" ON \"TBLRESULT\".FSourceBillEntryID=\"ENTRY\".FID WHERE ");
                    sql = sql.replaceAll("GROUP BY", " and \"TBLRESULT\".FSourceBillEntryID is null GROUP BY ");
                }
            } else {
                exec.setObjectView(ev);
                sql = exec.getSQL();
            }
            sql = sql.replaceAll("ORDER BY", " ");
            sql = sql.replaceAll("\"COSTCENTERORGUNIT.NAME\" ASC", " ");
            sql = "select \"ENTRY\".FID " + sql.substring(sql.toLowerCase().indexOf("from"));
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update T_IM_MaterialReqBillEntry ");
            updateSql.append("set FIsAdmeasure = 1 \n");
            updateSql.append("where FID in ( \n");
            updateSql.append(sql);
            updateSql.append(") \n");
            NCMDbUtil.execute((Context)ctx, (String)updateSql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCanUseTruncate(Context ctx, String sqlNotDeleteData) throws SQLException, BOSException {
        IRowSet rs = null;
        try {
            rs = NCMDbUtil.executeQuery((Context)ctx, (String)sqlNotDeleteData);
            boolean bl = !rs.next();
            return bl;
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
    }

    public String getTblAllocResult_Physical() {
        if (this.tblAllocResult_Physical != null) {
            return this.tblAllocResult_Physical;
        }
        Context ctx = (Context)this.param.get("ctx");
        String companyId = this.param.get("companyId").toString();
        try {
            this.tblAllocResult_Physical = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)this.tblAllocResult);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return this.tblAllocResult_Physical;
    }
}

