/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.basedata.ncm.AllocStdInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.AllocStdSetByCCOFactory;
import com.kingdee.eas.ncm.bill.AllocStdSetByCCOInfo;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.IAllocStdSetByCCO;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.AUSContext;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.CCOAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.FeeData;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.Info.IFeeInfo;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.AllocTable;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.ManuCCOAllocTable;
import com.kingdee.eas.ncm.common.AllocStdSetModeByCCOEnum;
import com.kingdee.eas.ncm.common.task.CostTaskResultEnum;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ManuCCOAllocator
extends CCOAllocator {
    private static Logger logger = Logger.getLogger((String)ManuCCOAllocator.class.getName());
    private boolean _hasGetAllocTbl = false;
    private AllocStdSetModeByCCOEnum setMode = AllocStdSetModeByCCOEnum.SetByCCGroup;

    public ManuCCOAllocator(Map param, AUSContext ausCtx) {
        super(param, ausCtx);
        Assert.that((boolean)param.containsKey("sourceBillId"));
        Assert.that((boolean)param.containsKey("sourceBillEntryId"));
        Assert.that((boolean)param.containsKey("isOnlyNotZero"));
        Assert.that((boolean)param.containsKey("isOnlyRangeChange"));
    }

    @Override
    public CostTaskResultEnum preCheck() throws Exception {
        return super.preCheck();
    }

    @Override
    public AllocTable getAllocTable() throws AllocateException {
        if (this._hasGetAllocTbl) {
            return super.getAllocTable();
        }
        Context ctx = (Context)this._param.get("ctx");
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        this._param.put("pool", pool);
        this.setAllocTable(new ManuCCOAllocTable(this._param));
        this._hasGetAllocTbl = true;
        return super.getAllocTable();
    }

    @Override
    public void preProcess() throws AllocateException {
        super.preProcess();
    }

    @Override
    public AllocStdInfo GetAllocStdSetting(IFeeInfo currFee) throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        try {
            this.setMode = NCMUtils.getAllocStdSetModeByCCO((Context)ctx, (String)companyId);
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e1);
        }
        AllocStdInfo allocStd = null;
        if (this._param.containsKey("allocStd")) {
            allocStd = (AllocStdInfo)this._param.get("allocStd");
        }
        if (allocStd != null) {
            return allocStd;
        }
        StringBuffer sb = new StringBuffer();
        try {
            IAllocStdSetByCCO fact = AllocStdSetByCCOFactory.getLocalInstance(ctx);
            if (this.setMode == AllocStdSetModeByCCOEnum.SetByCCGroup) {
                sb.append("Select allocStd.* where company = '").append(companyId).append("' AND calculatePeriod = '").append(periodId).append("' AND expense = '").append(currFee.GetExpenseId()).append("' ").append(" AND costCenterGroup = '").append(currFee.GetCostCenterGroupId()).append("'");
            } else {
                sb.append("Select allocStd.* where company = '").append(companyId).append("' AND calculatePeriod = '").append(periodId).append("' AND expense = '").append(currFee.GetExpenseId()).append("' ");
            }
            AllocStdSetByCCOInfo info = fact.getAllocStdSetByCCOInfo(sb.toString());
            return info.getAllocStd();
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
    }

    @Override
    public FeeData GetFeeDataControl() throws AllocateException {
        return super.GetFeeDataControl();
    }

    @Override
    public void allocDirect() throws AllocateException {
        super.allocDirect();
    }

    @Override
    public void allocIndirect(IFeeInfo currFee, int position) throws AllocateException {
        super.allocIndirect(currFee, position);
    }

    @Override
    public Map processResult() throws AllocateException {
        HashMap<String, Object> ret = null;
        ret = super.processResult();
        if (ret == null) {
            ret = new HashMap<String, Object>();
        }
        if (this._param.get("isOnlyRangeChange").equals(String.valueOf(true))) {
            this.dealWhenOnlyRangeChange();
        }
        IRowSet rs = this.getCCOAdjustData();
        ret.put("AdjustData", rs);
        ret.put("AllocStd", this.getAllocStd());
        return ret;
    }

    @Override
    public void endProcess() throws AllocateException {
        super.endProcess();
    }

    @Override
    protected String GetAdjustUserId() {
        return this._param.get("userId").toString();
    }

    @Override
    public void processAllocateException(AllocateException e, String possibleReason, String adviceHandle) throws AllocateException {
        super.processAllocateException(e, possibleReason, adviceHandle);
    }

    protected IRowSet getCCOAdjustData() throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        String sourceBillId = this._param.get("sourceBillId").toString();
        String sourceBillEntryId = this._param.get("sourceBillEntryId").toString();
        String tblResult = this.getAllocTable().GetResultTable();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT D.FID,D.FCostCenterID,O.FNumber As FCostCenterNumber, O.FName_L2 As FCostCenterName,").append('\n').append("  D.FAllocStdData,D.FQty,D.FPrice,D.FAmount,").append('\n').append("  D.FCostItemID, I.FNumber As FCostItemNumber, I.FName_L2 As FCostItemName,").append('\n').append("  D.FAllocStdID, S.FNumber As FAllocStdNumber, S.FName_L2 As FAllocStdName, ").append('\n').append("  D.FCreatorID, CR.FNumber As FCreatorNumber, CR.FName_L2 As FCreatorName,D.FCreateTime,").append('\n').append("  D.FAdjustUserID, AD.FNumber As AdjustUserNumber, AD.FName_L2 As FAdjustUserName,D.FAdjustTime,").append('\n').append("  CY.FPrecision As FAmountPrecision ,Isnull(UNT.FQtyPrecision,8)as FQtyPrecision, Isnull(EXP.FPricePrecision,8)As FPricePrecision, ").append('\n').append("  dp.Fname_l2 as Fdepartmentname,sourceCC.Fname_l2 as FSourceCostCenterName ").append('\n').append("FROM ").append(tblResult).append(" D ").append('\n').append("LEFT OUTER JOIN T_NCM_AllocStd S ON D.FAllocStdID = S.FID ").append('\n').append("LEFT OUTER JOIN T_ORG_CostCenter O ON D.FCostCenterID = O.FID ").append('\n').append("LEFT OUTER JOIN T_NCM_CostItem I ON D.FCostItemID = I.FID ").append('\n').append("LEFT OUTER JOIN T_PM_User CR ON D.FCreatorID = CR.FID ").append('\n').append("LEFT JOIN T_PM_User AD ON D.FAdjustUserID = AD.FID ").append('\n').append("LEFT OUTER JOIN T_ORG_Company COM ON D.FCompanyID = COM.FID ").append('\n').append("LEFT OUTER JOIN T_BD_Currency CY ON COM.FBaseCurrencyID = CY.FID ").append('\n').append("LEFT OUTER JOIN T_NCM_Expense EXP ON D.FExpenseID = EXP.FID ").append('\n').append("LEFT OUTER JOIN T_BD_MeasureUnit UNT ON EXP.FUnitID = UNT.FID ").append('\n').append("LEFT OUTER JOIN T_ORG_BaseUnit dp ON D.FDepartmentID = dp.FID ").append('\n').append("LEFT OUTER JOIN T_ORG_CostCenter sourceCC ON D.FSourceCostCenterID = sourceCC.FID ").append('\n').append("WHERE D.FCompanyID ='").append(companyId).append("' AND D.FCalculatePeriodID='").append(periodId).append("'").append('\n').append("  AND D.FSourceBillID='").append(sourceBillId).append("' AND D.FSourceBillEntryID='").append(sourceBillEntryId).append("'").append('\n').append("Order by O.FNumber ");
        Context ctx = (Context)this._param.get("ctx");
        try {
            return NCMDbUtil.executeQuery((Context)ctx, (String)sb.toString());
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
    }

    @Override
    protected boolean IsOnlyNotZero_AllcoStdData() {
        return this._param.get("isOnlyNotZero").equals(String.valueOf(true));
    }

    private void dealWhenOnlyRangeChange() throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        String sourceBillId = this._param.get("sourceBillId").toString();
        String sourceBillEntryId = this._param.get("sourceBillEntryId").toString();
        Context ctx = (Context)this._param.get("ctx");
        String tblResult_Adjust = this.getAllocTable().GetResultTable();
        String tblResult = null;
        StringBuffer sb = new StringBuffer();
        sb.append("(select a.FID, a.FCompanyOrg as FCompanyID, a.FCalculatePeriod as FCalculatePeriodID,").append('\n').append("        a.FExpenseID as FExpenseID, a.FCostCenterID, a.FSourceBillID as FSourceBillEntryID,").append('\n').append("        a.FCreatorID, a.FCreateTime, a.FLastUpdateUserID as FAdjustUserID, a.FLastUpdateTime as FAdjustTime,").append('\n').append("        b.FCostItemID, b.FAmount, b.FQty, b.FPrice, b.FAllocStdData,a.FAllocStdID,").append('\n').append("        c.FCostCenterGroupID, c.FID as FSourceBillID,a.FDepartmentID, a.FSourceCostCenterID ").append('\n').append("   from T_NCM_OtherFeeBill a, T_NCM_OtherFeeBillEntry b, T_NCM_CCOFeeBill c, T_NCM_CCOFeeBillEntry d").append('\n').append("  where a.FID = b.FParentID and a.FSourceBillID = d.FID and d.FParentID = c.FID").append('\n').append("    and a.FSourceBillID = ''{0}'')");
        tblResult = MessageFormat.format(sb.toString(), sourceBillEntryId);
        sb.delete(0, sb.length());
        sb.append("IF EXISTS(select 1 from ").append(tblResult).append(" tt ").append('\n').append(" where tt.FCompanyID ='").append(companyId).append("' AND tt.FCalculatePeriodID='").append(periodId).append("'").append('\n').append("  AND tt.FSourceBillID='").append(sourceBillId).append("' AND tt.FSourceBillEntryID='").append(sourceBillEntryId).append("')").append('\n').append("UPDATE ").append(tblResult_Adjust).append(" SET FAllocStdData=0,FQty=0,FPrice=0,FAmount=0 ").append('\n').append("WHERE FCompanyID ='").append(companyId).append("' AND FCalculatePeriodID='").append(periodId).append("'").append('\n').append("  AND FSourceBillID='").append(sourceBillId).append("' AND FSourceBillEntryID='").append(sourceBillEntryId).append("'").append('\n').append(";").append('\n');
        sb.append("IF EXISTS(select 1 from ").append(tblResult).append(" tt ").append('\n').append(" where tt.FCompanyID ='").append(companyId).append("' AND tt.FCalculatePeriodID='").append(periodId).append("'").append('\n').append("  AND tt.FSourceBillID='").append(sourceBillId).append("' AND tt.FSourceBillEntryID='").append(sourceBillEntryId).append("')").append('\n').append("UPDATE ").append(tblResult_Adjust).append(" As D SET (FAllocStdData,FQty,FPrice,FAmount)=( ").append('\n').append("\tSelect S.FAllocStdData,S.FQty,S.FPrice,S.FAmount ").append('\n').append("\tFrom ").append(tblResult).append(" S ").append('\n').append("\tWHERE S.FCompanyID ='").append(companyId).append("' AND S.FCalculatePeriodID='").append(periodId).append("'").append('\n').append("  \t\tAND S.FSourceBillID='").append(sourceBillId).append("' AND S.FSourceBillEntryID='").append(sourceBillEntryId).append("'").append('\n').append("\t\tAND S.FCompanyID=D.FCompanyID AND S.FCalculatePeriodID=D.FCalculatePeriodID ").append('\n').append("\t\tAND S.FSourceBillID=D.FSourceBillID AND S.FSourceBillEntryID=D.FSourceBillEntryID ").append('\n').append("\t\tAND S.FCostCenterGroupID=D.FCostCenterGroupID AND S.FCostCenterID=D.FCostCenterID ").append('\n').append(");").append('\n');
        if (this.IsOnlyNotZero_AllcoStdData()) {
            sb.append("Delete from ").append(tblResult_Adjust).append('\n').append("WHERE FCompanyID ='").append(companyId).append("' AND FCalculatePeriodID='").append(periodId).append("'").append('\n').append("  \tAND FSourceBillID='").append(sourceBillId).append("' AND FSourceBillEntryID='").append(sourceBillEntryId).append("'").append('\n').append("\tAND FAllocStdData=0 ").append('\n').append(";").append('\n');
        }
        try {
            NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
    }
}

