/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.basedata.ncm.AllocStdInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.AllocStdSetByOverheadFactory;
import com.kingdee.eas.ncm.bill.AllocStdSetByOverheadInfo;
import com.kingdee.eas.ncm.bill.AllocStdSetByPrdFactory;
import com.kingdee.eas.ncm.bill.AllocStdSetByPrdInfo;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.IAllocStdSetByOverhead;
import com.kingdee.eas.ncm.bill.IAllocStdSetByPrd;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.AUSContext;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.FeeData;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.Info.IFeeInfo;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.MatReqAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.AllocTable;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.ManuMatAllocTable;
import com.kingdee.eas.ncm.common.task.CostTaskResultEnum;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ManuMatAllocator
extends MatReqAllocator {
    private static Logger logger = Logger.getLogger((String)ManuMatAllocator.class.getName());

    public ManuMatAllocator(Map param, AUSContext ausCtx) {
        super(param, ausCtx);
        Assert.that((boolean)param.containsKey("sourceBillId"));
        Assert.that((boolean)param.containsKey("sourceBillEntryId"));
        Assert.that((boolean)param.containsKey("isOnlyNotZero"));
        Assert.that((boolean)param.containsKey("isOnlyRangeChange"));
    }

    @Override
    public CostTaskResultEnum preCheck() throws Exception {
        return super.preCheck();
    }

    @Override
    protected AllocTable setAllocTable(Map param) {
        return new ManuMatAllocTable(param);
    }

    @Override
    public void preProcess() throws AllocateException {
        super.preProcess();
    }

    @Override
    public AllocStdInfo GetAllocStdSetting(IFeeInfo currFee) throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        AllocStdInfo allocStd = null;
        if (this._param.containsKey("allocStd")) {
            allocStd = (AllocStdInfo)this._param.get("allocStd");
        }
        if (allocStd != null) {
            return allocStd;
        }
        StringBuffer sb = new StringBuffer();
        try {
            Boolean isAssistant = this.isAssistantCostCenterReqFee(currFee);
            if (isAssistant != null && isAssistant.booleanValue()) {
                IAllocStdSetByOverhead fact = AllocStdSetByOverheadFactory.getLocalInstance(ctx);
                sb.append("Select allocStd.* where company = '").append(companyId).append("' AND calculatePeriod = '").append(periodId).append("' AND expense = '").append(currFee.GetExpenseId()).append("' ").append(" AND costCenter = '").append(currFee.GetCostCenterId()).append("'");
                AllocStdSetByOverheadInfo info = fact.getAllocStdSetByOverheadInfo(sb.toString());
                allocStd = info.getAllocStd();
            } else {
                IAllocStdSetByPrd fact = AllocStdSetByPrdFactory.getLocalInstance(ctx);
                sb.append("Select allocStd.* where company = '").append(companyId).append("' AND calculatePeriod = '").append(periodId).append("' AND expense = '").append(currFee.GetExpenseId()).append("' ").append(" AND costCenter = '").append(currFee.GetCostCenterId()).append("'");
                AllocStdSetByPrdInfo info = fact.getAllocStdSetByPrdInfo(sb.toString());
                allocStd = info.getAllocStd();
            }
            return allocStd;
        }
        catch (ObjectNotFoundException e) {
            throw new AllocateException(AllocateException.ITEM_ALLOC_NOTSET, new Object[]{currFee.GetExpenseNumber().concat(" ").concat(currFee.GetExpenseName()), currFee.GetCostCenterNumber().concat(" ").concat(currFee.GetCostCenterName())});
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
    }

    @Override
    public FeeData GetFeeDataControl() throws AllocateException {
        return super.GetFeeDataControl();
    }

    @Override
    public void allocDirect() throws AllocateException {
        super.allocDirect();
    }

    @Override
    public void allocIndirect(IFeeInfo currFee, int position) throws AllocateException {
        super.allocIndirect(currFee, position);
    }

    @Override
    public Map processResult() throws AllocateException {
        HashMap<String, Object> ret = null;
        ret = super.processResult();
        if (ret == null) {
            ret = new HashMap<String, Object>();
        }
        if (this._param.get("isOnlyRangeChange").equals(String.valueOf(true))) {
            this.dealWhenOnlyRangeChange();
        }
        IRowSet rs = this.getMatAdjustData();
        ret.put("AdjustData", rs);
        ret.put("AllocStd", this.getAllocStd());
        return ret;
    }

    @Override
    public void endProcess() throws AllocateException {
        super.endProcess();
    }

    @Override
    protected String GetAdjustUserId() {
        return this._param.get("userId").toString();
    }

    @Override
    public void processAllocateException(AllocateException e, String possibleReason, String adviceHandle) throws AllocateException {
        super.processAllocateException(e, possibleReason, adviceHandle);
    }

    protected IRowSet getMatAdjustData() throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        String sourceBillId = this._param.get("sourceBillId").toString();
        String sourceBillEntryId = this._param.get("sourceBillEntryId").toString();
        String loc = ((Context)this._param.get("ctx")).getLocale().getLanguage();
        String tblResult = this.getAllocTable().GetResultTable();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT D.FID,D.FCostObjectID,O.FNumber As FCostObjectNumber, O.FName_L2 As FCostObjectName,P.FModel As FProdModel,").append('\n').append("  D.FAllocStdData,D.FCommonQty,D.FQty,D.FAssistQty,D.FPrice,D.FAmount,").append('\n').append("  D.FCostItemID, I.FNumber As FCostItemNumber, I.FName_L2 As FCostItemName,").append('\n').append("  D.FAllocStdID, S.FNumber As FAllocStdNumber, S.FName_L2 As FAllocStdName, ").append('\n').append("  D.FCreatorID, CR.FNumber As FCreatorNumber, CR.FName_L2 As FCreatorName,D.FCreateTime,").append('\n').append("  D.FAdjustUserID, AD.FNumber As AdjustUserNumber, AD.FName_L2 As FAdjustUserName,D.FAdjustTime, ").append('\n').append("  BU.FQtyPrecision,CY.FPrecision As FAmountPrecision,MT.FPricePrecision, ").append('\n').append("  admin.Fname_" + loc + " as FAdminOrgUnitName, warehouse.Fname_" + loc + " as FWareHouseName ").append('\n').append("FROM ").append(tblResult).append(" D ").append('\n').append("LEFT OUTER JOIN T_NCM_AllocStd S ON D.FAllocStdID = S.FID ").append('\n').append("LEFT OUTER JOIN T_BD_CostObject O ON D.FCostObjectID = O.FID ").append('\n').append("LEFT OUTER JOIN T_NCM_CostItem I ON D.FCostItemID = I.FID ").append('\n').append("LEFT JOIN T_BD_Material P ON O.FStdProductIDID = P.FID ").append('\n').append("LEFT OUTER JOIN T_PM_User CR ON D.FCreatorID = CR.FID ").append('\n').append("LEFT JOIN T_PM_User AD ON D.FAdjustUserID = AD.FID ").append('\n').append("LEFT OUTER JOIN T_IM_MaterialReqBillEntry ME ON ME.FID=D.FSourceBillEntryID ").append('\n').append("LEFT OUTER JOIN T_BD_MeasureUnit BU ON ME.FUnitID = BU.FID ").append('\n').append("LEFT OUTER JOIN T_ORG_Company COM ON ME.FCompanyOrgUnitID = COM.FID ").append('\n').append("LEFT OUTER JOIN T_BD_Currency CY ON COM.FBaseCurrencyID = CY.FID ").append('\n').append("LEFT OUTER JOIN T_BD_Material MT ON ME.FMaterialID = MT.FID ").append('\n').append("LEFT OUTER JOIN T_ORG_Admin admin ON admin.FID = D.FAdminOrgUnitID ").append('\n').append("LEFT OUTER JOIN T_DB_WAREHOUSE warehouse ON warehouse.FID = D.FWarehouseID ").append('\n').append("WHERE D.FCompanyID ='").append(companyId).append("' AND D.FCalculatePeriodID='").append(periodId).append("'").append('\n').append("  AND D.FSourceBillID='").append(sourceBillId).append("' AND D.FSourceBillEntryID='").append(sourceBillEntryId).append("'").append('\n').append("Order by O.FNumber ").append('\n');
        Context ctx = (Context)this._param.get("ctx");
        try {
            return NCMDbUtil.executeQuery((Context)ctx, (String)sb.toString());
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
    }

    @Override
    protected boolean IsOnlyNotZero_AllcoStdData() {
        return this._param.get("isOnlyNotZero").equals(String.valueOf(true));
    }

    private void dealWhenOnlyRangeChange() throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        String sourceBillId = this._param.get("sourceBillId").toString();
        String sourceBillEntryId = this._param.get("sourceBillEntryId").toString();
        Context ctx = (Context)this._param.get("ctx");
        String tblResult_Adjust = this.getAllocTable().GetResultTable();
        String tblResult = null;
        try {
            tblResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_MatAllocResult");
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE ").append(tblResult_Adjust).append(" SET FAllocStdData=0,FQty=0,FPrice=0,FAmount=0 ").append('\n').append("WHERE FCompanyID ='").append(companyId).append("' AND FCalculatePeriodID='").append(periodId).append("'").append('\n').append("  AND FSourceBillID='").append(sourceBillId).append("' AND FSourceBillEntryID='").append(sourceBillEntryId).append("'").append('\n').append(";").append('\n');
        sb.append("UPDATE ").append(tblResult_Adjust).append(" As D SET (FAllocStdData,FQty,FPrice,FAmount)=( ").append('\n').append("\tSelect S.FAllocStdData,S.FQty,S.FPrice,S.FAmount ").append('\n').append("\tFrom ").append(tblResult).append(" S ").append('\n').append("\tWHERE S.FCompanyID ='").append(companyId).append("' AND S.FCalculatePeriodID='").append(periodId).append("'").append('\n').append("  \t\tAND S.FSourceBillID='").append(sourceBillId).append("' AND S.FSourceBillEntryID='").append(sourceBillEntryId).append("'").append('\n').append("\t\tAND S.FCompanyID=D.FCompanyID AND S.FCalculatePeriodID=D.FCalculatePeriodID ").append('\n').append("\t\tAND S.FSourceBillID=D.FSourceBillID AND S.FSourceBillEntryID=D.FSourceBillEntryID ").append('\n').append("\t\tAND S.FCostCenterID=D.FCostCenterID AND S.FCostObjectID=D.FCostObjectID ").append('\n').append(");").append('\n');
        if (this.IsOnlyNotZero_AllcoStdData()) {
            sb.append("Delete from ").append(tblResult_Adjust).append('\n').append("WHERE FCompanyID ='").append(companyId).append("' AND FCalculatePeriodID='").append(periodId).append("'").append('\n').append("  \tAND FSourceBillID='").append(sourceBillId).append("' AND FSourceBillEntryID='").append(sourceBillEntryId).append("'").append('\n').append("\tAND FAllocStdData=0 ").append('\n').append(";").append('\n');
        }
        try {
            NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
    }

    public void preAllocProcess() throws AllocateException {
    }

    public void endAllocProcess() throws AllocateException {
    }

    @Override
    protected Map getMaterialList() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        FeeData iFee = this.GetFeeDataControl();
        String sqlIndirectFee = iFee.GetIndirectFeeDataSql();
        HashMap<String, String> ret = new HashMap<String, String>();
        StringBuffer sb = new StringBuffer();
        sb.append("create table T ( \n");
        sb.append("     FMaterialID varchar(44), \n");
        sb.append("     FBizDate DateTime \n");
        sb.append(") \n");
        try {
            this.T_TMP_MaterialDate = TempTablePool.getInstance((Context)ctx).createTempTable(sb.toString());
            sb.setLength(0);
            sb.append("insert into " + this.T_TMP_MaterialDate + " (FMaterialID, FBizDate) ");
            sb.append("SELECT distinct \"MATERIAL.ID\" As FMaterialId, \"BIZDATE\" As FBizDate ").append('\n').append("FROM (").append(sqlIndirectFee).append(" ) S");
            NCMDbUtil.execute((Context)ctx, (String)sb.toString());
            sb.setLength(0);
            sb.append("select FMaterialID, FBizDate from " + this.T_TMP_MaterialDate + " ");
            IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sb.toString());
            rs.first();
            while (rs.getRow() > 0 && !rs.isAfterLast()) {
                ret.put(rs.getString("FMaterialID"), rs.getString("FBizDate"));
                rs.next();
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e), null, null);
        }
        return ret;
    }

    @Override
    public void resetAllocFlagToUnallocated() throws Exception {
    }
}

