/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.BOMSearchFacadeFactory;
import com.kingdee.eas.mm.basedata.IBOMSearchFacade;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.AUSContext;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.BaseAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.FeeData;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.Info.IFeeInfo;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.Info.IMatFeeInfo;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.MatFeeData;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.AllocTable;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.MatAllocTable;
import com.kingdee.eas.ncm.bill.app.CostDataCache;
import com.kingdee.eas.ncm.common.AllocStdSetModeByPrdEnum;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class MatAllocator
extends BaseAllocator {
    private static Logger logger = Logger.getLogger((String)MatAllocator.class.getName());
    private String lastMaterialID = null;
    private Map MaterialList = null;
    protected String T_TMP_MaterialDate = null;

    public MatAllocator(Map param, AUSContext ausCtx) {
        super(param, ausCtx);
    }

    @Override
    public AllocTable getAllocTable() throws AllocateException {
        if (super.getAllocTable() == null) {
            Context ctx = (Context)this._param.get("ctx");
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            this._param.put("pool", pool);
            this.setAllocTable(this.setAllocTable(this._param));
        }
        return super.getAllocTable();
    }

    @Override
    public FeeData GetFeeDataControl() throws AllocateException {
        if (this.getFeeData() == null) {
            this.setFeeData(this.setFeeData(this._param));
        }
        return super.getFeeData();
    }

    protected AllocTable setAllocTable(Map param) {
        return new MatAllocTable(param);
    }

    protected FeeData setFeeData(Map param) {
        return new MatFeeData(param);
    }

    @Override
    protected void InsertDirectData(Context ctx, String companyId, String periodId, String userId) throws AllocateException {
        FeeData iFee = this.GetFeeDataControl();
        String sqlDirectFee = iFee.GetDirectFeeDataSql();
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO {0}(FID,FCompanyID,FCalculatePeriodID,FCostCenterID,").append("FSourceBillID,FSourceBillEntryID,FCostObjectID,FCostItemID,FAllocStdID,").append("FAllocStdData,FQty,FCommonQty,FAssistQty,FAmount,FPrice,FMaterialID,FLot,FBizDate,FSeq, FCreatorID,FCreateTime,FAdjustUserID,FAdjustTime,FIsDirect, AllocBillType, FWareHouseID, FAdminOrgUnitID, fIsRework )").append('\n').append("SELECT newbosid(''ADC37CB3'') AS FID, ''{1}'' As FCompanyID, ''{2}'' As FCalculatePeriodID,\"costCenterOrgUnit.id\" As FCostCenterID,").append('\n').append("\"ID\" As FSourceBillID,\"ENTRY.ID\" As FSourceBillEntryID, \"COSTOBJECT.ID\" As FCostObjectID, \"COSTITEM.id\" As FCostItemID, null As FAllocStdID,").append("1 As FAllocStdData, \"entry.baseQty\" As FQty,\"ENTRY.QTY\" as FCommonQty,\"ENTRY.ASSISTQTY\" as FAssistQty, \"entry.actualCost\" As FAmount, ROUND(to_decimal(\"entry.actualCost\",24,12) / to_decimal(\"entry.baseQty\",24,12), \"material.pricePrecision\") As FPrice, ").append('\n').append("\"MATERIAL.ID\" As FMaterialId, \"ENTRY.LOT\" As FLot, \"BIZDATE\" As FBizDate, \"ENTRY.SEQ\" As FSeq, ").append('\n').append("''{3}'' As FCreatorID, GetDate() As FCreateTime, ''{4}'' as FAdjustUserID, GetDate() as FAdjustTime, 1 As FIsDirect, ''{5}'' as AllocBillType ").append('\n');
        if (sqlDirectFee.indexOf("T_IM_MaterialReqBillEntry") > 0) {
            sb.append(",FWareHouseID, FAdminOrgUnitID , \"entry.FIsRework\" As FIsRework").append('\n');
        } else {
            sb.append(", 0 As FIsRework");
        }
        sb.append("FROM ( {6} ) S ").append('\n').append("Where \"entry.baseQty\" <> 0 ");
        String sqlInsert = MessageFormat.format(sb.toString(), this.getTblResult(), companyId, periodId, userId, this.GetAdjustUserId(), "MF", sqlDirectFee);
        try {
            NCMDbUtil.execute((Context)ctx, (String)sqlInsert);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
    }

    @Override
    protected Boolean isAssistantCostCenterReqFee(IFeeInfo currFee) {
        int costCenterType = currFee.getCostCenterType();
        return costCenterType == 1 ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    protected String GetSql_InsertIndirectData(String companyId, String periodId, String userId, String allocStdId, IFeeInfo currFee) throws AllocateException {
        Assert.that((boolean)(currFee instanceof IMatFeeInfo));
        IMatFeeInfo fee = (IMatFeeInfo)currFee;
        NumberFormat fm = NumberFormat.getInstance();
        fm.setGroupingUsed(false);
        fm.setMaximumFractionDigits(fee.GetQtyPrecision());
        String strQty = fm.format(fee.GetQty());
        fm.setMaximumFractionDigits(fee.GetCommonQtyPrecision());
        String strCommonQty = fm.format(fee.GetCommonQty());
        fm.setMaximumFractionDigits(fee.GetAssistQtyPrecision());
        String strAssistQty = fm.format(fee.GetAssistQty());
        fm.setMaximumFractionDigits(fee.GetAmountPrecision());
        String strAmount = fm.format(fee.GetAmount());
        fm.setMaximumFractionDigits(fee.GetPricePrecision());
        String strPrice = fm.format(BigDecimal.valueOf(0L));
        if (!fm.format(currFee.GetQty()).equals(BigDecimal.valueOf(0L).toString())) {
            strPrice = fm.format(fee.GetAmount().divide(fee.GetQty(), fee.GetPricePrecision(), 4));
        }
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO {0}(FID,FCompanyID,FCalculatePeriodID,FCostCenterID,").append('\n').append("FSourceBillID,FSourceBillEntryID,FCostObjectID,FCostItemID,FAllocStdID,").append('\n').append("FAllocStdData,FQty,FCommonQty,FAssistQty,FAmount,FPrice,FMaterialID,FLot,FBizDate,FSeq,FCreatorID,FCreateTime,FAdjustUserID,FAdjustTime,FIsDirect, AllocBillType )").append('\n').append("SELECT newbosid(''ADC37CB3'') AS FID, ''{1}'' As FCompanyID, ''{2}'' As FCalculatePeriodID,R.FCostCenterID,").append('\n').append("''{3}'' As FSourceBillID,''{4}'' As FSourceBillEntryID, R.FCostObjectID, {5} As FCostItemID, ''{6}'' As FAllocStdID,").append('\n').append("D.FQty As FAllocStdData, ROUND({7} * D.FRatio,{8})As FQty, ROUND({21} * D.FRatio,{22})As FCommonQty, ROUND({23} * D.FRatio,{24})As FAssistQty, ROUND({9} * D.FRatio,{10})As FAmount, {11} As FPrice, ").append('\n').append("''{12}'' As FMaterialID,{13} As FLot, TO_Date(''{14}'') As FBizDate, {15} As FSeq, ").append('\n').append("''{16}'' As FCreatorID, GetDate() As FCreateTime, ''{17}'' as FAdjustUserID, GetDate() as FAdjustTime,0 As FIsDirect , ''{18}'' as AllocBillType ").append('\n').append("FROM {19} R ").append('\n').append("INNER JOIN {20} D ON D.FID=R.FID ").append('\n').append("WHERE R.FIsValid =1 ");
        if (this.IsOnlyNotZero_AllcoStdData()) {
            sb.append(" AND D.FRatio <>0 ");
        }
        sb.append(";");
        String costItemId = fee.GetCostItemId();
        costItemId = costItemId != null && costItemId.length() > 0 ? "'" + costItemId + "'" : null;
        String lot = fee.GetLot();
        if (lot != null) {
            lot = "'" + lot + "'";
        }
        String sqlInsert = MessageFormat.format(sb.toString(), this.getTblResult(), companyId, periodId, fee.GetId(), fee.GetEntryId(), costItemId, this.getAllocStd().getId().toString(), strQty, String.valueOf(fee.GetQtyPrecision()), strAmount, String.valueOf(fee.GetAmountPrecision()), strPrice, fee.GetMaterialId(), lot, fee.GetBizDate(), String.valueOf(fee.GetSeq()), userId, this.GetAdjustUserId(), this.getAllocBillType(), this.getTblAllocObjectRange(), this.getTblAllocData(), strCommonQty, String.valueOf(fee.GetCommonQtyPrecision()), strAssistQty, String.valueOf(fee.GetAssistQtyPrecision()));
        return sqlInsert;
    }

    protected String getAllocBillType() {
        return "MF";
    }

    @Override
    protected String GetSql_AdjustDiff(IFeeInfo currFee) throws AllocateException {
        Assert.that((boolean)(currFee instanceof IMatFeeInfo));
        IMatFeeInfo fee = (IMatFeeInfo)currFee;
        NumberFormat fm = NumberFormat.getInstance();
        fm.setGroupingUsed(false);
        fm.setMaximumFractionDigits(fee.GetQtyPrecision());
        String strQty = fm.format(fee.GetQty());
        fm.setMaximumFractionDigits(fee.GetCommonQtyPrecision());
        String strCommonQty = fm.format(fee.GetCommonQty());
        fm.setMaximumFractionDigits(fee.GetAssistQtyPrecision());
        String strAssistQty = fm.format(fee.GetAssistQty());
        fm.setMaximumFractionDigits(fee.GetAmountPrecision());
        String strAmount = fm.format(fee.GetAmount());
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE {0} SET FQty=(FQty + {1} - ").append('\n').append("\t(SELECT ISNULL(SUM(S.FQty),0.00) ").append('\n').append("\tFROM {2} S").append('\n').append("\tWHERE S.FSourceBillID=''{3}'' AND S.FSourceBillEntryID=''{4}'')").append('\n').append(")").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom {5} ").append('\n').append("\tWHERE FSourceBillID=''{6}'' AND FSourceBillEntryID=''{7}'' ").append('\n').append("\tORDER BY FAllocStdData DESC ").append('\n').append(");");
        String sqlAdjustQty = MessageFormat.format(sb.toString(), this.getTblResult(), strQty, this.getTblResult(), fee.GetId(), fee.GetEntryId(), this.getTblResult(), fee.GetId(), fee.GetEntryId());
        sb.delete(0, sb.length());
        sb.append("UPDATE {0} SET FAmount=(FAmount + {1} - ").append('\n').append("\t(SELECT ISNULL(SUM(S.FAmount),0.00) ").append('\n').append("\tFROM {2} S").append('\n').append("\tWHERE S.FSourceBillID=''{3}'' AND S.FSourceBillEntryID=''{4}'')").append('\n').append(")").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom {5} ").append('\n').append("\tWHERE FSourceBillID=''{6}'' AND FSourceBillEntryID=''{7}'' ").append('\n').append("\tORDER BY FAllocStdData DESC ").append('\n').append(");");
        String sqlAdjustAmount = MessageFormat.format(sb.toString(), this.getTblResult(), strAmount, this.getTblResult(), fee.GetId(), fee.GetEntryId(), this.getTblResult(), fee.GetId(), fee.GetEntryId());
        String sqlUpdatePrice_Zero = MessageFormat.format("UPDATE {0} SET FPrice=0 WHERE FSourceBillID=''{1}'' AND FSourceBillEntryID=''{2}'' AND FQty=0 ;", this.getTblResult(), fee.GetId(), fee.GetEntryId());
        sb.delete(0, sb.length());
        sb.append("UPDATE {0} SET FCommonQty=(FCommonQty + {1} - ").append('\n').append("\t(SELECT ISNULL(SUM(S.FCommonQty),0.00) ").append('\n').append("\tFROM {2} S").append('\n').append("\tWHERE S.FSourceBillID=''{3}'' AND S.FSourceBillEntryID=''{4}'')").append('\n').append(")").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom {5} ").append('\n').append("\tWHERE FSourceBillID=''{6}'' AND FSourceBillEntryID=''{7}'' ").append('\n').append("\tORDER BY FAllocStdData DESC ").append('\n').append(");");
        String sqlAdjustCommonQty = MessageFormat.format(sb.toString(), this.getTblResult(), strCommonQty, this.getTblResult(), fee.GetId(), fee.GetEntryId(), this.getTblResult(), fee.GetId(), fee.GetEntryId());
        sb.delete(0, sb.length());
        sb.append("UPDATE {0} SET FAssistQty=(FAssistQty + {1} - ").append('\n').append("\t(SELECT ISNULL(SUM(S.FAssistQty),0.00) ").append('\n').append("\tFROM {2} S").append('\n').append("\tWHERE S.FSourceBillID=''{3}'' AND S.FSourceBillEntryID=''{4}'')").append('\n').append(")").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom {5} ").append('\n').append("\tWHERE FSourceBillID=''{6}'' AND FSourceBillEntryID=''{7}'' ").append('\n').append("\tORDER BY FAllocStdData DESC ").append('\n').append(");");
        String sqlAdjustAssistQty = MessageFormat.format(sb.toString(), this.getTblResult(), strAssistQty, this.getTblResult(), fee.GetId(), fee.GetEntryId(), this.getTblResult(), fee.GetId(), fee.GetEntryId());
        return sqlAdjustQty + '\n' + sqlAdjustAmount + '\n' + sqlUpdatePrice_Zero + '\n' + sqlAdjustCommonQty + '\n' + sqlAdjustAssistQty;
    }

    @Override
    protected void updateDefaultCostItem(Context ctx, String companyId, String periodId) throws AllocateException {
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE " + this.getTblResult() + " SET FCostItemID = ( \n").append("\tSELECT MC.FDefaultCostItemID \n").append("\tFROM T_BD_MaterialCost MC \n").append("\tWHERE MC.FOrgUnit='" + companyId + "' \n").append("\tand MC.FMaterialID = " + this.getTblResult() + ".FMaterialID \n").append("\tand MC.FStatus=1  \n").append(") \n").append("WHERE FCostItemID IS NULL;");
        sb.append('\n');
        sb.append("UPDATE " + this.getTblResult() + " SET FCostItemID = ( \n").append("\tSELECT E.FCostItemID \n").append("\tFROM T_NCM_ExpenseCompanyInfo E \n").append("\twhere E.FCompanyOrgUnitID='" + companyId + "' \n").append("\tand E.FExpenseID='ml7t5QEaEADgAAwawKgRe0olWCc=' \n").append(") \n").append("WHERE FCostItemID IS NULL ;");
        try {
            NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
    }

    @Override
    protected void removeNoCostItem(Context ctx, String companyId, String periodId) throws AllocateException {
        StringBuffer sb = new StringBuffer();
        try {
            if (this.setPhsicalTblBill().equalsIgnoreCase("T_IM_MaterialReqBill")) {
                CostDataCache costDataCache = (CostDataCache)this._param.get("CostDataCache");
                String T_TMP_MatReq = costDataCache.getMatReqTable();
                sb.append("SELECT top 100 t.FNumber, t.FSeq ").append("FROM " + this.getTblResult() + " D ").append("INNER JOIN " + T_TMP_MatReq + " t ON t.FSourceBillEntryID = D.FSourceBillEntryID ").append("WHERE D.FCostItemID IS NULL");
            } else {
                sb.append("SELECT top 100 MB.FNumber, ME.FSeq ").append("FROM " + this.getTblResult() + " D ").append("INNER JOIN ").append(this.setPhsicalTblEntry()).append(" ME ON ME.FID=D.FSourceBillEntryID ").append("INNER JOIN ").append(this.setPhsicalTblBill()).append(" MB ON MB.FID = ME.FParentID and MB.FID=D.FSourceBillID ").append("WHERE D.FCostItemID IS NULL");
            }
            IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sb.toString());
            rs.first();
            if (rs.getRow() > 0) {
                sb.delete(0, sb.length());
                if (this.setPhsicalTblBill().equalsIgnoreCase("T_IM_MaterialReqBill")) {
                    sb.append("UPDATE T_IM_MaterialReqBillEntry as d ").append('\n').append("   Set FIsAdmeasure=0 ").append('\n').append(" where exists(").append('\n').append("       select 1 from " + this.getTblResult() + " S ").append('\n').append("\t\tWHERE S.FCostItemID IS NULL").append("       \tand S.Fsourcebillid=d.FParentId and S.FSourceBillEntryID = d.FID ").append('\n').append("       )").append('\n').append("   and d.FIsAdmeasure=1 ").append('\n').append(";").append('\n');
                }
                sb.append("DELETE from " + this.getTblResult() + " ");
                sb.append("WHERE FCostItemID IS NULL;");
                NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sb.toString());
            }
            rs.first();
            while (rs.getRow() > 0 && !rs.isAfterLast()) {
                String number = rs.getString("FNumber");
                String seq = String.valueOf(rs.getInt("FSeq"));
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_NODEFAULT_COSTITEM_MAT, new Object[]{number, seq}), null, null);
                rs.next();
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e), null, null);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
    }

    protected String setPhsicalTblBill() {
        return "T_IM_MaterialReqBill";
    }

    protected String setPhsicalTblEntry() {
        return "T_IM_MaterialReqBillEntry";
    }

    protected String setFCostCenterOrgUnitID() {
        return "FCostCenterOrgUnitID";
    }

    protected String buildInvalidCostObjectSql(String companyId, String periodId) throws AllocateException {
        StringBuffer sb = new StringBuffer();
        String tblObjRange = this.getAllocTable().GetObjectRangeTable();
        sb.append("SELECT top 100 MB.FNumber, ME.FSeq, ").append('\n');
        sb.append("    CO.FName_L2 As FCostObjectName, D.FID AS inValidId, CC.FCostCenterType FCostCenterType ").append('\n');
        sb.append("FROM " + this.getTblResult() + " D ").append('\n');
        sb.append("INNER JOIN ").append(this.setPhsicalTblEntry()).append(" ME ON ME.FID=D.FSourceBillEntryID ").append('\n');
        sb.append("INNER JOIN ").append(this.setPhsicalTblBill()).append(" MB ON MB.FID=D.FSourceBillID ").append('\n');
        sb.append("INNER JOIN t_bd_CostObject CO ON CO.FID=D.FCostObjectID ").append('\n');
        if ("OtherInWarehs".equals(this._param.get("matType")) || "CostAdjust".equals(this._param.get("matType"))) {
            sb.append("INNER JOIN T_ORG_CostCenter CC ON MB.").append(this.setFCostCenterOrgUnitID()).append("=CC.FID ").append('\n');
        } else {
            sb.append("INNER JOIN T_ORG_CostCenter CC ON ME.").append(this.setFCostCenterOrgUnitID()).append("=CC.FID ").append('\n');
        }
        sb.append("left join " + tblObjRange + " S on s.fcostcenterid=d.fcostcenterid and s.fcostobjectid=d.fcostobjectid ").append('\n');
        sb.append("WHERE D.FCompanyID='" + companyId + "' AND D.FCalculatePeriodID='" + periodId + "' ").append('\n');
        sb.append(" and CC.FCostCenterType in (0, 1) ").append('\n');
        sb.append(" and ME.fcompanyorgunitid='" + companyId + "' ").append('\n');
        sb.append(" and S.FID is null ").append('\n');
        sb.append(" and D.FAllocStdID is not null ").append('\n');
        return sb.toString();
    }

    @Override
    protected void removeInvalidCostObject(Context ctx, String companyId, String periodId) throws AllocateException {
        if (ctx != null) {
            return;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void fillAllocTempData() throws AllocateException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getTblMatRate(Map param) throws BOSException {
        Context ctx = (Context)this._param.get("ctx");
        String companyId = this._param.get("companyId").toString();
        IBOMSearchFacade bomControl = BOMSearchFacadeFactory.getLocalInstance((Context)ctx);
        return bomControl.getBackBOM(companyId, this.T_TMP_MaterialDate);
    }

    protected String getCostObjectIds() throws EASBizException, BOSException, SQLException {
        StringBuffer sb = new StringBuffer();
        Context ctx = (Context)this._param.get("ctx");
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        String tblBalance = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_Balance");
        sb.append("\tSELECT DISTINCT E.FCostObjectID ").append('\n').append("\tFROM T_NCM_InputQtyBill B ").append('\n').append("\tRIGHT OUTER JOIN T_NCM_InputQtyBillEntry E ON B.FID = E.FParentID ").append('\n').append("\tWHERE B.FBillStatus=4 AND B.FCompanyOrg = '").append(companyId).append("' AND B.FCalculatePeriod ='").append(periodId).append("' ").append('\n').append("\tUNION ").append('\n').append("\tSELECT DISTINCT BB.FCostObjectID ").append('\n').append("\tFROM ").append(tblBalance).append(" BB ").append('\n').append("\tWHERE BB.FCompanyOrg = '").append(companyId).append("' AND BB.FCalculatePeriodID = '").append(periodId).append("' ").append('\n');
        return sb.toString();
    }

    protected Map getMaterialList() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        FeeData iFee = this.GetFeeDataControl();
        String sqlIndirectFee = iFee.GetIndirectFeeDataSql();
        HashMap<String, String> ret = new HashMap<String, String>();
        StringBuffer sb = new StringBuffer();
        sb.append("create table T ( \n");
        sb.append("     FMaterialID varchar(44), \n");
        sb.append("     FBizDate DateTime \n");
        sb.append(") \n");
        try {
            this.T_TMP_MaterialDate = TempTablePool.getInstance((Context)ctx).createTempTable(sb.toString());
            sb.setLength(0);
            sb.append("insert into " + this.T_TMP_MaterialDate + " (FMaterialID, FBizDate) ");
            sb.append("SELECT distinct \"MATERIAL.ID\" As FMaterialId, \"BIZDATE\" As FBizDate ").append('\n').append("FROM ( ").append(sqlIndirectFee).append(" ) S ").append('\n').append("WHERE ").append('\n').append("  EXISTS(").append('\n').append("\t\tSELECT 1").append('\n').append("\t\tFROM T_NCM_AllocStdSetByPrd Prd").append('\n').append("\t\tINNER JOIN T_NCM_AllocStd STD ON STD.FID=Prd.FAllocStdID").append("\t\tWHERE Prd.FExpenseID='").append("ml7t5QEaEADgAAwawKgRe0olWCc=").append("' ").append('\n');
            if (this._param.get("allocenum").equals(AllocStdSetModeByPrdEnum.SetByCC)) {
                sb.append(" AND Prd.FCostCenterID=\"costCenterOrgUnit.id\" ").append('\n');
            }
            sb.append("\t\t\tAND Prd.FCompanyId='").append(companyId).append("' AND Prd.FCalculatePeriodId='").append(periodId).append("'").append('\n').append("           AND Prd.FCostType = 1 ").append('\n').append("\t\t\tAND STD.FFormulaForParse like '%").append("d2T+lgEaEADgAAmCwKgRj53UGuM=").append("%'").append('\n').append("  )").append('\n');
            NCMDbUtil.execute((Context)ctx, (String)sb.toString());
            sb.setLength(0);
            sb.append("select FMaterialID, FBizDate from " + this.T_TMP_MaterialDate + " ");
            IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sb.toString());
            rs.first();
            while (rs.getRow() > 0 && !rs.isAfterLast()) {
                ret.put(rs.getString("FMaterialID"), rs.getString("FBizDate"));
                rs.next();
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e), null, null);
        }
        return ret;
    }

    @Override
    protected boolean filterAllocTempDataRange(IFeeInfo currFee) throws AllocateException {
        this.bMaterialChanged = false;
        Boolean isAssistant = this.isAssistantCostCenterReqFee(currFee);
        if (isAssistant != null && isAssistant.booleanValue()) {
            return false;
        }
        if (this.MaterialList == null || this.MaterialList.size() <= 0) {
            return false;
        }
        Assert.that((boolean)(currFee instanceof IMatFeeInfo));
        IMatFeeInfo fee = (IMatFeeInfo)currFee;
        if (!this.MaterialList.containsKey(fee.GetMaterialId())) {
            return false;
        }
        if (!(this.lastMaterialID == null && fee.GetMaterialId() == null || this.lastMaterialID != null && this.lastMaterialID.equals(fee.GetMaterialId()))) {
            StringBuffer sb = new StringBuffer();
            sb.append("UPDATE ").append(this.getAllocTable().GetMaterialRateDataTable()).append(" SET FIsValid=0;").append('\n').append("UPDATE ").append(this.getAllocTable().GetMaterialRateDataTable()).append(" SET FIsValid=1 ").append('\n').append("WHERE FMaterialID='").append(fee.GetMaterialId()).append("';").append('\n');
            sb.append(" truncate table ").append(this.getAllocTable().GetValidMaterialRateDataTable()).append("; \n");
            sb.append(" insert into ").append(this.getAllocTable().GetValidMaterialRateDataTable()).append('\n');
            sb.append(" (FCostObjectID,FBomID,FMaterialID,FRate,FEffectiveDate,FDisableDate,FIsValid)").append('\n');
            sb.append(" select FCostObjectID,FBomID,FMaterialID,FRate,FEffectiveDate,FDisableDate,FIsValid").append('\n');
            sb.append(" From ").append(this.getAllocTable().GetMaterialRateDataTable()).append('\n');
            sb.append(" where FIsValid = 1 ;").append('\n');
            sb.append(" truncate table ").append(this.getAllocTable().GetValidObjectRangeTable()).append("; \n");
            sb.append("insert into ").append(this.getAllocTable().GetValidObjectRangeTable()).append(" \n");
            sb.append(" (FID,FCostCenterID,FCostObjectID,FMaterialID,FCostItemID,FIsValid) \n");
            sb.append(" select FID,FCostCenterID,FCostObjectID,FMaterialID,FCostItemID,FIsValid \n");
            sb.append(" From ").append(this.getAllocTable().GetObjectRangeTable()).append(" co \n");
            sb.append(" where FIsValid = 1 \n");
            sb.append(" and exists (select 1 from ").append(this.getAllocTable().GetValidMaterialRateDataTable()).append(" rat ").append('\n');
            sb.append(" where co.FCostobjectID = rat.FCostobjectID); ").append('\n');
            try {
                NCMDbUtil.BatchSqlExecute((Context)((Context)this._param.get("ctx")), (String)sb.toString(), (String)";");
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
                return true;
            }
            this.lastMaterialID = fee.GetMaterialId();
            this.bMaterialChanged = true;
        }
        return false;
    }

    @Override
    protected boolean IsOnlyNotZero_AllcoStdData() {
        return true;
    }

    @Override
    public void commitAllocResult(boolean isLastBatch) throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        Context ctx = (Context)this._param.get("ctx");
        if (isLastBatch) {
            this.updateDefaultCostItem(ctx, companyId, periodId);
            this.removeNoCostItem(ctx, companyId, periodId);
        }
    }

    @Override
    protected void processQtyBeforeCalRate() throws AllocateException, BOSException {
        Context ctx = (Context)this._param.get("ctx");
        String currFeeMaterialId = (String)this._param.get("currFeeMaterialId");
        if (currFeeMaterialId == null || currFeeMaterialId.length() == 0) {
            return;
        }
        StringBuffer ksql = new StringBuffer();
        CostDataCache costDataCache = (CostDataCache)this._param.get("CostDataCache");
        String T_TMP_WIPCountMaterial = costDataCache.getWIPCountMaterial();
        String tblValidObjectRange = this.getAllocTable().GetValidObjectRangeTable();
        ksql.append("select top 1 FQty \n");
        ksql.append("from " + this.getTblAllocData() + " \n");
        ksql.append("where FQty <> 0 ");
        IRowSet rs = null;
        try {
            rs = NCMDbUtil.executeQuery((Context)ctx, (String)ksql.toString());
            if (!rs.next()) {
                ksql.setLength(0);
                ksql.append("update " + this.getTblAllocData() + " set FQty = isnull(( \n");
                ksql.append("    select wip.FQty \n");
                ksql.append("    from " + tblValidObjectRange + " range \n");
                ksql.append("    join " + T_TMP_WIPCountMaterial + " wip \n");
                ksql.append("        on wip.FCostCenterID = range.FCostCenterID \n");
                ksql.append("        and wip.FCostObjectID = range.FCostObjectID \n");
                ksql.append("        and wip.FMaterialID = '" + currFeeMaterialId + "' \n");
                ksql.append("    where range.FID = " + this.getTblAllocData() + ".FID \n");
                ksql.append("),0) \n");
                ksql.append("; \n");
                NCMDbUtil.BatchSqlExecute((Context)ctx, (String)ksql.toString(), (String)";");
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)"", (Throwable)e);
                throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
    }

    @Override
    protected boolean crossCostObjectSuiteRange(IFeeInfo currFee) throws AllocateException {
        boolean cancelAlloc = super.crossCostObjectSuiteRange(currFee);
        if (cancelAlloc) {
            this.updateFeeDataFlagToUnallocatedWhenCanntAlloc(currFee);
        }
        return cancelAlloc;
    }

    @Override
    protected boolean checkNoAllocStdData(IFeeInfo currFee) throws AllocateException {
        boolean hasNoAllocStdData = super.checkNoAllocStdData(currFee);
        if (hasNoAllocStdData) {
            this.updateFeeDataFlagToUnallocatedWhenCanntAlloc(currFee);
        }
        return hasNoAllocStdData;
    }

    protected void updateFeeDataFlagToUnallocatedWhenCanntAlloc(IFeeInfo currFee) throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE T_IM_MaterialReqBillEntry as d ").append('\n').append("   Set FIsAdmeasure=0 ").append('\n').append(" where d.FID = '").append(currFee.GetEntryId()).append("'").append('\n').append(";").append('\n');
        try {
            NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
        }
        catch (BOSException e) {
            log.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
    }
}

