/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.AUSContext;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.BaseAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.FeeData;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.Info.FeeInfoAdapter;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.Info.IFeeInfo;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.OtherFeeData;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.AllocTable;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.OtherAllocTable;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class OtherAllocator
extends BaseAllocator {
    private static Logger logger = Logger.getLogger((String)OtherAllocator.class.getName());

    public OtherAllocator(Map param, AUSContext ausCtx) {
        super(param, ausCtx);
    }

    protected AllocTable setAllocTable(Map param) {
        return new OtherAllocTable(this._param);
    }

    @Override
    public AllocTable getAllocTable() throws AllocateException {
        if (super.getAllocTable() == null) {
            Context ctx = (Context)this._param.get("ctx");
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            this._param.put("pool", pool);
            this.setAllocTable(this.setAllocTable(this._param));
        }
        return super.getAllocTable();
    }

    @Override
    public FeeData GetFeeDataControl() throws AllocateException {
        if (this.getFeeData() == null) {
            this.setFeeData(new OtherFeeData(this._param));
        }
        return super.getFeeData();
    }

    @Override
    protected boolean hasDirectCostCenterReqFee() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        StringBuffer ksql = new StringBuffer();
        ksql.append("select top 1 \n");
        ksql.append("    1 \n");
        ksql.append("from " + this.getAllocTable().GetToAllocBillEntryIDTable() + " eids \n");
        ksql.append("join T_NCM_OtherFeeBillEntry e on e.FID = eids.FSourceBillEntryID \n");
        ksql.append("join T_NCM_OtherFeeBill b on b.FID = e.FParentID \n");
        ksql.append("join T_ORG_CostCenter cc on cc.FID = b.FCostCenterID \n");
        ksql.append("where cc.FCostCenterType = 0 \n");
        try {
            IRowSet rowSet = NCMDbUtil.executeQuery((Context)ctx, (String)ksql.toString());
            boolean result = rowSet.next();
            rowSet.close();
            return result;
        }
        catch (Exception e) {
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
            return false;
        }
    }

    @Override
    protected boolean hasAssistantCostCenterReqFee() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        StringBuffer ksql = new StringBuffer();
        ksql.append("select top 1 \n");
        ksql.append("    1 \n");
        ksql.append("from " + this.getAllocTable().GetToAllocBillEntryIDTable() + " eids \n");
        ksql.append("join T_NCM_OtherFeeBillEntry e on e.FID = eids.FSourceBillEntryID \n");
        ksql.append("join T_NCM_OtherFeeBill b on b.FID = e.FParentID \n");
        ksql.append("join T_ORG_CostCenter cc on cc.FID = b.FCostCenterID \n");
        ksql.append("where cc.FCostCenterType = 1 \n");
        try {
            IRowSet rowSet = NCMDbUtil.executeQuery((Context)ctx, (String)ksql.toString());
            boolean result = rowSet.next();
            rowSet.close();
            return result;
        }
        catch (Exception e) {
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
            return false;
        }
    }

    @Override
    protected void InsertDirectData(Context ctx, String companyId, String periodId, String userId) throws AllocateException {
        FeeData iFee = this.GetFeeDataControl();
        String sqlDirectFee = iFee.GetDirectFeeDataSql();
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO {0}(FID,FCompanyID,FCalculatePeriodID,FCostCenterID,FdepartmentID,FSourceCostCenterID,").append("FSourceBillID,FSourceBillEntryID,FCostObjectID,FCostItemID,FAllocStdID,").append("FAllocStdData,FQty,FPrice,FAmount,FCreatorID,FCreateTime,FAdjustUserID,FAdjustTime,FIsDirect)").append('\n').append("SELECT newbosid(''BCAAC063'') AS FID, ''{1}'' As FCompanyID, ''{2}'' As FCalculatePeriodID,\"costCenter.id\" As FCostCenterID, \"DEPARTMENT.ID\" as FdepartmentID, \"SOURCECOSTCENTER.ID\" as FSourceCostCenterID ,").append('\n').append("\"ID\" As FSourceBillID,\"ENTRIES.ID\" As FSourceBillEntryID, \"COSTOBJECT.ID\" As FCostObjectID, \"COSTITEM.ID\" As FCostItemID, null As FAllocStdID,").append('\n').append("1 As FAllocStdData, ISNULL(\"ENTRIES.QTY\",0) As FQty,ISNULL(\"ENTRIES.PRICE\",0) As FPrice,\"ENTRIES.AMOUNT\" As FAmount, ").append('\n').append("''{3}'' As FCreatorID, GetDate() As FCreateTime, ''{4}'' as FAdjustUserID, GetDate() as FAdjustTime, 1 As FIsDirect ").append('\n').append("FROM ( {5} ) S ").append('\n');
        String sqlInsert = MessageFormat.format(sb.toString(), this.getTblResult(), companyId, periodId, userId, this.GetAdjustUserId(), sqlDirectFee);
        try {
            NCMDbUtil.execute((Context)ctx, (String)sqlInsert);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
    }

    @Override
    protected Boolean isAssistantCostCenterReqFee(IFeeInfo currFee) {
        int costCenterType = currFee.getCostCenterType();
        return costCenterType == 1 ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    protected String GetSql_InsertIndirectData(String companyId, String periodId, String userId, String allocStdId, IFeeInfo currFee) throws AllocateException {
        StringBuffer sb = new StringBuffer();
        NumberFormat fm = NumberFormat.getInstance();
        fm.setGroupingUsed(false);
        fm.setMaximumFractionDigits(currFee.GetQtyPrecision());
        String strQty = fm.format(currFee.GetQty());
        fm.setMaximumFractionDigits(currFee.GetAmountPrecision());
        String strAmount = fm.format(currFee.GetAmount());
        fm.setMaximumFractionDigits(currFee.GetPricePrecision());
        String strPrice = fm.format(BigDecimal.valueOf(0L));
        if (!fm.format(currFee.GetQty()).equals(BigDecimal.valueOf(0L).toString())) {
            strPrice = fm.format(currFee.GetAmount().divide(currFee.GetQty(), currFee.GetPricePrecision(), 4));
        }
        sb.append("INSERT INTO {0}(FID,FCompanyID,FCalculatePeriodID,FCostCenterID,").append('\n').append("FDepartmentID,FSourceCostCenterID,").append('\n').append("FSourceBillID,FSourceBillEntryID,FCostObjectID,FCostItemID,FAllocStdID,").append('\n').append("FAllocStdData,FQty,FPrice,FAmount,FCreatorID,FCreateTime,FAdjustUserID,FAdjustTime,FIsDirect)").append('\n').append("SELECT newbosid(''BCAAC063'') AS FID, ''{1}'' As FCompanyID, ''{2}'' As FCalculatePeriodID,R.FCostCenterID,").append('\n').append("''{3}'' As FDepartmentID,''{17}'' AS FSourceCostCenterID, ").append('\n').append("''{4}'' As FSourceBillID,''{5}'' As FSourceBillEntryID, R.FCostObjectID, {6} As FCostItemID, ''{7}'' As FAllocStdID,").append('\n').append("D.FQty As FAllocStdData, ROUND({8} * D.FRatio,{9})As FQty,{10} As FPrice, ROUND({11} * D.FRatio,{12})As FAmount,").append('\n').append("''{13}'' As FCreatorID, GetDate() As FCreateTime, ''{14}'' as FAdjustUserID, GetDate() as FAdjustTime, 0 As FIsDirect ").append('\n').append("FROM {15} R ").append('\n').append("INNER JOIN {16} D ON D.FID=R.FID ").append('\n').append("WHERE R.FIsValid =1 ");
        if (this.IsOnlyNotZero_AllcoStdData()) {
            sb.append(" AND D.FRatio <>0 ");
        }
        sb.append(";");
        String costItemId = currFee.GetCostItemId();
        if (costItemId != null) {
            costItemId = "'" + costItemId + "'";
        }
        String sqlInsert = MessageFormat.format(sb.toString(), this.getTblResult(), companyId, periodId, StringUtils.cnulls((String)((FeeInfoAdapter)currFee).GetDepartmentId()), currFee.GetId(), currFee.GetEntryId(), costItemId, this.getAllocStd().getId().toString(), strQty, String.valueOf(currFee.GetQtyPrecision()), strPrice, strAmount, String.valueOf(currFee.GetAmountPrecision()), userId, this.GetAdjustUserId(), this.getTblAllocObjectRange(), this.getTblAllocData(), StringUtils.cnulls((String)((FeeInfoAdapter)currFee).GetSourceCostCenterId()));
        return sqlInsert;
    }

    @Override
    protected String GetSql_AdjustDiff(IFeeInfo currFee) throws AllocateException {
        NumberFormat fm = NumberFormat.getInstance();
        fm.setGroupingUsed(false);
        fm.setMaximumFractionDigits(currFee.GetQtyPrecision());
        String strQty = fm.format(currFee.GetQty());
        fm.setMaximumFractionDigits(currFee.GetAmountPrecision());
        String strAmount = fm.format(currFee.GetAmount());
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE {0} SET FQty=(FQty + {1} - ").append('\n').append("\t(SELECT ISNULL(SUM(S.FQty),0.00) ").append('\n').append("\tFROM {2} S").append('\n').append("\tWHERE S.FSourceBillID=''{3}'' AND S.FSourceBillEntryID=''{4}'')").append('\n').append(")").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom {5} ").append('\n').append("\tWHERE FSourceBillID=''{6}'' AND FSourceBillEntryID=''{7}'' ").append('\n').append("\tORDER BY FAllocStdData DESC ").append('\n').append(");");
        String sqlAdjustQty = MessageFormat.format(sb.toString(), this.getTblResult(), strQty, this.getTblResult(), currFee.GetId(), currFee.GetEntryId(), this.getTblResult(), currFee.GetId(), currFee.GetEntryId());
        sb.delete(0, sb.length());
        sb.append("UPDATE {0} SET FAmount=(FAmount + {1} - ").append('\n').append("\t(SELECT ISNULL(SUM(S.FAmount),0.00) ").append('\n').append("\tFROM {2} S").append('\n').append("\tWHERE S.FSourceBillID=''{3}'' AND S.FSourceBillEntryID=''{4}'')").append('\n').append(")").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom {5} ").append('\n').append("\tWHERE FSourceBillID=''{6}'' AND FSourceBillEntryID=''{7}'' ").append('\n').append("\tORDER BY FAllocStdData DESC ").append('\n').append(");");
        String sqlAdjustAmount = MessageFormat.format(sb.toString(), this.getTblResult(), strAmount, this.getTblResult(), currFee.GetId(), currFee.GetEntryId(), this.getTblResult(), currFee.GetId(), currFee.GetEntryId());
        sb.delete(0, sb.length());
        String sqlUpdatePrice_Zero = MessageFormat.format("UPDATE {0} SET FPrice=0 WHERE FSourceBillID=''{1}'' AND FSourceBillEntryID=''{2}'' AND FQty=0 ;", this.getTblResult(), currFee.GetId(), currFee.GetEntryId());
        return sqlAdjustQty + '\n' + sqlAdjustAmount + '\n' + '\n' + sqlUpdatePrice_Zero;
    }

    @Override
    protected void updateDefaultCostItem(Context ctx, String companyId, String periodId) throws AllocateException {
        StringBuffer sb = new StringBuffer();
        sb.delete(0, sb.length());
        sb.append("UPDATE " + this.getTblResult() + " SET FCostItemID = (").append('\n');
        sb.append("\t   SELECT E.FCostItemID").append('\n');
        sb.append("\t   FROM T_NCM_ExpenseCompanyInfo E").append('\n');
        sb.append("\t   INNER JOIN T_NCM_OtherFeeBillEntry OBE ON OBE.FExpenseID = E.FExpenseID").append('\n');
        sb.append("\t   where OBE.FID = " + this.getTblResult() + ".FSourceBillEntryID ").append('\n');
        sb.append("\t       AND E.FCompanyOrgUnitID='" + companyId + "' ").append('\n');
        sb.append(") ").append('\n');
        sb.append("WHERE FCostItemID IS NULL");
        try {
            NCMDbUtil.execute((Context)ctx, (String)sb.toString());
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
    }

    @Override
    protected void removeNoCostItem(Context ctx, String companyId, String periodId) throws AllocateException {
        StringBuffer sb = new StringBuffer();
        try {
            sb.delete(0, sb.length());
            sb.append("SELECT top 100 MB.FNumber, ME.FSeq ").append("FROM " + this.getTblResult() + " D ").append("INNER JOIN T_NCM_OtherFeeBillEntry ME ON ME.FID=D.FSourceBillEntryID ").append("INNER JOIN T_NCM_OtherFeeBill MB ON MB.FID=D.FSourceBillID ").append("WHERE D.FCostItemID IS NULL");
            IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sb.toString());
            rs.first();
            if (rs.getRow() > 0) {
                sb.delete(0, sb.length());
                sb.append("DELETE from " + this.getTblResult() + " ").append("WHERE FCostItemID IS NULL");
                NCMDbUtil.execute((Context)ctx, (String)sb.toString());
            }
            rs.first();
            while (rs.getRow() > 0 && !rs.isAfterLast()) {
                String number = rs.getString("FNumber");
                String seq = String.valueOf(rs.getInt("FSeq"));
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_NODEFAULT_COSTITEM_OTHER, new Object[]{number, seq}), null, null);
                rs.next();
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e), null, null);
        }
    }

    @Override
    protected void removeInvalidCostObject(Context ctx, String companyId, String periodId) throws AllocateException {
        String tblObjRange = this.getAllocTable().GetObjectRangeTable();
        StringBuffer sb = new StringBuffer();
        sb.delete(0, sb.length());
        sb.append("SELECT top 100 ").append('\n');
        sb.append("    MB.FNumber, ME.FSeq, ").append('\n');
        sb.append("    CO.FName_L2 FCostObjectName, CO.FNumber FCostObjectNumber, ").append('\n');
        sb.append("    CC.FCostCenterType FCostCenterType ").append('\n');
        sb.append("FROM " + this.getTblResult() + " D ").append('\n');
        sb.append("INNER JOIN T_NCM_OtherFeeBillEntry ME ON ME.FID=D.FSourceBillEntryID ").append('\n');
        sb.append("INNER JOIN T_NCM_OtherFeeBill MB ON MB.FID=D.FSourceBillID ").append('\n');
        sb.append("INNER JOIN t_bd_CostObject CO ON CO.FID=D.FCostObjectID ").append('\n');
        sb.append("INNER JOIN T_ORG_CostCenter CC ON MB.FCostCenterID=CC.FID ").append('\n');
        sb.append("WHERE CC.FCostCenterType in (0, 1) ").append('\n');
        sb.append("    AND NOT exists (").append('\n');
        sb.append("\t       SELECT FCostObjectID").append('\n');
        sb.append("\t       FROM " + tblObjRange + " S ").append('\n');
        sb.append("\t       Where S.Fcostcenterid = D.Fcostcenterid and S.FCostObjectID = D.Fcostobjectid ").append('\n');
        sb.append("    )");
        try {
            IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sb.toString());
            rs.first();
            if (rs.getRow() > 0) {
                sb.delete(0, sb.length());
                sb.append("DELETE from " + this.getTblResult() + " ");
                sb.append("WHERE NOT exists ( ").append('\n');
                sb.append("\t   SELECT FCostObjectID").append('\n');
                sb.append("\t   FROM " + tblObjRange + " S ").append('\n');
                sb.append("\t   Where S.Fcostcenterid = " + this.getTblResult() + ".Fcostcenterid ").append('\n');
                sb.append("\t       and S.FCostObjectID = " + this.getTblResult() + ".Fcostobjectid ").append('\n');
                sb.append(") ");
                NCMDbUtil.execute((Context)ctx, (String)sb.toString());
                NumericExceptionSubItem except = null;
                rs.first();
                while (rs.getRow() > 0 && !rs.isAfterLast()) {
                    String number = rs.getString("FNumber");
                    String seq = String.valueOf(rs.getInt("FSeq"));
                    String costObjNumber = rs.getString("FCostObjectNumber");
                    int costCenterType = rs.getInt("FCostCenterType");
                    except = costCenterType == 1 ? AllocateException.ITEM_ALLOC_INVALID_AUSCOSTOBJ : AllocateException.ITEM_ALLOC_INVALID_COSTOBJ;
                    this.processAllocateException(new AllocateException(except, new Object[]{number, seq, costObjNumber}), null, null);
                    rs.next();
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e), null, null);
        }
    }

    @Override
    protected boolean IsOnlyNotZero_AllcoStdData() {
        return true;
    }
}

