/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.AUSContext;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.FeeData;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.Info.IFeeInfo;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.OtherInWHFeeData;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.MatAllocator;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class OtherInWHAllocator
extends MatAllocator {
    private static Logger logger = Logger.getLogger((String)OtherInWHAllocator.class.getName());

    public OtherInWHAllocator(Map param, AUSContext ausCtx) {
        super(param, ausCtx);
    }

    @Override
    protected FeeData setFeeData(Map param) {
        return new OtherInWHFeeData(param);
    }

    @Override
    protected boolean hasDirectCostCenterReqFee() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        StringBuffer ksql = new StringBuffer();
        ksql.append("select top 1 \n");
        ksql.append("    1 \n");
        ksql.append("from " + this.getAllocTable().GetToAllocBillEntryIDTable() + " eids \n");
        ksql.append("join T_IM_OtherInWarehsBillEntry e on e.FID = eids.FSourceBillEntryID \n");
        ksql.append("join T_IM_OtherInWarehsBill b on b.FID = e.FParentID \n");
        ksql.append("join T_ORG_CostCenter cc on cc.FID = b.FCostCenterOrgUnitID \n");
        ksql.append("where cc.FCostCenterType = 0 \n");
        try {
            IRowSet rowSet = NCMDbUtil.executeQuery((Context)ctx, (String)ksql.toString());
            boolean result = rowSet.next();
            rowSet.close();
            return result;
        }
        catch (Exception e) {
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
            return false;
        }
    }

    @Override
    protected boolean hasAssistantCostCenterReqFee() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        StringBuffer ksql = new StringBuffer();
        ksql.append("select top 1 \n");
        ksql.append("    1 \n");
        ksql.append("from " + this.getAllocTable().GetToAllocBillEntryIDTable() + " eids \n");
        ksql.append("join T_IM_OtherInWarehsBillEntry e on e.FID = eids.FSourceBillEntryID \n");
        ksql.append("join T_IM_OtherInWarehsBill b on b.FID = e.FParentID \n");
        ksql.append("join T_ORG_CostCenter cc on cc.FID = b.FCostCenterOrgUnitID \n");
        ksql.append("where cc.FCostCenterType = 1 \n");
        try {
            IRowSet rowSet = NCMDbUtil.executeQuery((Context)ctx, (String)ksql.toString());
            boolean result = rowSet.next();
            rowSet.close();
            return result;
        }
        catch (Exception e) {
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
            return false;
        }
    }

    @Override
    protected void InsertDirectData(Context ctx, String companyId, String periodId, String userId) throws AllocateException {
        FeeData iFee = this.GetFeeDataControl();
        String sqlDirectFee = iFee.GetDirectFeeDataSql();
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO {0}(FID,FCompanyID,FCalculatePeriodID,FCostCenterID,").append("FSourceBillID,FSourceBillEntryID,FCostObjectID,FCostItemID,FAllocStdID,").append("FAllocStdData,FQty,FCommonQty,FAssistQty,FAmount,FPrice,FMaterialID,FLot,FBizDate,FSeq, FCreatorID,FCreateTime,FAdjustUserID,FAdjustTime,FIsDirect, AllocBillType )").append('\n').append("SELECT newbosid(''ADC37CB3'') AS FID, ''{1}'' As FCompanyID, ''{2}'' As FCalculatePeriodID,\"costCenterOrgUnit.id\" As FCostCenterID,").append('\n').append("\"ID\" As FSourceBillID,\"ENTRY.ID\" As FSourceBillEntryID, \"COSTOBJECT.ID\" As FCostObjectID, null As FCostItemID, null As FAllocStdID,").append("1 As FAllocStdData, (-1) * \"entry.baseQty\" As FQty,(-1) * \"entry.Qty\" As FCommonQty,(-1) * \"entry.AssistQty\" As FAssistQty,  (-1) * \"entry.actualCost\" As FAmount, (-1) * ROUND(to_decimal(\"entry.actualCost\",24,12) / to_decimal(\"entry.baseQty\",24,12), \"material.pricePrecision\") As FPrice, ").append('\n').append("\"MATERIAL.ID\" As FMaterialId, \"ENTRY.LOT\" As FLot, \"BIZDATE\" As FBizDate, \"ENTRY.SEQ\" As FSeq, ").append('\n').append("''{3}'' As FCreatorID, GetDate() As FCreateTime, ''{4}'' as FAdjustUserID, GetDate() as FAdjustTime, 1 As FIsDirect , ''{5}'' as AllocBillType ").append('\n').append("FROM ( {6} ) S ").append('\n').append("Where \"entry.baseQty\" <> 0 ");
        String sqlInsert = MessageFormat.format(sb.toString(), this.getTblResult(), companyId, periodId, userId, this.GetAdjustUserId(), "OI", sqlDirectFee);
        try {
            NCMDbUtil.execute((Context)ctx, (String)sqlInsert);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
    }

    @Override
    protected String getAllocBillType() {
        return "OI";
    }

    @Override
    protected String setPhsicalTblBill() {
        return "T_IM_OtherInWarehsBill";
    }

    @Override
    protected String setPhsicalTblEntry() {
        return "T_IM_OtherInWarehsBillEntry";
    }

    @Override
    protected String GetSql_AdjustDiff(IFeeInfo currFee) throws AllocateException {
        String sql_AdjustDiff = super.GetSql_AdjustDiff(currFee);
        String amendDataWithSign = this.amendDataWithSign(currFee);
        return sql_AdjustDiff + '\n' + amendDataWithSign;
    }

    private String amendDataWithSign(IFeeInfo currFee) throws AllocateException {
        String dataSign = "(" + Integer.valueOf(-1).toString() + ")";
        String amendDataWithSign = MessageFormat.format("UPDATE {0} SET FQty=FQty*{1} ,FCommonQty=FCommonQty*{1} ,FAssistQty=FAssistQty*{1} , FAmount=FAmount*{2} , FPrice=FPrice*{3}  WHERE FSourceBillID=''{4}'' AND FSourceBillEntryID=''{5}'';", this.getTblResult(), dataSign, dataSign, dataSign, currFee.GetId(), currFee.GetEntryId());
        return amendDataWithSign;
    }

    public void preAllocProcess() throws AllocateException {
    }

    public void endAllocProcess() throws AllocateException {
    }

    @Override
    protected void removeInvalidCostObject(Context ctx, String companyId, String periodId) throws AllocateException {
        String tblObjRange = this.getAllocTable().GetObjectRangeTable();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT top 100 MB.FNumber, ME.FSeq, CO.FName_L2 As FCostObjectName, D.FID AS inValidId, CO.FNumber As FCostObjectNumber, CC.FCostCenterType FCostCenterType ").append('\n').append("FROM {0} D ").append('\n').append("INNER JOIN ").append(this.setPhsicalTblEntry()).append(" ME ON ME.FID=D.FSourceBillEntryID ").append('\n').append("INNER JOIN ").append(this.setPhsicalTblBill()).append(" MB ON MB.FID=D.FSourceBillID ").append('\n').append("INNER JOIN t_bd_CostObject CO ON CO.FID=D.FCostObjectID ").append('\n');
        if ("OtherInWarehs".equals(this._param.get("matType")) || "CostAdjust".equals(this._param.get("matType"))) {
            sb.append("INNER JOIN T_ORG_CostCenter CC ON MB.").append(this.setFCostCenterOrgUnitID()).append("=CC.FID ").append('\n');
        } else {
            sb.append("INNER JOIN T_ORG_CostCenter CC ON ME.").append(this.setFCostCenterOrgUnitID()).append("=CC.FID ").append('\n');
        }
        sb.append(" left outer join {1} S on s.fcostcenterid=d.fcostcenterid and s.fcostobjectid=d.fcostobjectid ").append('\n').append("WHERE D.FCompanyID=''{2}'' AND D.FCalculatePeriodID=''{3}'' ").append('\n').append("  AND CC.FCostCenterType in (0, 1) ").append('\n').append(" and ME.fcompanyorgunitid=''{4}'' ").append('\n').append(" and S.FID is null ").append('\n');
        String sqlInvalidCostObject = MessageFormat.format(sb.toString(), this.getTblResult(), tblObjRange, companyId, periodId, companyId);
        sb.delete(0, sb.length());
        try {
            IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sqlInvalidCostObject);
            rs.first();
            if (rs.getRow() > 0) {
                StringBuffer inVaildIds = new StringBuffer();
                rs.first();
                while (rs.getRow() > 0 && !rs.isAfterLast()) {
                    if (inVaildIds.length() > 0) {
                        inVaildIds.append(",");
                    }
                    inVaildIds.append("'").append(rs.getString("inValidId")).append("'");
                    rs.next();
                }
                sb.append("DELETE ").append(this.getTblResult()).append(" WHERE FID in (").append(inVaildIds).append(")").append('\n');
                NCMDbUtil.execute((Context)ctx, (String)sb.toString());
                NumericExceptionSubItem except = null;
                rs.first();
                while (rs.getRow() > 0 && !rs.isAfterLast()) {
                    String number = rs.getString("FNumber");
                    String seq = String.valueOf(rs.getInt("FSeq"));
                    String costObjNumber = rs.getString("FCostObjectNumber");
                    int costCenterType = rs.getInt("FCostCenterType");
                    except = costCenterType == 1 ? AllocateException.ITEM_ALLOC_INVALID_AUSCOSTOBJ : AllocateException.ITEM_ALLOC_INVALID_COSTOBJ;
                    this.processAllocateException(new AllocateException(except, new Object[]{number, seq, costObjNumber}), null, null);
                    rs.next();
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e), null, null);
        }
    }

    @Override
    protected void updateDefaultCostItem(Context ctx, String companyId, String periodId) throws AllocateException {
        StringBuffer sb = new StringBuffer();
        sb.delete(0, sb.length());
        sb.append("UPDATE {0} SET (FCostItemID)=( \n").append("\tSELECT BE.FCostItemID \n").append("\tFrom ").append(this.setPhsicalTblEntry()).append(" BE \n").append("\tWHERE BE.FID={1}.FSourceBillEntryID \n").append("   AND {2}.FCostItemID IS NULL \n").append(") ; \n");
        String sqlUpdateCostItem_Bill = MessageFormat.format(sb.toString(), this.getTblResult(), this.getTblResult(), this.getTblResult());
        try {
            NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sqlUpdateCostItem_Bill, (String)";");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        super.updateDefaultCostItem(ctx, companyId, periodId);
    }
}

